--
-- PostgreSQL database dump
--

-- Dumped from database version 16.9 (Ubuntu 16.9-1.pgdg20.04+1)
-- Dumped by pg_dump version 16.9 (Ubuntu 16.9-1.pgdg24.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_cache_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_tests_models_char; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char IS 'Tests : Base Import Model, Character';


--
-- Name: COLUMN base_import_tests_models_char.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_id_seq OWNED BY public.base_import_tests_models_char.id;


--
-- Name: base_import_tests_models_char_noreadonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_noreadonly (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_noreadonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_noreadonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_noreadonly IS 'Tests : Base Import Model, Character No readonly';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq OWNED BY public.base_import_tests_models_char_noreadonly.id;


--
-- Name: base_import_tests_models_char_readonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_readonly (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_readonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_readonly IS 'Tests : Base Import Model, Character readonly';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_readonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_readonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_readonly_id_seq OWNED BY public.base_import_tests_models_char_readonly.id;


--
-- Name: base_import_tests_models_char_required; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_required (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_required OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_required IS 'Tests : Base Import Model, Character required';


--
-- Name: COLUMN base_import_tests_models_char_required.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_required.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_required.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_required.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_required.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_required_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_required_id_seq OWNED BY public.base_import_tests_models_char_required.id;


--
-- Name: base_import_tests_models_char_states; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_states (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_states OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_states; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_states IS 'Tests : Base Import Model, Character states';


--
-- Name: COLUMN base_import_tests_models_char_states.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_states.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_states.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_states.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_states.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_states_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_states_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_states_id_seq OWNED BY public.base_import_tests_models_char_states.id;


--
-- Name: base_import_tests_models_char_stillreadonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_stillreadonly (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_stillreadonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_stillreadonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_stillreadonly IS 'Tests : Base Import Model, Character still readonly';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq OWNED BY public.base_import_tests_models_char_stillreadonly.id;


--
-- Name: base_import_tests_models_complex; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_complex (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    c character varying,
    d date,
    m numeric,
    dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    f double precision
);


ALTER TABLE public.base_import_tests_models_complex OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_complex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_complex IS 'Tests: Base Import Model Complex';


--
-- Name: COLUMN base_import_tests_models_complex.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_complex.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_complex.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_complex.c; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.c IS 'C';


--
-- Name: COLUMN base_import_tests_models_complex.d; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.d IS 'D';


--
-- Name: COLUMN base_import_tests_models_complex.m; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.m IS 'M';


--
-- Name: COLUMN base_import_tests_models_complex.dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.dt IS 'Dt';


--
-- Name: COLUMN base_import_tests_models_complex.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_complex.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_tests_models_complex.f; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.f IS 'F';


--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_complex_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_complex_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_complex_id_seq OWNED BY public.base_import_tests_models_complex.id;


--
-- Name: base_import_tests_models_float; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_float (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    value2 numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value double precision
);


ALTER TABLE public.base_import_tests_models_float OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_float IS 'Tests: Base Import Model Float';


--
-- Name: COLUMN base_import_tests_models_float.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_float.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_float.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_float.value2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.value2 IS 'Value2';


--
-- Name: COLUMN base_import_tests_models_float.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_float.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_tests_models_float.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.value IS 'Value';


--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_float_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_float_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_float_id_seq OWNED BY public.base_import_tests_models_float.id;


--
-- Name: base_import_tests_models_m2o; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o IS 'Tests : Base Import Model, Many to One';


--
-- Name: COLUMN base_import_tests_models_m2o.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_id_seq OWNED BY public.base_import_tests_models_m2o.id;


--
-- Name: base_import_tests_models_m2o_related; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_related OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_related IS 'Tests : Base Import Model, Many to One related';


--
-- Name: COLUMN base_import_tests_models_m2o_related.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_related_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_related_id_seq OWNED BY public.base_import_tests_models_m2o_related.id;


--
-- Name: base_import_tests_models_m2o_required; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_required (
    id integer NOT NULL,
    value integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_required OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required IS 'Tests : Base Import Model, Many to One required';


--
-- Name: COLUMN base_import_tests_models_m2o_required.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_required_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_id_seq OWNED BY public.base_import_tests_models_m2o_required.id;


--
-- Name: base_import_tests_models_m2o_required_related; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_required_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_required_related OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_required_related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required_related IS 'Tests : Base Import Model, Many to One required related';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq OWNED BY public.base_import_tests_models_m2o_required_related.id;


--
-- Name: base_import_tests_models_o2m; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_o2m (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_o2m OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_o2m; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_o2m IS 'Tests : Base Import Model, One to Many';


--
-- Name: COLUMN base_import_tests_models_o2m.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_o2m.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_o2m_child (
    id integer NOT NULL,
    parent_id integer,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_o2m_child OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_o2m_child; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_o2m_child IS 'Tests : Base Import Model, One to Many child';


--
-- Name: COLUMN base_import_tests_models_o2m_child.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.parent_id IS 'Parent';


--
-- Name: COLUMN base_import_tests_models_o2m_child.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_o2m_child_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_o2m_child_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_o2m_child_id_seq OWNED BY public.base_import_tests_models_o2m_child.id;


--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_o2m_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_o2m_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_o2m_id_seq OWNED BY public.base_import_tests_models_o2m.id;


--
-- Name: base_import_tests_models_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_preview (
    id integer NOT NULL,
    somevalue integer NOT NULL,
    othervalue integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_preview OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_preview IS 'Tests : Base Import Model Preview';


--
-- Name: COLUMN base_import_tests_models_preview.somevalue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.somevalue IS 'Some Value';


--
-- Name: COLUMN base_import_tests_models_preview.othervalue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.othervalue IS 'Other Variable';


--
-- Name: COLUMN base_import_tests_models_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_preview.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_preview_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_preview_id_seq OWNED BY public.base_import_tests_models_preview.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying(6) NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone
);


ALTER TABLE public.bus_presence OWNER TO runbot;

--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_presence_id_seq OWNER TO runbot;

--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    crud_model_id integer,
    link_field_id integer,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    model_name character varying,
    code text
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Target Model';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Action To Do';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    usage character varying,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer,
    numbercall integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    interval_type character varying,
    cron_name jsonb,
    active boolean,
    doall boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.numbercall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.numbercall IS 'Number of Calls';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.doall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.doall IS 'Repeat Missed';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    json_value character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default.json_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.json_value IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    user_id integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    sort text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying NOT NULL,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    name jsonb NOT NULL,
    info text,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    create_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_property; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_property (
    id integer NOT NULL,
    company_id integer,
    fields_id integer NOT NULL,
    value_integer integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    res_id character varying,
    value_reference character varying,
    type character varying NOT NULL,
    value_text text,
    value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value_float double precision,
    value_binary bytea
);


ALTER TABLE public.ir_property OWNER TO runbot;

--
-- Name: TABLE ir_property; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_property IS 'Company Property';


--
-- Name: COLUMN ir_property.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.company_id IS 'Company';


--
-- Name: COLUMN ir_property.fields_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.fields_id IS 'Field';


--
-- Name: COLUMN ir_property.value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_integer IS 'Value Integer';


--
-- Name: COLUMN ir_property.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_uid IS 'Created by';


--
-- Name: COLUMN ir_property.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_property.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.name IS 'Name';


--
-- Name: COLUMN ir_property.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.res_id IS 'Resource';


--
-- Name: COLUMN ir_property.value_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_reference IS 'Value Reference';


--
-- Name: COLUMN ir_property.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.type IS 'Type';


--
-- Name: COLUMN ir_property.value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_text IS 'Value Text';


--
-- Name: COLUMN ir_property.value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_datetime IS 'Value Datetime';


--
-- Name: COLUMN ir_property.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_date IS 'Created on';


--
-- Name: COLUMN ir_property.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_property.value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_float IS 'Value Float';


--
-- Name: COLUMN ir_property.value_binary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_binary IS 'Value Binary';


--
-- Name: ir_property_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_property_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_property_id_seq OWNER TO runbot;

--
-- Name: ir_property_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_property_id_seq OWNED BY public.ir_property.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Apply for Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Apply for Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Apply for Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Apply for Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_server_object_lines; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_server_object_lines (
    id integer NOT NULL,
    server_id integer,
    col1 integer NOT NULL,
    create_uid integer,
    write_uid integer,
    evaluation_type character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_server_object_lines OWNER TO runbot;

--
-- Name: TABLE ir_server_object_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_server_object_lines IS 'Server Action value mapping';


--
-- Name: COLUMN ir_server_object_lines.server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.server_id IS 'Related Server Action';


--
-- Name: COLUMN ir_server_object_lines.col1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.col1 IS 'Field';


--
-- Name: COLUMN ir_server_object_lines.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.create_uid IS 'Created by';


--
-- Name: COLUMN ir_server_object_lines.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_server_object_lines.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.evaluation_type IS 'Evaluation Type';


--
-- Name: COLUMN ir_server_object_lines.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.value IS 'Value';


--
-- Name: COLUMN ir_server_object_lines.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.create_date IS 'Created on';


--
-- Name: COLUMN ir_server_object_lines.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.write_date IS 'Last Updated on';


--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_server_object_lines_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_server_object_lines_id_seq OWNER TO runbot;

--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_server_object_lines_id_seq OWNED BY public.ir_server_object_lines.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    field_parent character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.field_parent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.field_parent IS 'Child Field';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: rel_server_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_server_actions (
    server_id integer NOT NULL,
    action_id integer NOT NULL
);


ALTER TABLE public.rel_server_actions OWNER TO runbot;

--
-- Name: TABLE rel_server_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_server_actions IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format ?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    mobile character varying,
    base_onboarding_company_state character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_footer jsonb,
    report_header text,
    company_details text,
    active boolean,
    write_date timestamp without time zone,
    logo_web bytea
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.mobile IS 'Mobile';


--
-- Name: COLUMN res_company.base_onboarding_company_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.base_onboarding_company_state IS 'State of the onboarding company step';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_installer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_installer (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config_installer OWNER TO runbot;

--
-- Name: TABLE res_config_installer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_installer IS 'Config Installer';


--
-- Name: COLUMN res_config_installer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_installer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_installer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.create_date IS 'Created on';


--
-- Name: COLUMN res_config_installer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.write_date IS 'Last Updated on';


--
-- Name: res_config_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_installer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_installer_id_seq OWNER TO runbot;

--
-- Name: res_config_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_installer_id_seq OWNED BY public.res_config_installer.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2),
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label character varying,
    currency_subunit_label character varying,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    category_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.category_id IS 'Application';


--
-- Name: COLUMN res_groups.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.color IS 'Color Index';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


ALTER TABLE public.res_lang_install_rel OWNER TO runbot;

--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    title integer,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    display_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    mobile character varying,
    commercial_company_name character varying,
    company_name character varying,
    date date,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.title IS 'Title';


--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.display_name IS 'Display Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.mobile IS 'Mobile';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.date IS 'Date';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Tag Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_partner_title; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_title (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    shortcut jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_title OWNER TO runbot;

--
-- Name: TABLE res_partner_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_title IS 'Partner Title';


--
-- Name: COLUMN res_partner_title.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_title.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_title.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.name IS 'Title';


--
-- Name: COLUMN res_partner_title.shortcut; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.shortcut IS 'Abbreviation';


--
-- Name: COLUMN res_partner_title.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_title.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_date IS 'Last Updated on';


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_title_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_title_id_seq OWNER TO runbot;

--
-- Name: res_partner_title_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_title_id_seq OWNED BY public.res_partner_title.id;


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    totp_secret character varying
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_deletion OWNER TO runbot;

--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_deletion_id_seq OWNER TO runbot;

--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.password IS 'Password';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: web_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


ALTER TABLE public.web_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test IS 'Web Editor Converter Test';


--
-- Name: COLUMN web_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN web_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN web_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN web_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN web_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN web_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN web_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN web_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN web_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN web_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN web_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN web_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."binary" IS 'Binary';


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNED BY public.web_editor_converter_test.id;


--
-- Name: web_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test_sub IS 'Web Editor Converter Subtest';


--
-- Name: COLUMN web_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN web_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNED BY public.web_editor_converter_test_sub.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    user_id integer,
    name character varying NOT NULL
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.user_id IS 'Consumed by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Tour name';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_tests_models_char id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_noreadonly id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_noreadonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_noreadonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_readonly id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_readonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_readonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_required id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_required ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_required_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_states id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_states ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_states_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_stillreadonly id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_stillreadonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_stillreadonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_complex id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_complex ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_complex_id_seq'::regclass);


--
-- Name: base_import_tests_models_float id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_float ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_float_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_related id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_related ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_related_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_required id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_required ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_required_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_required_related id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_required_related ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_required_related_id_seq'::regclass);


--
-- Name: base_import_tests_models_o2m id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_o2m ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_o2m_id_seq'::regclass);


--
-- Name: base_import_tests_models_o2m_child id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_o2m_child ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_o2m_child_id_seq'::regclass);


--
-- Name: base_import_tests_models_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_preview ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_preview_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: bus_presence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_presence ALTER COLUMN id SET DEFAULT nextval('public.bus_presence_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_property id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_property ALTER COLUMN id SET DEFAULT nextval('public.ir_property_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_server_object_lines id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_server_object_lines ALTER COLUMN id SET DEFAULT nextval('public.ir_server_object_lines_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_installer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_installer ALTER COLUMN id SET DEFAULT nextval('public.res_config_installer_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_partner_title id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_title ALTER COLUMN id SET DEFAULT nextval('public.res_partner_title_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: web_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_id_seq'::regclass);


--
-- Name: web_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_device (id, name, user_id, scope, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_wizard (id, user_id, create_uid, write_uid, secret, url, code, create_date, write_date, qrcode) FROM stdin;
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_enable_profiling_wizard (id, create_uid, write_uid, duration, expiration, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_import (id, create_uid, write_uid, res_model, file_name, file_type, create_date, write_date, file) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_mapping (id, create_uid, write_uid, res_model, column_name, field_name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_noreadonly; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_noreadonly (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_readonly; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_readonly (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_required; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_required (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_states; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_states (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_stillreadonly; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_stillreadonly (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_complex; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_complex (id, currency_id, create_uid, write_uid, c, d, m, dt, create_date, write_date, f) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_float; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_float (id, currency_id, create_uid, write_uid, value2, create_date, write_date, value) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o (id, value, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o_related; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o_related (id, value, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o_required; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o_required (id, value, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o_required_related; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o_required_related (id, value, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_o2m; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_o2m (id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_o2m_child; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_o2m_child (id, parent_id, value, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_preview; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_preview (id, somevalue, othervalue, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_export (id, create_uid, write_uid, name, lang, format, state, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_import (id, create_uid, write_uid, name, code, filename, overwrite, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_install (id, create_uid, write_uid, overwrite, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall (id, module_id, create_uid, write_uid, show_all, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_update (id, updated, added, create_uid, write_uid, state, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_upgrade (id, create_uid, write_uid, module_info, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard (id, number_group, current_line_id, dst_partner_id, maximum_group, create_uid, write_uid, state, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, exclude_contact, exclude_journal_item, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, create_uid, write_uid, aggr_ids, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_bus; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_bus (id, create_uid, write_uid, channel, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_presence; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_presence (id, user_id, status, last_poll, last_presence) FROM stdin;
\.


--
-- Data for Name: change_password_own; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_own (id, create_uid, write_uid, new_password, confirm_password, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_user; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_user (id, wizard_id, user_id, create_uid, write_uid, user_login, new_passwd, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: decimal_precision; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.decimal_precision (id, digits, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_act_client; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_client (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, tag, target, res_model, context, params_store) FROM stdin;
2	\N	1	1	ir.actions.client	action	list,form	{"en_US": "Open Settings Menu"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	reload	current	\N	{}	\\x7b276d656e755f6964273a20347d
39	\N	1	1	ir.actions.client	action	list,form	{"en_US": "App Store"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	apps	current	\N	{}	\N
40	\N	1	1	ir.actions.client	action	list,form	{"en_US": "Updates"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	apps.updates	current	\N	{}	\\x7b7d
\.


--
-- Data for Name: ir_act_report_xml; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_report_xml (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, paperformat_id, model, report_type, report_name, report_file, attachment, print_report_name, multi, attachment_use) FROM stdin;
34	3	1	1	ir.actions.report	report	list,form	{"en_US": "Model Overview"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	ir.model	qweb-pdf	base.report_irmodeloverview	base.report_irmodeloverview	\N	\N	\N	\N
41	66	1	1	ir.actions.report	report	list,form	{"en_US": "Technical guide"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	ir.module.module	qweb-pdf	base.report_irmodulereference	base.report_irmodulereference	\N	\N	\N	\N
79	94	1	1	ir.actions.report	report	list,form	{"en_US": "Preview Internal Report"}	\N	2025-11-06 17:18:07.783695	2025-11-06 17:18:07.783695	\N	res.company	qweb-pdf	web.preview_internalreport	web.preview_internalreport	\N	\N	\N	\N
80	94	1	1	ir.actions.report	report	list,form	{"en_US": "Preview External Report"}	\N	2025-11-06 17:18:07.783695	2025-11-06 17:18:07.783695	\N	res.company	qweb-pdf	web.preview_externalreport	web.preview_externalreport	\N	\N	\N	\N
81	94	1	1	ir.actions.report	report	list,form	{"en_US": "Report Layout Preview"}	\N	2025-11-06 17:18:07.783695	2025-11-06 17:18:07.783695	\N	res.company	qweb-pdf	web.preview_layout_report	web.preview_layout_report	\N	\N	\N	\N
\.


--
-- Data for Name: ir_act_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, sequence, model_id, crud_model_id, link_field_id, usage, state, model_name, code) FROM stdin;
10	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Config: Run Remaining Action Todo"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	5	89	\N	\N	ir_actions_server	code	res.config	\nconfig = model.next() or {}\nif config.get('type') not in ('ir.actions.act_window_close',):\n    action = config\n
33	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Base: Auto-vacuum internal data"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	5	38	\N	\N	ir_cron	code	ir.autovacuum	model._run_vacuum_cleaner()
50	66	1	1	ir.actions.server	action	list,form	{"en_US": "Activate Modules"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	5	66	\N	\N	ir_actions_server	code	ir.module.module	records.button_immediate_install()
51	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Failed to install demo data for some modules, demo disabled"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	5	71	\N	\N	ir_actions_server	code	ir.demo_failure.wizard	\nfailures = env['ir.demo_failure'].search([\n    ('wizard_id', '=', False),\n])\nrecord = model.create({\n    'failure_ids': [Command.set(failures.ids)],\n})\naction = {\n    'type': 'ir.actions.act_window',\n    'res_id': record.id,\n    'res_model': 'ir.demo_failure.wizard',\n    'target': 'new',\n    'views': [(env.ref('base.demo_failures_dialog').id, 'form')],\n}\n        
83	97	1	1	ir.actions.server	action	list,form	{"en_US": "Disable two-factor authentication"}	\N	2025-11-06 17:18:11.586504	2025-11-06 17:18:11.586504	5	97	\N	\N	ir_actions_server	code	res.users	\n            action = records.action_totp_disable()\n        
\.


--
-- Data for Name: ir_act_server_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_group_rel (act_id, gid) FROM stdin;
83	2
\.


--
-- Data for Name: ir_act_url; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_url (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, target, url) FROM stdin;
3	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Home Menu"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	self	/web
37	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Third-Party Apps"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	new	https://apps.odoo.com/apps/modules
38	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Theme Store"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	new	https://apps.odoo.com/apps/themes
\.


--
-- Data for Name: ir_act_window; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, view_id, res_id, "limit", search_view_id, domain, context, res_model, target, view_mode, usage, filter) FROM stdin;
1	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Load demo data"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	ir.demo	new	form	\N	\N
4	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Decimal Accuracy"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	decimal.precision	current	tree,form	\N	\N
5	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Actions"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	7	\N	80	8	\N	{}	ir.actions.actions	current	tree,form	\N	\N
6	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Reports"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	10	\N	80	11	\N	{}	ir.actions.report	current	tree,form	\N	\N
7	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Window Actions"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	14	\N	{}	ir.actions.act_window	current	tree,form	\N	\N
8	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Server Actions"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	16	\N	80	17	\N	{'key':'server_action'}	ir.actions.server	current	tree,form	\N	\N
9	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Configuration Wizards"}	{"en_US": "<p>The configuration wizards are used to help you configure a new instance of Odoo. They are launched during the installation of new modules, but you can choose to restart some wizards manually from this menu.</p>"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	18	\N	80	\N	\N	{}	ir.actions.todo	current	tree,form	\N	\N
11	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Assets"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	22	\N	80	\N	\N	{'search_default_active': 1}	ir.asset	current	tree,form	\N	\N
12	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "System Parameters"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	ir.config_parameter	current	tree,form	\N	\N
13	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Scheduled Actions"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	28	\N	80	\N	\N	{'search_default_all': 1}	ir.cron	current	tree,form,calendar	\N	\N
14	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Scheduled Actions Triggers"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	ir.cron.trigger	current	tree,form	\N	\N
15	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "User-defined Filters"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	ir.filters	current	tree,form	\N	\N
16	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Outgoing Mail Servers"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	38	\N	80	39	\N	{}	ir.mail_server	current	tree,form	\N	\N
17	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Create Menu"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{'model_id': active_id}	wizard.ir.model.menu.create	new	form	\N	\N
18	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Models"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	42	\N	80	\N	\N	{}	ir.model	current	tree,form	\N	\N
19	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fields"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	45	\N	80	\N	\N	{}	ir.model.fields	current	tree,form	\N	\N
20	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fields Selection"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	48	\N	80	\N	\N	{}	ir.model.fields.selection	current	tree,form	\N	\N
21	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "External Identifiers"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	51	\N	80	\N	\N	{}	ir.model.data	current	tree,form	\N	\N
22	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Model Constraints"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	54	\N	80	55	\N	{}	ir.model.constraint	current	tree,form	\N	\N
23	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "ManyToMany Relations"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	57	\N	80	\N	\N	{}	ir.model.relation	current	tree,form	\N	\N
24	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Access Rights"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	59	\N	80	61	\N	{}	ir.model.access	current	tree,form	\N	\N
25	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Attachments"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a new document\\n                </p>\\n                <p>\\n                    Also you will find here all the related documents and download it by clicking on any individual document.\\n                </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	64	\N	{}	ir.attachment	current	tree,form	\N	\N
26	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Record Rules"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	66	\N	80	67	\N	{}	ir.rule	current	tree,form	\N	\N
27	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Sequences"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	69	\N	80	\N	\N	{'active_test': False}	ir.sequence	current	tree,form	\N	\N
28	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Menu Items"}	{"en_US": "<p>Manage and customize the items available and displayed in your Odoo system menu. You can delete an item by clicking on the box at the beginning of each line and then delete it through the button that appeared. Items can be assigned to specific groups in order to make them accessible to some users within the system.</p>"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	72	\N	80	73	\N	{'ir.ui.menu.full_list':True}	ir.ui.menu	current	tree,form	\N	\N
29	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Views"}	{"en_US": "<p>Views allows you to personalize each view of Odoo. You can add new fields, move fields, rename them or delete the ones that you do not need.</p>"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	75	\N	80	\N	\N	{'search_default_active': 1}	ir.ui.view	current	tree,form	\N	\N
30	15	1	1	ir.actions.act_window	action	form,list	{"en_US": "Compare/Reset"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	reset.view.arch.wizard	new	form	\N	\N
31	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customized Views"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">Create a customized view</p><p>Customized views are used when users reorganize the content of their dashboard views (via web client)</p>"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	ir.ui.view.custom	current	tree,form	\N	\N
32	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "User-defined Defaults"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	83	\N	{}	ir.default	current	tree,form	\N	\N
35	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Logging"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	87	\N	{}	ir.logging	current	tree,form	\N	\N
36	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Apps"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No module found!\\n              </p><p>\\n                You should try other search criteria.\\n              </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	92	\N	{'search_default_app':1}	ir.module.module	current	kanban,tree,form	\N	\N
42	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Module Update"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	base.module.update	new	form	\N	\N
43	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Add Languages"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	base.language.install	new	form	\N	\N
44	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Import Translation"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	base.language.import	new	form	\N	\N
45	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Apply Schedule Upgrade"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	base.module.upgrade	new	form	\N	\N
46	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Module Upgrade Install"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	102	\N	80	\N	\N	{}	base.module.upgrade	new	form	\N	\N
47	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Export Translation"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	base.language.export	new	form	\N	\N
48	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Deduplicate Contacts"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{'active_test': False}	base.partner.merge.automatic.wizard	new	form	\N	\N
49	85	1	1	ir.actions.act_window	action	list	{"en_US": "Merge"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	base.partner.merge.automatic.wizard	new	form	\N	\N
52	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Ir profile"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{'search_default_group_session': 1}	ir.profile	current	tree,form	\N	\N
53	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Companies"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new company\\n              </p><p>\\n                Create and manage the companies that will be managed by Odoo from here. Shops or subsidiaries can be created and maintained from here.\\n              </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	res.company	current	tree,kanban,form	\N	\N
54	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Languages"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	117	\N	{'active_test': False}	res.lang	current	tree,form	\N	\N
55	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Contact Titles"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Title\\n                </p><p>\\n                    Manage Contact Titles as well as their abbreviations (e.g. \\"Mr.\\", \\"Mrs.\\", etc).\\n                </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	[]	{}	res.partner.title	current	tree,form	\N	\N
56	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact in your address book\\n              </p><p>\\n                Odoo helps you track all activities related to your contacts.\\n              </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	125	\N	{'res_partner_search_mode': 'customer'}	res.partner	current	kanban,tree,form	\N	\N
57	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new customer in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a customer.\\n              </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	[]	{'res_partner_search_mode': 'customer', 'default_is_company': True}	res.partner	current	kanban,tree,form	\N	t
58	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Vendors"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new vendor in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a vendor.\\n              </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	[]	{'res_partner_search_mode': 'supplier', 'default_is_company': True}	res.partner	current	kanban,tree,form	\N	t
59	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Contact Tags"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact Tag\\n              </p><p>\\n                Assign tags to your contacts to organize, filter and track them.\\n              </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	129	\N	{}	res.partner.category	current	tree,form	\N	\N
60	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Industries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create an Industry\\n              </p><p>\\n                Specify industries to classify your contacts and draw up reports.\\n              </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	132	\N	{}	res.partner.industry	current	tree,form	\N	\N
61	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Banks"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank\\n              </p><p>\\n                Banks are the financial institutions at which you and your contacts have their accounts.\\n              </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	135	\N	{}	res.bank	current	tree,form	\N	\N
62	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Bank Accounts"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank Account\\n              </p><p>\\n                From here you can manage all bank accounts linked to you and your contacts.\\n              </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	res.partner.bank	current	tree,form	\N	\N
63	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Countries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No Country Found!\\n                </p><p>\\n                    Manage the list of countries that can be set on your contacts.\\n                </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	res.country	current	tree,form	\N	\N
64	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Country Group"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Country Group\\n                </p><p>\\n                    Use groups to organize countries that are frequently selected together (e.g. \\"LATAM\\", \\"BeNeLux\\", \\"ASEAN\\").\\n                </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	res.country.group	current	tree,form	\N	\N
65	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fed. States"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a State\\n                </p><p>\\n                    Federal States belong to countries and are part of your contacts' addresses.\\n                </p>\\n            "}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	143	\N	80	\N	\N	{}	res.country.state	current	tree,form	\N	\N
66	92	1	1	ir.actions.act_window	action	form	{"en_US": "Show Currency Rates"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	147	\N	80	\N	[('currency_id','=', active_id)]	{'default_currency_id': active_id}	res.currency.rate	current	tree,form	\N	\N
67	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Currencies"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	149	\N	{'active_test': False}	res.currency	current	tree,kanban,form	\N	\N
68	97	1	1	ir.actions.act_window	action	list,form	{"en_US": "Change Password"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	change.password.wizard	new	form	\N	\N
69	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Groups"}	{"en_US": "<p>A group is a set of functional areas that will be assigned to the user in order to give them access and rights to specific applications and tasks in the system. You can create custom groups or edit the ones existing by default in order to customize the view of the menu that users will be able to see. Whether they can have a read, write, create and delete access right can be managed from here.</p>"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{'search_default_filter_no_share': 1}	res.groups	current	tree,form	\N	\N
70	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Users"}	{"en_US": "<p>Create and manage users that will connect to the system. Users can be deactivated should there be a period of time during which they will/should not connect to the system. You can assign them groups in order to give them specific access to the applications they need to use in the system.</p>"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	161	\N	80	163	\N	{'search_default_filter_no_share': 1, 'show_user_group_warning': True}	res.users	current	tree,kanban,form	\N	\N
71	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "API Key: description input wizard"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	res.users.apikeys.description	new	form	\N	\N
72	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Change My Preferences"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	res.users	new	form	\N	\N
73	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "API Keys Listing"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	168	\N	80	\N	\N	{}	res.users.apikeys	current	tree	\N	\N
74	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Company Properties"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	171	\N	80	\N	\N	{}	ir.property	current	tree,form	\N	\N
75	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Settings"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	res.config.settings	inline	form	\N	\N
76	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Paper Format General Configuration"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	report.paperformat	current	tree,form	\N	\N
77	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Reports"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N	80	\N	\N	{}	ir.actions.report	current	tree,form	\N	\N
78	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Set your company data"}	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	178	\N	80	\N	\N	{}	res.company	new	form	\N	\N
82	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Configure your document layout"}	\N	2025-11-06 17:18:07.783695	2025-11-06 17:18:07.783695	210	\N	80	\N	\N	{}	base.document.layout	new	form	\N	\N
84	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Tours"}	\N	2025-11-06 17:18:13.404714	2025-11-06 17:18:13.404714	219	\N	80	220	\N	{}	web_tour.tour	current	tree,form	\N	\N
\.


--
-- Data for Name: ir_act_window_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_group_rel (act_id, gid) FROM stdin;
73	4
\.


--
-- Data for Name: ir_act_window_view; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_view (id, sequence, view_id, act_window_id, create_uid, write_uid, view_mode, multi, create_date, write_date) FROM stdin;
1	1	12	7	1	1	tree	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
2	2	13	7	1	1	form	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
3	0	126	56	1	1	kanban	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
4	2	123	56	1	1	form	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
5	1	120	56	1	1	tree	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
6	1	126	57	1	1	kanban	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
7	2	120	57	1	1	tree	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
8	3	123	57	1	1	form	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
9	1	126	58	1	1	kanban	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
10	2	120	58	1	1	tree	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
11	3	123	58	1	1	form	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
12	10	161	70	1	1	tree	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
13	20	160	70	1	1	form	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
14	10	167	72	1	1	form	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
\.


--
-- Data for Name: ir_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_actions_todo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions_todo (id, action_id, sequence, create_uid, write_uid, state, name, create_date, write_date) FROM stdin;
1	2	100	1	1	done	Open Menu	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
2	51	1	1	1	done	Demo Failure Notification	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
\.


--
-- Data for Name: ir_asset; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_asset (id, sequence, create_uid, write_uid, name, bundle, directive, path, target, active, create_date, write_date) FROM stdin;
1	16	1	1	13 0 color system support primary variables SCSS	web._assets_primary_variables	append	web_editor/static/src/scss/13_0_color_system_support_primary_variables.scss	\N	f	2025-11-06 17:18:13.563663	2025-11-06 17:18:13.563663
\.


--
-- Data for Name: ir_attachment; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_attachment (id, res_id, company_id, file_size, create_uid, write_uid, name, res_model, res_field, type, url, access_token, store_fname, checksum, mimetype, description, index_content, public, create_date, write_date, db_datas, original_id) FROM stdin;
1	3	1	9152	1	1	flag_image	res.lang	flag_image	binary	\N	\N	44/44d1661b24fa9f688091c8256535434b60aafba7	44d1661b24fa9f688091c8256535434b60aafba7	image/png	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
2	63	1	15497	1	1	flag_image	res.lang	flag_image	binary	\N	\N	62/627090759f9a66678c28c1bc3c3039b37f40f66e	627090759f9a66678c28c1bc3c3039b37f40f66e	image/png	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
3	10	1	192	1	1	flag_image	res.lang	flag_image	binary	\N	\N	05/055ffc5cce56e142234ffc466012dff7edc2c7e7	055ffc5cce56e142234ffc466012dff7edc2c7e7	image/png	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
4	1	1	15310	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
5	1	1	1150	1	1	favicon	res.company	favicon	binary	\N	\N	d0/d09086a0794cf3070f12e742f27126254b4e2b5a	d09086a0794cf3070f12e742f27126254b4e2b5a	image/vnd.microsoft.icon	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
6	1	1	15310	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
7	1	1	15310	1	1	image_512	res.partner	image_512	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
8	1	1	12509	1	1	image_256	res.partner	image_256	binary	\N	\N	77/7712910ea66effcd74ee140f5d145fe30000aa57	7712910ea66effcd74ee140f5d145fe30000aa57	image/png	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
9	1	1	5421	1	1	image_128	res.partner	image_128	binary	\N	\N	e0/e0d4b5b2f41d6a523b47d17100558bf3084c67b1	e0d4b5b2f41d6a523b47d17100558bf3084c67b1	image/png	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
10	1	1	9168	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	ab/ab7e6730db0c9255c1a5c4373a2dec39f94058e5	ab7e6730db0c9255c1a5c4373a2dec39f94058e5	image/png	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
11	4	1	9020	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	b8/b8f9001425cfd0ef0315797909281b912817643a	b8f9001425cfd0ef0315797909281b912817643a	image/png	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
12	5	1	9180	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	a3/a330920abcef2433621d6bb985bc24828d77f77b	a330920abcef2433621d6bb985bc24828d77f77b	image/png	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
13	19	1	2879	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	37/370346e9cc2090760bd32bba59f14042e98cd92e	370346e9cc2090760bd32bba59f14042e98cd92e	image/svg+xml	\N	image	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	\N
14	\N	1	\N	1	1	placeholder.png	\N	\N	url	/web/static/img/placeholder.png	\N	\N	\N	image/png	\N	\N	t	2025-11-06 17:18:07.783695	2025-11-06 17:18:07.783695	\N	\N
15	\N	1	583	1	1	res.company.scss	\N	\N	binary	web/static/asset_styles_company_report.scss	\N	6a/6a8d2ce207c6f1860f379cf9f75c8cc497c06982	6a8d2ce207c6f1860f379cf9f75c8cc497c06982	text/scss	\N	                .o_company_1_layout {\n                font-family: Lato;\n                &.o_report_layout_standard {\n                    h2 {\n                        color: black;\n                    }\n                    #informations strong {\n                        color: black;\n                    }\n                    #total strong{\n                        color: black;\n                    }\n                    table {\n                        thead {\n                            color: black;\n                        }\n                    }\n                }\n            }	\N	2025-11-06 17:18:07.783695	2025-11-06 17:18:07.783695	\N	\N
\.


--
-- Data for Name: ir_config_parameter; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_config_parameter (id, create_uid, write_uid, key, value, create_date, write_date) FROM stdin;
4	1	1	web.base.url	http://localhost:8069	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
5	1	1	base.login_cooldown_after	10	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
6	1	1	base.login_cooldown_duration	60	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
7	1	1	mail.catchall.alias	catchall	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
8	1	1	mail.bounce.alias	bounce	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
9	1	1	mail.default.from	notifications	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
10	1	1	base.template_portal_user_id	5	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
1	1	1	database.secret	21eafb0e-86e9-46e5-8af6-0f066f9d23c4	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
2	1	1	database.uuid	90069428-bb34-11f0-86fc-cf2b885b1551	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
3	1	1	database.create_date	2025-11-06 17:18:07	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
\.


--
-- Data for Name: ir_cron; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron (id, ir_actions_server_id, user_id, interval_number, numbercall, priority, create_uid, write_uid, interval_type, cron_name, active, doall, nextcall, lastcall, create_date, write_date) FROM stdin;
1	33	1	1	-1	5	1	1	days	{"en_US": "Base: Auto-vacuum internal data"}	t	\N	2025-11-06 17:18:05	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
\.


--
-- Data for Name: ir_cron_trigger; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron_trigger (id, cron_id, create_uid, write_uid, call_at, create_date, write_date) FROM stdin;
1	1	1	1	2025-11-06 17:19:14.571534	2025-11-06 17:18:14.433293	2025-11-06 17:18:14.433293
\.


--
-- Data for Name: ir_default; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_default (id, field_id, user_id, company_id, create_uid, write_uid, condition, json_value, create_date, write_date) FROM stdin;
1	901	\N	\N	1	1	\N	"en_US"	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
\.


--
-- Data for Name: ir_demo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure (id, module_id, wizard_id, create_uid, write_uid, error, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports (id, create_uid, write_uid, name, resource, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports_line (id, export_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_filters; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_filters (id, user_id, action_id, create_uid, write_uid, name, model_id, domain, context, sort, is_default, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_logging; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_logging (id, create_uid, write_uid, name, type, dbname, level, path, func, line, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_mail_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_mail_server (id, smtp_port, sequence, create_uid, write_uid, name, from_filter, smtp_host, smtp_authentication, smtp_user, smtp_pass, smtp_encryption, smtp_debug, active, create_date, write_date, smtp_ssl_certificate, smtp_ssl_private_key) FROM stdin;
\.


--
-- Data for Name: ir_model; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model (id, create_uid, write_uid, model, "order", state, name, info, transient, create_date, write_date) FROM stdin;
1	\N	\N	base	id	base	{"en_US": "Base"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N
2	\N	\N	_unknown	id	base	{"en_US": "Unknown"}	\n    Abstract model used as a substitute for relational fields with an unknown\n    comodel.\n    	f	\N	\N
3	\N	\N	ir.model	model	base	{"en_US": "Models"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
4	\N	\N	ir.model.fields	name	base	{"en_US": "Fields"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
5	\N	\N	ir.model.fields.selection	sequence, id	base	{"en_US": "Fields Selection"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
6	\N	\N	ir.model.constraint	id	base	{"en_US": "Model Constraint"}	\n    This model tracks PostgreSQL foreign keys and constraints used by Odoo\n    models.\n    	f	\N	\N
7	\N	\N	ir.model.relation	id	base	{"en_US": "Relation Model"}	\n    This model tracks PostgreSQL tables used to implement Odoo many2many\n    relations.\n    	f	\N	\N
8	\N	\N	ir.model.access	model_id,group_id,name,id	base	{"en_US": "Model Access"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
9	\N	\N	ir.model.data	module, model, name	base	{"en_US": "Model Data"}	Holds external identifier keys for records in the database.\n       This has two main uses:\n\n           * allows easy data integration with third-party systems,\n             making import/export/sync of data possible, as records\n             can be uniquely identified across multiple systems\n           * allows tracking the origin of data installed by Odoo\n             modules themselves, thus making it possible to later\n             update them seamlessly.\n    	f	\N	\N
10	\N	\N	wizard.ir.model.menu.create	id	base	{"en_US": "Create Menu Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
11	\N	\N	ir.sequence	name	base	{"en_US": "Sequence"}	 Sequence model.\n\n    The sequence model allows to define and use so-called sequence objects.\n    Such objects are used to generate unique identifiers in a transaction-safe\n    way.\n\n    	f	\N	\N
12	\N	\N	ir.sequence.date_range	id	base	{"en_US": "Sequence Date Range"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
13	\N	\N	ir.ui.menu	sequence,id	base	{"en_US": "Menu"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
14	\N	\N	ir.ui.view.custom	create_date desc	base	{"en_US": "Custom View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
15	\N	\N	ir.ui.view	priority,name,id	base	{"en_US": "View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
16	\N	\N	reset.view.arch.wizard	id	base	{"en_US": "Reset View Architecture Wizard"}	 A wizard to compare and reset views architecture. 	t	\N	\N
17	\N	\N	ir.asset	sequence, id	base	{"en_US": "Asset"}	This model contributes to two things:\n\n        1. It provides a function returning a list of all file paths declared\n        in a given list of addons (see _get_addon_paths);\n\n        2. It allows to create 'ir.asset' records to add additional directives\n        to certain bundles.\n    	f	\N	\N
18	\N	\N	ir.actions.actions	name	base	{"en_US": "Actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
19	\N	\N	ir.actions.act_window	name	base	{"en_US": "Action Window"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
20	\N	\N	ir.actions.act_window.view	sequence,id	base	{"en_US": "Action Window View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
21	\N	\N	ir.actions.act_window_close	name	base	{"en_US": "Action Window Close"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
22	\N	\N	ir.actions.act_url	name	base	{"en_US": "Action URL"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
52	\N	\N	ir.qweb.field.image	id	base	{"en_US": "Qweb Field Image"}	\n    Widget options:\n\n    ``class``\n        set as attribute on the generated <img> tag\n    	f	\N	\N
23	\N	\N	ir.actions.server	sequence,name	base	{"en_US": "Server Actions"}	 Server actions model. Server action work on a base model and offer various\n    type of actions that can be executed automatically, for example using base\n    action rules, of manually, by adding the action in the 'More' contextual\n    menu.\n\n    Since Odoo 8.0 a button 'Create Menu Action' button is available on the\n    action form view. It creates an entry in the More menu of the base model.\n    This allows to create server actions and run them in mass mode easily through\n    the interface.\n\n    The available actions are :\n\n    - 'Execute Python Code': a block of python code that will be executed\n    - 'Create a new Record': create a new record with new values\n    - 'Write on a Record': update the values of a record\n    - 'Execute several actions': define an action that triggers several other\n      server actions\n    	f	\N	\N
24	\N	\N	ir.server.object.lines	id	base	{"en_US": "Server Action value mapping"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
25	\N	\N	ir.actions.todo	sequence, id	base	{"en_US": "Configuration Wizards"}	\n    Configuration Wizards\n    	f	\N	\N
26	\N	\N	ir.actions.client	name	base	{"en_US": "Client Action"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
27	\N	\N	ir.actions.report	name, id	base	{"en_US": "Report Action"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
28	\N	\N	ir.attachment	id desc	base	{"en_US": "Attachment"}	Attachments are used to link binary files or url to any openerp document.\n\n    External attachment storage\n    ---------------------------\n\n    The computed field ``datas`` is implemented using ``_file_read``,\n    ``_file_write`` and ``_file_delete``, which can be overridden to implement\n    other storage engines. Such methods should check for other location pseudo\n    uri (example: hdfs://hadoopserver).\n\n    The default implementation is the file:dirname location that stores files\n    on the local filesystem using name based on their sha1 hash\n    	f	\N	\N
29	\N	\N	ir.binary	id	base	{"en_US": "File streaming helper model for controllers"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N
30	\N	\N	ir.cron	cron_name	base	{"en_US": "Scheduled Actions"}	 Model describing cron jobs (also called actions or tasks).\n    	f	\N	\N
31	\N	\N	ir.cron.trigger	id	base	{"en_US": "Triggered actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
32	\N	\N	ir.filters	model_id, name, id desc	base	{"en_US": "Filters"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
33	\N	\N	ir.default	id	base	{"en_US": "Default Values"}	 User-defined default values for fields. 	f	\N	\N
34	\N	\N	ir.exports	name	base	{"en_US": "Exports"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
35	\N	\N	ir.exports.line	id	base	{"en_US": "Exports Line"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
36	\N	\N	ir.rule	model_id DESC,id	base	{"en_US": "Record Rule"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
37	\N	\N	ir.config_parameter	key	base	{"en_US": "System Parameter"}	Per-database storage of configuration key-value pairs.	f	\N	\N
38	\N	\N	ir.autovacuum	id	base	{"en_US": "Automatic Vacuum"}	 Helper model to the ``@api.autovacuum`` method decorator. 	f	\N	\N
39	\N	\N	ir.mail_server	sequence	base	{"en_US": "Mail Server"}	Represents an SMTP server, able to send outgoing emails, with SSL and TLS capabilities.	f	\N	\N
40	\N	\N	ir.fields.converter	id	base	{"en_US": "Fields Converter"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N
42	\N	\N	ir.qweb.field	id	base	{"en_US": "Qweb Field"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
43	\N	\N	ir.qweb.field.integer	id	base	{"en_US": "Qweb Field Integer"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
117	\N	\N	base.document.layout	id	base	{"en_US": "Company Document Layout"}	\n    Customise the company document layout and display a live preview\n    	t	\N	\N
44	\N	\N	ir.qweb.field.float	id	base	{"en_US": "Qweb Field Float"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
45	\N	\N	ir.qweb.field.date	id	base	{"en_US": "Qweb Field Date"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
46	\N	\N	ir.qweb.field.datetime	id	base	{"en_US": "Qweb Field Datetime"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
47	\N	\N	ir.qweb.field.text	id	base	{"en_US": "Qweb Field Text"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
48	\N	\N	ir.qweb.field.selection	id	base	{"en_US": "Qweb Field Selection"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
49	\N	\N	ir.qweb.field.many2one	id	base	{"en_US": "Qweb Field Many to One"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
50	\N	\N	ir.qweb.field.many2many	id	base	{"en_US": "Qweb field many2many"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
51	\N	\N	ir.qweb.field.html	id	base	{"en_US": "Qweb Field HTML"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
53	\N	\N	ir.qweb.field.image_url	id	base	{"en_US": "Qweb Field Image"}	 ``image_url`` widget rendering, inserts an image tag in the\n    document.\n    	f	\N	\N
54	\N	\N	ir.qweb.field.monetary	id	base	{"en_US": "Qweb Field Monetary"}	 ``monetary`` converter, has a mandatory option\n    ``display_currency`` only if field is not of type Monetary.\n    Otherwise, if we are in presence of a monetary field, the field definition must\n    have a currency_field attribute set.\n\n    The currency is used for formatting *and rounding* of the float value. It\n    is assumed that the linked res_currency has a non-empty rounding value and\n    res.currency's ``round`` method is used to perform rounding.\n\n    .. note:: the monetary converter internally adds the qweb context to its\n              options mapping, so that the context is available to callees.\n              It's set under the ``_values`` key.\n    	f	\N	\N
55	\N	\N	ir.qweb.field.float_time	id	base	{"en_US": "Qweb Field Float Time"}	 ``float_time`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "01:30").\n\n    Can be used on any numerical field.\n    	f	\N	\N
56	\N	\N	ir.qweb.field.time	id	base	{"en_US": "QWeb Field Time"}	 ``time`` converter, to display integer or fractional value as\n    human-readable time (e.g. 1.5 as "1:30 AM"). The unit of this value\n    is in hours.\n\n    Can be used on any numerical field between: 0 <= value < 24\n    	f	\N	\N
57	\N	\N	ir.qweb.field.duration	id	base	{"en_US": "Qweb Field Duration"}	 ``duration`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "1 hour 30 minutes").\n\n    Can be used on any numerical field.\n\n    Has an option ``unit`` which can be one of ``second``, ``minute``,\n    ``hour``, ``day``, ``week`` or ``year``, used to interpret the numerical\n    field value before converting it. By default use ``second``.\n\n    Has an option ``round``. By default use ``second``.\n\n    Has an option ``digital`` to display 01:00 instead of 1 hour\n\n    Sub-second values will be ignored.\n    	f	\N	\N
58	\N	\N	ir.qweb.field.relative	id	base	{"en_US": "Qweb Field Relative"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
59	\N	\N	ir.qweb.field.barcode	id	base	{"en_US": "Qweb Field Barcode"}	 ``barcode`` widget rendering, inserts a data:uri-using image tag in the\n    document. May be overridden by e.g. the website module to generate links\n    instead.\n    	f	\N	\N
60	\N	\N	ir.qweb.field.contact	id	base	{"en_US": "Qweb Field Contact"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
61	\N	\N	ir.qweb.field.qweb	id	base	{"en_US": "Qweb Field qweb"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
62	\N	\N	ir.http	id	base	{"en_US": "HTTP Routing"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N
63	\N	\N	ir.logging	id DESC	base	{"en_US": "Logging"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
64	\N	\N	ir.property	id	base	{"en_US": "Company Property"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
65	\N	\N	ir.module.category	name	base	{"en_US": "Application"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
66	\N	\N	ir.module.module	application desc,sequence,name	base	{"en_US": "Module"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
67	\N	\N	ir.module.module.dependency	id	base	{"en_US": "Module dependency"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
68	\N	\N	ir.module.module.exclusion	id	base	{"en_US": "Module exclusion"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
69	\N	\N	ir.demo	id	base	{"en_US": "Demo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
70	\N	\N	ir.demo_failure	id	base	{"en_US": "Demo failure"}	 Stores modules for which we could not install demo data\n    	t	\N	\N
71	\N	\N	ir.demo_failure.wizard	id	base	{"en_US": "Demo Failure wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
72	\N	\N	report.layout	sequence	base	{"en_US": "Report Layout"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
73	\N	\N	report.paperformat	id	base	{"en_US": "Paper Format Config"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
74	\N	\N	ir.profile	session desc, id desc	base	{"en_US": "Profiling results"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
75	\N	\N	base.enable.profiling.wizard	id	base	{"en_US": "Enable profiling for some time"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
76	\N	\N	image.mixin	id	base	{"en_US": "Image Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N
77	\N	\N	avatar.mixin	id	base	{"en_US": "Avatar Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N
78	\N	\N	res.country	name	base	{"en_US": "Country"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
79	\N	\N	res.country.group	id	base	{"en_US": "Country Group"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
80	\N	\N	res.country.state	code	base	{"en_US": "Country state"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
81	\N	\N	res.lang	active desc,name	base	{"en_US": "Languages"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
82	\N	\N	format.address.mixin	id	base	{"en_US": "Address Format"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N
83	\N	\N	res.partner.category	name	base	{"en_US": "Partner Tags"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
84	\N	\N	res.partner.title	name	base	{"en_US": "Partner Title"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
85	\N	\N	res.partner	display_name ASC, id DESC	base	{"en_US": "Contact"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
86	\N	\N	res.partner.industry	name	base	{"en_US": "Industry"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
87	\N	\N	res.bank	name	base	{"en_US": "Bank"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
88	\N	\N	res.partner.bank	sequence, id	base	{"en_US": "Bank Accounts"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
89	\N	\N	res.config	id	base	{"en_US": "Config"}	 Base classes for new-style configuration items\n\n    Configuration items should inherit from this class, implement\n    the execute method (and optionally the cancel one) and have\n    their view inherit from the related res_config_view_base view.\n    	t	\N	\N
90	\N	\N	res.config.installer	id	base	{"en_US": "Config Installer"}	 New-style configuration base specialized for addons selection\n    and installation.\n\n    Basic usage\n    -----------\n\n    Subclasses can simply define a number of boolean fields. The field names\n    should be the names of the addons to install (when selected). Upon action\n    execution, selected boolean fields (and those only) will be interpreted as\n    addons to install, and batch-installed.\n\n    Additional addons\n    -----------------\n\n    It is also possible to require the installation of an additional\n    addon set when a specific preset of addons has been marked for\n    installation (in the basic usage only, additionals can't depend on\n    one another).\n\n    These additionals are defined through the ``_install_if``\n    property. This property is a mapping of a collection of addons (by\n    name) to a collection of addons (by name) [#]_, and if all the *key*\n    addons are selected for installation, then the *value* ones will\n    be selected as well. For example::\n\n        _install_if = {\n            ('sale','crm'): ['sale_crm'],\n        }\n\n    This will install the ``sale_crm`` addon if and only if both the\n    ``sale`` and ``crm`` addons are selected for installation.\n\n    You can define as many additionals as you wish, and additionals\n    can overlap in key and value. For instance::\n\n        _install_if = {\n            ('sale','crm'): ['sale_crm'],\n            ('sale','project'): ['sale_service'],\n        }\n\n    will install both ``sale_crm`` and ``sale_service`` if all of\n    ``sale``, ``crm`` and ``project`` are selected for installation.\n\n    Hook methods\n    ------------\n\n    Subclasses might also need to express dependencies more complex\n    than that provided by additionals. In this case, it's possible to\n    define methods of the form ``_if_%(name)s`` where ``name`` is the\n    name of a boolean field. If the field is selected, then the\n    corresponding module will be marked for installation *and* the\n    hook method will be executed.\n\n    Hook methods take the usual set of parameters (cr, uid, ids,\n    context) and can return a collection of additional addons to\n    install (if they return anything, otherwise they should not return\n    anything, though returning any "falsy" value such as None or an\n    empty collection will have the same effect).\n\n    Complete control\n    ----------------\n\n    The last hook is to simply overload the ``modules_to_install``\n    method, which implements all the mechanisms above. This method\n    takes the usual set of parameters (cr, uid, ids, context) and\n    returns a ``set`` of addons to install (addons selected by the\n    above methods minus addons from the *basic* set which are already\n    installed) [#]_ so an overloader can simply manipulate the ``set``\n    returned by ``ResConfigInstaller.modules_to_install`` to add or\n    remove addons.\n\n    Skipping the installer\n    ----------------------\n\n    Unless it is removed from the view, installers have a *skip*\n    button which invokes ``action_skip`` (and the ``cancel`` hook from\n    ``res.config``). Hooks and additionals *are not run* when skipping\n    installation, even for already installed addons.\n\n    Again, setup your hooks accordingly.\n\n    .. [#] note that since a mapping key needs to be hashable, it's\n           possible to use a tuple or a frozenset, but not a list or a\n           regular set\n\n    .. [#] because the already-installed modules are only pruned at\n           the very end of ``modules_to_install``, additionals and\n           hooks depending on them *are guaranteed to execute*. Setup\n           your hooks accordingly.\n    	t	\N	\N
91	\N	\N	res.config.settings	id	base	{"en_US": "Config Settings"}	 Base configuration wizard for application settings.  It provides support for setting\n        default values, assigning groups to employee users, and installing modules.\n        To make such a 'settings' wizard, define a model like::\n\n            class MyConfigWizard(models.TransientModel):\n                _name = 'my.settings'\n                _inherit = 'res.config.settings'\n\n                default_foo = fields.type(..., default_model='my.model'),\n                group_bar = fields.Boolean(..., group='base.group_user', implied_group='my.group'),\n                module_baz = fields.Boolean(...),\n                config_qux = fields.Char(..., config_parameter='my.parameter')\n                other_field = fields.type(...),\n\n        The method ``execute`` provides some support based on a naming convention:\n\n        *   For a field like 'default_XXX', ``execute`` sets the (global) default value of\n            the field 'XXX' in the model named by ``default_model`` to the field's value.\n\n        *   For a boolean field like 'group_XXX', ``execute`` adds/removes 'implied_group'\n            to/from the implied groups of 'group', depending on the field's value.\n            By default 'group' is the group Employee.  Groups are given by their xml id.\n            The attribute 'group' may contain several xml ids, separated by commas.\n\n        *   For a selection field like 'group_XXX' composed of 2 string values ('0' and '1'),\n            ``execute`` adds/removes 'implied_group' to/from the implied groups of 'group', \n            depending on the field's value.\n            By default 'group' is the group Employee.  Groups are given by their xml id.\n            The attribute 'group' may contain several xml ids, separated by commas.\n\n        *   For a boolean field like 'module_XXX', ``execute`` triggers the immediate\n            installation of the module named 'XXX' if the field has value ``True``.\n\n        *   For a selection field like 'module_XXX' composed of 2 string values ('0' and '1'), \n            ``execute`` triggers the immediate installation of the module named 'XXX' \n            if the field has the value ``'1'``.\n\n        *   For a field with no specific prefix BUT an attribute 'config_parameter',\n            ``execute``` will save its value in an ir.config.parameter (global setting for the\n            database).\n\n        *   For the other fields, the method ``execute`` invokes `set_values`.\n            Override it to implement the effect of those fields.\n\n        The method ``default_get`` retrieves values that reflect the current status of the\n        fields like 'default_XXX', 'group_XXX', 'module_XXX' and config_XXX.\n        It also invokes all methods with a name that starts with 'get_default_';\n        such methods can be defined to provide current values for other fields.\n    	t	\N	\N
92	\N	\N	res.currency	active desc, name	base	{"en_US": "Currency"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
93	\N	\N	res.currency.rate	name desc	base	{"en_US": "Currency Rate"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
94	\N	\N	res.company	sequence, name	base	{"en_US": "Companies"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
95	\N	\N	res.groups	name	base	{"en_US": "Access Groups"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
96	\N	\N	res.users.log	id desc	base	{"en_US": "Users Log"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
97	\N	\N	res.users	name, login	base	{"en_US": "User"}	 User class. A res.users record models an OpenERP user and is different\n        from an employee.\n\n        res.users class now inherits from res.partner. The partner model is\n        used to store the data related to the partner: lang, name, address,\n        avatar, ... The user model is now dedicated to technical data.\n    	f	\N	\N
98	\N	\N	res.users.identitycheck	id	base	{"en_US": "Password Check Wizard"}	 Wizard used to re-check the user's credentials (password)\n\n    Might be useful before the more security-sensitive operations, users might be\n    leaving their computer unlocked & unattended. Re-checking credentials mitigates\n    some of the risk of a third party using such an unattended device to manipulate\n    the account.\n    	t	\N	\N
99	\N	\N	change.password.wizard	id	base	{"en_US": "Change Password Wizard"}	 A wizard to manage the change of users' passwords. 	t	\N	\N
100	\N	\N	change.password.user	id	base	{"en_US": "User, Change Password Wizard"}	 A model to configure users in the change password wizard. 	t	\N	\N
101	\N	\N	change.password.own	id	base	{"en_US": "User, change own password wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
102	\N	\N	res.users.apikeys	id	base	{"en_US": "Users API Keys"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
103	\N	\N	res.users.apikeys.description	id	base	{"en_US": "API Key Description"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
104	\N	\N	res.users.apikeys.show	id	base	{"en_US": "Show API Key"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N
105	\N	\N	res.users.deletion	id	base	{"en_US": "Users Deletion Request"}	User deletion requests.\n\n    Those requests are logged in a different model to keep a trace of this action and the\n    deletion is done in a CRON. Indeed, removing a user can be a heavy operation on\n    large database (because of create_uid, write_uid on each model, which are not always\n    indexed). This model just remove the users added in the deletion queue, remaining code\n    must deal with other consideration (archiving, blacklist email...).\n    	f	\N	\N
106	\N	\N	decimal.precision	id	base	{"en_US": "Decimal Precision"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
107	\N	\N	report.base.report_irmodulereference	id	base	{"en_US": "Module Reference Report (base)"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N
108	\N	\N	base.module.update	id	base	{"en_US": "Update Module"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
109	\N	\N	base.language.install	id	base	{"en_US": "Install Language"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
110	\N	\N	base.language.import	id	base	{"en_US": "Language Import"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
111	\N	\N	base.module.upgrade	id	base	{"en_US": "Upgrade Module"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
112	\N	\N	base.module.uninstall	id	base	{"en_US": "Module Uninstall"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
113	\N	\N	base.language.export	id	base	{"en_US": "Language Export"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
114	\N	\N	base.partner.merge.line	min_id asc	base	{"en_US": "Merge Partner Line"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
115	\N	\N	base.partner.merge.automatic.wizard	id	base	{"en_US": "Merge Partner Wizard"}	\n        The idea behind this wizard is to create a list of potential partners to\n        merge. We use two objects, the first one is the wizard for the end-user.\n        And the second will contain the partner list to merge.\n    	t	\N	\N
118	\N	\N	auth_totp.device	id	base	{"en_US": "Authentication Device"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
119	\N	\N	auth_totp.wizard	id	base	{"en_US": "2-Factor Setup Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
120	\N	\N	base_import.mapping	id	base	{"en_US": "Base Import Mapping"}	 mapping of previous column:field selections\n\n    This is useful when repeatedly importing from a third-party\n    system: column names generated by the external system may\n    not match Odoo's field names or labels. This model is used\n    to save the mapping between column names and fields so that\n    next time a user imports from the same third-party systems\n    we can automatically match the columns to the correct field\n    without them having to re-enter the mapping every single\n    time.\n    	f	\N	\N
121	\N	\N	base_import.import	id	base	{"en_US": "Base Import"}	\n    This model is used to prepare the loading of data coming from a user file.\n\n    Here is the process that is followed:\n\n    #. The user selects a file to import.\n    #. File parsing and mapping suggestion (see "parse_preview" method)\n\n       #. Extract the current model's importable fields tree (see :meth:`get_fields_tree`).\n       #. Read the file (see :meth:`_read_file`) and extract header names and file\n          length (used for batch import).\n       #. Extract headers types from the data preview (10 first line of the file)\n          (see :meth:`_extract_headers_types`).\n       #. Try to find for each header a field to map with (see :meth:`_get_mapping_suggestions`)\n\n          - First check the previously saved mappings between the header name\n            and one of the model's fields.\n          - If no mapping found, try an exact match comparison using fields\n            technical names, labels and user language translated labels.\n          - If nothing found, try a fuzzy match using word distance between\n            header name and fields tachnical names, labels and user language\n            translated labels. Keep only the closest match.\n\n       #. Prepare examples for each columns using the first non null value from each column.\n       #. Send the info back to the UI where the user can modify the suggested mapping.\n    #. Execute the import: There are two import mode with uses the same process. (see :meth:`execute_import`)\n\n       #. Test import: Try to import but rollback the transaction. This allows\n          the check errors during the import process and allow the user to\n          choose import options for the different encountered errors.\n       #. Real import: Try to import the file using the configured mapping and\n          the eventual "error mapping options". If import encounters blocking\n          errors, the transaction is rollbacked and the user is allowed to\n          choose import options for the different errors.\n\n          - Get file data and fields to import into (see :meth:`_convert_import_data`).\n          - Parse date, float and binary data (see :meth:`_parse_import_data`).\n          - Handle multiple mapping -> concatenate char/text/many2many columns\n            mapped on the same field (see :meth:`_handle_multi_mapping`).\n          - Handle fallback values for boolean and selection fields, in case\n            input data does not match any allowed values (see :meth:`_handle_fallback_values`).\n          - Load data (see ir.model "load" method).\n          - Rollback transaction if test mode or if encountered error.\n          - Save mapping if any import is successful to ease later mapping suggestions.\n          - Return import result to the UI (success or errors if any).\n    	t	\N	\N
122	\N	\N	base_import.tests.models.char	id	base	{"en_US": "Tests : Base Import Model, Character"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
123	\N	\N	base_import.tests.models.char.required	id	base	{"en_US": "Tests : Base Import Model, Character required"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
124	\N	\N	base_import.tests.models.char.readonly	id	base	{"en_US": "Tests : Base Import Model, Character readonly"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
125	\N	\N	base_import.tests.models.char.states	id	base	{"en_US": "Tests : Base Import Model, Character states"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
126	\N	\N	base_import.tests.models.char.noreadonly	id	base	{"en_US": "Tests : Base Import Model, Character No readonly"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
127	\N	\N	base_import.tests.models.char.stillreadonly	id	base	{"en_US": "Tests : Base Import Model, Character still readonly"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
128	\N	\N	base_import.tests.models.m2o	id	base	{"en_US": "Tests : Base Import Model, Many to One"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
129	\N	\N	base_import.tests.models.m2o.related	id	base	{"en_US": "Tests : Base Import Model, Many to One related"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
130	\N	\N	base_import.tests.models.m2o.required	id	base	{"en_US": "Tests : Base Import Model, Many to One required"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
131	\N	\N	base_import.tests.models.m2o.required.related	id	base	{"en_US": "Tests : Base Import Model, Many to One required related"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
132	\N	\N	base_import.tests.models.o2m	id	base	{"en_US": "Tests : Base Import Model, One to Many"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
133	\N	\N	base_import.tests.models.o2m.child	id	base	{"en_US": "Tests : Base Import Model, One to Many child"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
134	\N	\N	base_import.tests.models.preview	id	base	{"en_US": "Tests : Base Import Model Preview"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
135	\N	\N	base_import.tests.models.float	id	base	{"en_US": "Tests: Base Import Model Float"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
136	\N	\N	base_import.tests.models.complex	id	base	{"en_US": "Tests: Base Import Model Complex"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
137	\N	\N	bus.bus	id	base	{"en_US": "Communication Bus"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
138	\N	\N	bus.presence	id	base	{"en_US": "User Presence"}	 User Presence\n        Its status is 'online', 'away' or 'offline'. This model should be a one2one, but is not\n        attached to res_users to avoid database concurrence errors. Since the 'update' method is executed\n        at each poll, if the user have multiple opened tabs, concurrence errors can happend, but are 'muted-logged'.\n    	f	\N	\N
139	\N	\N	ir.websocket	id	base	{"en_US": "websocket message handling"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N
140	\N	\N	web_tour.tour	id	base	{"en_US": "Tours"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
41	\N	\N	ir.qweb	id	base	{"en_US": "Qweb"}	 IrQWeb object for rendering editor stuff\n    	f	\N	\N
142	\N	\N	web_editor.assets	id	base	{"en_US": "Assets Utils"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N
143	\N	\N	web_editor.converter.test	id	base	{"en_US": "Web Editor Converter Test"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
144	\N	\N	web_editor.converter.test.sub	id	base	{"en_US": "Web Editor Converter Subtest"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
\.


--
-- Data for Name: ir_model_access; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_access (id, model_id, group_id, create_uid, write_uid, name, active, perm_read, perm_write, perm_create, perm_unlink, create_date, write_date) FROM stdin;
1	106	4	1	1	decimal.precision configuration	t	t	t	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
2	28	1	1	1	ir_attachment group_user	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
3	28	\N	1	1	ir_attachment group_portal_public	t	f	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
4	30	4	1	1	ir_cron group_cron	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
5	31	4	1	1	ir_cron_trigger group_cron	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
6	34	8	1	1	ir_exports group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
7	35	1	1	1	ir_exports_line group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
8	3	2	1	1	ir_model group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
9	6	2	1	1	ir_model_constraint group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
10	7	2	1	1	ir_model_relation group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
11	8	2	1	1	ir_model_access_group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
12	9	2	1	1	ir_model_data group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
13	4	2	1	1	ir_model_fields group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
14	5	2	1	1	ir_model_fields_selection group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
15	3	1	1	1	ir_model_all	t	f	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
16	9	1	1	1	ir_model_data user	t	f	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
17	4	1	1	1	ir_model_fields all	t	f	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
18	5	1	1	1	ir_model_fields_selection all	t	f	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
19	65	2	1	1	ir_module_category group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
20	66	4	1	1	ir_module_module group_user	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
21	67	4	1	1	ir_module_module_dependency group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
22	68	4	1	1	ir_module_module_exclusion group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
23	64	\N	1	1	ir_property group_user	t	f	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
24	64	4	1	1	ir_property group_system	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
25	36	2	1	1	ir_rule group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
26	11	1	1	1	ir_sequence group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
27	11	4	1	1	ir_sequence group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
28	12	1	1	1	ir_sequence_date_range group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
29	12	4	1	1	ir_sequence_date_range group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
30	13	1	1	1	ir_ui_menu group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
31	13	4	1	1	ir_ui_menu group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
32	15	\N	1	1	ir_ui_view group_user	t	f	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
33	15	4	1	1	ir_ui_view group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
34	16	4	1	1	reset_view_arch_wizard group_system	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
35	14	\N	1	1	ir_ui_view_custom_group_user	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
36	33	\N	1	1	ir_default all	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
37	33	1	1	1	ir_default group_user	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
38	33	4	1	1	ir_default group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
39	94	2	1	1	res_company group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
40	94	\N	1	1	res_company group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
41	78	\N	1	1	res_country group_user_all	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
42	80	\N	1	1	res_country_state group_user_all	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
43	79	\N	1	1	res_country_group group_user_all	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
44	78	9	1	1	res_country group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
45	78	4	1	1	res_country_group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
46	80	9	1	1	res_country_state group_user	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
47	79	9	1	1	res_country_group group_user	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
48	92	\N	1	1	res_currency group_all	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
49	93	\N	1	1	res_currency_rate group_all	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
50	92	4	1	1	res_currency group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
51	93	4	1	1	res_currency_rate group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
52	95	2	1	1	res_groups group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
53	95	1	1	1	res_groups group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
54	81	\N	1	1	res_lang group_all	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
55	81	4	1	1	res_lang group_user	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
56	85	11	1	1	res_partner group_public	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
57	85	10	1	1	res_partner group_portal	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
58	85	9	1	1	res_partner group_partner_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
59	85	1	1	1	res_partner group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
60	88	1	1	1	res_partner_bank group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
61	88	9	1	1	res_partner_bank group_partner_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
62	83	1	1	1	res_partner_category group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
63	83	9	1	1	res_partner_category group_partner_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
64	86	1	1	1	res_partner_industry group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
65	86	4	1	1	res_partner_industry group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
66	84	9	1	1	res_partner_title group_partner_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
67	84	\N	1	1	res_partner_title group_user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
68	97	\N	1	1	res_users all	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
69	97	2	1	1	res_users group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
70	105	\N	1	1	res_users_deletion all	t	f	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
71	105	2	1	1	res_users_deletion group_erp_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
72	96	\N	1	1	res_users_log_all	t	t	f	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
73	98	1	1	1	id check employees	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
74	98	10	1	1	id check portal	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
75	102	1	1	1	API keys access employees	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
76	102	10	1	1	API keys access portal	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
77	103	1	1	1	API key wizard employees	t	t	f	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
78	103	10	1	1	API key wizard	t	t	f	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
79	104	1	1	1	API key result employees	t	t	f	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
80	17	4	1	1	ir_asset_group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
81	18	4	1	1	ir_actions_group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
82	19	4	1	1	ir_actions_act_window_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
83	21	4	1	1	ir_actions_act_window_close_group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
84	27	4	1	1	ir_actions_report_group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
85	25	4	1	1	ir_actions_todo group system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
86	20	4	1	1	ir_actions_act_window_view_group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
87	22	4	1	1	ir_actions_act_url_group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
88	24	4	1	1	ir_server_object_lines_group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
89	23	4	1	1	ir_actions_server_group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
90	26	4	1	1	ir_actions_client all	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
91	87	4	1	1	res_bank_group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
92	87	9	1	1	res_bank_group_partner_manager	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
93	87	1	1	1	res_bank user	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
94	32	2	1	1	ir_filters all	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
95	32	1	1	1	ir_filters all	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
96	32	10	1	1	ir_filters all	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
97	32	11	1	1	ir_filters all	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
98	37	4	1	1	ir_config_parameter_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
99	39	4	1	1	ir_mail_server	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
100	63	2	1	1	ir_logging admin	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
101	73	\N	1	1	ir_actions_report_paperformat group_portal	t	t	f	f	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
102	73	4	1	1	ir_actions_report_paperformat group_system	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
103	72	\N	1	1	access_report_layout	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
104	10	4	1	1	access.wizard.ir.model.menu.create	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
105	16	2	1	1	access.reset.view.arch.wizard	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
106	69	4	1	1	access.ir.demo	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
107	70	4	1	1	access.ir.demo_failure	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
108	71	4	1	1	access.ir.demo_failure.wizard	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
109	89	4	1	1	access.res.config	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
110	90	4	1	1	access.res.config.installer	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
111	91	4	1	1	access.res.config.settings	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
112	99	2	1	1	access.change.password.wizard	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
113	100	2	1	1	access.change.password.user	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
114	101	1	1	1	access.change.password.own	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
115	108	4	1	1	access.base.module.update	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
116	109	4	1	1	access.base.language.install	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
117	110	4	1	1	access.base.language.import	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
118	111	4	1	1	access.base.module.upgrade	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
119	112	4	1	1	access.base.module.uninstall	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
120	113	1	1	1	access.base.language.export	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
121	114	9	1	1	access.base.partner.merge.line	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
122	115	9	1	1	access.base.partner.merge.automatic.wizard	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
123	74	4	1	1	ir_profile	t	t	t	t	t	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
124	75	4	1	1	access.base.enable.profiling.wizard	t	t	t	t	f	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
125	117	4	1	1	access.base.document.layout	t	t	t	t	f	2025-11-06 17:18:07.783695	2025-11-06 17:18:07.783695
126	119	1	1	1	auth_totp wizard access rules	t	t	t	t	t	2025-11-06 17:18:11.586504	2025-11-06 17:18:11.586504
127	118	1	1	1	TOTP Device access employees	t	t	f	f	f	2025-11-06 17:18:11.586504	2025-11-06 17:18:11.586504
128	118	10	1	1	TOTP Device access portal	t	t	f	f	f	2025-11-06 17:18:11.586504	2025-11-06 17:18:11.586504
129	122	1	1	1	base.import.tests.models.char	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
130	123	1	1	1	base.import.tests.models.char.required	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
131	124	1	1	1	base.import.tests.models.char.readonly	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
132	125	1	1	1	base.import.tests.models.char.states	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
133	126	1	1	1	base.import.tests.models.char.noreadonly	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
134	127	1	1	1	base.import.tests.models.char.stillreadonly	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
135	128	1	1	1	base.import.tests.models.m2o	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
136	129	1	1	1	base.import.tests.models.m2o.related	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
137	130	1	1	1	base.import.tests.models.m2o.required	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
138	131	1	1	1	base.import.tests.models.m2o.required.related	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
139	132	1	1	1	base.import.tests.models.o2m	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
140	133	1	1	1	base.import.tests.models.o2m.child	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
141	135	1	1	1	base.import.tests.models.float	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
142	134	1	1	1	base.import.tests.models.preview	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
143	120	1	1	1	base.import.mapping	t	t	t	t	t	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
144	136	1	1	1	access_base_import_tests_models_complex	t	t	f	f	f	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
145	121	1	1	1	access.base_import.import	t	t	t	t	f	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
146	137	\N	1	1	bus.bus public	t	f	f	f	f	2025-11-06 17:18:13.114059	2025-11-06 17:18:13.114059
147	138	1	1	1	bus.presence	t	t	t	t	t	2025-11-06 17:18:13.114059	2025-11-06 17:18:13.114059
148	138	10	1	1	bus.presence	t	t	t	t	t	2025-11-06 17:18:13.114059	2025-11-06 17:18:13.114059
149	140	4	1	1	access_web_tour_tour_admin	t	t	f	t	f	2025-11-06 17:18:13.404714	2025-11-06 17:18:13.404714
150	140	\N	1	1	access_web_tour_tour	t	t	f	f	f	2025-11-06 17:18:13.404714	2025-11-06 17:18:13.404714
151	143	\N	1	1	access_web_editor_converter_test	t	t	t	t	t	2025-11-06 17:18:13.563663	2025-11-06 17:18:13.563663
152	144	\N	1	1	access_web_editor_converter_test_sub	t	t	t	t	t	2025-11-06 17:18:13.563663	2025-11-06 17:18:13.563663
\.


--
-- Data for Name: ir_model_constraint; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_constraint (id, model, module, create_uid, write_uid, name, definition, type, message, write_date, create_date) FROM stdin;
1	3	224	1	1	ir_model_obj_name_uniq	unique(model)	u	{"en_US": "Each model must have a unique name."}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
2	4	224	1	1	ir_model_fields_name_unique	unique(model,name)	u	{"en_US": "Field names must be unique per model."}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
3	4	224	1	1	ir_model_fields_size_gt_zero	check(size>=0)	u	{"en_US": "Size of the field cannot be negative."}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
4	5	224	1	1	ir_model_fields_selection_selection_field_uniq	unique(field_id,value)	u	{"en_US": "Selections values must be unique per field"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
5	6	224	1	1	ir_model_constraint_module_name_uniq	unique(name,module)	u	{"en_US": "Constraints with the same name are unique per module."}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
6	9	224	1	1	ir_model_data_name_nospaces	check(name not like '% %')	u	{"en_US": "External IDs cannot contain spaces"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
7	12	224	1	1	ir_sequence_date_range_unique_range_per_sequence	unique(sequence_id,date_from,date_to)	u	{"en_US": "You cannot create two date ranges for the same sequence with the same date range."}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
8	15	224	1	1	ir_ui_view_inheritance_mode	check(mode != 'extension' or inherit_id is not null)	u	{"en_US": "Invalid inheritance mode: if the mode is 'extension', the view must extend an other view"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
9	15	224	1	1	ir_ui_view_qweb_required_key	check(type != 'qweb' or key is not null)	u	{"en_US": "Invalid key: QWeb view should have a key"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
10	32	224	1	1	ir_filters_name_model_uid_unique	unique(model_id,user_id,action_id,name)	u	{"en_US": "Filter names must be unique"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
11	36	224	1	1	ir_rule_no_access_rights	check(perm_read!=false or perm_write!=false or perm_create!=false or perm_unlink!=false)	u	{"en_US": "Rule must have at least one checked access right !"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
12	37	224	1	1	ir_config_parameter_key_uniq	unique(key)	u	{"en_US": "Key must be unique."}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
13	66	224	1	1	ir_module_module_name_uniq	unique(name)	u	{"en_US": "The name of the module must be unique!"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
14	78	224	1	1	res_country_name_uniq	unique(name)	u	{"en_US": "The name of the country must be unique !"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
15	78	224	1	1	res_country_code_uniq	unique(code)	u	{"en_US": "The code of the country must be unique !"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
16	80	224	1	1	res_country_state_name_code_uniq	unique(country_id,code)	u	{"en_US": "The code of the state must be unique by country !"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
17	81	224	1	1	res_lang_name_uniq	unique(name)	u	{"en_US": "The name of the language must be unique !"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
18	81	224	1	1	res_lang_code_uniq	unique(code)	u	{"en_US": "The code of the language must be unique !"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
19	81	224	1	1	res_lang_url_code_uniq	unique(url_code)	u	{"en_US": "The URL code of the language must be unique !"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
20	85	224	1	1	res_partner_check_name	check((type='contact' and name is not null) or(type!='contact') )	u	{"en_US": "Contacts require a name"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
21	88	224	1	1	res_partner_bank_unique_number	unique(sanitized_acc_number,partner_id)	u	{"en_US": "The combination Account Number/Partner must be unique."}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
22	92	224	1	1	res_currency_unique_name	unique(name)	u	{"en_US": "The currency code must be unique!"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
23	92	224	1	1	res_currency_rounding_gt_zero	check(rounding>0)	u	{"en_US": "The rounding factor must be greater than 0!"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
24	93	224	1	1	res_currency_rate_unique_name_per_day	unique(name,currency_id,company_id)	u	{"en_US": "Only one currency rate per day allowed!"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
25	93	224	1	1	res_currency_rate_currency_rate_check	check(rate>0)	u	{"en_US": "The currency rate must be strictly positive."}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
26	94	224	1	1	res_company_name_uniq	unique(name)	u	{"en_US": "The company name must be unique !"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
27	95	224	1	1	res_groups_name_uniq	unique(category_id,name)	u	{"en_US": "The name of the group must be unique within an application!"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
28	97	224	1	1	res_users_login_key	unique(login)	u	{"en_US": "You can not have two users with the same login !"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
29	106	224	1	1	decimal_precision_name_uniq	unique(name)	u	{"en_US": "Only one value can be defined for each given usage!"}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
30	3	224	1	1	ir_model_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
31	3	224	1	1	ir_model_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
32	4	224	1	1	ir_model_fields_group_rel_field_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
33	4	224	1	1	ir_model_fields_group_rel_group_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
34	4	224	1	1	ir_model_fields_relation_field_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
35	4	224	1	1	ir_model_fields_model_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
36	4	224	1	1	ir_model_fields_related_field_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
37	4	224	1	1	ir_model_fields_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
38	4	224	1	1	ir_model_fields_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
39	5	224	1	1	ir_model_fields_selection_field_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
40	5	224	1	1	ir_model_fields_selection_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
41	5	224	1	1	ir_model_fields_selection_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
42	6	224	1	1	ir_model_constraint_model_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
43	6	224	1	1	ir_model_constraint_module_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
44	6	224	1	1	ir_model_constraint_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
45	6	224	1	1	ir_model_constraint_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
46	7	224	1	1	ir_model_relation_model_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
47	7	224	1	1	ir_model_relation_module_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
48	7	224	1	1	ir_model_relation_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
49	7	224	1	1	ir_model_relation_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
50	8	224	1	1	ir_model_access_model_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
51	8	224	1	1	ir_model_access_group_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
52	8	224	1	1	ir_model_access_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
53	8	224	1	1	ir_model_access_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
54	9	224	1	1	ir_model_data_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
55	9	224	1	1	ir_model_data_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
56	10	224	1	1	wizard_ir_model_menu_create_menu_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
57	10	224	1	1	wizard_ir_model_menu_create_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
58	10	224	1	1	wizard_ir_model_menu_create_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
59	11	224	1	1	ir_sequence_company_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
60	11	224	1	1	ir_sequence_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
61	11	224	1	1	ir_sequence_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
62	12	224	1	1	ir_sequence_date_range_sequence_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
63	12	224	1	1	ir_sequence_date_range_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
64	12	224	1	1	ir_sequence_date_range_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
65	95	224	1	1	ir_ui_menu_group_rel_menu_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
66	13	224	1	1	ir_ui_menu_group_rel_gid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
67	13	224	1	1	ir_ui_menu_parent_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
68	13	224	1	1	ir_ui_menu_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
69	13	224	1	1	ir_ui_menu_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
70	14	224	1	1	ir_ui_view_custom_ref_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
71	14	224	1	1	ir_ui_view_custom_user_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
72	14	224	1	1	ir_ui_view_custom_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
73	14	224	1	1	ir_ui_view_custom_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
74	95	224	1	1	ir_ui_view_group_rel_view_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
75	15	224	1	1	ir_ui_view_group_rel_group_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
76	15	224	1	1	ir_ui_view_inherit_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
77	15	224	1	1	ir_ui_view_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
78	15	224	1	1	ir_ui_view_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
79	16	224	1	1	reset_view_arch_wizard_view_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
80	16	224	1	1	reset_view_arch_wizard_compare_view_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
81	16	224	1	1	reset_view_arch_wizard_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
82	16	224	1	1	reset_view_arch_wizard_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
83	17	224	1	1	ir_asset_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
84	17	224	1	1	ir_asset_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
85	21	224	1	1	ir_actions_binding_model_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
86	21	224	1	1	ir_actions_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
87	21	224	1	1	ir_actions_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
88	19	224	1	1	ir_act_window_group_rel_act_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
89	19	224	1	1	ir_act_window_group_rel_gid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
90	19	224	1	1	ir_act_window_binding_model_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
91	19	224	1	1	ir_act_window_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
92	19	224	1	1	ir_act_window_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
93	19	224	1	1	ir_act_window_view_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
94	19	224	1	1	ir_act_window_search_view_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
95	20	224	1	1	ir_act_window_view_view_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
96	20	224	1	1	ir_act_window_view_act_window_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
97	20	224	1	1	ir_act_window_view_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
98	20	224	1	1	ir_act_window_view_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
99	22	224	1	1	ir_act_url_binding_model_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
100	22	224	1	1	ir_act_url_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
101	22	224	1	1	ir_act_url_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
102	23	224	1	1	rel_server_actions_server_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
103	23	224	1	1	rel_server_actions_action_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
104	23	224	1	1	ir_act_server_group_rel_act_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
105	23	224	1	1	ir_act_server_group_rel_gid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
106	23	224	1	1	ir_act_server_binding_model_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
107	23	224	1	1	ir_act_server_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
108	23	224	1	1	ir_act_server_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
109	23	224	1	1	ir_act_server_model_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
110	23	224	1	1	ir_act_server_crud_model_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
111	23	224	1	1	ir_act_server_link_field_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
112	24	224	1	1	ir_server_object_lines_server_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
113	24	224	1	1	ir_server_object_lines_col1_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
114	24	224	1	1	ir_server_object_lines_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
115	24	224	1	1	ir_server_object_lines_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
116	25	224	1	1	ir_actions_todo_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
117	25	224	1	1	ir_actions_todo_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
118	26	224	1	1	ir_act_client_binding_model_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
119	26	224	1	1	ir_act_client_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
120	26	224	1	1	ir_act_client_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
121	27	224	1	1	res_groups_report_rel_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
122	27	224	1	1	res_groups_report_rel_gid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
123	27	224	1	1	ir_act_report_xml_binding_model_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
124	27	224	1	1	ir_act_report_xml_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
125	27	224	1	1	ir_act_report_xml_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
126	27	224	1	1	ir_act_report_xml_paperformat_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
127	28	224	1	1	ir_attachment_company_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
128	28	224	1	1	ir_attachment_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
129	28	224	1	1	ir_attachment_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
130	30	224	1	1	ir_cron_ir_actions_server_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
131	30	224	1	1	ir_cron_user_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
132	30	224	1	1	ir_cron_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
133	30	224	1	1	ir_cron_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
134	31	224	1	1	ir_cron_trigger_cron_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
135	31	224	1	1	ir_cron_trigger_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
136	31	224	1	1	ir_cron_trigger_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
137	32	224	1	1	ir_filters_user_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
138	32	224	1	1	ir_filters_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
139	32	224	1	1	ir_filters_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
140	33	224	1	1	ir_default_field_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
141	33	224	1	1	ir_default_user_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
142	33	224	1	1	ir_default_company_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
143	33	224	1	1	ir_default_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
144	33	224	1	1	ir_default_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
145	34	224	1	1	ir_exports_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
146	34	224	1	1	ir_exports_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
147	35	224	1	1	ir_exports_line_export_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
148	35	224	1	1	ir_exports_line_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
149	35	224	1	1	ir_exports_line_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
150	95	224	1	1	rule_group_rel_rule_group_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
151	36	224	1	1	rule_group_rel_group_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
152	36	224	1	1	ir_rule_model_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
153	36	224	1	1	ir_rule_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
154	36	224	1	1	ir_rule_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
155	37	224	1	1	ir_config_parameter_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
156	37	224	1	1	ir_config_parameter_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
157	39	224	1	1	ir_mail_server_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
158	39	224	1	1	ir_mail_server_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
159	64	224	1	1	ir_property_company_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
160	64	224	1	1	ir_property_fields_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
161	64	224	1	1	ir_property_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
162	64	224	1	1	ir_property_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
163	65	224	1	1	ir_module_category_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
164	65	224	1	1	ir_module_category_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
165	66	224	1	1	ir_module_module_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
166	66	224	1	1	ir_module_module_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
167	68	224	1	1	ir_module_module_exclusion_module_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
168	68	224	1	1	ir_module_module_exclusion_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
169	68	224	1	1	ir_module_module_exclusion_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
170	69	224	1	1	ir_demo_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
171	69	224	1	1	ir_demo_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
172	70	224	1	1	ir_demo_failure_module_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
173	70	224	1	1	ir_demo_failure_wizard_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
174	70	224	1	1	ir_demo_failure_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
175	70	224	1	1	ir_demo_failure_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
176	71	224	1	1	ir_demo_failure_wizard_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
177	71	224	1	1	ir_demo_failure_wizard_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
178	72	224	1	1	report_layout_view_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
179	72	224	1	1	report_layout_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
180	72	224	1	1	report_layout_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
181	73	224	1	1	report_paperformat_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
182	73	224	1	1	report_paperformat_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
183	75	224	1	1	base_enable_profiling_wizard_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
184	75	224	1	1	base_enable_profiling_wizard_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
185	79	224	1	1	res_country_res_country_group_rel_res_country_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
186	78	224	1	1	res_country_res_country_group_rel_res_country_group_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
187	78	224	1	1	res_country_address_view_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
188	78	224	1	1	res_country_currency_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
189	78	224	1	1	res_country_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
190	78	224	1	1	res_country_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
191	79	224	1	1	res_country_group_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
192	79	224	1	1	res_country_group_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
193	80	224	1	1	res_country_state_country_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
194	80	224	1	1	res_country_state_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
195	80	224	1	1	res_country_state_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
196	81	224	1	1	res_lang_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
197	81	224	1	1	res_lang_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
198	85	224	1	1	res_partner_res_partner_category_rel_category_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
199	83	224	1	1	res_partner_res_partner_category_rel_partner_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
200	83	224	1	1	res_partner_category_parent_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
201	83	224	1	1	res_partner_category_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
202	83	224	1	1	res_partner_category_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
203	84	224	1	1	res_partner_title_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
204	84	224	1	1	res_partner_title_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
205	85	224	1	1	res_partner_title_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
206	85	224	1	1	res_partner_parent_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
207	85	224	1	1	res_partner_user_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
208	85	224	1	1	res_partner_state_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
209	85	224	1	1	res_partner_country_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
210	85	224	1	1	res_partner_industry_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
211	85	224	1	1	res_partner_company_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
212	85	224	1	1	res_partner_commercial_partner_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
213	85	224	1	1	res_partner_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
214	85	224	1	1	res_partner_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
215	86	224	1	1	res_partner_industry_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
216	86	224	1	1	res_partner_industry_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
217	87	224	1	1	res_bank_state_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
218	87	224	1	1	res_bank_country_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
219	87	224	1	1	res_bank_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
220	87	224	1	1	res_bank_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
221	88	224	1	1	res_partner_bank_partner_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
222	88	224	1	1	res_partner_bank_bank_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
223	88	224	1	1	res_partner_bank_currency_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
224	88	224	1	1	res_partner_bank_company_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
225	88	224	1	1	res_partner_bank_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
226	88	224	1	1	res_partner_bank_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
227	89	224	1	1	res_config_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
228	89	224	1	1	res_config_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
229	90	224	1	1	res_config_installer_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
230	90	224	1	1	res_config_installer_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
231	91	224	1	1	res_config_settings_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
232	91	224	1	1	res_config_settings_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
233	92	224	1	1	res_currency_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
234	92	224	1	1	res_currency_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
235	93	224	1	1	res_currency_rate_currency_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
236	93	224	1	1	res_currency_rate_company_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
237	93	224	1	1	res_currency_rate_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
238	93	224	1	1	res_currency_rate_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
239	97	224	1	1	res_company_users_rel_cid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
240	94	224	1	1	res_company_users_rel_user_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
241	94	224	1	1	res_company_parent_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
242	94	224	1	1	res_company_partner_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
243	94	224	1	1	res_company_currency_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
244	94	224	1	1	res_company_paperformat_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
245	94	224	1	1	res_company_external_report_layout_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
246	94	224	1	1	res_company_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
247	94	224	1	1	res_company_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
248	97	224	1	1	res_groups_users_rel_gid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
249	95	224	1	1	res_groups_users_rel_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
250	95	224	1	1	res_groups_implied_rel_gid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
251	95	224	1	1	res_groups_implied_rel_hid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
252	95	224	1	1	res_groups_category_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
253	95	224	1	1	res_groups_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
254	95	224	1	1	res_groups_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
255	96	224	1	1	res_users_log_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
256	96	224	1	1	res_users_log_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
257	97	224	1	1	res_users_partner_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
258	97	224	1	1	res_users_company_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
259	97	224	1	1	res_users_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
260	97	224	1	1	res_users_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
261	98	224	1	1	res_users_identitycheck_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
262	98	224	1	1	res_users_identitycheck_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
263	99	224	1	1	change_password_wizard_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
264	99	224	1	1	change_password_wizard_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
265	100	224	1	1	change_password_user_wizard_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
266	100	224	1	1	change_password_user_user_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
267	100	224	1	1	change_password_user_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
268	100	224	1	1	change_password_user_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
269	101	224	1	1	change_password_own_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
270	101	224	1	1	change_password_own_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
271	103	224	1	1	res_users_apikeys_description_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
272	103	224	1	1	res_users_apikeys_description_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
273	105	224	1	1	res_users_deletion_user_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
274	105	224	1	1	res_users_deletion_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
275	105	224	1	1	res_users_deletion_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
276	106	224	1	1	decimal_precision_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
277	106	224	1	1	decimal_precision_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
278	108	224	1	1	base_module_update_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
279	108	224	1	1	base_module_update_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
280	109	224	1	1	res_lang_install_rel_language_wizard_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
281	109	224	1	1	res_lang_install_rel_lang_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
282	109	224	1	1	base_language_install_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
283	109	224	1	1	base_language_install_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
284	110	224	1	1	base_language_import_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
285	110	224	1	1	base_language_import_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
286	111	224	1	1	base_module_upgrade_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
287	111	224	1	1	base_module_upgrade_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
288	112	224	1	1	base_module_uninstall_module_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
289	112	224	1	1	base_module_uninstall_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
290	112	224	1	1	base_module_uninstall_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
291	113	224	1	1	rel_modules_langexport_wiz_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
292	113	224	1	1	rel_modules_langexport_module_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
293	113	224	1	1	base_language_export_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
294	113	224	1	1	base_language_export_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
295	114	224	1	1	base_partner_merge_line_wizard_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
296	114	224	1	1	base_partner_merge_line_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
297	114	224	1	1	base_partner_merge_line_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
298	115	224	1	1	base_partner_merge_automatic__base_partner_merge_automatic_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
299	115	224	1	1	base_partner_merge_automatic_wizard_res_par_res_partner_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
300	115	224	1	1	base_partner_merge_automatic_wizard_current_line_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
301	115	224	1	1	base_partner_merge_automatic_wizard_dst_partner_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
302	115	224	1	1	base_partner_merge_automatic_wizard_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
303	115	224	1	1	base_partner_merge_automatic_wizard_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888
304	117	1165	1	1	base_document_layout_company_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:07.783695	2025-11-06 17:18:07.783695
305	117	1165	1	1	base_document_layout_report_layout_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:07.783695	2025-11-06 17:18:07.783695
306	117	1165	1	1	base_document_layout_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:07.783695	2025-11-06 17:18:07.783695
307	117	1165	1	1	base_document_layout_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:07.783695	2025-11-06 17:18:07.783695
308	119	213	1	1	auth_totp_wizard_user_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.586504	2025-11-06 17:18:11.586504
309	119	213	1	1	auth_totp_wizard_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.586504	2025-11-06 17:18:11.586504
310	119	213	1	1	auth_totp_wizard_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.586504	2025-11-06 17:18:11.586504
311	120	249	1	1	base_import_mapping_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
312	120	249	1	1	base_import_mapping_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
313	121	249	1	1	base_import_import_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
314	121	249	1	1	base_import_import_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
315	122	249	1	1	base_import_tests_models_char_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
316	122	249	1	1	base_import_tests_models_char_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
317	123	249	1	1	base_import_tests_models_char_required_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
318	123	249	1	1	base_import_tests_models_char_required_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
319	124	249	1	1	base_import_tests_models_char_readonly_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
320	124	249	1	1	base_import_tests_models_char_readonly_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
321	125	249	1	1	base_import_tests_models_char_states_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
322	125	249	1	1	base_import_tests_models_char_states_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
323	126	249	1	1	base_import_tests_models_char_noreadonly_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
324	126	249	1	1	base_import_tests_models_char_noreadonly_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
325	127	249	1	1	base_import_tests_models_char_stillreadonly_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
326	127	249	1	1	base_import_tests_models_char_stillreadonly_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
327	128	249	1	1	base_import_tests_models_m2o_value_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
328	128	249	1	1	base_import_tests_models_m2o_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
329	128	249	1	1	base_import_tests_models_m2o_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
330	129	249	1	1	base_import_tests_models_m2o_related_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
331	129	249	1	1	base_import_tests_models_m2o_related_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
332	130	249	1	1	base_import_tests_models_m2o_required_value_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
333	130	249	1	1	base_import_tests_models_m2o_required_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
334	130	249	1	1	base_import_tests_models_m2o_required_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
335	131	249	1	1	base_import_tests_models_m2o_required_related_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
336	131	249	1	1	base_import_tests_models_m2o_required_related_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
337	132	249	1	1	base_import_tests_models_o2m_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
338	132	249	1	1	base_import_tests_models_o2m_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
339	133	249	1	1	base_import_tests_models_o2m_child_parent_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
340	133	249	1	1	base_import_tests_models_o2m_child_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
341	133	249	1	1	base_import_tests_models_o2m_child_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
342	134	249	1	1	base_import_tests_models_preview_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
343	134	249	1	1	base_import_tests_models_preview_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
344	135	249	1	1	base_import_tests_models_float_currency_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
345	135	249	1	1	base_import_tests_models_float_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
346	135	249	1	1	base_import_tests_models_float_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
347	136	249	1	1	base_import_tests_models_complex_currency_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
348	136	249	1	1	base_import_tests_models_complex_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
349	136	249	1	1	base_import_tests_models_complex_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:11.806566	2025-11-06 17:18:11.806566
350	137	303	1	1	bus_bus_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:13.114059	2025-11-06 17:18:13.114059
351	137	303	1	1	bus_bus_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:13.114059	2025-11-06 17:18:13.114059
352	138	303	1	1	bus_presence_user_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:13.114059	2025-11-06 17:18:13.114059
353	140	1220	1	1	web_tour_tour_user_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:13.404714	2025-11-06 17:18:13.404714
354	28	1180	1	1	ir_attachment_original_id_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:13.563663	2025-11-06 17:18:13.563663
355	143	1180	1	1	web_editor_converter_test_many2one_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:13.563663	2025-11-06 17:18:13.563663
356	143	1180	1	1	web_editor_converter_test_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:13.563663	2025-11-06 17:18:13.563663
357	143	1180	1	1	web_editor_converter_test_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:13.563663	2025-11-06 17:18:13.563663
358	144	1180	1	1	web_editor_converter_test_sub_create_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:13.563663	2025-11-06 17:18:13.563663
359	144	1180	1	1	web_editor_converter_test_sub_write_uid_fkey	\N	f	{"en_US": null}	2025-11-06 17:18:13.563663	2025-11-06 17:18:13.563663
\.


--
-- Data for Name: ir_model_data; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_data (id, create_uid, create_date, write_date, write_uid, res_id, noupdate, name, module, model) FROM stdin;
8	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	module_account	base	ir.module.module
9	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	t	module_category_uncategorized	base	ir.module.category
10	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	t	module_account_account_tag_code	base	ir.module.module
11	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	t	module_account_analytic_account_tag	base	ir.module.module
12	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	t	module_account_analytic_distribution_manual	base	ir.module.module
13	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	t	module_account_analytic_document_date	base	ir.module.module
14	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	t	module_category_analytic_accounting	base	ir.module.category
15	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	t	module_account_analytic_organization	base	ir.module.module
16	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	t	module_category_accounting_and_finance	base	ir.module.category
17	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	t	module_account_analytic_parent	base	ir.module.module
18	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	t	module_account_analytic_required	base	ir.module.module
19	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	t	module_category_account	base	ir.module.category
20	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	t	module_account_analytic_root	base	ir.module.module
21	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	t	module_account_analytic_sequence	base	ir.module.module
22	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	11	t	module_account_analytic_tag	base	ir.module.module
23	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	t	module_account_analytic_tag_distribution	base	ir.module.module
24	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	13	t	module_account_asset_batch_compute	base	ir.module.module
25	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	14	t	module_account_asset_low_value	base	ir.module.module
26	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	15	t	module_account_asset_management	base	ir.module.module
27	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	16	t	module_account_asset_management_stock_lot	base	ir.module.module
28	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	17	t	module_account_asset_number	base	ir.module.module
29	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	18	t	module_account_asset_transfer	base	ir.module.module
30	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	t	module_category_invoices_and_payments	base	ir.module.category
31	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	19	t	module_account_bank_statement_chatter	base	ir.module.module
32	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	20	t	module_account_billing	base	ir.module.module
33	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	21	t	module_account_cash_deposit	base	ir.module.module
34	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	22	t	module_account_chart_update	base	ir.module.module
35	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	23	t	module_account_chart_update_l10n_eu_oss_oca	base	ir.module.module
36	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	24	t	module_account_chart_update_multilang	base	ir.module.module
37	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	25	t	module_account_check_printing	base	ir.module.module
38	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	26	t	module_account_cutoff_accrual_order_base	base	ir.module.module
39	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	27	t	module_account_cutoff_accrual_order_stock_base	base	ir.module.module
40	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	28	t	module_account_cutoff_accrual_purchase	base	ir.module.module
41	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	29	t	module_account_cutoff_accrual_purchase_stock	base	ir.module.module
42	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	30	t	module_account_cutoff_accrual_sale	base	ir.module.module
43	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	31	t	module_account_cutoff_accrual_sale_stock	base	ir.module.module
44	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	32	t	module_account_cutoff_accrual_sale_stock_delivery	base	ir.module.module
45	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	33	t	module_account_cutoff_accrual_subscription	base	ir.module.module
46	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	34	t	module_account_cutoff_base	base	ir.module.module
47	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	35	t	module_account_cutoff_picking	base	ir.module.module
48	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	36	t	module_account_cutoff_start_end_dates	base	ir.module.module
49	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	37	t	module_account_dashboard_banner	base	ir.module.module
50	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	38	t	module_account_debit_note	base	ir.module.module
51	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	39	t	module_account_edi	base	ir.module.module
52	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	40	t	module_account_edi_proxy_client	base	ir.module.module
53	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	41	t	module_account_edi_ubl_cii	base	ir.module.module
54	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	42	t	module_account_edi_ubl_cii_tax_extension	base	ir.module.module
55	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	t	module_category_reporting	base	ir.module.category
56	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	43	t	module_account_financial_report	base	ir.module.module
57	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	44	t	module_account_financial_report_sale	base	ir.module.module
58	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	45	t	module_account_fiscal_month	base	ir.module.module
59	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	46	t	module_account_fiscal_position_vat_check	base	ir.module.module
60	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	47	t	module_account_fiscal_year	base	ir.module.module
61	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	48	t	module_account_fiscal_year_auto_create	base	ir.module.module
62	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	49	t	module_account_fiscal_year_closing	base	ir.module.module
63	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	50	t	module_account_fleet	base	ir.module.module
64	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	51	t	module_account_global_discount	base	ir.module.module
65	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	52	t	module_account_in_payment	base	ir.module.module
66	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	53	t	module_account_invoice_alternate_payer	base	ir.module.module
1	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	EUR	base	res.currency
67	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	54	t	module_account_invoice_block_payment	base	ir.module.module
68	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	55	t	module_account_invoice_blocking	base	ir.module.module
69	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	56	t	module_account_invoice_change_currency	base	ir.module.module
70	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	57	t	module_account_invoice_check_picking_date	base	ir.module.module
71	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	58	t	module_account_invoice_check_total	base	ir.module.module
72	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	59	t	module_account_invoice_clearing	base	ir.module.module
73	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	60	t	module_account_invoice_constraint_chronology	base	ir.module.module
74	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	61	t	module_account_invoice_crm_tag	base	ir.module.module
75	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	62	t	module_account_invoice_currency_taxes	base	ir.module.module
76	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	63	t	module_account_invoice_customer_no_autofollow	base	ir.module.module
77	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	64	t	module_account_invoice_date_due	base	ir.module.module
78	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	t	module_category_invoicing	base	ir.module.category
79	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	65	t	module_account_invoice_default_code_column	base	ir.module.module
80	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	66	t	module_account_invoice_discount_date	base	ir.module.module
81	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	67	t	module_account_invoice_discount_display_amount	base	ir.module.module
82	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	68	t	module_account_invoice_fiscal_position_update	base	ir.module.module
83	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	69	t	module_account_invoice_fixed_discount	base	ir.module.module
84	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	70	t	module_account_invoice_force_number	base	ir.module.module
85	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	71	t	module_account_invoice_google_document_ai	base	ir.module.module
86	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	72	t	module_account_invoice_line_default_account	base	ir.module.module
87	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	73	t	module_account_invoice_mass_sending	base	ir.module.module
88	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	t	module_category_finance	base	ir.module.category
89	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	74	t	module_account_invoice_merge	base	ir.module.module
90	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	75	t	module_account_invoice_partner_reference	base	ir.module.module
91	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	76	t	module_account_invoice_payment_retention	base	ir.module.module
92	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	77	t	module_account_invoice_payment_term_date_due	base	ir.module.module
93	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	78	t	module_account_invoice_pricelist	base	ir.module.module
95	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	79	t	module_account_invoice_pricelist_sale	base	ir.module.module
96	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	80	t	module_account_invoice_recipient_bank_currency	base	ir.module.module
97	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	81	t	module_account_invoice_refund_code	base	ir.module.module
98	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	82	t	module_account_invoice_refund_line_selection	base	ir.module.module
99	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	83	t	module_account_invoice_refund_link	base	ir.module.module
100	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	84	t	module_account_invoice_refund_reason	base	ir.module.module
101	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	85	t	module_account_invoice_refund_reason_skip_anglo_saxon	base	ir.module.module
102	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	86	t	module_account_invoice_refund_reinvoice	base	ir.module.module
103	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	87	t	module_account_invoice_section_sale_order	base	ir.module.module
104	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	88	t	module_account_invoice_show_currency_rate	base	ir.module.module
105	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	89	t	module_account_invoice_start_end_dates	base	ir.module.module
106	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	90	t	module_account_invoice_start_end_dates_move	base	ir.module.module
107	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	91	t	module_account_invoice_supplier_ref_unique	base	ir.module.module
108	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	92	t	module_account_invoice_supplier_self_invoice	base	ir.module.module
109	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	93	t	module_account_invoice_supplierinfo_update	base	ir.module.module
110	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	94	t	module_account_invoice_supplierinfo_update_discount	base	ir.module.module
111	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	95	t	module_account_invoice_supplierinfo_update_qty_multiplier	base	ir.module.module
112	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	96	t	module_account_invoice_supplierinfo_update_triple_discount	base	ir.module.module
113	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	t	module_category_localization_	base	ir.module.category
114	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	13	t	module_category_localization___accounting	base	ir.module.category
115	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	97	t	module_account_invoice_tax_note	base	ir.module.module
116	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	98	t	module_account_invoice_tax_required	base	ir.module.module
117	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	99	t	module_account_invoice_transmit_method	base	ir.module.module
118	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	100	t	module_account_invoice_tree_currency	base	ir.module.module
119	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	101	t	module_account_invoice_triple_discount	base	ir.module.module
120	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	102	t	module_account_invoice_uom_column	base	ir.module.module
121	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	103	t	module_account_invoice_validation_queued	base	ir.module.module
122	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	104	t	module_account_invoice_warn_message	base	ir.module.module
123	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	105	t	module_account_journal_general_sequence	base	ir.module.module
124	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	106	t	module_account_journal_lock_date	base	ir.module.module
125	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	107	t	module_account_journal_restrict_mode	base	ir.module.module
126	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	108	t	module_account_liquidity_forecast	base	ir.module.module
127	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	109	t	module_account_loan	base	ir.module.module
128	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	110	t	module_account_lock	base	ir.module.module
129	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	111	t	module_account_lock_date_update	base	ir.module.module
130	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	112	t	module_account_lock_to_date	base	ir.module.module
131	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	113	t	module_account_mail_autosubscribe	base	ir.module.module
132	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	114	t	module_account_mass_reconcile	base	ir.module.module
133	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	115	t	module_account_menu_invoice_refund	base	ir.module.module
134	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	116	t	module_account_move_auto_post_ref	base	ir.module.module
135	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	117	t	module_account_move_base_import	base	ir.module.module
136	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	118	t	module_account_move_budget	base	ir.module.module
138	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	119	t	module_account_move_cancel_confirm	base	ir.module.module
139	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	120	t	module_account_move_fiscal_month	base	ir.module.module
140	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	121	t	module_account_move_fiscal_year	base	ir.module.module
141	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	122	t	module_account_move_line_check_number	base	ir.module.module
142	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	15	t	module_category_generic	base	ir.module.category
143	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	123	t	module_account_move_line_landed_cost_info	base	ir.module.module
144	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	124	t	module_account_move_line_product	base	ir.module.module
145	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	125	t	module_account_move_line_purchase_info	base	ir.module.module
146	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	126	t	module_account_move_line_reconcile_manual	base	ir.module.module
147	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	127	t	module_account_move_line_repair_info	base	ir.module.module
148	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	128	t	module_account_move_line_sale_info	base	ir.module.module
149	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	16	t	module_category_warehouse_management	base	ir.module.category
150	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	129	t	module_account_move_line_stock_info	base	ir.module.module
151	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	130	t	module_account_move_line_tax_editable	base	ir.module.module
152	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	131	t	module_account_move_name_sequence	base	ir.module.module
153	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	132	t	module_account_move_post_date_user	base	ir.module.module
154	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	133	t	module_account_move_print	base	ir.module.module
155	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	134	t	module_account_move_reconcile_forbid_cancel	base	ir.module.module
156	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	135	t	module_account_move_reconcile_helper	base	ir.module.module
157	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	136	t	module_account_move_sent_usability	base	ir.module.module
158	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	137	t	module_account_move_so_import	base	ir.module.module
159	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	138	t	module_account_move_substate	base	ir.module.module
160	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	139	t	module_account_move_template	base	ir.module.module
161	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	17	t	module_category_accounts	base	ir.module.category
162	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	140	t	module_account_move_tier_validation	base	ir.module.module
163	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	141	t	module_account_move_transfer_partner	base	ir.module.module
164	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	142	t	module_account_move_update_analytic	base	ir.module.module
165	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	143	t	module_account_multicurrency_revaluation	base	ir.module.module
166	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	144	t	module_account_netting	base	ir.module.module
167	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	145	t	module_account_operating_unit	base	ir.module.module
168	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	146	t	module_account_partner_reconcile	base	ir.module.module
169	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	147	t	module_account_partner_required	base	ir.module.module
170	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	148	t	module_account_payment	base	ir.module.module
171	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	149	t	module_account_payment_invoice_online_payment_patch	base	ir.module.module
172	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	150	t	module_account_peppol	base	ir.module.module
173	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	151	t	module_account_purchase_stock_report_non_billed	base	ir.module.module
174	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	18	t	module_category_accounting_payment	base	ir.module.category
175	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	152	t	module_account_qr_code_sepa	base	ir.module.module
176	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	153	t	module_account_receipt_journal	base	ir.module.module
177	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	154	t	module_account_receipt_send	base	ir.module.module
178	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	155	t	module_account_reconcile_analytic_tag	base	ir.module.module
179	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	156	t	module_account_reconcile_oca	base	ir.module.module
180	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	157	t	module_account_sale_stock_report_non_billed	base	ir.module.module
182	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	158	t	module_account_sequence	base	ir.module.module
183	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	159	t	module_account_sequence_option	base	ir.module.module
184	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	160	t	module_account_spread_cost_revenue	base	ir.module.module
185	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	161	t	module_account_statement_base	base	ir.module.module
186	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	162	t	module_account_tax_balance	base	ir.module.module
187	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	163	t	module_account_tax_change	base	ir.module.module
188	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	164	t	module_account_tax_group_widget_base_amount	base	ir.module.module
189	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	165	t	module_account_tax_one_vat	base	ir.module.module
190	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	166	t	module_account_tax_one_vat_purchase	base	ir.module.module
191	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	167	t	module_account_tax_one_vat_sale	base	ir.module.module
192	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	168	t	module_account_tax_python	base	ir.module.module
193	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	169	t	module_account_template_active	base	ir.module.module
194	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	170	t	module_account_test	base	ir.module.module
195	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	171	t	module_account_update_tax_tags	base	ir.module.module
196	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	172	t	module_account_usability	base	ir.module.module
197	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	173	t	module_analytic	base	ir.module.module
198	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	20	t	module_category_generic_modules	base	ir.module.category
199	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	21	t	module_category_generic_modules_projects_and_services	base	ir.module.category
200	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	174	t	module_analytic_base_department	base	ir.module.module
201	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	175	t	module_analytic_distribution_widget_remove_save	base	ir.module.module
202	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	176	t	module_analytic_hr_department_restriction	base	ir.module.module
203	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	177	t	module_analytic_mixin_analytic_account	base	ir.module.module
204	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	178	t	module_analytic_operating_unit	base	ir.module.module
205	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	179	t	module_analytic_partner	base	ir.module.module
206	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	22	t	module_category_server_ux	base	ir.module.category
207	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	180	t	module_announcement	base	ir.module.module
208	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	181	t	module_announcement_dialog_size	base	ir.module.module
210	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	182	t	module_association	base	ir.module.module
211	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	24	t	module_category_tools	base	ir.module.category
212	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	183	t	module_attachment_delete_restrict	base	ir.module.module
213	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	25	t	module_category_hidden_tools	base	ir.module.category
214	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	184	t	module_attachment_indexation	base	ir.module.module
215	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	185	t	module_attachment_logging	base	ir.module.module
216	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	186	t	module_attachment_queue	base	ir.module.module
217	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	187	t	module_attachment_synchronize	base	ir.module.module
218	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	188	t	module_attachment_unindex_content	base	ir.module.module
219	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	189	t	module_auditlog	base	ir.module.module
220	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	26	t	module_category_base	base	ir.module.category
221	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	190	t	module_auth_admin_passkey	base	ir.module.module
222	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	191	t	module_auth_api_key	base	ir.module.module
223	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	192	t	module_auth_api_key_group	base	ir.module.module
224	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	193	t	module_auth_api_key_server_env	base	ir.module.module
225	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	194	t	module_auth_jwt	base	ir.module.module
226	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	195	t	module_auth_jwt_demo	base	ir.module.module
227	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	196	t	module_auth_jwt_server_env	base	ir.module.module
228	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	197	t	module_auth_ldap	base	ir.module.module
229	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	198	t	module_auth_ldaps	base	ir.module.module
230	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	199	t	module_auth_oauth	base	ir.module.module
231	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	200	t	module_auth_oauth_autologin	base	ir.module.module
232	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	201	t	module_auth_oauth_filter_by_domain	base	ir.module.module
233	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	27	t	module_category_tool	base	ir.module.category
234	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	202	t	module_auth_oauth_multi_token	base	ir.module.module
235	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	203	t	module_auth_oauth_ropc	base	ir.module.module
236	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	204	t	module_auth_oidc	base	ir.module.module
237	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	205	t	module_auth_oidc_environment	base	ir.module.module
238	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	206	t	module_auth_password_policy	base	ir.module.module
239	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	207	t	module_auth_password_policy_portal	base	ir.module.module
240	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	208	t	module_auth_password_policy_signup	base	ir.module.module
241	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	209	t	module_auth_saml	base	ir.module.module
242	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	210	t	module_auth_session_timeout	base	ir.module.module
243	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	211	t	module_auth_signup	base	ir.module.module
244	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	28	t	module_category_authentication	base	ir.module.category
245	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	212	t	module_auth_signup_verify_email	base	ir.module.module
246	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	29	t	module_category_extra_tools	base	ir.module.category
247	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	213	t	module_auth_totp	base	ir.module.module
248	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	214	t	module_auth_totp_mail	base	ir.module.module
249	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	215	t	module_auth_totp_mail_enforce	base	ir.module.module
250	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	216	t	module_auth_totp_portal	base	ir.module.module
251	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	217	t	module_auth_user_case_insensitive	base	ir.module.module
252	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	218	t	module_auto_backup	base	ir.module.module
253	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	219	t	module_autovacuum_message_attachment	base	ir.module.module
254	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	220	t	module_bank_statement_check_number	base	ir.module.module
255	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	221	t	module_barcode_action	base	ir.module.module
256	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	222	t	module_barcodes	base	ir.module.module
257	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	223	t	module_barcodes_gs1_nomenclature	base	ir.module.module
258	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	224	t	module_base	base	ir.module.module
259	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	225	t	module_base_address_extended	base	ir.module.module
260	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	30	t	module_category_server_tools	base	ir.module.category
261	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	226	t	module_base_archive_security	base	ir.module.module
262	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	31	t	module_category_sales_sales	base	ir.module.category
263	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	227	t	module_base_automation	base	ir.module.module
264	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	228	t	module_base_binary_url_import	base	ir.module.module
265	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	229	t	module_base_cancel_confirm	base	ir.module.module
266	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	230	t	module_base_changeset	base	ir.module.module
267	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	231	t	module_base_comment_template	base	ir.module.module
268	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	32	t	module_category_misc	base	ir.module.category
269	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	232	t	module_base_conditional_image	base	ir.module.module
270	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	233	t	module_base_cron_exclusion	base	ir.module.module
271	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	234	t	module_base_custom_filter	base	ir.module.module
272	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	33	t	module_category_others	base	ir.module.category
273	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	235	t	module_base_domain_inverse_function	base	ir.module.module
274	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	236	t	module_base_exception	base	ir.module.module
275	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	34	t	module_category_personalization	base	ir.module.category
276	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	237	t	module_base_export_manager	base	ir.module.module
277	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	238	t	module_base_external_dbsource	base	ir.module.module
278	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	239	t	module_base_external_dbsource_mssql	base	ir.module.module
279	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	240	t	module_base_external_dbsource_mysql	base	ir.module.module
280	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	241	t	module_base_external_dbsource_sqlite	base	ir.module.module
281	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	242	t	module_base_external_system	base	ir.module.module
282	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	243	t	module_base_fontawesome	base	ir.module.module
283	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	244	t	module_base_force_record_noupdate	base	ir.module.module
284	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	245	t	module_base_geolocalize	base	ir.module.module
285	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	246	t	module_base_global_discount	base	ir.module.module
286	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	247	t	module_base_group_backend	base	ir.module.module
287	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	248	t	module_base_iban	base	ir.module.module
288	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	249	t	module_base_import	base	ir.module.module
289	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	250	t	module_base_import_default_enable_tracking	base	ir.module.module
290	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	251	t	module_base_import_match	base	ir.module.module
291	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	252	t	module_base_import_module	base	ir.module.module
292	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	253	t	module_base_import_odoo	base	ir.module.module
293	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	254	t	module_base_import_security_group	base	ir.module.module
294	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	255	t	module_base_install_request	base	ir.module.module
295	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	35	t	module_category_technical_settings	base	ir.module.category
296	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	256	t	module_base_m2m_custom_field	base	ir.module.module
297	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	257	t	module_base_menu_visibility_restriction	base	ir.module.module
298	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	258	t	module_base_model_restrict_update	base	ir.module.module
299	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	259	t	module_base_multi_image	base	ir.module.module
300	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	260	t	module_base_name_search_improved	base	ir.module.module
301	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	261	t	module_base_optional_quick_create	base	ir.module.module
302	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	262	t	module_base_partition	base	ir.module.module
303	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	36	t	module_category_technical	base	ir.module.category
304	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	263	t	module_base_portal_type	base	ir.module.module
305	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	264	t	module_base_product_merge	base	ir.module.module
306	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	37	t	module_category_generic_modules_base	base	ir.module.category
307	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	265	t	module_base_remote	base	ir.module.module
308	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	266	t	module_base_revision	base	ir.module.module
309	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	267	t	module_base_rule_visibility_restriction	base	ir.module.module
310	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	268	t	module_base_search_custom_field_filter	base	ir.module.module
311	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	269	t	module_base_search_fuzzy	base	ir.module.module
312	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	270	t	module_base_sequence_default	base	ir.module.module
313	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	271	t	module_base_sequence_option	base	ir.module.module
314	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	272	t	module_base_setup	base	ir.module.module
315	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	273	t	module_base_sparse_field	base	ir.module.module
316	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	274	t	module_base_sparse_field_list_support	base	ir.module.module
317	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	275	t	module_base_substate	base	ir.module.module
318	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	276	t	module_base_technical_features	base	ir.module.module
319	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	38	t	module_category_hidden_dependency	base	ir.module.category
320	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	277	t	module_base_technical_user	base	ir.module.module
321	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	278	t	module_base_tier_validation	base	ir.module.module
322	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	279	t	module_base_tier_validation_board	base	ir.module.module
323	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	280	t	module_base_tier_validation_correction	base	ir.module.module
324	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	281	t	module_base_tier_validation_definition_server_action	base	ir.module.module
325	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	282	t	module_base_tier_validation_formula	base	ir.module.module
326	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	283	t	module_base_tier_validation_forward	base	ir.module.module
327	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	284	t	module_base_tier_validation_report	base	ir.module.module
328	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	285	t	module_base_tier_validation_server_action	base	ir.module.module
329	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	286	t	module_base_tier_validation_waiting	base	ir.module.module
330	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	287	t	module_base_time_window	base	ir.module.module
331	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	288	t	module_base_transaction_id	base	ir.module.module
332	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	39	t	module_category_mail	base	ir.module.category
333	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	289	t	module_base_user_chatter	base	ir.module.module
334	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	290	t	module_base_user_effective_permissions	base	ir.module.module
335	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	291	t	module_base_user_locale	base	ir.module.module
336	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	292	t	module_base_user_role	base	ir.module.module
337	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	293	t	module_base_user_role_company	base	ir.module.module
338	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	294	t	module_base_user_role_history	base	ir.module.module
339	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	295	t	module_base_user_show_email	base	ir.module.module
340	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	296	t	module_base_vat	base	ir.module.module
341	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	297	t	module_base_vat_optional_vies	base	ir.module.module
342	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	298	t	module_base_view_inheritance_extension	base	ir.module.module
343	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	299	t	module_bi_sql_editor	base	ir.module.module
345	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	300	t	module_bi_view_editor	base	ir.module.module
346	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	301	t	module_bi_view_editor_spreadsheet_dashboard	base	ir.module.module
347	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	302	t	module_board	base	ir.module.module
348	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	303	t	module_bus	base	ir.module.module
349	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	304	t	module_bus_alt_connection	base	ir.module.module
350	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	41	t	module_category_productivity_calendar	base	ir.module.category
351	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	305	t	module_calendar	base	ir.module.module
352	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	306	t	module_calendar_sms	base	ir.module.module
353	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	307	t	module_confirmation_wizard	base	ir.module.module
354	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	42	t	module_category_sales_crm	base	ir.module.category
355	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	308	t	module_contacts	base	ir.module.module
356	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	309	t	module_contract_operating_unit	base	ir.module.module
357	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	310	t	module_crm	base	ir.module.module
358	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	43	t	module_category_customer_relationship_management	base	ir.module.category
359	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	311	t	module_crm_claim_analytic	base	ir.module.module
360	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	312	t	module_crm_iap_enrich	base	ir.module.module
361	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	313	t	module_crm_iap_mine	base	ir.module.module
362	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	314	t	module_crm_livechat	base	ir.module.module
363	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	315	t	module_crm_mail_plugin	base	ir.module.module
364	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	316	t	module_crm_sms	base	ir.module.module
365	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	317	t	module_cron_daylight_saving_time_resistant	base	ir.module.module
366	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	318	t	module_cross_connect_client	base	ir.module.module
367	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	319	t	module_cross_connect_server	base	ir.module.module
368	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	44	t	module_category_financial_management	base	ir.module.category
369	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	45	t	module_category_financial_management_configuration	base	ir.module.category
370	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	320	t	module_currency_rate_update_TH_BOT	base	ir.module.module
371	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	321	t	module_data_encryption	base	ir.module.module
372	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	46	t	module_category_productivity_data_cleaning	base	ir.module.category
373	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	322	t	module_data_recycle	base	ir.module.module
374	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	323	t	module_database_cleanup	base	ir.module.module
375	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	324	t	module_date_range	base	ir.module.module
376	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	325	t	module_date_range_account	base	ir.module.module
377	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	326	t	module_datetime_formatter	base	ir.module.module
378	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	327	t	module_dbfilter_from_header	base	ir.module.module
380	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	48	t	module_category_inventory_delivery	base	ir.module.category
381	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	328	t	module_delivery	base	ir.module.module
382	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	329	t	module_delivery_mondialrelay	base	ir.module.module
383	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	330	t	module_delivery_stock_picking_batch	base	ir.module.module
384	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	331	t	module_developer_menu	base	ir.module.module
385	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	332	t	module_digest	base	ir.module.module
386	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	333	t	module_disable_odoo_online	base	ir.module.module
387	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	334	t	module_document_quick_access	base	ir.module.module
388	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	335	t	module_document_quick_access_folder_auto_classification	base	ir.module.module
389	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	49	t	module_category_marketing_events	base	ir.module.category
390	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	336	t	module_event	base	ir.module.module
391	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	337	t	module_event_booth	base	ir.module.module
392	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	338	t	module_event_booth_sale	base	ir.module.module
393	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	339	t	module_event_crm	base	ir.module.module
394	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	340	t	module_event_crm_sale	base	ir.module.module
395	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	341	t	module_event_sale	base	ir.module.module
396	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	342	t	module_event_sms	base	ir.module.module
397	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	343	t	module_excel_import_export	base	ir.module.module
398	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	344	t	module_excel_import_export_demo	base	ir.module.module
399	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	345	t	module_excel_import_export_unidecode	base	ir.module.module
400	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	346	t	module_fetchmail_attach_from_folder	base	ir.module.module
401	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	347	t	module_fetchmail_notify_error_to_sender	base	ir.module.module
402	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	348	t	module_fetchmail_notify_error_to_sender_test	base	ir.module.module
403	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	349	t	module_field_vector	base	ir.module.module
404	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	350	t	module_filter_multi_user	base	ir.module.module
406	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	51	t	module_category_human_resources_fleet	base	ir.module.category
407	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	351	t	module_fleet	base	ir.module.module
408	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	352	t	module_gamification	base	ir.module.module
409	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	353	t	module_gamification_sale_crm	base	ir.module.module
410	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	354	t	module_google_account	base	ir.module.module
411	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	355	t	module_google_calendar	base	ir.module.module
412	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	356	t	module_google_gmail	base	ir.module.module
413	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	357	t	module_google_recaptcha	base	ir.module.module
414	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	52	t	module_category_human_resources_employees	base	ir.module.category
415	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	358	t	module_hr	base	ir.module.module
416	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	53	t	module_category_human_resources_attendances	base	ir.module.category
417	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	359	t	module_hr_attendance	base	ir.module.module
418	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	54	t	module_category_human_resources_contracts	base	ir.module.category
419	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	360	t	module_hr_contract	base	ir.module.module
420	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	361	t	module_hr_contract_employee_calendar_planning	base	ir.module.module
421	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	55	t	module_category_generic_modules_human_resources	base	ir.module.category
422	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	362	t	module_hr_contract_multi_job	base	ir.module.module
423	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	363	t	module_hr_contract_reference	base	ir.module.module
424	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	364	t	module_hr_course	base	ir.module.module
425	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	365	t	module_hr_course_survey	base	ir.module.module
426	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	366	t	module_hr_department_analytic	base	ir.module.module
427	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	367	t	module_hr_department_code	base	ir.module.module
428	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	368	t	module_hr_employee_age	base	ir.module.module
429	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	369	t	module_hr_employee_birth_name	base	ir.module.module
430	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	370	t	module_hr_employee_birthday_mail	base	ir.module.module
431	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	371	t	module_hr_employee_calendar_planning	base	ir.module.module
432	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	372	t	module_hr_employee_digitized_signature	base	ir.module.module
433	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	373	t	module_hr_employee_document	base	ir.module.module
434	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	374	t	module_hr_employee_document_from_applicant	base	ir.module.module
435	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	375	t	module_hr_employee_firstname	base	ir.module.module
436	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	376	t	module_hr_employee_firstname_partner_firstname	base	ir.module.module
437	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	377	t	module_hr_employee_group_overview_readonly	base	ir.module.module
438	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	378	t	module_hr_employee_id	base	ir.module.module
439	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	379	t	module_hr_employee_language	base	ir.module.module
440	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	380	t	module_hr_employee_lastnames	base	ir.module.module
441	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	381	t	module_hr_employee_medical_examination	base	ir.module.module
442	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	382	t	module_hr_employee_partner_external	base	ir.module.module
443	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	383	t	module_hr_employee_phone_extension	base	ir.module.module
444	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	384	t	module_hr_employee_phone_pin	base	ir.module.module
445	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	385	t	module_hr_employee_ppe	base	ir.module.module
446	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	386	t	module_hr_employee_relative	base	ir.module.module
447	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	387	t	module_hr_employee_service	base	ir.module.module
448	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	388	t	module_hr_employee_service_contract	base	ir.module.module
449	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	389	t	module_hr_employee_ssn	base	ir.module.module
450	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	56	t	module_category_human_resources_expenses	base	ir.module.category
451	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	390	t	module_hr_expense	base	ir.module.module
452	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	391	t	module_hr_expense_advance_clearing	base	ir.module.module
453	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	392	t	module_hr_expense_advance_clearing_sequence	base	ir.module.module
454	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	393	t	module_hr_expense_analytic_tag	base	ir.module.module
455	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	394	t	module_hr_expense_cancel	base	ir.module.module
456	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	395	t	module_hr_expense_invoice	base	ir.module.module
457	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	396	t	module_hr_expense_journal	base	ir.module.module
458	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	397	t	module_hr_expense_pay_to_vendor	base	ir.module.module
459	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	398	t	module_hr_expense_payment	base	ir.module.module
460	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	399	t	module_hr_expense_remove_mobile_link	base	ir.module.module
461	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	400	t	module_hr_expense_sequence	base	ir.module.module
462	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	401	t	module_hr_expense_sequence_option	base	ir.module.module
463	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	402	t	module_hr_expense_tier_validation	base	ir.module.module
464	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	403	t	module_hr_fleet	base	ir.module.module
465	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	404	t	module_hr_gamification	base	ir.module.module
466	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	57	t	module_category_human_resources_time_off	base	ir.module.category
467	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	405	t	module_hr_holidays	base	ir.module.module
468	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	406	t	module_hr_holidays_attendance	base	ir.module.module
469	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	58	t	module_category_hr	base	ir.module.category
470	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	407	t	module_hr_holidays_team_manager	base	ir.module.module
472	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	60	t	module_category_services_employee_hourly_cost	base	ir.module.category
473	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	408	t	module_hr_hourly_cost	base	ir.module.module
474	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	409	t	module_hr_job_category	base	ir.module.module
475	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	410	t	module_hr_maintenance	base	ir.module.module
476	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	411	t	module_hr_operating_unit	base	ir.module.module
477	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	412	t	module_hr_org_chart	base	ir.module.module
478	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	413	t	module_hr_org_chart_overview	base	ir.module.module
479	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	414	t	module_hr_personal_equipment_request	base	ir.module.module
480	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	415	t	module_hr_personal_equipment_request_tier_validation	base	ir.module.module
481	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	416	t	module_hr_personal_equipment_stock	base	ir.module.module
482	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	417	t	module_hr_personal_equipment_variant_configurator	base	ir.module.module
483	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	418	t	module_hr_presence	base	ir.module.module
484	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	419	t	module_hr_professional_category	base	ir.module.module
485	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	61	t	module_category_human_resources_recruitment	base	ir.module.category
486	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	420	t	module_hr_recruitment	base	ir.module.module
487	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	421	t	module_hr_recruitment_skills	base	ir.module.module
488	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	422	t	module_hr_recruitment_survey	base	ir.module.module
489	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	423	t	module_hr_recruitment_torecruit	base	ir.module.module
490	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	424	t	module_hr_skills	base	ir.module.module
491	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	425	t	module_hr_skills_slides	base	ir.module.module
492	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	426	t	module_hr_skills_survey	base	ir.module.module
493	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	62	t	module_category_services_timesheets	base	ir.module.category
494	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	427	t	module_hr_timesheet	base	ir.module.module
495	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	428	t	module_hr_timesheet_analytic_tag	base	ir.module.module
496	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	429	t	module_hr_timesheet_attendance	base	ir.module.module
497	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	430	t	module_hr_work_entry	base	ir.module.module
498	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	431	t	module_hr_work_entry_contract	base	ir.module.module
499	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	63	t	module_category_human_resources_payroll	base	ir.module.category
500	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	432	t	module_hr_work_entry_holidays	base	ir.module.module
501	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	433	t	module_html_image_url_extractor	base	ir.module.module
502	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	434	t	module_html_text	base	ir.module.module
503	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	435	t	module_http_routing	base	ir.module.module
504	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	436	t	module_hw_drivers	base	ir.module.module
505	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	64	t	module_category_sales_point_of_sale	base	ir.module.category
506	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	437	t	module_hw_escpos	base	ir.module.module
507	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	438	t	module_hw_posbox_homepage	base	ir.module.module
508	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	439	t	module_iap	base	ir.module.module
509	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	440	t	module_iap_alternative_provider	base	ir.module.module
510	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	441	t	module_iap_crm	base	ir.module.module
511	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	442	t	module_iap_mail	base	ir.module.module
513	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	66	t	module_category_website_live_chat	base	ir.module.category
514	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	443	t	module_im_livechat	base	ir.module.module
515	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	67	t	module_category_productivity_discuss	base	ir.module.category
516	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	444	t	module_im_livechat_mail_bot	base	ir.module.module
517	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	445	t	module_impersonate_login	base	ir.module.module
518	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	446	t	module_jsonifier	base	ir.module.module
519	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	68	t	module_category_hidden_tests	base	ir.module.category
520	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	447	t	module_l10n_account_edi_ubl_cii_tests	base	ir.module.module
523	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	448	t	module_l10n_ae	base	ir.module.module
524	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	71	t	module_category_accounting_localizations_point_of_sale	base	ir.module.category
525	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	449	t	module_l10n_ae_pos	base	ir.module.module
526	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	450	t	module_l10n_ar	base	ir.module.module
527	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	72	t	module_category_accounting_localizations_website	base	ir.module.category
528	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	451	t	module_l10n_ar_website_sale	base	ir.module.module
529	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	452	t	module_l10n_at	base	ir.module.module
530	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	453	t	module_l10n_au	base	ir.module.module
531	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	454	t	module_l10n_be	base	ir.module.module
532	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	455	t	module_l10n_be_pos_sale	base	ir.module.module
533	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	456	t	module_l10n_bg	base	ir.module.module
534	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	457	t	module_l10n_bo	base	ir.module.module
535	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	458	t	module_l10n_br	base	ir.module.module
536	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	459	t	module_l10n_ca	base	ir.module.module
537	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	460	t	module_l10n_ch	base	ir.module.module
3254	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	55	f	lang_fa_IR	base	res.lang
538	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	461	t	module_l10n_ch_pos	base	ir.module.module
539	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	462	t	module_l10n_cl	base	ir.module.module
540	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	463	t	module_l10n_cn	base	ir.module.module
541	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	464	t	module_l10n_cn_city	base	ir.module.module
542	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	465	t	module_l10n_co	base	ir.module.module
543	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	466	t	module_l10n_co_pos	base	ir.module.module
544	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	467	t	module_l10n_cr	base	ir.module.module
545	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	468	t	module_l10n_cz	base	ir.module.module
546	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	469	t	module_l10n_de	base	ir.module.module
547	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	470	t	module_l10n_de_skr03	base	ir.module.module
548	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	471	t	module_l10n_de_skr04	base	ir.module.module
549	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	472	t	module_l10n_din5008	base	ir.module.module
550	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	473	t	module_l10n_din5008_purchase	base	ir.module.module
551	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	474	t	module_l10n_din5008_repair	base	ir.module.module
552	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	475	t	module_l10n_din5008_sale	base	ir.module.module
553	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	476	t	module_l10n_din5008_stock	base	ir.module.module
554	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	477	t	module_l10n_dk	base	ir.module.module
555	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	478	t	module_l10n_do	base	ir.module.module
556	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	479	t	module_l10n_dz	base	ir.module.module
557	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	480	t	module_l10n_ec	base	ir.module.module
558	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	481	t	module_l10n_ec_stock	base	ir.module.module
559	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	482	t	module_l10n_ee	base	ir.module.module
560	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	483	t	module_l10n_eg	base	ir.module.module
561	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	484	t	module_l10n_eg_edi_eta	base	ir.module.module
562	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	485	t	module_l10n_es	base	ir.module.module
563	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	73	t	module_category_accounting_localizations_edi	base	ir.module.category
564	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	486	t	module_l10n_es_edi_sii	base	ir.module.module
565	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	487	t	module_l10n_es_edi_tbai	base	ir.module.module
566	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	488	t	module_l10n_es_edi_tbai_multi_refund	base	ir.module.module
567	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	489	t	module_l10n_et	base	ir.module.module
568	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	490	t	module_l10n_eu_oss	base	ir.module.module
569	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	491	t	module_l10n_fi	base	ir.module.module
570	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	74	t	module_category_localization	base	ir.module.category
571	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	492	t	module_l10n_fi_sale	base	ir.module.module
572	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	493	t	module_l10n_fr	base	ir.module.module
573	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	494	t	module_l10n_fr_facturx_chorus_pro	base	ir.module.module
574	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	75	t	module_category_accounting_localizations_reporting	base	ir.module.category
575	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	495	t	module_l10n_fr_fec	base	ir.module.module
576	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	496	t	module_l10n_fr_invoice_addr	base	ir.module.module
577	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	497	t	module_l10n_fr_pos_cert	base	ir.module.module
578	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	498	t	module_l10n_gcc_invoice	base	ir.module.module
579	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	499	t	module_l10n_gcc_invoice_stock_account	base	ir.module.module
580	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	500	t	module_l10n_gcc_pos	base	ir.module.module
581	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	501	t	module_l10n_generic_coa	base	ir.module.module
582	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	502	t	module_l10n_gr	base	ir.module.module
583	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	503	t	module_l10n_gt	base	ir.module.module
584	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	504	t	module_l10n_hk	base	ir.module.module
585	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	505	t	module_l10n_hn	base	ir.module.module
586	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	506	t	module_l10n_hr	base	ir.module.module
587	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	507	t	module_l10n_hr_euro	base	ir.module.module
588	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	508	t	module_l10n_hu	base	ir.module.module
589	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	509	t	module_l10n_id	base	ir.module.module
590	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	510	t	module_l10n_id_efaktur	base	ir.module.module
591	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	511	t	module_l10n_id_efaktur_coretax	base	ir.module.module
592	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	512	t	module_l10n_ie	base	ir.module.module
593	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	513	t	module_l10n_il	base	ir.module.module
594	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	514	t	module_l10n_in	base	ir.module.module
595	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	515	t	module_l10n_in_edi	base	ir.module.module
596	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	516	t	module_l10n_in_edi_ewaybill	base	ir.module.module
597	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	517	t	module_l10n_in_ewaybill_port	base	ir.module.module
598	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	518	t	module_l10n_in_pos	base	ir.module.module
599	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	76	t	module_category_accounting_localizations_purchase	base	ir.module.category
600	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	519	t	module_l10n_in_purchase	base	ir.module.module
601	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	520	t	module_l10n_in_purchase_stock	base	ir.module.module
602	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	77	t	module_category_accounting_localizations_sale	base	ir.module.category
603	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	521	t	module_l10n_in_sale	base	ir.module.module
604	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	522	t	module_l10n_in_sale_stock	base	ir.module.module
605	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	523	t	module_l10n_in_stock	base	ir.module.module
606	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	524	t	module_l10n_in_tcs_tds	base	ir.module.module
607	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	525	t	module_l10n_in_upi	base	ir.module.module
608	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	526	t	module_l10n_it	base	ir.module.module
609	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	527	t	module_l10n_it_edi	base	ir.module.module
610	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	528	t	module_l10n_it_edi_doi	base	ir.module.module
611	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	529	t	module_l10n_it_edi_pa	base	ir.module.module
612	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	530	t	module_l10n_it_edi_website_sale	base	ir.module.module
613	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	531	t	module_l10n_it_edi_withholding	base	ir.module.module
614	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	532	t	module_l10n_it_stock_ddt	base	ir.module.module
615	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	533	t	module_l10n_jp	base	ir.module.module
616	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	534	t	module_l10n_ke	base	ir.module.module
617	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	535	t	module_l10n_ke_edi_tremol	base	ir.module.module
618	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	536	t	module_l10n_latam_account_sequence	base	ir.module.module
619	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	537	t	module_l10n_latam_base	base	ir.module.module
620	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	538	t	module_l10n_latam_check	base	ir.module.module
621	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	539	t	module_l10n_latam_invoice_document	base	ir.module.module
622	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	540	t	module_l10n_lt	base	ir.module.module
623	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	541	t	module_l10n_lu	base	ir.module.module
624	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	542	t	module_l10n_lu_peppol_id	base	ir.module.module
625	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	543	t	module_l10n_lv	base	ir.module.module
626	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	544	t	module_l10n_ma	base	ir.module.module
627	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	545	t	module_l10n_mn	base	ir.module.module
628	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	546	t	module_l10n_mt_pos	base	ir.module.module
629	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	547	t	module_l10n_multilang	base	ir.module.module
630	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	548	t	module_l10n_mx	base	ir.module.module
631	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	549	t	module_l10n_mx_hr	base	ir.module.module
632	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	550	t	module_l10n_my	base	ir.module.module
633	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	551	t	module_l10n_mz	base	ir.module.module
634	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	552	t	module_l10n_nl	base	ir.module.module
635	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	553	t	module_l10n_no	base	ir.module.module
636	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	554	t	module_l10n_nz	base	ir.module.module
637	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	555	t	module_l10n_pa	base	ir.module.module
638	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	556	t	module_l10n_pe	base	ir.module.module
639	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	557	t	module_l10n_ph	base	ir.module.module
640	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	558	t	module_l10n_pk	base	ir.module.module
641	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	559	t	module_l10n_pl	base	ir.module.module
642	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	560	t	module_l10n_pl_jpk	base	ir.module.module
643	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	561	t	module_l10n_pl_sale_stock	base	ir.module.module
644	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	562	t	module_l10n_pt	base	ir.module.module
645	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	563	t	module_l10n_ro	base	ir.module.module
646	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	564	t	module_l10n_rs	base	ir.module.module
647	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	565	t	module_l10n_sa	base	ir.module.module
648	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	566	t	module_l10n_sa_edi	base	ir.module.module
649	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	567	t	module_l10n_sa_edi_pos	base	ir.module.module
650	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	568	t	module_l10n_sa_pos	base	ir.module.module
651	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	569	t	module_l10n_se	base	ir.module.module
652	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	570	t	module_l10n_sg	base	ir.module.module
653	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	571	t	module_l10n_si	base	ir.module.module
654	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	572	t	module_l10n_sk	base	ir.module.module
655	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	573	t	module_l10n_syscohada	base	ir.module.module
656	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	574	t	module_l10n_th	base	ir.module.module
657	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	575	t	module_l10n_th_account_asset_management	base	ir.module.module
658	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	576	t	module_l10n_th_account_tax	base	ir.module.module
659	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	577	t	module_l10n_th_account_tax_expense	base	ir.module.module
660	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	578	t	module_l10n_th_account_tax_multi	base	ir.module.module
661	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	579	t	module_l10n_th_account_tax_report	base	ir.module.module
662	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	78	t	module_category_report	base	ir.module.category
663	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	580	t	module_l10n_th_account_wht_cert_form	base	ir.module.module
664	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	581	t	module_l10n_th_amount_to_text	base	ir.module.module
665	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	582	t	module_l10n_th_bank_payment_export	base	ir.module.module
666	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	79	t	module_category_localisation	base	ir.module.category
667	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	80	t	module_category_localisation_asia	base	ir.module.category
668	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	583	t	module_l10n_th_base_location	base	ir.module.module
669	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	584	t	module_l10n_th_base_sequence	base	ir.module.module
670	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	585	t	module_l10n_th_fonts	base	ir.module.module
671	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	81	t	module_category_localization___purchase	base	ir.module.category
672	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	586	t	module_l10n_th_gov_purchase_agreement	base	ir.module.module
673	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	587	t	module_l10n_th_mis_report	base	ir.module.module
674	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	82	t	module_category_localization_asia	base	ir.module.category
675	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	588	t	module_l10n_th_partner	base	ir.module.module
676	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	83	t	module_category_accounting_	base	ir.module.category
677	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	84	t	module_category_accounting___payment	base	ir.module.category
678	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	589	t	module_l10n_th_promptpay	base	ir.module.module
679	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	590	t	module_l10n_th_tax_address	base	ir.module.module
680	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	85	t	module_category_localization___tools	base	ir.module.category
681	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	591	t	module_l10n_th_tier_department	base	ir.module.module
682	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	592	t	module_l10n_th_tier_department_demo	base	ir.module.module
683	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	593	t	module_l10n_tr	base	ir.module.module
684	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	594	t	module_l10n_tw	base	ir.module.module
685	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	595	t	module_l10n_ua	base	ir.module.module
686	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	596	t	module_l10n_uk	base	ir.module.module
687	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	597	t	module_l10n_us	base	ir.module.module
688	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	598	t	module_l10n_uy	base	ir.module.module
689	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	599	t	module_l10n_ve	base	ir.module.module
690	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	600	t	module_l10n_vn	base	ir.module.module
691	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	601	t	module_l10n_za	base	ir.module.module
692	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	602	t	module_letsencrypt	base	ir.module.module
693	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	603	t	module_link_tracker	base	ir.module.module
694	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	604	t	module_loyalty	base	ir.module.module
695	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	605	t	module_loyalty_delivery	base	ir.module.module
696	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	86	t	module_category_human_resources_lunch	base	ir.module.category
697	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	606	t	module_lunch	base	ir.module.module
698	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	607	t	module_mail	base	ir.module.module
699	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	608	t	module_mail_bot	base	ir.module.module
700	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	609	t	module_mail_bot_hr	base	ir.module.module
701	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	610	t	module_mail_cleanup	base	ir.module.module
702	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	611	t	module_mail_environment	base	ir.module.module
703	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	612	t	module_mail_environment_google_gmail	base	ir.module.module
704	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	613	t	module_mail_group	base	ir.module.module
705	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	614	t	module_mail_message_destiny_link_template	base	ir.module.module
706	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	615	t	module_mail_plugin	base	ir.module.module
707	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	616	t	module_mail_suggested_recipient_unchecked	base	ir.module.module
709	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	88	t	module_category_manufacturing_maintenance	base	ir.module.category
710	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	617	t	module_maintenance	base	ir.module.module
711	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	89	t	module_category_marketing_email_marketing	base	ir.module.category
712	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	618	t	module_mass_mailing	base	ir.module.module
713	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	619	t	module_mass_mailing_crm	base	ir.module.module
714	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	620	t	module_mass_mailing_crm_sms	base	ir.module.module
715	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	621	t	module_mass_mailing_event	base	ir.module.module
716	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	622	t	module_mass_mailing_event_sms	base	ir.module.module
717	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	623	t	module_mass_mailing_event_track	base	ir.module.module
718	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	624	t	module_mass_mailing_event_track_sms	base	ir.module.module
719	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	625	t	module_mass_mailing_sale	base	ir.module.module
720	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	626	t	module_mass_mailing_sale_sms	base	ir.module.module
721	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	627	t	module_mass_mailing_slides	base	ir.module.module
722	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	628	t	module_mass_mailing_sms	base	ir.module.module
723	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	629	t	module_mass_mailing_themes	base	ir.module.module
724	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	630	t	module_membership	base	ir.module.module
725	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	631	t	module_microsoft_account	base	ir.module.module
726	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	632	t	module_microsoft_calendar	base	ir.module.module
727	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	633	t	module_microsoft_outlook	base	ir.module.module
728	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	634	t	module_mis_builder	base	ir.module.module
729	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	635	t	module_mis_builder_budget	base	ir.module.module
730	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	636	t	module_mis_builder_cash_flow	base	ir.module.module
731	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	637	t	module_mis_builder_demo	base	ir.module.module
732	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	638	t	module_mis_template_financial_report	base	ir.module.module
733	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	639	t	module_misc_settings	base	ir.module.module
734	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	640	t	module_module_analysis	base	ir.module.module
735	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	641	t	module_module_auto_update	base	ir.module.module
736	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	642	t	module_module_change_auto_install	base	ir.module.module
737	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	90	t	module_category_manufacturing_manufacturing	base	ir.module.category
738	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	643	t	module_mrp	base	ir.module.module
739	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	644	t	module_mrp_account	base	ir.module.module
740	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	645	t	module_mrp_landed_costs	base	ir.module.module
741	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	646	t	module_mrp_product_expiry	base	ir.module.module
742	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	91	t	module_category_inventory_inventory	base	ir.module.category
743	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	647	t	module_mrp_repair	base	ir.module.module
744	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	648	t	module_mrp_stock_analytic	base	ir.module.module
745	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	649	t	module_mrp_subcontracting	base	ir.module.module
746	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	650	t	module_mrp_subcontracting_account	base	ir.module.module
747	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	92	t	module_category_inventory_purchase	base	ir.module.category
748	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	651	t	module_mrp_subcontracting_dropshipping	base	ir.module.module
749	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	93	t	module_category_manufacturing_purchase	base	ir.module.category
750	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	652	t	module_mrp_subcontracting_purchase	base	ir.module.module
751	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	94	t	module_category_manufacturing_repair	base	ir.module.category
752	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	653	t	module_mrp_subcontracting_repair	base	ir.module.module
753	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	654	t	module_mrp_subonctracting_landed_costs	base	ir.module.module
754	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	655	t	module_multi_step_wizard	base	ir.module.module
755	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	656	t	module_multisearch_field	base	ir.module.module
756	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	95	t	module_category_productivity_notes	base	ir.module.category
757	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	657	t	module_note	base	ir.module.module
758	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	658	t	module_nsca_client	base	ir.module.module
759	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	659	t	module_odoo_test_xmlrunner	base	ir.module.module
760	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	660	t	module_onboarding	base	ir.module.module
761	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	661	t	module_onchange_helper	base	ir.module.module
762	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	662	t	module_operating_unit	base	ir.module.module
763	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	663	t	module_operating_unit_access_all	base	ir.module.module
764	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	664	t	module_partner_autocomplete	base	ir.module.module
765	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	665	t	module_partner_invoicing_mode	base	ir.module.module
766	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	666	t	module_partner_invoicing_mode_at_shipping	base	ir.module.module
767	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	667	t	module_partner_invoicing_mode_monthly	base	ir.module.module
768	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	668	t	module_partner_last_invoice_date	base	ir.module.module
769	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	669	t	module_partner_statement	base	ir.module.module
770	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	96	t	module_category_purchase_management	base	ir.module.category
771	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	670	t	module_partner_supplierinfo_smartbutton	base	ir.module.module
772	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	671	t	module_password_security	base	ir.module.module
773	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	672	t	module_payment	base	ir.module.module
774	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	97	t	module_category_accounting_payment_providers	base	ir.module.category
775	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	673	t	module_payment_adyen	base	ir.module.module
776	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	674	t	module_payment_alipay	base	ir.module.module
777	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	675	t	module_payment_aps	base	ir.module.module
778	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	676	t	module_payment_asiapay	base	ir.module.module
779	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	677	t	module_payment_authorize	base	ir.module.module
780	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	678	t	module_payment_buckaroo	base	ir.module.module
781	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	679	t	module_payment_custom	base	ir.module.module
782	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	680	t	module_payment_demo	base	ir.module.module
783	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	681	t	module_payment_flutterwave	base	ir.module.module
784	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	682	t	module_payment_mercado_pago	base	ir.module.module
785	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	683	t	module_payment_mollie	base	ir.module.module
786	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	684	t	module_payment_ogone	base	ir.module.module
787	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	685	t	module_payment_paypal	base	ir.module.module
788	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	686	t	module_payment_payulatam	base	ir.module.module
789	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	687	t	module_payment_payumoney	base	ir.module.module
790	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	688	t	module_payment_razorpay	base	ir.module.module
791	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	689	t	module_payment_sips	base	ir.module.module
792	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	690	t	module_payment_stripe	base	ir.module.module
793	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	691	t	module_phone_validation	base	ir.module.module
794	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	692	t	module_point_of_sale	base	ir.module.module
795	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	693	t	module_portal	base	ir.module.module
796	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	694	t	module_portal_account_personal_data_only	base	ir.module.module
797	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	695	t	module_portal_odoo_debranding	base	ir.module.module
798	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	696	t	module_portal_rating	base	ir.module.module
799	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	697	t	module_pos_adyen	base	ir.module.module
800	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	98	t	module_category_point_of_sale,_accounting	base	ir.module.category
801	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	698	t	module_pos_analytic_by_config	base	ir.module.module
802	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	699	t	module_pos_cache	base	ir.module.module
803	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	99	t	module_category_point_of_sale	base	ir.module.category
804	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	700	t	module_pos_daily_sales_reports	base	ir.module.module
805	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	701	t	module_pos_discount	base	ir.module.module
806	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	702	t	module_pos_environment	base	ir.module.module
807	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	703	t	module_pos_epson_printer	base	ir.module.module
808	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	704	t	module_pos_epson_printer_restaurant	base	ir.module.module
809	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	705	t	module_pos_hr	base	ir.module.module
810	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	706	t	module_pos_hr_restaurant	base	ir.module.module
811	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	707	t	module_pos_loyalty	base	ir.module.module
812	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	708	t	module_pos_mercury	base	ir.module.module
813	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	709	t	module_pos_mrp	base	ir.module.module
814	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	710	t	module_pos_restaurant	base	ir.module.module
815	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	711	t	module_pos_restaurant_adyen	base	ir.module.module
816	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	712	t	module_pos_restaurant_stripe	base	ir.module.module
817	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	713	t	module_pos_sale	base	ir.module.module
818	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	714	t	module_pos_sale_loyalty	base	ir.module.module
819	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	715	t	module_pos_sale_margin	base	ir.module.module
3255	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	56	f	lang_pl	base	res.lang
820	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	716	t	module_pos_sale_product_configurator	base	ir.module.module
821	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	717	t	module_pos_six	base	ir.module.module
822	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	718	t	module_pos_stripe	base	ir.module.module
823	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	719	t	module_postgres_vacuum	base	ir.module.module
824	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	720	t	module_privacy_lookup	base	ir.module.module
825	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	100	t	module_category_warehouse	base	ir.module.category
826	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	721	t	module_procurement_auto_create_group	base	ir.module.module
827	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	101	t	module_category_procurements	base	ir.module.category
828	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	722	t	module_procurement_purchase_no_grouping	base	ir.module.module
829	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	723	t	module_product	base	ir.module.module
830	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	724	t	module_product_analytic	base	ir.module.module
831	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	102	t	module_category_purchases	base	ir.module.category
832	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	725	t	module_product_analytic_purchase	base	ir.module.module
833	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	726	t	module_product_analytic_sale	base	ir.module.module
834	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	727	t	module_product_email_template	base	ir.module.module
835	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	728	t	module_product_expiry	base	ir.module.module
836	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	729	t	module_product_form_account_move_line_link	base	ir.module.module
837	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	730	t	module_product_images	base	ir.module.module
838	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	103	t	module_category_purchase	base	ir.module.category
839	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	731	t	module_product_main_seller	base	ir.module.module
840	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	732	t	module_product_margin	base	ir.module.module
841	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	733	t	module_product_matrix	base	ir.module.module
842	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	104	t	module_category_product	base	ir.module.category
843	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	734	t	module_product_operating_unit	base	ir.module.module
844	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	105	t	module_category_stock	base	ir.module.category
845	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	735	t	module_product_packaging_usability	base	ir.module.module
846	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	736	t	module_product_route_profile	base	ir.module.module
847	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	737	t	module_product_supplier_code_purchase	base	ir.module.module
848	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	738	t	module_product_supplierinfo_purchase_contact	base	ir.module.module
849	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	739	t	module_product_supplierinfo_qty_multiplier	base	ir.module.module
850	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	740	t	module_product_supplierinfo_security	base	ir.module.module
851	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	741	t	module_product_supplierinfo_update_price	base	ir.module.module
852	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	742	t	module_product_view_inventory_no_search_default_my_count	base	ir.module.module
853	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	106	t	module_category_services_project	base	ir.module.category
854	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	743	t	module_project	base	ir.module.module
855	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	107	t	module_category_project	base	ir.module.category
856	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	744	t	module_project_administrator_restricted_visibility	base	ir.module.module
857	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	745	t	module_project_department	base	ir.module.module
858	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	746	t	module_project_duplicate_subtask	base	ir.module.module
859	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	747	t	module_project_hr	base	ir.module.module
860	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	108	t	module_category_services_expenses	base	ir.module.category
861	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	748	t	module_project_hr_expense	base	ir.module.module
862	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	749	t	module_project_internal_access_from_portal	base	ir.module.module
863	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	750	t	module_project_key	base	ir.module.module
864	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	751	t	module_project_list	base	ir.module.module
865	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	752	t	module_project_mail_plugin	base	ir.module.module
866	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	109	t	module_category_after-sales	base	ir.module.category
867	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	753	t	module_project_merge	base	ir.module.module
868	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	754	t	module_project_milestone_status	base	ir.module.module
869	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	110	t	module_category_project_management	base	ir.module.category
870	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	755	t	module_project_milestone_tree	base	ir.module.module
871	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	756	t	module_project_mrp	base	ir.module.module
872	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	757	t	module_project_operating_unit	base	ir.module.module
873	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	758	t	module_project_parent	base	ir.module.module
874	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	759	t	module_project_parent_task_filter	base	ir.module.module
875	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	760	t	module_project_pivot	base	ir.module.module
876	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	761	t	module_project_portal_task_visibility	base	ir.module.module
877	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	762	t	module_project_purchase	base	ir.module.module
878	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	763	t	module_project_purchase_link	base	ir.module.module
879	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	764	t	module_project_risk	base	ir.module.module
880	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	765	t	module_project_role	base	ir.module.module
881	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	766	t	module_project_sale_expense	base	ir.module.module
882	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	767	t	module_project_scrum	base	ir.module.module
883	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	768	t	module_project_sequence	base	ir.module.module
884	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	769	t	module_project_sms	base	ir.module.module
885	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	770	t	module_project_stage_extra_info	base	ir.module.module
886	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	771	t	module_project_stage_last_update_date	base	ir.module.module
887	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	772	t	module_project_status	base	ir.module.module
888	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	773	t	module_project_stock	base	ir.module.module
889	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	774	t	module_project_stock_analytic_tag	base	ir.module.module
890	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	775	t	module_project_stock_product_set	base	ir.module.module
891	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	776	t	module_project_tag_hierarchy	base	ir.module.module
892	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	777	t	module_project_tag_multicompany	base	ir.module.module
893	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	778	t	module_project_tag_security	base	ir.module.module
894	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	779	t	module_project_task_add_very_high	base	ir.module.module
895	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	780	t	module_project_task_code	base	ir.module.module
896	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	781	t	module_project_task_code_portal	base	ir.module.module
897	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	782	t	module_project_task_creation_description_notification	base	ir.module.module
898	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	783	t	module_project_task_default_stage	base	ir.module.module
899	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	784	t	module_project_task_description_portal	base	ir.module.module
900	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	785	t	module_project_task_description_template	base	ir.module.module
901	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	786	t	module_project_task_link	base	ir.module.module
902	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	787	t	module_project_task_material	base	ir.module.module
903	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	788	t	module_project_task_name_with_id	base	ir.module.module
904	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	789	t	module_project_task_note	base	ir.module.module
905	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	790	t	module_project_task_parent_completion_blocking	base	ir.module.module
906	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	791	t	module_project_task_parent_due_auto	base	ir.module.module
907	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	792	t	module_project_task_personal_stage_auto_fold	base	ir.module.module
908	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	793	t	module_project_task_project_required	base	ir.module.module
909	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	794	t	module_project_task_pull_request	base	ir.module.module
910	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	795	t	module_project_task_pull_request_state	base	ir.module.module
911	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	796	t	module_project_task_recurring_activity	base	ir.module.module
912	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	797	t	module_project_task_stage_change_restriction	base	ir.module.module
913	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	798	t	module_project_task_stage_mgmt	base	ir.module.module
914	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	799	t	module_project_task_stage_state	base	ir.module.module
915	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	800	t	module_project_template	base	ir.module.module
916	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	801	t	module_project_timeline	base	ir.module.module
917	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	802	t	module_project_timeline_hr_timesheet	base	ir.module.module
918	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	803	t	module_project_timesheet_holidays	base	ir.module.module
919	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	804	t	module_project_timesheet_time_control	base	ir.module.module
920	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	805	t	module_project_type	base	ir.module.module
921	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	806	t	module_project_update_visible	base	ir.module.module
922	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	807	t	module_project_version	base	ir.module.module
923	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	808	t	module_purchase	base	ir.module.module
924	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	809	t	module_purchase_advance_payment	base	ir.module.module
925	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	810	t	module_purchase_all_shipments	base	ir.module.module
926	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	811	t	module_purchase_allowed_product	base	ir.module.module
927	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	812	t	module_purchase_analytic	base	ir.module.module
928	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	813	t	module_purchase_analytic_tag	base	ir.module.module
929	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	814	t	module_purchase_blanket_order	base	ir.module.module
930	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	815	t	module_purchase_cancel_reason	base	ir.module.module
931	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	816	t	module_purchase_commercial_partner	base	ir.module.module
932	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	817	t	module_purchase_date_planned_manual	base	ir.module.module
933	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	818	t	module_purchase_default_terms_conditions	base	ir.module.module
934	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	819	t	module_purchase_delivery_split_date	base	ir.module.module
935	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	820	t	module_purchase_deposit	base	ir.module.module
936	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	821	t	module_purchase_discount	base	ir.module.module
937	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	111	t	module_category_generic_modules_purchase	base	ir.module.category
938	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	822	t	module_purchase_exception	base	ir.module.module
939	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	823	t	module_purchase_fop_shipping	base	ir.module.module
940	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	824	t	module_purchase_force_invoiced	base	ir.module.module
941	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	825	t	module_purchase_force_invoiced_quantity	base	ir.module.module
942	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	826	t	module_purchase_fully_invoiced	base	ir.module.module
943	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	827	t	module_purchase_fully_received	base	ir.module.module
944	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	828	t	module_purchase_invoice_method	base	ir.module.module
945	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	829	t	module_purchase_invoice_new_picking_line	base	ir.module.module
946	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	830	t	module_purchase_invoice_plan	base	ir.module.module
947	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	831	t	module_purchase_invoicing_no_zero_line	base	ir.module.module
948	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	832	t	module_purchase_landed_cost	base	ir.module.module
949	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	833	t	module_purchase_last_price_info	base	ir.module.module
950	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	834	t	module_purchase_line_procurement_group	base	ir.module.module
951	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	835	t	module_purchase_location_by_line	base	ir.module.module
952	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	836	t	module_purchase_lot	base	ir.module.module
953	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	837	t	module_purchase_manual_delivery	base	ir.module.module
954	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	838	t	module_purchase_merge	base	ir.module.module
955	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	839	t	module_purchase_minimum_amount	base	ir.module.module
956	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	840	t	module_purchase_mrp	base	ir.module.module
957	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	841	t	module_purchase_mto_owner	base	ir.module.module
958	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	842	t	module_purchase_no_rfq	base	ir.module.module
959	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	843	t	module_purchase_only_by_packaging	base	ir.module.module
960	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	844	t	module_purchase_open_qty	base	ir.module.module
961	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	845	t	module_purchase_order_approval_block	base	ir.module.module
962	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	846	t	module_purchase_order_approved	base	ir.module.module
963	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	847	t	module_purchase_order_archive	base	ir.module.module
964	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	848	t	module_purchase_order_downpayment	base	ir.module.module
965	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	849	t	module_purchase_order_duplicate_check	base	ir.module.module
966	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	850	t	module_purchase_order_general_discount	base	ir.module.module
967	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	851	t	module_purchase_order_hide_receipt_status	base	ir.module.module
968	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	852	t	module_purchase_order_line_menu	base	ir.module.module
969	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	853	t	module_purchase_order_line_receipt_status	base	ir.module.module
970	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	854	t	module_purchase_order_line_sequence	base	ir.module.module
971	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	855	t	module_purchase_order_line_stock_available	base	ir.module.module
972	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	856	t	module_purchase_order_no_zero_price	base	ir.module.module
973	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	857	t	module_purchase_order_owner	base	ir.module.module
974	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	858	t	module_purchase_order_price_recalculation	base	ir.module.module
975	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	859	t	module_purchase_order_product_attachment_mgmt	base	ir.module.module
976	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	860	t	module_purchase_order_product_recommendation	base	ir.module.module
977	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	861	t	module_purchase_order_purchase_manager	base	ir.module.module
978	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	862	t	module_purchase_order_qty_change_no_recompute	base	ir.module.module
979	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	863	t	module_purchase_order_revision	base	ir.module.module
980	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	864	t	module_purchase_order_secondary_unit	base	ir.module.module
981	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	865	t	module_purchase_order_supplier_return	base	ir.module.module
982	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	866	t	module_purchase_order_supplierinfo_update	base	ir.module.module
983	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	867	t	module_purchase_order_type	base	ir.module.module
984	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	868	t	module_purchase_order_type_dashboard	base	ir.module.module
985	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	869	t	module_purchase_order_uninvoiced_amount	base	ir.module.module
986	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	870	t	module_purchase_order_uninvoiced_amount_line	base	ir.module.module
987	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	871	t	module_purchase_order_weight_volume	base	ir.module.module
988	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	872	t	module_purchase_packaging_default	base	ir.module.module
989	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	873	t	module_purchase_packaging_level_qty	base	ir.module.module
990	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	874	t	module_purchase_partner_incoterm	base	ir.module.module
991	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	875	t	module_purchase_partner_selectable_option	base	ir.module.module
992	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	876	t	module_purchase_price_diff	base	ir.module.module
993	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	877	t	module_purchase_product_matrix	base	ir.module.module
994	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	878	t	module_purchase_product_packaging_container_deposit	base	ir.module.module
995	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	879	t	module_purchase_quick	base	ir.module.module
996	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	880	t	module_purchase_reception_status	base	ir.module.module
997	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	881	t	module_purchase_reorder_control	base	ir.module.module
998	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	882	t	module_purchase_request	base	ir.module.module
999	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	883	t	module_purchase_request_department	base	ir.module.module
1000	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	884	t	module_purchase_request_exception	base	ir.module.module
1001	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	885	t	module_purchase_request_tier_validation	base	ir.module.module
1002	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	886	t	module_purchase_request_type	base	ir.module.module
1003	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	887	t	module_purchase_requisition	base	ir.module.module
1004	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	888	t	module_purchase_requisition_stock	base	ir.module.module
1005	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	889	t	module_purchase_requisition_tier_validation	base	ir.module.module
1006	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	890	t	module_purchase_return	base	ir.module.module
1007	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	891	t	module_purchase_sale_link_by_origin	base	ir.module.module
1008	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	892	t	module_purchase_security	base	ir.module.module
1009	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	893	t	module_purchase_sign	base	ir.module.module
1010	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	894	t	module_purchase_split_by_route	base	ir.module.module
1011	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	895	t	module_purchase_stock	base	ir.module.module
1012	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	896	t	module_purchase_stock_analytic	base	ir.module.module
1013	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	897	t	module_purchase_stock_packaging	base	ir.module.module
1014	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	898	t	module_purchase_stock_picking_return_invoicing	base	ir.module.module
1015	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	899	t	module_purchase_stock_price_unit_sync	base	ir.module.module
1016	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	900	t	module_purchase_tag	base	ir.module.module
1017	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	901	t	module_purchase_tier_validation	base	ir.module.module
1018	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	902	t	module_purchase_transport_mode	base	ir.module.module
1019	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	903	t	module_purchase_triple_discount	base	ir.module.module
1020	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	904	t	module_purchase_vendor_promotion	base	ir.module.module
1021	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	905	t	module_purchase_warn_message	base	ir.module.module
1022	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	906	t	module_purchase_work_acceptance	base	ir.module.module
1023	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	907	t	module_purchase_work_acceptance_evaluation	base	ir.module.module
1024	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	908	t	module_rating	base	ir.module.module
1025	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	112	t	module_category_maintenance	base	ir.module.category
1026	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	909	t	module_remove_odoo_enterprise	base	ir.module.module
1027	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	910	t	module_repair	base	ir.module.module
1028	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	911	t	module_report_async	base	ir.module.module
1029	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	912	t	module_report_company_details_translatable	base	ir.module.module
1030	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	913	t	module_report_context	base	ir.module.module
1031	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	914	t	module_report_csv	base	ir.module.module
1032	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	915	t	module_report_display_name_in_footer	base	ir.module.module
1033	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	916	t	module_report_footer_html	base	ir.module.module
1034	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	917	t	module_report_generate_helper	base	ir.module.module
1035	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	918	t	module_report_label	base	ir.module.module
1036	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	919	t	module_report_paperformat_company_dependent	base	ir.module.module
1037	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	920	t	module_report_py3o	base	ir.module.module
1038	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	921	t	module_report_py3o_fusion_server	base	ir.module.module
1039	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	922	t	module_report_qr	base	ir.module.module
1040	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	923	t	module_report_qweb_decimal_place	base	ir.module.module
1041	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	924	t	module_report_qweb_element_page_visibility	base	ir.module.module
1042	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	925	t	module_report_qweb_encrypt	base	ir.module.module
1043	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	926	t	module_report_qweb_field_option	base	ir.module.module
1044	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	113	t	module_category_reports	base	ir.module.category
1045	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	114	t	module_category_reports_qweb	base	ir.module.category
1046	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	927	t	module_report_qweb_operating_unit	base	ir.module.module
1047	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	928	t	module_report_qweb_parameter	base	ir.module.module
1048	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	929	t	module_report_qweb_pdf_cover	base	ir.module.module
1049	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	930	t	module_report_qweb_pdf_watermark	base	ir.module.module
1050	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	931	t	module_report_qweb_signer	base	ir.module.module
1051	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	932	t	module_report_substitute	base	ir.module.module
1052	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	933	t	module_report_text_format_option	base	ir.module.module
1053	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	934	t	module_report_wkhtmltopdf_param	base	ir.module.module
1054	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	935	t	module_report_xlsx	base	ir.module.module
1055	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	936	t	module_report_xlsx_helper	base	ir.module.module
1056	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	937	t	module_report_xml	base	ir.module.module
1057	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	938	t	module_resource	base	ir.module.module
1058	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	939	t	module_resource_multi_week_calendar	base	ir.module.module
1059	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	940	t	module_rpc_helper	base	ir.module.module
1060	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	941	t	module_sale	base	ir.module.module
1061	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	942	t	module_sale_analytic_tag	base	ir.module.module
1062	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	943	t	module_sale_credit_note_reversal	base	ir.module.module
1063	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	944	t	module_sale_crm	base	ir.module.module
1064	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	945	t	module_sale_expense	base	ir.module.module
1065	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	946	t	module_sale_expense_margin	base	ir.module.module
1066	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	947	t	module_sale_invoicing_date_from_picking	base	ir.module.module
1067	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	948	t	module_sale_invoicing_date_selection	base	ir.module.module
1068	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	949	t	module_sale_line_refund_to_invoice_qty	base	ir.module.module
1069	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	950	t	module_sale_line_refund_to_invoice_qty_skip_anglo_saxon	base	ir.module.module
1070	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	951	t	module_sale_loyalty	base	ir.module.module
1071	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	952	t	module_sale_loyalty_delivery	base	ir.module.module
1072	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	953	t	module_sale_management	base	ir.module.module
1073	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	954	t	module_sale_margin	base	ir.module.module
1074	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	955	t	module_sale_mrp	base	ir.module.module
1075	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	956	t	module_sale_mrp_margin	base	ir.module.module
1076	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	115	t	module_category_sales_management	base	ir.module.category
1077	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	957	t	module_sale_operating_unit	base	ir.module.module
1078	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	958	t	module_sale_order_invoicing_grouping_criteria	base	ir.module.module
1079	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	959	t	module_sale_order_invoicing_qty_percentage	base	ir.module.module
1080	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	960	t	module_sale_order_invoicing_queued	base	ir.module.module
1081	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	961	t	module_sale_product_configurator	base	ir.module.module
1082	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	962	t	module_sale_product_matrix	base	ir.module.module
1083	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	963	t	module_sale_project	base	ir.module.module
1084	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	964	t	module_sale_project_copy_tasks	base	ir.module.module
1085	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	965	t	module_sale_project_stock	base	ir.module.module
1086	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	966	t	module_sale_purchase	base	ir.module.module
1087	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	967	t	module_sale_purchase_force_vendor	base	ir.module.module
1088	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	968	t	module_sale_purchase_stock	base	ir.module.module
1089	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	969	t	module_sale_quotation_builder	base	ir.module.module
1090	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	970	t	module_sale_sms	base	ir.module.module
1091	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	971	t	module_sale_stock	base	ir.module.module
1092	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	972	t	module_sale_stock_margin	base	ir.module.module
1093	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	973	t	module_sale_stock_operating_unit	base	ir.module.module
1094	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	974	t	module_sale_stock_picking_invoicing	base	ir.module.module
1095	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	975	t	module_sale_timesheet	base	ir.module.module
1096	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	976	t	module_sale_timesheet_invoice_description	base	ir.module.module
1097	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	977	t	module_sale_timesheet_margin	base	ir.module.module
1098	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	978	t	module_sales_team	base	ir.module.module
1099	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	979	t	module_sales_team_operating_unit	base	ir.module.module
1100	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	980	t	module_scheduler_error_mailer	base	ir.module.module
1101	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	981	t	module_scrap_reason_code	base	ir.module.module
1102	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	982	t	module_sentry	base	ir.module.module
1103	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	983	t	module_sequence_check_digit	base	ir.module.module
1104	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	984	t	module_sequence_python	base	ir.module.module
1105	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	985	t	module_sequence_reset_period	base	ir.module.module
1106	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	986	t	module_server_action_logging	base	ir.module.module
1107	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	987	t	module_server_action_mass_edit	base	ir.module.module
1108	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	988	t	module_server_action_navigate	base	ir.module.module
1109	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	989	t	module_server_action_sort	base	ir.module.module
1110	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	990	t	module_server_environment	base	ir.module.module
1111	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	991	t	module_server_environment_data_encryption	base	ir.module.module
1112	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	992	t	module_server_environment_ir_config_parameter	base	ir.module.module
1113	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	993	t	module_session_db	base	ir.module.module
1114	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	994	t	module_sms	base	ir.module.module
1115	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	995	t	module_snailmail	base	ir.module.module
1116	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	996	t	module_snailmail_account	base	ir.module.module
1117	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	997	t	module_social_media	base	ir.module.module
1118	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	998	t	module_spreadsheet	base	ir.module.module
1119	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	999	t	module_spreadsheet_account	base	ir.module.module
1120	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1000	t	module_spreadsheet_dashboard	base	ir.module.module
1121	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1001	t	module_spreadsheet_dashboard_account	base	ir.module.module
1122	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1002	t	module_spreadsheet_dashboard_event_sale	base	ir.module.module
1123	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1003	t	module_spreadsheet_dashboard_hr_expense	base	ir.module.module
1124	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1004	t	module_spreadsheet_dashboard_hr_timesheet	base	ir.module.module
1125	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1005	t	module_spreadsheet_dashboard_im_livechat	base	ir.module.module
1126	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1006	t	module_spreadsheet_dashboard_pos_hr	base	ir.module.module
1127	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1007	t	module_spreadsheet_dashboard_purchase	base	ir.module.module
1128	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1008	t	module_spreadsheet_dashboard_purchase_stock	base	ir.module.module
1129	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1009	t	module_spreadsheet_dashboard_sale	base	ir.module.module
1130	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1010	t	module_spreadsheet_dashboard_sale_expense	base	ir.module.module
1131	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1011	t	module_spreadsheet_dashboard_sale_timesheet	base	ir.module.module
1132	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1012	t	module_spreadsheet_dashboard_stock_account	base	ir.module.module
1133	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1013	t	module_spreadsheet_dashboard_website_sale_slides	base	ir.module.module
1134	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	116	t	module_category_generic_modules_others	base	ir.module.category
1135	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1014	t	module_sql_export	base	ir.module.module
1136	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1015	t	module_sql_export_delta	base	ir.module.module
1137	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1016	t	module_sql_export_excel	base	ir.module.module
1138	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1017	t	module_sql_export_mail	base	ir.module.module
1139	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1018	t	module_sql_request_abstract	base	ir.module.module
1140	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1019	t	module_stock	base	ir.module.module
1141	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1020	t	module_stock_account	base	ir.module.module
1142	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1021	t	module_stock_account_anglo_saxon_cogs_kit	base	ir.module.module
1143	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1022	t	module_stock_account_move_reset_to_draft	base	ir.module.module
1144	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1023	t	module_stock_analytic	base	ir.module.module
1145	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1024	t	module_stock_cycle_count	base	ir.module.module
1146	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1025	t	module_stock_demand_estimate	base	ir.module.module
1147	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1026	t	module_stock_demand_estimate_matrix	base	ir.module.module
1148	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1027	t	module_stock_dropshipping	base	ir.module.module
1149	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	117	t	module_category_generic_modules_warehouse_management	base	ir.module.category
1150	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1028	t	module_stock_exception	base	ir.module.module
1151	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1029	t	module_stock_helper	base	ir.module.module
1152	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1030	t	module_stock_inventory	base	ir.module.module
1153	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1031	t	module_stock_inventory_count_to_zero	base	ir.module.module
3256	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	57	f	lang_pt_AO	base	res.lang
1154	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1032	t	module_stock_inventory_discrepancy	base	ir.module.module
1155	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1033	t	module_stock_inventory_justification	base	ir.module.module
1156	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1034	t	module_stock_inventory_lockdown	base	ir.module.module
1157	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	118	t	module_category_inventory,_logistic,_storage	base	ir.module.category
1158	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1035	t	module_stock_inventory_preparation_filter	base	ir.module.module
1159	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1036	t	module_stock_inventory_quantity_history	base	ir.module.module
1160	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1037	t	module_stock_landed_costs	base	ir.module.module
1161	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1038	t	module_stock_landed_costs_analytic	base	ir.module.module
1162	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1039	t	module_stock_location_children	base	ir.module.module
1163	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1040	t	module_stock_location_fill_state	base	ir.module.module
1164	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1041	t	module_stock_location_lockdown	base	ir.module.module
1165	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1042	t	module_stock_location_package_restriction	base	ir.module.module
1166	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1043	t	module_stock_location_pending_move	base	ir.module.module
1167	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	119	t	module_category_stock_management	base	ir.module.category
1168	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1044	t	module_stock_location_position	base	ir.module.module
1169	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1045	t	module_stock_location_product_restriction	base	ir.module.module
1170	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1046	t	module_stock_location_release_channel_restriction	base	ir.module.module
1171	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1047	t	module_stock_location_zone	base	ir.module.module
1172	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1048	t	module_stock_lot_multi_image	base	ir.module.module
1173	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1049	t	module_stock_move_auto_assign	base	ir.module.module
1174	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1050	t	module_stock_move_auto_assign_auto_release	base	ir.module.module
1175	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1051	t	module_stock_move_auto_assign_auto_release_exclude_location	base	ir.module.module
1176	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1052	t	module_stock_move_common_dest	base	ir.module.module
1177	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1053	t	module_stock_move_location	base	ir.module.module
1178	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1054	t	module_stock_move_packaging_qty	base	ir.module.module
1179	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1055	t	module_stock_mts_mto_rule	base	ir.module.module
1180	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	120	t	module_category_generic_modules_sales_and_purchases	base	ir.module.category
1181	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1056	t	module_stock_operating_unit	base	ir.module.module
1182	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1057	t	module_stock_operating_unit_access_all	base	ir.module.module
1183	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1058	t	module_stock_package_type_button_box	base	ir.module.module
1184	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1059	t	module_stock_package_type_category	base	ir.module.module
1185	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1060	t	module_stock_package_type_volume	base	ir.module.module
1186	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1061	t	module_stock_packaging_calculator	base	ir.module.module
1187	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1062	t	module_stock_packaging_calculator_packaging_level	base	ir.module.module
1188	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1063	t	module_stock_picking_analytic	base	ir.module.module
1189	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1064	t	module_stock_picking_batch	base	ir.module.module
1190	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1065	t	module_stock_picking_batch_packaging_qty	base	ir.module.module
1191	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1066	t	module_stock_picking_commercial_partner	base	ir.module.module
1192	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1067	t	module_stock_picking_invoicing	base	ir.module.module
1193	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1068	t	module_stock_picking_procure_method	base	ir.module.module
1194	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1069	t	module_stock_picking_product_interchangeable	base	ir.module.module
1195	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1070	t	module_stock_picking_return_refund_option	base	ir.module.module
1196	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1071	t	module_stock_picking_show_linked	base	ir.module.module
1197	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1072	t	module_stock_picking_volume	base	ir.module.module
1198	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1073	t	module_stock_picking_volume_packaging	base	ir.module.module
1199	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1074	t	module_stock_product_qty_by_packaging	base	ir.module.module
1200	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1075	t	module_stock_production_lot_quantity_tree	base	ir.module.module
1201	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1076	t	module_stock_pull_list	base	ir.module.module
1202	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1077	t	module_stock_putaway_product_template	base	ir.module.module
1203	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1078	t	module_stock_quant_cost_info	base	ir.module.module
1204	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1079	t	module_stock_quant_expiration_date_tree	base	ir.module.module
1205	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1080	t	module_stock_quant_manual_assign	base	ir.module.module
1206	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1081	t	module_stock_quant_reservation_info	base	ir.module.module
1207	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1082	t	module_stock_quant_reservation_info_mrp	base	ir.module.module
1208	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1083	t	module_stock_quant_safe_inventory	base	ir.module.module
1209	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1084	t	module_stock_removal_location_by_priority	base	ir.module.module
1210	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1085	t	module_stock_reservation_date_show	base	ir.module.module
1211	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1086	t	module_stock_reserve	base	ir.module.module
1212	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1087	t	module_stock_reserve_rule	base	ir.module.module
1213	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1088	t	module_stock_route_mto	base	ir.module.module
1214	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1089	t	module_stock_scrap_location_default	base	ir.module.module
1215	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1090	t	module_stock_search_supplierinfo_code	base	ir.module.module
1216	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1091	t	module_stock_secondary_unit	base	ir.module.module
1217	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1092	t	module_stock_sms	base	ir.module.module
3257	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	58	f	lang_pt_BR	base	res.lang
1218	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1093	t	module_stock_storage_category_capacity_name	base	ir.module.module
1219	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1094	t	module_stock_valuation_layer_accounting_date	base	ir.module.module
1220	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1095	t	module_stock_valuation_layer_inventory_filter	base	ir.module.module
1221	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1096	t	module_stock_valuation_layer_total_value	base	ir.module.module
1222	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1097	t	module_stock_vlm_mgmt	base	ir.module.module
1223	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1098	t	module_stock_vlm_mgmt_kardex	base	ir.module.module
1224	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1099	t	module_stock_vlm_mgmt_modula	base	ir.module.module
1225	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1100	t	module_stock_warehouse_calendar	base	ir.module.module
1226	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1101	t	module_stock_warehouse_relationship	base	ir.module.module
1227	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1102	t	module_supplier_calendar	base	ir.module.module
1228	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	121	t	module_category_marketing_surveys	base	ir.module.category
1229	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1103	t	module_survey	base	ir.module.module
1230	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1104	t	module_task_project_status	base	ir.module.module
1231	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1105	t	module_template_content_swapper	base	ir.module.module
1232	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1106	t	module_test_access_rights	base	ir.module.module
1233	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1107	t	module_test_action_bindings	base	ir.module.module
1234	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1108	t	module_test_apikeys	base	ir.module.module
1235	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1109	t	module_test_assetsbundle	base	ir.module.module
1236	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1110	t	module_test_auditlog	base	ir.module.module
1237	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1111	t	module_test_auth_custom	base	ir.module.module
1238	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1112	t	module_test_base_automation	base	ir.module.module
1239	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1113	t	module_test_base_binary_url_import	base	ir.module.module
1240	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1114	t	module_test_convert	base	ir.module.module
1241	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1115	t	module_test_converter	base	ir.module.module
1242	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1116	t	module_test_crm_full	base	ir.module.module
1243	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1117	t	module_test_data_module	base	ir.module.module
1244	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1118	t	module_test_data_module_install	base	ir.module.module
1245	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1119	t	module_test_discuss_full	base	ir.module.module
1246	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1120	t	module_test_event_full	base	ir.module.module
1247	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1121	t	module_test_exceptions	base	ir.module.module
1248	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1122	t	module_test_http	base	ir.module.module
1249	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1123	t	module_test_impex	base	ir.module.module
1250	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1124	t	module_test_inherit	base	ir.module.module
1251	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1125	t	module_test_inherit_depends	base	ir.module.module
1252	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1126	t	module_test_inherits	base	ir.module.module
1253	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1127	t	module_test_inherits_depends	base	ir.module.module
1254	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1128	t	module_test_limits	base	ir.module.module
1255	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1129	t	module_test_lint	base	ir.module.module
1256	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1130	t	module_test_mail	base	ir.module.module
1257	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1131	t	module_test_mail_full	base	ir.module.module
1258	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1132	t	module_test_mail_sms	base	ir.module.module
1259	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1133	t	module_test_main_flows	base	ir.module.module
1260	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1134	t	module_test_mass_mailing	base	ir.module.module
1261	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1135	t	module_test_mimetypes	base	ir.module.module
1262	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1136	t	module_test_new_api	base	ir.module.module
1263	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1137	t	module_test_performance	base	ir.module.module
1264	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	122	t	module_category_tests	base	ir.module.category
1265	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1138	t	module_test_populate	base	ir.module.module
1266	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1139	t	module_test_read_group	base	ir.module.module
1267	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1140	t	module_test_resource	base	ir.module.module
1268	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1141	t	module_test_rpc	base	ir.module.module
1269	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1142	t	module_test_sale_product_configurators	base	ir.module.module
1270	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1143	t	module_test_search_panel	base	ir.module.module
1271	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1144	t	module_test_testing_utilities	base	ir.module.module
1272	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1145	t	module_test_translation_import	base	ir.module.module
1273	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1146	t	module_test_uninstall	base	ir.module.module
1274	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1147	t	module_test_website	base	ir.module.module
1275	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1148	t	module_test_website_modules	base	ir.module.module
1276	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1149	t	module_test_website_slides_full	base	ir.module.module
1277	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1150	t	module_test_xlsx_export	base	ir.module.module
1279	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1151	t	module_theme_default	base	ir.module.module
1280	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1152	t	module_tracking_manager	base	ir.module.module
1281	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1153	t	module_transifex	base	ir.module.module
1282	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1154	t	module_uom	base	ir.module.module
1283	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	124	t	module_category_migration	base	ir.module.category
1284	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1155	t	module_upgrade_analysis	base	ir.module.module
1285	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1156	t	module_url_attachment_search_fuzzy	base	ir.module.module
1286	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1157	t	module_user_all_groups	base	ir.module.module
1287	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1158	t	module_user_log_view	base	ir.module.module
1288	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1159	t	module_users_ldap_groups	base	ir.module.module
1289	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1160	t	module_users_ldap_mail	base	ir.module.module
1290	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1161	t	module_users_ldap_populate	base	ir.module.module
1291	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1162	t	module_utm	base	ir.module.module
1292	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	125	t	module_category_vault	base	ir.module.category
1293	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1163	t	module_vault	base	ir.module.module
1294	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1164	t	module_vault_share	base	ir.module.module
1295	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1165	t	module_web	base	ir.module.module
1296	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1166	t	module_web_action_conditionable	base	ir.module.module
1297	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1167	t	module_web_advanced_search	base	ir.module.module
1298	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	126	t	module_category_web	base	ir.module.category
1299	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1168	t	module_web_apply_field_style	base	ir.module.module
1300	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1169	t	module_web_calendar_slot_duration	base	ir.module.module
1301	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1170	t	module_web_chatter_camera	base	ir.module.module
1302	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1171	t	module_web_chatter_position	base	ir.module.module
1303	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1172	t	module_web_company_color	base	ir.module.module
1304	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1173	t	module_web_copy_confirm	base	ir.module.module
1305	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1174	t	module_web_dark_mode	base	ir.module.module
1306	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1175	t	module_web_dashboard_tile	base	ir.module.module
1307	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1176	t	module_web_datetime_picker_default_time	base	ir.module.module
1308	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1177	t	module_web_dialog_size	base	ir.module.module
1309	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1178	t	module_web_disable_export_group	base	ir.module.module
1310	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1179	t	module_web_domain_field	base	ir.module.module
1311	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1180	t	module_web_editor	base	ir.module.module
1312	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1181	t	module_web_editor_class_selector	base	ir.module.module
1313	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1182	t	module_web_environment_ribbon	base	ir.module.module
1314	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1183	t	module_web_export_html_as_text	base	ir.module.module
1315	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1184	t	module_web_field_numeric_formatting	base	ir.module.module
1316	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1185	t	module_web_field_tooltip	base	ir.module.module
1317	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1186	t	module_web_form_banner	base	ir.module.module
1318	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1187	t	module_web_group_by_percentage	base	ir.module.module
1319	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1188	t	module_web_group_expand	base	ir.module.module
1320	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1189	t	module_web_help	base	ir.module.module
1321	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1190	t	module_web_hide_field_with_key	base	ir.module.module
1322	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1191	t	module_web_ir_actions_act_multi	base	ir.module.module
1323	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1192	t	module_web_ir_actions_act_window_message	base	ir.module.module
1324	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1193	t	module_web_ir_actions_act_window_page	base	ir.module.module
1325	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1194	t	module_web_ir_actions_close_wizard_refresh_view	base	ir.module.module
1326	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1195	t	module_web_kanban_gauge	base	ir.module.module
1327	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1196	t	module_web_listview_range_select	base	ir.module.module
1328	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1197	t	module_web_m2x_options	base	ir.module.module
1329	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1198	t	module_web_m2x_options_manager	base	ir.module.module
1330	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1199	t	module_web_no_bubble	base	ir.module.module
1331	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1200	t	module_web_notify	base	ir.module.module
1332	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1201	t	module_web_notify_channel_message	base	ir.module.module
1333	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1202	t	module_web_notify_upgrade	base	ir.module.module
1334	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1203	t	module_web_pivot_computed_measure	base	ir.module.module
1335	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1204	t	module_web_pwa_oca	base	ir.module.module
1336	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1205	t	module_web_quick_start_screen	base	ir.module.module
1337	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1206	t	module_web_refresher	base	ir.module.module
1338	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1207	t	module_web_remember_tree_column_width	base	ir.module.module
1339	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1208	t	module_web_responsive	base	ir.module.module
1340	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1209	t	module_web_save_discard_button	base	ir.module.module
1341	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1210	t	module_web_search_with_and	base	ir.module.module
1342	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1211	t	module_web_searchbar_full_width	base	ir.module.module
1343	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1212	t	module_web_select_all_companies	base	ir.module.module
1344	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1213	t	module_web_send_message_popup	base	ir.module.module
1345	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1214	t	module_web_sheet_full_width	base	ir.module.module
1346	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1215	t	module_web_systray_button_init_action	base	ir.module.module
1347	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1216	t	module_web_theme_classic	base	ir.module.module
1348	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1217	t	module_web_time_range_menu_custom	base	ir.module.module
1349	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1218	t	module_web_timeline	base	ir.module.module
1350	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1219	t	module_web_touchscreen	base	ir.module.module
1351	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1220	t	module_web_tour	base	ir.module.module
1352	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1221	t	module_web_tree_duplicate	base	ir.module.module
1353	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1222	t	module_web_tree_dynamic_colored_field	base	ir.module.module
1354	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1223	t	module_web_tree_many2one_clickable	base	ir.module.module
1355	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1224	t	module_web_unsplash	base	ir.module.module
1356	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1225	t	module_web_widget_bokeh_chart	base	ir.module.module
1357	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1226	t	module_web_widget_char_size	base	ir.module.module
1358	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1227	t	module_web_widget_datepicker_fulloptions	base	ir.module.module
1359	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1228	t	module_web_widget_domain_editor_dialog	base	ir.module.module
1360	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1229	t	module_web_widget_dropdown_dynamic	base	ir.module.module
1361	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1230	t	module_web_widget_image_download	base	ir.module.module
1362	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1231	t	module_web_widget_image_webcam	base	ir.module.module
1363	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1232	t	module_web_widget_mpld3_chart	base	ir.module.module
1364	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1233	t	module_web_widget_numeric_step	base	ir.module.module
1365	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1234	t	module_web_widget_one2many_tree_line_duplicate	base	ir.module.module
1366	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1235	t	module_web_widget_open_tab	base	ir.module.module
1367	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1236	t	module_web_widget_pattern	base	ir.module.module
1368	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1237	t	module_web_widget_pattern_partner_autocomplete	base	ir.module.module
1369	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1238	t	module_web_widget_plotly_chart	base	ir.module.module
1370	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1239	t	module_web_widget_product_label_section_and_note	base	ir.module.module
1371	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1240	t	module_web_widget_progressbar_gradient	base	ir.module.module
1372	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1241	t	module_web_widget_remaining_days_exact_date	base	ir.module.module
1373	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1242	t	module_web_widget_x2many_2d_matrix	base	ir.module.module
1374	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	127	t	module_category_website_website	base	ir.module.category
1375	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1243	t	module_website	base	ir.module.module
1376	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1244	t	module_website_blog	base	ir.module.module
1377	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1245	t	module_website_crm	base	ir.module.module
1378	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1246	t	module_website_crm_iap_reveal	base	ir.module.module
1379	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1247	t	module_website_crm_livechat	base	ir.module.module
1380	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1248	t	module_website_crm_partner_assign	base	ir.module.module
1381	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1249	t	module_website_crm_sms	base	ir.module.module
1382	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1250	t	module_website_customer	base	ir.module.module
1383	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1251	t	module_website_event	base	ir.module.module
1384	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1252	t	module_website_event_booth	base	ir.module.module
1385	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1253	t	module_website_event_booth_exhibitor	base	ir.module.module
1386	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1254	t	module_website_event_booth_sale	base	ir.module.module
1387	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1255	t	module_website_event_booth_sale_exhibitor	base	ir.module.module
1388	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1256	t	module_website_event_crm	base	ir.module.module
1389	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1257	t	module_website_event_crm_questions	base	ir.module.module
1390	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1258	t	module_website_event_exhibitor	base	ir.module.module
1391	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1259	t	module_website_event_jitsi	base	ir.module.module
1392	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1260	t	module_website_event_meet	base	ir.module.module
1393	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1261	t	module_website_event_meet_quiz	base	ir.module.module
1394	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1262	t	module_website_event_questions	base	ir.module.module
1395	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1263	t	module_website_event_sale	base	ir.module.module
1396	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1264	t	module_website_event_track	base	ir.module.module
1397	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1265	t	module_website_event_track_live	base	ir.module.module
1398	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1266	t	module_website_event_track_live_quiz	base	ir.module.module
1399	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1267	t	module_website_event_track_quiz	base	ir.module.module
1400	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1268	t	module_website_form_project	base	ir.module.module
1401	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1269	t	module_website_forum	base	ir.module.module
1402	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1270	t	module_website_google_map	base	ir.module.module
1403	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1271	t	module_website_hr_recruitment	base	ir.module.module
1404	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1272	t	module_website_jitsi	base	ir.module.module
1405	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1273	t	module_website_links	base	ir.module.module
1406	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1274	t	module_website_livechat	base	ir.module.module
1407	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1275	t	module_website_mail	base	ir.module.module
1408	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1276	t	module_website_mail_group	base	ir.module.module
1409	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1277	t	module_website_mass_mailing	base	ir.module.module
1410	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1278	t	module_website_mass_mailing_sms	base	ir.module.module
1411	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1279	t	module_website_membership	base	ir.module.module
1412	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1280	t	module_website_partner	base	ir.module.module
1413	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1281	t	module_website_payment	base	ir.module.module
1414	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1282	t	module_website_payment_authorize	base	ir.module.module
1415	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1283	t	module_website_payment_paypal	base	ir.module.module
1416	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1284	t	module_website_profile	base	ir.module.module
1417	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1285	t	module_website_sale	base	ir.module.module
1418	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1286	t	module_website_sale_autocomplete	base	ir.module.module
1419	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1287	t	module_website_sale_comparison	base	ir.module.module
1420	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1288	t	module_website_sale_comparison_wishlist	base	ir.module.module
1421	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1289	t	module_website_sale_delivery	base	ir.module.module
1422	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1290	t	module_website_sale_delivery_mondialrelay	base	ir.module.module
1423	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1291	t	module_website_sale_digital	base	ir.module.module
1424	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1292	t	module_website_sale_loyalty	base	ir.module.module
1425	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1293	t	module_website_sale_loyalty_delivery	base	ir.module.module
1426	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1294	t	module_website_sale_picking	base	ir.module.module
1427	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1295	t	module_website_sale_product_configurator	base	ir.module.module
1428	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1296	t	module_website_sale_slides	base	ir.module.module
1429	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1297	t	module_website_sale_stock	base	ir.module.module
1430	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1298	t	module_website_sale_stock_product_configurator	base	ir.module.module
1431	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1299	t	module_website_sale_stock_wishlist	base	ir.module.module
1432	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1300	t	module_website_sale_wishlist	base	ir.module.module
1433	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	128	t	module_category_website_elearning	base	ir.module.category
1434	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1301	t	module_website_slides	base	ir.module.module
1435	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1302	t	module_website_slides_forum	base	ir.module.module
1436	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1303	t	module_website_slides_survey	base	ir.module.module
1437	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1304	t	module_website_sms	base	ir.module.module
1438	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1305	t	module_website_twitter	base	ir.module.module
1439	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	f	model_base	base	ir.model
1440	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	f	model__unknown	base	ir.model
1441	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	f	model_ir_model	base	ir.model
1442	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	f	model_ir_model_fields	base	ir.model
1443	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	f	model_ir_model_fields_selection	base	ir.model
1444	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	f	model_ir_model_constraint	base	ir.model
1445	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	f	model_ir_model_relation	base	ir.model
1446	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	f	model_ir_model_access	base	ir.model
1447	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	f	model_ir_model_data	base	ir.model
1448	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	f	model_wizard_ir_model_menu_create	base	ir.model
1449	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	11	f	model_ir_sequence	base	ir.model
1450	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	f	model_ir_sequence_date_range	base	ir.model
1451	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	13	f	model_ir_ui_menu	base	ir.model
1452	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	14	f	model_ir_ui_view_custom	base	ir.model
1453	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	15	f	model_ir_ui_view	base	ir.model
1454	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	16	f	model_reset_view_arch_wizard	base	ir.model
1455	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	17	f	model_ir_asset	base	ir.model
1456	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	18	f	model_ir_actions_actions	base	ir.model
1457	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	19	f	model_ir_actions_act_window	base	ir.model
1458	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	20	f	model_ir_actions_act_window_view	base	ir.model
1459	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	21	f	model_ir_actions_act_window_close	base	ir.model
1460	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	22	f	model_ir_actions_act_url	base	ir.model
1461	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	23	f	model_ir_actions_server	base	ir.model
1462	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	24	f	model_ir_server_object_lines	base	ir.model
1463	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	25	f	model_ir_actions_todo	base	ir.model
1464	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	26	f	model_ir_actions_client	base	ir.model
1465	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	27	f	model_ir_actions_report	base	ir.model
1466	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	28	f	model_ir_attachment	base	ir.model
1467	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	29	f	model_ir_binary	base	ir.model
1468	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	30	f	model_ir_cron	base	ir.model
1469	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	31	f	model_ir_cron_trigger	base	ir.model
1470	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	32	f	model_ir_filters	base	ir.model
1471	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	33	f	model_ir_default	base	ir.model
1472	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	34	f	model_ir_exports	base	ir.model
1473	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	35	f	model_ir_exports_line	base	ir.model
1474	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	36	f	model_ir_rule	base	ir.model
1475	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	37	f	model_ir_config_parameter	base	ir.model
1476	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	38	f	model_ir_autovacuum	base	ir.model
1477	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	39	f	model_ir_mail_server	base	ir.model
1478	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	40	f	model_ir_fields_converter	base	ir.model
1479	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	41	f	model_ir_qweb	base	ir.model
1480	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	42	f	model_ir_qweb_field	base	ir.model
1481	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	43	f	model_ir_qweb_field_integer	base	ir.model
1482	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	44	f	model_ir_qweb_field_float	base	ir.model
1483	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	45	f	model_ir_qweb_field_date	base	ir.model
1484	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	46	f	model_ir_qweb_field_datetime	base	ir.model
1485	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	47	f	model_ir_qweb_field_text	base	ir.model
1486	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	48	f	model_ir_qweb_field_selection	base	ir.model
1487	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	49	f	model_ir_qweb_field_many2one	base	ir.model
1488	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	50	f	model_ir_qweb_field_many2many	base	ir.model
1489	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	51	f	model_ir_qweb_field_html	base	ir.model
1490	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	52	f	model_ir_qweb_field_image	base	ir.model
1491	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	53	f	model_ir_qweb_field_image_url	base	ir.model
1492	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	54	f	model_ir_qweb_field_monetary	base	ir.model
1493	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	55	f	model_ir_qweb_field_float_time	base	ir.model
1494	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	56	f	model_ir_qweb_field_time	base	ir.model
1495	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	57	f	model_ir_qweb_field_duration	base	ir.model
1496	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	58	f	model_ir_qweb_field_relative	base	ir.model
1497	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	59	f	model_ir_qweb_field_barcode	base	ir.model
1498	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	60	f	model_ir_qweb_field_contact	base	ir.model
1499	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	61	f	model_ir_qweb_field_qweb	base	ir.model
1500	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	62	f	model_ir_http	base	ir.model
1501	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	63	f	model_ir_logging	base	ir.model
1502	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	64	f	model_ir_property	base	ir.model
1503	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	65	f	model_ir_module_category	base	ir.model
1504	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	66	f	model_ir_module_module	base	ir.model
1505	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	67	f	model_ir_module_module_dependency	base	ir.model
1506	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	68	f	model_ir_module_module_exclusion	base	ir.model
1507	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	69	f	model_ir_demo	base	ir.model
1508	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	70	f	model_ir_demo_failure	base	ir.model
1509	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	71	f	model_ir_demo_failure_wizard	base	ir.model
1510	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	72	f	model_report_layout	base	ir.model
1511	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	73	f	model_report_paperformat	base	ir.model
1512	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	74	f	model_ir_profile	base	ir.model
1513	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	75	f	model_base_enable_profiling_wizard	base	ir.model
1514	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	76	f	model_image_mixin	base	ir.model
1515	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	77	f	model_avatar_mixin	base	ir.model
1516	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	78	f	model_res_country	base	ir.model
1517	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	79	f	model_res_country_group	base	ir.model
1518	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	80	f	model_res_country_state	base	ir.model
1519	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	81	f	model_res_lang	base	ir.model
1520	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	82	f	model_format_address_mixin	base	ir.model
1521	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	83	f	model_res_partner_category	base	ir.model
1522	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	84	f	model_res_partner_title	base	ir.model
1523	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	85	f	model_res_partner	base	ir.model
1524	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	86	f	model_res_partner_industry	base	ir.model
1525	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	87	f	model_res_bank	base	ir.model
1526	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	88	f	model_res_partner_bank	base	ir.model
1527	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	89	f	model_res_config	base	ir.model
1528	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	90	f	model_res_config_installer	base	ir.model
1529	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	91	f	model_res_config_settings	base	ir.model
1530	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	92	f	model_res_currency	base	ir.model
1531	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	93	f	model_res_currency_rate	base	ir.model
1532	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	94	f	model_res_company	base	ir.model
1533	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	95	f	model_res_groups	base	ir.model
1534	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	96	f	model_res_users_log	base	ir.model
1535	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	97	f	model_res_users	base	ir.model
1536	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	98	f	model_res_users_identitycheck	base	ir.model
1537	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	99	f	model_change_password_wizard	base	ir.model
1538	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	100	f	model_change_password_user	base	ir.model
1539	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	101	f	model_change_password_own	base	ir.model
1540	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	102	f	model_res_users_apikeys	base	ir.model
1541	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	103	f	model_res_users_apikeys_description	base	ir.model
1542	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	104	f	model_res_users_apikeys_show	base	ir.model
1543	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	105	f	model_res_users_deletion	base	ir.model
1544	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	106	f	model_decimal_precision	base	ir.model
1545	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	107	f	model_report_base_report_irmodulereference	base	ir.model
1546	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	108	f	model_base_module_update	base	ir.model
1547	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	109	f	model_base_language_install	base	ir.model
1548	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	110	f	model_base_language_import	base	ir.model
1549	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	111	f	model_base_module_upgrade	base	ir.model
1550	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	112	f	model_base_module_uninstall	base	ir.model
1551	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	113	f	model_base_language_export	base	ir.model
1552	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	114	f	model_base_partner_merge_line	base	ir.model
1553	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	115	f	model_base_partner_merge_automatic_wizard	base	ir.model
1554	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	f	field_ir_model__name	base	ir.model.fields
1555	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	f	field_ir_model__model	base	ir.model.fields
1556	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	f	field_ir_model__order	base	ir.model.fields
1557	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	f	field_ir_model__info	base	ir.model.fields
1558	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	f	field_ir_model__field_id	base	ir.model.fields
1559	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	f	field_ir_model__inherited_model_ids	base	ir.model.fields
1560	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	f	field_ir_model__state	base	ir.model.fields
1561	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	f	field_ir_model__access_ids	base	ir.model.fields
1562	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	f	field_ir_model__rule_ids	base	ir.model.fields
1563	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	f	field_ir_model__transient	base	ir.model.fields
1564	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	11	f	field_ir_model__modules	base	ir.model.fields
1565	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	f	field_ir_model__view_ids	base	ir.model.fields
1566	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	13	f	field_ir_model__count	base	ir.model.fields
1567	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	14	f	field_ir_model__id	base	ir.model.fields
1568	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	15	f	field_ir_model____last_update	base	ir.model.fields
1569	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	16	f	field_ir_model__display_name	base	ir.model.fields
1570	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	17	f	field_ir_model__create_uid	base	ir.model.fields
1571	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	18	f	field_ir_model__create_date	base	ir.model.fields
1572	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	19	f	field_ir_model__write_uid	base	ir.model.fields
1573	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	20	f	field_ir_model__write_date	base	ir.model.fields
1574	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	21	f	field_ir_model_fields__name	base	ir.model.fields
1575	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	22	f	field_ir_model_fields__complete_name	base	ir.model.fields
1576	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	23	f	field_ir_model_fields__model	base	ir.model.fields
1577	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	24	f	field_ir_model_fields__relation	base	ir.model.fields
1578	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	25	f	field_ir_model_fields__relation_field	base	ir.model.fields
1579	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	26	f	field_ir_model_fields__relation_field_id	base	ir.model.fields
1580	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	27	f	field_ir_model_fields__model_id	base	ir.model.fields
1581	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	28	f	field_ir_model_fields__field_description	base	ir.model.fields
1582	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	29	f	field_ir_model_fields__help	base	ir.model.fields
1583	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	30	f	field_ir_model_fields__ttype	base	ir.model.fields
1584	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	31	f	field_ir_model_fields__selection	base	ir.model.fields
1585	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	32	f	field_ir_model_fields__selection_ids	base	ir.model.fields
1586	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	33	f	field_ir_model_fields__copied	base	ir.model.fields
1587	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	34	f	field_ir_model_fields__related	base	ir.model.fields
1588	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	35	f	field_ir_model_fields__related_field_id	base	ir.model.fields
1589	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	36	f	field_ir_model_fields__required	base	ir.model.fields
1590	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	37	f	field_ir_model_fields__readonly	base	ir.model.fields
1591	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	38	f	field_ir_model_fields__index	base	ir.model.fields
1592	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	39	f	field_ir_model_fields__translate	base	ir.model.fields
1593	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	40	f	field_ir_model_fields__size	base	ir.model.fields
1594	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	41	f	field_ir_model_fields__state	base	ir.model.fields
1595	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	42	f	field_ir_model_fields__on_delete	base	ir.model.fields
1596	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	43	f	field_ir_model_fields__domain	base	ir.model.fields
1597	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	44	f	field_ir_model_fields__groups	base	ir.model.fields
1598	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	45	f	field_ir_model_fields__group_expand	base	ir.model.fields
1599	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	46	f	field_ir_model_fields__selectable	base	ir.model.fields
1600	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	47	f	field_ir_model_fields__modules	base	ir.model.fields
1601	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	48	f	field_ir_model_fields__relation_table	base	ir.model.fields
1602	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	49	f	field_ir_model_fields__column1	base	ir.model.fields
1603	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	50	f	field_ir_model_fields__column2	base	ir.model.fields
1604	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	51	f	field_ir_model_fields__compute	base	ir.model.fields
1605	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	52	f	field_ir_model_fields__depends	base	ir.model.fields
1606	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	53	f	field_ir_model_fields__store	base	ir.model.fields
1607	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	54	f	field_ir_model_fields__id	base	ir.model.fields
1608	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	55	f	field_ir_model_fields____last_update	base	ir.model.fields
1609	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	56	f	field_ir_model_fields__display_name	base	ir.model.fields
1610	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	57	f	field_ir_model_fields__create_uid	base	ir.model.fields
1611	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	58	f	field_ir_model_fields__create_date	base	ir.model.fields
1612	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	59	f	field_ir_model_fields__write_uid	base	ir.model.fields
1613	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	60	f	field_ir_model_fields__write_date	base	ir.model.fields
1614	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	61	f	field_ir_model_fields_selection__field_id	base	ir.model.fields
1615	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	62	f	field_ir_model_fields_selection__value	base	ir.model.fields
1616	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	63	f	field_ir_model_fields_selection__name	base	ir.model.fields
1617	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	64	f	field_ir_model_fields_selection__sequence	base	ir.model.fields
1618	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	65	f	field_ir_model_fields_selection__id	base	ir.model.fields
1619	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	66	f	field_ir_model_fields_selection____last_update	base	ir.model.fields
1620	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	67	f	field_ir_model_fields_selection__display_name	base	ir.model.fields
1621	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	68	f	field_ir_model_fields_selection__create_uid	base	ir.model.fields
1622	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	69	f	field_ir_model_fields_selection__create_date	base	ir.model.fields
1623	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	70	f	field_ir_model_fields_selection__write_uid	base	ir.model.fields
1624	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	71	f	field_ir_model_fields_selection__write_date	base	ir.model.fields
1625	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	72	f	field_ir_model_constraint__name	base	ir.model.fields
1626	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	73	f	field_ir_model_constraint__definition	base	ir.model.fields
1627	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	74	f	field_ir_model_constraint__message	base	ir.model.fields
1628	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	75	f	field_ir_model_constraint__model	base	ir.model.fields
1629	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	76	f	field_ir_model_constraint__module	base	ir.model.fields
1630	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	77	f	field_ir_model_constraint__type	base	ir.model.fields
1631	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	78	f	field_ir_model_constraint__write_date	base	ir.model.fields
1632	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	79	f	field_ir_model_constraint__create_date	base	ir.model.fields
1633	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	80	f	field_ir_model_constraint__id	base	ir.model.fields
1634	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	81	f	field_ir_model_constraint____last_update	base	ir.model.fields
1635	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	82	f	field_ir_model_constraint__display_name	base	ir.model.fields
1636	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	83	f	field_ir_model_constraint__create_uid	base	ir.model.fields
1637	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	84	f	field_ir_model_constraint__write_uid	base	ir.model.fields
1638	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	85	f	field_ir_model_relation__name	base	ir.model.fields
1639	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	86	f	field_ir_model_relation__model	base	ir.model.fields
1640	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	87	f	field_ir_model_relation__module	base	ir.model.fields
1641	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	88	f	field_ir_model_relation__write_date	base	ir.model.fields
1642	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	89	f	field_ir_model_relation__create_date	base	ir.model.fields
1643	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	90	f	field_ir_model_relation__id	base	ir.model.fields
1644	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	91	f	field_ir_model_relation____last_update	base	ir.model.fields
1645	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	92	f	field_ir_model_relation__display_name	base	ir.model.fields
1646	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	93	f	field_ir_model_relation__create_uid	base	ir.model.fields
1647	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	94	f	field_ir_model_relation__write_uid	base	ir.model.fields
1648	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	95	f	field_ir_model_access__name	base	ir.model.fields
1649	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	96	f	field_ir_model_access__active	base	ir.model.fields
1650	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	97	f	field_ir_model_access__model_id	base	ir.model.fields
1651	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	98	f	field_ir_model_access__group_id	base	ir.model.fields
1652	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	99	f	field_ir_model_access__perm_read	base	ir.model.fields
1653	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	100	f	field_ir_model_access__perm_write	base	ir.model.fields
1654	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	101	f	field_ir_model_access__perm_create	base	ir.model.fields
1655	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	102	f	field_ir_model_access__perm_unlink	base	ir.model.fields
1656	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	103	f	field_ir_model_access__id	base	ir.model.fields
1657	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	104	f	field_ir_model_access____last_update	base	ir.model.fields
1658	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	105	f	field_ir_model_access__display_name	base	ir.model.fields
1659	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	106	f	field_ir_model_access__create_uid	base	ir.model.fields
1660	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	107	f	field_ir_model_access__create_date	base	ir.model.fields
1661	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	108	f	field_ir_model_access__write_uid	base	ir.model.fields
1662	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	109	f	field_ir_model_access__write_date	base	ir.model.fields
1663	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	110	f	field_ir_model_data__name	base	ir.model.fields
1664	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	111	f	field_ir_model_data__complete_name	base	ir.model.fields
1665	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	112	f	field_ir_model_data__model	base	ir.model.fields
1666	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	113	f	field_ir_model_data__module	base	ir.model.fields
1667	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	114	f	field_ir_model_data__res_id	base	ir.model.fields
1668	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	115	f	field_ir_model_data__noupdate	base	ir.model.fields
1669	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	116	f	field_ir_model_data__reference	base	ir.model.fields
1670	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	117	f	field_ir_model_data__id	base	ir.model.fields
1671	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	118	f	field_ir_model_data____last_update	base	ir.model.fields
1672	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	119	f	field_ir_model_data__display_name	base	ir.model.fields
1673	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	120	f	field_ir_model_data__create_uid	base	ir.model.fields
1674	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	121	f	field_ir_model_data__create_date	base	ir.model.fields
1675	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	122	f	field_ir_model_data__write_uid	base	ir.model.fields
1676	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	123	f	field_ir_model_data__write_date	base	ir.model.fields
1677	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	124	f	field_wizard_ir_model_menu_create__menu_id	base	ir.model.fields
1678	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	125	f	field_wizard_ir_model_menu_create__name	base	ir.model.fields
1679	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	126	f	field_wizard_ir_model_menu_create__id	base	ir.model.fields
1680	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	127	f	field_wizard_ir_model_menu_create____last_update	base	ir.model.fields
1681	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	128	f	field_wizard_ir_model_menu_create__display_name	base	ir.model.fields
1682	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	129	f	field_wizard_ir_model_menu_create__create_uid	base	ir.model.fields
1683	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	130	f	field_wizard_ir_model_menu_create__create_date	base	ir.model.fields
1684	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	131	f	field_wizard_ir_model_menu_create__write_uid	base	ir.model.fields
1685	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	132	f	field_wizard_ir_model_menu_create__write_date	base	ir.model.fields
1686	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	133	f	field_ir_sequence__name	base	ir.model.fields
1687	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	134	f	field_ir_sequence__code	base	ir.model.fields
1688	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	135	f	field_ir_sequence__implementation	base	ir.model.fields
1689	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	136	f	field_ir_sequence__active	base	ir.model.fields
1690	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	137	f	field_ir_sequence__prefix	base	ir.model.fields
1691	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	138	f	field_ir_sequence__suffix	base	ir.model.fields
1692	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	139	f	field_ir_sequence__number_next	base	ir.model.fields
1693	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	140	f	field_ir_sequence__number_next_actual	base	ir.model.fields
1694	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	141	f	field_ir_sequence__number_increment	base	ir.model.fields
1695	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	142	f	field_ir_sequence__padding	base	ir.model.fields
1696	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	143	f	field_ir_sequence__company_id	base	ir.model.fields
1697	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	144	f	field_ir_sequence__use_date_range	base	ir.model.fields
1698	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	145	f	field_ir_sequence__date_range_ids	base	ir.model.fields
1699	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	146	f	field_ir_sequence__id	base	ir.model.fields
1700	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	147	f	field_ir_sequence____last_update	base	ir.model.fields
1701	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	148	f	field_ir_sequence__display_name	base	ir.model.fields
1702	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	149	f	field_ir_sequence__create_uid	base	ir.model.fields
1703	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	150	f	field_ir_sequence__create_date	base	ir.model.fields
1704	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	151	f	field_ir_sequence__write_uid	base	ir.model.fields
1705	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	152	f	field_ir_sequence__write_date	base	ir.model.fields
1706	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	153	f	field_ir_sequence_date_range__date_from	base	ir.model.fields
1707	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	154	f	field_ir_sequence_date_range__date_to	base	ir.model.fields
1708	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	155	f	field_ir_sequence_date_range__sequence_id	base	ir.model.fields
1709	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	156	f	field_ir_sequence_date_range__number_next	base	ir.model.fields
1710	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	157	f	field_ir_sequence_date_range__number_next_actual	base	ir.model.fields
1711	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	158	f	field_ir_sequence_date_range__id	base	ir.model.fields
1712	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	159	f	field_ir_sequence_date_range____last_update	base	ir.model.fields
1713	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	160	f	field_ir_sequence_date_range__display_name	base	ir.model.fields
1714	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	161	f	field_ir_sequence_date_range__create_uid	base	ir.model.fields
1715	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	162	f	field_ir_sequence_date_range__create_date	base	ir.model.fields
1716	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	163	f	field_ir_sequence_date_range__write_uid	base	ir.model.fields
1717	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	164	f	field_ir_sequence_date_range__write_date	base	ir.model.fields
1718	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	165	f	field_ir_ui_menu__name	base	ir.model.fields
1719	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	166	f	field_ir_ui_menu__active	base	ir.model.fields
1720	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	167	f	field_ir_ui_menu__sequence	base	ir.model.fields
1721	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	168	f	field_ir_ui_menu__child_id	base	ir.model.fields
1722	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	169	f	field_ir_ui_menu__parent_id	base	ir.model.fields
1723	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	170	f	field_ir_ui_menu__parent_path	base	ir.model.fields
1724	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	171	f	field_ir_ui_menu__groups_id	base	ir.model.fields
1725	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	172	f	field_ir_ui_menu__complete_name	base	ir.model.fields
1726	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	173	f	field_ir_ui_menu__web_icon	base	ir.model.fields
1727	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	174	f	field_ir_ui_menu__action	base	ir.model.fields
1728	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	175	f	field_ir_ui_menu__web_icon_data	base	ir.model.fields
1729	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	176	f	field_ir_ui_menu__id	base	ir.model.fields
1730	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	177	f	field_ir_ui_menu____last_update	base	ir.model.fields
1731	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	178	f	field_ir_ui_menu__display_name	base	ir.model.fields
1732	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	179	f	field_ir_ui_menu__create_uid	base	ir.model.fields
1733	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	180	f	field_ir_ui_menu__create_date	base	ir.model.fields
1734	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	181	f	field_ir_ui_menu__write_uid	base	ir.model.fields
1735	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	182	f	field_ir_ui_menu__write_date	base	ir.model.fields
1736	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	183	f	field_ir_ui_view_custom__ref_id	base	ir.model.fields
1737	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	184	f	field_ir_ui_view_custom__user_id	base	ir.model.fields
1738	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	185	f	field_ir_ui_view_custom__arch	base	ir.model.fields
1739	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	186	f	field_ir_ui_view_custom__id	base	ir.model.fields
1740	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	187	f	field_ir_ui_view_custom____last_update	base	ir.model.fields
1741	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	188	f	field_ir_ui_view_custom__display_name	base	ir.model.fields
1742	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	189	f	field_ir_ui_view_custom__create_uid	base	ir.model.fields
1743	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	190	f	field_ir_ui_view_custom__create_date	base	ir.model.fields
1744	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	191	f	field_ir_ui_view_custom__write_uid	base	ir.model.fields
1745	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	192	f	field_ir_ui_view_custom__write_date	base	ir.model.fields
1746	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	193	f	field_ir_ui_view__name	base	ir.model.fields
1747	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	194	f	field_ir_ui_view__model	base	ir.model.fields
1748	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	195	f	field_ir_ui_view__key	base	ir.model.fields
1749	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	196	f	field_ir_ui_view__priority	base	ir.model.fields
1750	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	197	f	field_ir_ui_view__type	base	ir.model.fields
1751	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	198	f	field_ir_ui_view__arch	base	ir.model.fields
1752	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	199	f	field_ir_ui_view__arch_base	base	ir.model.fields
1753	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	200	f	field_ir_ui_view__arch_db	base	ir.model.fields
1754	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	201	f	field_ir_ui_view__arch_fs	base	ir.model.fields
1755	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	202	f	field_ir_ui_view__arch_updated	base	ir.model.fields
1756	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	203	f	field_ir_ui_view__arch_prev	base	ir.model.fields
1757	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	204	f	field_ir_ui_view__inherit_id	base	ir.model.fields
1758	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	205	f	field_ir_ui_view__inherit_children_ids	base	ir.model.fields
1759	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	206	f	field_ir_ui_view__field_parent	base	ir.model.fields
1760	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	207	f	field_ir_ui_view__model_data_id	base	ir.model.fields
1761	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	208	f	field_ir_ui_view__xml_id	base	ir.model.fields
1762	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	209	f	field_ir_ui_view__groups_id	base	ir.model.fields
1763	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	210	f	field_ir_ui_view__mode	base	ir.model.fields
1764	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	211	f	field_ir_ui_view__active	base	ir.model.fields
1765	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	212	f	field_ir_ui_view__id	base	ir.model.fields
1766	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	213	f	field_ir_ui_view____last_update	base	ir.model.fields
1767	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	214	f	field_ir_ui_view__display_name	base	ir.model.fields
1768	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	215	f	field_ir_ui_view__create_uid	base	ir.model.fields
1769	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	216	f	field_ir_ui_view__create_date	base	ir.model.fields
1770	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	217	f	field_ir_ui_view__write_uid	base	ir.model.fields
1771	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	218	f	field_ir_ui_view__write_date	base	ir.model.fields
1772	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	219	f	field_reset_view_arch_wizard__view_id	base	ir.model.fields
1773	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	220	f	field_reset_view_arch_wizard__view_name	base	ir.model.fields
1774	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	221	f	field_reset_view_arch_wizard__has_diff	base	ir.model.fields
1775	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	222	f	field_reset_view_arch_wizard__arch_diff	base	ir.model.fields
1776	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	223	f	field_reset_view_arch_wizard__reset_mode	base	ir.model.fields
1777	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	224	f	field_reset_view_arch_wizard__compare_view_id	base	ir.model.fields
1778	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	225	f	field_reset_view_arch_wizard__arch_to_compare	base	ir.model.fields
1779	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	226	f	field_reset_view_arch_wizard__id	base	ir.model.fields
1780	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	227	f	field_reset_view_arch_wizard____last_update	base	ir.model.fields
1781	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	228	f	field_reset_view_arch_wizard__display_name	base	ir.model.fields
1782	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	229	f	field_reset_view_arch_wizard__create_uid	base	ir.model.fields
1783	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	230	f	field_reset_view_arch_wizard__create_date	base	ir.model.fields
1784	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	231	f	field_reset_view_arch_wizard__write_uid	base	ir.model.fields
1785	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	232	f	field_reset_view_arch_wizard__write_date	base	ir.model.fields
1786	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	233	f	field_ir_asset__name	base	ir.model.fields
1787	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	234	f	field_ir_asset__bundle	base	ir.model.fields
1788	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	235	f	field_ir_asset__directive	base	ir.model.fields
1789	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	236	f	field_ir_asset__path	base	ir.model.fields
1790	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	237	f	field_ir_asset__target	base	ir.model.fields
1791	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	238	f	field_ir_asset__active	base	ir.model.fields
1792	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	239	f	field_ir_asset__sequence	base	ir.model.fields
1793	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	240	f	field_ir_asset__id	base	ir.model.fields
1794	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	241	f	field_ir_asset____last_update	base	ir.model.fields
1795	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	242	f	field_ir_asset__display_name	base	ir.model.fields
1796	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	243	f	field_ir_asset__create_uid	base	ir.model.fields
1797	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	244	f	field_ir_asset__create_date	base	ir.model.fields
1798	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	245	f	field_ir_asset__write_uid	base	ir.model.fields
1799	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	246	f	field_ir_asset__write_date	base	ir.model.fields
1800	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	247	f	field_ir_actions_actions__name	base	ir.model.fields
1801	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	248	f	field_ir_actions_actions__type	base	ir.model.fields
1802	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	249	f	field_ir_actions_actions__xml_id	base	ir.model.fields
1803	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	250	f	field_ir_actions_actions__help	base	ir.model.fields
1804	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	251	f	field_ir_actions_actions__binding_model_id	base	ir.model.fields
1805	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	252	f	field_ir_actions_actions__binding_type	base	ir.model.fields
1806	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	253	f	field_ir_actions_actions__binding_view_types	base	ir.model.fields
1807	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	254	f	field_ir_actions_actions__id	base	ir.model.fields
1808	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	255	f	field_ir_actions_actions____last_update	base	ir.model.fields
1809	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	256	f	field_ir_actions_actions__display_name	base	ir.model.fields
1810	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	257	f	field_ir_actions_actions__create_uid	base	ir.model.fields
1811	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	258	f	field_ir_actions_actions__create_date	base	ir.model.fields
1812	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	259	f	field_ir_actions_actions__write_uid	base	ir.model.fields
1813	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	260	f	field_ir_actions_actions__write_date	base	ir.model.fields
1814	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	261	f	field_ir_actions_act_window__name	base	ir.model.fields
1815	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	262	f	field_ir_actions_act_window__type	base	ir.model.fields
1816	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	263	f	field_ir_actions_act_window__xml_id	base	ir.model.fields
1817	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	264	f	field_ir_actions_act_window__help	base	ir.model.fields
1818	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	265	f	field_ir_actions_act_window__binding_model_id	base	ir.model.fields
1819	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	266	f	field_ir_actions_act_window__binding_type	base	ir.model.fields
1820	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	267	f	field_ir_actions_act_window__binding_view_types	base	ir.model.fields
1821	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	268	f	field_ir_actions_act_window__id	base	ir.model.fields
1822	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	269	f	field_ir_actions_act_window____last_update	base	ir.model.fields
1823	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	270	f	field_ir_actions_act_window__display_name	base	ir.model.fields
1824	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	271	f	field_ir_actions_act_window__create_uid	base	ir.model.fields
1825	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	272	f	field_ir_actions_act_window__create_date	base	ir.model.fields
1826	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	273	f	field_ir_actions_act_window__write_uid	base	ir.model.fields
1827	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	274	f	field_ir_actions_act_window__write_date	base	ir.model.fields
1828	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	275	f	field_ir_actions_act_window__view_id	base	ir.model.fields
1829	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	276	f	field_ir_actions_act_window__domain	base	ir.model.fields
1830	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	277	f	field_ir_actions_act_window__context	base	ir.model.fields
1831	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	278	f	field_ir_actions_act_window__res_id	base	ir.model.fields
1832	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	279	f	field_ir_actions_act_window__res_model	base	ir.model.fields
1833	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	280	f	field_ir_actions_act_window__target	base	ir.model.fields
1834	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	281	f	field_ir_actions_act_window__view_mode	base	ir.model.fields
1835	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	282	f	field_ir_actions_act_window__usage	base	ir.model.fields
1836	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	283	f	field_ir_actions_act_window__view_ids	base	ir.model.fields
1837	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	284	f	field_ir_actions_act_window__views	base	ir.model.fields
1838	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	285	f	field_ir_actions_act_window__limit	base	ir.model.fields
1839	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	286	f	field_ir_actions_act_window__groups_id	base	ir.model.fields
1840	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	287	f	field_ir_actions_act_window__search_view_id	base	ir.model.fields
1841	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	288	f	field_ir_actions_act_window__filter	base	ir.model.fields
1842	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	289	f	field_ir_actions_act_window__search_view	base	ir.model.fields
1843	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	290	f	field_ir_actions_act_window_view__sequence	base	ir.model.fields
1844	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	291	f	field_ir_actions_act_window_view__view_id	base	ir.model.fields
1845	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	292	f	field_ir_actions_act_window_view__view_mode	base	ir.model.fields
1846	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	293	f	field_ir_actions_act_window_view__act_window_id	base	ir.model.fields
1847	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	294	f	field_ir_actions_act_window_view__multi	base	ir.model.fields
1848	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	295	f	field_ir_actions_act_window_view__id	base	ir.model.fields
1849	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	296	f	field_ir_actions_act_window_view____last_update	base	ir.model.fields
1850	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	297	f	field_ir_actions_act_window_view__display_name	base	ir.model.fields
1851	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	298	f	field_ir_actions_act_window_view__create_uid	base	ir.model.fields
1852	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	299	f	field_ir_actions_act_window_view__create_date	base	ir.model.fields
1853	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	300	f	field_ir_actions_act_window_view__write_uid	base	ir.model.fields
1854	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	301	f	field_ir_actions_act_window_view__write_date	base	ir.model.fields
1855	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	302	f	field_ir_actions_act_window_close__name	base	ir.model.fields
1856	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	303	f	field_ir_actions_act_window_close__type	base	ir.model.fields
1857	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	304	f	field_ir_actions_act_window_close__xml_id	base	ir.model.fields
1858	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	305	f	field_ir_actions_act_window_close__help	base	ir.model.fields
1859	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	306	f	field_ir_actions_act_window_close__binding_model_id	base	ir.model.fields
1860	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	307	f	field_ir_actions_act_window_close__binding_type	base	ir.model.fields
1861	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	308	f	field_ir_actions_act_window_close__binding_view_types	base	ir.model.fields
1862	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	309	f	field_ir_actions_act_window_close__id	base	ir.model.fields
1863	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	310	f	field_ir_actions_act_window_close____last_update	base	ir.model.fields
1864	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	311	f	field_ir_actions_act_window_close__display_name	base	ir.model.fields
1865	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	312	f	field_ir_actions_act_window_close__create_uid	base	ir.model.fields
1866	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	313	f	field_ir_actions_act_window_close__create_date	base	ir.model.fields
1867	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	314	f	field_ir_actions_act_window_close__write_uid	base	ir.model.fields
1868	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	315	f	field_ir_actions_act_window_close__write_date	base	ir.model.fields
1869	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	316	f	field_ir_actions_act_url__name	base	ir.model.fields
1870	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	317	f	field_ir_actions_act_url__type	base	ir.model.fields
1871	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	318	f	field_ir_actions_act_url__xml_id	base	ir.model.fields
1872	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	319	f	field_ir_actions_act_url__help	base	ir.model.fields
1873	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	320	f	field_ir_actions_act_url__binding_model_id	base	ir.model.fields
1874	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	321	f	field_ir_actions_act_url__binding_type	base	ir.model.fields
1875	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	322	f	field_ir_actions_act_url__binding_view_types	base	ir.model.fields
1876	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	323	f	field_ir_actions_act_url__id	base	ir.model.fields
1877	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	324	f	field_ir_actions_act_url____last_update	base	ir.model.fields
1878	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	325	f	field_ir_actions_act_url__display_name	base	ir.model.fields
1879	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	326	f	field_ir_actions_act_url__create_uid	base	ir.model.fields
1880	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	327	f	field_ir_actions_act_url__create_date	base	ir.model.fields
1881	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	328	f	field_ir_actions_act_url__write_uid	base	ir.model.fields
1882	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	329	f	field_ir_actions_act_url__write_date	base	ir.model.fields
1883	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	330	f	field_ir_actions_act_url__url	base	ir.model.fields
1884	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	331	f	field_ir_actions_act_url__target	base	ir.model.fields
1885	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	332	f	field_ir_actions_server__name	base	ir.model.fields
1886	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	333	f	field_ir_actions_server__type	base	ir.model.fields
1887	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	334	f	field_ir_actions_server__xml_id	base	ir.model.fields
1888	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	335	f	field_ir_actions_server__help	base	ir.model.fields
1889	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	336	f	field_ir_actions_server__binding_model_id	base	ir.model.fields
1890	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	337	f	field_ir_actions_server__binding_type	base	ir.model.fields
1891	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	338	f	field_ir_actions_server__binding_view_types	base	ir.model.fields
1892	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	339	f	field_ir_actions_server__id	base	ir.model.fields
1893	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	340	f	field_ir_actions_server____last_update	base	ir.model.fields
1894	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	341	f	field_ir_actions_server__display_name	base	ir.model.fields
1895	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	342	f	field_ir_actions_server__create_uid	base	ir.model.fields
1896	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	343	f	field_ir_actions_server__create_date	base	ir.model.fields
1897	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	344	f	field_ir_actions_server__write_uid	base	ir.model.fields
1898	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	345	f	field_ir_actions_server__write_date	base	ir.model.fields
1899	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	346	f	field_ir_actions_server__usage	base	ir.model.fields
1900	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	347	f	field_ir_actions_server__state	base	ir.model.fields
1901	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	348	f	field_ir_actions_server__sequence	base	ir.model.fields
1902	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	349	f	field_ir_actions_server__model_id	base	ir.model.fields
1903	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	350	f	field_ir_actions_server__model_name	base	ir.model.fields
1904	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	351	f	field_ir_actions_server__code	base	ir.model.fields
1905	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	352	f	field_ir_actions_server__child_ids	base	ir.model.fields
1906	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	353	f	field_ir_actions_server__crud_model_id	base	ir.model.fields
1907	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	354	f	field_ir_actions_server__crud_model_name	base	ir.model.fields
1908	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	355	f	field_ir_actions_server__link_field_id	base	ir.model.fields
1909	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	356	f	field_ir_actions_server__fields_lines	base	ir.model.fields
1910	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	357	f	field_ir_actions_server__groups_id	base	ir.model.fields
1911	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	358	f	field_ir_server_object_lines__server_id	base	ir.model.fields
1912	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	359	f	field_ir_server_object_lines__col1	base	ir.model.fields
1913	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	360	f	field_ir_server_object_lines__value	base	ir.model.fields
1914	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	361	f	field_ir_server_object_lines__evaluation_type	base	ir.model.fields
1915	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	362	f	field_ir_server_object_lines__resource_ref	base	ir.model.fields
1916	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	363	f	field_ir_server_object_lines__id	base	ir.model.fields
1917	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	364	f	field_ir_server_object_lines____last_update	base	ir.model.fields
1918	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	365	f	field_ir_server_object_lines__display_name	base	ir.model.fields
1919	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	366	f	field_ir_server_object_lines__create_uid	base	ir.model.fields
1920	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	367	f	field_ir_server_object_lines__create_date	base	ir.model.fields
1921	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	368	f	field_ir_server_object_lines__write_uid	base	ir.model.fields
1922	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	369	f	field_ir_server_object_lines__write_date	base	ir.model.fields
1923	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	370	f	field_ir_actions_todo__action_id	base	ir.model.fields
1924	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	371	f	field_ir_actions_todo__sequence	base	ir.model.fields
1925	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	372	f	field_ir_actions_todo__state	base	ir.model.fields
1926	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	373	f	field_ir_actions_todo__name	base	ir.model.fields
1927	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	374	f	field_ir_actions_todo__id	base	ir.model.fields
1928	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	375	f	field_ir_actions_todo____last_update	base	ir.model.fields
1929	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	376	f	field_ir_actions_todo__display_name	base	ir.model.fields
1930	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	377	f	field_ir_actions_todo__create_uid	base	ir.model.fields
1931	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	378	f	field_ir_actions_todo__create_date	base	ir.model.fields
1932	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	379	f	field_ir_actions_todo__write_uid	base	ir.model.fields
1933	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	380	f	field_ir_actions_todo__write_date	base	ir.model.fields
1934	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	381	f	field_ir_actions_client__name	base	ir.model.fields
1935	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	382	f	field_ir_actions_client__type	base	ir.model.fields
1936	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	383	f	field_ir_actions_client__xml_id	base	ir.model.fields
1937	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	384	f	field_ir_actions_client__help	base	ir.model.fields
1938	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	385	f	field_ir_actions_client__binding_model_id	base	ir.model.fields
1939	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	386	f	field_ir_actions_client__binding_type	base	ir.model.fields
1940	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	387	f	field_ir_actions_client__binding_view_types	base	ir.model.fields
1941	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	388	f	field_ir_actions_client__id	base	ir.model.fields
1942	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	389	f	field_ir_actions_client____last_update	base	ir.model.fields
1943	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	390	f	field_ir_actions_client__display_name	base	ir.model.fields
1944	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	391	f	field_ir_actions_client__create_uid	base	ir.model.fields
1945	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	392	f	field_ir_actions_client__create_date	base	ir.model.fields
1946	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	393	f	field_ir_actions_client__write_uid	base	ir.model.fields
1947	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	394	f	field_ir_actions_client__write_date	base	ir.model.fields
1948	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	395	f	field_ir_actions_client__tag	base	ir.model.fields
1949	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	396	f	field_ir_actions_client__target	base	ir.model.fields
1950	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	397	f	field_ir_actions_client__res_model	base	ir.model.fields
1951	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	398	f	field_ir_actions_client__context	base	ir.model.fields
1952	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	399	f	field_ir_actions_client__params	base	ir.model.fields
1953	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	400	f	field_ir_actions_client__params_store	base	ir.model.fields
1954	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	401	f	field_ir_actions_report__name	base	ir.model.fields
1955	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	402	f	field_ir_actions_report__type	base	ir.model.fields
1956	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	403	f	field_ir_actions_report__xml_id	base	ir.model.fields
1957	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	404	f	field_ir_actions_report__help	base	ir.model.fields
1958	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	405	f	field_ir_actions_report__binding_model_id	base	ir.model.fields
1959	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	406	f	field_ir_actions_report__binding_type	base	ir.model.fields
1960	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	407	f	field_ir_actions_report__binding_view_types	base	ir.model.fields
1961	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	408	f	field_ir_actions_report__id	base	ir.model.fields
1962	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	409	f	field_ir_actions_report____last_update	base	ir.model.fields
1963	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	410	f	field_ir_actions_report__display_name	base	ir.model.fields
1964	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	411	f	field_ir_actions_report__create_uid	base	ir.model.fields
1965	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	412	f	field_ir_actions_report__create_date	base	ir.model.fields
1966	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	413	f	field_ir_actions_report__write_uid	base	ir.model.fields
1967	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	414	f	field_ir_actions_report__write_date	base	ir.model.fields
1968	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	415	f	field_ir_actions_report__model	base	ir.model.fields
1969	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	416	f	field_ir_actions_report__model_id	base	ir.model.fields
1970	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	417	f	field_ir_actions_report__report_type	base	ir.model.fields
1971	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	418	f	field_ir_actions_report__report_name	base	ir.model.fields
1972	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	419	f	field_ir_actions_report__report_file	base	ir.model.fields
1973	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	420	f	field_ir_actions_report__groups_id	base	ir.model.fields
1974	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	421	f	field_ir_actions_report__multi	base	ir.model.fields
1975	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	422	f	field_ir_actions_report__paperformat_id	base	ir.model.fields
1976	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	423	f	field_ir_actions_report__print_report_name	base	ir.model.fields
1977	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	424	f	field_ir_actions_report__attachment_use	base	ir.model.fields
1978	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	425	f	field_ir_actions_report__attachment	base	ir.model.fields
1979	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	426	f	field_ir_attachment__name	base	ir.model.fields
1980	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	427	f	field_ir_attachment__description	base	ir.model.fields
1981	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	428	f	field_ir_attachment__res_name	base	ir.model.fields
1982	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	429	f	field_ir_attachment__res_model	base	ir.model.fields
1983	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	430	f	field_ir_attachment__res_field	base	ir.model.fields
1984	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	431	f	field_ir_attachment__res_id	base	ir.model.fields
1985	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	432	f	field_ir_attachment__company_id	base	ir.model.fields
1986	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	433	f	field_ir_attachment__type	base	ir.model.fields
1987	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	434	f	field_ir_attachment__url	base	ir.model.fields
1988	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	435	f	field_ir_attachment__public	base	ir.model.fields
1989	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	436	f	field_ir_attachment__access_token	base	ir.model.fields
1990	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	437	f	field_ir_attachment__raw	base	ir.model.fields
1991	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	438	f	field_ir_attachment__datas	base	ir.model.fields
1992	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	439	f	field_ir_attachment__db_datas	base	ir.model.fields
1993	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	440	f	field_ir_attachment__store_fname	base	ir.model.fields
1994	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	441	f	field_ir_attachment__file_size	base	ir.model.fields
1995	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	442	f	field_ir_attachment__checksum	base	ir.model.fields
1996	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	443	f	field_ir_attachment__mimetype	base	ir.model.fields
1997	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	444	f	field_ir_attachment__index_content	base	ir.model.fields
1998	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	445	f	field_ir_attachment__id	base	ir.model.fields
1999	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	446	f	field_ir_attachment____last_update	base	ir.model.fields
2000	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	447	f	field_ir_attachment__display_name	base	ir.model.fields
2001	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	448	f	field_ir_attachment__create_uid	base	ir.model.fields
2002	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	449	f	field_ir_attachment__create_date	base	ir.model.fields
2003	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	450	f	field_ir_attachment__write_uid	base	ir.model.fields
2004	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	451	f	field_ir_attachment__write_date	base	ir.model.fields
2005	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	452	f	field_ir_cron__ir_actions_server_id	base	ir.model.fields
2006	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	453	f	field_ir_cron__cron_name	base	ir.model.fields
2007	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	454	f	field_ir_cron__user_id	base	ir.model.fields
2008	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	455	f	field_ir_cron__active	base	ir.model.fields
2009	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	456	f	field_ir_cron__interval_number	base	ir.model.fields
2010	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	457	f	field_ir_cron__interval_type	base	ir.model.fields
2011	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	458	f	field_ir_cron__numbercall	base	ir.model.fields
2012	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	459	f	field_ir_cron__doall	base	ir.model.fields
2013	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	460	f	field_ir_cron__nextcall	base	ir.model.fields
2014	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	461	f	field_ir_cron__lastcall	base	ir.model.fields
2015	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	462	f	field_ir_cron__priority	base	ir.model.fields
2016	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	463	f	field_ir_cron__id	base	ir.model.fields
2017	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	464	f	field_ir_cron____last_update	base	ir.model.fields
2018	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	465	f	field_ir_cron__display_name	base	ir.model.fields
2019	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	466	f	field_ir_cron__create_uid	base	ir.model.fields
2020	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	467	f	field_ir_cron__create_date	base	ir.model.fields
2021	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	468	f	field_ir_cron__write_uid	base	ir.model.fields
2022	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	469	f	field_ir_cron__write_date	base	ir.model.fields
2023	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	470	f	field_ir_cron__name	base	ir.model.fields
2024	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	471	f	field_ir_cron__type	base	ir.model.fields
2025	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	472	f	field_ir_cron__xml_id	base	ir.model.fields
2026	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	473	f	field_ir_cron__help	base	ir.model.fields
2027	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	474	f	field_ir_cron__binding_model_id	base	ir.model.fields
2028	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	475	f	field_ir_cron__binding_type	base	ir.model.fields
2029	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	476	f	field_ir_cron__binding_view_types	base	ir.model.fields
2030	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	477	f	field_ir_cron__usage	base	ir.model.fields
2031	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	478	f	field_ir_cron__state	base	ir.model.fields
2032	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	479	f	field_ir_cron__sequence	base	ir.model.fields
2033	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	480	f	field_ir_cron__model_id	base	ir.model.fields
2034	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	481	f	field_ir_cron__model_name	base	ir.model.fields
2035	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	482	f	field_ir_cron__code	base	ir.model.fields
2036	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	483	f	field_ir_cron__child_ids	base	ir.model.fields
2037	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	484	f	field_ir_cron__crud_model_id	base	ir.model.fields
2038	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	485	f	field_ir_cron__crud_model_name	base	ir.model.fields
2039	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	486	f	field_ir_cron__link_field_id	base	ir.model.fields
2040	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	487	f	field_ir_cron__fields_lines	base	ir.model.fields
2041	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	488	f	field_ir_cron__groups_id	base	ir.model.fields
2042	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	489	f	field_ir_cron_trigger__cron_id	base	ir.model.fields
2043	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	490	f	field_ir_cron_trigger__call_at	base	ir.model.fields
2044	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	491	f	field_ir_cron_trigger__id	base	ir.model.fields
2045	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	492	f	field_ir_cron_trigger____last_update	base	ir.model.fields
2046	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	493	f	field_ir_cron_trigger__display_name	base	ir.model.fields
2047	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	494	f	field_ir_cron_trigger__create_uid	base	ir.model.fields
2048	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	495	f	field_ir_cron_trigger__create_date	base	ir.model.fields
2049	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	496	f	field_ir_cron_trigger__write_uid	base	ir.model.fields
2050	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	497	f	field_ir_cron_trigger__write_date	base	ir.model.fields
2051	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	498	f	field_ir_filters__name	base	ir.model.fields
2052	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	499	f	field_ir_filters__user_id	base	ir.model.fields
2053	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	500	f	field_ir_filters__domain	base	ir.model.fields
2054	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	501	f	field_ir_filters__context	base	ir.model.fields
2055	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	502	f	field_ir_filters__sort	base	ir.model.fields
2056	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	503	f	field_ir_filters__model_id	base	ir.model.fields
2057	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	504	f	field_ir_filters__is_default	base	ir.model.fields
2058	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	505	f	field_ir_filters__action_id	base	ir.model.fields
2059	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	506	f	field_ir_filters__active	base	ir.model.fields
2060	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	507	f	field_ir_filters__id	base	ir.model.fields
2061	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	508	f	field_ir_filters____last_update	base	ir.model.fields
2062	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	509	f	field_ir_filters__display_name	base	ir.model.fields
2063	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	510	f	field_ir_filters__create_uid	base	ir.model.fields
2064	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	511	f	field_ir_filters__create_date	base	ir.model.fields
2065	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	512	f	field_ir_filters__write_uid	base	ir.model.fields
2066	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	513	f	field_ir_filters__write_date	base	ir.model.fields
2067	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	514	f	field_ir_default__field_id	base	ir.model.fields
2068	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	515	f	field_ir_default__user_id	base	ir.model.fields
2069	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	516	f	field_ir_default__company_id	base	ir.model.fields
2070	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	517	f	field_ir_default__condition	base	ir.model.fields
2071	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	518	f	field_ir_default__json_value	base	ir.model.fields
2072	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	519	f	field_ir_default__id	base	ir.model.fields
2073	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	520	f	field_ir_default____last_update	base	ir.model.fields
2074	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	521	f	field_ir_default__display_name	base	ir.model.fields
2075	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	522	f	field_ir_default__create_uid	base	ir.model.fields
2076	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	523	f	field_ir_default__create_date	base	ir.model.fields
2077	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	524	f	field_ir_default__write_uid	base	ir.model.fields
2078	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	525	f	field_ir_default__write_date	base	ir.model.fields
2079	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	526	f	field_ir_exports__name	base	ir.model.fields
2080	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	527	f	field_ir_exports__resource	base	ir.model.fields
2081	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	528	f	field_ir_exports__export_fields	base	ir.model.fields
2082	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	529	f	field_ir_exports__id	base	ir.model.fields
2083	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	530	f	field_ir_exports____last_update	base	ir.model.fields
2084	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	531	f	field_ir_exports__display_name	base	ir.model.fields
2085	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	532	f	field_ir_exports__create_uid	base	ir.model.fields
2086	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	533	f	field_ir_exports__create_date	base	ir.model.fields
2087	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	534	f	field_ir_exports__write_uid	base	ir.model.fields
2088	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	535	f	field_ir_exports__write_date	base	ir.model.fields
2089	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	536	f	field_ir_exports_line__name	base	ir.model.fields
2090	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	537	f	field_ir_exports_line__export_id	base	ir.model.fields
2091	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	538	f	field_ir_exports_line__id	base	ir.model.fields
2092	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	539	f	field_ir_exports_line____last_update	base	ir.model.fields
2093	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	540	f	field_ir_exports_line__display_name	base	ir.model.fields
2094	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	541	f	field_ir_exports_line__create_uid	base	ir.model.fields
2095	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	542	f	field_ir_exports_line__create_date	base	ir.model.fields
2096	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	543	f	field_ir_exports_line__write_uid	base	ir.model.fields
2097	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	544	f	field_ir_exports_line__write_date	base	ir.model.fields
2098	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	545	f	field_ir_rule__name	base	ir.model.fields
2099	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	546	f	field_ir_rule__active	base	ir.model.fields
2100	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	547	f	field_ir_rule__model_id	base	ir.model.fields
2101	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	548	f	field_ir_rule__groups	base	ir.model.fields
2102	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	549	f	field_ir_rule__domain_force	base	ir.model.fields
2103	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	550	f	field_ir_rule__perm_read	base	ir.model.fields
2104	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	551	f	field_ir_rule__perm_write	base	ir.model.fields
2105	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	552	f	field_ir_rule__perm_create	base	ir.model.fields
2106	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	553	f	field_ir_rule__perm_unlink	base	ir.model.fields
2107	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	554	f	field_ir_rule__id	base	ir.model.fields
2108	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	555	f	field_ir_rule____last_update	base	ir.model.fields
2109	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	556	f	field_ir_rule__display_name	base	ir.model.fields
2110	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	557	f	field_ir_rule__create_uid	base	ir.model.fields
2111	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	558	f	field_ir_rule__create_date	base	ir.model.fields
2112	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	559	f	field_ir_rule__write_uid	base	ir.model.fields
2113	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	560	f	field_ir_rule__write_date	base	ir.model.fields
2114	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	561	f	field_ir_rule__global	base	ir.model.fields
2115	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	562	f	field_ir_config_parameter__key	base	ir.model.fields
2116	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	563	f	field_ir_config_parameter__value	base	ir.model.fields
2117	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	564	f	field_ir_config_parameter__id	base	ir.model.fields
2118	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	565	f	field_ir_config_parameter____last_update	base	ir.model.fields
2119	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	566	f	field_ir_config_parameter__display_name	base	ir.model.fields
2120	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	567	f	field_ir_config_parameter__create_uid	base	ir.model.fields
2121	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	568	f	field_ir_config_parameter__create_date	base	ir.model.fields
2122	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	569	f	field_ir_config_parameter__write_uid	base	ir.model.fields
2123	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	570	f	field_ir_config_parameter__write_date	base	ir.model.fields
2124	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	571	f	field_ir_mail_server__name	base	ir.model.fields
2125	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	572	f	field_ir_mail_server__from_filter	base	ir.model.fields
2126	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	573	f	field_ir_mail_server__smtp_host	base	ir.model.fields
2127	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	574	f	field_ir_mail_server__smtp_port	base	ir.model.fields
2128	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	575	f	field_ir_mail_server__smtp_authentication	base	ir.model.fields
2129	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	576	f	field_ir_mail_server__smtp_authentication_info	base	ir.model.fields
2130	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	577	f	field_ir_mail_server__smtp_user	base	ir.model.fields
2131	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	578	f	field_ir_mail_server__smtp_pass	base	ir.model.fields
2132	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	579	f	field_ir_mail_server__smtp_encryption	base	ir.model.fields
2133	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	580	f	field_ir_mail_server__smtp_ssl_certificate	base	ir.model.fields
2134	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	581	f	field_ir_mail_server__smtp_ssl_private_key	base	ir.model.fields
2135	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	582	f	field_ir_mail_server__smtp_debug	base	ir.model.fields
2136	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	583	f	field_ir_mail_server__sequence	base	ir.model.fields
2137	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	584	f	field_ir_mail_server__active	base	ir.model.fields
2138	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	585	f	field_ir_mail_server__id	base	ir.model.fields
2139	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	586	f	field_ir_mail_server____last_update	base	ir.model.fields
2140	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	587	f	field_ir_mail_server__display_name	base	ir.model.fields
2141	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	588	f	field_ir_mail_server__create_uid	base	ir.model.fields
2142	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	589	f	field_ir_mail_server__create_date	base	ir.model.fields
2143	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	590	f	field_ir_mail_server__write_uid	base	ir.model.fields
2144	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	591	f	field_ir_mail_server__write_date	base	ir.model.fields
2145	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	592	f	field_ir_logging__create_uid	base	ir.model.fields
2146	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	593	f	field_ir_logging__create_date	base	ir.model.fields
2147	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	594	f	field_ir_logging__write_uid	base	ir.model.fields
2148	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	595	f	field_ir_logging__write_date	base	ir.model.fields
2149	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	596	f	field_ir_logging__name	base	ir.model.fields
2150	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	597	f	field_ir_logging__type	base	ir.model.fields
2151	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	598	f	field_ir_logging__dbname	base	ir.model.fields
2152	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	599	f	field_ir_logging__level	base	ir.model.fields
2153	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	600	f	field_ir_logging__message	base	ir.model.fields
2154	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	601	f	field_ir_logging__path	base	ir.model.fields
2155	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	602	f	field_ir_logging__func	base	ir.model.fields
2156	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	603	f	field_ir_logging__line	base	ir.model.fields
2157	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	604	f	field_ir_logging__id	base	ir.model.fields
2158	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	605	f	field_ir_logging____last_update	base	ir.model.fields
2159	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	606	f	field_ir_logging__display_name	base	ir.model.fields
2160	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	607	f	field_ir_property__name	base	ir.model.fields
2161	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	608	f	field_ir_property__res_id	base	ir.model.fields
2162	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	609	f	field_ir_property__company_id	base	ir.model.fields
2163	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	610	f	field_ir_property__fields_id	base	ir.model.fields
2164	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	611	f	field_ir_property__value_float	base	ir.model.fields
2165	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	612	f	field_ir_property__value_integer	base	ir.model.fields
2166	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	613	f	field_ir_property__value_text	base	ir.model.fields
2167	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	614	f	field_ir_property__value_binary	base	ir.model.fields
3258	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	59	f	lang_pt	base	res.lang
2168	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	615	f	field_ir_property__value_reference	base	ir.model.fields
2169	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	616	f	field_ir_property__value_datetime	base	ir.model.fields
2170	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	617	f	field_ir_property__type	base	ir.model.fields
2171	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	618	f	field_ir_property__id	base	ir.model.fields
2172	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	619	f	field_ir_property____last_update	base	ir.model.fields
2173	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	620	f	field_ir_property__display_name	base	ir.model.fields
2174	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	621	f	field_ir_property__create_uid	base	ir.model.fields
2175	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	622	f	field_ir_property__create_date	base	ir.model.fields
2176	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	623	f	field_ir_property__write_uid	base	ir.model.fields
2177	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	624	f	field_ir_property__write_date	base	ir.model.fields
2178	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	625	f	field_ir_module_category__name	base	ir.model.fields
2179	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	626	f	field_ir_module_category__parent_id	base	ir.model.fields
2180	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	627	f	field_ir_module_category__child_ids	base	ir.model.fields
2181	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	628	f	field_ir_module_category__module_nr	base	ir.model.fields
2182	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	629	f	field_ir_module_category__module_ids	base	ir.model.fields
2183	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	630	f	field_ir_module_category__description	base	ir.model.fields
2184	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	631	f	field_ir_module_category__sequence	base	ir.model.fields
2185	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	632	f	field_ir_module_category__visible	base	ir.model.fields
2186	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	633	f	field_ir_module_category__exclusive	base	ir.model.fields
2187	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	634	f	field_ir_module_category__xml_id	base	ir.model.fields
2188	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	635	f	field_ir_module_category__id	base	ir.model.fields
2189	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	636	f	field_ir_module_category____last_update	base	ir.model.fields
2190	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	637	f	field_ir_module_category__display_name	base	ir.model.fields
2191	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	638	f	field_ir_module_category__create_uid	base	ir.model.fields
2192	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	639	f	field_ir_module_category__create_date	base	ir.model.fields
2193	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	640	f	field_ir_module_category__write_uid	base	ir.model.fields
2194	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	641	f	field_ir_module_category__write_date	base	ir.model.fields
2195	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	642	f	field_ir_module_module__name	base	ir.model.fields
2196	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	643	f	field_ir_module_module__category_id	base	ir.model.fields
2197	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	644	f	field_ir_module_module__shortdesc	base	ir.model.fields
2198	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	645	f	field_ir_module_module__summary	base	ir.model.fields
2199	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	646	f	field_ir_module_module__description	base	ir.model.fields
2200	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	647	f	field_ir_module_module__description_html	base	ir.model.fields
2201	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	648	f	field_ir_module_module__author	base	ir.model.fields
2202	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	649	f	field_ir_module_module__maintainer	base	ir.model.fields
2203	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	650	f	field_ir_module_module__contributors	base	ir.model.fields
2204	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	651	f	field_ir_module_module__website	base	ir.model.fields
2205	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	652	f	field_ir_module_module__installed_version	base	ir.model.fields
2206	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	653	f	field_ir_module_module__latest_version	base	ir.model.fields
2207	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	654	f	field_ir_module_module__published_version	base	ir.model.fields
2208	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	655	f	field_ir_module_module__url	base	ir.model.fields
2209	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	656	f	field_ir_module_module__sequence	base	ir.model.fields
2210	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	657	f	field_ir_module_module__dependencies_id	base	ir.model.fields
2211	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	658	f	field_ir_module_module__exclusion_ids	base	ir.model.fields
2212	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	659	f	field_ir_module_module__auto_install	base	ir.model.fields
2213	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	660	f	field_ir_module_module__state	base	ir.model.fields
2214	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	661	f	field_ir_module_module__demo	base	ir.model.fields
2215	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	662	f	field_ir_module_module__license	base	ir.model.fields
2216	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	663	f	field_ir_module_module__menus_by_module	base	ir.model.fields
2217	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	664	f	field_ir_module_module__reports_by_module	base	ir.model.fields
2218	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	665	f	field_ir_module_module__views_by_module	base	ir.model.fields
2219	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	666	f	field_ir_module_module__application	base	ir.model.fields
2220	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	667	f	field_ir_module_module__icon	base	ir.model.fields
2221	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	668	f	field_ir_module_module__icon_image	base	ir.model.fields
2222	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	669	f	field_ir_module_module__to_buy	base	ir.model.fields
2223	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	670	f	field_ir_module_module__has_iap	base	ir.model.fields
2224	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	671	f	field_ir_module_module__id	base	ir.model.fields
2225	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	672	f	field_ir_module_module____last_update	base	ir.model.fields
2226	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	673	f	field_ir_module_module__display_name	base	ir.model.fields
2227	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	674	f	field_ir_module_module__create_uid	base	ir.model.fields
2228	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	675	f	field_ir_module_module__create_date	base	ir.model.fields
2229	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	676	f	field_ir_module_module__write_uid	base	ir.model.fields
2230	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	677	f	field_ir_module_module__write_date	base	ir.model.fields
2231	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	678	f	field_ir_module_module_dependency__name	base	ir.model.fields
2232	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	679	f	field_ir_module_module_dependency__module_id	base	ir.model.fields
3259	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	60	f	lang_ro	base	res.lang
2233	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	680	f	field_ir_module_module_dependency__depend_id	base	ir.model.fields
2234	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	681	f	field_ir_module_module_dependency__state	base	ir.model.fields
2235	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	682	f	field_ir_module_module_dependency__auto_install_required	base	ir.model.fields
2236	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	683	f	field_ir_module_module_dependency__id	base	ir.model.fields
2237	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	684	f	field_ir_module_module_dependency____last_update	base	ir.model.fields
2238	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	685	f	field_ir_module_module_dependency__display_name	base	ir.model.fields
2239	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	686	f	field_ir_module_module_exclusion__name	base	ir.model.fields
2240	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	687	f	field_ir_module_module_exclusion__module_id	base	ir.model.fields
2241	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	688	f	field_ir_module_module_exclusion__exclusion_id	base	ir.model.fields
2242	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	689	f	field_ir_module_module_exclusion__state	base	ir.model.fields
2243	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	690	f	field_ir_module_module_exclusion__id	base	ir.model.fields
2244	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	691	f	field_ir_module_module_exclusion____last_update	base	ir.model.fields
2245	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	692	f	field_ir_module_module_exclusion__display_name	base	ir.model.fields
2246	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	693	f	field_ir_module_module_exclusion__create_uid	base	ir.model.fields
2247	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	694	f	field_ir_module_module_exclusion__create_date	base	ir.model.fields
2248	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	695	f	field_ir_module_module_exclusion__write_uid	base	ir.model.fields
2249	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	696	f	field_ir_module_module_exclusion__write_date	base	ir.model.fields
2250	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	697	f	field_ir_demo__id	base	ir.model.fields
2251	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	698	f	field_ir_demo____last_update	base	ir.model.fields
2252	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	699	f	field_ir_demo__display_name	base	ir.model.fields
2253	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	700	f	field_ir_demo__create_uid	base	ir.model.fields
2254	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	701	f	field_ir_demo__create_date	base	ir.model.fields
2255	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	702	f	field_ir_demo__write_uid	base	ir.model.fields
2256	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	703	f	field_ir_demo__write_date	base	ir.model.fields
2257	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	704	f	field_ir_demo_failure__module_id	base	ir.model.fields
2258	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	705	f	field_ir_demo_failure__error	base	ir.model.fields
2259	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	706	f	field_ir_demo_failure__wizard_id	base	ir.model.fields
2260	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	707	f	field_ir_demo_failure__id	base	ir.model.fields
2261	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	708	f	field_ir_demo_failure____last_update	base	ir.model.fields
2262	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	709	f	field_ir_demo_failure__display_name	base	ir.model.fields
2263	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	710	f	field_ir_demo_failure__create_uid	base	ir.model.fields
2264	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	711	f	field_ir_demo_failure__create_date	base	ir.model.fields
2265	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	712	f	field_ir_demo_failure__write_uid	base	ir.model.fields
2266	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	713	f	field_ir_demo_failure__write_date	base	ir.model.fields
2267	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	714	f	field_ir_demo_failure_wizard__failure_ids	base	ir.model.fields
2268	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	715	f	field_ir_demo_failure_wizard__failures_count	base	ir.model.fields
2269	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	716	f	field_ir_demo_failure_wizard__id	base	ir.model.fields
2270	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	717	f	field_ir_demo_failure_wizard____last_update	base	ir.model.fields
2271	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	718	f	field_ir_demo_failure_wizard__display_name	base	ir.model.fields
2272	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	719	f	field_ir_demo_failure_wizard__create_uid	base	ir.model.fields
2273	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	720	f	field_ir_demo_failure_wizard__create_date	base	ir.model.fields
2274	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	721	f	field_ir_demo_failure_wizard__write_uid	base	ir.model.fields
2275	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	722	f	field_ir_demo_failure_wizard__write_date	base	ir.model.fields
2276	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	723	f	field_report_layout__view_id	base	ir.model.fields
2277	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	724	f	field_report_layout__image	base	ir.model.fields
2278	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	725	f	field_report_layout__pdf	base	ir.model.fields
2279	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	726	f	field_report_layout__sequence	base	ir.model.fields
2280	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	727	f	field_report_layout__name	base	ir.model.fields
2281	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	728	f	field_report_layout__id	base	ir.model.fields
2282	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	729	f	field_report_layout____last_update	base	ir.model.fields
2283	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	730	f	field_report_layout__display_name	base	ir.model.fields
2284	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	731	f	field_report_layout__create_uid	base	ir.model.fields
2285	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	732	f	field_report_layout__create_date	base	ir.model.fields
2286	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	733	f	field_report_layout__write_uid	base	ir.model.fields
2287	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	734	f	field_report_layout__write_date	base	ir.model.fields
2288	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	735	f	field_report_paperformat__name	base	ir.model.fields
2289	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	736	f	field_report_paperformat__default	base	ir.model.fields
2290	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	737	f	field_report_paperformat__format	base	ir.model.fields
2291	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	738	f	field_report_paperformat__margin_top	base	ir.model.fields
2292	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	739	f	field_report_paperformat__margin_bottom	base	ir.model.fields
2293	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	740	f	field_report_paperformat__margin_left	base	ir.model.fields
2294	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	741	f	field_report_paperformat__margin_right	base	ir.model.fields
2295	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	742	f	field_report_paperformat__page_height	base	ir.model.fields
2296	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	743	f	field_report_paperformat__page_width	base	ir.model.fields
3260	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	61	f	lang_ru	base	res.lang
2297	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	744	f	field_report_paperformat__orientation	base	ir.model.fields
2298	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	745	f	field_report_paperformat__header_line	base	ir.model.fields
2299	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	746	f	field_report_paperformat__header_spacing	base	ir.model.fields
2300	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	747	f	field_report_paperformat__disable_shrinking	base	ir.model.fields
2301	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	748	f	field_report_paperformat__dpi	base	ir.model.fields
2302	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	749	f	field_report_paperformat__report_ids	base	ir.model.fields
2303	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	750	f	field_report_paperformat__print_page_width	base	ir.model.fields
2304	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	751	f	field_report_paperformat__print_page_height	base	ir.model.fields
2305	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	752	f	field_report_paperformat__id	base	ir.model.fields
2306	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	753	f	field_report_paperformat____last_update	base	ir.model.fields
2307	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	754	f	field_report_paperformat__display_name	base	ir.model.fields
2308	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	755	f	field_report_paperformat__create_uid	base	ir.model.fields
2309	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	756	f	field_report_paperformat__create_date	base	ir.model.fields
2310	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	757	f	field_report_paperformat__write_uid	base	ir.model.fields
2311	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	758	f	field_report_paperformat__write_date	base	ir.model.fields
2312	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	759	f	field_ir_profile__create_date	base	ir.model.fields
2313	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	760	f	field_ir_profile__session	base	ir.model.fields
2314	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	761	f	field_ir_profile__name	base	ir.model.fields
2315	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	762	f	field_ir_profile__duration	base	ir.model.fields
2316	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	763	f	field_ir_profile__init_stack_trace	base	ir.model.fields
2317	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	764	f	field_ir_profile__sql	base	ir.model.fields
2318	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	765	f	field_ir_profile__sql_count	base	ir.model.fields
2319	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	766	f	field_ir_profile__traces_async	base	ir.model.fields
2320	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	767	f	field_ir_profile__traces_sync	base	ir.model.fields
2321	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	768	f	field_ir_profile__qweb	base	ir.model.fields
2322	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	769	f	field_ir_profile__entry_count	base	ir.model.fields
2323	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	770	f	field_ir_profile__speedscope	base	ir.model.fields
2324	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	771	f	field_ir_profile__speedscope_url	base	ir.model.fields
2325	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	772	f	field_ir_profile__id	base	ir.model.fields
2326	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	773	f	field_ir_profile____last_update	base	ir.model.fields
2327	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	774	f	field_ir_profile__display_name	base	ir.model.fields
2328	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	775	f	field_base_enable_profiling_wizard__duration	base	ir.model.fields
2329	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	776	f	field_base_enable_profiling_wizard__expiration	base	ir.model.fields
2330	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	777	f	field_base_enable_profiling_wizard__id	base	ir.model.fields
2331	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	778	f	field_base_enable_profiling_wizard____last_update	base	ir.model.fields
2332	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	779	f	field_base_enable_profiling_wizard__display_name	base	ir.model.fields
2333	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	780	f	field_base_enable_profiling_wizard__create_uid	base	ir.model.fields
2334	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	781	f	field_base_enable_profiling_wizard__create_date	base	ir.model.fields
2335	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	782	f	field_base_enable_profiling_wizard__write_uid	base	ir.model.fields
2336	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	783	f	field_base_enable_profiling_wizard__write_date	base	ir.model.fields
2337	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	784	f	field_image_mixin__image_1920	base	ir.model.fields
2338	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	785	f	field_image_mixin__image_1024	base	ir.model.fields
2339	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	786	f	field_image_mixin__image_512	base	ir.model.fields
2340	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	787	f	field_image_mixin__image_256	base	ir.model.fields
2341	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	788	f	field_image_mixin__image_128	base	ir.model.fields
2342	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	789	f	field_avatar_mixin__image_1920	base	ir.model.fields
2343	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	790	f	field_avatar_mixin__image_1024	base	ir.model.fields
2344	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	791	f	field_avatar_mixin__image_512	base	ir.model.fields
2345	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	792	f	field_avatar_mixin__image_256	base	ir.model.fields
2346	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	793	f	field_avatar_mixin__image_128	base	ir.model.fields
2347	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	794	f	field_avatar_mixin__avatar_1920	base	ir.model.fields
2348	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	795	f	field_avatar_mixin__avatar_1024	base	ir.model.fields
2349	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	796	f	field_avatar_mixin__avatar_512	base	ir.model.fields
2350	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	797	f	field_avatar_mixin__avatar_256	base	ir.model.fields
2351	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	798	f	field_avatar_mixin__avatar_128	base	ir.model.fields
2352	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	799	f	field_res_country__name	base	ir.model.fields
2353	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	800	f	field_res_country__code	base	ir.model.fields
2354	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	801	f	field_res_country__address_format	base	ir.model.fields
2355	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	802	f	field_res_country__address_view_id	base	ir.model.fields
2356	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	803	f	field_res_country__currency_id	base	ir.model.fields
2357	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	804	f	field_res_country__image_url	base	ir.model.fields
2358	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	805	f	field_res_country__phone_code	base	ir.model.fields
2359	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	806	f	field_res_country__country_group_ids	base	ir.model.fields
2360	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	807	f	field_res_country__state_ids	base	ir.model.fields
2361	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	808	f	field_res_country__name_position	base	ir.model.fields
2362	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	809	f	field_res_country__vat_label	base	ir.model.fields
2363	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	810	f	field_res_country__state_required	base	ir.model.fields
2364	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	811	f	field_res_country__zip_required	base	ir.model.fields
2365	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	812	f	field_res_country__id	base	ir.model.fields
2366	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	813	f	field_res_country____last_update	base	ir.model.fields
2367	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	814	f	field_res_country__display_name	base	ir.model.fields
2368	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	815	f	field_res_country__create_uid	base	ir.model.fields
2369	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	816	f	field_res_country__create_date	base	ir.model.fields
2370	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	817	f	field_res_country__write_uid	base	ir.model.fields
2371	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	818	f	field_res_country__write_date	base	ir.model.fields
2372	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	819	f	field_res_country_group__name	base	ir.model.fields
2373	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	820	f	field_res_country_group__country_ids	base	ir.model.fields
2374	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	821	f	field_res_country_group__id	base	ir.model.fields
2375	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	822	f	field_res_country_group____last_update	base	ir.model.fields
2376	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	823	f	field_res_country_group__display_name	base	ir.model.fields
2377	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	824	f	field_res_country_group__create_uid	base	ir.model.fields
2378	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	825	f	field_res_country_group__create_date	base	ir.model.fields
2379	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	826	f	field_res_country_group__write_uid	base	ir.model.fields
2380	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	827	f	field_res_country_group__write_date	base	ir.model.fields
2381	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	828	f	field_res_country_state__country_id	base	ir.model.fields
2382	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	829	f	field_res_country_state__name	base	ir.model.fields
2383	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	830	f	field_res_country_state__code	base	ir.model.fields
2384	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	831	f	field_res_country_state__id	base	ir.model.fields
2385	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	832	f	field_res_country_state____last_update	base	ir.model.fields
2386	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	833	f	field_res_country_state__display_name	base	ir.model.fields
2387	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	834	f	field_res_country_state__create_uid	base	ir.model.fields
2388	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	835	f	field_res_country_state__create_date	base	ir.model.fields
2389	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	836	f	field_res_country_state__write_uid	base	ir.model.fields
2390	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	837	f	field_res_country_state__write_date	base	ir.model.fields
2391	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	838	f	field_res_lang__name	base	ir.model.fields
2392	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	839	f	field_res_lang__code	base	ir.model.fields
2393	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	840	f	field_res_lang__iso_code	base	ir.model.fields
2394	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	841	f	field_res_lang__url_code	base	ir.model.fields
2395	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	842	f	field_res_lang__active	base	ir.model.fields
2396	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	843	f	field_res_lang__direction	base	ir.model.fields
2397	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	844	f	field_res_lang__date_format	base	ir.model.fields
2398	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	845	f	field_res_lang__time_format	base	ir.model.fields
2399	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	846	f	field_res_lang__week_start	base	ir.model.fields
2400	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	847	f	field_res_lang__grouping	base	ir.model.fields
2401	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	848	f	field_res_lang__decimal_point	base	ir.model.fields
2402	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	849	f	field_res_lang__thousands_sep	base	ir.model.fields
2403	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	850	f	field_res_lang__flag_image	base	ir.model.fields
2404	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	851	f	field_res_lang__flag_image_url	base	ir.model.fields
2405	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	852	f	field_res_lang__id	base	ir.model.fields
2406	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	853	f	field_res_lang____last_update	base	ir.model.fields
2407	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	854	f	field_res_lang__display_name	base	ir.model.fields
2408	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	855	f	field_res_lang__create_uid	base	ir.model.fields
2409	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	856	f	field_res_lang__create_date	base	ir.model.fields
2410	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	857	f	field_res_lang__write_uid	base	ir.model.fields
2411	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	858	f	field_res_lang__write_date	base	ir.model.fields
2412	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	859	f	field_res_partner_category__name	base	ir.model.fields
2413	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	860	f	field_res_partner_category__color	base	ir.model.fields
2414	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	861	f	field_res_partner_category__parent_id	base	ir.model.fields
2415	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	862	f	field_res_partner_category__child_ids	base	ir.model.fields
2416	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	863	f	field_res_partner_category__active	base	ir.model.fields
2417	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	864	f	field_res_partner_category__parent_path	base	ir.model.fields
2418	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	865	f	field_res_partner_category__partner_ids	base	ir.model.fields
2419	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	866	f	field_res_partner_category__id	base	ir.model.fields
2420	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	867	f	field_res_partner_category____last_update	base	ir.model.fields
2421	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	868	f	field_res_partner_category__display_name	base	ir.model.fields
2422	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	869	f	field_res_partner_category__create_uid	base	ir.model.fields
2423	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	870	f	field_res_partner_category__create_date	base	ir.model.fields
2424	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	871	f	field_res_partner_category__write_uid	base	ir.model.fields
2425	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	872	f	field_res_partner_category__write_date	base	ir.model.fields
2426	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	873	f	field_res_partner_title__name	base	ir.model.fields
2427	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	874	f	field_res_partner_title__shortcut	base	ir.model.fields
2428	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	875	f	field_res_partner_title__id	base	ir.model.fields
2429	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	876	f	field_res_partner_title____last_update	base	ir.model.fields
2430	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	877	f	field_res_partner_title__display_name	base	ir.model.fields
2431	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	878	f	field_res_partner_title__create_uid	base	ir.model.fields
2432	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	879	f	field_res_partner_title__create_date	base	ir.model.fields
2433	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	880	f	field_res_partner_title__write_uid	base	ir.model.fields
2434	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	881	f	field_res_partner_title__write_date	base	ir.model.fields
2435	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	882	f	field_res_partner__image_1920	base	ir.model.fields
2436	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	883	f	field_res_partner__image_1024	base	ir.model.fields
2437	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	884	f	field_res_partner__image_512	base	ir.model.fields
2438	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	885	f	field_res_partner__image_256	base	ir.model.fields
2439	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	886	f	field_res_partner__image_128	base	ir.model.fields
2440	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	887	f	field_res_partner__avatar_1920	base	ir.model.fields
2441	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	888	f	field_res_partner__avatar_1024	base	ir.model.fields
2442	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	889	f	field_res_partner__avatar_512	base	ir.model.fields
2443	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	890	f	field_res_partner__avatar_256	base	ir.model.fields
2444	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	891	f	field_res_partner__avatar_128	base	ir.model.fields
2445	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	892	f	field_res_partner__name	base	ir.model.fields
2446	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	893	f	field_res_partner__display_name	base	ir.model.fields
2447	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	894	f	field_res_partner__translated_display_name	base	ir.model.fields
2448	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	895	f	field_res_partner__date	base	ir.model.fields
2449	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	896	f	field_res_partner__title	base	ir.model.fields
2450	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	897	f	field_res_partner__parent_id	base	ir.model.fields
2451	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	898	f	field_res_partner__parent_name	base	ir.model.fields
2452	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	899	f	field_res_partner__child_ids	base	ir.model.fields
2453	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	900	f	field_res_partner__ref	base	ir.model.fields
2454	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	901	f	field_res_partner__lang	base	ir.model.fields
2455	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	902	f	field_res_partner__active_lang_count	base	ir.model.fields
2456	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	903	f	field_res_partner__tz	base	ir.model.fields
2457	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	904	f	field_res_partner__tz_offset	base	ir.model.fields
2458	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	905	f	field_res_partner__user_id	base	ir.model.fields
2459	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	906	f	field_res_partner__vat	base	ir.model.fields
2460	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	907	f	field_res_partner__same_vat_partner_id	base	ir.model.fields
2461	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	908	f	field_res_partner__same_company_registry_partner_id	base	ir.model.fields
2462	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	909	f	field_res_partner__company_registry	base	ir.model.fields
2463	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	910	f	field_res_partner__bank_ids	base	ir.model.fields
2464	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	911	f	field_res_partner__website	base	ir.model.fields
2465	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	912	f	field_res_partner__comment	base	ir.model.fields
2466	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	913	f	field_res_partner__category_id	base	ir.model.fields
2467	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	914	f	field_res_partner__active	base	ir.model.fields
2468	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	915	f	field_res_partner__employee	base	ir.model.fields
2469	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	916	f	field_res_partner__function	base	ir.model.fields
2470	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	917	f	field_res_partner__type	base	ir.model.fields
2471	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	918	f	field_res_partner__street	base	ir.model.fields
2472	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	919	f	field_res_partner__street2	base	ir.model.fields
2473	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	920	f	field_res_partner__zip	base	ir.model.fields
2474	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	921	f	field_res_partner__city	base	ir.model.fields
2475	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	922	f	field_res_partner__state_id	base	ir.model.fields
2476	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	923	f	field_res_partner__country_id	base	ir.model.fields
2477	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	924	f	field_res_partner__country_code	base	ir.model.fields
2478	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	925	f	field_res_partner__partner_latitude	base	ir.model.fields
2479	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	926	f	field_res_partner__partner_longitude	base	ir.model.fields
2480	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	927	f	field_res_partner__email	base	ir.model.fields
2481	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	928	f	field_res_partner__email_formatted	base	ir.model.fields
2482	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	929	f	field_res_partner__phone	base	ir.model.fields
2483	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	930	f	field_res_partner__mobile	base	ir.model.fields
2484	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	931	f	field_res_partner__is_company	base	ir.model.fields
2485	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	932	f	field_res_partner__is_public	base	ir.model.fields
2486	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	933	f	field_res_partner__industry_id	base	ir.model.fields
2487	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	934	f	field_res_partner__company_type	base	ir.model.fields
2488	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	935	f	field_res_partner__company_id	base	ir.model.fields
2489	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	936	f	field_res_partner__color	base	ir.model.fields
2490	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	937	f	field_res_partner__user_ids	base	ir.model.fields
2491	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	938	f	field_res_partner__partner_share	base	ir.model.fields
2492	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	939	f	field_res_partner__contact_address	base	ir.model.fields
2493	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	940	f	field_res_partner__commercial_partner_id	base	ir.model.fields
2494	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	941	f	field_res_partner__commercial_company_name	base	ir.model.fields
2495	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	942	f	field_res_partner__company_name	base	ir.model.fields
2496	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	943	f	field_res_partner__barcode	base	ir.model.fields
2497	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	944	f	field_res_partner__self	base	ir.model.fields
2498	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	945	f	field_res_partner__id	base	ir.model.fields
2499	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	946	f	field_res_partner____last_update	base	ir.model.fields
2500	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	947	f	field_res_partner__create_uid	base	ir.model.fields
2501	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	948	f	field_res_partner__create_date	base	ir.model.fields
2502	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	949	f	field_res_partner__write_uid	base	ir.model.fields
2503	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	950	f	field_res_partner__write_date	base	ir.model.fields
2504	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	951	f	field_res_partner_industry__name	base	ir.model.fields
2505	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	952	f	field_res_partner_industry__full_name	base	ir.model.fields
2506	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	953	f	field_res_partner_industry__active	base	ir.model.fields
2507	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	954	f	field_res_partner_industry__id	base	ir.model.fields
2508	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	955	f	field_res_partner_industry____last_update	base	ir.model.fields
2509	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	956	f	field_res_partner_industry__display_name	base	ir.model.fields
2510	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	957	f	field_res_partner_industry__create_uid	base	ir.model.fields
2511	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	958	f	field_res_partner_industry__create_date	base	ir.model.fields
2512	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	959	f	field_res_partner_industry__write_uid	base	ir.model.fields
2513	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	960	f	field_res_partner_industry__write_date	base	ir.model.fields
2514	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	961	f	field_res_bank__name	base	ir.model.fields
2515	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	962	f	field_res_bank__street	base	ir.model.fields
2516	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	963	f	field_res_bank__street2	base	ir.model.fields
2517	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	964	f	field_res_bank__zip	base	ir.model.fields
2518	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	965	f	field_res_bank__city	base	ir.model.fields
2519	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	966	f	field_res_bank__state	base	ir.model.fields
2520	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	967	f	field_res_bank__country	base	ir.model.fields
2521	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	968	f	field_res_bank__email	base	ir.model.fields
2522	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	969	f	field_res_bank__phone	base	ir.model.fields
2523	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	970	f	field_res_bank__active	base	ir.model.fields
2524	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	971	f	field_res_bank__bic	base	ir.model.fields
2525	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	972	f	field_res_bank__id	base	ir.model.fields
2526	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	973	f	field_res_bank____last_update	base	ir.model.fields
2527	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	974	f	field_res_bank__display_name	base	ir.model.fields
2528	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	975	f	field_res_bank__create_uid	base	ir.model.fields
2529	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	976	f	field_res_bank__create_date	base	ir.model.fields
2530	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	977	f	field_res_bank__write_uid	base	ir.model.fields
2531	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	978	f	field_res_bank__write_date	base	ir.model.fields
2532	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	979	f	field_res_partner_bank__active	base	ir.model.fields
2533	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	980	f	field_res_partner_bank__acc_type	base	ir.model.fields
2534	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	981	f	field_res_partner_bank__acc_number	base	ir.model.fields
2535	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	982	f	field_res_partner_bank__sanitized_acc_number	base	ir.model.fields
2536	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	983	f	field_res_partner_bank__acc_holder_name	base	ir.model.fields
2537	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	984	f	field_res_partner_bank__partner_id	base	ir.model.fields
2538	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	985	f	field_res_partner_bank__allow_out_payment	base	ir.model.fields
2539	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	986	f	field_res_partner_bank__bank_id	base	ir.model.fields
2540	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	987	f	field_res_partner_bank__bank_name	base	ir.model.fields
2541	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	988	f	field_res_partner_bank__bank_bic	base	ir.model.fields
2542	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	989	f	field_res_partner_bank__sequence	base	ir.model.fields
2543	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	990	f	field_res_partner_bank__currency_id	base	ir.model.fields
2544	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	991	f	field_res_partner_bank__company_id	base	ir.model.fields
2545	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	992	f	field_res_partner_bank__id	base	ir.model.fields
2546	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	993	f	field_res_partner_bank____last_update	base	ir.model.fields
2547	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	994	f	field_res_partner_bank__display_name	base	ir.model.fields
2548	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	995	f	field_res_partner_bank__create_uid	base	ir.model.fields
2549	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	996	f	field_res_partner_bank__create_date	base	ir.model.fields
2550	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	997	f	field_res_partner_bank__write_uid	base	ir.model.fields
2551	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	998	f	field_res_partner_bank__write_date	base	ir.model.fields
2552	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	999	f	field_res_config__id	base	ir.model.fields
2553	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1000	f	field_res_config____last_update	base	ir.model.fields
2554	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1001	f	field_res_config__display_name	base	ir.model.fields
2555	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1002	f	field_res_config__create_uid	base	ir.model.fields
2556	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1003	f	field_res_config__create_date	base	ir.model.fields
2557	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1004	f	field_res_config__write_uid	base	ir.model.fields
2558	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1005	f	field_res_config__write_date	base	ir.model.fields
2559	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1006	f	field_res_config_installer__id	base	ir.model.fields
2560	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1007	f	field_res_config_installer____last_update	base	ir.model.fields
2561	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1008	f	field_res_config_installer__display_name	base	ir.model.fields
2562	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1009	f	field_res_config_installer__create_uid	base	ir.model.fields
2563	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1010	f	field_res_config_installer__create_date	base	ir.model.fields
2564	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1011	f	field_res_config_installer__write_uid	base	ir.model.fields
2565	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1012	f	field_res_config_installer__write_date	base	ir.model.fields
2566	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1013	f	field_res_config_settings__id	base	ir.model.fields
2567	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1014	f	field_res_config_settings____last_update	base	ir.model.fields
2568	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1015	f	field_res_config_settings__display_name	base	ir.model.fields
2569	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1016	f	field_res_config_settings__create_uid	base	ir.model.fields
2570	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1017	f	field_res_config_settings__create_date	base	ir.model.fields
2571	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1018	f	field_res_config_settings__write_uid	base	ir.model.fields
2572	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1019	f	field_res_config_settings__write_date	base	ir.model.fields
2573	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1020	f	field_res_currency__name	base	ir.model.fields
2574	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1021	f	field_res_currency__full_name	base	ir.model.fields
2575	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1022	f	field_res_currency__symbol	base	ir.model.fields
2576	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1023	f	field_res_currency__rate	base	ir.model.fields
2577	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1024	f	field_res_currency__inverse_rate	base	ir.model.fields
2578	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1025	f	field_res_currency__rate_string	base	ir.model.fields
2579	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1026	f	field_res_currency__rate_ids	base	ir.model.fields
2580	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1027	f	field_res_currency__rounding	base	ir.model.fields
2581	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1028	f	field_res_currency__decimal_places	base	ir.model.fields
2582	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1029	f	field_res_currency__active	base	ir.model.fields
2583	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1030	f	field_res_currency__position	base	ir.model.fields
2584	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1031	f	field_res_currency__date	base	ir.model.fields
2585	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1032	f	field_res_currency__currency_unit_label	base	ir.model.fields
2586	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1033	f	field_res_currency__currency_subunit_label	base	ir.model.fields
2587	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1034	f	field_res_currency__is_current_company_currency	base	ir.model.fields
2588	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1035	f	field_res_currency__id	base	ir.model.fields
2589	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1036	f	field_res_currency____last_update	base	ir.model.fields
2590	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1037	f	field_res_currency__display_name	base	ir.model.fields
2591	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1038	f	field_res_currency__create_uid	base	ir.model.fields
2592	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1039	f	field_res_currency__create_date	base	ir.model.fields
2593	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1040	f	field_res_currency__write_uid	base	ir.model.fields
2594	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1041	f	field_res_currency__write_date	base	ir.model.fields
2595	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1042	f	field_res_currency_rate__name	base	ir.model.fields
2596	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1043	f	field_res_currency_rate__rate	base	ir.model.fields
2597	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1044	f	field_res_currency_rate__company_rate	base	ir.model.fields
2598	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1045	f	field_res_currency_rate__inverse_company_rate	base	ir.model.fields
2599	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1046	f	field_res_currency_rate__currency_id	base	ir.model.fields
2600	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1047	f	field_res_currency_rate__company_id	base	ir.model.fields
2601	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1048	f	field_res_currency_rate__id	base	ir.model.fields
2602	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1049	f	field_res_currency_rate____last_update	base	ir.model.fields
2603	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1050	f	field_res_currency_rate__display_name	base	ir.model.fields
2604	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1051	f	field_res_currency_rate__create_uid	base	ir.model.fields
2605	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1052	f	field_res_currency_rate__create_date	base	ir.model.fields
2606	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1053	f	field_res_currency_rate__write_uid	base	ir.model.fields
2607	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1054	f	field_res_currency_rate__write_date	base	ir.model.fields
2608	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1055	f	field_res_company__name	base	ir.model.fields
2609	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1056	f	field_res_company__active	base	ir.model.fields
2610	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1057	f	field_res_company__sequence	base	ir.model.fields
2611	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1058	f	field_res_company__parent_id	base	ir.model.fields
2612	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1059	f	field_res_company__child_ids	base	ir.model.fields
2613	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1060	f	field_res_company__partner_id	base	ir.model.fields
2614	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1061	f	field_res_company__report_header	base	ir.model.fields
2615	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1062	f	field_res_company__report_footer	base	ir.model.fields
2616	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1063	f	field_res_company__company_details	base	ir.model.fields
2617	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1064	f	field_res_company__is_company_details_empty	base	ir.model.fields
2618	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1065	f	field_res_company__logo	base	ir.model.fields
2619	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1066	f	field_res_company__logo_web	base	ir.model.fields
2620	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1067	f	field_res_company__currency_id	base	ir.model.fields
2621	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1068	f	field_res_company__user_ids	base	ir.model.fields
2622	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1069	f	field_res_company__street	base	ir.model.fields
2623	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1070	f	field_res_company__street2	base	ir.model.fields
2624	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1071	f	field_res_company__zip	base	ir.model.fields
2625	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1072	f	field_res_company__city	base	ir.model.fields
2626	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1073	f	field_res_company__state_id	base	ir.model.fields
2627	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1074	f	field_res_company__bank_ids	base	ir.model.fields
2628	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1075	f	field_res_company__country_id	base	ir.model.fields
2629	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1076	f	field_res_company__email	base	ir.model.fields
2630	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1077	f	field_res_company__phone	base	ir.model.fields
2631	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1078	f	field_res_company__mobile	base	ir.model.fields
2632	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1079	f	field_res_company__website	base	ir.model.fields
2633	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1080	f	field_res_company__vat	base	ir.model.fields
2634	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1081	f	field_res_company__company_registry	base	ir.model.fields
2635	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1082	f	field_res_company__paperformat_id	base	ir.model.fields
2636	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1083	f	field_res_company__external_report_layout_id	base	ir.model.fields
2637	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1084	f	field_res_company__base_onboarding_company_state	base	ir.model.fields
2638	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1085	f	field_res_company__favicon	base	ir.model.fields
2639	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1086	f	field_res_company__font	base	ir.model.fields
2640	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1087	f	field_res_company__primary_color	base	ir.model.fields
2641	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1088	f	field_res_company__secondary_color	base	ir.model.fields
2642	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1089	f	field_res_company__layout_background	base	ir.model.fields
2643	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1090	f	field_res_company__layout_background_image	base	ir.model.fields
2644	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1091	f	field_res_company__id	base	ir.model.fields
2645	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1092	f	field_res_company____last_update	base	ir.model.fields
2646	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1093	f	field_res_company__display_name	base	ir.model.fields
2647	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1094	f	field_res_company__create_uid	base	ir.model.fields
2648	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1095	f	field_res_company__create_date	base	ir.model.fields
2649	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1096	f	field_res_company__write_uid	base	ir.model.fields
2650	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1097	f	field_res_company__write_date	base	ir.model.fields
2651	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1098	f	field_res_groups__name	base	ir.model.fields
2652	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1099	f	field_res_groups__users	base	ir.model.fields
2653	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1100	f	field_res_groups__model_access	base	ir.model.fields
2654	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1101	f	field_res_groups__rule_groups	base	ir.model.fields
2655	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1102	f	field_res_groups__menu_access	base	ir.model.fields
2656	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1103	f	field_res_groups__view_access	base	ir.model.fields
2657	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1104	f	field_res_groups__comment	base	ir.model.fields
2658	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1105	f	field_res_groups__category_id	base	ir.model.fields
2659	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1106	f	field_res_groups__color	base	ir.model.fields
2660	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1107	f	field_res_groups__full_name	base	ir.model.fields
2661	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1108	f	field_res_groups__share	base	ir.model.fields
2662	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1109	f	field_res_groups__id	base	ir.model.fields
2663	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1110	f	field_res_groups____last_update	base	ir.model.fields
2664	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1111	f	field_res_groups__display_name	base	ir.model.fields
2665	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1112	f	field_res_groups__create_uid	base	ir.model.fields
2666	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1113	f	field_res_groups__create_date	base	ir.model.fields
2667	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1114	f	field_res_groups__write_uid	base	ir.model.fields
2668	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1115	f	field_res_groups__write_date	base	ir.model.fields
2669	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1116	f	field_res_groups__implied_ids	base	ir.model.fields
2670	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1117	f	field_res_groups__trans_implied_ids	base	ir.model.fields
2671	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1118	f	field_res_users_log__id	base	ir.model.fields
2672	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1119	f	field_res_users_log____last_update	base	ir.model.fields
2673	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1120	f	field_res_users_log__display_name	base	ir.model.fields
2674	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1121	f	field_res_users_log__create_uid	base	ir.model.fields
2675	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1122	f	field_res_users_log__create_date	base	ir.model.fields
2676	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1123	f	field_res_users_log__write_uid	base	ir.model.fields
2677	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1124	f	field_res_users_log__write_date	base	ir.model.fields
2678	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1125	f	field_res_users__partner_id	base	ir.model.fields
2679	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1126	f	field_res_users__login	base	ir.model.fields
2680	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1127	f	field_res_users__password	base	ir.model.fields
2681	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1128	f	field_res_users__new_password	base	ir.model.fields
2682	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1129	f	field_res_users__signature	base	ir.model.fields
2683	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1130	f	field_res_users__active	base	ir.model.fields
2684	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1131	f	field_res_users__active_partner	base	ir.model.fields
2685	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1132	f	field_res_users__action_id	base	ir.model.fields
2686	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1133	f	field_res_users__groups_id	base	ir.model.fields
2687	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1134	f	field_res_users__log_ids	base	ir.model.fields
2688	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1135	f	field_res_users__login_date	base	ir.model.fields
2689	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1136	f	field_res_users__share	base	ir.model.fields
2690	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1137	f	field_res_users__companies_count	base	ir.model.fields
2691	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1138	f	field_res_users__tz_offset	base	ir.model.fields
2692	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1139	f	field_res_users__company_id	base	ir.model.fields
2693	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1140	f	field_res_users__company_ids	base	ir.model.fields
2694	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1141	f	field_res_users__name	base	ir.model.fields
2695	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1142	f	field_res_users__email	base	ir.model.fields
2696	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1143	f	field_res_users__accesses_count	base	ir.model.fields
2697	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1144	f	field_res_users__rules_count	base	ir.model.fields
2698	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1145	f	field_res_users__groups_count	base	ir.model.fields
2699	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1146	f	field_res_users__id	base	ir.model.fields
2700	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1147	f	field_res_users____last_update	base	ir.model.fields
2701	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1148	f	field_res_users__display_name	base	ir.model.fields
2702	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1149	f	field_res_users__create_uid	base	ir.model.fields
2703	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1150	f	field_res_users__create_date	base	ir.model.fields
2704	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1151	f	field_res_users__write_uid	base	ir.model.fields
2705	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1152	f	field_res_users__write_date	base	ir.model.fields
2706	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1153	f	field_res_users__user_group_warning	base	ir.model.fields
2707	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1154	f	field_res_users__api_key_ids	base	ir.model.fields
2708	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1155	f	field_res_users__image_1920	base	ir.model.fields
2709	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1156	f	field_res_users__image_1024	base	ir.model.fields
2710	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1157	f	field_res_users__image_512	base	ir.model.fields
2711	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1158	f	field_res_users__image_256	base	ir.model.fields
2712	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1159	f	field_res_users__image_128	base	ir.model.fields
2713	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1160	f	field_res_users__avatar_1920	base	ir.model.fields
2714	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1161	f	field_res_users__avatar_1024	base	ir.model.fields
2715	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1162	f	field_res_users__avatar_512	base	ir.model.fields
2716	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1163	f	field_res_users__avatar_256	base	ir.model.fields
2717	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1164	f	field_res_users__avatar_128	base	ir.model.fields
2718	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1165	f	field_res_users__translated_display_name	base	ir.model.fields
2719	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1166	f	field_res_users__date	base	ir.model.fields
2720	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1167	f	field_res_users__title	base	ir.model.fields
2721	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1168	f	field_res_users__parent_id	base	ir.model.fields
2722	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1169	f	field_res_users__parent_name	base	ir.model.fields
2723	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1170	f	field_res_users__child_ids	base	ir.model.fields
2724	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1171	f	field_res_users__ref	base	ir.model.fields
2725	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1172	f	field_res_users__lang	base	ir.model.fields
2726	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1173	f	field_res_users__active_lang_count	base	ir.model.fields
2727	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1174	f	field_res_users__tz	base	ir.model.fields
2728	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1175	f	field_res_users__user_id	base	ir.model.fields
2729	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1176	f	field_res_users__vat	base	ir.model.fields
2730	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1177	f	field_res_users__same_vat_partner_id	base	ir.model.fields
2731	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1178	f	field_res_users__same_company_registry_partner_id	base	ir.model.fields
2732	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1179	f	field_res_users__company_registry	base	ir.model.fields
2733	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1180	f	field_res_users__bank_ids	base	ir.model.fields
2734	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1181	f	field_res_users__website	base	ir.model.fields
2735	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1182	f	field_res_users__comment	base	ir.model.fields
2736	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1183	f	field_res_users__category_id	base	ir.model.fields
2737	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1184	f	field_res_users__employee	base	ir.model.fields
2738	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1185	f	field_res_users__function	base	ir.model.fields
2739	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1186	f	field_res_users__type	base	ir.model.fields
2740	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1187	f	field_res_users__street	base	ir.model.fields
2741	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1188	f	field_res_users__street2	base	ir.model.fields
2742	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1189	f	field_res_users__zip	base	ir.model.fields
2743	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1190	f	field_res_users__city	base	ir.model.fields
2744	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1191	f	field_res_users__state_id	base	ir.model.fields
2745	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1192	f	field_res_users__country_id	base	ir.model.fields
2746	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1193	f	field_res_users__country_code	base	ir.model.fields
2747	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1194	f	field_res_users__partner_latitude	base	ir.model.fields
2748	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1195	f	field_res_users__partner_longitude	base	ir.model.fields
2749	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1196	f	field_res_users__email_formatted	base	ir.model.fields
2750	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1197	f	field_res_users__phone	base	ir.model.fields
2751	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1198	f	field_res_users__mobile	base	ir.model.fields
2752	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1199	f	field_res_users__is_company	base	ir.model.fields
2753	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1200	f	field_res_users__is_public	base	ir.model.fields
2754	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1201	f	field_res_users__industry_id	base	ir.model.fields
2755	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1202	f	field_res_users__company_type	base	ir.model.fields
2756	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1203	f	field_res_users__color	base	ir.model.fields
2757	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1204	f	field_res_users__user_ids	base	ir.model.fields
2758	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1205	f	field_res_users__partner_share	base	ir.model.fields
2759	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1206	f	field_res_users__contact_address	base	ir.model.fields
2760	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1207	f	field_res_users__commercial_partner_id	base	ir.model.fields
2761	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1208	f	field_res_users__commercial_company_name	base	ir.model.fields
2762	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1209	f	field_res_users__company_name	base	ir.model.fields
2763	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1210	f	field_res_users__barcode	base	ir.model.fields
2764	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1211	f	field_res_users__self	base	ir.model.fields
2765	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1212	f	field_res_users_identitycheck__request	base	ir.model.fields
2766	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1213	f	field_res_users_identitycheck__password	base	ir.model.fields
2767	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1214	f	field_res_users_identitycheck__id	base	ir.model.fields
2768	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1215	f	field_res_users_identitycheck____last_update	base	ir.model.fields
2769	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1216	f	field_res_users_identitycheck__display_name	base	ir.model.fields
2770	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1217	f	field_res_users_identitycheck__create_uid	base	ir.model.fields
2771	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1218	f	field_res_users_identitycheck__create_date	base	ir.model.fields
2772	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1219	f	field_res_users_identitycheck__write_uid	base	ir.model.fields
2773	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1220	f	field_res_users_identitycheck__write_date	base	ir.model.fields
2774	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1221	f	field_change_password_wizard__user_ids	base	ir.model.fields
2775	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1222	f	field_change_password_wizard__id	base	ir.model.fields
2776	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1223	f	field_change_password_wizard____last_update	base	ir.model.fields
2777	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1224	f	field_change_password_wizard__display_name	base	ir.model.fields
2778	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1225	f	field_change_password_wizard__create_uid	base	ir.model.fields
2779	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1226	f	field_change_password_wizard__create_date	base	ir.model.fields
2780	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1227	f	field_change_password_wizard__write_uid	base	ir.model.fields
2781	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1228	f	field_change_password_wizard__write_date	base	ir.model.fields
2782	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1229	f	field_change_password_user__wizard_id	base	ir.model.fields
2783	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1230	f	field_change_password_user__user_id	base	ir.model.fields
2784	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1231	f	field_change_password_user__user_login	base	ir.model.fields
2785	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1232	f	field_change_password_user__new_passwd	base	ir.model.fields
2786	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1233	f	field_change_password_user__id	base	ir.model.fields
2787	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1234	f	field_change_password_user____last_update	base	ir.model.fields
2788	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1235	f	field_change_password_user__display_name	base	ir.model.fields
2789	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1236	f	field_change_password_user__create_uid	base	ir.model.fields
2790	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1237	f	field_change_password_user__create_date	base	ir.model.fields
2791	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1238	f	field_change_password_user__write_uid	base	ir.model.fields
2792	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1239	f	field_change_password_user__write_date	base	ir.model.fields
2793	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1240	f	field_change_password_own__new_password	base	ir.model.fields
2794	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1241	f	field_change_password_own__confirm_password	base	ir.model.fields
2795	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1242	f	field_change_password_own__id	base	ir.model.fields
2796	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1243	f	field_change_password_own____last_update	base	ir.model.fields
2797	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1244	f	field_change_password_own__display_name	base	ir.model.fields
2798	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1245	f	field_change_password_own__create_uid	base	ir.model.fields
2799	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1246	f	field_change_password_own__create_date	base	ir.model.fields
2800	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1247	f	field_change_password_own__write_uid	base	ir.model.fields
2801	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1248	f	field_change_password_own__write_date	base	ir.model.fields
2802	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1249	f	field_res_users_apikeys__name	base	ir.model.fields
2803	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1250	f	field_res_users_apikeys__user_id	base	ir.model.fields
2804	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1251	f	field_res_users_apikeys__scope	base	ir.model.fields
2805	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1252	f	field_res_users_apikeys__create_date	base	ir.model.fields
2806	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1253	f	field_res_users_apikeys__id	base	ir.model.fields
2807	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1254	f	field_res_users_apikeys____last_update	base	ir.model.fields
2808	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1255	f	field_res_users_apikeys__display_name	base	ir.model.fields
2809	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1256	f	field_res_users_apikeys_description__name	base	ir.model.fields
2810	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1257	f	field_res_users_apikeys_description__id	base	ir.model.fields
2811	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1258	f	field_res_users_apikeys_description____last_update	base	ir.model.fields
2812	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1259	f	field_res_users_apikeys_description__display_name	base	ir.model.fields
2813	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1260	f	field_res_users_apikeys_description__create_uid	base	ir.model.fields
2814	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1261	f	field_res_users_apikeys_description__create_date	base	ir.model.fields
2815	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1262	f	field_res_users_apikeys_description__write_uid	base	ir.model.fields
2816	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1263	f	field_res_users_apikeys_description__write_date	base	ir.model.fields
2817	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1264	f	field_res_users_apikeys_show__id	base	ir.model.fields
2818	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1265	f	field_res_users_apikeys_show__key	base	ir.model.fields
2819	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1266	f	field_res_users_deletion__user_id	base	ir.model.fields
2820	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1267	f	field_res_users_deletion__user_id_int	base	ir.model.fields
2821	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1268	f	field_res_users_deletion__state	base	ir.model.fields
2822	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1269	f	field_res_users_deletion__id	base	ir.model.fields
2823	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1270	f	field_res_users_deletion____last_update	base	ir.model.fields
2824	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1271	f	field_res_users_deletion__display_name	base	ir.model.fields
2825	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1272	f	field_res_users_deletion__create_uid	base	ir.model.fields
2826	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1273	f	field_res_users_deletion__create_date	base	ir.model.fields
2827	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1274	f	field_res_users_deletion__write_uid	base	ir.model.fields
2828	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1275	f	field_res_users_deletion__write_date	base	ir.model.fields
2829	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1276	f	field_decimal_precision__name	base	ir.model.fields
2830	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1277	f	field_decimal_precision__digits	base	ir.model.fields
2831	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1278	f	field_decimal_precision__id	base	ir.model.fields
2832	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1279	f	field_decimal_precision____last_update	base	ir.model.fields
2833	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1280	f	field_decimal_precision__display_name	base	ir.model.fields
2834	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1281	f	field_decimal_precision__create_uid	base	ir.model.fields
2835	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1282	f	field_decimal_precision__create_date	base	ir.model.fields
2836	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1283	f	field_decimal_precision__write_uid	base	ir.model.fields
2837	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1284	f	field_decimal_precision__write_date	base	ir.model.fields
2838	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1285	f	field_base_module_update__updated	base	ir.model.fields
2839	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1286	f	field_base_module_update__added	base	ir.model.fields
2840	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1287	f	field_base_module_update__state	base	ir.model.fields
2841	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1288	f	field_base_module_update__id	base	ir.model.fields
2842	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1289	f	field_base_module_update____last_update	base	ir.model.fields
2843	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1290	f	field_base_module_update__display_name	base	ir.model.fields
2844	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1291	f	field_base_module_update__create_uid	base	ir.model.fields
2845	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1292	f	field_base_module_update__create_date	base	ir.model.fields
2846	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1293	f	field_base_module_update__write_uid	base	ir.model.fields
2847	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1294	f	field_base_module_update__write_date	base	ir.model.fields
2848	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1295	f	field_base_language_install__lang_ids	base	ir.model.fields
2849	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1296	f	field_base_language_install__overwrite	base	ir.model.fields
2850	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1297	f	field_base_language_install__first_lang_id	base	ir.model.fields
2851	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1298	f	field_base_language_install__id	base	ir.model.fields
2852	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1299	f	field_base_language_install____last_update	base	ir.model.fields
2853	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1300	f	field_base_language_install__display_name	base	ir.model.fields
2854	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1301	f	field_base_language_install__create_uid	base	ir.model.fields
2855	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1302	f	field_base_language_install__create_date	base	ir.model.fields
2856	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1303	f	field_base_language_install__write_uid	base	ir.model.fields
2857	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1304	f	field_base_language_install__write_date	base	ir.model.fields
2858	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1305	f	field_base_language_import__name	base	ir.model.fields
2859	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1306	f	field_base_language_import__code	base	ir.model.fields
2860	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1307	f	field_base_language_import__data	base	ir.model.fields
2861	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1308	f	field_base_language_import__filename	base	ir.model.fields
2862	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1309	f	field_base_language_import__overwrite	base	ir.model.fields
2863	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1310	f	field_base_language_import__id	base	ir.model.fields
2864	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1311	f	field_base_language_import____last_update	base	ir.model.fields
2865	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1312	f	field_base_language_import__display_name	base	ir.model.fields
2866	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1313	f	field_base_language_import__create_uid	base	ir.model.fields
2867	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1314	f	field_base_language_import__create_date	base	ir.model.fields
2868	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1315	f	field_base_language_import__write_uid	base	ir.model.fields
2869	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1316	f	field_base_language_import__write_date	base	ir.model.fields
2870	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1317	f	field_base_module_upgrade__module_info	base	ir.model.fields
2871	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1318	f	field_base_module_upgrade__id	base	ir.model.fields
2872	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1319	f	field_base_module_upgrade____last_update	base	ir.model.fields
2873	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1320	f	field_base_module_upgrade__display_name	base	ir.model.fields
2874	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1321	f	field_base_module_upgrade__create_uid	base	ir.model.fields
2875	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1322	f	field_base_module_upgrade__create_date	base	ir.model.fields
2876	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1323	f	field_base_module_upgrade__write_uid	base	ir.model.fields
2877	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1324	f	field_base_module_upgrade__write_date	base	ir.model.fields
2878	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1325	f	field_base_module_uninstall__show_all	base	ir.model.fields
2879	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1326	f	field_base_module_uninstall__module_id	base	ir.model.fields
2880	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1327	f	field_base_module_uninstall__module_ids	base	ir.model.fields
2881	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1328	f	field_base_module_uninstall__model_ids	base	ir.model.fields
2882	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1329	f	field_base_module_uninstall__id	base	ir.model.fields
2883	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1330	f	field_base_module_uninstall____last_update	base	ir.model.fields
2884	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1331	f	field_base_module_uninstall__display_name	base	ir.model.fields
2885	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1332	f	field_base_module_uninstall__create_uid	base	ir.model.fields
2886	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1333	f	field_base_module_uninstall__create_date	base	ir.model.fields
2887	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1334	f	field_base_module_uninstall__write_uid	base	ir.model.fields
2888	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1335	f	field_base_module_uninstall__write_date	base	ir.model.fields
2889	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1336	f	field_base_language_export__name	base	ir.model.fields
2890	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1337	f	field_base_language_export__lang	base	ir.model.fields
2891	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1338	f	field_base_language_export__format	base	ir.model.fields
2892	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1339	f	field_base_language_export__modules	base	ir.model.fields
2893	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1340	f	field_base_language_export__data	base	ir.model.fields
2894	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1341	f	field_base_language_export__state	base	ir.model.fields
2895	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1342	f	field_base_language_export__id	base	ir.model.fields
2896	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1343	f	field_base_language_export____last_update	base	ir.model.fields
2897	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1344	f	field_base_language_export__display_name	base	ir.model.fields
2898	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1345	f	field_base_language_export__create_uid	base	ir.model.fields
2899	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1346	f	field_base_language_export__create_date	base	ir.model.fields
2900	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1347	f	field_base_language_export__write_uid	base	ir.model.fields
2901	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1348	f	field_base_language_export__write_date	base	ir.model.fields
2902	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1349	f	field_base_partner_merge_line__wizard_id	base	ir.model.fields
2903	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1350	f	field_base_partner_merge_line__min_id	base	ir.model.fields
2904	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1351	f	field_base_partner_merge_line__aggr_ids	base	ir.model.fields
2905	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1352	f	field_base_partner_merge_line__id	base	ir.model.fields
2906	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1353	f	field_base_partner_merge_line____last_update	base	ir.model.fields
2907	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1354	f	field_base_partner_merge_line__display_name	base	ir.model.fields
2908	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1355	f	field_base_partner_merge_line__create_uid	base	ir.model.fields
2909	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1356	f	field_base_partner_merge_line__create_date	base	ir.model.fields
2910	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1357	f	field_base_partner_merge_line__write_uid	base	ir.model.fields
2911	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1358	f	field_base_partner_merge_line__write_date	base	ir.model.fields
2912	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1359	f	field_base_partner_merge_automatic_wizard__group_by_email	base	ir.model.fields
2913	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1360	f	field_base_partner_merge_automatic_wizard__group_by_name	base	ir.model.fields
2914	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1361	f	field_base_partner_merge_automatic_wizard__group_by_is_company	base	ir.model.fields
2915	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1362	f	field_base_partner_merge_automatic_wizard__group_by_vat	base	ir.model.fields
2916	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1363	f	field_base_partner_merge_automatic_wizard__group_by_parent_id	base	ir.model.fields
2917	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1364	f	field_base_partner_merge_automatic_wizard__state	base	ir.model.fields
2918	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1365	f	field_base_partner_merge_automatic_wizard__number_group	base	ir.model.fields
2919	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1366	f	field_base_partner_merge_automatic_wizard__current_line_id	base	ir.model.fields
2920	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1367	f	field_base_partner_merge_automatic_wizard__line_ids	base	ir.model.fields
2921	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1368	f	field_base_partner_merge_automatic_wizard__partner_ids	base	ir.model.fields
2922	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1369	f	field_base_partner_merge_automatic_wizard__dst_partner_id	base	ir.model.fields
2923	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1370	f	field_base_partner_merge_automatic_wizard__exclude_contact	base	ir.model.fields
2924	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1371	f	field_base_partner_merge_automatic_wizard__exclude_journal_item	base	ir.model.fields
2925	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1372	f	field_base_partner_merge_automatic_wizard__maximum_group	base	ir.model.fields
2926	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1373	f	field_base_partner_merge_automatic_wizard__id	base	ir.model.fields
2927	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1374	f	field_base_partner_merge_automatic_wizard____last_update	base	ir.model.fields
2928	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1375	f	field_base_partner_merge_automatic_wizard__display_name	base	ir.model.fields
2929	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1376	f	field_base_partner_merge_automatic_wizard__create_uid	base	ir.model.fields
2930	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1377	f	field_base_partner_merge_automatic_wizard__create_date	base	ir.model.fields
2931	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1378	f	field_base_partner_merge_automatic_wizard__write_uid	base	ir.model.fields
2932	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1379	f	field_base_partner_merge_automatic_wizard__write_date	base	ir.model.fields
3261	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	62	f	lang_sr_RS	base	res.lang
3199	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	res_bank_1	base	res.bank
3200	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	f	lang_en	base	res.lang
3201	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	f	lang_am_ET	base	res.lang
3203	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	f	lang_ar_SY	base	res.lang
3204	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	f	lang_az	base	res.lang
3205	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	f	lang_eu_ES	base	res.lang
3206	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	f	lang_bn_IN	base	res.lang
3207	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	f	lang_bs_BA	base	res.lang
3208	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	f	lang_bg	base	res.lang
3210	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	11	f	lang_zh_CN	base	res.lang
3211	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	f	lang_zh_HK	base	res.lang
3212	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	13	f	lang_zh_TW	base	res.lang
3213	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	14	f	lang_hr	base	res.lang
3214	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	15	f	lang_cs_CZ	base	res.lang
3215	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	16	f	lang_da_DK	base	res.lang
3216	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	17	f	lang_nl_BE	base	res.lang
3217	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	18	f	lang_nl	base	res.lang
3218	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	19	f	lang_en_AU	base	res.lang
3219	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	20	f	lang_en_CA	base	res.lang
3220	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	21	f	lang_en_GB	base	res.lang
3221	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	22	f	lang_en_IN	base	res.lang
3222	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	23	f	lang_et_EE	base	res.lang
3223	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	24	f	lang_fi	base	res.lang
3224	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	25	f	lang_fr_BE	base	res.lang
3225	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	26	f	lang_fr_CA	base	res.lang
3226	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	27	f	lang_fr_CH	base	res.lang
3227	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	28	f	lang_fr	base	res.lang
3228	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	29	f	lang_gl_ES	base	res.lang
3229	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	30	f	lang_ka_GE	base	res.lang
3230	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	31	f	lang_de	base	res.lang
3231	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	32	f	lang_de_CH	base	res.lang
3232	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	33	f	lang_el_GR	base	res.lang
3233	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	34	f	lang_gu_IN	base	res.lang
3234	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	35	f	lang_he_IL	base	res.lang
3235	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	36	f	lang_hi_IN	base	res.lang
3236	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	37	f	lang_hu	base	res.lang
3237	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	38	f	lang_id	base	res.lang
3238	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	39	f	lang_it	base	res.lang
3239	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	40	f	lang_ja_JP	base	res.lang
3240	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	41	f	lang_kab_DZ	base	res.lang
3241	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	42	f	lang_km	base	res.lang
3242	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	43	f	lang_ko_KP	base	res.lang
3243	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	44	f	lang_ko_KR	base	res.lang
3244	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	45	f	lang_lo_LA	base	res.lang
3245	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	46	f	lang_lv	base	res.lang
3246	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	47	f	lang_lt	base	res.lang
3247	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	48	f	lang_lb	base	res.lang
3248	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	49	f	lang_mk	base	res.lang
3249	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	50	f	lang_ml	base	res.lang
3250	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	51	f	lang_mn	base	res.lang
3251	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	52	f	lang_ms	base	res.lang
3253	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	54	f	lang_nb_NO	base	res.lang
3263	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	64	f	lang_sk	base	res.lang
3264	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	65	f	lang_sl_SI	base	res.lang
3265	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	66	f	lang_es_AR	base	res.lang
3266	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	67	f	lang_es_BO	base	res.lang
3267	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	68	f	lang_es_CL	base	res.lang
3268	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	69	f	lang_es_CO	base	res.lang
3269	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	70	f	lang_es_CR	base	res.lang
3270	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	71	f	lang_es_DO	base	res.lang
3271	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	72	f	lang_es_EC	base	res.lang
3272	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	73	f	lang_es_GT	base	res.lang
3273	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	74	f	lang_es_MX	base	res.lang
3274	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	75	f	lang_es_PA	base	res.lang
3275	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	76	f	lang_es_PE	base	res.lang
3276	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	77	f	lang_es_PY	base	res.lang
3277	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	78	f	lang_es_UY	base	res.lang
3278	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	79	f	lang_es_VE	base	res.lang
3279	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	80	f	lang_es	base	res.lang
3280	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	81	f	lang_sv_SE	base	res.lang
3281	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	82	f	lang_th	base	res.lang
3282	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	83	f	lang_tl	base	res.lang
3283	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	84	f	lang_tr	base	res.lang
3284	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	85	f	lang_uk_UA	base	res.lang
3285	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	86	f	lang_vi_VN	base	res.lang
3286	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	87	f	lang_sq_AL	base	res.lang
3287	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	88	f	lang_te_IN	base	res.lang
3252	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	53	f	lang_my	base	res.lang
3202	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	f	lang_ar	base	res.lang
3262	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	63	f	lang_sr@latin	base	res.lang
3209	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	f	lang_ca_ES	base	res.lang
3	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	main_partner	base	res.partner
3293	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	t	partner_root	base	res.partner
3294	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	t	partner_admin	base	res.partner
3295	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	t	public_partner	base	res.partner
3296	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	res_partner_title_madam	base	res.partner.title
3297	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	t	res_partner_title_miss	base	res.partner.title
3298	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	t	res_partner_title_mister	base	res.partner.title
3299	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	t	res_partner_title_doctor	base	res.partner.title
3300	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	t	res_partner_title_prof	base	res.partner.title
3301	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	res_partner_industry_A	base	res.partner.industry
3302	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	t	res_partner_industry_B	base	res.partner.industry
3303	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	t	res_partner_industry_C	base	res.partner.industry
3304	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	t	res_partner_industry_D	base	res.partner.industry
3305	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	t	res_partner_industry_E	base	res.partner.industry
3306	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	t	res_partner_industry_F	base	res.partner.industry
3307	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	t	res_partner_industry_G	base	res.partner.industry
3308	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	t	res_partner_industry_H	base	res.partner.industry
3309	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	t	res_partner_industry_I	base	res.partner.industry
3310	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	t	res_partner_industry_J	base	res.partner.industry
3311	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	11	t	res_partner_industry_K	base	res.partner.industry
3312	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	t	res_partner_industry_L	base	res.partner.industry
3313	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	13	t	res_partner_industry_M	base	res.partner.industry
3314	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	14	t	res_partner_industry_N	base	res.partner.industry
3315	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	15	t	res_partner_industry_O	base	res.partner.industry
3316	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	16	t	res_partner_industry_P	base	res.partner.industry
3317	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	17	t	res_partner_industry_Q	base	res.partner.industry
3318	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	18	t	res_partner_industry_R	base	res.partner.industry
3319	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	19	t	res_partner_industry_S	base	res.partner.industry
3320	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	20	t	res_partner_industry_T	base	res.partner.industry
3321	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	21	t	res_partner_industry_U	base	res.partner.industry
3322	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	t	USD	base	res.currency
3323	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	t	VEF	base	res.currency
3324	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	t	CAD	base	res.currency
3325	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	t	CHF	base	res.currency
3326	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	t	BRL	base	res.currency
3327	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	t	CNY	base	res.currency
3328	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	t	CNH	base	res.currency
3329	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	t	COP	base	res.currency
3330	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	t	CZK	base	res.currency
3331	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	11	t	DKK	base	res.currency
3332	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	t	HUF	base	res.currency
3333	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	13	t	IDR	base	res.currency
3334	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	14	t	LVL	base	res.currency
3335	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	15	t	NOK	base	res.currency
3336	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	16	t	XPF	base	res.currency
3337	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	17	t	PAB	base	res.currency
3338	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	18	t	PLN	base	res.currency
3339	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	19	t	SEK	base	res.currency
3340	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	20	t	ARS	base	res.currency
3341	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	21	t	INR	base	res.currency
3342	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	22	t	AUD	base	res.currency
3343	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	23	t	UAH	base	res.currency
3344	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	24	t	VND	base	res.currency
3345	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	25	t	HKD	base	res.currency
3346	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	26	t	JPY	base	res.currency
3347	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	27	t	BGN	base	res.currency
3348	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	28	t	LTL	base	res.currency
3349	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	29	t	RON	base	res.currency
3350	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	30	t	HRK	base	res.currency
3351	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	31	t	RUB	base	res.currency
3352	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	32	t	TRY	base	res.currency
3353	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	33	t	KRW	base	res.currency
3354	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	34	t	MXN	base	res.currency
3355	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	35	t	MYR	base	res.currency
3356	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	36	t	NZD	base	res.currency
3357	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	37	t	PHP	base	res.currency
3358	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	38	t	SGD	base	res.currency
3359	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	39	t	ZAR	base	res.currency
3360	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	40	t	CRC	base	res.currency
3361	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	41	t	MUR	base	res.currency
3362	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	42	t	XOF	base	res.currency
3363	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	43	t	XAF	base	res.currency
3364	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	44	t	UGX	base	res.currency
3365	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	45	t	HNL	base	res.currency
3366	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	46	t	CLP	base	res.currency
3367	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	47	t	UYU	base	res.currency
3368	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	48	t	AFN	base	res.currency
3369	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	49	t	AOA	base	res.currency
3370	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	50	t	XCD	base	res.currency
3371	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	51	t	AMD	base	res.currency
3372	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	52	t	AWG	base	res.currency
3373	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	53	t	AZN	base	res.currency
3374	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	54	t	BSD	base	res.currency
3375	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	55	t	BHD	base	res.currency
3376	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	56	t	BDT	base	res.currency
3377	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	57	t	BBD	base	res.currency
3378	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	58	t	BYR	base	res.currency
3379	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	59	t	BYN	base	res.currency
3380	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	60	t	BZD	base	res.currency
3381	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	61	t	BMD	base	res.currency
3382	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	62	t	BTN	base	res.currency
3383	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	63	t	BOB	base	res.currency
3384	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	64	t	BAM	base	res.currency
3385	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	65	t	BWP	base	res.currency
3386	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	66	t	BIF	base	res.currency
3387	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	67	t	KHR	base	res.currency
3388	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	68	t	KYD	base	res.currency
3389	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	69	t	KMF	base	res.currency
3390	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	70	t	CDF	base	res.currency
3391	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	71	t	CUP	base	res.currency
3392	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	72	t	ANG	base	res.currency
3393	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	73	t	DJF	base	res.currency
3394	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	74	t	DOP	base	res.currency
3395	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	75	t	EGP	base	res.currency
3396	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	76	t	SVC	base	res.currency
3397	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	77	t	ERN	base	res.currency
3398	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	78	t	ETB	base	res.currency
3399	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	79	t	FKP	base	res.currency
3400	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	80	t	FJD	base	res.currency
3401	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	81	t	GEL	base	res.currency
3402	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	82	t	GIP	base	res.currency
3403	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	83	t	GNF	base	res.currency
3404	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	84	t	GYD	base	res.currency
3405	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	85	t	HTG	base	res.currency
3406	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	86	t	ISK	base	res.currency
3407	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	87	t	IRR	base	res.currency
3408	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	88	t	IQD	base	res.currency
3409	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	89	t	ILS	base	res.currency
3410	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	90	t	JMD	base	res.currency
3411	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	91	t	JOD	base	res.currency
3412	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	92	t	KZT	base	res.currency
3413	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	93	t	KES	base	res.currency
3414	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	94	t	KWD	base	res.currency
3415	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	95	t	KGS	base	res.currency
3416	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	96	t	LAK	base	res.currency
3417	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	97	t	LBP	base	res.currency
3418	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	98	t	LSL	base	res.currency
3419	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	99	t	LRD	base	res.currency
3420	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	100	t	LYD	base	res.currency
3421	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	101	t	MOP	base	res.currency
3422	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	102	t	MKD	base	res.currency
3423	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	103	t	MGA	base	res.currency
3424	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	104	t	MWK	base	res.currency
3425	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	105	t	MVR	base	res.currency
3426	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	106	t	MRO	base	res.currency
3427	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	107	t	MRU	base	res.currency
3428	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	108	t	MDL	base	res.currency
3429	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	109	t	MNT	base	res.currency
3430	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	110	t	MAD	base	res.currency
3431	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	111	t	BND	base	res.currency
3432	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	112	t	DZD	base	res.currency
3433	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	113	t	GHS	base	res.currency
3434	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	114	t	GMD	base	res.currency
3435	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	115	t	MZN	base	res.currency
3436	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	116	t	MMK	base	res.currency
3437	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	117	t	NAD	base	res.currency
3438	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	118	t	NPR	base	res.currency
3439	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	119	t	ALL	base	res.currency
3440	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	120	t	NIO	base	res.currency
3441	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	121	t	NGN	base	res.currency
3442	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	122	t	KPW	base	res.currency
3443	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	123	t	ZWL	base	res.currency
3444	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	124	t	ZIG	base	res.currency
3445	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	125	t	ZMW	base	res.currency
3446	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	126	t	YER	base	res.currency
3448	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	127	t	VUV	base	res.currency
3449	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	128	t	UZS	base	res.currency
3450	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	129	t	AED	base	res.currency
3451	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	130	t	TMT	base	res.currency
3452	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	131	t	TND	base	res.currency
3453	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	132	t	TTD	base	res.currency
3454	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	133	t	TOP	base	res.currency
3455	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	134	t	THB	base	res.currency
3456	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	135	t	TZS	base	res.currency
3457	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	136	t	TJS	base	res.currency
3458	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	137	t	TWD	base	res.currency
3459	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	138	t	SYP	base	res.currency
3460	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	139	t	SZL	base	res.currency
3461	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	140	t	SRD	base	res.currency
3462	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	141	t	SDG	base	res.currency
3463	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	142	t	LKR	base	res.currency
3464	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	143	t	SSP	base	res.currency
3465	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	144	t	GBP	base	res.currency
3466	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	145	t	SOS	base	res.currency
3467	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	146	t	SBD	base	res.currency
3468	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	147	t	SLL	base	res.currency
3469	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	148	t	SCR	base	res.currency
3470	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	149	t	RSD	base	res.currency
3471	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	150	t	SAR	base	res.currency
3472	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	151	t	STD	base	res.currency
3473	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	152	t	WST	base	res.currency
3474	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	153	t	SHP	base	res.currency
3475	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	154	t	RWF	base	res.currency
3476	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	155	t	QAR	base	res.currency
3477	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	156	t	PEN	base	res.currency
3478	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	157	t	PYG	base	res.currency
3479	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	158	t	PGK	base	res.currency
3480	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	159	t	PKR	base	res.currency
3481	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	160	t	OMR	base	res.currency
3482	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	161	t	CVE	base	res.currency
3483	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	162	t	COU	base	res.currency
3484	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	163	t	CLF	base	res.currency
3485	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	164	t	CUC	base	res.currency
3486	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	165	t	GTQ	base	res.currency
3487	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	166	t	VES	base	res.currency
3488	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	167	t	UYW	base	res.currency
3489	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	168	t	UYI	base	res.currency
3490	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	169	t	STN	base	res.currency
2	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	main_company	base	res.company
4	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	user_root	base	res.users
3493	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	t	user_admin	base	res.users
3494	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	t	default_user_res_partner	base	res.partner
3497	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	paperformat_euro	base	report.paperformat
3498	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	t	paperformat_us	base	report.paperformat
3499	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	t	paperformat_batch_deposit	base	report.paperformat
3500	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	ad	base	res.country
3501	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	t	ae	base	res.country
3502	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	t	af	base	res.country
3503	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	t	ag	base	res.country
3504	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	t	ai	base	res.country
3505	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	t	al	base	res.country
3506	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	t	am	base	res.country
3507	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	t	ao	base	res.country
3508	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	t	aq	base	res.country
3509	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	t	ar	base	res.country
3510	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	11	t	as	base	res.country
3511	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	t	at	base	res.country
3512	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	13	t	au	base	res.country
3513	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	14	t	aw	base	res.country
3514	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	15	t	ax	base	res.country
3515	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	16	t	az	base	res.country
3516	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	17	t	ba	base	res.country
3517	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	18	t	bb	base	res.country
3518	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	19	t	bd	base	res.country
3519	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	20	t	be	base	res.country
3520	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	21	t	bf	base	res.country
3521	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	22	t	bg	base	res.country
3522	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	23	t	bh	base	res.country
3523	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	24	t	bi	base	res.country
3524	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	25	t	bj	base	res.country
3525	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	26	t	bl	base	res.country
3526	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	27	t	bm	base	res.country
3527	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	28	t	bn	base	res.country
3528	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	29	t	bo	base	res.country
3529	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	30	t	bq	base	res.country
3530	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	31	t	br	base	res.country
3531	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	32	t	bs	base	res.country
3532	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	33	t	bt	base	res.country
3533	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	34	t	bv	base	res.country
3534	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	35	t	bw	base	res.country
3535	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	36	t	by	base	res.country
3536	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	37	t	bz	base	res.country
3537	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	38	t	ca	base	res.country
3538	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	39	t	cc	base	res.country
3539	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	40	t	cf	base	res.country
3540	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	41	t	cd	base	res.country
3541	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	42	t	cg	base	res.country
3542	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	43	t	ch	base	res.country
3543	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	44	t	ci	base	res.country
3544	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	45	t	ck	base	res.country
3545	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	46	t	cl	base	res.country
3546	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	47	t	cm	base	res.country
3547	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	48	t	cn	base	res.country
3548	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	49	t	co	base	res.country
3549	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	50	t	cr	base	res.country
3550	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	51	t	cu	base	res.country
3551	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	52	t	cv	base	res.country
3552	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	53	t	cw	base	res.country
3553	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	54	t	cx	base	res.country
3554	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	55	t	cy	base	res.country
3555	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	56	t	cz	base	res.country
3556	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	57	t	de	base	res.country
3557	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	58	t	dj	base	res.country
3558	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	59	t	dk	base	res.country
3559	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	60	t	dm	base	res.country
3560	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	61	t	do	base	res.country
3561	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	62	t	dz	base	res.country
3562	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	63	t	ec	base	res.country
3563	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	64	t	ee	base	res.country
3564	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	65	t	eg	base	res.country
3565	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	66	t	eh	base	res.country
3566	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	67	t	er	base	res.country
3567	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	68	t	es	base	res.country
3568	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	69	t	et	base	res.country
3569	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	70	t	fi	base	res.country
3570	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	71	t	fj	base	res.country
3571	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	72	t	fk	base	res.country
3572	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	73	t	fm	base	res.country
3573	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	74	t	fo	base	res.country
3574	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	75	t	fr	base	res.country
3575	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	76	t	ga	base	res.country
3576	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	77	t	gd	base	res.country
3577	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	78	t	ge	base	res.country
3578	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	79	t	gf	base	res.country
3579	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	80	t	gh	base	res.country
3580	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	81	t	gi	base	res.country
3581	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	82	t	gg	base	res.country
3582	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	83	t	gl	base	res.country
3583	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	84	t	gm	base	res.country
3584	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	85	t	gn	base	res.country
3585	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	86	t	gp	base	res.country
3586	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	87	t	gq	base	res.country
3587	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	88	t	gr	base	res.country
3588	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	89	t	gs	base	res.country
3589	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	90	t	gt	base	res.country
3590	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	91	t	gu	base	res.country
3591	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	92	t	gw	base	res.country
3592	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	93	t	gy	base	res.country
3593	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	94	t	hk	base	res.country
3594	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	95	t	hm	base	res.country
3595	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	96	t	hn	base	res.country
3596	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	97	t	hr	base	res.country
3597	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	98	t	ht	base	res.country
3598	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	99	t	hu	base	res.country
3599	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	100	t	id	base	res.country
3600	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	101	t	ie	base	res.country
3601	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	102	t	il	base	res.country
3602	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	103	t	im	base	res.country
3603	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	104	t	in	base	res.country
3604	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	105	t	io	base	res.country
3605	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	106	t	iq	base	res.country
3606	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	107	t	ir	base	res.country
3607	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	108	t	is	base	res.country
3608	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	109	t	it	base	res.country
3609	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	110	t	je	base	res.country
3610	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	111	t	jm	base	res.country
3611	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	112	t	jo	base	res.country
3612	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	113	t	jp	base	res.country
3613	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	114	t	ke	base	res.country
3614	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	115	t	kg	base	res.country
3615	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	116	t	kh	base	res.country
3616	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	117	t	ki	base	res.country
3617	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	118	t	km	base	res.country
3618	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	119	t	kn	base	res.country
3619	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	120	t	kp	base	res.country
3620	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	121	t	kr	base	res.country
3621	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	122	t	kw	base	res.country
3622	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	123	t	ky	base	res.country
3623	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	124	t	kz	base	res.country
3624	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	125	t	la	base	res.country
3625	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	126	t	lb	base	res.country
3626	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	127	t	lc	base	res.country
3627	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	128	t	li	base	res.country
3628	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	129	t	lk	base	res.country
3629	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	130	t	lr	base	res.country
3630	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	131	t	ls	base	res.country
3631	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	132	t	lt	base	res.country
3632	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	133	t	lu	base	res.country
3633	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	134	t	lv	base	res.country
3634	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	135	t	ly	base	res.country
3635	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	136	t	ma	base	res.country
3636	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	137	t	mc	base	res.country
3637	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	138	t	md	base	res.country
3638	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	139	t	me	base	res.country
3639	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	140	t	mf	base	res.country
3640	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	141	t	mg	base	res.country
3641	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	142	t	mh	base	res.country
3642	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	143	t	mk	base	res.country
3643	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	144	t	ml	base	res.country
3644	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	145	t	mm	base	res.country
3645	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	146	t	mn	base	res.country
3646	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	147	t	mo	base	res.country
3647	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	148	t	mp	base	res.country
3648	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	149	t	mq	base	res.country
3649	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	150	t	mr	base	res.country
3650	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	151	t	ms	base	res.country
3651	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	152	t	mt	base	res.country
3652	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	153	t	mu	base	res.country
3653	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	154	t	mv	base	res.country
3654	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	155	t	mw	base	res.country
3655	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	156	t	mx	base	res.country
3656	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	157	t	my	base	res.country
3657	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	158	t	mz	base	res.country
3658	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	159	t	na	base	res.country
3659	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	160	t	nc	base	res.country
3660	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	161	t	ne	base	res.country
3661	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	162	t	nf	base	res.country
3662	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	163	t	ng	base	res.country
3663	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	164	t	ni	base	res.country
3664	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	165	t	nl	base	res.country
3665	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	166	t	no	base	res.country
3666	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	167	t	np	base	res.country
3667	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	168	t	nr	base	res.country
3668	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	169	t	nu	base	res.country
3669	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	170	t	nz	base	res.country
3670	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	171	t	om	base	res.country
3671	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	172	t	pa	base	res.country
3672	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	173	t	pe	base	res.country
3673	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	174	t	pf	base	res.country
3674	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	175	t	pg	base	res.country
3675	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	176	t	ph	base	res.country
3676	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	177	t	pk	base	res.country
3677	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	178	t	pl	base	res.country
3678	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	179	t	pm	base	res.country
3679	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	180	t	pn	base	res.country
3680	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	181	t	pr	base	res.country
3681	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	182	t	ps	base	res.country
3682	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	183	t	pt	base	res.country
3683	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	184	t	pw	base	res.country
3684	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	185	t	py	base	res.country
3685	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	186	t	qa	base	res.country
3686	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	187	t	re	base	res.country
3687	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	188	t	ro	base	res.country
3688	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	189	t	rs	base	res.country
3689	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	190	t	ru	base	res.country
3690	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	191	t	rw	base	res.country
3691	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	192	t	sa	base	res.country
3692	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	193	t	sb	base	res.country
3693	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	194	t	sc	base	res.country
3694	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	195	t	sd	base	res.country
3695	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	196	t	se	base	res.country
3696	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	197	t	sg	base	res.country
3697	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	198	t	sh	base	res.country
3698	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	199	t	si	base	res.country
3699	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	200	t	sj	base	res.country
3700	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	201	t	sk	base	res.country
3701	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	202	t	sl	base	res.country
3702	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	203	t	sm	base	res.country
3703	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	204	t	sn	base	res.country
3704	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	205	t	so	base	res.country
3705	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	206	t	sr	base	res.country
3706	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	207	t	ss	base	res.country
3707	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	208	t	st	base	res.country
3708	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	209	t	sv	base	res.country
3709	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	210	t	sx	base	res.country
3710	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	211	t	sy	base	res.country
3711	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	212	t	sz	base	res.country
3712	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	213	t	tc	base	res.country
3713	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	214	t	td	base	res.country
3714	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	215	t	tf	base	res.country
3715	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	216	t	tg	base	res.country
3716	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	217	t	th	base	res.country
3717	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	218	t	tj	base	res.country
3718	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	219	t	tk	base	res.country
3719	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	220	t	tm	base	res.country
3720	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	221	t	tn	base	res.country
3721	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	222	t	to	base	res.country
3722	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	223	t	tl	base	res.country
3723	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	224	t	tr	base	res.country
3724	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	225	t	tt	base	res.country
3725	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	226	t	tv	base	res.country
3726	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	227	t	tw	base	res.country
3727	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	228	t	tz	base	res.country
3728	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	229	t	ua	base	res.country
3729	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	230	t	ug	base	res.country
3730	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	231	t	uk	base	res.country
3731	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	232	t	um	base	res.country
3732	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	233	t	us	base	res.country
3733	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	234	t	uy	base	res.country
3734	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	235	t	uz	base	res.country
3735	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	236	t	va	base	res.country
3736	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	237	t	vc	base	res.country
3737	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	238	t	ve	base	res.country
3738	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	239	t	vg	base	res.country
3739	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	240	t	vi	base	res.country
3740	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	241	t	vn	base	res.country
3741	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	242	t	vu	base	res.country
3742	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	243	t	wf	base	res.country
3743	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	244	t	ws	base	res.country
3744	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	245	t	ye	base	res.country
3745	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	246	t	yt	base	res.country
3746	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	247	t	za	base	res.country
3747	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	248	t	zm	base	res.country
3748	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	249	t	zw	base	res.country
3749	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	250	t	xk	base	res.country
3750	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	europe	base	res.country.group
3751	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	t	south_america	base	res.country.group
3752	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	t	sepa_zone	base	res.country.group
3753	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	t	gulf_cooperation_council	base	res.country.group
3754	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	t	ch_and_li	base	res.country.group
3755	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	f	demo_force_install_action	base	ir.actions.act_window
3756	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	f	demo_force_install_form	base	ir.ui.view
3757	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	t	icp_mail_catchall_alias	base	ir.config_parameter
3758	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	t	icp_mail_bounce_alias	base	ir.config_parameter
3759	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	t	icp_mail_default_from	base	ir.config_parameter
3761	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	f	group_sanitize_override	base	res.groups
3768	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	f	group_allow_export	base	res.groups
3495	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	t	default_user	base	res.users
3496	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	t	public_user	base	res.users
3775	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	f	template_portal_user_id_res_partner	base	res.partner
3776	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	f	template_portal_user_id	base	res.users
3777	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	f	default_template_user_config	base	ir.config_parameter
3778	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	f	group_private_addresses	base	res.groups
3779	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	t	res_users_log_rule	base	ir.rule
3780	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	t	res_partner_rule	base	ir.rule
3781	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	t	res_partner_portal_public_rule	base	ir.rule
3782	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	t	ir_default_user_rule	base	ir.rule
3783	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	t	ir_default_system_rule	base	ir.rule
3784	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	t	ir_ui_view_custom_personal	base	ir.rule
3785	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	t	res_partner_bank_rule	base	ir.rule
3786	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	t	res_currency_rate_rule	base	ir.rule
3787	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	t	change_password_rule	base	ir.rule
3788	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	t	res_partner_rule_private_employee	base	ir.rule
3789	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	11	t	res_partner_rule_private_group	base	ir.rule
3790	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	t	ir_filters_admin_all_rights_rule	base	ir.rule
3791	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	13	t	ir_filters_employee_rule	base	ir.rule
3792	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	14	t	ir_filters_delete_own_rule	base	ir.rule
3793	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	15	t	ir_filters_portal_public_rule	base	ir.rule
3794	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	16	t	res_company_rule_portal	base	ir.rule
3795	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	17	t	res_company_rule_employee	base	ir.rule
3796	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	18	t	res_company_rule_public	base	ir.rule
3797	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	19	t	res_company_rule_erp_manager	base	ir.rule
3798	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	20	t	res_users_identity_check	base	ir.rule
3799	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	21	t	res_users_rule	base	ir.rule
3800	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	22	t	change_password_own_rule	base	ir.rule
3801	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	23	t	api_key_public	base	ir.rule
3802	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	24	t	api_key_user	base	ir.rule
3803	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	25	t	api_key_admin	base	ir.rule
3804	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	f	menu_board_root	base	ir.ui.menu
3805	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	f	menu_reporting_dashboard	base	ir.ui.menu
3806	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	f	menu_reporting_config	base	ir.ui.menu
3808	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	f	menu_management	base	ir.ui.menu
3809	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	f	menu_administration_shortcut	base	ir.ui.menu
3810	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	f	menu_users	base	ir.ui.menu
3811	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	f	menu_translation	base	ir.ui.menu
3812	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	f	menu_translation_app	base	ir.ui.menu
3813	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	f	menu_translation_export	base	ir.ui.menu
3814	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	11	f	menu_config	base	ir.ui.menu
3815	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	f	menu_custom	base	ir.ui.menu
3816	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	13	f	next_id_2	base	ir.ui.menu
3817	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	14	f	menu_email	base	ir.ui.menu
3818	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	15	f	next_id_9	base	ir.ui.menu
3819	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	16	f	menu_automation	base	ir.ui.menu
3820	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	17	f	menu_security	base	ir.ui.menu
3821	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	18	f	menu_ir_property	base	ir.ui.menu
3822	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	19	f	menu_tests	base	ir.ui.menu
3807	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	f	menu_administration	base	ir.ui.menu
3824	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	f	action_client_base_menu	base	ir.actions.client
3825	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	f	open_menu	base	ir.actions.todo
3826	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	f	action_open_website	base	ir.actions.act_url
3827	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	f	view_decimal_precision_form	base	ir.ui.view
3828	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	f	view_decimal_precision_tree	base	ir.ui.view
3829	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	f	action_decimal_precision_form	base	ir.actions.act_window
3830	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	20	f	menu_decimal_precision_form	base	ir.ui.menu
3831	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	f	res_config_view_base	base	ir.ui.view
3832	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	f	res_config_installer	base	ir.ui.view
3833	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1	f	state_au_1	base	res.country.state
3834	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	2	f	state_au_2	base	res.country.state
3835	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	3	f	state_au_3	base	res.country.state
3836	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	4	f	state_au_4	base	res.country.state
3837	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	5	f	state_au_5	base	res.country.state
3838	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	6	f	state_au_6	base	res.country.state
3839	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	7	f	state_au_7	base	res.country.state
3840	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	8	f	state_au_8	base	res.country.state
3841	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	9	f	state_us_1	base	res.country.state
3842	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	10	f	state_us_2	base	res.country.state
3843	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	11	f	state_us_3	base	res.country.state
3844	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	12	f	state_us_4	base	res.country.state
3845	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	13	f	state_us_5	base	res.country.state
3846	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	14	f	state_us_6	base	res.country.state
3847	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	15	f	state_us_7	base	res.country.state
3848	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	16	f	state_us_8	base	res.country.state
3849	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	17	f	state_us_9	base	res.country.state
3850	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	18	f	state_us_10	base	res.country.state
3851	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	19	f	state_us_11	base	res.country.state
3852	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	20	f	state_us_12	base	res.country.state
3853	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	21	f	state_us_13	base	res.country.state
3854	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	22	f	state_us_14	base	res.country.state
3855	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	23	f	state_us_15	base	res.country.state
3856	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	24	f	state_us_16	base	res.country.state
3857	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	25	f	state_us_17	base	res.country.state
3858	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	26	f	state_us_18	base	res.country.state
3859	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	27	f	state_us_19	base	res.country.state
3860	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	28	f	state_us_20	base	res.country.state
3861	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	29	f	state_us_21	base	res.country.state
3862	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	30	f	state_us_22	base	res.country.state
3863	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	31	f	state_us_23	base	res.country.state
3864	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	32	f	state_us_24	base	res.country.state
3865	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	33	f	state_us_25	base	res.country.state
3866	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	34	f	state_us_26	base	res.country.state
3867	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	35	f	state_us_27	base	res.country.state
3868	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	36	f	state_us_28	base	res.country.state
3869	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	37	f	state_us_29	base	res.country.state
3870	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	38	f	state_us_30	base	res.country.state
3871	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	39	f	state_us_31	base	res.country.state
3872	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	40	f	state_us_32	base	res.country.state
3873	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	41	f	state_us_33	base	res.country.state
3874	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	42	f	state_us_34	base	res.country.state
3875	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	43	f	state_us_35	base	res.country.state
3876	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	44	f	state_us_36	base	res.country.state
3877	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	45	f	state_us_37	base	res.country.state
3878	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	46	f	state_us_38	base	res.country.state
3879	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	47	f	state_us_39	base	res.country.state
3880	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	48	f	state_us_40	base	res.country.state
3881	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	49	f	state_us_41	base	res.country.state
3882	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	50	f	state_us_42	base	res.country.state
3883	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	51	f	state_us_43	base	res.country.state
3884	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	52	f	state_us_44	base	res.country.state
3885	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	53	f	state_us_45	base	res.country.state
3886	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	54	f	state_us_46	base	res.country.state
3887	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	55	f	state_us_47	base	res.country.state
3888	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	56	f	state_us_48	base	res.country.state
3889	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	57	f	state_us_49	base	res.country.state
3890	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	58	f	state_us_50	base	res.country.state
3891	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	59	f	state_us_51	base	res.country.state
3892	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	60	f	state_us_as	base	res.country.state
3893	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	61	f	state_us_fm	base	res.country.state
3894	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	62	f	state_us_gu	base	res.country.state
3895	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	63	f	state_us_mh	base	res.country.state
3896	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	64	f	state_us_mp	base	res.country.state
3897	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	65	f	state_us_pw	base	res.country.state
3898	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	66	f	state_us_pr	base	res.country.state
3899	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	67	f	state_us_vi	base	res.country.state
3900	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	68	f	state_us_aa	base	res.country.state
3901	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	69	f	state_us_ae	base	res.country.state
3902	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	70	f	state_us_ap	base	res.country.state
3903	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	71	f	state_br_ac	base	res.country.state
3904	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	72	f	state_br_al	base	res.country.state
3905	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	73	f	state_br_ap	base	res.country.state
3906	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	74	f	state_br_am	base	res.country.state
3907	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	75	f	state_br_ba	base	res.country.state
3908	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	76	f	state_br_ce	base	res.country.state
3909	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	77	f	state_br_df	base	res.country.state
3910	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	78	f	state_br_es	base	res.country.state
3911	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	79	f	state_br_go	base	res.country.state
3912	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	80	f	state_br_ma	base	res.country.state
3913	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	81	f	state_br_mt	base	res.country.state
3914	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	82	f	state_br_ms	base	res.country.state
3915	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	83	f	state_br_mg	base	res.country.state
3916	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	84	f	state_br_pa	base	res.country.state
3917	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	85	f	state_br_pb	base	res.country.state
3918	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	86	f	state_br_pr	base	res.country.state
3919	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	87	f	state_br_pe	base	res.country.state
3920	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	88	f	state_br_pi	base	res.country.state
3921	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	89	f	state_br_rj	base	res.country.state
3922	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	90	f	state_br_rn	base	res.country.state
3923	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	91	f	state_br_rs	base	res.country.state
3924	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	92	f	state_br_ro	base	res.country.state
3925	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	93	f	state_br_rr	base	res.country.state
3926	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	94	f	state_br_sc	base	res.country.state
3927	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	95	f	state_br_sp	base	res.country.state
3928	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	96	f	state_br_se	base	res.country.state
3929	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	97	f	state_br_to	base	res.country.state
3930	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	98	f	state_ru_ad	base	res.country.state
3931	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	99	f	state_ru_al	base	res.country.state
3932	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	100	f	state_ru_alt	base	res.country.state
3933	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	101	f	state_ru_amu	base	res.country.state
3934	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	102	f	state_ru_ark	base	res.country.state
3935	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	103	f	state_ru_ast	base	res.country.state
3936	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	104	f	state_ru_ba	base	res.country.state
3937	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	105	f	state_ru_bel	base	res.country.state
3938	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	106	f	state_ru_bry	base	res.country.state
3939	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	107	f	state_ru_bu	base	res.country.state
3940	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	108	f	state_ru_ce	base	res.country.state
3941	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	109	f	state_ru_che	base	res.country.state
3942	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	110	f	state_ru_chu	base	res.country.state
3943	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	111	f	state_ru_cu	base	res.country.state
3944	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	112	f	state_ru_da	base	res.country.state
3945	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	113	f	state_ru_in	base	res.country.state
3946	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	114	f	state_ru_irk	base	res.country.state
3947	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	115	f	state_ru_iva	base	res.country.state
3948	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	116	f	state_ru_kam	base	res.country.state
3949	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	117	f	state_ru_kb	base	res.country.state
3950	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	118	f	state_ru_kgd	base	res.country.state
3951	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	119	f	state_ru_kl	base	res.country.state
3952	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	120	f	state_ru_klu	base	res.country.state
3953	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	121	f	state_ru_kc	base	res.country.state
3954	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	122	f	state_ru_kr	base	res.country.state
3955	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	123	f	state_ru_kem	base	res.country.state
3956	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	124	f	state_ru_kha	base	res.country.state
3957	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	125	f	state_ru_kk	base	res.country.state
3958	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	126	f	state_ru_khm	base	res.country.state
3959	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	127	f	state_ru_kir	base	res.country.state
3960	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	128	f	state_ru_ko	base	res.country.state
3961	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	129	f	state_ru_kos	base	res.country.state
3962	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	130	f	state_ru_kda	base	res.country.state
3963	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	131	f	state_ru_kya	base	res.country.state
3964	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	132	f	state_ru_kgn	base	res.country.state
3965	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	133	f	state_ru_krs	base	res.country.state
3966	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	134	f	state_ru_len	base	res.country.state
3967	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	135	f	state_ru_lip	base	res.country.state
3968	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	136	f	state_ru_mag	base	res.country.state
3969	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	137	f	state_ru_me	base	res.country.state
3970	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	138	f	state_ru_mo	base	res.country.state
3971	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	139	f	state_ru_mos	base	res.country.state
3972	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	140	f	state_ru_mow	base	res.country.state
3973	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	141	f	state_ru_mur	base	res.country.state
3974	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	142	f	state_ru_niz	base	res.country.state
3975	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	143	f	state_ru_ngr	base	res.country.state
3976	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	144	f	state_ru_nvs	base	res.country.state
3977	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	145	f	state_ru_oms	base	res.country.state
3978	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	146	f	state_ru_ore	base	res.country.state
3979	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	147	f	state_ru_orl	base	res.country.state
3980	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	148	f	state_ru_pnz	base	res.country.state
3981	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	149	f	state_ru_per	base	res.country.state
3982	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	150	f	state_ru_pri	base	res.country.state
3983	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	151	f	state_ru_psk	base	res.country.state
3984	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	152	f	state_ru_ros	base	res.country.state
3985	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	153	f	state_ru_rya	base	res.country.state
3986	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	154	f	state_ru_sa	base	res.country.state
3987	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	155	f	state_ru_sak	base	res.country.state
3988	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	156	f	state_ru_sam	base	res.country.state
3989	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	157	f	state_ru_spe	base	res.country.state
3990	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	158	f	state_ru_sar	base	res.country.state
3991	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	159	f	state_ru_se	base	res.country.state
3992	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	160	f	state_ru_smo	base	res.country.state
3993	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	161	f	state_ru_sta	base	res.country.state
3994	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	162	f	state_ru_sve	base	res.country.state
3995	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	163	f	state_ru_tam	base	res.country.state
3996	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	164	f	state_ru_ta	base	res.country.state
3997	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	165	f	state_ru_tom	base	res.country.state
3998	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	166	f	state_ru_tul	base	res.country.state
3999	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	167	f	state_ru_tve	base	res.country.state
4000	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	168	f	state_ru_tyu	base	res.country.state
4001	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	169	f	state_ru_ty	base	res.country.state
4002	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	170	f	state_ru_ud	base	res.country.state
4003	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	171	f	state_ru_uly	base	res.country.state
4004	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	172	f	state_ru_vla	base	res.country.state
4005	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	173	f	state_ru_vgg	base	res.country.state
4006	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	174	f	state_ru_vlg	base	res.country.state
4007	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	175	f	state_ru_vor	base	res.country.state
4008	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	176	f	state_ru_yan	base	res.country.state
4009	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	177	f	state_ru_yar	base	res.country.state
4010	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	178	f	state_ru_yev	base	res.country.state
4011	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	179	f	state_gt_ave	base	res.country.state
4012	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	180	f	state_gt_bve	base	res.country.state
4013	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	181	f	state_gt_cmt	base	res.country.state
4014	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	182	f	state_gt_cqm	base	res.country.state
4169	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	337	f	state_it_en	base	res.country.state
4015	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	183	f	state_gt_epr	base	res.country.state
4016	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	184	f	state_gt_esc	base	res.country.state
4017	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	185	f	state_gt_gua	base	res.country.state
4018	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	186	f	state_gt_hue	base	res.country.state
4019	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	187	f	state_gt_iza	base	res.country.state
4020	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	188	f	state_gt_jal	base	res.country.state
4021	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	189	f	state_gt_jut	base	res.country.state
4022	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	190	f	state_gt_pet	base	res.country.state
4023	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	191	f	state_gt_que	base	res.country.state
4024	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	192	f	state_gt_qui	base	res.country.state
4025	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	193	f	state_gt_ret	base	res.country.state
4026	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	194	f	state_gt_sac	base	res.country.state
4027	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	195	f	state_gt_sma	base	res.country.state
4028	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	196	f	state_gt_sro	base	res.country.state
4029	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	197	f	state_gt_sol	base	res.country.state
4030	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	198	f	state_gt_suc	base	res.country.state
4031	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	199	f	state_gt_tot	base	res.country.state
4032	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	200	f	state_gt_zac	base	res.country.state
4033	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	201	f	state_jp_jp-23	base	res.country.state
4034	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	202	f	state_jp_jp-05	base	res.country.state
4035	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	203	f	state_jp_jp-02	base	res.country.state
4036	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	204	f	state_jp_jp-12	base	res.country.state
4037	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	205	f	state_jp_jp-38	base	res.country.state
4038	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	206	f	state_jp_jp-18	base	res.country.state
4039	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	207	f	state_jp_jp-40	base	res.country.state
4040	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	208	f	state_jp_jp-07	base	res.country.state
4041	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	209	f	state_jp_jp-21	base	res.country.state
4042	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	210	f	state_jp_jp-10	base	res.country.state
4043	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	211	f	state_jp_jp-34	base	res.country.state
4044	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	212	f	state_jp_jp-01	base	res.country.state
4045	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	213	f	state_jp_jp-28	base	res.country.state
4046	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	214	f	state_jp_jp-08	base	res.country.state
4047	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	215	f	state_jp_jp-17	base	res.country.state
4048	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	216	f	state_jp_jp-03	base	res.country.state
4049	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	217	f	state_jp_jp-37	base	res.country.state
4050	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	218	f	state_jp_jp-46	base	res.country.state
4051	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	219	f	state_jp_jp-14	base	res.country.state
4052	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	220	f	state_jp_jp-39	base	res.country.state
4053	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	221	f	state_jp_jp-43	base	res.country.state
4054	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	222	f	state_jp_jp-26	base	res.country.state
4055	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	223	f	state_jp_jp-24	base	res.country.state
4056	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	224	f	state_jp_jp-04	base	res.country.state
4057	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	225	f	state_jp_jp-45	base	res.country.state
4058	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	226	f	state_jp_jp-20	base	res.country.state
4059	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	227	f	state_jp_jp-42	base	res.country.state
4060	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	228	f	state_jp_jp-29	base	res.country.state
4061	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	229	f	state_jp_jp-15	base	res.country.state
4062	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	230	f	state_jp_jp-44	base	res.country.state
4063	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	231	f	state_jp_jp-33	base	res.country.state
4064	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	232	f	state_jp_jp-47	base	res.country.state
4065	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	233	f	state_jp_jp-27	base	res.country.state
4066	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	234	f	state_jp_jp-41	base	res.country.state
4067	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	235	f	state_jp_jp-11	base	res.country.state
4068	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	236	f	state_jp_jp-25	base	res.country.state
4069	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	237	f	state_jp_jp-32	base	res.country.state
4070	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	238	f	state_jp_jp-22	base	res.country.state
4071	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	239	f	state_jp_jp-09	base	res.country.state
4072	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	240	f	state_jp_jp-36	base	res.country.state
4073	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	241	f	state_jp_jp-31	base	res.country.state
4074	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	242	f	state_jp_jp-16	base	res.country.state
4075	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	243	f	state_jp_jp-13	base	res.country.state
4076	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	244	f	state_jp_jp-30	base	res.country.state
4077	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	245	f	state_jp_jp-06	base	res.country.state
4078	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	246	f	state_jp_jp-35	base	res.country.state
4079	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	247	f	state_jp_jp-19	base	res.country.state
4080	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	248	f	state_pt_pt-01	base	res.country.state
4081	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	249	f	state_pt_pt-02	base	res.country.state
4082	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	250	f	state_pt_pt-03	base	res.country.state
4083	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	251	f	state_pt_pt-04	base	res.country.state
4084	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	252	f	state_pt_pt-05	base	res.country.state
4085	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	253	f	state_pt_pt-06	base	res.country.state
4086	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	254	f	state_pt_pt-07	base	res.country.state
4087	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	255	f	state_pt_pt-08	base	res.country.state
4088	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	256	f	state_pt_pt-09	base	res.country.state
4089	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	257	f	state_pt_pt-10	base	res.country.state
4090	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	258	f	state_pt_pt-11	base	res.country.state
4091	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	259	f	state_pt_pt-12	base	res.country.state
4092	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	260	f	state_pt_pt-13	base	res.country.state
4093	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	261	f	state_pt_pt-14	base	res.country.state
4094	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	262	f	state_pt_pt-15	base	res.country.state
4095	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	263	f	state_pt_pt-16	base	res.country.state
4096	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	264	f	state_pt_pt-17	base	res.country.state
4097	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	265	f	state_pt_pt-18	base	res.country.state
4098	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	266	f	state_pt_pt-20	base	res.country.state
4099	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	267	f	state_pt_pt-30	base	res.country.state
4100	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	268	f	state_eg_dk	base	res.country.state
4101	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	269	f	state_eg_ba	base	res.country.state
4102	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	270	f	state_eg_bh	base	res.country.state
4103	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	271	f	state_eg_fym	base	res.country.state
4104	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	272	f	state_eg_gh	base	res.country.state
4105	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	273	f	state_eg_alx	base	res.country.state
4106	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	274	f	state_eg_is	base	res.country.state
4107	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	275	f	state_eg_gz	base	res.country.state
4108	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	276	f	state_eg_mnf	base	res.country.state
4109	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	277	f	state_eg_mn	base	res.country.state
4110	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	278	f	state_eg_c	base	res.country.state
4111	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	279	f	state_eg_kb	base	res.country.state
4112	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	280	f	state_eg_lx	base	res.country.state
4113	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	281	f	state_eg_wad	base	res.country.state
4114	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	282	f	state_eg_shr	base	res.country.state
4115	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	283	f	state_eg_su	base	res.country.state
4116	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	284	f	state_eg_suz	base	res.country.state
4117	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	285	f	state_eg_asn	base	res.country.state
4118	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	286	f	state_eg_ast	base	res.country.state
4119	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	287	f	state_eg_bns	base	res.country.state
4120	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	288	f	state_eg_pts	base	res.country.state
4121	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	289	f	state_eg_dt	base	res.country.state
4122	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	290	f	state_eg_hu	base	res.country.state
4123	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	291	f	state_eg_js	base	res.country.state
4124	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	292	f	state_eg_kfs	base	res.country.state
4125	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	293	f	state_eg_mt	base	res.country.state
4126	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	294	f	state_eg_kn	base	res.country.state
4127	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	295	f	state_eg_sin	base	res.country.state
4128	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	296	f	state_eg_shg	base	res.country.state
4129	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	297	f	state_za_ec	base	res.country.state
4130	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	298	f	state_za_fs	base	res.country.state
4131	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	299	f	state_za_gt	base	res.country.state
4132	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	300	f	state_za_nl	base	res.country.state
4133	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	301	f	state_za_lp	base	res.country.state
4134	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	302	f	state_za_mp	base	res.country.state
4135	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	303	f	state_za_nc	base	res.country.state
4136	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	304	f	state_za_nw	base	res.country.state
4137	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	305	f	state_za_wc	base	res.country.state
4138	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	306	f	state_it_ag	base	res.country.state
4139	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	307	f	state_it_al	base	res.country.state
4140	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	308	f	state_it_an	base	res.country.state
4141	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	309	f	state_it_ao	base	res.country.state
4142	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	310	f	state_it_ar	base	res.country.state
4143	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	311	f	state_it_ap	base	res.country.state
4144	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	312	f	state_it_at	base	res.country.state
4145	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	313	f	state_it_av	base	res.country.state
4146	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	314	f	state_it_ba	base	res.country.state
4147	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	315	f	state_it_bt	base	res.country.state
4148	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	316	f	state_it_bl	base	res.country.state
4149	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	317	f	state_it_bn	base	res.country.state
4150	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	318	f	state_it_bg	base	res.country.state
4151	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	319	f	state_it_bi	base	res.country.state
4152	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	320	f	state_it_bo	base	res.country.state
4153	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	321	f	state_it_bz	base	res.country.state
4154	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	322	f	state_it_bs	base	res.country.state
4155	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	323	f	state_it_br	base	res.country.state
4156	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	324	f	state_it_ca	base	res.country.state
4157	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	325	f	state_it_cl	base	res.country.state
4158	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	326	f	state_it_cb	base	res.country.state
4159	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	327	f	state_it_ci	base	res.country.state
4160	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	328	f	state_it_ce	base	res.country.state
4161	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	329	f	state_it_ct	base	res.country.state
4162	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	330	f	state_it_cz	base	res.country.state
4163	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	331	f	state_it_ch	base	res.country.state
4164	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	332	f	state_it_co	base	res.country.state
4165	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	333	f	state_it_cs	base	res.country.state
4166	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	334	f	state_it_cr	base	res.country.state
4167	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	335	f	state_it_kr	base	res.country.state
4168	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	336	f	state_it_cn	base	res.country.state
4170	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	338	f	state_it_fm	base	res.country.state
4171	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	339	f	state_it_fe	base	res.country.state
4172	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	340	f	state_it_fi	base	res.country.state
4173	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	341	f	state_it_fg	base	res.country.state
4174	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	342	f	state_it_fc	base	res.country.state
4175	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	343	f	state_it_fr	base	res.country.state
4176	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	344	f	state_it_ge	base	res.country.state
4177	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	345	f	state_it_go	base	res.country.state
4178	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	346	f	state_it_gr	base	res.country.state
4179	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	347	f	state_it_im	base	res.country.state
4180	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	348	f	state_it_is	base	res.country.state
4181	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	349	f	state_it_sp	base	res.country.state
4182	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	350	f	state_it_aq	base	res.country.state
4183	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	351	f	state_it_lt	base	res.country.state
4184	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	352	f	state_it_le	base	res.country.state
4185	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	353	f	state_it_lc	base	res.country.state
4186	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	354	f	state_it_li	base	res.country.state
4187	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	355	f	state_it_lo	base	res.country.state
4188	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	356	f	state_it_lu	base	res.country.state
4189	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	357	f	state_it_mc	base	res.country.state
4190	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	358	f	state_it_mn	base	res.country.state
4191	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	359	f	state_it_ms	base	res.country.state
4192	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	360	f	state_it_mt	base	res.country.state
4193	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	361	f	state_it_vs	base	res.country.state
4194	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	362	f	state_it_me	base	res.country.state
4195	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	363	f	state_it_mi	base	res.country.state
4196	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	364	f	state_it_mo	base	res.country.state
4197	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	365	f	state_it_mb	base	res.country.state
4198	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	366	f	state_it_na	base	res.country.state
4199	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	367	f	state_it_no	base	res.country.state
4200	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	368	f	state_it_nu	base	res.country.state
4201	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	369	f	state_it_og	base	res.country.state
4202	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	370	f	state_it_ot	base	res.country.state
4203	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	371	f	state_it_or	base	res.country.state
4204	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	372	f	state_it_pd	base	res.country.state
4205	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	373	f	state_it_pa	base	res.country.state
4206	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	374	f	state_it_pr	base	res.country.state
4207	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	375	f	state_it_pv	base	res.country.state
4208	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	376	f	state_it_pg	base	res.country.state
4209	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	377	f	state_it_pu	base	res.country.state
4210	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	378	f	state_it_pe	base	res.country.state
4211	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	379	f	state_it_pc	base	res.country.state
4212	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	380	f	state_it_pi	base	res.country.state
4213	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	381	f	state_it_pt	base	res.country.state
4214	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	382	f	state_it_pn	base	res.country.state
4215	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	383	f	state_it_pz	base	res.country.state
4216	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	384	f	state_it_po	base	res.country.state
4217	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	385	f	state_it_rg	base	res.country.state
4218	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	386	f	state_it_ra	base	res.country.state
4219	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	387	f	state_it_rc	base	res.country.state
4220	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	388	f	state_it_re	base	res.country.state
4221	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	389	f	state_it_ri	base	res.country.state
4222	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	390	f	state_it_rn	base	res.country.state
4223	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	391	f	state_it_rm	base	res.country.state
4224	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	392	f	state_it_ro	base	res.country.state
4225	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	393	f	state_it_sa	base	res.country.state
4226	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	394	f	state_it_ss	base	res.country.state
4227	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	395	f	state_it_sv	base	res.country.state
4228	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	396	f	state_it_si	base	res.country.state
4229	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	397	f	state_it_sr	base	res.country.state
4230	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	398	f	state_it_so	base	res.country.state
4231	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	399	f	state_it_su	base	res.country.state
4232	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	400	f	state_it_ta	base	res.country.state
4233	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	401	f	state_it_te	base	res.country.state
4234	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	402	f	state_it_tr	base	res.country.state
4235	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	403	f	state_it_to	base	res.country.state
4236	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	404	f	state_it_tp	base	res.country.state
4237	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	405	f	state_it_tn	base	res.country.state
4238	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	406	f	state_it_tv	base	res.country.state
4239	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	407	f	state_it_ts	base	res.country.state
4240	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	408	f	state_it_ud	base	res.country.state
4241	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	409	f	state_it_va	base	res.country.state
4242	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	410	f	state_it_ve	base	res.country.state
4243	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	411	f	state_it_vb	base	res.country.state
4244	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	412	f	state_it_vc	base	res.country.state
4245	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	413	f	state_it_vr	base	res.country.state
4246	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	414	f	state_it_vv	base	res.country.state
4247	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	415	f	state_it_vi	base	res.country.state
4248	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	416	f	state_it_vt	base	res.country.state
4249	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	417	f	state_es_c	base	res.country.state
4250	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	418	f	state_es_vi	base	res.country.state
4251	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	419	f	state_es_ab	base	res.country.state
4252	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	420	f	state_es_a	base	res.country.state
4253	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	421	f	state_es_al	base	res.country.state
4254	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	422	f	state_es_o	base	res.country.state
4255	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	423	f	state_es_av	base	res.country.state
4256	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	424	f	state_es_ba	base	res.country.state
4257	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	425	f	state_es_pm	base	res.country.state
4258	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	426	f	state_es_b	base	res.country.state
4259	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	427	f	state_es_bu	base	res.country.state
4260	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	428	f	state_es_cc	base	res.country.state
4261	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	429	f	state_es_ca	base	res.country.state
4262	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	430	f	state_es_s	base	res.country.state
4263	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	431	f	state_es_cs	base	res.country.state
4264	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	432	f	state_es_ce	base	res.country.state
4265	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	433	f	state_es_cr	base	res.country.state
4266	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	434	f	state_es_co	base	res.country.state
4267	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	435	f	state_es_cu	base	res.country.state
4268	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	436	f	state_es_gi	base	res.country.state
4269	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	437	f	state_es_gr	base	res.country.state
4270	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	438	f	state_es_gu	base	res.country.state
4271	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	439	f	state_es_ss	base	res.country.state
4272	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	440	f	state_es_h	base	res.country.state
4273	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	441	f	state_es_hu	base	res.country.state
4274	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	442	f	state_es_j	base	res.country.state
4275	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	443	f	state_es_lo	base	res.country.state
4276	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	444	f	state_es_gc	base	res.country.state
4277	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	445	f	state_es_le	base	res.country.state
4278	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	446	f	state_es_l	base	res.country.state
4279	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	447	f	state_es_lu	base	res.country.state
4280	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	448	f	state_es_m	base	res.country.state
4281	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	449	f	state_es_ma	base	res.country.state
4282	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	450	f	state_es_ml	base	res.country.state
4283	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	451	f	state_es_mu	base	res.country.state
4284	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	452	f	state_es_na	base	res.country.state
4285	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	453	f	state_es_or	base	res.country.state
4286	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	454	f	state_es_p	base	res.country.state
4287	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	455	f	state_es_po	base	res.country.state
4288	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	456	f	state_es_sa	base	res.country.state
4289	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	457	f	state_es_tf	base	res.country.state
4290	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	458	f	state_es_sg	base	res.country.state
4291	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	459	f	state_es_se	base	res.country.state
4292	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	460	f	state_es_so	base	res.country.state
4293	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	461	f	state_es_t	base	res.country.state
4294	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	462	f	state_es_te	base	res.country.state
4295	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	463	f	state_es_to	base	res.country.state
4296	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	464	f	state_es_v	base	res.country.state
4297	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	465	f	state_es_va	base	res.country.state
4298	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	466	f	state_es_bi	base	res.country.state
4299	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	467	f	state_es_za	base	res.country.state
4300	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	468	f	state_es_z	base	res.country.state
4301	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	469	f	state_my_jhr	base	res.country.state
4302	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	470	f	state_my_kdh	base	res.country.state
4303	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	471	f	state_my_ktn	base	res.country.state
4304	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	472	f	state_my_kul	base	res.country.state
4305	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	473	f	state_my_lbn	base	res.country.state
4306	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	474	f	state_my_mlk	base	res.country.state
4307	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	475	f	state_my_nsn	base	res.country.state
4308	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	476	f	state_my_phg	base	res.country.state
4309	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	477	f	state_my_prk	base	res.country.state
4310	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	478	f	state_my_pls	base	res.country.state
4311	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	479	f	state_my_png	base	res.country.state
4312	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	480	f	state_my_pjy	base	res.country.state
4313	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	481	f	state_my_sbh	base	res.country.state
4314	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	482	f	state_my_swk	base	res.country.state
4315	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	483	f	state_my_sgr	base	res.country.state
4316	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	484	f	state_my_trg	base	res.country.state
4317	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	485	f	state_mx_ags	base	res.country.state
4318	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	486	f	state_mx_bc	base	res.country.state
4319	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	487	f	state_mx_bcs	base	res.country.state
4320	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	488	f	state_mx_chih	base	res.country.state
4321	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	489	f	state_mx_col	base	res.country.state
4322	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	490	f	state_mx_camp	base	res.country.state
4323	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	491	f	state_mx_coah	base	res.country.state
4324	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	492	f	state_mx_chis	base	res.country.state
4325	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	493	f	state_mx_df	base	res.country.state
4326	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	494	f	state_mx_dgo	base	res.country.state
4327	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	495	f	state_mx_gro	base	res.country.state
4328	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	496	f	state_mx_gto	base	res.country.state
4329	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	497	f	state_mx_hgo	base	res.country.state
4330	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	498	f	state_mx_jal	base	res.country.state
4331	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	499	f	state_mx_mich	base	res.country.state
4332	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	500	f	state_mx_mor	base	res.country.state
4333	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	501	f	state_mx_mex	base	res.country.state
4334	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	502	f	state_mx_nay	base	res.country.state
4335	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	503	f	state_mx_nl	base	res.country.state
4336	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	504	f	state_mx_oax	base	res.country.state
4337	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	505	f	state_mx_pue	base	res.country.state
4338	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	506	f	state_mx_q_roo	base	res.country.state
4339	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	507	f	state_mx_qro	base	res.country.state
4340	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	508	f	state_mx_sin	base	res.country.state
4341	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	509	f	state_mx_slp	base	res.country.state
4342	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	510	f	state_mx_son	base	res.country.state
4343	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	511	f	state_mx_tab	base	res.country.state
4344	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	512	f	state_mx_tlax	base	res.country.state
4345	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	513	f	state_mx_tamps	base	res.country.state
4346	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	514	f	state_mx_ver	base	res.country.state
4347	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	515	f	state_mx_yuc	base	res.country.state
4348	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	516	f	state_mx_zac	base	res.country.state
4349	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	517	f	state_nz_auk	base	res.country.state
4350	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	518	f	state_nz_bop	base	res.country.state
4351	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	519	f	state_nz_can	base	res.country.state
4352	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	520	f	state_nz_gis	base	res.country.state
4353	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	521	f	state_nz_hkb	base	res.country.state
4354	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	522	f	state_nz_mwt	base	res.country.state
4355	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	523	f	state_nz_mbh	base	res.country.state
4356	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	524	f	state_nz_nsn	base	res.country.state
4357	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	525	f	state_nz_ntl	base	res.country.state
4358	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	526	f	state_nz_ota	base	res.country.state
4359	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	527	f	state_nz_stl	base	res.country.state
4360	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	528	f	state_nz_tki	base	res.country.state
4361	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	529	f	state_nz_tas	base	res.country.state
4362	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	530	f	state_nz_wko	base	res.country.state
4363	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	531	f	state_nz_wgn	base	res.country.state
4364	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	532	f	state_nz_wtc	base	res.country.state
4365	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	533	f	state_ca_ab	base	res.country.state
4366	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	534	f	state_ca_bc	base	res.country.state
4367	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	535	f	state_ca_mb	base	res.country.state
4368	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	536	f	state_ca_nb	base	res.country.state
4369	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	537	f	state_ca_nl	base	res.country.state
4370	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	538	f	state_ca_nt	base	res.country.state
4371	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	539	f	state_ca_ns	base	res.country.state
4372	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	540	f	state_ca_nu	base	res.country.state
4373	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	541	f	state_ca_on	base	res.country.state
4374	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	542	f	state_ca_pe	base	res.country.state
4375	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	543	f	state_ca_qc	base	res.country.state
4376	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	544	f	state_ca_sk	base	res.country.state
4377	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	545	f	state_ca_yt	base	res.country.state
4378	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	546	f	state_ae_az	base	res.country.state
4379	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	547	f	state_ae_aj	base	res.country.state
4380	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	548	f	state_ae_du	base	res.country.state
4381	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	549	f	state_ae_fu	base	res.country.state
4382	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	550	f	state_ae_rk	base	res.country.state
4383	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	551	f	state_ae_sh	base	res.country.state
4384	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	552	f	state_ae_uq	base	res.country.state
4385	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	553	f	state_ar_c	base	res.country.state
4386	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	554	f	state_ar_b	base	res.country.state
4387	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	555	f	state_ar_k	base	res.country.state
4388	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	556	f	state_ar_h	base	res.country.state
4389	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	557	f	state_ar_u	base	res.country.state
4390	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	558	f	state_ar_x	base	res.country.state
4391	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	559	f	state_ar_w	base	res.country.state
4392	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	560	f	state_ar_e	base	res.country.state
4393	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	561	f	state_ar_p	base	res.country.state
4394	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	562	f	state_ar_y	base	res.country.state
4395	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	563	f	state_ar_l	base	res.country.state
4396	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	564	f	state_ar_f	base	res.country.state
4397	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	565	f	state_ar_m	base	res.country.state
4398	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	566	f	state_ar_n	base	res.country.state
4399	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	567	f	state_ar_q	base	res.country.state
4400	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	568	f	state_ar_r	base	res.country.state
4401	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	569	f	state_ar_a	base	res.country.state
4402	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	570	f	state_ar_j	base	res.country.state
4403	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	571	f	state_ar_d	base	res.country.state
4404	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	572	f	state_ar_z	base	res.country.state
4405	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	573	f	state_ar_s	base	res.country.state
4406	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	574	f	state_ar_g	base	res.country.state
4407	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	575	f	state_ar_v	base	res.country.state
4408	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	576	f	state_ar_t	base	res.country.state
4409	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	577	f	state_in_an	base	res.country.state
4410	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	578	f	state_in_ap	base	res.country.state
4411	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	579	f	state_in_ar	base	res.country.state
4412	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	580	f	state_in_as	base	res.country.state
4413	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	581	f	state_in_br	base	res.country.state
4414	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	582	f	state_in_ch	base	res.country.state
4415	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	583	f	state_in_cg	base	res.country.state
4416	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	584	f	state_in_dn	base	res.country.state
4417	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	585	f	state_in_dd	base	res.country.state
4418	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	586	f	state_in_dl	base	res.country.state
4419	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	587	f	state_in_ga	base	res.country.state
4420	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	588	f	state_in_gj	base	res.country.state
4421	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	589	f	state_in_hr	base	res.country.state
4422	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	590	f	state_in_hp	base	res.country.state
4423	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	591	f	state_in_jk	base	res.country.state
4424	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	592	f	state_in_jh	base	res.country.state
4425	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	593	f	state_in_ka	base	res.country.state
4426	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	594	f	state_in_kl	base	res.country.state
4427	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	595	f	state_in_ld	base	res.country.state
4428	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	596	f	state_in_mp	base	res.country.state
4429	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	597	f	state_in_mh	base	res.country.state
4430	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	598	f	state_in_mn	base	res.country.state
4431	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	599	f	state_in_ml	base	res.country.state
4432	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	600	f	state_in_mz	base	res.country.state
4433	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	601	f	state_in_nl	base	res.country.state
4434	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	602	f	state_in_or	base	res.country.state
4435	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	603	f	state_in_py	base	res.country.state
4436	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	604	f	state_in_pb	base	res.country.state
4437	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	605	f	state_in_rj	base	res.country.state
4438	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	606	f	state_in_sk	base	res.country.state
4439	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	607	f	state_in_tn	base	res.country.state
4440	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	608	f	state_in_ts	base	res.country.state
4441	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	609	f	state_in_tr	base	res.country.state
4442	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	610	f	state_in_up	base	res.country.state
4443	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	611	f	state_in_uk	base	res.country.state
4444	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	612	f	state_in_wb	base	res.country.state
4445	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	613	f	state_id_ac	base	res.country.state
4446	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	614	f	state_id_ba	base	res.country.state
4447	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	615	f	state_id_bb	base	res.country.state
4448	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	616	f	state_id_bt	base	res.country.state
4449	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	617	f	state_id_be	base	res.country.state
4450	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	618	f	state_id_go	base	res.country.state
4451	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	619	f	state_id_jk	base	res.country.state
4452	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	620	f	state_id_ja	base	res.country.state
4453	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	621	f	state_id_jb	base	res.country.state
4454	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	622	f	state_id_jt	base	res.country.state
4455	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	623	f	state_id_ji	base	res.country.state
4456	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	624	f	state_id_kb	base	res.country.state
4457	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	625	f	state_id_ks	base	res.country.state
4458	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	626	f	state_id_kt	base	res.country.state
4459	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	627	f	state_id_ki	base	res.country.state
4460	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	628	f	state_id_ku	base	res.country.state
4461	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	629	f	state_id_kr	base	res.country.state
4462	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	630	f	state_id_la	base	res.country.state
4463	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	631	f	state_id_ma	base	res.country.state
4464	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	632	f	state_id_mu	base	res.country.state
4465	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	633	f	state_id_nb	base	res.country.state
4466	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	634	f	state_id_nt	base	res.country.state
4467	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	635	f	state_id_pa	base	res.country.state
4468	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	636	f	state_id_pb	base	res.country.state
4469	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	637	f	state_id_pd	base	res.country.state
4470	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	638	f	state_id_ps	base	res.country.state
4471	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	639	f	state_id_pt	base	res.country.state
4472	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	640	f	state_id_pp	base	res.country.state
4473	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	641	f	state_id_ri	base	res.country.state
4474	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	642	f	state_id_sr	base	res.country.state
4475	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	643	f	state_id_sn	base	res.country.state
4476	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	644	f	state_id_st	base	res.country.state
4477	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	645	f	state_id_sg	base	res.country.state
4478	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	646	f	state_id_sa	base	res.country.state
4479	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	647	f	state_id_sb	base	res.country.state
4480	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	648	f	state_id_ss	base	res.country.state
4481	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	649	f	state_id_su	base	res.country.state
4482	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	650	f	state_id_yo	base	res.country.state
4483	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	651	f	state_co_01	base	res.country.state
4484	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	652	f	state_co_02	base	res.country.state
4485	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	653	f	state_co_03	base	res.country.state
4486	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	654	f	state_co_04	base	res.country.state
4487	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	655	f	state_co_05	base	res.country.state
4488	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	656	f	state_co_06	base	res.country.state
4489	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	657	f	state_co_07	base	res.country.state
4490	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	658	f	state_co_08	base	res.country.state
4491	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	659	f	state_co_09	base	res.country.state
4492	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	660	f	state_co_10	base	res.country.state
4493	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	661	f	state_co_11	base	res.country.state
4494	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	662	f	state_co_12	base	res.country.state
4495	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	663	f	state_co_13	base	res.country.state
4496	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	664	f	state_co_14	base	res.country.state
4497	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	665	f	state_co_15	base	res.country.state
4498	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	666	f	state_co_16	base	res.country.state
4499	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	667	f	state_co_17	base	res.country.state
4500	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	668	f	state_co_18	base	res.country.state
4501	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	669	f	state_co_19	base	res.country.state
4502	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	670	f	state_co_20	base	res.country.state
4503	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	671	f	state_co_21	base	res.country.state
4504	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	672	f	state_co_22	base	res.country.state
4505	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	673	f	state_co_23	base	res.country.state
4506	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	674	f	state_co_24	base	res.country.state
4507	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	675	f	state_co_25	base	res.country.state
4508	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	676	f	state_co_26	base	res.country.state
4509	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	677	f	state_co_27	base	res.country.state
4510	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	678	f	state_co_28	base	res.country.state
4511	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	679	f	state_co_29	base	res.country.state
4512	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	680	f	state_co_30	base	res.country.state
4513	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	681	f	state_co_31	base	res.country.state
4514	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	682	f	state_co_32	base	res.country.state
4515	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	683	f	state_co_33	base	res.country.state
4516	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	684	f	state_mn_01	base	res.country.state
4517	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	685	f	state_mn_02	base	res.country.state
4518	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	686	f	state_mn_03	base	res.country.state
4519	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	687	f	state_mn_04	base	res.country.state
4520	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	688	f	state_mn_05	base	res.country.state
4521	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	689	f	state_mn_06	base	res.country.state
4522	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	690	f	state_mn_07	base	res.country.state
4523	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	691	f	state_mn_08	base	res.country.state
4524	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	692	f	state_mn_09	base	res.country.state
4525	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	693	f	state_mn_10	base	res.country.state
4526	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	694	f	state_mn_11	base	res.country.state
4527	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	695	f	state_mn_12	base	res.country.state
4528	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	696	f	state_mn_13	base	res.country.state
4529	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	697	f	state_mn_14	base	res.country.state
4530	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	698	f	state_mn_15	base	res.country.state
4531	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	699	f	state_mn_16	base	res.country.state
4532	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	700	f	state_mn_17	base	res.country.state
4533	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	701	f	state_mn_18	base	res.country.state
4534	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	702	f	state_mn_19	base	res.country.state
4535	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	703	f	state_mn_20	base	res.country.state
4536	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	704	f	state_mn_23	base	res.country.state
4537	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	705	f	state_mn_24	base	res.country.state
4538	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	706	f	state_mn_25	base	res.country.state
4539	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	707	f	state_mn_26	base	res.country.state
4540	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	708	f	state_mn_27	base	res.country.state
4541	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	709	f	state_mn_28	base	res.country.state
4542	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	710	f	state_mn_29	base	res.country.state
4543	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	711	f	state_mn_32	base	res.country.state
4544	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	712	f	state_mn_34	base	res.country.state
4545	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	713	f	state_mn_35	base	res.country.state
4546	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	714	f	state_uk1	base	res.country.state
4547	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	715	f	state_uk2	base	res.country.state
4548	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	716	f	state_uk3	base	res.country.state
4549	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	717	f	state_uk4	base	res.country.state
4550	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	718	f	state_uk5	base	res.country.state
4551	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	719	f	state_uk6	base	res.country.state
4552	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	720	f	state_uk7	base	res.country.state
4553	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	721	f	state_uk8	base	res.country.state
4554	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	722	f	state_uk9	base	res.country.state
4555	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	723	f	state_uk10	base	res.country.state
4556	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	724	f	state_uk11	base	res.country.state
4557	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	725	f	state_uk12	base	res.country.state
4558	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	726	f	state_uk13	base	res.country.state
4559	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	727	f	state_uk14	base	res.country.state
4560	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	728	f	state_uk15	base	res.country.state
4561	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	729	f	state_uk16	base	res.country.state
4562	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	730	f	state_uk17	base	res.country.state
4563	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	731	f	state_uk18	base	res.country.state
4564	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	732	f	state_uk19	base	res.country.state
4565	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	733	f	state_uk20	base	res.country.state
4566	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	734	f	state_uk21	base	res.country.state
4567	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	735	f	state_uk22	base	res.country.state
4568	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	736	f	state_uk23	base	res.country.state
4569	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	737	f	state_uk24	base	res.country.state
4570	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	738	f	state_uk25	base	res.country.state
4571	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	739	f	state_uk26	base	res.country.state
4572	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	740	f	state_uk27	base	res.country.state
4573	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	741	f	state_uk28	base	res.country.state
4574	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	742	f	state_uk29	base	res.country.state
4575	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	743	f	state_uk30	base	res.country.state
4576	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	744	f	state_uk31	base	res.country.state
4577	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	745	f	state_uk32	base	res.country.state
4578	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	746	f	state_uk33	base	res.country.state
4579	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	747	f	state_uk34	base	res.country.state
4580	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	748	f	state_uk35	base	res.country.state
4581	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	749	f	state_uk36	base	res.country.state
4582	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	750	f	state_uk37	base	res.country.state
4583	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	751	f	state_uk38	base	res.country.state
4584	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	752	f	state_uk39	base	res.country.state
4585	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	753	f	state_uk40	base	res.country.state
4586	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	754	f	state_uk41	base	res.country.state
4587	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	755	f	state_uk42	base	res.country.state
4588	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	756	f	state_uk43	base	res.country.state
4589	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	757	f	state_uk44	base	res.country.state
4590	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	758	f	state_uk45	base	res.country.state
4591	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	759	f	state_uk46	base	res.country.state
4592	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	760	f	state_uk47	base	res.country.state
4593	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	761	f	state_uk48	base	res.country.state
4594	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	762	f	state_uk49	base	res.country.state
4595	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	763	f	state_uk50	base	res.country.state
4596	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	764	f	state_uk51	base	res.country.state
4597	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	765	f	state_uk52	base	res.country.state
4598	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	766	f	state_uk53	base	res.country.state
4599	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	767	f	state_uk54	base	res.country.state
4600	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	768	f	state_uk55	base	res.country.state
4601	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	769	f	state_uk56	base	res.country.state
4602	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	770	f	state_uk57	base	res.country.state
4603	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	771	f	state_uk58	base	res.country.state
4604	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	772	f	state_uk59	base	res.country.state
4605	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	773	f	state_uk60	base	res.country.state
4606	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	774	f	state_uk61	base	res.country.state
4607	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	775	f	state_uk62	base	res.country.state
4608	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	776	f	state_uk63	base	res.country.state
4609	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	777	f	state_uk64	base	res.country.state
4610	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	778	f	state_uk65	base	res.country.state
4611	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	779	f	state_uk66	base	res.country.state
4612	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	780	f	state_uk67	base	res.country.state
4613	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	781	f	state_uk68	base	res.country.state
4614	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	782	f	state_uk69	base	res.country.state
4615	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	783	f	state_uk70	base	res.country.state
4616	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	784	f	state_uk71	base	res.country.state
4617	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	785	f	state_uk72	base	res.country.state
4618	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	786	f	state_uk73	base	res.country.state
4619	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	787	f	state_uk74	base	res.country.state
4620	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	788	f	state_uk75	base	res.country.state
4621	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	789	f	state_uk76	base	res.country.state
4622	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	790	f	state_uk77	base	res.country.state
4623	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	791	f	state_uk78	base	res.country.state
4624	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	792	f	state_uk79	base	res.country.state
4625	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	793	f	state_uk80	base	res.country.state
4626	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	794	f	state_uk81	base	res.country.state
4627	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	795	f	state_uk82	base	res.country.state
4628	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	796	f	state_uk83	base	res.country.state
4629	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	797	f	state_uk84	base	res.country.state
4630	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	798	f	state_uk85	base	res.country.state
4631	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	799	f	state_uk86	base	res.country.state
4632	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	800	f	state_uk87	base	res.country.state
4633	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	801	f	state_uk88	base	res.country.state
4634	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	802	f	state_uk89	base	res.country.state
4635	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	803	f	state_uk90	base	res.country.state
4636	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	804	f	state_uk91	base	res.country.state
4637	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	805	f	state_uk92	base	res.country.state
4638	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	806	f	state_uk93	base	res.country.state
4639	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	807	f	state_uk94	base	res.country.state
4640	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	808	f	state_uk95	base	res.country.state
4641	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	809	f	state_uk96	base	res.country.state
4642	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	810	f	state_uk97	base	res.country.state
4643	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	811	f	state_uk98	base	res.country.state
4644	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	812	f	state_uk99	base	res.country.state
4645	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	813	f	state_uk100	base	res.country.state
4646	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	814	f	state_uk101	base	res.country.state
4647	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	815	f	state_uk102	base	res.country.state
4648	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	816	f	state_uk103	base	res.country.state
4649	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	817	f	state_uk104	base	res.country.state
4650	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	818	f	state_uk105	base	res.country.state
4651	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	819	f	state_uk106	base	res.country.state
4652	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	820	f	state_uk107	base	res.country.state
4653	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	821	f	state_uk108	base	res.country.state
4654	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	822	f	state_uk109	base	res.country.state
4655	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	823	f	state_uk110	base	res.country.state
4656	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	824	f	state_uk111	base	res.country.state
4657	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	825	f	state_uk112	base	res.country.state
4658	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	826	f	state_uk113	base	res.country.state
4659	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	827	f	state_uk114	base	res.country.state
4660	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	828	f	state_uk115	base	res.country.state
4661	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	829	f	state_uk116	base	res.country.state
4662	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	830	f	state_uk117	base	res.country.state
4663	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	831	f	state_uk118	base	res.country.state
4664	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	832	f	state_uk119	base	res.country.state
4665	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	833	f	RO_AB	base	res.country.state
4666	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	834	f	RO_AG	base	res.country.state
4667	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	835	f	RO_AR	base	res.country.state
4668	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	836	f	RO_B	base	res.country.state
4669	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	837	f	RO_BC	base	res.country.state
4670	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	838	f	RO_BH	base	res.country.state
4671	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	839	f	RO_BN	base	res.country.state
4672	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	840	f	RO_BR	base	res.country.state
4673	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	841	f	RO_BT	base	res.country.state
4674	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	842	f	RO_BV	base	res.country.state
4675	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	843	f	RO_BZ	base	res.country.state
4676	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	844	f	RO_CJ	base	res.country.state
4677	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	845	f	RO_CL	base	res.country.state
4678	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	846	f	RO_CS	base	res.country.state
4679	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	847	f	RO_CT	base	res.country.state
4680	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	848	f	RO_CV	base	res.country.state
4681	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	849	f	RO_DB	base	res.country.state
4682	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	850	f	RO_DJ	base	res.country.state
4683	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	851	f	RO_GJ	base	res.country.state
4684	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	852	f	RO_GL	base	res.country.state
4685	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	853	f	RO_GR	base	res.country.state
4686	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	854	f	RO_HD	base	res.country.state
4687	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	855	f	RO_HR	base	res.country.state
4688	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	856	f	RO_IF	base	res.country.state
4689	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	857	f	RO_IL	base	res.country.state
4690	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	858	f	RO_IS	base	res.country.state
4691	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	859	f	RO_MH	base	res.country.state
4692	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	860	f	RO_MM	base	res.country.state
4693	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	861	f	RO_MS	base	res.country.state
4694	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	862	f	RO_NT	base	res.country.state
4695	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	863	f	RO_OT	base	res.country.state
4696	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	864	f	RO_PH	base	res.country.state
4697	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	865	f	RO_SB	base	res.country.state
4698	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	866	f	RO_SJ	base	res.country.state
4699	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	867	f	RO_SM	base	res.country.state
4700	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	868	f	RO_SV	base	res.country.state
4701	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	869	f	RO_TL	base	res.country.state
4702	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	870	f	RO_TM	base	res.country.state
4703	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	871	f	RO_TR	base	res.country.state
4704	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	872	f	RO_VL	base	res.country.state
4705	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	873	f	RO_VN	base	res.country.state
4706	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	874	f	RO_VS	base	res.country.state
4707	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	875	f	state_cn_BJ	base	res.country.state
4708	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	876	f	state_cn_SH	base	res.country.state
4709	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	877	f	state_cn_ZJ	base	res.country.state
4710	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	878	f	state_cn_TJ	base	res.country.state
4711	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	879	f	state_cn_AH	base	res.country.state
4712	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	880	f	state_cn_FJ	base	res.country.state
4713	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	881	f	state_cn_CQ	base	res.country.state
4714	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	882	f	state_cn_JX	base	res.country.state
4715	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	883	f	state_cn_SD	base	res.country.state
4716	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	884	f	state_cn_HA	base	res.country.state
4717	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	885	f	state_cn_NM	base	res.country.state
4718	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	886	f	state_cn_HB	base	res.country.state
4719	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	887	f	state_cn_XJ	base	res.country.state
4720	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	888	f	state_cn_HN	base	res.country.state
4721	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	889	f	state_cn_NX	base	res.country.state
4722	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	890	f	state_cn_GD	base	res.country.state
4723	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	891	f	state_cn_XZ	base	res.country.state
4724	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	892	f	state_cn_HI	base	res.country.state
4725	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	893	f	state_cn_GX	base	res.country.state
4726	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	894	f	state_cn_SC	base	res.country.state
4727	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	895	f	state_cn_HE	base	res.country.state
4728	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	896	f	state_cn_GZ	base	res.country.state
4729	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	897	f	state_cn_SX	base	res.country.state
4730	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	898	f	state_cn_YN	base	res.country.state
4731	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	899	f	state_cn_LN	base	res.country.state
4732	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	900	f	state_cn_SN	base	res.country.state
4733	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	901	f	state_cn_JL	base	res.country.state
4734	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	902	f	state_cn_GS	base	res.country.state
4735	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	903	f	state_cn_HL	base	res.country.state
4736	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	904	f	state_cn_QH	base	res.country.state
4737	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	905	f	state_cn_JS	base	res.country.state
4738	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	906	f	state_cn_TW	base	res.country.state
4739	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	907	f	state_cn_HK	base	res.country.state
4740	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	908	f	state_cn_MO	base	res.country.state
4741	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	909	f	state_et_1	base	res.country.state
4742	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	910	f	state_et_2	base	res.country.state
4743	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	911	f	state_et_3	base	res.country.state
4744	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	912	f	state_et_4	base	res.country.state
4745	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	913	f	state_et_5	base	res.country.state
4746	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	914	f	state_et_6	base	res.country.state
4747	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	915	f	state_et_7	base	res.country.state
4748	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	916	f	state_et_8	base	res.country.state
4749	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	917	f	state_et_9	base	res.country.state
4750	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	918	f	state_et_10	base	res.country.state
4751	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	919	f	state_et_11	base	res.country.state
4752	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	920	f	state_ie_1	base	res.country.state
4753	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	921	f	state_ie_2	base	res.country.state
4754	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	922	f	state_ie_3	base	res.country.state
4755	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	923	f	state_ie_4	base	res.country.state
4756	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	924	f	state_ie_5	base	res.country.state
4757	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	925	f	state_ie_6	base	res.country.state
4758	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	926	f	state_ie_7	base	res.country.state
4759	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	927	f	state_ie_8	base	res.country.state
4760	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	928	f	state_ie_9	base	res.country.state
4761	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	929	f	state_ie_10	base	res.country.state
4762	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	930	f	state_ie_11	base	res.country.state
4763	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	931	f	state_ie_12	base	res.country.state
4764	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	932	f	state_ie_13	base	res.country.state
4765	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	933	f	state_ie_14	base	res.country.state
4766	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	934	f	state_ie_15	base	res.country.state
4767	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	935	f	state_ie_16	base	res.country.state
4768	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	936	f	state_ie_17	base	res.country.state
4769	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	937	f	state_ie_18	base	res.country.state
4770	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	938	f	state_ie_19	base	res.country.state
4771	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	939	f	state_ie_20	base	res.country.state
4772	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	940	f	state_ie_21	base	res.country.state
4773	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	941	f	state_ie_22	base	res.country.state
4774	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	942	f	state_ie_23	base	res.country.state
4775	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	943	f	state_ie_24	base	res.country.state
4776	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	944	f	state_ie_25	base	res.country.state
4777	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	945	f	state_ie_26	base	res.country.state
4778	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	946	f	state_ie_27	base	res.country.state
4779	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	947	f	state_ie_28	base	res.country.state
4780	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	948	f	state_ie_29	base	res.country.state
4781	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	949	f	state_ie_30	base	res.country.state
4782	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	950	f	state_ie_31	base	res.country.state
4783	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	951	f	state_ie_32	base	res.country.state
4784	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	952	f	state_nl_dr	base	res.country.state
4785	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	953	f	state_nl_fl	base	res.country.state
4786	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	954	f	state_nl_fr	base	res.country.state
4787	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	955	f	state_nl_ge	base	res.country.state
4788	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	956	f	state_nl_gr	base	res.country.state
4789	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	957	f	state_nl_li	base	res.country.state
4790	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	958	f	state_nl_nb	base	res.country.state
4791	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	959	f	state_nl_nh	base	res.country.state
4792	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	960	f	state_nl_ov	base	res.country.state
4793	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	961	f	state_nl_ut	base	res.country.state
4794	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	962	f	state_nl_ze	base	res.country.state
4795	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	963	f	state_nl_zh	base	res.country.state
4796	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	964	f	state_nl_bq1	base	res.country.state
4797	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	965	f	state_nl_bq2	base	res.country.state
4798	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	966	f	state_nl_bq3	base	res.country.state
4799	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	967	f	state_tr_01	base	res.country.state
4800	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	968	f	state_tr_02	base	res.country.state
4801	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	969	f	state_tr_03	base	res.country.state
4802	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	970	f	state_tr_04	base	res.country.state
4803	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	971	f	state_tr_05	base	res.country.state
4804	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	972	f	state_tr_06	base	res.country.state
4805	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	973	f	state_tr_07	base	res.country.state
4806	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	974	f	state_tr_08	base	res.country.state
4807	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	975	f	state_tr_09	base	res.country.state
4808	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	976	f	state_tr_10	base	res.country.state
4809	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	977	f	state_tr_11	base	res.country.state
4810	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	978	f	state_tr_12	base	res.country.state
4811	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	979	f	state_tr_13	base	res.country.state
4812	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	980	f	state_tr_14	base	res.country.state
4813	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	981	f	state_tr_15	base	res.country.state
4814	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	982	f	state_tr_16	base	res.country.state
4815	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	983	f	state_tr_17	base	res.country.state
4816	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	984	f	state_tr_18	base	res.country.state
4817	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	985	f	state_tr_19	base	res.country.state
4818	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	986	f	state_tr_20	base	res.country.state
4819	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	987	f	state_tr_21	base	res.country.state
4820	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	988	f	state_tr_22	base	res.country.state
4821	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	989	f	state_tr_23	base	res.country.state
4822	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	990	f	state_tr_24	base	res.country.state
4823	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	991	f	state_tr_25	base	res.country.state
4824	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	992	f	state_tr_26	base	res.country.state
4825	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	993	f	state_tr_27	base	res.country.state
4826	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	994	f	state_tr_28	base	res.country.state
4827	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	995	f	state_tr_29	base	res.country.state
4828	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	996	f	state_tr_30	base	res.country.state
4829	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	997	f	state_tr_31	base	res.country.state
4830	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	998	f	state_tr_32	base	res.country.state
4831	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	999	f	state_tr_33	base	res.country.state
4832	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1000	f	state_tr_34	base	res.country.state
4833	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1001	f	state_tr_35	base	res.country.state
4834	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1002	f	state_tr_36	base	res.country.state
4835	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1003	f	state_tr_37	base	res.country.state
4836	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1004	f	state_tr_38	base	res.country.state
4837	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1005	f	state_tr_39	base	res.country.state
4838	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1006	f	state_tr_40	base	res.country.state
4839	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1007	f	state_tr_41	base	res.country.state
4840	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1008	f	state_tr_42	base	res.country.state
4841	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1009	f	state_tr_43	base	res.country.state
4842	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1010	f	state_tr_44	base	res.country.state
4843	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1011	f	state_tr_45	base	res.country.state
4844	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1012	f	state_tr_46	base	res.country.state
4845	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1013	f	state_tr_47	base	res.country.state
4846	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1014	f	state_tr_48	base	res.country.state
4847	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1015	f	state_tr_49	base	res.country.state
4848	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1016	f	state_tr_50	base	res.country.state
4849	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1017	f	state_tr_51	base	res.country.state
4850	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1018	f	state_tr_52	base	res.country.state
4851	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1019	f	state_tr_53	base	res.country.state
4852	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1020	f	state_tr_54	base	res.country.state
4853	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1021	f	state_tr_55	base	res.country.state
4854	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1022	f	state_tr_56	base	res.country.state
4855	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1023	f	state_tr_57	base	res.country.state
4856	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1024	f	state_tr_58	base	res.country.state
4857	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1025	f	state_tr_59	base	res.country.state
4858	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1026	f	state_tr_60	base	res.country.state
4859	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1027	f	state_tr_61	base	res.country.state
4860	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1028	f	state_tr_62	base	res.country.state
4861	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1029	f	state_tr_63	base	res.country.state
4862	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1030	f	state_tr_64	base	res.country.state
4863	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1031	f	state_tr_65	base	res.country.state
4864	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1032	f	state_tr_66	base	res.country.state
4865	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1033	f	state_tr_67	base	res.country.state
4866	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1034	f	state_tr_68	base	res.country.state
4867	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1035	f	state_tr_69	base	res.country.state
4868	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1036	f	state_tr_70	base	res.country.state
4869	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1037	f	state_tr_71	base	res.country.state
4870	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1038	f	state_tr_72	base	res.country.state
4871	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1039	f	state_tr_73	base	res.country.state
4872	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1040	f	state_tr_74	base	res.country.state
4873	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1041	f	state_tr_75	base	res.country.state
4874	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1042	f	state_tr_76	base	res.country.state
4875	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1043	f	state_tr_77	base	res.country.state
4876	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17:52.956888	\N	1044	f	state_tr_78	base	res.country.state
4877	\N	2025-11-06 17:17:52.956888	2025-11-06 17:17: