--
-- PostgreSQL database dump
--

-- Dumped from database version 16.9 (Ubuntu 16.9-1.pgdg20.04+1)
-- Dumped by pg_dump version 16.9 (Ubuntu 16.9-1.pgdg24.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    secret character varying NOT NULL,
    url character varying,
    qrcode bytea,
    code character varying(7),
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_cache_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    duration character varying,
    expiration timestamp without time zone,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    res_model character varying,
    file bytea,
    file_name character varying,
    file_type character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_tests_models_char; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char IS 'Tests : Base Import Model, Character';


--
-- Name: COLUMN base_import_tests_models_char.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_id_seq OWNED BY public.base_import_tests_models_char.id;


--
-- Name: base_import_tests_models_char_noreadonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_noreadonly (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_noreadonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_noreadonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_noreadonly IS 'Tests : Base Import Model, Character No readonly';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq OWNED BY public.base_import_tests_models_char_noreadonly.id;


--
-- Name: base_import_tests_models_char_readonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_readonly (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_readonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_readonly IS 'Tests : Base Import Model, Character readonly';


--
-- Name: COLUMN base_import_tests_models_char_readonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_readonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_readonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_readonly_id_seq OWNED BY public.base_import_tests_models_char_readonly.id;


--
-- Name: base_import_tests_models_char_required; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_required (
    id integer NOT NULL,
    value character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_required OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_required IS 'Tests : Base Import Model, Character required';


--
-- Name: COLUMN base_import_tests_models_char_required.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_required.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_required.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_required.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_required.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_required_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_required_id_seq OWNED BY public.base_import_tests_models_char_required.id;


--
-- Name: base_import_tests_models_char_states; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_states (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_states OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_states; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_states IS 'Tests : Base Import Model, Character states';


--
-- Name: COLUMN base_import_tests_models_char_states.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_states.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_states.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_states.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_states.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_states_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_states_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_states_id_seq OWNED BY public.base_import_tests_models_char_states.id;


--
-- Name: base_import_tests_models_char_stillreadonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_stillreadonly (
    id integer NOT NULL,
    value character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_stillreadonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_stillreadonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_stillreadonly IS 'Tests : Base Import Model, Character still readonly';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq OWNED BY public.base_import_tests_models_char_stillreadonly.id;


--
-- Name: base_import_tests_models_complex; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_complex (
    id integer NOT NULL,
    f double precision,
    m numeric,
    c character varying,
    currency_id integer,
    d date,
    dt timestamp without time zone,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_complex OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_complex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_complex IS 'Tests: Base Import Model Complex';


--
-- Name: COLUMN base_import_tests_models_complex.f; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.f IS 'F';


--
-- Name: COLUMN base_import_tests_models_complex.m; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.m IS 'M';


--
-- Name: COLUMN base_import_tests_models_complex.c; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.c IS 'C';


--
-- Name: COLUMN base_import_tests_models_complex.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_complex.d; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.d IS 'D';


--
-- Name: COLUMN base_import_tests_models_complex.dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.dt IS 'Dt';


--
-- Name: COLUMN base_import_tests_models_complex.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_complex.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_complex.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_complex.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_complex_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_complex_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_complex_id_seq OWNED BY public.base_import_tests_models_complex.id;


--
-- Name: base_import_tests_models_float; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_float (
    id integer NOT NULL,
    value double precision,
    value2 numeric,
    currency_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_float OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_float IS 'Tests: Base Import Model Float';


--
-- Name: COLUMN base_import_tests_models_float.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_float.value2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.value2 IS 'Value2';


--
-- Name: COLUMN base_import_tests_models_float.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_float.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_float.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_float.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_float.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_float_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_float_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_float_id_seq OWNED BY public.base_import_tests_models_float.id;


--
-- Name: base_import_tests_models_m2o; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o IS 'Tests : Base Import Model, Many to One';


--
-- Name: COLUMN base_import_tests_models_m2o.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_id_seq OWNED BY public.base_import_tests_models_m2o.id;


--
-- Name: base_import_tests_models_m2o_related; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_related OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_related IS 'Tests : Base Import Model, Many to One related';


--
-- Name: COLUMN base_import_tests_models_m2o_related.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_related_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_related_id_seq OWNED BY public.base_import_tests_models_m2o_related.id;


--
-- Name: base_import_tests_models_m2o_required; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_required (
    id integer NOT NULL,
    value integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_required OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required IS 'Tests : Base Import Model, Many to One required';


--
-- Name: COLUMN base_import_tests_models_m2o_required.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_required_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_id_seq OWNED BY public.base_import_tests_models_m2o_required.id;


--
-- Name: base_import_tests_models_m2o_required_related; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_required_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_required_related OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_required_related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required_related IS 'Tests : Base Import Model, Many to One required related';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq OWNED BY public.base_import_tests_models_m2o_required_related.id;


--
-- Name: base_import_tests_models_o2m; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_o2m (
    id integer NOT NULL,
    name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_o2m OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_o2m; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_o2m IS 'Tests : Base Import Model, One to Many';


--
-- Name: COLUMN base_import_tests_models_o2m.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_o2m.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_o2m_child (
    id integer NOT NULL,
    parent_id integer,
    value integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_o2m_child OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_o2m_child; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_o2m_child IS 'Tests : Base Import Model, One to Many child';


--
-- Name: COLUMN base_import_tests_models_o2m_child.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.parent_id IS 'Parent';


--
-- Name: COLUMN base_import_tests_models_o2m_child.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_o2m_child_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_o2m_child_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_o2m_child_id_seq OWNED BY public.base_import_tests_models_o2m_child.id;


--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_o2m_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_o2m_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_o2m_id_seq OWNED BY public.base_import_tests_models_o2m.id;


--
-- Name: base_import_tests_models_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_preview (
    id integer NOT NULL,
    name character varying,
    somevalue integer NOT NULL,
    othervalue integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_preview OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_preview IS 'Tests : Base Import Model Preview';


--
-- Name: COLUMN base_import_tests_models_preview.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_preview.somevalue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.somevalue IS 'Some Value';


--
-- Name: COLUMN base_import_tests_models_preview.othervalue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.othervalue IS 'Other Variable';


--
-- Name: COLUMN base_import_tests_models_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_preview_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_preview_id_seq OWNED BY public.base_import_tests_models_preview.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    data bytea,
    state character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying(6) NOT NULL,
    data bytea NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    lang character varying NOT NULL,
    overwrite boolean,
    state character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.lang IS 'Language';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.state IS 'Status';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    show_all boolean,
    module_id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    state character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    module_info text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    state character varying NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    exclude_contact boolean,
    exclude_journal_item boolean,
    maximum_group integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    aggr_ids character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: base_update_translations; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_update_translations (
    id integer NOT NULL,
    lang character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.base_update_translations OWNER TO runbot;

--
-- Name: TABLE base_update_translations; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_update_translations IS 'Update Translations';


--
-- Name: COLUMN base_update_translations.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_update_translations.lang IS 'Language';


--
-- Name: COLUMN base_update_translations.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_update_translations.create_uid IS 'Created by';


--
-- Name: COLUMN base_update_translations.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_update_translations.create_date IS 'Created on';


--
-- Name: COLUMN base_update_translations.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_update_translations.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_update_translations.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_update_translations.write_date IS 'Last Updated on';


--
-- Name: base_update_translations_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_update_translations_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_update_translations_id_seq OWNER TO runbot;

--
-- Name: base_update_translations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_update_translations_id_seq OWNED BY public.base_update_translations.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    user_login character varying,
    new_passwd character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    name character varying NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    name character varying NOT NULL,
    type character varying NOT NULL,
    help text,
    binding_model_id integer,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Name';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    multi boolean,
    paperformat_id integer,
    print_report_name character varying,
    attachment_use boolean,
    attachment character varying
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    usage character varying NOT NULL,
    state character varying NOT NULL,
    sequence integer,
    model_id integer NOT NULL,
    model_name character varying,
    code text,
    crud_model_id integer,
    link_field_id integer
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Action To Do';


--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Target Model';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    url text NOT NULL,
    target character varying NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_id integer,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    usage character varying,
    "limit" integer,
    search_view_id integer,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    view_mode character varying NOT NULL,
    act_window_id integer,
    multi boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    state character varying NOT NULL,
    name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    sequence integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    name character varying NOT NULL,
    description text,
    res_model character varying,
    res_field character varying,
    res_id integer,
    company_id integer,
    type character varying NOT NULL,
    url character varying(1024),
    public boolean,
    access_token character varying,
    db_datas bytea,
    store_fname character varying,
    file_size integer,
    checksum character varying(40),
    mimetype character varying,
    index_content text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    key character varying NOT NULL,
    value text NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    cron_name character varying,
    user_id integer NOT NULL,
    active boolean,
    interval_number integer,
    interval_type character varying,
    numbercall integer,
    doall boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    priority integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.numbercall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.numbercall IS 'Number of Calls';


--
-- Name: COLUMN ir_cron.doall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.doall IS 'Repeat Missed';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    call_at timestamp without time zone,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    condition character varying,
    json_value character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default.json_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.json_value IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    error character varying,
    wizard_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    name character varying,
    resource character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    name character varying,
    export_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer,
    domain text NOT NULL,
    context text NOT NULL,
    sort text NOT NULL,
    model_id character varying NOT NULL,
    is_default boolean,
    action_id integer,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    message text NOT NULL,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying NOT NULL,
    smtp_port integer NOT NULL,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    smtp_debug boolean,
    sequence integer,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Description';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'From Filter';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Security';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    name character varying NOT NULL,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    info text,
    state character varying,
    transient boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    model_id integer NOT NULL,
    group_id integer,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    name character varying NOT NULL,
    definition character varying,
    message character varying,
    model integer NOT NULL,
    module integer NOT NULL,
    type character varying(1) NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    create_uid integer,
    write_uid integer
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    res_id integer,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    relation_field_id integer,
    model_id integer NOT NULL,
    field_description character varying NOT NULL,
    help text,
    ttype character varying NOT NULL,
    copied boolean,
    related character varying,
    related_field_id integer,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    size integer,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    group_expand boolean,
    selectable boolean,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    compute text,
    depends character varying,
    store boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related field';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    value character varying NOT NULL,
    name character varying NOT NULL,
    sequence integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    name character varying NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    create_uid integer,
    write_uid integer
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name character varying NOT NULL,
    description text,
    sequence integer,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary character varying,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc character varying,
    category_id integer,
    description text,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    contributors text,
    published_version character varying,
    url character varying,
    menus_by_module text,
    reports_by_module text,
    views_by_module text
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    create_date timestamp without time zone,
    session character varying,
    name character varying,
    duration double precision,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    entry_count integer
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_property; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_property (
    id integer NOT NULL,
    name character varying,
    res_id character varying,
    company_id integer,
    fields_id integer NOT NULL,
    value_float double precision,
    value_integer integer,
    value_text text,
    value_binary bytea,
    value_reference character varying,
    value_datetime timestamp without time zone,
    type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_property OWNER TO runbot;

--
-- Name: TABLE ir_property; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_property IS 'Company Property';


--
-- Name: COLUMN ir_property.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.name IS 'Name';


--
-- Name: COLUMN ir_property.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.res_id IS 'Resource';


--
-- Name: COLUMN ir_property.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.company_id IS 'Company';


--
-- Name: COLUMN ir_property.fields_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.fields_id IS 'Field';


--
-- Name: COLUMN ir_property.value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_float IS 'Value Float';


--
-- Name: COLUMN ir_property.value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_integer IS 'Value Integer';


--
-- Name: COLUMN ir_property.value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_text IS 'Value Text';


--
-- Name: COLUMN ir_property.value_binary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_binary IS 'Value Binary';


--
-- Name: COLUMN ir_property.value_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_reference IS 'Value Reference';


--
-- Name: COLUMN ir_property.value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_datetime IS 'Value Datetime';


--
-- Name: COLUMN ir_property.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.type IS 'Type';


--
-- Name: COLUMN ir_property.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_uid IS 'Created by';


--
-- Name: COLUMN ir_property.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_date IS 'Created on';


--
-- Name: COLUMN ir_property.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_property.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_date IS 'Last Updated on';


--
-- Name: ir_property_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_property_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_property_id_seq OWNER TO runbot;

--
-- Name: ir_property_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_property_id_seq OWNED BY public.ir_property.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    name character varying,
    active boolean,
    model_id integer NOT NULL,
    domain_force text,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    global boolean,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Apply for Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Apply for Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Apply for Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Apply for Delete';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    active boolean,
    prefix character varying,
    suffix character varying,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    use_date_range boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_server_object_lines; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_server_object_lines (
    id integer NOT NULL,
    server_id integer,
    col1 integer NOT NULL,
    value text NOT NULL,
    evaluation_type character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_server_object_lines OWNER TO runbot;

--
-- Name: TABLE ir_server_object_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_server_object_lines IS 'Server Action value mapping';


--
-- Name: COLUMN ir_server_object_lines.server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.server_id IS 'Related Server Action';


--
-- Name: COLUMN ir_server_object_lines.col1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.col1 IS 'Field';


--
-- Name: COLUMN ir_server_object_lines.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.value IS 'Value';


--
-- Name: COLUMN ir_server_object_lines.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.evaluation_type IS 'Evaluation Type';


--
-- Name: COLUMN ir_server_object_lines.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.create_uid IS 'Created by';


--
-- Name: COLUMN ir_server_object_lines.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.create_date IS 'Created on';


--
-- Name: COLUMN ir_server_object_lines.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_server_object_lines.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.write_date IS 'Last Updated on';


--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_server_object_lines_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_server_object_lines_id_seq OWNER TO runbot;

--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_server_object_lines_id_seq OWNED BY public.ir_server_object_lines.id;


--
-- Name: ir_translation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_translation (
    id integer NOT NULL,
    name character varying NOT NULL,
    res_id integer,
    lang character varying,
    type character varying,
    src text,
    value text,
    module character varying,
    state character varying,
    comments text
);


ALTER TABLE public.ir_translation OWNER TO runbot;

--
-- Name: TABLE ir_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_translation IS 'Translation';


--
-- Name: COLUMN ir_translation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.name IS 'Translated field';


--
-- Name: COLUMN ir_translation.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.res_id IS 'Record ID';


--
-- Name: COLUMN ir_translation.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.lang IS 'Language';


--
-- Name: COLUMN ir_translation.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.type IS 'Type';


--
-- Name: COLUMN ir_translation.src; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.src IS 'Internal Source';


--
-- Name: COLUMN ir_translation.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.value IS 'Translation Value';


--
-- Name: COLUMN ir_translation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.module IS 'Module';


--
-- Name: COLUMN ir_translation.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.state IS 'Status';


--
-- Name: COLUMN ir_translation.comments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_translation.comments IS 'Translation comments';


--
-- Name: ir_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_translation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_translation_id_seq OWNER TO runbot;

--
-- Name: ir_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_translation_id_seq OWNED BY public.ir_translation.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    name character varying NOT NULL,
    active boolean,
    sequence integer,
    parent_id integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    priority integer NOT NULL,
    type character varying,
    arch_db text,
    arch_fs character varying,
    arch_updated boolean,
    arch_prev text,
    inherit_id integer,
    field_parent character varying,
    mode character varying NOT NULL,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.field_parent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.field_parent IS 'Child Field';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    arch text NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: rel_server_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_server_actions (
    server_id integer NOT NULL,
    action_id integer NOT NULL
);


ALTER TABLE public.rel_server_actions OWNER TO runbot;

--
-- Name: TABLE rel_server_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_server_actions IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    image character varying,
    pdf character varying,
    sequence integer,
    name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    name character varying NOT NULL,
    "default" boolean,
    format character varying,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision,
    page_height integer,
    page_width integer,
    orientation character varying,
    header_line boolean,
    header_spacing integer,
    disable_shrinking boolean,
    dpi integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format ?';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    state integer,
    country integer,
    email character varying,
    phone character varying,
    active boolean,
    bic character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_id integer,
    report_header text,
    report_footer text,
    company_details text,
    logo_web bytea,
    email character varying,
    phone character varying,
    mobile character varying,
    company_registry character varying,
    paperformat_id integer,
    external_report_layout_id integer,
    base_onboarding_company_state character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    create_uid integer,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.mobile IS 'Mobile';


--
-- Name: COLUMN res_company.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_registry IS 'Company Registry';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.base_onboarding_company_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.base_onboarding_company_state IS 'State of the onboarding company step';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_installer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_installer (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config_installer OWNER TO runbot;

--
-- Name: TABLE res_config_installer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_installer IS 'Config Installer';


--
-- Name: COLUMN res_config_installer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_installer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.create_date IS 'Created on';


--
-- Name: COLUMN res_config_installer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_installer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.write_date IS 'Last Updated on';


--
-- Name: res_config_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_installer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_installer_id_seq OWNER TO runbot;

--
-- Name: res_config_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_installer_id_seq OWNED BY public.res_config_installer.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying(2),
    address_format text,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    name_position character varying,
    vat_label character varying,
    state_required boolean,
    zip_required boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    name character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    full_name character varying,
    rounding numeric,
    decimal_places integer,
    active boolean,
    "position" character varying,
    currency_unit_label character varying,
    currency_subunit_label character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    name date NOT NULL,
    rate numeric,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name character varying NOT NULL,
    comment text,
    category_id integer,
    color integer,
    share boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.category_id IS 'Application';


--
-- Name: COLUMN res_groups.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.color IS 'Color Index';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    active boolean,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    name character varying,
    company_id integer,
    create_date timestamp without time zone,
    display_name character varying,
    date date,
    title integer,
    parent_id integer,
    ref character varying,
    lang character varying,
    tz character varying,
    user_id integer,
    vat character varying,
    website character varying,
    comment text,
    credit_limit double precision,
    active boolean,
    employee boolean,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    state_id integer,
    country_id integer,
    partner_latitude numeric,
    partner_longitude numeric,
    email character varying,
    phone character varying,
    mobile character varying,
    is_company boolean,
    industry_id integer,
    color integer,
    partner_share boolean,
    commercial_partner_id integer,
    commercial_company_name character varying,
    company_name character varying,
    create_uid integer,
    write_uid integer,
    write_date timestamp without time zone,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.display_name IS 'Display Name';


--
-- Name: COLUMN res_partner.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.date IS 'Date';


--
-- Name: COLUMN res_partner.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.title IS 'Title';


--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.credit_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.credit_limit IS 'Credit Limit';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.mobile IS 'Mobile';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    active boolean,
    acc_number character varying NOT NULL,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    name character varying NOT NULL,
    color integer,
    parent_id integer,
    active boolean,
    parent_path character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Tag Name';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    name character varying,
    full_name character varying,
    active boolean,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_partner_title; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_title (
    id integer NOT NULL,
    name character varying NOT NULL,
    shortcut character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_title OWNER TO runbot;

--
-- Name: TABLE res_partner_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_title IS 'Partner Title';


--
-- Name: COLUMN res_partner_title.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.name IS 'Title';


--
-- Name: COLUMN res_partner_title.shortcut; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.shortcut IS 'Abbreviation';


--
-- Name: COLUMN res_partner_title.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_title.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_title.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_title.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_date IS 'Last Updated on';


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_title_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_title_id_seq OWNER TO runbot;

--
-- Name: res_partner_title_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_title_id_seq OWNED BY public.res_partner_title.id;


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    active boolean DEFAULT true,
    login character varying NOT NULL,
    password character varying,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_date timestamp without time zone,
    signature text,
    action_id integer,
    share boolean,
    create_uid integer,
    write_uid integer,
    write_date timestamp without time zone,
    totp_secret character varying
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    name character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'res.users.apikeys.description';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    request character varying,
    password character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.password IS 'Password';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    reset_mode character varying NOT NULL,
    compare_view_id integer,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: web_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test (
    id integer NOT NULL,
    "char" character varying,
    "integer" integer,
    "float" double precision,
    "numeric" numeric,
    many2one integer,
    "binary" bytea,
    date date,
    datetime timestamp without time zone,
    selection_str character varying,
    html text,
    text text,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.web_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test IS 'Web Editor Converter Test';


--
-- Name: COLUMN web_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN web_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN web_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN web_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN web_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN web_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."binary" IS 'Binary';


--
-- Name: COLUMN web_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN web_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN web_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN web_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN web_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN web_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNED BY public.web_editor_converter_test.id;


--
-- Name: web_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test_sub (
    id integer NOT NULL,
    name character varying,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.web_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test_sub IS 'Web Editor Converter Subtest';


--
-- Name: COLUMN web_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN web_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNED BY public.web_editor_converter_test_sub.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Tour name';


--
-- Name: COLUMN web_tour_tour.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.user_id IS 'Consumed by';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    name character varying NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_uid integer,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_tests_models_char id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_noreadonly id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_noreadonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_noreadonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_readonly id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_readonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_readonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_required id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_required ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_required_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_states id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_states ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_states_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_stillreadonly id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_stillreadonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_stillreadonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_complex id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_complex ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_complex_id_seq'::regclass);


--
-- Name: base_import_tests_models_float id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_float ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_float_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_related id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_related ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_related_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_required id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_required ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_required_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_required_related id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_required_related ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_required_related_id_seq'::regclass);


--
-- Name: base_import_tests_models_o2m id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_o2m ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_o2m_id_seq'::regclass);


--
-- Name: base_import_tests_models_o2m_child id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_o2m_child ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_o2m_child_id_seq'::regclass);


--
-- Name: base_import_tests_models_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_preview ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_preview_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: base_update_translations id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_update_translations ALTER COLUMN id SET DEFAULT nextval('public.base_update_translations_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_property id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_property ALTER COLUMN id SET DEFAULT nextval('public.ir_property_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_server_object_lines id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_server_object_lines ALTER COLUMN id SET DEFAULT nextval('public.ir_server_object_lines_id_seq'::regclass);


--
-- Name: ir_translation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_translation ALTER COLUMN id SET DEFAULT nextval('public.ir_translation_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_installer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_installer ALTER COLUMN id SET DEFAULT nextval('public.res_config_installer_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_partner_title id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_title ALTER COLUMN id SET DEFAULT nextval('public.res_partner_title_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: web_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_id_seq'::regclass);


--
-- Name: web_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_device (id, name, user_id, scope, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_wizard (id, user_id, secret, url, qrcode, code, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_enable_profiling_wizard (id, duration, expiration, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_import (id, res_model, file, file_name, file_type, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_mapping (id, res_model, column_name, field_name, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char (id, value, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_noreadonly; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_noreadonly (id, value, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_readonly; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_readonly (id, value, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_required; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_required (id, value, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_states; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_states (id, value, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_stillreadonly; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_stillreadonly (id, value, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_complex; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_complex (id, f, m, c, currency_id, d, dt, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_float; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_float (id, value, value2, currency_id, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o (id, value, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o_related; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o_related (id, value, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o_required; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o_required (id, value, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o_required_related; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o_required_related (id, value, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_o2m; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_o2m (id, name, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_o2m_child; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_o2m_child (id, parent_id, value, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_preview; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_preview (id, name, somevalue, othervalue, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_export (id, name, lang, format, data, state, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_import (id, name, code, data, filename, overwrite, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_install (id, lang, overwrite, state, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall (id, show_all, module_id, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_update (id, updated, added, state, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_upgrade (id, module_info, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard (id, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, state, number_group, current_line_id, dst_partner_id, exclude_contact, exclude_journal_item, maximum_group, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, aggr_ids, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: base_update_translations; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_update_translations (id, lang, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_user; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_user (id, wizard_id, user_id, user_login, new_passwd, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_wizard (id, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: decimal_precision; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.decimal_precision (id, name, digits, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: ir_act_client; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_client (id, name, type, help, binding_model_id, binding_type, binding_view_types, create_uid, create_date, write_uid, write_date, tag, target, res_model, context, params_store) FROM stdin;
2	Open Settings Menu	ir.actions.client	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	reload	current	\N	{}	\\x7b276d656e755f6964273a20347d
40	App Store	ir.actions.client	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	apps	current	\N	{}	\N
41	Updates	ir.actions.client	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	apps.updates	current	\N	{}	\\x7b7d
\.


--
-- Data for Name: ir_act_report_xml; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_report_xml (id, name, type, help, binding_model_id, binding_type, binding_view_types, create_uid, create_date, write_uid, write_date, model, report_type, report_name, report_file, multi, paperformat_id, print_report_name, attachment_use, attachment) FROM stdin;
35	Model Overview	ir.actions.report	\N	3	report	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	ir.model	qweb-pdf	base.report_irmodeloverview	base.report_irmodeloverview	\N	\N	\N	\N	\N
42	Technical guide	ir.actions.report	\N	65	report	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	ir.module.module	qweb-pdf	base.report_irmodulereference	base.report_irmodulereference	\N	\N	\N	\N	\N
81	Preview Internal Report	ir.actions.report	\N	93	report	list,form	1	2026-01-22 02:33:50.902537	1	2026-01-22 02:33:50.902537	res.company	qweb-pdf	web.preview_internalreport	web.preview_internalreport	\N	\N	\N	\N	\N
82	Preview External Report	ir.actions.report	\N	93	report	list,form	1	2026-01-22 02:33:50.902537	1	2026-01-22 02:33:50.902537	res.company	qweb-pdf	web.preview_externalreport	web.preview_externalreport	\N	\N	\N	\N	\N
83	Report Layout Preview	ir.actions.report	\N	93	report	list,form	1	2026-01-22 02:33:50.902537	1	2026-01-22 02:33:50.902537	res.company	qweb-pdf	web.preview_layout_report	web.preview_layout_report	\N	\N	\N	\N	\N
\.


--
-- Data for Name: ir_act_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server (id, name, type, help, binding_model_id, binding_type, binding_view_types, create_uid, create_date, write_uid, write_date, usage, state, sequence, model_id, model_name, code, crud_model_id, link_field_id) FROM stdin;
10	Config: Run Remaining Action Todo	ir.actions.server	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	ir_actions_server	code	5	88	res.config	\nconfig = model.next() or {}\nif config.get('type') not in ('ir.actions.act_window_close',):\n    action = config\n	\N	\N
34	Base: Auto-vacuum internal data	ir.actions.server	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	ir_cron	code	5	38	ir.autovacuum	model._run_vacuum_cleaner()	\N	\N
52	Install Modules	ir.actions.server	\N	65	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	ir_actions_server	code	5	65	ir.module.module	records.button_immediate_install()	\N	\N
53	Failed to install demo data for some modules, demo disabled	ir.actions.server	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	ir_actions_server	code	5	70	ir.demo_failure.wizard	\nfailures = env['ir.demo_failure'].search([\n    ('wizard_id', '=', False),\n])\nrecord = model.create({\n    'failure_ids': [Command.set(failures.ids)],\n})\naction = {\n    'type': 'ir.actions.act_window',\n    'res_id': record.id,\n    'res_model': 'ir.demo_failure.wizard',\n    'target': 'new',\n    'views': [(env.ref('base.demo_failures_dialog').id, 'form')],\n}\n        	\N	\N
85	Disable two-factor authentication	ir.actions.server	\N	96	action	list,form	1	2026-01-22 02:33:55.752938	1	2026-01-22 02:33:55.752938	ir_actions_server	code	5	96	res.users	\n            action = records.action_totp_disable()\n        	\N	\N
\.


--
-- Data for Name: ir_act_server_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_group_rel (act_id, gid) FROM stdin;
85	2
\.


--
-- Data for Name: ir_act_url; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_url (id, name, type, help, binding_model_id, binding_type, binding_view_types, create_uid, create_date, write_uid, write_date, url, target) FROM stdin;
3	Home Menu	ir.actions.act_url	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	/web	self
38	Third-Party Apps	ir.actions.act_url	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	https://apps.odoo.com/apps/modules	new
39	Theme Store	ir.actions.act_url	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	https://apps.odoo.com/apps/themes	new
\.


--
-- Data for Name: ir_act_window; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window (id, name, type, help, binding_model_id, binding_type, binding_view_types, create_uid, create_date, write_uid, write_date, view_id, domain, context, res_id, res_model, target, view_mode, usage, "limit", search_view_id, filter) FROM stdin;
1	Load demo data	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	ir.demo	new	form	\N	80	\N	\N
4	Decimal Accuracy	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	decimal.precision	current	tree,form	\N	80	\N	\N
5	Actions	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	7	\N	{}	\N	ir.actions.actions	current	tree,form	\N	80	8	\N
6	Reports	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	10	\N	{}	\N	ir.actions.report	current	tree,form	\N	80	11	\N
7	Window Actions	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	ir.actions.act_window	current	tree,form	\N	80	14	\N
8	Server Actions	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	16	\N	{'key':'server_action'}	\N	ir.actions.server	current	tree,form	\N	80	17	\N
9	Configuration Wizards	ir.actions.act_window	<p>The configuration wizards are used to help you configure a new instance of Odoo. They are launched during the installation of new modules, but you can choose to restart some wizards manually from this menu.</p>	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	18	\N	{}	\N	ir.actions.todo	current	tree,form	\N	80	\N	\N
11	Assets	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	22	\N	{'search_default_active': 1}	\N	ir.asset	current	tree,form	\N	80	\N	\N
12	System Parameters	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	ir.config_parameter	current	tree,form	\N	80	\N	\N
13	Scheduled Actions	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	28	\N	{'search_default_all': 1}	\N	ir.cron	current	tree,form,calendar	\N	80	\N	\N
14	Scheduled Actions Triggers	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	ir.cron.trigger	current	tree,form	\N	80	\N	\N
15	User-defined Filters	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	ir.filters	current	tree,form	\N	80	\N	\N
16	Outgoing Mail Servers	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	38	\N	{}	\N	ir.mail_server	current	tree,form	\N	80	39	\N
17	Create Menu	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{'model_id': active_id}	\N	wizard.ir.model.menu.create	new	form	\N	80	\N	\N
18	Models	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	42	\N	{}	\N	ir.model	current	tree,form	\N	80	\N	\N
19	Fields	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	45	\N	{}	\N	ir.model.fields	current	tree,form	\N	80	\N	\N
20	Fields Selection	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	48	\N	{}	\N	ir.model.fields.selection	current	tree,form	\N	80	\N	\N
21	External Identifiers	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	51	\N	{}	\N	ir.model.data	current	tree,form	\N	80	\N	\N
22	Model Constraints	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	54	\N	{}	\N	ir.model.constraint	current	tree,form	\N	80	55	\N
23	ManyToMany Relations	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	57	\N	{}	\N	ir.model.relation	current	tree,form	\N	80	\N	\N
24	Access Rights	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	59	\N	{}	\N	ir.model.access	current	tree,form	\N	80	61	\N
25	Attachments	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                    Create a new document\n                </p>\n                <p>\n                    Also you will find here all the related documents and download it by clicking on any individual document.\n                </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	ir.attachment	current	tree,form	\N	80	64	\N
26	Record Rules	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	66	\N	{}	\N	ir.rule	current	tree,form	\N	80	67	\N
27	Sequences	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	69	\N	{'active_test': False}	\N	ir.sequence	current	tree,form	\N	80	\N	\N
28	Translated Terms	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	73	\N	{}	\N	ir.translation	current	tree,form	\N	80	\N	\N
29	Menu Items	ir.actions.act_window	<p>Manage and customize the items available and displayed in your Odoo system menu. You can delete an item by clicking on the box at the beginning of each line and then delete it through the button that appeared. Items can be assigned to specific groups in order to make them accessible to some users within the system.</p>	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	78	\N	{'ir.ui.menu.full_list':True}	\N	ir.ui.menu	current	tree,form	\N	80	79	\N
30	Views	ir.actions.act_window	<p>Views allows you to personalize each view of Odoo. You can add new fields, move fields, rename them or delete the ones that you do not need.</p>	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	81	\N	{'search_default_active': 1}	\N	ir.ui.view	current	tree,form	\N	80	\N	\N
31	Compare/Reset	ir.actions.act_window	\N	15	action	form,list	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	reset.view.arch.wizard	new	form	\N	80	\N	\N
32	Customized Views	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">Create a customized view</p><p>Customized views are used when users reorganize the content of their dashboard views (via web client)</p>	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	ir.ui.view.custom	current	tree,form	\N	80	\N	\N
33	User-defined Defaults	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	ir.default	current	tree,form	\N	80	89	\N
36	Logging	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	ir.logging	current	tree,form	\N	80	93	\N
37	Apps	ir.actions.act_window	<p class="o_view_nocontent_empty_folder">\n                No module found!\n              </p><p>\n                You should try other search criteria.\n              </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{'search_default_app':1}	\N	ir.module.module	current	kanban,tree,form	\N	80	98	\N
43	Module Update	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	base.module.update	new	form	\N	80	\N	\N
44	Add Language	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	base.language.install	new	form	\N	80	\N	\N
45	Import Translation	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	base.language.import	new	form	\N	80	\N	\N
46	Apply Schedule Upgrade	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	base.module.upgrade	new	form	\N	80	\N	\N
47	Module Upgrade Install	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	107	\N	{}	\N	base.module.upgrade	new	form	\N	80	\N	\N
48	Export Translation	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	base.language.export	new	form	\N	80	\N	\N
49	Generate Missing Terms	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	base.update.translations	new	form	\N	80	\N	\N
50	Deduplicate Contacts	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{'active_test': False}	\N	base.partner.merge.automatic.wizard	new	form	\N	80	\N	\N
51	Merge	ir.actions.act_window	\N	84	action	list	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	base.partner.merge.automatic.wizard	new	form	\N	80	\N	\N
54	Ir profile	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{'search_default_group_session': 1}	\N	ir.profile	current	tree,form	\N	80	\N	\N
55	Companies	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                Create a new company\n              </p><p>\n                Create and manage the companies that will be managed by Odoo from here. Shops or subsidiaries can be created and maintained from here.\n              </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	res.company	current	tree,kanban,form	\N	80	\N	\N
56	Languages	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{'active_test': False}	\N	res.lang	current	tree,form	\N	80	122	\N
57	Contact Titles	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                    Create a Title\n                </p><p>\n                    Manage Contact Titles as well as their abbreviations (e.g. "Mr.", "Mrs.", etc).\n                </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	[]	{}	\N	res.partner.title	current	tree,form	\N	80	\N	\N
58	Customers	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                Create a Contact in your address book\n              </p><p>\n                Odoo helps you track all activities related to your contacts.\n              </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{'res_partner_search_mode': 'customer'}	\N	res.partner	current	kanban,tree,form	\N	80	130	\N
59	Customers	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                Create a new customer in your address book\n              </p><p>\n                Odoo helps you easily track all activities related to a customer.\n              </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	[]	{'res_partner_search_mode': 'customer', 'default_is_company': True}	\N	res.partner	current	kanban,tree,form	\N	80	\N	t
60	Vendors	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                Create a new vendor in your address book\n              </p><p>\n                Odoo helps you easily track all activities related to a vendor.\n              </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	[]	{'res_partner_search_mode': 'supplier', 'default_is_company': True}	\N	res.partner	current	kanban,tree,form	\N	80	\N	t
61	Contact Tags	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                Create a Contact Tag\n              </p><p>\n                Assign tags to your contacts to organize, filter and track them.\n              </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	res.partner.category	current	tree,form	\N	80	134	\N
62	Industries	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                Create an Industry\n              </p><p>\n                Specify industries to classify your contacts and draw up reports.\n              </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	res.partner.industry	current	tree,form	\N	80	137	\N
63	Banks	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                Create a Bank\n              </p><p>\n                Banks are the financial institutions at which you and your contacts have their accounts.\n              </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	res.bank	current	tree,form	\N	80	140	\N
64	Bank Accounts	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                Create a Bank Account\n              </p><p>\n                From here you can manage all bank accounts linked to you and your contacts.\n              </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	res.partner.bank	current	tree,form	\N	80	\N	\N
65	Countries	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                    No Country Found!\n                </p><p>\n                    Manage the list of countries that can be set on your contacts.\n                </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	res.country	current	tree,form	\N	80	\N	\N
66	Country Group	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                    Create a Country Group\n                </p><p>\n                    Use groups to organize countries that are frequently selected together (e.g. "LATAM", "BeNeLux", "ASEAN").\n                </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	res.country.group	current	tree,form	\N	80	\N	\N
67	Fed. States	ir.actions.act_window	<p class="o_view_nocontent_smiling_face">\n                    Create a State\n                </p><p>\n                    Federal States belong to countries and are part of your contacts' addresses.\n                </p>\n            	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	148	\N	{}	\N	res.country.state	current	tree,form	\N	80	\N	\N
68	Show Currency Rates	ir.actions.act_window	\N	91	action	form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	152	[('currency_id','=', active_id)]	{'default_currency_id': active_id}	\N	res.currency.rate	current	tree,form	\N	80	\N	\N
69	Currencies	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{'active_test': False}	\N	res.currency	current	tree,kanban,form	\N	80	154	\N
70	Change Password	ir.actions.act_window	\N	96	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	change.password.wizard	new	form	\N	80	\N	\N
71	Groups	ir.actions.act_window	<p>A group is a set of functional areas that will be assigned to the user in order to give them access and rights to specific applications and tasks in the system. You can create custom groups or edit the ones existing by default in order to customize the view of the menu that users will be able to see. Whether they can have a read, write, create and delete access right can be managed from here.</p>	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{'search_default_no_share': 1}	\N	res.groups	current	tree,form	\N	80	\N	\N
72	Users	ir.actions.act_window	<p>Create and manage users that will connect to the system. Users can be deactivated should there be a period of time during which they will/should not connect to the system. You can assign them groups in order to give them specific access to the applications they need to use in the system.</p>	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	165	\N	{'search_default_no_share': 1}	\N	res.users	current	tree,kanban,form	\N	80	167	\N
73	API Key: description input wizard	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	res.users.apikeys.description	new	form	\N	80	\N	\N
74	Change My Preferences	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	res.users	new	form	\N	80	\N	\N
75	API Keys Listing	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	172	\N	{}	\N	res.users.apikeys	current	tree	\N	80	\N	\N
76	Company Properties	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	175	\N	{}	\N	ir.property	current	tree,form	\N	80	\N	\N
77	Settings	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	res.config.settings	inline	form	\N	80	\N	\N
78	Paper Format General Configuration	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	report.paperformat	current	tree,form	\N	80	\N	\N
79	Reports	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N	\N	{}	\N	ir.actions.report	current	tree,form	\N	80	\N	\N
80	Set your company data	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	183	\N	{}	\N	res.company	new	form	\N	80	\N	\N
84	Configure your document layout	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:50.902537	1	2026-01-22 02:33:50.902537	215	\N	{}	\N	base.document.layout	new	form	\N	80	\N	\N
86	Tours	ir.actions.act_window	\N	\N	action	list,form	1	2026-01-22 02:33:57.946096	1	2026-01-22 02:33:57.946096	233	\N	{}	\N	web_tour.tour	current	tree,form	\N	80	234	\N
\.


--
-- Data for Name: ir_act_window_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_group_rel (act_id, gid) FROM stdin;
75	3
\.


--
-- Data for Name: ir_act_window_view; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_view (id, sequence, view_id, view_mode, act_window_id, multi, create_uid, create_date, write_uid, write_date) FROM stdin;
1	1	12	tree	7	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
2	2	13	form	7	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
3	0	131	kanban	58	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
4	2	128	form	58	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
5	1	125	tree	58	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
6	1	131	kanban	59	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
7	2	125	tree	59	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
8	3	128	form	59	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
9	1	131	kanban	60	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
10	2	125	tree	60	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
11	3	128	form	60	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
12	10	165	tree	72	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
13	20	164	form	72	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
14	10	171	form	74	\N	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
\.


--
-- Data for Name: ir_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions (id, name, type, help, binding_model_id, binding_type, binding_view_types, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: ir_actions_todo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions_todo (id, action_id, sequence, state, name, create_uid, create_date, write_uid, write_date) FROM stdin;
1	2	100	done	Open Menu	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
2	53	1	done	Demo Failure Notification	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
\.


--
-- Data for Name: ir_asset; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_asset (id, name, bundle, directive, path, target, active, sequence, create_uid, create_date, write_uid, write_date) FROM stdin;
1	13 0 color system support primary variables SCSS	web._assets_primary_variables	append	web_editor/static/src/scss/13_0_color_system_support_primary_variables.scss	\N	f	16	1	2026-01-22 02:33:57.429843	1	2026-01-22 02:33:57.429843
\.


--
-- Data for Name: ir_attachment; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_attachment (id, name, description, res_model, res_field, res_id, company_id, type, url, public, access_token, db_datas, store_fname, file_size, checksum, mimetype, index_content, create_uid, create_date, write_uid, write_date, original_id) FROM stdin;
1	flag_image	\N	res.lang	flag_image	3	1	binary	\N	\N	\N	\N	23/23fe89f51c8121f053a697a3dd79106f25aeeb52	23980	23fe89f51c8121f053a697a3dd79106f25aeeb52	image/png	image	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N
2	image_1920	\N	res.partner	image_1920	1	1	binary	\N	\N	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	15310	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	image	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N
3	favicon	\N	res.company	favicon	1	1	binary	\N	\N	\N	\N	2f/2f7028932480cdcb927f83b0165d577669e620fa	1150	2f7028932480cdcb927f83b0165d577669e620fa	image/vnd.microsoft.icon	image	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N
4	image_1024	\N	res.partner	image_1024	1	1	binary	\N	\N	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	15310	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	image	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N
5	image_512	\N	res.partner	image_512	1	1	binary	\N	\N	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	15310	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	image	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N
6	image_256	\N	res.partner	image_256	1	1	binary	\N	\N	\N	\N	77/7712910ea66effcd74ee140f5d145fe30000aa57	12509	7712910ea66effcd74ee140f5d145fe30000aa57	image/png	image	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N
7	image_128	\N	res.partner	image_128	1	1	binary	\N	\N	\N	\N	e0/e0d4b5b2f41d6a523b47d17100558bf3084c67b1	5421	e0d4b5b2f41d6a523b47d17100558bf3084c67b1	image/png	image	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N
8	web_icon_data	\N	ir.ui.menu	web_icon_data	1	1	binary	\N	\N	\N	\N	ab/ab7e6730db0c9255c1a5c4373a2dec39f94058e5	9168	ab7e6730db0c9255c1a5c4373a2dec39f94058e5	image/png	image	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N
9	web_icon_data	\N	ir.ui.menu	web_icon_data	4	1	binary	\N	\N	\N	\N	b8/b8f9001425cfd0ef0315797909281b912817643a	9020	b8f9001425cfd0ef0315797909281b912817643a	image/png	image	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N
10	web_icon_data	\N	ir.ui.menu	web_icon_data	5	1	binary	\N	\N	\N	\N	a3/a330920abcef2433621d6bb985bc24828d77f77b	9180	a330920abcef2433621d6bb985bc24828d77f77b	image/png	image	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N
11	web_icon_data	\N	ir.ui.menu	web_icon_data	19	1	binary	\N	\N	\N	\N	9a/9a33710495b4a31fa3f92aaed82bde552ea34dd2	7139	9a33710495b4a31fa3f92aaed82bde552ea34dd2	image/png	image	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596	\N
12	res.company.scss	\N	\N	\N	\N	1	binary	/web/static/src/legacy/scss/asset_styles_company_report.scss	\N	\N	\N	f6/f6d02e80c92620f1fcc6b230c02d645dd3010917	566	f6d02e80c92620f1fcc6b230c02d645dd3010917	text/scss	.o_company_1_layout {\n                font-family: Lato;\n                &.o_report_layout_standard {\n                    h2 {\n                        color: black;\n                    }\n                    #informations strong {\n                        color: black;\n                    }\n                    #total strong{\n                        color: black;\n                    }\n                    table {\n                        thead {\n                            color: black;\n                        }\n                    }\n                }\n            }	1	2026-01-22 02:33:50.902537	1	2026-01-22 02:33:50.902537	\N
\.


--
-- Data for Name: ir_config_parameter; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_config_parameter (id, key, value, create_uid, create_date, write_uid, write_date) FROM stdin;
4	web.base.url	http://localhost:8069	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
5	base.login_cooldown_after	10	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
6	base.login_cooldown_duration	60	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
7	mail.catchall.alias	catchall	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
8	mail.bounce.alias	bounce	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
9	mail.default.from	notifications	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
10	base.template_portal_user_id	5	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
1	database.secret	f86c47ff-e877-4028-a0a4-a9418e1a55c7	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
2	database.uuid	c9760b0f-f73a-11f0-82f9-a731ae7c96c3	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
3	database.create_date	2026-01-22 02:33:50	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
\.


--
-- Data for Name: ir_cron; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron (id, ir_actions_server_id, cron_name, user_id, active, interval_number, interval_type, numbercall, doall, nextcall, lastcall, priority, create_uid, create_date, write_uid, write_date) FROM stdin;
1	34	Base: Auto-vacuum internal data	1	t	1	days	-1	\N	2026-01-22 02:33:49	\N	5	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
\.


--
-- Data for Name: ir_cron_trigger; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron_trigger (id, cron_id, call_at, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: ir_default; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_default (id, field_id, user_id, company_id, condition, json_value, create_uid, create_date, write_uid, write_date) FROM stdin;
1	914	\N	\N	\N	"en_US"	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
\.


--
-- Data for Name: ir_demo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo (id, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure (id, module_id, error, wizard_id, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure_wizard (id, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports (id, name, resource, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports_line (id, name, export_id, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: ir_filters; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_filters (id, name, user_id, domain, context, sort, model_id, is_default, action_id, active, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: ir_logging; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_logging (id, create_uid, create_date, write_uid, write_date, name, type, dbname, level, message, path, func, line) FROM stdin;
\.


--
-- Data for Name: ir_mail_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_mail_server (id, name, from_filter, smtp_host, smtp_port, smtp_authentication, smtp_user, smtp_pass, smtp_encryption, smtp_ssl_certificate, smtp_ssl_private_key, smtp_debug, sequence, active, create_uid, create_date, write_uid, write_date) FROM stdin;
\.


--
-- Data for Name: ir_model; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model (id, name, model, "order", info, state, transient, create_uid, create_date, write_uid, write_date) FROM stdin;
1	Base	base	id	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	base	f	\N	\N	\N	\N
2	Unknown	_unknown	id	\n    Abstract model used as a substitute for relational fields with an unknown\n    comodel.\n    	base	f	\N	\N	\N	\N
3	Models	ir.model	model	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
4	Fields	ir.model.fields	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
5	Fields Selection	ir.model.fields.selection	sequence, id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
6	Model Constraint	ir.model.constraint	id	\n    This model tracks PostgreSQL foreign keys and constraints used by Odoo\n    models.\n    	base	f	\N	\N	\N	\N
7	Relation Model	ir.model.relation	id	\n    This model tracks PostgreSQL tables used to implement Odoo many2many\n    relations.\n    	base	f	\N	\N	\N	\N
8	Model Access	ir.model.access	model_id,group_id,name,id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
9	Model Data	ir.model.data	module, model, name	Holds external identifier keys for records in the database.\n       This has two main uses:\n\n           * allows easy data integration with third-party systems,\n             making import/export/sync of data possible, as records\n             can be uniquely identified across multiple systems\n           * allows tracking the origin of data installed by Odoo\n             modules themselves, thus making it possible to later\n             update them seamlessly.\n    	base	f	\N	\N	\N	\N
10	Create Menu Wizard	wizard.ir.model.menu.create	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
11	Sequence	ir.sequence	name	 Sequence model.\n\n    The sequence model allows to define and use so-called sequence objects.\n    Such objects are used to generate unique identifiers in a transaction-safe\n    way.\n\n    	base	f	\N	\N	\N	\N
12	Sequence Date Range	ir.sequence.date_range	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
13	Menu	ir.ui.menu	sequence,id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
14	Custom View	ir.ui.view.custom	create_date desc	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
15	View	ir.ui.view	priority,name,id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
16	Reset View Architecture Wizard	reset.view.arch.wizard	id	 A wizard to compare and reset views architecture. 	base	t	\N	\N	\N	\N
17	Asset	ir.asset	sequence, id	This model contributes to two things:\n\n        1. It provides a function returning a list of all file paths declared\n        in a given list of addons (see _get_addon_paths);\n\n        2. It allows to create 'ir.asset' records to add additional directives\n        to certain bundles.\n    	base	f	\N	\N	\N	\N
18	Actions	ir.actions.actions	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
19	Action Window	ir.actions.act_window	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
20	Action Window View	ir.actions.act_window.view	sequence,id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
21	Action Window Close	ir.actions.act_window_close	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
22	Action URL	ir.actions.act_url	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
45	Qweb Field Date	ir.qweb.field.date	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
23	Server Actions	ir.actions.server	sequence,name	 Server actions model. Server action work on a base model and offer various\n    type of actions that can be executed automatically, for example using base\n    action rules, of manually, by adding the action in the 'More' contextual\n    menu.\n\n    Since Odoo 8.0 a button 'Create Menu Action' button is available on the\n    action form view. It creates an entry in the More menu of the base model.\n    This allows to create server actions and run them in mass mode easily through\n    the interface.\n\n    The available actions are :\n\n    - 'Execute Python Code': a block of python code that will be executed\n    - 'Create a new Record': create a new record with new values\n    - 'Write on a Record': update the values of a record\n    - 'Execute several actions': define an action that triggers several other\n      server actions\n    	base	f	\N	\N	\N	\N
24	Server Action value mapping	ir.server.object.lines	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
25	Configuration Wizards	ir.actions.todo	sequence, id	\n    Configuration Wizards\n    	base	f	\N	\N	\N	\N
26	Client Action	ir.actions.client	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
27	Report Action	ir.actions.report	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
28	Attachment	ir.attachment	id desc	Attachments are used to link binary files or url to any openerp document.\n\n    External attachment storage\n    ---------------------------\n\n    The computed field ``datas`` is implemented using ``_file_read``,\n    ``_file_write`` and ``_file_delete``, which can be overridden to implement\n    other storage engines. Such methods should check for other location pseudo\n    uri (example: hdfs://hadoopserver).\n\n    The default implementation is the file:dirname location that stores files\n    on the local filesystem using name based on their sha1 hash\n    	base	f	\N	\N	\N	\N
29	Scheduled Actions	ir.cron	cron_name	 Model describing cron jobs (also called actions or tasks).\n    	base	f	\N	\N	\N	\N
30	Triggered actions	ir.cron.trigger	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
31	Filters	ir.filters	model_id, name, id desc	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
32	Default Values	ir.default	id	 User-defined default values for fields. 	base	f	\N	\N	\N	\N
33	Translation	ir.translation	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
34	Exports	ir.exports	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
35	Exports Line	ir.exports.line	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
36	Record Rule	ir.rule	model_id DESC,id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
37	System Parameter	ir.config_parameter	key	Per-database storage of configuration key-value pairs.	base	f	\N	\N	\N	\N
38	Automatic Vacuum	ir.autovacuum	id	 Helper model to the ``@api.autovacuum`` method decorator. 	base	f	\N	\N	\N	\N
39	Mail Server	ir.mail_server	sequence	Represents an SMTP server, able to send outgoing emails, with SSL and TLS capabilities.	base	f	\N	\N	\N	\N
40	Fields Converter	ir.fields.converter	id	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	base	f	\N	\N	\N	\N
42	Qweb Field	ir.qweb.field	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
43	Qweb Field Integer	ir.qweb.field.integer	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
44	Qweb Field Float	ir.qweb.field.float	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
41	Qweb	ir.qweb	id	 QWeb object for rendering editor stuff\n    	base	f	\N	\N	\N	\N
46	Qweb Field Datetime	ir.qweb.field.datetime	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
47	Qweb Field Text	ir.qweb.field.text	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
48	Qweb Field Selection	ir.qweb.field.selection	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
49	Qweb Field Many to One	ir.qweb.field.many2one	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
50	Qweb field many2many	ir.qweb.field.many2many	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
51	Qweb Field HTML	ir.qweb.field.html	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
53	Qweb Field Image	ir.qweb.field.image_url	id	 ``image_url`` widget rendering, inserts an image tag in the\n    document.\n    	base	f	\N	\N	\N	\N
54	Qweb Field Monetary	ir.qweb.field.monetary	id	 ``monetary`` converter, has a mandatory option\n    ``display_currency`` only if field is not of type Monetary.\n    Otherwise, if we are in presence of a monetary field, the field definition must\n    have a currency_field attribute set.\n\n    The currency is used for formatting *and rounding* of the float value. It\n    is assumed that the linked res_currency has a non-empty rounding value and\n    res.currency's ``round`` method is used to perform rounding.\n\n    .. note:: the monetary converter internally adds the qweb context to its\n              options mapping, so that the context is available to callees.\n              It's set under the ``_values`` key.\n    	base	f	\N	\N	\N	\N
55	Qweb Field Float Time	ir.qweb.field.float_time	id	 ``float_time`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "01:30").\n\n    Can be used on any numerical field.\n    	base	f	\N	\N	\N	\N
56	Qweb Field Duration	ir.qweb.field.duration	id	 ``duration`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "1 hour 30 minutes").\n\n    Can be used on any numerical field.\n\n    Has an option ``unit`` which can be one of ``second``, ``minute``,\n    ``hour``, ``day``, ``week`` or ``year``, used to interpret the numerical\n    field value before converting it. By default use ``second``.\n\n    Has an option ``round``. By default use ``second``.\n\n    Has an option ``digital`` to display 01:00 instead of 1 hour\n\n    Sub-second values will be ignored.\n    	base	f	\N	\N	\N	\N
57	Qweb Field Relative	ir.qweb.field.relative	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
58	Qweb Field Barcode	ir.qweb.field.barcode	id	 ``barcode`` widget rendering, inserts a data:uri-using image tag in the\n    document. May be overridden by e.g. the website module to generate links\n    instead.\n    	base	f	\N	\N	\N	\N
59	Qweb Field Contact	ir.qweb.field.contact	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
60	Qweb Field qweb	ir.qweb.field.qweb	id	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	base	f	\N	\N	\N	\N
61	HTTP Routing	ir.http	id	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	base	f	\N	\N	\N	\N
62	Logging	ir.logging	id DESC	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
63	Company Property	ir.property	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
64	Application	ir.module.category	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
65	Module	ir.module.module	application desc,sequence,name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
66	Module dependency	ir.module.module.dependency	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
67	Module exclusion	ir.module.module.exclusion	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
68	Demo	ir.demo	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
69	Demo failure	ir.demo_failure	id	 Stores modules for which we could not install demo data\n    	base	t	\N	\N	\N	\N
70	Demo Failure wizard	ir.demo_failure.wizard	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
71	Report Layout	report.layout	sequence	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
72	Paper Format Config	report.paperformat	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
73	Profiling results	ir.profile	session desc, id desc	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
74	Enable profiling for some time	base.enable.profiling.wizard	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
75	Image Mixin	image.mixin	id	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	base	f	\N	\N	\N	\N
76	Avatar Mixin	avatar.mixin	id	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	base	f	\N	\N	\N	\N
77	Country	res.country	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
78	Country Group	res.country.group	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
79	Country state	res.country.state	code	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
80	Languages	res.lang	active desc,name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
81	Address Format	format.address.mixin	id	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	base	f	\N	\N	\N	\N
82	Partner Tags	res.partner.category	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
83	Partner Title	res.partner.title	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
84	Contact	res.partner	display_name ASC, id DESC	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
85	Industry	res.partner.industry	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
86	Bank	res.bank	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
87	Bank Accounts	res.partner.bank	sequence, id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
88	Config	res.config	id	 Base classes for new-style configuration items\n\n    Configuration items should inherit from this class, implement\n    the execute method (and optionally the cancel one) and have\n    their view inherit from the related res_config_view_base view.\n    	base	t	\N	\N	\N	\N
89	Config Installer	res.config.installer	id	 New-style configuration base specialized for addons selection\n    and installation.\n\n    Basic usage\n    -----------\n\n    Subclasses can simply define a number of boolean fields. The field names\n    should be the names of the addons to install (when selected). Upon action\n    execution, selected boolean fields (and those only) will be interpreted as\n    addons to install, and batch-installed.\n\n    Additional addons\n    -----------------\n\n    It is also possible to require the installation of an additional\n    addon set when a specific preset of addons has been marked for\n    installation (in the basic usage only, additionals can't depend on\n    one another).\n\n    These additionals are defined through the ``_install_if``\n    property. This property is a mapping of a collection of addons (by\n    name) to a collection of addons (by name) [#]_, and if all the *key*\n    addons are selected for installation, then the *value* ones will\n    be selected as well. For example::\n\n        _install_if = {\n            ('sale','crm'): ['sale_crm'],\n        }\n\n    This will install the ``sale_crm`` addon if and only if both the\n    ``sale`` and ``crm`` addons are selected for installation.\n\n    You can define as many additionals as you wish, and additionals\n    can overlap in key and value. For instance::\n\n        _install_if = {\n            ('sale','crm'): ['sale_crm'],\n            ('sale','project'): ['sale_service'],\n        }\n\n    will install both ``sale_crm`` and ``sale_service`` if all of\n    ``sale``, ``crm`` and ``project`` are selected for installation.\n\n    Hook methods\n    ------------\n\n    Subclasses might also need to express dependencies more complex\n    than that provided by additionals. In this case, it's possible to\n    define methods of the form ``_if_%(name)s`` where ``name`` is the\n    name of a boolean field. If the field is selected, then the\n    corresponding module will be marked for installation *and* the\n    hook method will be executed.\n\n    Hook methods take the usual set of parameters (cr, uid, ids,\n    context) and can return a collection of additional addons to\n    install (if they return anything, otherwise they should not return\n    anything, though returning any "falsy" value such as None or an\n    empty collection will have the same effect).\n\n    Complete control\n    ----------------\n\n    The last hook is to simply overload the ``modules_to_install``\n    method, which implements all the mechanisms above. This method\n    takes the usual set of parameters (cr, uid, ids, context) and\n    returns a ``set`` of addons to install (addons selected by the\n    above methods minus addons from the *basic* set which are already\n    installed) [#]_ so an overloader can simply manipulate the ``set``\n    returned by ``ResConfigInstaller.modules_to_install`` to add or\n    remove addons.\n\n    Skipping the installer\n    ----------------------\n\n    Unless it is removed from the view, installers have a *skip*\n    button which invokes ``action_skip`` (and the ``cancel`` hook from\n    ``res.config``). Hooks and additionals *are not run* when skipping\n    installation, even for already installed addons.\n\n    Again, setup your hooks accordingly.\n\n    .. [#] note that since a mapping key needs to be hashable, it's\n           possible to use a tuple or a frozenset, but not a list or a\n           regular set\n\n    .. [#] because the already-installed modules are only pruned at\n           the very end of ``modules_to_install``, additionals and\n           hooks depending on them *are guaranteed to execute*. Setup\n           your hooks accordingly.\n    	base	t	\N	\N	\N	\N
90	Config Settings	res.config.settings	id	 Base configuration wizard for application settings.  It provides support for setting\n        default values, assigning groups to employee users, and installing modules.\n        To make such a 'settings' wizard, define a model like::\n\n            class MyConfigWizard(models.TransientModel):\n                _name = 'my.settings'\n                _inherit = 'res.config.settings'\n\n                default_foo = fields.type(..., default_model='my.model'),\n                group_bar = fields.Boolean(..., group='base.group_user', implied_group='my.group'),\n                module_baz = fields.Boolean(...),\n                config_qux = fields.Char(..., config_parameter='my.parameter')\n                other_field = fields.type(...),\n\n        The method ``execute`` provides some support based on a naming convention:\n\n        *   For a field like 'default_XXX', ``execute`` sets the (global) default value of\n            the field 'XXX' in the model named by ``default_model`` to the field's value.\n\n        *   For a boolean field like 'group_XXX', ``execute`` adds/removes 'implied_group'\n            to/from the implied groups of 'group', depending on the field's value.\n            By default 'group' is the group Employee.  Groups are given by their xml id.\n            The attribute 'group' may contain several xml ids, separated by commas.\n\n        *   For a selection field like 'group_XXX' composed of 2 string values ('0' and '1'),\n            ``execute`` adds/removes 'implied_group' to/from the implied groups of 'group', \n            depending on the field's value.\n            By default 'group' is the group Employee.  Groups are given by their xml id.\n            The attribute 'group' may contain several xml ids, separated by commas.\n\n        *   For a boolean field like 'module_XXX', ``execute`` triggers the immediate\n            installation of the module named 'XXX' if the field has value ``True``.\n\n        *   For a selection field like 'module_XXX' composed of 2 string values ('0' and '1'), \n            ``execute`` triggers the immediate installation of the module named 'XXX' \n            if the field has the value ``'1'``.\n\n        *   For a field with no specific prefix BUT an attribute 'config_parameter',\n            ``execute``` will save its value in an ir.config.parameter (global setting for the\n            database).\n\n        *   For the other fields, the method ``execute`` invokes `set_values`.\n            Override it to implement the effect of those fields.\n\n        The method ``default_get`` retrieves values that reflect the current status of the\n        fields like 'default_XXX', 'group_XXX', 'module_XXX' and config_XXX.\n        It also invokes all methods with a name that starts with 'get_default_';\n        such methods can be defined to provide current values for other fields.\n    	base	t	\N	\N	\N	\N
91	Currency	res.currency	active desc, name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
92	Currency Rate	res.currency.rate	name desc	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
93	Companies	res.company	sequence, name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
94	Access Groups	res.groups	name	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
95	Users Log	res.users.log	id desc	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
96	Users	res.users	name, login	 User class. A res.users record models an OpenERP user and is different\n        from an employee.\n\n        res.users class now inherits from res.partner. The partner model is\n        used to store the data related to the partner: lang, name, address,\n        avatar, ... The user model is now dedicated to technical data.\n    	base	f	\N	\N	\N	\N
97	Password Check Wizard	res.users.identitycheck	id	 Wizard used to re-check the user's credentials (password)\n\n    Might be useful before the more security-sensitive operations, users might be\n    leaving their computer unlocked & unattended. Re-checking credentials mitigates\n    some of the risk of a third party using such an unattended device to manipulate\n    the account.\n    	base	t	\N	\N	\N	\N
98	Change Password Wizard	change.password.wizard	id	 A wizard to manage the change of users' passwords. 	base	t	\N	\N	\N	\N
99	User, Change Password Wizard	change.password.user	id	 A model to configure users in the change password wizard. 	base	t	\N	\N	\N	\N
100	res.users.apikeys	res.users.apikeys	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
137	Web Editor Converter Test	web_editor.converter.test	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
101	res.users.apikeys.description	res.users.apikeys.description	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
102	res.users.apikeys.show	res.users.apikeys.show	id	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	base	f	\N	\N	\N	\N
103	Decimal Precision	decimal.precision	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
104	Module Reference Report (base)	report.base.report_irmodulereference	id	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	base	f	\N	\N	\N	\N
105	Update Module	base.module.update	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
106	Install Language	base.language.install	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
107	Language Import	base.language.import	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
108	Upgrade Module	base.module.upgrade	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
109	Module Uninstall	base.module.uninstall	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
110	Language Export	base.language.export	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
111	Update Translations	base.update.translations	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
112	Merge Partner Line	base.partner.merge.line	min_id asc	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
113	Merge Partner Wizard	base.partner.merge.automatic.wizard	id	\n        The idea behind this wizard is to create a list of potential partners to\n        merge. We use two objects, the first one is the wizard for the end-user.\n        And the second will contain the partner list to merge.\n    	base	t	\N	\N	\N	\N
52	Qweb Field Image	ir.qweb.field.image	id	\n    Widget options:\n\n    ``class``\n        set as attribute on the generated <img> tag\n    	base	f	\N	\N	\N	\N
115	Company Document Layout	base.document.layout	id	\n    Customise the company document layout and display a live preview\n    	base	t	\N	\N	\N	\N
116	Authentication Device	auth_totp.device	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
117	2-Factor Setup Wizard	auth_totp.wizard	id	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	base	t	\N	\N	\N	\N
118	Base Import Mapping	base_import.mapping	id	 mapping of previous column:field selections\n\n    This is useful when repeatedly importing from a third-party\n    system: column names generated by the external system may\n    not match Odoo's field names or labels. This model is used\n    to save the mapping between column names and fields so that\n    next time a user imports from the same third-party systems\n    we can automatically match the columns to the correct field\n    without them having to re-enter the mapping every single\n    time.\n    	base	f	\N	\N	\N	\N
138	Web Editor Converter Subtest	web_editor.converter.test.sub	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
139	Tours	web_tour.tour	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
119	Base Import	base_import.import	id	\n    This model is used to prepare the loading of data coming from a user file.\n\n    Here is the process that is followed:\n\n    #. The user selects a file to import.\n    #. File parsing and mapping suggestion (see "parse_preview" method)\n\n       #. Extract the current model's importable fields tree (see :meth:`get_fields_tree`).\n       #. Read the file (see :meth:`_read_file`) and extract header names and file\n          length (used for batch import).\n       #. Extract headers types from the data preview (10 first line of the file)\n          (see :meth:`_extract_headers_types`).\n       #. Try to find for each header a field to map with (see :meth:`_get_mapping_suggestions`)\n\n          - First check the previously saved mappings between the header name\n            and one of the model's fields.\n          - If no mapping found, try an exact match comparison using fields\n            technical names, labels and user language translated labels.\n          - If nothing found, try a fuzzy match using word distance between\n            header name and fields tachnical names, labels and user language\n            translated labels. Keep only the closest match.\n\n       #. Prepare examples for each columns using the first non null value from each column.\n       #. Send the info back to the UI where the user can modify the suggested mapping.\n    #. Execute the import: There are two import mode with uses the same process. (see :meth:`execute_import`)\n\n       #. Test import: Try to import but rollback the transaction. This allows\n          the check errors during the import process and allow the user to\n          choose import options for the different encountered errors.\n       #. Real import: Try to import the file using the configured mapping and\n          the eventual "error mapping options". If import encounters blocking\n          errors, the transaction is rollbacked and the user is allowed to\n          choose import options for the different errors.\n\n          - Get file data and fields to import into (see :meth:`_convert_import_data`).\n          - Parse date, float and binary data (see :meth:`_parse_import_data`).\n          - Handle multiple mapping -> concatenate char/text/many2many columns\n            mapped on the same field (see :meth:`_handle_multi_mapping`).\n          - Handle fallback values for boolean and selection fields, in case\n            input data does not match any allowed values (see :meth:`_handle_fallback_values`).\n          - Load data (see ir.model "load" method).\n          - Rollback transaction if test mode or if encountered error.\n          - Save mapping if any import is successful to ease later mapping suggestions.\n          - Return import result to the UI (success or errors if any).\n    	base	t	\N	\N	\N	\N
120	Tests : Base Import Model, Character	base_import.tests.models.char	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
121	Tests : Base Import Model, Character required	base_import.tests.models.char.required	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
122	Tests : Base Import Model, Character readonly	base_import.tests.models.char.readonly	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
123	Tests : Base Import Model, Character states	base_import.tests.models.char.states	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
124	Tests : Base Import Model, Character No readonly	base_import.tests.models.char.noreadonly	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
125	Tests : Base Import Model, Character still readonly	base_import.tests.models.char.stillreadonly	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
126	Tests : Base Import Model, Many to One	base_import.tests.models.m2o	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
127	Tests : Base Import Model, Many to One related	base_import.tests.models.m2o.related	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
128	Tests : Base Import Model, Many to One required	base_import.tests.models.m2o.required	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
129	Tests : Base Import Model, Many to One required related	base_import.tests.models.m2o.required.related	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
130	Tests : Base Import Model, One to Many	base_import.tests.models.o2m	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
131	Tests : Base Import Model, One to Many child	base_import.tests.models.o2m.child	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
132	Tests : Base Import Model Preview	base_import.tests.models.preview	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
133	Tests: Base Import Model Float	base_import.tests.models.float	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
134	Tests: Base Import Model Complex	base_import.tests.models.complex	id	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	base	f	\N	\N	\N	\N
136	Assets Utils	web_editor.assets	id	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	base	f	\N	\N	\N	\N
\.


--
-- Data for Name: ir_model_access; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_access (id, name, active, model_id, group_id, perm_read, perm_write, perm_create, perm_unlink, create_uid, create_date, write_uid, write_date) FROM stdin;
1	decimal.precision configuration	t	103	3	t	t	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
2	ir_attachment group_user	t	28	1	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
3	ir_attachment group_portal_public	t	28	\N	f	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
4	ir_cron group_cron	t	29	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
5	ir_cron_trigger group_cron	t	30	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
6	ir_exports group_system	t	34	7	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
7	ir_exports_line group_system	t	35	1	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
8	ir_model group_erp_manager	t	3	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
9	ir_model_constraint group_erp_manager	t	6	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
10	ir_model_relation group_erp_manager	t	7	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
11	ir_model_access_group_erp_manager	t	8	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
12	ir_model_data group_erp_manager	t	9	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
13	ir_model_fields group_erp_manager	t	4	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
14	ir_model_fields_selection group_erp_manager	t	5	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
15	ir_model_all	t	3	1	f	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
16	ir_model_data user	t	9	1	f	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
17	ir_model_fields all	t	4	1	f	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
18	ir_model_fields_selection all	t	5	1	f	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
19	ir_module_category group_user	t	64	2	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
20	ir_module_module group_user	t	65	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
21	ir_module_module_dependency group_system	t	66	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
22	ir_module_module_exclusion group_system	t	67	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
23	ir_property group_user	t	63	\N	f	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
24	ir_property group_system	t	63	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
25	ir_rule group_erp_manager	t	36	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
26	ir_sequence group_user	t	11	1	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
27	ir_sequence group_system	t	11	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
28	ir_sequence_date_range group_user	t	12	1	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
29	ir_sequence_date_range group_system	t	12	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
30	ir_translation all	t	33	1	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
31	ir_translation group_system	t	33	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
32	ir_ui_menu group_user	t	13	1	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
33	ir_ui_menu group_system	t	13	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
34	ir_ui_view group_user	t	15	\N	f	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
35	ir_ui_view group_system	t	15	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
36	reset_view_arch_wizard group_system	t	16	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
37	ir_ui_view_custom_group_user	t	14	\N	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
38	ir_default all	t	32	\N	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
39	ir_default group_user	t	32	1	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
40	ir_default group_system	t	32	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
41	res_company group_erp_manager	t	93	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
42	res_company group_user	t	93	\N	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
43	res_country group_user_all	t	77	\N	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
44	res_country_state group_user_all	t	79	\N	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
45	res_country_group group_user_all	t	78	\N	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
46	res_country group_user	t	77	8	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
47	res_country_group_system	t	77	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
48	res_country_state group_user	t	79	8	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
49	res_country_group group_user	t	78	8	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
50	res_currency group_all	t	91	\N	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
51	res_currency_rate group_all	t	92	\N	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
52	res_currency group_system	t	91	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
53	res_currency_rate group_system	t	92	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
54	res_groups group_erp_manager	t	94	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
55	res_groups group_user	t	94	1	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
56	res_lang group_all	t	80	\N	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
57	res_lang group_user	t	80	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
58	res_partner group_public	t	84	10	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
59	res_partner group_portal	t	84	9	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
60	res_partner group_partner_manager	t	84	8	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
61	res_partner group_user	t	84	1	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
62	res_partner_bank group_user	t	87	1	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
63	res_partner_bank group_partner_manager	t	87	8	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
64	res_partner_category group_user	t	82	1	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
65	res_partner_category group_partner_manager	t	82	8	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
66	res_partner_industry group_user	t	85	1	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
67	res_partner_industry group_system	t	85	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
68	res_partner_title group_partner_manager	t	83	8	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
69	res_partner_title group_user	t	83	\N	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
70	res_users all	t	96	\N	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
71	res_users group_erp_manager	t	96	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
72	res_users_log_all	t	95	\N	t	f	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
73	id check employees	t	97	1	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
74	id check portal	t	97	9	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
75	API keys access employees	t	100	1	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
76	API keys access portal	t	100	9	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
77	API key wizard employees	t	101	1	t	f	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
78	API key wizard	t	101	9	t	f	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
79	API key result employees	t	102	1	t	f	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
80	ir_asset_group_system	t	17	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
81	ir_actions_group_system	t	18	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
82	ir_actions_act_window_system	t	19	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
83	ir_actions_act_window_close_group_system	t	21	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
84	ir_actions_report_group_system	t	27	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
85	ir_actions_todo group system	t	25	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
86	ir_actions_act_window_view_group_system	t	20	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
87	ir_actions_act_url_group_system	t	22	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
88	ir_server_object_lines_group_system	t	24	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
89	ir_actions_server_group_system	t	23	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
90	ir_actions_client all	t	26	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
91	res_bank_group_system	t	86	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
92	res_bank_group_partner_manager	t	86	8	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
93	res_bank user	t	86	1	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
94	ir_filters all	t	31	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
95	ir_filters all	t	31	1	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
96	ir_filters all	t	31	9	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
97	ir_filters all	t	31	10	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
98	ir_config_parameter_system	t	37	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
99	ir_mail_server	t	39	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
100	ir_logging admin	t	62	2	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
101	ir_actions_report_paperformat group_portal	t	72	\N	t	f	f	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
102	ir_actions_report_paperformat group_system	t	72	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
103	access_report_layout	t	71	\N	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
104	access.wizard.ir.model.menu.create	t	10	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
105	access.reset.view.arch.wizard	t	16	2	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
106	access.ir.demo	t	68	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
107	access.ir.demo_failure	t	69	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
108	access.ir.demo_failure.wizard	t	70	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
109	access.res.config	t	88	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
110	access.res.config.installer	t	89	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
111	access.res.config.settings	t	90	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
112	access.change.password.wizard	t	98	2	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
113	access.change.password.user	t	99	2	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
114	access.base.module.update	t	105	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
115	access.base.language.install	t	106	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
116	access.base.language.import	t	107	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
117	access.base.module.upgrade	t	108	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
118	access.base.module.uninstall	t	109	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
119	access.base.language.export	t	110	1	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
120	access.base.update.translations	t	111	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
121	access.base.partner.merge.line	t	112	8	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
122	access.base.partner.merge.automatic.wizard	t	113	8	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
123	ir_profile	t	73	3	t	t	t	t	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
124	access.base.enable.profiling.wizard	t	74	3	t	t	t	f	1	2026-01-22 02:33:34.171596	1	2026-01-22 02:33:34.171596
125	access.base.document.layout	t	115	3	t	t	t	f	1	2026-01-22 02:33:50.902537	1	2026-01-22 02:33:50.902537
126	auth_totp wizard access rules	t	117	1	t	t	t	t	1	2026-01-22 02:33:55.752938	1	2026-01-22 02:33:55.752938
127	TOTP Device access employees	t	116	1	t	f	f	f	1	2026-01-22 02:33:55.752938	1	2026-01-22 02:33:55.752938
128	TOTP Device access portal	t	116	9	t	f	f	f	1	2026-01-22 02:33:55.752938	1	2026-01-22 02:33:55.752938
129	base.import.tests.models.char	t	120	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
130	base.import.tests.models.char.required	t	121	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
131	base.import.tests.models.char.readonly	t	122	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
132	base.import.tests.models.char.states	t	123	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
133	base.import.tests.models.char.noreadonly	t	124	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
134	base.import.tests.models.char.stillreadonly	t	125	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
135	base.import.tests.models.m2o	t	126	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
136	base.import.tests.models.m2o.related	t	127	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
137	base.import.tests.models.m2o.required	t	128	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
138	base.import.tests.models.m2o.required.related	t	129	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
139	base.import.tests.models.o2m	t	130	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
140	base.import.tests.models.o2m.child	t	131	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
141	base.import.tests.models.float	t	133	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
142	base.import.tests.models.preview	t	132	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
143	base.import.mapping	t	118	1	t	t	t	t	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
144	access_base_import_tests_models_complex	t	134	1	t	f	f	f	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
145	access.base_import.import	t	119	1	t	t	t	f	1	2026-01-22 02:33:56.088568	1	2026-01-22 02:33:56.088568
146	access_web_editor_converter_test	t	137	\N	t	t	t	t	1	2026-01-22 02:33:57.429843	1	2026-01-22 02:33:57.429843
147	access_web_editor_converter_test_sub	t	138	\N	t	t	t	t	1	2026-01-22 02:33:57.429843	1	2026-01-22 02:33:57.429843
148	access_web_tour_tour_admin	t	139	3	t	f	t	f	1	2026-01-22 02:33:57.946096	1	2026-01-22 02:33:57.946096
149	access_web_tour_tour	t	139	\N	t	f	f	f	1	2026-01-22 02:33:57.946096	1	2026-01-22 02:33:57.946096
\.


--
-- Data for Name: ir_model_constraint; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_constraint (id, name, definition, message, model, module, type, write_date, create_date, create_uid, write_uid) FROM stdin;
1	ir_model_obj_name_uniq	unique(model)	Each model must have a unique name.	3	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
2	ir_model_fields_name_unique	unique(model,name)	Field names must be unique per model.	4	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
3	ir_model_fields_size_gt_zero	check(size>=0)	Size of the field cannot be negative.	4	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
4	ir_model_fields_selection_selection_field_uniq	unique(field_id,value)	Selections values must be unique per field	5	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
5	ir_model_constraint_module_name_uniq	unique(name,module)	Constraints with the same name are unique per module.	6	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
6	ir_model_data_name_nospaces	check(name not like '% %')	External IDs cannot contain spaces	9	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
7	ir_ui_view_inheritance_mode	check(mode != 'extension' or inherit_id is not null)	Invalid inheritance mode: if the mode is 'extension', the view must extend an other view	15	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
8	ir_ui_view_qweb_required_key	check(type != 'qweb' or key is not null)	Invalid key: QWeb view should have a key	15	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
9	ir_filters_name_model_uid_unique	unique(name,model_id,user_id,action_id)	Filter names must be unique	31	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
10	ir_translation_lang_fkey_res_lang	foreign key(lang) references res_lang(code)	Language code of translation item must be among known languages	33	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
11	ir_rule_no_access_rights	check(perm_read!=false or perm_write!=false or perm_create!=false or perm_unlink!=false)	Rule must have at least one checked access right !	36	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
12	ir_config_parameter_key_uniq	unique(key)	Key must be unique.	37	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
13	ir_module_module_name_uniq	unique(name)	The name of the module must be unique!	65	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
14	res_country_name_uniq	unique(name)	The name of the country must be unique !	77	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
15	res_country_code_uniq	unique(code)	The code of the country must be unique !	77	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
16	res_country_state_name_code_uniq	unique(country_id,code)	The code of the state must be unique by country !	79	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
17	res_lang_name_uniq	unique(name)	The name of the language must be unique !	80	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
18	res_lang_code_uniq	unique(code)	The code of the language must be unique !	80	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
19	res_lang_url_code_uniq	unique(url_code)	The URL code of the language must be unique !	80	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
20	res_partner_check_name	check((type='contact' and name is not null) or(type!='contact') )	Contacts require a name	84	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
21	res_partner_bank_unique_number	unique(sanitized_acc_number,company_id)	Account Number must be unique	87	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
22	res_currency_unique_name	unique(name)	The currency code must be unique!	91	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
23	res_currency_rounding_gt_zero	check(rounding>0)	The rounding factor must be greater than 0!	91	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
24	res_currency_rate_unique_name_per_day	unique(name,currency_id,company_id)	Only one currency rate per day allowed!	92	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
25	res_currency_rate_currency_rate_check	check(rate>0)	The currency rate must be strictly positive.	92	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
26	res_company_name_uniq	unique(name)	The company name must be unique !	93	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
27	res_groups_name_uniq	unique(category_id,name)	The name of the group must be unique within an application!	94	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
28	res_users_login_key	unique(login)	You can not have two users with the same login !	96	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
29	decimal_precision_name_uniq	unique(name)	Only one value can be defined for each given usage!	103	1115	u	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
30	ir_model_create_uid_fkey	\N	\N	3	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
31	ir_model_write_uid_fkey	\N	\N	3	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
32	ir_model_fields_relation_field_id_fkey	\N	\N	4	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
33	ir_model_fields_model_id_fkey	\N	\N	4	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
34	ir_model_fields_related_field_id_fkey	\N	\N	4	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
35	ir_model_fields_group_rel_field_id_fkey	\N	\N	4	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
36	ir_model_fields_group_rel_group_id_fkey	\N	\N	4	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
37	ir_model_fields_create_uid_fkey	\N	\N	4	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
38	ir_model_fields_write_uid_fkey	\N	\N	4	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
39	ir_model_fields_selection_field_id_fkey	\N	\N	5	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
40	ir_model_fields_selection_create_uid_fkey	\N	\N	5	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
41	ir_model_fields_selection_write_uid_fkey	\N	\N	5	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
42	ir_model_constraint_model_fkey	\N	\N	6	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
43	ir_model_constraint_module_fkey	\N	\N	6	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
44	ir_model_constraint_create_uid_fkey	\N	\N	6	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
45	ir_model_constraint_write_uid_fkey	\N	\N	6	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
46	ir_model_relation_model_fkey	\N	\N	7	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
47	ir_model_relation_module_fkey	\N	\N	7	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
48	ir_model_relation_create_uid_fkey	\N	\N	7	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
49	ir_model_relation_write_uid_fkey	\N	\N	7	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
50	ir_model_access_model_id_fkey	\N	\N	8	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
51	ir_model_access_group_id_fkey	\N	\N	8	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
52	ir_model_access_create_uid_fkey	\N	\N	8	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
53	ir_model_access_write_uid_fkey	\N	\N	8	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
54	ir_model_data_create_uid_fkey	\N	\N	9	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
55	ir_model_data_write_uid_fkey	\N	\N	9	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
56	wizard_ir_model_menu_create_menu_id_fkey	\N	\N	10	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
57	wizard_ir_model_menu_create_create_uid_fkey	\N	\N	10	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
58	wizard_ir_model_menu_create_write_uid_fkey	\N	\N	10	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
59	ir_sequence_company_id_fkey	\N	\N	11	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
60	ir_sequence_create_uid_fkey	\N	\N	11	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
61	ir_sequence_write_uid_fkey	\N	\N	11	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
62	ir_sequence_date_range_sequence_id_fkey	\N	\N	12	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
63	ir_sequence_date_range_create_uid_fkey	\N	\N	12	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
64	ir_sequence_date_range_write_uid_fkey	\N	\N	12	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
65	ir_ui_menu_parent_id_fkey	\N	\N	13	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
66	ir_ui_menu_group_rel_menu_id_fkey	\N	\N	94	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
67	ir_ui_menu_group_rel_gid_fkey	\N	\N	13	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
68	ir_ui_menu_create_uid_fkey	\N	\N	13	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
69	ir_ui_menu_write_uid_fkey	\N	\N	13	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
70	ir_ui_view_custom_ref_id_fkey	\N	\N	14	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
71	ir_ui_view_custom_user_id_fkey	\N	\N	14	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
72	ir_ui_view_custom_create_uid_fkey	\N	\N	14	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
73	ir_ui_view_custom_write_uid_fkey	\N	\N	14	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
74	ir_ui_view_inherit_id_fkey	\N	\N	15	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
75	ir_ui_view_group_rel_view_id_fkey	\N	\N	94	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
76	ir_ui_view_group_rel_group_id_fkey	\N	\N	15	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
77	ir_ui_view_create_uid_fkey	\N	\N	15	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
78	ir_ui_view_write_uid_fkey	\N	\N	15	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
79	reset_view_arch_wizard_view_id_fkey	\N	\N	16	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
80	reset_view_arch_wizard_compare_view_id_fkey	\N	\N	16	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
81	reset_view_arch_wizard_create_uid_fkey	\N	\N	16	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
82	reset_view_arch_wizard_write_uid_fkey	\N	\N	16	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
83	ir_asset_create_uid_fkey	\N	\N	17	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
84	ir_asset_write_uid_fkey	\N	\N	17	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
85	ir_actions_binding_model_id_fkey	\N	\N	21	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
86	ir_actions_create_uid_fkey	\N	\N	21	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
87	ir_actions_write_uid_fkey	\N	\N	21	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
88	ir_act_window_binding_model_id_fkey	\N	\N	19	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
89	ir_act_window_create_uid_fkey	\N	\N	19	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
90	ir_act_window_write_uid_fkey	\N	\N	19	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
91	ir_act_window_view_id_fkey	\N	\N	19	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
92	ir_act_window_group_rel_act_id_fkey	\N	\N	19	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
93	ir_act_window_group_rel_gid_fkey	\N	\N	19	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
94	ir_act_window_search_view_id_fkey	\N	\N	19	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
95	ir_act_window_view_view_id_fkey	\N	\N	20	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
96	ir_act_window_view_act_window_id_fkey	\N	\N	20	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
97	ir_act_window_view_create_uid_fkey	\N	\N	20	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
98	ir_act_window_view_write_uid_fkey	\N	\N	20	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
99	ir_act_url_binding_model_id_fkey	\N	\N	22	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
100	ir_act_url_create_uid_fkey	\N	\N	22	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
101	ir_act_url_write_uid_fkey	\N	\N	22	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
102	ir_act_server_binding_model_id_fkey	\N	\N	23	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
103	ir_act_server_create_uid_fkey	\N	\N	23	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
104	ir_act_server_write_uid_fkey	\N	\N	23	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
105	ir_act_server_model_id_fkey	\N	\N	23	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
106	rel_server_actions_server_id_fkey	\N	\N	23	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
107	rel_server_actions_action_id_fkey	\N	\N	23	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
108	ir_act_server_crud_model_id_fkey	\N	\N	23	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
109	ir_act_server_link_field_id_fkey	\N	\N	23	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
110	ir_act_server_group_rel_act_id_fkey	\N	\N	23	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
111	ir_act_server_group_rel_gid_fkey	\N	\N	23	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
112	ir_server_object_lines_server_id_fkey	\N	\N	24	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
113	ir_server_object_lines_col1_fkey	\N	\N	24	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
114	ir_server_object_lines_create_uid_fkey	\N	\N	24	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
115	ir_server_object_lines_write_uid_fkey	\N	\N	24	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
116	ir_actions_todo_create_uid_fkey	\N	\N	25	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
117	ir_actions_todo_write_uid_fkey	\N	\N	25	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
118	ir_act_client_binding_model_id_fkey	\N	\N	26	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
119	ir_act_client_create_uid_fkey	\N	\N	26	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
120	ir_act_client_write_uid_fkey	\N	\N	26	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
121	ir_act_report_xml_binding_model_id_fkey	\N	\N	27	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
122	ir_act_report_xml_create_uid_fkey	\N	\N	27	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
123	ir_act_report_xml_write_uid_fkey	\N	\N	27	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
124	res_groups_report_rel_uid_fkey	\N	\N	27	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
125	res_groups_report_rel_gid_fkey	\N	\N	27	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
126	ir_act_report_xml_paperformat_id_fkey	\N	\N	27	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
127	ir_attachment_company_id_fkey	\N	\N	28	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
128	ir_attachment_create_uid_fkey	\N	\N	28	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
129	ir_attachment_write_uid_fkey	\N	\N	28	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
130	ir_cron_ir_actions_server_id_fkey	\N	\N	29	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
131	ir_cron_user_id_fkey	\N	\N	29	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
132	ir_cron_create_uid_fkey	\N	\N	29	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
133	ir_cron_write_uid_fkey	\N	\N	29	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
134	ir_cron_trigger_cron_id_fkey	\N	\N	30	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
135	ir_cron_trigger_create_uid_fkey	\N	\N	30	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
136	ir_cron_trigger_write_uid_fkey	\N	\N	30	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
137	ir_filters_user_id_fkey	\N	\N	31	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
138	ir_filters_create_uid_fkey	\N	\N	31	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
139	ir_filters_write_uid_fkey	\N	\N	31	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
140	ir_default_field_id_fkey	\N	\N	32	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
141	ir_default_user_id_fkey	\N	\N	32	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
142	ir_default_company_id_fkey	\N	\N	32	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
143	ir_default_create_uid_fkey	\N	\N	32	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
144	ir_default_write_uid_fkey	\N	\N	32	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
145	ir_exports_create_uid_fkey	\N	\N	34	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
146	ir_exports_write_uid_fkey	\N	\N	34	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
147	ir_exports_line_export_id_fkey	\N	\N	35	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
148	ir_exports_line_create_uid_fkey	\N	\N	35	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
149	ir_exports_line_write_uid_fkey	\N	\N	35	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
150	ir_rule_model_id_fkey	\N	\N	36	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
151	rule_group_rel_rule_group_id_fkey	\N	\N	94	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
152	rule_group_rel_group_id_fkey	\N	\N	36	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
153	ir_rule_create_uid_fkey	\N	\N	36	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
154	ir_rule_write_uid_fkey	\N	\N	36	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
155	ir_config_parameter_create_uid_fkey	\N	\N	37	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
156	ir_config_parameter_write_uid_fkey	\N	\N	37	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
157	ir_mail_server_create_uid_fkey	\N	\N	39	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
158	ir_mail_server_write_uid_fkey	\N	\N	39	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
159	ir_property_company_id_fkey	\N	\N	63	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
160	ir_property_fields_id_fkey	\N	\N	63	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
161	ir_property_create_uid_fkey	\N	\N	63	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
162	ir_property_write_uid_fkey	\N	\N	63	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
163	ir_module_category_create_uid_fkey	\N	\N	64	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
164	ir_module_category_write_uid_fkey	\N	\N	64	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
165	ir_module_module_create_uid_fkey	\N	\N	65	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
166	ir_module_module_write_uid_fkey	\N	\N	65	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
167	ir_module_module_dependency_create_uid_fkey	\N	\N	66	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
168	ir_module_module_dependency_write_uid_fkey	\N	\N	66	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
169	ir_module_module_exclusion_module_id_fkey	\N	\N	67	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
170	ir_module_module_exclusion_create_uid_fkey	\N	\N	67	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
171	ir_module_module_exclusion_write_uid_fkey	\N	\N	67	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
172	ir_demo_create_uid_fkey	\N	\N	68	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
173	ir_demo_write_uid_fkey	\N	\N	68	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
174	ir_demo_failure_module_id_fkey	\N	\N	69	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
175	ir_demo_failure_wizard_id_fkey	\N	\N	69	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
176	ir_demo_failure_create_uid_fkey	\N	\N	69	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
177	ir_demo_failure_write_uid_fkey	\N	\N	69	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
178	ir_demo_failure_wizard_create_uid_fkey	\N	\N	70	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
179	ir_demo_failure_wizard_write_uid_fkey	\N	\N	70	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
180	report_layout_view_id_fkey	\N	\N	71	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
181	report_layout_create_uid_fkey	\N	\N	71	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
182	report_layout_write_uid_fkey	\N	\N	71	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
183	report_paperformat_create_uid_fkey	\N	\N	72	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
184	report_paperformat_write_uid_fkey	\N	\N	72	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
185	base_enable_profiling_wizard_create_uid_fkey	\N	\N	74	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
186	base_enable_profiling_wizard_write_uid_fkey	\N	\N	74	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
187	res_country_address_view_id_fkey	\N	\N	77	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
188	res_country_currency_id_fkey	\N	\N	77	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
189	res_country_res_country_group_rel_res_country_id_fkey	\N	\N	78	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
190	res_country_res_country_group_rel_res_country_group_id_fkey	\N	\N	77	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
191	res_country_create_uid_fkey	\N	\N	77	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
192	res_country_write_uid_fkey	\N	\N	77	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
193	res_country_group_create_uid_fkey	\N	\N	78	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
194	res_country_group_write_uid_fkey	\N	\N	78	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
195	res_country_state_country_id_fkey	\N	\N	79	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
196	res_country_state_create_uid_fkey	\N	\N	79	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
197	res_country_state_write_uid_fkey	\N	\N	79	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
198	res_lang_create_uid_fkey	\N	\N	80	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
199	res_lang_write_uid_fkey	\N	\N	80	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
200	res_partner_category_parent_id_fkey	\N	\N	82	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
201	res_partner_res_partner_category_rel_category_id_fkey	\N	\N	84	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
202	res_partner_res_partner_category_rel_partner_id_fkey	\N	\N	82	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
203	res_partner_category_create_uid_fkey	\N	\N	82	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
204	res_partner_category_write_uid_fkey	\N	\N	82	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
205	res_partner_title_create_uid_fkey	\N	\N	83	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
206	res_partner_title_write_uid_fkey	\N	\N	83	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
207	res_partner_title_fkey	\N	\N	84	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
208	res_partner_parent_id_fkey	\N	\N	84	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
209	res_partner_user_id_fkey	\N	\N	84	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
210	res_partner_state_id_fkey	\N	\N	84	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
211	res_partner_country_id_fkey	\N	\N	84	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
212	res_partner_industry_id_fkey	\N	\N	84	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
213	res_partner_company_id_fkey	\N	\N	84	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
214	res_partner_commercial_partner_id_fkey	\N	\N	84	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
215	res_partner_create_uid_fkey	\N	\N	84	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
216	res_partner_write_uid_fkey	\N	\N	84	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
217	res_partner_industry_create_uid_fkey	\N	\N	85	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
218	res_partner_industry_write_uid_fkey	\N	\N	85	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
219	res_bank_state_fkey	\N	\N	86	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
220	res_bank_country_fkey	\N	\N	86	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
221	res_bank_create_uid_fkey	\N	\N	86	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
222	res_bank_write_uid_fkey	\N	\N	86	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
223	res_partner_bank_partner_id_fkey	\N	\N	87	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
224	res_partner_bank_bank_id_fkey	\N	\N	87	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
225	res_partner_bank_currency_id_fkey	\N	\N	87	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
226	res_partner_bank_company_id_fkey	\N	\N	87	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
227	res_partner_bank_create_uid_fkey	\N	\N	87	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
228	res_partner_bank_write_uid_fkey	\N	\N	87	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
229	res_config_create_uid_fkey	\N	\N	88	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
230	res_config_write_uid_fkey	\N	\N	88	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
231	res_config_installer_create_uid_fkey	\N	\N	89	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
232	res_config_installer_write_uid_fkey	\N	\N	89	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
233	res_config_settings_create_uid_fkey	\N	\N	90	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
234	res_config_settings_write_uid_fkey	\N	\N	90	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
235	res_currency_create_uid_fkey	\N	\N	91	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
236	res_currency_write_uid_fkey	\N	\N	91	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
237	res_currency_rate_currency_id_fkey	\N	\N	92	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
238	res_currency_rate_company_id_fkey	\N	\N	92	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
239	res_currency_rate_create_uid_fkey	\N	\N	92	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
240	res_currency_rate_write_uid_fkey	\N	\N	92	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
241	res_company_parent_id_fkey	\N	\N	93	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
242	res_company_partner_id_fkey	\N	\N	93	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
243	res_company_currency_id_fkey	\N	\N	93	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
244	res_company_users_rel_cid_fkey	\N	\N	96	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
245	res_company_users_rel_user_id_fkey	\N	\N	93	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
246	res_company_paperformat_id_fkey	\N	\N	93	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
247	res_company_external_report_layout_id_fkey	\N	\N	93	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
248	res_company_create_uid_fkey	\N	\N	93	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
249	res_company_write_uid_fkey	\N	\N	93	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
250	res_groups_users_rel_gid_fkey	\N	\N	96	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
251	res_groups_users_rel_uid_fkey	\N	\N	94	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
252	res_groups_category_id_fkey	\N	\N	94	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
253	res_groups_create_uid_fkey	\N	\N	94	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
254	res_groups_write_uid_fkey	\N	\N	94	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
255	res_groups_implied_rel_gid_fkey	\N	\N	94	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
256	res_groups_implied_rel_hid_fkey	\N	\N	94	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
257	res_users_log_create_uid_fkey	\N	\N	95	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
258	res_users_log_write_uid_fkey	\N	\N	95	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
259	res_users_partner_id_fkey	\N	\N	96	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
260	res_users_company_id_fkey	\N	\N	96	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
261	res_users_create_uid_fkey	\N	\N	96	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
262	res_users_write_uid_fkey	\N	\N	96	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
263	res_users_identitycheck_create_uid_fkey	\N	\N	97	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
264	res_users_identitycheck_write_uid_fkey	\N	\N	97	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
265	change_password_wizard_create_uid_fkey	\N	\N	98	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
266	change_password_wizard_write_uid_fkey	\N	\N	98	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
267	change_password_user_wizard_id_fkey	\N	\N	99	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
268	change_password_user_user_id_fkey	\N	\N	99	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
269	change_password_user_create_uid_fkey	\N	\N	99	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
270	change_password_user_write_uid_fkey	\N	\N	99	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
271	res_users_apikeys_description_create_uid_fkey	\N	\N	101	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
272	res_users_apikeys_description_write_uid_fkey	\N	\N	101	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
273	decimal_precision_create_uid_fkey	\N	\N	103	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
274	decimal_precision_write_uid_fkey	\N	\N	103	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
275	base_module_update_create_uid_fkey	\N	\N	105	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
276	base_module_update_write_uid_fkey	\N	\N	105	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
277	base_language_install_create_uid_fkey	\N	\N	106	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
278	base_language_install_write_uid_fkey	\N	\N	106	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
279	base_language_import_create_uid_fkey	\N	\N	107	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
280	base_language_import_write_uid_fkey	\N	\N	107	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
281	base_module_upgrade_create_uid_fkey	\N	\N	108	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
282	base_module_upgrade_write_uid_fkey	\N	\N	108	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
283	base_module_uninstall_module_id_fkey	\N	\N	109	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
284	base_module_uninstall_create_uid_fkey	\N	\N	109	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
285	base_module_uninstall_write_uid_fkey	\N	\N	109	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
286	rel_modules_langexport_wiz_id_fkey	\N	\N	110	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
287	rel_modules_langexport_module_id_fkey	\N	\N	110	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
288	base_language_export_create_uid_fkey	\N	\N	110	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
289	base_language_export_write_uid_fkey	\N	\N	110	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
290	base_update_translations_create_uid_fkey	\N	\N	111	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
291	base_update_translations_write_uid_fkey	\N	\N	111	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
292	base_partner_merge_line_wizard_id_fkey	\N	\N	112	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
293	base_partner_merge_line_create_uid_fkey	\N	\N	112	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
294	base_partner_merge_line_write_uid_fkey	\N	\N	112	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
295	base_partner_merge_automatic_wizard_current_line_id_fkey	\N	\N	113	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
296	base_partner_merge_automatic__base_partner_merge_automatic_fkey	\N	\N	113	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
297	base_partner_merge_automatic_wizard_res_par_res_partner_id_fkey	\N	\N	113	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
298	base_partner_merge_automatic_wizard_dst_partner_id_fkey	\N	\N	113	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
299	base_partner_merge_automatic_wizard_create_uid_fkey	\N	\N	113	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
300	base_partner_merge_automatic_wizard_write_uid_fkey	\N	\N	113	1115	f	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	1	1
301	base_document_layout_company_id_fkey	\N	\N	115	908	f	2026-01-22 02:33:50.902537	2026-01-22 02:33:50.902537	1	1
302	base_document_layout_report_layout_id_fkey	\N	\N	115	908	f	2026-01-22 02:33:50.902537	2026-01-22 02:33:50.902537	1	1
303	base_document_layout_create_uid_fkey	\N	\N	115	908	f	2026-01-22 02:33:50.902537	2026-01-22 02:33:50.902537	1	1
304	base_document_layout_write_uid_fkey	\N	\N	115	908	f	2026-01-22 02:33:50.902537	2026-01-22 02:33:50.902537	1	1
305	auth_totp_wizard_user_id_fkey	\N	\N	117	62	f	2026-01-22 02:33:55.752938	2026-01-22 02:33:55.752938	1	1
306	auth_totp_wizard_create_uid_fkey	\N	\N	117	62	f	2026-01-22 02:33:55.752938	2026-01-22 02:33:55.752938	1	1
307	auth_totp_wizard_write_uid_fkey	\N	\N	117	62	f	2026-01-22 02:33:55.752938	2026-01-22 02:33:55.752938	1	1
308	base_import_mapping_create_uid_fkey	\N	\N	118	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
309	base_import_mapping_write_uid_fkey	\N	\N	118	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
310	base_import_import_create_uid_fkey	\N	\N	119	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
311	base_import_import_write_uid_fkey	\N	\N	119	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
312	base_import_tests_models_char_create_uid_fkey	\N	\N	120	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
313	base_import_tests_models_char_write_uid_fkey	\N	\N	120	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
314	base_import_tests_models_char_required_create_uid_fkey	\N	\N	121	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
315	base_import_tests_models_char_required_write_uid_fkey	\N	\N	121	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
316	base_import_tests_models_char_readonly_create_uid_fkey	\N	\N	122	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
317	base_import_tests_models_char_readonly_write_uid_fkey	\N	\N	122	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
318	base_import_tests_models_char_states_create_uid_fkey	\N	\N	123	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
319	base_import_tests_models_char_states_write_uid_fkey	\N	\N	123	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
320	base_import_tests_models_char_noreadonly_create_uid_fkey	\N	\N	124	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
321	base_import_tests_models_char_noreadonly_write_uid_fkey	\N	\N	124	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
322	base_import_tests_models_char_stillreadonly_create_uid_fkey	\N	\N	125	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
323	base_import_tests_models_char_stillreadonly_write_uid_fkey	\N	\N	125	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
324	base_import_tests_models_m2o_value_fkey	\N	\N	126	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
325	base_import_tests_models_m2o_create_uid_fkey	\N	\N	126	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
326	base_import_tests_models_m2o_write_uid_fkey	\N	\N	126	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
327	base_import_tests_models_m2o_related_create_uid_fkey	\N	\N	127	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
328	base_import_tests_models_m2o_related_write_uid_fkey	\N	\N	127	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
329	base_import_tests_models_m2o_required_value_fkey	\N	\N	128	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
330	base_import_tests_models_m2o_required_create_uid_fkey	\N	\N	128	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
331	base_import_tests_models_m2o_required_write_uid_fkey	\N	\N	128	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
332	base_import_tests_models_m2o_required_related_create_uid_fkey	\N	\N	129	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
333	base_import_tests_models_m2o_required_related_write_uid_fkey	\N	\N	129	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
334	base_import_tests_models_o2m_create_uid_fkey	\N	\N	130	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
335	base_import_tests_models_o2m_write_uid_fkey	\N	\N	130	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
336	base_import_tests_models_o2m_child_parent_id_fkey	\N	\N	131	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
337	base_import_tests_models_o2m_child_create_uid_fkey	\N	\N	131	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
338	base_import_tests_models_o2m_child_write_uid_fkey	\N	\N	131	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
339	base_import_tests_models_preview_create_uid_fkey	\N	\N	132	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
340	base_import_tests_models_preview_write_uid_fkey	\N	\N	132	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
341	base_import_tests_models_float_currency_id_fkey	\N	\N	133	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
342	base_import_tests_models_float_create_uid_fkey	\N	\N	133	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
343	base_import_tests_models_float_write_uid_fkey	\N	\N	133	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
344	base_import_tests_models_complex_currency_id_fkey	\N	\N	134	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
345	base_import_tests_models_complex_create_uid_fkey	\N	\N	134	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
346	base_import_tests_models_complex_write_uid_fkey	\N	\N	134	196	f	2026-01-22 02:33:56.088568	2026-01-22 02:33:56.088568	1	1
347	ir_attachment_original_id_fkey	\N	\N	28	52	f	2026-01-22 02:33:57.429843	2026-01-22 02:33:57.429843	1	1
348	web_editor_converter_test_many2one_fkey	\N	\N	137	52	f	2026-01-22 02:33:57.429843	2026-01-22 02:33:57.429843	1	1
349	web_editor_converter_test_create_uid_fkey	\N	\N	137	52	f	2026-01-22 02:33:57.429843	2026-01-22 02:33:57.429843	1	1
350	web_editor_converter_test_write_uid_fkey	\N	\N	137	52	f	2026-01-22 02:33:57.429843	2026-01-22 02:33:57.429843	1	1
351	web_editor_converter_test_sub_create_uid_fkey	\N	\N	138	52	f	2026-01-22 02:33:57.429843	2026-01-22 02:33:57.429843	1	1
352	web_editor_converter_test_sub_write_uid_fkey	\N	\N	138	52	f	2026-01-22 02:33:57.429843	2026-01-22 02:33:57.429843	1	1
353	web_tour_tour_user_id_fkey	\N	\N	139	330	f	2026-01-22 02:33:57.946096	2026-01-22 02:33:57.946096	1	1
\.


--
-- Data for Name: ir_model_data; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_data (id, create_uid, create_date, write_date, write_uid, noupdate, name, module, model, res_id) FROM stdin;
9	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ar	base	ir.module.module	1
10	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_web	base	ir.module.category	4
11	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_environment_ribbon	base	ir.module.module	2
12	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_loan	base	ir.module.module	3
14	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_sales_sales	base	ir.module.category	6
15	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale	base	ir.module.module	4
16	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_margin	base	ir.module.module	5
17	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_localization	base	ir.module.category	7
18	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_amount_to_text	base	ir.module.module	6
19	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounting_and_finance	base	ir.module.category	8
20	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_supplier_self_invoice	base	ir.module.module	7
21	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_lt	base	ir.module.module	8
22	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_purchase_management	base	ir.module.category	9
23	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_work_acceptance_late_fines	base	ir.module.module	9
24	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_extra_tools	base	ir.module.category	10
25	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sentry	base	ir.module.module	10
27	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_hidden_tools	base	ir.module.category	12
28	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sms	base	ir.module.module	11
30	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_website_website	base	ir.module.category	14
31	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_gift_card	base	ir.module.module	12
33	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_services_project	base	ir.module.category	16
34	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project	base	ir.module.module	13
36	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_track	base	ir.module.module	14
38	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_widget_o2m	base	ir.module.module	15
39	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_coupon_delivery	base	ir.module.module	16
40	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_purchase	base	ir.module.category	19
41	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_revision	base	ir.module.module	17
42	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_no_bubble	base	ir.module.module	18
43	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_uncategorized	base	ir.module.category	20
44	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_time_range_menu_custom	base	ir.module.module	19
45	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_fetchmail_outlook	base	ir.module.module	20
46	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_sale_gift_card	base	ir.module.module	21
47	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_category_tax	base	ir.module.module	22
48	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pad	base	ir.module.module	23
49	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_wishlist	base	ir.module.module	24
50	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_hidden_dependency	base	ir.module.category	21
51	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_tree_dynamic_colored_field	base	ir.module.module	25
52	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_sale	base	ir.module.module	26
53	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_generic_modules	base	ir.module.category	22
54	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_generic_modules_others	base	ir.module.category	23
55	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sql_export_excel	base	ir.module.module	27
56	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_skills_survey	base	ir.module.module	28
57	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_base	base	ir.module.category	24
58	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_admin_passkey	base	ir.module.module	29
59	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_marketing_events	base	ir.module.category	25
60	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_event_booth	base	ir.module.module	30
61	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_reporting	base	ir.module.category	26
62	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sequence_check_digit	base	ir.module.module	31
63	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_payment	base	ir.module.module	32
64	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_global_discount	base	ir.module.module	33
65	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_technical_user	base	ir.module.module	34
66	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_asset_management	base	ir.module.module	35
67	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounting_localizations_point_of_sale	base	ir.module.category	27
68	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_co_pos	base	ir.module.module	36
69	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_reconciliation_widget_limit_aml	base	ir.module.module	37
71	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_edi_ubl_cii	base	ir.module.module	38
72	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_comparison_wishlist	base	ir.module.module	39
73	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_expense_cost_reinvoice	base	ir.module.module	40
74	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_quotation_builder	base	ir.module.module	41
75	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_project	base	ir.module.category	29
76	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_parent_task_filter	base	ir.module.module	42
77	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_tax_python	base	ir.module.module	43
78	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_purchase_stock_report_non_billed	base	ir.module.module	44
79	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_xlsx_helper	base	ir.module.module	45
80	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_in_upi	base	ir.module.module	46
81	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_technical_settings	base	ir.module.category	30
82	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_sparse_field_list_support	base	ir.module.module	47
83	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_stock	base	ir.module.category	31
84	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_stock_secondary_unit	base	ir.module.module	48
85	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_finance	base	ir.module.category	32
86	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_reconcile_restrict_partner_mismatch	base	ir.module.module	49
87	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_vat_optional_vies	base	ir.module.module	50
88	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ve	base	ir.module.module	51
89	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_editor	base	ir.module.module	52
90	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_warehouse_management	base	ir.module.category	33
91	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_stock_available_info_popup	base	ir.module.module	53
92	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_asset_batch_compute	base	ir.module.module	54
93	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_event_booth_sale	base	ir.module.module	55
94	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_sales_management	base	ir.module.category	34
95	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_operating_unit	base	ir.module.module	56
96	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account	base	ir.module.module	57
97	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_hidden_tests	base	ir.module.category	35
98	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_read_group	base	ir.module.module	58
99	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_financial_report_sale	base	ir.module.module	59
100	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp_subcontracting_account	base	ir.module.module	60
101	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_sales_point_of_sale	base	ir.module.category	36
102	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_epson_printer	base	ir.module.module	61
103	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_totp	base	ir.module.module	62
104	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_sales_crm	base	ir.module.category	37
105	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_crm_iap_mine	base	ir.module.module	63
106	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_lock	base	ir.module.module	64
107	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_project_management	base	ir.module.category	38
108	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_timeline_hr_timesheet	base	ir.module.module	65
110	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_custom_filter	base	ir.module.module	66
111	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_timesheet_time_control	base	ir.module.module	67
112	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mis_builder_demo	base	ir.module.module	68
113	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_refund_reason_skip_anglo_saxon	base	ir.module.module	69
114	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_purchases	base	ir.module.category	40
115	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_product_recommendation_brand	base	ir.module.module	70
116	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_last_price_info	base	ir.module.module	71
117	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_gamification	base	ir.module.module	72
118	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_administrator_restricted_visibility	base	ir.module.module	73
119	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_service_contract	base	ir.module.module	74
120	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_gcc_invoice_stock_account	base	ir.module.module	75
121	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_project_copy_tasks	base	ir.module.module	76
122	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_mrp	base	ir.module.module	77
123	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_barcodes_gs1_nomenclature	base	ir.module.module	78
124	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_tools	base	ir.module.category	41
125	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_excel_import_export	base	ir.module.module	79
126	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_operating_unit	base	ir.module.module	80
127	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounting_localizations_edi	base	ir.module.category	42
128	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_sa_edi_pos	base	ir.module.module	81
129	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_analytic	base	ir.module.module	82
130	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_stock_tier_validation	base	ir.module.module	83
131	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_lock_date_update	base	ir.module.module	84
132	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_iap	base	ir.module.module	85
133	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_many2one_simple	base	ir.module.module	86
135	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_theme_default	base	ir.module.module	87
136	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_secondary_unit	base	ir.module.module	88
137	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_es_edi_sii	base	ir.module.module	89
138	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_holidays_attendance	base	ir.module.module	90
139	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_search_line	base	ir.module.module	91
140	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_required_project	base	ir.module.module	92
141	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_access_rights	base	ir.module.module	93
142	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_recurrence	base	ir.module.module	94
143	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_totp_mail	base	ir.module.module	95
144	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_de	base	ir.module.module	96
145	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_sms	base	ir.module.module	97
146	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_session_timeout	base	ir.module.module	98
147	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_human_resources_lunch	base	ir.module.category	44
148	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_lunch	base	ir.module.module	99
150	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_inventory_inventory	base	ir.module.category	46
151	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock	base	ir.module.module	100
152	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_alternate_payer	base	ir.module.module	101
153	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_coupon	base	ir.module.module	102
154	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_bi_sql_editor	base	ir.module.module	103
155	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_scrap_reason_code	base	ir.module.module	104
156	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_picking_batch	base	ir.module.module	105
157	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_tree_image_tooltip	base	ir.module.module	106
158	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_analytic_global	base	ir.module.module	107
159	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_de_skr03	base	ir.module.module	108
160	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_qweb_parameter	base	ir.module.module	109
161	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_portal_invoice_search	base	ir.module.module	110
162	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_marketing_surveys	base	ir.module.category	47
163	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_survey	base	ir.module.module	111
164	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_optional_quick_create	base	ir.module.module	112
165	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_uninvoiced_amount	base	ir.module.module	113
166	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_localization_	base	ir.module.category	48
167	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_localization___accounting	base	ir.module.category	49
168	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_bank_payment_export_ktb	base	ir.module.module	114
169	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_packaging_calculator	base	ir.module.module	115
170	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_payment_retention	base	ir.module.module	116
171	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_no_edi	base	ir.module.module	117
172	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_generic_coa	base	ir.module.module	118
173	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_stock_manual_currency	base	ir.module.module	119
174	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_tag	base	ir.module.module	120
175	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_website_elearning	base	ir.module.category	50
176	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_slides_forum	base	ir.module.module	121
177	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_it_stock_ddt	base	ir.module.module	122
178	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_open_tab	base	ir.module.module	123
179	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event	base	ir.module.module	124
180	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_digitized_signature	base	ir.module.module	125
181	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_m2x_options	base	ir.module.module	126
182	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_module_analysis	base	ir.module.module	127
183	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_stock_management	base	ir.module.category	51
184	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_location_route_description	base	ir.module.module	128
185	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounting_payment_acquirers	base	ir.module.category	52
186	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_alipay	base	ir.module.module	129
187	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_fully_received	base	ir.module.module	130
188	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_material	base	ir.module.module	131
189	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_mail	base	ir.module.module	132
190	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_ldaps	base	ir.module.module	133
191	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_pricelist	base	ir.module.module	134
192	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_server_tools	base	ir.module.category	53
193	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_import_security_group	base	ir.module.module	135
194	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_http	base	ir.module.module	136
195	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_partner_invoicing_mode	base	ir.module.module	137
196	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_portal_rating	base	ir.module.module	138
197	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_request_purchase	base	ir.module.module	139
198	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_se	base	ir.module.module	140
199	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_pe	base	ir.module.module	141
200	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_crm_questions	base	ir.module.module	142
201	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_document_quick_access_folder_auto_classification	base	ir.module.module	143
202	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_buckaroo	base	ir.module.module	144
203	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_br	base	ir.module.module	145
204	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_main_flows	base	ir.module.module	146
205	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_fetchmail_incoming_log_test	base	ir.module.module	147
206	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_lu	base	ir.module.module	148
207	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_customer	base	ir.module.module	149
208	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_email_template	base	ir.module.module	150
209	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_discount	base	ir.module.module	151
210	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_generic	base	ir.module.category	54
211	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_line_product	base	ir.module.module	152
212	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_delivery_giftcard	base	ir.module.module	153
213	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_check_deposit	base	ir.module.module	154
214	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp_repair	base	ir.module.module	155
215	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_orderpoint_uom	base	ir.module.module	156
216	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_x2many_2d_matrix	base	ir.module.module	157
217	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_dbfilter_from_header	base	ir.module.module	158
218	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_forecast_line	base	ir.module.module	159
219	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_human_resources_expenses	base	ir.module.category	55
220	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense	base	ir.module.module	160
221	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_substate	base	ir.module.module	161
222	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_change_qty_reason	base	ir.module.module	162
223	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_search_fuzzy	base	ir.module.module	163
224	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_sheet_full_width	base	ir.module.module	164
225	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_mailing_sale_sms	base	ir.module.module	165
226	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_authorize	base	ir.module.module	166
227	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_petty_cash	base	ir.module.module	167
228	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_booth_exhibitor	base	ir.module.module	168
229	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_livechat	base	ir.module.module	169
230	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_disable_odoo_online	base	ir.module.module	170
231	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_medical_examination	base	ir.module.module	171
232	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_ical	base	ir.module.module	172
233	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_analytic_tag_default	base	ir.module.module	173
234	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_point_of_sale	base	ir.module.category	56
235	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_restaurant_adyen	base	ir.module.module	174
237	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp_operating_unit	base	ir.module.module	175
238	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_account	base	ir.module.category	58
239	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_eg_edi_eta	base	ir.module.module	176
240	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_pk	base	ir.module.module	177
241	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_analytic	base	ir.module.category	59
242	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_request_analytic	base	ir.module.module	178
243	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_warehouse	base	ir.module.category	60
244	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_demand_estimate	base	ir.module.module	179
245	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_analytic	base	ir.module.module	180
246	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_fiscal_position_update	base	ir.module.module	181
247	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_letsencrypt	base	ir.module.module	182
248	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_oidc	base	ir.module.module	183
249	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_document_quick_access	base	ir.module.module	184
250	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_multicurrency_revaluation_operating_unit	base	ir.module.module	185
251	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_edi_proxy_client	base	ir.module.module	186
252	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_operating_unit	base	ir.module.module	187
253	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_sent_usability	base	ir.module.module	188
254	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_refresher	base	ir.module.module	189
255	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_archive_date	base	ir.module.module	190
256	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_line_reassign	base	ir.module.module	191
257	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th	base	ir.module.module	192
258	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_account_tax_expense_operating_unit	base	ir.module.module	193
259	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_reconcile_helper	base	ir.module.module	194
260	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_balance_line	base	ir.module.module	195
261	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_import	base	ir.module.module	196
262	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_warn_message	base	ir.module.module	197
263	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_request_operating_unit_access_all	base	ir.module.module	198
264	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_type_dashboard	base	ir.module.module	199
265	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_management	base	ir.module.module	200
266	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_onchange_helper	base	ir.module.module	201
267	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_localization___purchase	base	ir.module.category	61
268	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_gov_purchase_request	base	ir.module.module	202
269	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_human_resources_employees	base	ir.module.category	62
270	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr	base	ir.module.module	203
271	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_human_resources_attendances	base	ir.module.category	63
272	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_attendance	base	ir.module.module	204
273	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_sa	base	ir.module.module	205
274	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_one2many_tree_line_duplicate	base	ir.module.module	206
275	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_stock	base	ir.module.module	207
276	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_no	base	ir.module.module	208
277	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_purchase	base	ir.module.module	209
278	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ae_pos	base	ir.module.module	210
279	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ec	base	ir.module.module	211
280	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_contract_type	base	ir.module.module	212
281	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_jwt_demo	base	ir.module.module	213
282	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_coupon	base	ir.module.module	214
283	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_google_account	base	ir.module.module	215
284	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_manufacturing_manufacturing	base	ir.module.category	64
285	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp_account	base	ir.module.module	216
286	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_event_crm	base	ir.module.module	217
287	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_purchase_secondary_unit	base	ir.module.module	218
288	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_employee_analytic_default	base	ir.module.module	219
289	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_stock_analytic	base	ir.module.module	220
290	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_allowed_product	base	ir.module.module	221
291	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_total_by_account_internal_group	base	ir.module.module	222
292	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_qr	base	ir.module.module	223
293	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_xml	base	ir.module.module	224
294	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_line_refund_to_invoice_qty	base	ir.module.module	225
295	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_edi	base	ir.module.module	226
296	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_de_stock	base	ir.module.module	227
297	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_it_edi_sdicoop	base	ir.module.module	228
298	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_mass_reconcile_by_purchase_line	base	ir.module.module	229
299	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_coupon_delivery	base	ir.module.module	230
300	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_sale_stock_report_non_billed	base	ir.module.module	231
301	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_bo	base	ir.module.module	232
302	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hw_escpos	base	ir.module.module	233
303	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_expiry	base	ir.module.module	234
304	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_jitsi	base	ir.module.module	235
305	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_chatter_position	base	ir.module.module	236
306	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_account_asset_management	base	ir.module.module	237
307	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_purchase_analytic_global	base	ir.module.module	238
308	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_asset_low_value	base	ir.module.module	239
309	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_eu_oss	base	ir.module.module	240
310	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_impex	base	ir.module.module	241
311	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mail_environment_office365	base	ir.module.module	242
312	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_birthday_mail	base	ir.module.module	243
313	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_presence	base	ir.module.module	244
314	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_snailmail_account	base	ir.module.module	245
315	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_za	base	ir.module.module	246
316	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_refund_reinvoice	base	ir.module.module	247
317	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_view_calendar_list	base	ir.module.module	248
318	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_product_recommendation_forecast	base	ir.module.module	249
319	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_qty_by_product_category	base	ir.module.module	250
320	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_misc	base	ir.module.category	65
321	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_conditional_image	base	ir.module.module	251
322	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auditlog	base	ir.module.module	252
323	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ie	base	ir.module.module	253
324	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_debit_note	base	ir.module.module	254
325	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_receipt_expectation_from_partner	base	ir.module.module	255
326	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp_landed_costs	base	ir.module.module	256
327	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_account_tax_expense	base	ir.module.module	257
328	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_gov_purchase_agreement	base	ir.module.module	258
329	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_char_size	base	ir.module.module	259
330	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_expense_manual_reinvoice	base	ir.module.module	260
331	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sequence_python	base	ir.module.module	261
332	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_type	base	ir.module.module	262
333	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_microsoft_account	base	ir.module.module	263
334	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_jp	base	ir.module.module	264
335	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_picking_batch_purchase_price_update	base	ir.module.module	265
336	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_human_resources_fleet	base	ir.module.category	66
337	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_fleet	base	ir.module.module	266
338	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_procurement_mto_analytic	base	ir.module.module	267
339	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounting_localizations_purchase	base	ir.module.category	67
340	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_in_purchase	base	ir.module.module	268
341	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_json_graph	base	ir.module.module	269
342	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_mail_full	base	ir.module.module	270
343	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_substate	base	ir.module.module	271
344	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_request	base	ir.module.module	272
345	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_stock	base	ir.module.module	273
346	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_deposit_analytic	base	ir.module.module	274
347	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sql_export_mail	base	ir.module.module	275
348	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_line_report_xls	base	ir.module.module	276
349	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hw_posbox_homepage	base	ir.module.module	277
350	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_authentication	base	ir.module.category	68
351	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_user_case_insensitive	base	ir.module.module	278
352	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_in_edi_ewaybill	base	ir.module.module	279
353	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_reconcile_forbid_cancel	base	ir.module.module	280
354	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_asset_management_menu	base	ir.module.module	281
355	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_generic_modules_sales_and_purchases	base	ir.module.category	69
356	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_account_operating_unit	base	ir.module.module	282
357	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_operating_unit	base	ir.module.module	283
358	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_generic_modules_human_resources	base	ir.module.category	70
359	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_operating_unit	base	ir.module.module	284
360	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_line_price_history_discount	base	ir.module.module	285
361	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_excluded_tax	base	ir.module.module	286
362	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_field_deprecated	base	ir.module.module	287
363	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_tax_group_widget_base_amount	base	ir.module.module	288
364	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_advance_clearing_sequence	base	ir.module.module	289
365	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_time_window	base	ir.module.module	290
366	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_advanced_search	base	ir.module.module	291
367	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_stock_picking_invoicing	base	ir.module.module	292
368	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_manual_currency	base	ir.module.module	293
369	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_track_quiz	base	ir.module.module	294
370	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_inventory_purchase	base	ir.module.category	71
371	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase	base	ir.module.module	295
372	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_cutoff_accrual_subscription	base	ir.module.module	296
373	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_bank_statement_reopen_skip_undo_reconciliation	base	ir.module.module	297
374	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_qweb_element_page_visibility	base	ir.module.module	298
375	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_pivot_computed_measure	base	ir.module.module	299
376	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_fleet	base	ir.module.module	300
377	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_timeline	base	ir.module.module	301
378	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_gamification_sale_crm	base	ir.module.module	302
379	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_line_purchase_info	base	ir.module.module	303
380	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_line_menu	base	ir.module.module	304
381	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_mailing_crm_sms	base	ir.module.module	305
382	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_demand_estimate_matrix	base	ir.module.module	306
383	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_id_efaktur	base	ir.module.module	307
384	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_tax_required	base	ir.module.module	308
385	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_chart_update_l10n_eu_oss	base	ir.module.module	309
386	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_update_tax_tags	base	ir.module.module	310
387	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_fr_facturx_chorus_pro	base	ir.module.module	311
388	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_inherit	base	ir.module.module	312
389	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_tool	base	ir.module.category	72
390	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_oauth_multi_token	base	ir.module.module	313
391	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_gr	base	ir.module.module	314
392	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_status	base	ir.module.module	315
393	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_api_key_server_env	base	ir.module.module	316
394	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_fetchmail	base	ir.module.module	317
395	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_website_slides_full	base	ir.module.module	318
396	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_booth	base	ir.module.module	319
397	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_unsplash	base	ir.module.module	320
398	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_product_matrix	base	ir.module.module	321
399	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_line_price_history	base	ir.module.module	322
400	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_stock_return_request	base	ir.module.module	323
401	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_blocking	base	ir.module.module	324
402	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product	base	ir.module.module	325
403	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_filter_multi_user	base	ir.module.module	326
404	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_cutoff_base	base	ir.module.module	327
405	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_blanket_order	base	ir.module.module	328
406	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_meet_quiz	base	ir.module.module	329
407	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_tour	base	ir.module.module	330
408	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_work_entry_contract	base	ir.module.module	331
409	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_reconciliation_widget	base	ir.module.module	332
410	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_line_residual	base	ir.module.module	333
411	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_delivery_split_date	base	ir.module.module	334
412	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_skills_slides	base	ir.module.module	335
413	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_slides_survey	base	ir.module.module	336
414	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_hr_recruitment	base	ir.module.module	337
415	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_six	base	ir.module.module	338
416	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_data_module_install	base	ir.module.module	339
417	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_reports	base	ir.module.category	73
418	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_reports_qweb	base	ir.module.category	74
419	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_qweb_operating_unit	base	ir.module.module	340
420	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_global_discount	base	ir.module.module	341
421	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_asset_number	base	ir.module.module	342
422	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_mass_sending	base	ir.module.module	343
423	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_tw	base	ir.module.module	344
424	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_anglo_saxon_no_cogs_deferral	base	ir.module.module	345
425	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_generic_modules_base	base	ir.module.category	75
426	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_remote	base	ir.module.module	346
427	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_recruitment_survey	base	ir.module.module	347
428	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_server_environment_files_sample	base	ir.module.module	348
429	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_totp_mail_enforce	base	ir.module.module	349
430	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_course	base	ir.module.module	350
431	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_request	base	ir.module.module	351
432	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_work_entry	base	ir.module.module	352
433	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_fetchmail_gmail	base	ir.module.module	353
434	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_mpld3_chart	base	ir.module.module	354
435	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_supplierinfo_update	base	ir.module.module	355
436	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_in_pos	base	ir.module.module	356
437	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_base_sequence	base	ir.module.module	357
438	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_quant_manual_assign	base	ir.module.module	358
439	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_weight_volume	base	ir.module.module	359
440	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounting_localizations_website	base	ir.module.category	76
441	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_it_edi_website_sale	base	ir.module.module	360
442	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_rfq_number	base	ir.module.module	361
443	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_pwa_oca	base	ir.module.module	362
444	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_view_payment	base	ir.module.module	363
445	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_invoices_and_payments	base	ir.module.category	77
446	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_tax_balance	base	ir.module.module	364
447	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_qweb_decimal_place	base	ir.module.module	365
448	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_orderpoint_generator	base	ir.module.module	366
449	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_discount_display_amount	base	ir.module.module	367
450	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_manufacturing_purchase	base	ir.module.category	78
451	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp_subcontracting_purchase	base	ir.module.module	368
452	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_module_change_auto_install	base	ir.module.module	369
453	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_pa	base	ir.module.module	370
454	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_line_sale_info	base	ir.module.module	371
455	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_services_timesheets	base	ir.module.category	79
456	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_timesheet	base	ir.module.module	372
457	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_url_advanced	base	ir.module.module	373
458	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_purchase_workflow	base	ir.module.category	80
459	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_analytic_search	base	ir.module.module	374
460	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_portal_invoice_search_by_lot	base	ir.module.module	375
461	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_technical_features	base	ir.module.module	376
462	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_request_department	base	ir.module.module	377
463	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_request_mrp	base	ir.module.module	378
464	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_mrp	base	ir.module.module	379
465	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_apikeys	base	ir.module.module	380
466	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_forecast_line_deadline	base	ir.module.module	381
467	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_document	base	ir.module.module	382
468	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_picking_return_refund_option	base	ir.module.module	383
469	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_xlsx_export	base	ir.module.module	384
470	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_link_tracker	base	ir.module.module	385
472	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_google_calendar	base	ir.module.module	386
473	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_fiscal_position_vat_check	base	ir.module.module	387
474	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_clearing	base	ir.module.module	388
475	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_available_immediately	base	ir.module.module	389
476	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_custom_info	base	ir.module.module	390
477	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_procurement_group_hook	base	ir.module.module	391
478	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_payroll_account_operating_unit	base	ir.module.module	392
479	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_analytic_sequence	base	ir.module.module	393
480	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_rating	base	ir.module.module	394
481	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_date_range_account	base	ir.module.module	395
482	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_asset_transfer	base	ir.module.module	396
483	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_iap_mail	base	ir.module.module	397
484	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_nz	base	ir.module.module	398
485	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_address_city	base	ir.module.module	399
486	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_payumoney	base	ir.module.module	400
487	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_v12_control_menu	base	ir.module.module	401
488	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_dependency	base	ir.module.module	402
489	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_tier_validation_forward	base	ir.module.module	403
490	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_force_removal	base	ir.module.module	404
491	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_requisition_tier_validation	base	ir.module.module	405
492	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_supplier_code_purchase	base	ir.module.module	406
493	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_edi_ubl_bis3	base	ir.module.module	407
494	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_analytic_accounting	base	ir.module.category	82
495	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_analytic_required	base	ir.module.module	408
496	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_requisition_stock	base	ir.module.module	409
497	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_xlsx	base	ir.module.module	410
498	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_partner_analytic	base	ir.module.module	411
499	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_approval_block	base	ir.module.module	412
500	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_mass_mailing	base	ir.module.module	413
501	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ch	base	ir.module.module	414
502	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_account_sale	base	ir.module.category	83
503	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_account_sale_timesheet	base	ir.module.category	84
504	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_sale_timesheet	base	ir.module.module	415
505	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_users_ldap_groups	base	ir.module.module	416
506	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_merge	base	ir.module.module	417
507	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_generic_modules_accounting	base	ir.module.category	85
508	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_line_description	base	ir.module.module	418
509	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_association	base	ir.module.module	419
510	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_wkhtmltopdf_param	base	ir.module.module	420
511	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_contract_reference	base	ir.module.module	421
512	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_scheduler_error_mailer	base	ir.module.module	422
513	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_partner_autocomplete	base	ir.module.module	423
514	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_dz	base	ir.module.module	424
515	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_mass_reconcile	base	ir.module.module	425
516	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_ir_actions_act_view_reload	base	ir.module.module	426
517	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_milestone	base	ir.module.module	427
518	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website	base	ir.module.module	428
519	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_mimetypes	base	ir.module.module	429
520	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_timesheet_margin	base	ir.module.module	430
521	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_skills	base	ir.module.module	431
522	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_line_stock_info	base	ir.module.module	432
523	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_mail	base	ir.module.module	433
524	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_remember_tree_column_width	base	ir.module.module	434
525	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_external_dbsource_mssql	base	ir.module.module	435
526	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_archive_date	base	ir.module.module	436
527	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_refund_line_selection	base	ir.module.module	437
528	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_list	base	ir.module.module	438
529	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_event_sms	base	ir.module.module	439
530	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_stock_product_set	base	ir.module.module	440
531	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_lint	base	ir.module.module	441
532	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_price_recalculation	base	ir.module.module	442
533	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_html_text	base	ir.module.module	443
534	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_server_environment	base	ir.module.module	444
535	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_asset_compute_batch	base	ir.module.module	445
536	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_dropdown_dynamic	base	ir.module.module	446
537	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_print	base	ir.module.module	447
538	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_api_key	base	ir.module.module	448
539	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_ldap	base	ir.module.module	449
540	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_gift_card	base	ir.module.module	450
541	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_revision	base	ir.module.module	451
542	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_crm_iap_enrich	base	ir.module.module	452
543	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_available	base	ir.module.module	453
544	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_eg	base	ir.module.module	454
545	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_generic_modules_purchase	base	ir.module.category	86
546	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_exception	base	ir.module.module	455
547	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_requisition_operating_unit	base	ir.module.module	456
548	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_nl	base	ir.module.module	457
549	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_exhibitor	base	ir.module.module	458
550	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mis_builder_budget	base	ir.module.module	459
551	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_pricelist_sale	base	ir.module.module	460
552	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_restaurant	base	ir.module.module	461
553	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_productivity_notes	base	ir.module.category	87
554	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_note_pad	base	ir.module.module	462
555	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_stock_wishlist	base	ir.module.module	463
556	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_receipt_expectation_manual_split	base	ir.module.module	464
557	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp_subcontracting	base	ir.module.module	465
558	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_translation_field_label	base	ir.module.module	466
559	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_at	base	ir.module.module	467
560	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_uk	base	ir.module.module	468
561	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_journal_general_sequence	base	ir.module.module	469
562	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_payment_widget_amount	base	ir.module.module	470
563	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_original_partner	base	ir.module.module	471
564	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_dk	base	ir.module.module	472
565	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_id	base	ir.module.module	473
566	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_totp_portal	base	ir.module.module	474
567	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_cz	base	ir.module.module	475
568	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_dropshipping	base	ir.module.module	476
569	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_fiscal_month	base	ir.module.module	477
570	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_substate	base	ir.module.module	478
571	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_transfer	base	ir.module.module	479
572	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_de_purchase	base	ir.module.module	480
573	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_crm_tag	base	ir.module.module	481
574	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_purchase	base	ir.module.module	482
575	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_substate	base	ir.module.module	483
576	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_tier_validation	base	ir.module.module	484
577	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_auth_custom	base	ir.module.module	485
578	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_stock_margin	base	ir.module.module	486
579	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_mass_mailing	base	ir.module.module	487
580	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_operating_unit	base	ir.module.module	488
581	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_warehouse_calendar	base	ir.module.module	489
582	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_track_live_quiz	base	ir.module.module	490
583	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_fixed_discount	base	ir.module.module	491
584	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_inventory	base	ir.module.module	492
585	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_procurements	base	ir.module.category	88
586	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_procurement_purchase_no_grouping	base	ir.module.module	493
587	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_move_purchase_price_update	base	ir.module.module	494
588	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_maintenance	base	ir.module.category	89
589	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_remove_odoo_enterprise	base	ir.module.module	495
590	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_financial_report_operating_unit	base	ir.module.module	496
591	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_bokeh_chart	base	ir.module.module	497
592	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_changeset	base	ir.module.module	498
593	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_payment	base	ir.module.module	499
594	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_timesheet_holidays	base	ir.module.module	500
595	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_data_module	base	ir.module.module	501
596	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_relative	base	ir.module.module	502
597	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_representative	base	ir.module.module	503
598	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_orderpoint_purchase_link	base	ir.module.module	504
599	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_fetchmail_notify_error_to_sender	base	ir.module.module	505
600	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_us	base	ir.module.module	506
601	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_mail_group	base	ir.module.module	507
602	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_limits	base	ir.module.module	508
603	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_general_discount	base	ir.module.module	509
604	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_gov_work_acceptance	base	ir.module.module	510
605	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_gov_purchase_guarantee	base	ir.module.module	511
606	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_account_edi_ubl_cii_tests	base	ir.module.module	512
607	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_crm	base	ir.module.module	513
608	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_user_role	base	ir.module.module	514
609	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mail_environment_google_gmail	base	ir.module.module	515
610	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_repair	base	ir.module.module	516
611	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_add_very_high	base	ir.module.module	517
612	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_restrict_linked_so	base	ir.module.module	518
613	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_bus	base	ir.module.module	519
614	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_supplierinfo_qty_multiplier	base	ir.module.module	520
615	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_fiscal_year	base	ir.module.module	521
616	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mail_group	base	ir.module.module	522
617	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_check_printing	base	ir.module.module	523
618	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_stock_product_configurator	base	ir.module.module	524
619	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_mail_plugin	base	ir.module.module	525
620	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_sips	base	ir.module.module	526
621	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_in_stock	base	ir.module.module	527
622	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hw_drivers	base	ir.module.module	528
623	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_inventory_count_to_zero	base	ir.module.module	529
624	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_partner_selectable_option	base	ir.module.module	530
625	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_contract_multi_job	base	ir.module.module	531
626	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_edi_ubl	base	ir.module.module	532
627	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_point_of_sale	base	ir.module.module	533
628	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_wbs	base	ir.module.module	534
629	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_mercury	base	ir.module.module	535
630	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_snailmail	base	ir.module.module	536
631	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_timesheet	base	ir.module.module	537
632	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_route_profile	base	ir.module.module	538
633	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_productivity_discuss	base	ir.module.category	90
634	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mail	base	ir.module.module	539
635	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_operating_unit_access_all	base	ir.module.module	540
636	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_contract_operating_unit	base	ir.module.module	541
637	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_reserve_rule	base	ir.module.module	542
638	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_budget	base	ir.module.module	543
639	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sequence_reset_period	base	ir.module.module	544
640	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_total_ordered_qty	base	ir.module.module	545
641	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_session_db	base	ir.module.module	546
642	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_supplier_ref_unique	base	ir.module.module	547
643	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_pt	base	ir.module.module	548
644	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_financial_management	base	ir.module.category	91
645	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_financial_management_configuration	base	ir.module.category	92
646	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_currency_rate_update_TH_BOT	base	ir.module.module	549
647	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_discount_date	base	ir.module.module	550
648	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_location_by_line	base	ir.module.module	551
649	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_mailing_sale	base	ir.module.module	552
650	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_date_due	base	ir.module.module	553
651	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_mailing_event	base	ir.module.module	554
652	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_stock_picking_return_invoicing	base	ir.module.module	555
653	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_tier_validation_forward	base	ir.module.module	556
654	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_work_acceptance_tier_validation	base	ir.module.module	557
655	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_location_lockdown	base	ir.module.module	558
656	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_update_analytic	base	ir.module.module	559
657	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounting_localizations_reporting	base	ir.module.category	93
658	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_fr_fec	base	ir.module.module	560
659	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_invoicing_grouping_criteria	base	ir.module.module	561
660	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_sequence	base	ir.module.module	562
661	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_asset_operating_unit	base	ir.module.module	563
662	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_password_policy	base	ir.module.module	564
663	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_mailing_event_track_sms	base	ir.module.module	565
664	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_cron_exclusion	base	ir.module.module	566
665	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_product_merge	base	ir.module.module	567
666	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_paypal	base	ir.module.module	568
667	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_remove_mobile_link	base	ir.module.module	569
668	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_refund_link	base	ir.module.module	570
669	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_sale_margin	base	ir.module.module	571
670	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_my	base	ir.module.module	572
671	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_product_matrix	base	ir.module.module	573
672	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_gcc_pos	base	ir.module.module	574
673	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_putaway_product_template	base	ir.module.module	575
674	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sales_team	base	ir.module.module	576
675	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_operating_unit_access_all	base	ir.module.module	577
676	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_role	base	ir.module.module	578
677	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_force_invoiced	base	ir.module.module	579
678	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_journal	base	ir.module.module	580
679	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_supplier_calendar	base	ir.module.module	581
680	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_productivity_calendar	base	ir.module.category	94
681	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_calendar	base	ir.module.module	582
682	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_name_sequence	base	ir.module.module	583
683	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_de_sale	base	ir.module.module	584
684	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_google_recaptcha	base	ir.module.module	585
685	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_move_purchase_uom	base	ir.module.module	586
686	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_group_expand	base	ir.module.module	587
687	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_responsive	base	ir.module.module	588
688	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_stock_operating_unit	base	ir.module.module	589
689	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_line_refund_to_invoice_qty_skip_anglo_saxon	base	ir.module.module	590
690	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_attachment_indexation	base	ir.module.module	591
691	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_fr_pos_cert	base	ir.module.module	592
692	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_purchase_stock	base	ir.module.module	593
693	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_request_substate	base	ir.module.module	594
694	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_analytic_partner	base	ir.module.module	595
695	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_password_security	base	ir.module.module	596
696	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_request_cancel_confirm	base	ir.module.module	597
697	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_do	base	ir.module.module	598
698	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_request_tier_validation	base	ir.module.module	599
699	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_crm_operating_unit	base	ir.module.module	600
700	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_drop_target	base	ir.module.module	601
701	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_track_live	base	ir.module.module	602
702	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_sk	base	ir.module.module	603
703	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_oauth	base	ir.module.module	604
704	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_line_menu	base	ir.module.module	605
705	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_external_system	base	ir.module.module	606
706	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_account_tax_report	base	ir.module.module	607
707	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_no_zero_price	base	ir.module.module	608
708	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_tier_validation_report	base	ir.module.module	609
709	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounting_payment	base	ir.module.category	95
710	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_qr_code_sepa	base	ir.module.module	610
711	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_sms	base	ir.module.module	611
712	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_quant_cost_info	base	ir.module.module	612
713	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_search_panel	base	ir.module.module	613
714	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_gcc_invoice	base	ir.module.module	614
715	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_uninvoiced_amount_force_invoiced_line	base	ir.module.module	615
716	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_server_environment_ir_config_parameter	base	ir.module.module	616
717	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_department_code	base	ir.module.module	617
718	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_date_range	base	ir.module.module	618
719	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_de_repair	base	ir.module.module	619
720	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_microsoft_outlook	base	ir.module.module	620
721	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_operating_unit	base	ir.module.module	621
722	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_signup_verify_email	base	ir.module.module	622
723	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_warn_message	base	ir.module.module	623
724	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_blog	base	ir.module.module	624
725	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_api_key_group	base	ir.module.module	625
726	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_operating_unit_access_all	base	ir.module.module	626
727	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_syscohada	base	ir.module.module	627
728	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_account_no_auto_reconcile	base	ir.module.module	628
729	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_tax_note	base	ir.module.module	629
730	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_fi	base	ir.module.module	630
731	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mail_plugin	base	ir.module.module	631
732	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_invoicing_date_selection	base	ir.module.module	632
733	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_invoice	base	ir.module.module	633
734	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_type	base	ir.module.module	634
735	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_tier_validation	base	ir.module.module	635
736	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_branch	base	ir.module.module	636
737	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_journal_lock_date	base	ir.module.module	637
738	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_product_configurator	base	ir.module.module	638
739	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_comment_template	base	ir.module.module	639
740	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_refund_reason	base	ir.module.module	640
741	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_calendar_planning	base	ir.module.module	641
742	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_manufacturing_maintenance	base	ir.module.category	96
743	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_maintenance	base	ir.module.module	642
744	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_gift_card	base	ir.module.module	643
745	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_au	base	ir.module.module	644
746	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_warn_option	base	ir.module.module	645
747	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_service	base	ir.module.module	646
748	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_uninvoiced_amount_line	base	ir.module.module	647
749	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_edi_facturx	base	ir.module.module	648
750	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_crm_mail_plugin	base	ir.module.module	649
751	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_line_deep_sort	base	ir.module.module	650
752	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounting_localizations_sale	base	ir.module.category	97
753	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_in_sale_stock	base	ir.module.module	651
754	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_crm_sms	base	ir.module.module	652
755	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_partner_incoterm	base	ir.module.module	653
756	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_iap_alternative_provider	base	ir.module.module	654
757	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_age	base	ir.module.module	655
758	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_request_exception	base	ir.module.module	656
759	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_timesheet_invoice_description	base	ir.module.module	657
760	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp_operating_unit_access_all	base	ir.module.module	658
761	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_report	base	ir.module.category	98
762	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_fonts	base	ir.module.module	659
763	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_human_resources_recruitment	base	ir.module.category	99
764	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_recruitment	base	ir.module.module	660
765	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_cancel_confirm	base	ir.module.module	661
766	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_financial_report	base	ir.module.module	662
767	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_usability	base	ir.module.module	663
768	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_product_recommendation_xlsx	base	ir.module.module	664
769	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_invoicing	base	ir.module.category	100
770	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_search_by_reference	base	ir.module.module	665
771	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_si	base	ir.module.module	666
772	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_lock_to_date	base	ir.module.module	667
773	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_payment	base	ir.module.module	668
774	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_tree_many2one_clickable	base	ir.module.module	669
775	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_stripe	base	ir.module.module	670
776	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_fleet	base	ir.module.module	671
777	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_translation_import	base	ir.module.module	672
778	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_tr	base	ir.module.module	673
779	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_ir_actions_act_multi	base	ir.module.module	674
780	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_cancel_confirm	base	ir.module.module	675
781	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_gov_account_asset_management	base	ir.module.module	676
782	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_pl	base	ir.module.module	677
783	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_inherit_depends	base	ir.module.module	678
784	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_partner_statement	base	ir.module.module	679
785	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_fiscal_month	base	ir.module.module	680
786	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_vault	base	ir.module.category	101
787	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_vault_share	base	ir.module.module	681
788	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_code	base	ir.module.module	682
789	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_receipt_send	base	ir.module.module	683
790	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_search_with_and	base	ir.module.module	684
791	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_asset_transfer_operating_unit	base	ir.module.module	685
792	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_google_gmail	base	ir.module.module	686
793	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_monitoring	base	ir.module.module	687
794	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_child_selector	base	ir.module.module	688
795	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_numeric_step	base	ir.module.module	689
796	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_block_payment	base	ir.module.module	690
797	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_pull_request	base	ir.module.module	691
798	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_line_stock_available	base	ir.module.module	692
799	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_calendar_sms	base	ir.module.module	693
800	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_operating_unit	base	ir.module.module	694
801	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_portal_odoo_debranding	base	ir.module.module	695
802	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_setup	base	ir.module.module	696
803	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_epson_printer_restaurant	base	ir.module.module	697
804	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_firstname	base	ir.module.module	698
805	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_order_invoicing_grouping_criteria	base	ir.module.module	699
806	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_security	base	ir.module.module	700
807	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_chart_update	base	ir.module.module	701
808	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_event_sale	base	ir.module.module	702
809	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_line_original_date	base	ir.module.module	703
810	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ro	base	ir.module.module	704
811	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mail_environment	base	ir.module.module	705
812	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_org_chart_overview	base	ir.module.module	706
813	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_adyen	base	ir.module.module	707
814	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_server_ux	base	ir.module.category	102
815	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_announcement	base	ir.module.module	708
816	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_request_tier_validation	base	ir.module.module	709
817	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_advance_overdue_reminder	base	ir.module.module	710
818	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_request_operating_unit	base	ir.module.module	711
819	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_fr	base	ir.module.module	712
820	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_gov_purchase_report	base	ir.module.module	713
821	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_exception	base	ir.module.module	714
822	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_company_color	base	ir.module.module	715
823	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_user_log_view	base	ir.module.module	716
824	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_mailing_crm	base	ir.module.module	717
825	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_il	base	ir.module.module	718
826	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_localization___tools	base	ir.module.category	103
827	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_tier_department_demo	base	ir.module.module	719
828	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_operating_unit_access_all	base	ir.module.module	720
829	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_cn_city	base	ir.module.module	721
830	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mail_bot_hr	base	ir.module.module	722
831	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_external_dbsource	base	ir.module.module	723
832	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_multi_step_wizard	base	ir.module.module	724
833	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_search_custom_field_filter	base	ir.module.module	725
834	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_account_tax_inter_company	base	ir.module.module	726
835	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_mis_report	base	ir.module.module	727
836	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_request_bom	base	ir.module.module	728
837	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_crm_livechat	base	ir.module.module	729
838	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_google_spreadsheet	base	ir.module.module	730
839	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ke	base	ir.module.module	731
840	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_external_dbsource_sqlite	base	ir.module.module	732
841	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_event_full	base	ir.module.module	733
842	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_ssn	base	ir.module.module	734
843	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_async	base	ir.module.module	735
844	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pad_project	base	ir.module.module	736
845	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_invoice_plan	base	ir.module.module	737
846	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_qweb_pdf_watermark	base	ir.module.module	738
847	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_technical	base	ir.module.category	104
848	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_time_parameter	base	ir.module.module	739
849	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_crm_partner_assign	base	ir.module.module	740
850	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounting_	base	ir.module.category	105
851	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounting___payment	base	ir.module.category	106
852	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_promptpay	base	ir.module.module	741
853	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_ogone	base	ir.module.module	742
854	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_others	base	ir.module.category	107
855	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_model_restrict_update	base	ir.module.module	743
856	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_request_to_requisition	base	ir.module.module	744
857	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_dialog_size	base	ir.module.module	745
858	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_warn_option	base	ir.module.module	746
859	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_performance	base	ir.module.module	747
860	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_image_download	base	ir.module.module	748
861	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_menu_visibility_restriction	base	ir.module.module	749
862	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_picking_orig_dest_link	base	ir.module.module	750
863	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_job_category	base	ir.module.module	751
864	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_in_sale	base	ir.module.module	752
865	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_exception	base	ir.module.module	753
866	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mis_template_financial_report	base	ir.module.module	754
867	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_archive_constraint	base	ir.module.module	755
868	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_contract_operating_unit	base	ir.module.module	756
869	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_duplicate_security_group	base	ir.module.module	757
870	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_sg	base	ir.module.module	758
871	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_order_whole_delivered_invoiceability	base	ir.module.module	759
872	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_force_number	base	ir.module.module	760
873	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_product_recommendation_secondary_unit	base	ir.module.module	761
874	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_product_configurator	base	ir.module.module	762
875	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_contract_employee_calendar_planning	base	ir.module.module	763
876	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_qty_change_no_recompute	base	ir.module.module	764
877	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_inventory_delivery	base	ir.module.category	108
878	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_delivery	base	ir.module.module	765
879	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mis_builder_cash_flow	base	ir.module.module	766
880	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_kanban_stage	base	ir.module.module	767
1367	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_avatar_mixin	base	ir.model	76
881	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_triple_discount	base	ir.module.module	768
882	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_it	base	ir.module.module	769
883	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_operating_unit_access_all	base	ir.module.module	770
884	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_delivery	base	ir.module.module	771
885	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_localization_asia	base	ir.module.category	109
886	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_partner	base	ir.module.module	772
887	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_check_total	base	ir.module.module	773
888	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_gamification	base	ir.module.module	774
889	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_available_mrp	base	ir.module.module	775
890	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_analytic_parent	base	ir.module.module	776
891	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_personal_stage_auto_fold	base	ir.module.module	777
892	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_cost_center	base	ir.module.module	778
893	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_inventory_verification_request	base	ir.module.module	779
894	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_analytic_operating_unit	base	ir.module.module	780
895	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_http_routing	base	ir.module.module	781
896	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_cr	base	ir.module.module	782
897	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_portal	base	ir.module.module	783
898	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ca	base	ir.module.module	784
899	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_discuss_full	base	ir.module.module	785
900	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_reception_notify	base	ir.module.module	786
901	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_sa_pos	base	ir.module.module	787
902	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_check_picking_date	base	ir.module.module	788
903	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_tree_currency	base	ir.module.module	789
904	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_latam_base	base	ir.module.module	790
905	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_hr	base	ir.module.module	791
906	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_et	base	ir.module.module	792
907	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_fully_invoiced	base	ir.module.module	793
908	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_receipt_journal	base	ir.module.module	794
909	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_vn	base	ir.module.module	795
910	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_hr	base	ir.module.module	796
911	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_form_purchase_link	base	ir.module.module	797
912	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_secondary_unit	base	ir.module.module	798
913	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ph	base	ir.module.module	799
914	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_m2x_options_manager	base	ir.module.module	800
915	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_description_template	base	ir.module.module	801
916	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_duplicate_subtask	base	ir.module.module	802
917	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_excel_export_dynamic_expand	base	ir.module.module	803
918	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_search_supplierinfo_code	base	ir.module.module	804
919	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_sequence_option	base	ir.module.module	805
920	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_booth_sale_exhibitor	base	ir.module.module	806
921	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_multilang	base	ir.module.module	807
922	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ke_edi_tremol	base	ir.module.module	808
923	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_work_acceptance_invoice_plan	base	ir.module.module	809
924	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_mts_mto_rule	base	ir.module.module	810
925	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_move_location_purchase_uom	base	ir.module.module	811
926	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_multi_branch_company	base	ir.module.module	812
927	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_default_terms_conditions	base	ir.module.module	813
928	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_available_unreserved	base	ir.module.module	814
929	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_lu_peppol_id	base	ir.module.module	815
930	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_stage_state	base	ir.module.module	816
931	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_timeline	base	ir.module.module	817
932	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_password_policy_portal	base	ir.module.module	818
933	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_excel_import_export_demo	base	ir.module.module	819
934	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_line_tax_editable	base	ir.module.module	820
935	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_account	base	ir.module.module	821
936	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_requisition_grouped_by_procurement	base	ir.module.module	822
937	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_work_acceptance_evaluation	base	ir.module.module	823
938	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_generic_modules_projects_and_services	base	ir.module.category	110
939	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_department	base	ir.module.module	824
940	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_personal_equipment_request	base	ir.module.module	825
941	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_cn	base	ir.module.module	826
942	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_partner_invoicing_mode_at_shipping	base	ir.module.module	827
943	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_qweb_encrypt	base	ir.module.module	828
944	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_crm_sms	base	ir.module.module	829
945	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_action_conditionable	base	ir.module.module	830
946	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_cache	base	ir.module.module	831
947	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_assetsbundle	base	ir.module.module	832
948	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_reserve	base	ir.module.module	833
949	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_maturity_date_default	base	ir.module.module	834
950	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_marketing_email_marketing	base	ir.module.category	111
951	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_mailing	base	ir.module.module	835
952	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_twitter	base	ir.module.module	836
953	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_testing_utilities	base	ir.module.module	837
954	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_images	base	ir.module.module	838
955	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp_product_expiry	base	ir.module.module	839
956	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_signup	base	ir.module.module	840
957	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_fop_shipping	base	ir.module.module	841
958	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_mailing_slides	base	ir.module.module	842
959	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_stock	base	ir.module.module	843
960	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_domain_editor_dialog	base	ir.module.module	844
961	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_fetchmail_incoming_log	base	ir.module.module	845
962	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_board_eval_context	base	ir.module.module	846
963	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_csv	base	ir.module.module	847
964	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_timesheet_attendance	base	ir.module.module	848
965	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_gt	base	ir.module.module	849
966	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_delivery_mondialrelay	base	ir.module.module	850
967	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_netting	base	ir.module.module	851
968	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_tier_validation_formula	base	ir.module.module	852
969	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp	base	ir.module.module	853
970	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_deposit	base	ir.module.module	854
971	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_receipt_percentage	base	ir.module.module	855
972	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_cycle_count	base	ir.module.module	856
973	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_jwt	base	ir.module.module	857
974	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_move_location	base	ir.module.module	858
975	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_worked_days_from_timesheet	base	ir.module.module	859
976	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_invoice_status_line	base	ir.module.module	860
977	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_cancel_confirm	base	ir.module.module	861
978	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_human_resources_payroll	base	ir.module.category	112
979	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_work_entry_holidays	base	ir.module.module	862
980	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_cutoff_start_end_dates	base	ir.module.module	863
981	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_partner_reconcile	base	ir.module.module	864
982	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_delivery_mondialrelay	base	ir.module.module	865
983	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_reconciliation_widget_due_date	base	ir.module.module	866
984	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_sa_invoice	base	ir.module.module	867
985	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_de_skr04	base	ir.module.module	868
986	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_work_acceptance	base	ir.module.module	869
987	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_multicurrency_revaluation	base	ir.module.module	870
988	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auto_backup	base	ir.module.module	871
989	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_iap_crm	base	ir.module.module	872
990	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_payulatam	base	ir.module.module	873
991	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_reception_status_line	base	ir.module.module	874
992	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_be	base	ir.module.module	875
993	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_requisition	base	ir.module.module	876
994	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_request_separate_picking	base	ir.module.module	877
995	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_request_kanban	base	ir.module.module	878
996	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_membership	base	ir.module.module	879
997	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_personalization	base	ir.module.category	113
998	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_export_manager	base	ir.module.module	880
999	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_warn_option	base	ir.module.module	881
1000	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_exceptions	base	ir.module.module	882
1001	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_receipt_expectation_manual	base	ir.module.module	883
1002	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_note	base	ir.module.module	884
1003	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_send_message_popup	base	ir.module.module	885
1004	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_external_dbsource_sap_hana	base	ir.module.module	886
1005	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_free_quantity	base	ir.module.module	887
1006	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_analytic_base_department	base	ir.module.module	888
1007	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp_subcontracting_dropshipping	base	ir.module.module	889
1008	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_gift_card	base	ir.module.module	890
1009	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_line_qty_to_receive	base	ir.module.module	891
1010	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_hide_user_menu_item	base	ir.module.module	892
1011	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_post_block	base	ir.module.module	893
1012	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_custom_rounding	base	ir.module.module	894
1013	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_automation	base	ir.module.module	895
1014	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_cancel	base	ir.module.module	896
1015	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_test	base	ir.module.module	897
1016	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_pay_to_vendor	base	ir.module.module	898
1017	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_sequence_option	base	ir.module.module	899
1018	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_migration	base	ir.module.category	114
1019	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_upgrade_analysis	base	ir.module.module	900
1020	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_passport_expiration	base	ir.module.module	901
1021	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_copy_confirm	base	ir.module.module	902
1022	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_iban	base	ir.module.module	903
1023	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_booth_sale	base	ir.module.module	904
1024	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_template_milestone	base	ir.module.module	905
1025	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_generic_modules_account	base	ir.module.category	115
1026	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_exception	base	ir.module.module	906
1027	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_template	base	ir.module.module	907
1028	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web	base	ir.module.module	908
1029	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_crm_livechat	base	ir.module.module	909
1030	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_adyen	base	ir.module.module	910
1031	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_accounts	base	ir.module.category	116
1032	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_tier_validation	base	ir.module.module	911
1033	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_analytic	base	ir.module.module	912
1034	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_import_match	base	ir.module.module	913
1035	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_domain_field	base	ir.module.module	914
1036	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_module_auto_update	base	ir.module.module	915
1037	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_section_sale_order	base	ir.module.module	916
1038	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_id	base	ir.module.module	917
1039	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_chained_swapper	base	ir.module.module	918
1040	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_html_image_url_extractor	base	ir.module.module	919
1041	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_phone_validation	base	ir.module.module	920
1042	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_address_extended	base	ir.module.module	921
1043	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_payment_term_date_due	base	ir.module.module	922
1044	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_fr_invoice_addr	base	ir.module.module	923
1045	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment	base	ir.module.module	924
1046	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_helper	base	ir.module.module	925
1047	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_advance_payment	base	ir.module.module	926
1048	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_questions	base	ir.module.module	927
1049	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_crm	base	ir.module.module	928
1050	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_report_py3o	base	ir.module.module	929
1051	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_sale_order_link	base	ir.module.module	930
1052	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_constraint_chronology	base	ir.module.module	931
1053	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_hk	base	ir.module.module	932
1054	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_fontawesome	base	ir.module.module	933
1055	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_fi_sale	base	ir.module.module	934
1056	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mis_builder	base	ir.module.module	935
1057	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_quant_reservation_info_mrp	base	ir.module.module	936
1058	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_reversal_choose_method	base	ir.module.module	937
1059	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_tier_validation	base	ir.module.module	938
1060	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_stock_price_unit_sync	base	ir.module.module	939
1061	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_start_end_dates	base	ir.module.module	940
1062	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_analytic	base	ir.module.module	941
1063	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_kanban_gauge	base	ir.module.module	942
1064	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_product_recommendation	base	ir.module.module	943
1065	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_test	base	ir.module.module	944
1066	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_margin	base	ir.module.module	945
1067	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_hn	base	ir.module.module	946
1068	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_es	base	ir.module.module	947
1069	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_inventory_discrepancy	base	ir.module.module	948
1070	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_fiscal_year	base	ir.module.module	949
1071	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_product_recommendation_classification	base	ir.module.module	950
1072	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_account_tax_multi	base	ir.module.module	951
1073	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_mrp	base	ir.module.module	952
1074	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_coupon	base	ir.module.module	953
1075	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_birth_name	base	ir.module.module	954
1076	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_sequence_option	base	ir.module.module	955
1077	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_holidays_settings	base	ir.module.module	956
1078	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_mailing_sms	base	ir.module.module	957
1079	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_contacts	base	ir.module.module	958
1080	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_rs	base	ir.module.module	959
1081	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ua	base	ir.module.module	960
1082	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_latam_invoice_document	base	ir.module.module	961
1083	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_invoicing_management	base	ir.module.category	117
1084	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_portal_hide_invoice	base	ir.module.module	962
1085	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_triple_discount	base	ir.module.module	963
1086	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_google_map	base	ir.module.module	964
1087	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_sale_product_configurator	base	ir.module.module	965
1088	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mrp_analytic	base	ir.module.module	966
1089	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hw_l10n_eg_eta	base	ir.module.module	967
1090	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_forecast_line_holidays_public	base	ir.module.module	968
1091	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_mx	base	ir.module.module	969
1092	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_payment_mollie	base	ir.module.module	970
1093	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_user_locale	base	ir.module.module	971
1094	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_slides	base	ir.module.module	972
1095	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_cl	base	ir.module.module	973
1096	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_disable_export_group	base	ir.module.module	974
1097	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_analytic_operating_unit_access_all	base	ir.module.module	975
1098	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_picking_invoicing_incoterm	base	ir.module.module	976
1099	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_stage_mgmt	base	ir.module.module	977
1100	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sms	base	ir.module.module	978
1101	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_barcodes	base	ir.module.module	979
1102	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_tests	base	ir.module.category	118
1103	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_populate	base	ir.module.module	980
1104	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_sparse_field	base	ir.module.module	981
1105	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_base_automation	base	ir.module.module	982
1106	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_comparison	base	ir.module.module	983
1107	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_kpi_dashboard	base	ir.module.module	984
1108	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_new_api	base	ir.module.module	985
1109	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_multi_image	base	ir.module.module	986
1110	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_human_resources_time_off	base	ir.module.category	119
1111	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_holidays	base	ir.module.module	987
1112	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_co	base	ir.module.module	988
1113	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_default_stage	base	ir.module.module	989
1114	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_request_analytic	base	ir.module.module	990
1115	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_advance_clearing	base	ir.module.module	991
1116	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_sequence	base	ir.module.module	992
1117	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mail_bot	base	ir.module.module	993
1118	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_requisition_order_remaining_qty	base	ir.module.module	994
1119	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_matrix	base	ir.module.module	995
1120	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_procurement_auto_create_group	base	ir.module.module	996
1121	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_services_expenses	base	ir.module.category	120
1122	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_hr_expense	base	ir.module.module	997
1123	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_announcement	base	ir.module.module	998
1124	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_im_livechat_mail_bot	base	ir.module.module	999
1125	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_chart_update_l10n_eu_oss_oca	base	ir.module.module	1000
1126	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_services_account	base	ir.module.category	121
1127	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_account	base	ir.module.module	1001
1128	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_bank_payment_export	base	ir.module.module	1002
1129	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_widget_text_markdown	base	ir.module.module	1003
1130	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_reconcile_payment_order	base	ir.module.module	1004
1131	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_form_project	base	ir.module.module	1005
1132	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_board	base	ir.module.module	1006
1133	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_analytic_tag_dimension	base	ir.module.module	1007
1134	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_saml_environment	base	ir.module.module	1008
1135	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_barcode_action	base	ir.module.module	1009
1136	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_bg	base	ir.module.module	1010
1137	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_partner_external	base	ir.module.module	1011
1138	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_google_drive	base	ir.module.module	1012
1139	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_sa_edi	base	ir.module.module	1013
1140	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_slides	base	ir.module.module	1014
1141	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_line_repair_info	base	ir.module.module	1015
1142	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_reception_status	base	ir.module.module	1016
1143	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_digital	base	ir.module.module	1017
1144	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_subcontracted_service	base	ir.module.module	1018
1145	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_website_live_chat	base	ir.module.category	122
1146	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_im_livechat	base	ir.module.module	1019
1147	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_landed_costs	base	ir.module.module	1020
1148	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_org_chart	base	ir.module.module	1021
1149	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_template_content_swapper	base	ir.module.module	1022
1150	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ar_website_sale	base	ir.module.module	1023
1151	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_orderpoint_move_link	base	ir.module.module	1024
1152	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_operating_unit_access_all	base	ir.module.module	1025
1153	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_it_edi	base	ir.module.module	1026
1154	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_mailing_event_sms	base	ir.module.module	1027
1155	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_stock	base	ir.module.module	1028
1156	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_expense_tax_adjust	base	ir.module.module	1029
1157	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_convert	base	ir.module.module	1030
1158	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_crm_iap_reveal	base	ir.module.module	1031
1159	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_sale	base	ir.module.module	1032
1160	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_jsonifier	base	ir.module.module	1033
1161	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_utm	base	ir.module.module	1034
1162	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_order_invoicing_qty_percentage	base	ir.module.module	1035
1163	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_human_resources_contracts	base	ir.module.category	123
1164	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_contract	base	ir.module.module	1036
1165	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_saml	base	ir.module.module	1037
1166	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_stock_operating_unit	base	ir.module.module	1038
1167	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_view_inheritance_extension	base	ir.module.module	1039
1168	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_profile	base	ir.module.module	1040
1169	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_partner	base	ir.module.module	1041
1170	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_merge	base	ir.module.module	1042
1171	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_project_account	base	ir.module.module	1043
1172	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_manual_currency	base	ir.module.module	1044
1173	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_valuation_layer_accounting_date	base	ir.module.module	1045
1174	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_links	base	ir.module.module	1046
1175	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_converter	base	ir.module.module	1047
1176	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_move_template	base	ir.module.module	1048
1177	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_website	base	ir.module.module	1049
1178	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_inherits_depends	base	ir.module.module	1050
1179	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_emergency_contact	base	ir.module.module	1051
1180	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_localization___human_resources	base	ir.module.category	124
1181	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_gov_hr_expense	base	ir.module.module	1052
1182	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_crm	base	ir.module.module	1053
1183	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_inventory_lockdown	base	ir.module.module	1054
1184	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_microsoft_calendar	base	ir.module.module	1055
1185	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_membership	base	ir.module.module	1056
1186	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_filter_header_button	base	ir.module.module	1057
1187	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_forecast_line_bokeh_chart	base	ir.module.module	1058
1188	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_tier_validation_server_action	base	ir.module.module	1059
1189	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_action_bindings	base	ir.module.module	1060
1190	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_select_all_companies	base	ir.module.module	1061
1191	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_mailing_event_track	base	ir.module.module	1062
1192	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_invoice_method	base	ir.module.module	1063
1193	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_lot_filter_available	base	ir.module.module	1064
1194	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_forum	base	ir.module.module	1065
1195	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_account_wht_cert_form	base	ir.module.module	1066
1196	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sql_request_abstract	base	ir.module.module	1067
1197	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_attachment_unindex_content	base	ir.module.module	1068
1198	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_spread_cost_revenue	base	ir.module.module	1069
1199	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_vat	base	ir.module.module	1070
1200	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_localisation	base	ir.module.category	125
1201	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_localisation_asia	base	ir.module.category	126
1202	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_base_location	base	ir.module.module	1071
1203	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_quick	base	ir.module.module	1072
1204	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_signup_partner_company	base	ir.module.module	1073
1205	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_in	base	ir.module.module	1074
1206	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_geolocalize	base	ir.module.module	1075
1207	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_category_point_of_sale,_accounting	base	ir.module.category	127
1208	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_pos_analytic_by_config	base	ir.module.module	1076
1209	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_expense	base	ir.module.module	1077
1210	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_maintenance	base	ir.module.module	1078
1211	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mis_builder_operating_unit	base	ir.module.module	1079
1212	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_order_type_whole_delivered_invoiceability	base	ir.module.module	1080
1213	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_transifex	base	ir.module.module	1081
1214	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_stock_request	base	ir.module.module	1082
1215	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_database_cleanup	base	ir.module.module	1083
1216	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_notify	base	ir.module.module	1084
1217	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_digest	base	ir.module.module	1085
1218	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_multicurrency_revaluation	base	ir.module.module	1086
1219	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_task_note	base	ir.module.module	1087
1220	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_mrp_margin	base	ir.module.module	1088
1221	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_external_dbsource_mysql	base	ir.module.module	1089
1222	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_phone_extension	base	ir.module.module	1090
1223	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale_coupon	base	ir.module.module	1091
1224	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_website_modules	base	ir.module.module	1092
1225	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_event	base	ir.module.module	1093
1226	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_social_media	base	ir.module.module	1094
1227	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_form_account_move_line_link	base	ir.module.module	1095
1228	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_import_module	base	ir.module.module	1096
1229	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_inherits	base	ir.module.module	1097
1230	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mass_editing	base	ir.module.module	1098
1231	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_in_edi	base	ir.module.module	1099
1232	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_employee_lastnames	base	ir.module.module	1100
1233	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_rpc	base	ir.module.module	1101
1234	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_approved	base	ir.module.module	1102
1235	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_requisition_stock_dropshipping	base	ir.module.module	1103
1236	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_be_edi	base	ir.module.module	1104
1237	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_auth_password_policy_signup	base	ir.module.module	1105
1238	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_transmit_method	base	ir.module.module	1106
1239	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_analytic_search	base	ir.module.module	1107
1240	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_order_line_sequence	base	ir.module.module	1108
1241	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_picking_show_linked	base	ir.module.module	1109
1242	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_purchase_force_vendor	base	ir.module.module	1110
1243	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_open_qty	base	ir.module.module	1111
1244	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_validation_queued	base	ir.module.module	1112
1245	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_hr_study	base	ir.module.module	1113
1246	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_deposit_operating_unit	base	ir.module.module	1114
1247	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base	base	ir.module.module	1115
1248	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_nl_edi	base	ir.module.module	1116
1249	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_resource	base	ir.module.module	1117
1250	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_tier_department	base	ir.module.module	1118
1251	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_vault	base	ir.module.module	1119
1252	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_product_supplierinfo_for_customer_invoice	base	ir.module.module	1120
1253	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_cutoff_accrual_picking	base	ir.module.module	1121
1254	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_uy	base	ir.module.module	1122
1255	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_change_currency	base	ir.module.module	1123
1256	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_listview_range_select	base	ir.module.module	1124
1257	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_project	base	ir.module.module	1125
1258	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_in_purchase_stock	base	ir.module.module	1126
1259	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_ir_actions_act_window_message	base	ir.module.module	1127
1260	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_project_hr	base	ir.module.module	1128
1261	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_web_calendar_slot_duration	base	ir.module.module	1129
1262	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_procurement_purchase_sale_no_grouping	base	ir.module.module	1130
1263	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_request_submit	base	ir.module.module	1131
1264	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sales_team_operating_unit	base	ir.module.module	1132
1265	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sql_export	base	ir.module.module	1133
1266	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_portal	base	ir.module.module	1134
1267	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_bi_view_editor	base	ir.module.module	1135
1268	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ae	base	ir.module.module	1136
1269	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_portal_account_personal_data_only	base	ir.module.module	1137
1270	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_crm	base	ir.module.module	1138
1271	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_sale_mrp	base	ir.module.module	1139
1272	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_mn	base	ir.module.module	1140
1273	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_sale	base	ir.module.module	1141
1274	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_tracking_manager	base	ir.module.module	1142
1275	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_uom	base	ir.module.module	1143
1276	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_base_kanban_stage_state	base	ir.module.module	1144
1277	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_default_multi_user	base	ir.module.module	1145
1278	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_location_position	base	ir.module.module	1146
1279	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_datetime_formatter	base	ir.module.module	1147
1280	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_discount	base	ir.module.module	1148
1281	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_picking_invoicing	base	ir.module.module	1149
1282	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_event_crm_sale	base	ir.module.module	1150
1283	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_stock_quant_reservation_info	base	ir.module.module	1151
1284	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_purchase_receipt_expectation	base	ir.module.module	1152
1285	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_website_event_meet	base	ir.module.module	1153
1286	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_ma	base	ir.module.module	1154
1287	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_mis_builder_operating_unit_access_all	base	ir.module.module	1155
1288	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_account_invoice_line_sequence	base	ir.module.module	1156
1289	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_hu	base	ir.module.module	1157
1290	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_test_uninstall	base	ir.module.module	1158
1291	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	module_l10n_th_account_tax	base	ir.module.module	1159
1292	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_base	base	ir.model	1
1293	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model__unknown	base	ir.model	2
1294	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_model	base	ir.model	3
1295	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_model_fields	base	ir.model	4
1296	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_model_fields_selection	base	ir.model	5
1297	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_model_constraint	base	ir.model	6
1298	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_model_relation	base	ir.model	7
1299	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_model_access	base	ir.model	8
1300	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_model_data	base	ir.model	9
1301	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_wizard_ir_model_menu_create	base	ir.model	10
1302	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_sequence	base	ir.model	11
1303	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_sequence_date_range	base	ir.model	12
1304	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_ui_menu	base	ir.model	13
1305	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_ui_view_custom	base	ir.model	14
1306	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_ui_view	base	ir.model	15
1307	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_reset_view_arch_wizard	base	ir.model	16
1308	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_asset	base	ir.model	17
1309	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_actions_actions	base	ir.model	18
1310	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_actions_act_window	base	ir.model	19
1311	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_actions_act_window_view	base	ir.model	20
1312	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_actions_act_window_close	base	ir.model	21
1313	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_actions_act_url	base	ir.model	22
1314	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_actions_server	base	ir.model	23
1315	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_server_object_lines	base	ir.model	24
1316	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_actions_todo	base	ir.model	25
1317	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_actions_client	base	ir.model	26
1318	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_actions_report	base	ir.model	27
1319	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_attachment	base	ir.model	28
1320	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_cron	base	ir.model	29
1321	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_cron_trigger	base	ir.model	30
1322	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_filters	base	ir.model	31
1323	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_default	base	ir.model	32
1324	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_translation	base	ir.model	33
1325	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_exports	base	ir.model	34
1326	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_exports_line	base	ir.model	35
1327	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_rule	base	ir.model	36
1328	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_config_parameter	base	ir.model	37
1329	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_autovacuum	base	ir.model	38
1330	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_mail_server	base	ir.model	39
1331	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_fields_converter	base	ir.model	40
1332	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb	base	ir.model	41
1333	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field	base	ir.model	42
1334	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_integer	base	ir.model	43
1335	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_float	base	ir.model	44
1336	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_date	base	ir.model	45
1337	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_datetime	base	ir.model	46
1338	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_text	base	ir.model	47
1339	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_selection	base	ir.model	48
1340	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_many2one	base	ir.model	49
1341	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_many2many	base	ir.model	50
1342	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_html	base	ir.model	51
1343	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_image	base	ir.model	52
1344	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_image_url	base	ir.model	53
1345	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_monetary	base	ir.model	54
1346	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_float_time	base	ir.model	55
1347	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_duration	base	ir.model	56
1348	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_relative	base	ir.model	57
1349	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_barcode	base	ir.model	58
1350	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_contact	base	ir.model	59
1351	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_qweb_field_qweb	base	ir.model	60
1352	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_http	base	ir.model	61
1353	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_logging	base	ir.model	62
1354	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_property	base	ir.model	63
1355	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_module_category	base	ir.model	64
1356	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_module_module	base	ir.model	65
1357	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_module_module_dependency	base	ir.model	66
1358	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_module_module_exclusion	base	ir.model	67
1359	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_demo	base	ir.model	68
1360	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_demo_failure	base	ir.model	69
1361	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_demo_failure_wizard	base	ir.model	70
1362	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_report_layout	base	ir.model	71
1363	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_report_paperformat	base	ir.model	72
1364	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_ir_profile	base	ir.model	73
1365	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_base_enable_profiling_wizard	base	ir.model	74
1366	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_image_mixin	base	ir.model	75
1368	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_country	base	ir.model	77
1369	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_country_group	base	ir.model	78
1370	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_country_state	base	ir.model	79
1371	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_lang	base	ir.model	80
1372	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_format_address_mixin	base	ir.model	81
1373	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_partner_category	base	ir.model	82
1374	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_partner_title	base	ir.model	83
1375	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_partner	base	ir.model	84
1376	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_partner_industry	base	ir.model	85
1377	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_bank	base	ir.model	86
1378	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_partner_bank	base	ir.model	87
1379	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_config	base	ir.model	88
1380	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_config_installer	base	ir.model	89
1381	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_config_settings	base	ir.model	90
1382	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_currency	base	ir.model	91
1383	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_currency_rate	base	ir.model	92
1384	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_company	base	ir.model	93
1385	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_groups	base	ir.model	94
1386	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_users_log	base	ir.model	95
1387	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_users	base	ir.model	96
1388	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_users_identitycheck	base	ir.model	97
1389	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_change_password_wizard	base	ir.model	98
1390	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_change_password_user	base	ir.model	99
1391	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_users_apikeys	base	ir.model	100
1392	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_users_apikeys_description	base	ir.model	101
1393	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_res_users_apikeys_show	base	ir.model	102
1394	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_decimal_precision	base	ir.model	103
1395	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_report_base_report_irmodulereference	base	ir.model	104
1396	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_base_module_update	base	ir.model	105
1397	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_base_language_install	base	ir.model	106
1398	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_base_language_import	base	ir.model	107
1399	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_base_module_upgrade	base	ir.model	108
1400	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_base_module_uninstall	base	ir.model	109
1401	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_base_language_export	base	ir.model	110
1402	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_base_update_translations	base	ir.model	111
1403	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_base_partner_merge_line	base	ir.model	112
1404	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	model_base_partner_merge_automatic_wizard	base	ir.model	113
1405	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__name	base	ir.model.fields	1
1406	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__model	base	ir.model.fields	2
1407	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__order	base	ir.model.fields	3
1408	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__info	base	ir.model.fields	4
1409	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__field_id	base	ir.model.fields	5
1410	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__inherited_model_ids	base	ir.model.fields	6
1411	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__state	base	ir.model.fields	7
1412	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__access_ids	base	ir.model.fields	8
1413	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__rule_ids	base	ir.model.fields	9
1414	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__transient	base	ir.model.fields	10
1415	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__modules	base	ir.model.fields	11
1416	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__view_ids	base	ir.model.fields	12
1417	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__count	base	ir.model.fields	13
1418	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__id	base	ir.model.fields	14
1419	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model____last_update	base	ir.model.fields	15
1420	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__display_name	base	ir.model.fields	16
1421	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__create_uid	base	ir.model.fields	17
1422	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__create_date	base	ir.model.fields	18
1423	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__write_uid	base	ir.model.fields	19
1424	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model__write_date	base	ir.model.fields	20
1425	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__name	base	ir.model.fields	21
1426	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__complete_name	base	ir.model.fields	22
1427	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__model	base	ir.model.fields	23
1428	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__relation	base	ir.model.fields	24
1429	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__relation_field	base	ir.model.fields	25
1430	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__relation_field_id	base	ir.model.fields	26
1431	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__model_id	base	ir.model.fields	27
1432	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__field_description	base	ir.model.fields	28
1433	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__help	base	ir.model.fields	29
1434	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__ttype	base	ir.model.fields	30
1435	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__selection	base	ir.model.fields	31
1436	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__selection_ids	base	ir.model.fields	32
1437	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__copied	base	ir.model.fields	33
1438	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__related	base	ir.model.fields	34
1439	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__related_field_id	base	ir.model.fields	35
1440	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__required	base	ir.model.fields	36
1441	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__readonly	base	ir.model.fields	37
1442	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__index	base	ir.model.fields	38
1443	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__translate	base	ir.model.fields	39
1444	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__size	base	ir.model.fields	40
1445	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__state	base	ir.model.fields	41
1446	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__on_delete	base	ir.model.fields	42
1447	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__domain	base	ir.model.fields	43
1448	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__groups	base	ir.model.fields	44
1449	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__group_expand	base	ir.model.fields	45
1450	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__selectable	base	ir.model.fields	46
1451	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__modules	base	ir.model.fields	47
1452	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__relation_table	base	ir.model.fields	48
1453	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__column1	base	ir.model.fields	49
1454	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__column2	base	ir.model.fields	50
1455	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__compute	base	ir.model.fields	51
1456	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__depends	base	ir.model.fields	52
1457	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__store	base	ir.model.fields	53
1458	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__id	base	ir.model.fields	54
1459	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields____last_update	base	ir.model.fields	55
1460	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__display_name	base	ir.model.fields	56
1461	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__create_uid	base	ir.model.fields	57
1462	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__create_date	base	ir.model.fields	58
1463	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__write_uid	base	ir.model.fields	59
1464	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields__write_date	base	ir.model.fields	60
1465	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields_selection__field_id	base	ir.model.fields	61
1466	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields_selection__value	base	ir.model.fields	62
1467	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields_selection__name	base	ir.model.fields	63
1468	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields_selection__sequence	base	ir.model.fields	64
1469	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields_selection__id	base	ir.model.fields	65
1470	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields_selection____last_update	base	ir.model.fields	66
1471	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields_selection__display_name	base	ir.model.fields	67
1472	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields_selection__create_uid	base	ir.model.fields	68
1473	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields_selection__create_date	base	ir.model.fields	69
1474	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields_selection__write_uid	base	ir.model.fields	70
1475	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_fields_selection__write_date	base	ir.model.fields	71
1476	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__name	base	ir.model.fields	72
1477	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__definition	base	ir.model.fields	73
1478	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__message	base	ir.model.fields	74
1479	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__model	base	ir.model.fields	75
1480	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__module	base	ir.model.fields	76
1481	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__type	base	ir.model.fields	77
1482	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__write_date	base	ir.model.fields	78
1483	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__create_date	base	ir.model.fields	79
1484	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__id	base	ir.model.fields	80
1485	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint____last_update	base	ir.model.fields	81
1486	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__display_name	base	ir.model.fields	82
1487	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__create_uid	base	ir.model.fields	83
1488	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_constraint__write_uid	base	ir.model.fields	84
1489	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_relation__name	base	ir.model.fields	85
1490	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_relation__model	base	ir.model.fields	86
1491	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_relation__module	base	ir.model.fields	87
1492	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_relation__write_date	base	ir.model.fields	88
1493	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_relation__create_date	base	ir.model.fields	89
1494	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_relation__id	base	ir.model.fields	90
1495	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_relation____last_update	base	ir.model.fields	91
1496	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_relation__display_name	base	ir.model.fields	92
1497	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_relation__create_uid	base	ir.model.fields	93
1498	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_relation__write_uid	base	ir.model.fields	94
1499	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__name	base	ir.model.fields	95
1500	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__active	base	ir.model.fields	96
1501	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__model_id	base	ir.model.fields	97
1502	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__group_id	base	ir.model.fields	98
1503	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__perm_read	base	ir.model.fields	99
1504	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__perm_write	base	ir.model.fields	100
1505	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__perm_create	base	ir.model.fields	101
1506	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__perm_unlink	base	ir.model.fields	102
1507	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__id	base	ir.model.fields	103
1508	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access____last_update	base	ir.model.fields	104
1509	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__display_name	base	ir.model.fields	105
1510	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__create_uid	base	ir.model.fields	106
1511	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__create_date	base	ir.model.fields	107
1512	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__write_uid	base	ir.model.fields	108
1513	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_access__write_date	base	ir.model.fields	109
1514	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__name	base	ir.model.fields	110
1515	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__complete_name	base	ir.model.fields	111
1516	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__model	base	ir.model.fields	112
1517	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__module	base	ir.model.fields	113
1518	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__res_id	base	ir.model.fields	114
1519	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__noupdate	base	ir.model.fields	115
1520	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__reference	base	ir.model.fields	116
1521	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__id	base	ir.model.fields	117
1522	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data____last_update	base	ir.model.fields	118
1523	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__display_name	base	ir.model.fields	119
1524	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__create_uid	base	ir.model.fields	120
1525	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__create_date	base	ir.model.fields	121
1526	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__write_uid	base	ir.model.fields	122
1527	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_model_data__write_date	base	ir.model.fields	123
1528	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_wizard_ir_model_menu_create__menu_id	base	ir.model.fields	124
1529	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_wizard_ir_model_menu_create__name	base	ir.model.fields	125
1530	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_wizard_ir_model_menu_create__id	base	ir.model.fields	126
1531	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_wizard_ir_model_menu_create____last_update	base	ir.model.fields	127
1532	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_wizard_ir_model_menu_create__display_name	base	ir.model.fields	128
1533	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_wizard_ir_model_menu_create__create_uid	base	ir.model.fields	129
1534	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_wizard_ir_model_menu_create__create_date	base	ir.model.fields	130
1535	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_wizard_ir_model_menu_create__write_uid	base	ir.model.fields	131
1536	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_wizard_ir_model_menu_create__write_date	base	ir.model.fields	132
1537	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__name	base	ir.model.fields	133
1538	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__code	base	ir.model.fields	134
1539	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__implementation	base	ir.model.fields	135
1540	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__active	base	ir.model.fields	136
1541	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__prefix	base	ir.model.fields	137
1542	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__suffix	base	ir.model.fields	138
1543	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__number_next	base	ir.model.fields	139
1544	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__number_next_actual	base	ir.model.fields	140
1545	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__number_increment	base	ir.model.fields	141
1546	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__padding	base	ir.model.fields	142
1547	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__company_id	base	ir.model.fields	143
1548	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__use_date_range	base	ir.model.fields	144
1549	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__date_range_ids	base	ir.model.fields	145
1550	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__id	base	ir.model.fields	146
1551	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence____last_update	base	ir.model.fields	147
1552	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__display_name	base	ir.model.fields	148
1553	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__create_uid	base	ir.model.fields	149
1554	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__create_date	base	ir.model.fields	150
1555	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__write_uid	base	ir.model.fields	151
1556	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence__write_date	base	ir.model.fields	152
1557	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range__date_from	base	ir.model.fields	153
1558	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range__date_to	base	ir.model.fields	154
1559	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range__sequence_id	base	ir.model.fields	155
1560	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range__number_next	base	ir.model.fields	156
1561	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range__number_next_actual	base	ir.model.fields	157
1562	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range__id	base	ir.model.fields	158
1563	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range____last_update	base	ir.model.fields	159
1564	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range__display_name	base	ir.model.fields	160
1565	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range__create_uid	base	ir.model.fields	161
1566	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range__create_date	base	ir.model.fields	162
1567	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range__write_uid	base	ir.model.fields	163
1568	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_sequence_date_range__write_date	base	ir.model.fields	164
1569	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__name	base	ir.model.fields	165
1570	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__active	base	ir.model.fields	166
1571	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__sequence	base	ir.model.fields	167
1572	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__child_id	base	ir.model.fields	168
1573	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__parent_id	base	ir.model.fields	169
1574	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__parent_path	base	ir.model.fields	170
1575	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__groups_id	base	ir.model.fields	171
1576	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__complete_name	base	ir.model.fields	172
1577	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__web_icon	base	ir.model.fields	173
1578	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__action	base	ir.model.fields	174
1579	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__web_icon_data	base	ir.model.fields	175
1580	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__id	base	ir.model.fields	176
1581	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu____last_update	base	ir.model.fields	177
1582	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__display_name	base	ir.model.fields	178
1583	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__create_uid	base	ir.model.fields	179
1584	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__create_date	base	ir.model.fields	180
1585	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__write_uid	base	ir.model.fields	181
1586	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_menu__write_date	base	ir.model.fields	182
1587	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view_custom__ref_id	base	ir.model.fields	183
1588	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view_custom__user_id	base	ir.model.fields	184
1589	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view_custom__arch	base	ir.model.fields	185
1590	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view_custom__id	base	ir.model.fields	186
1591	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view_custom____last_update	base	ir.model.fields	187
1592	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view_custom__display_name	base	ir.model.fields	188
1593	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view_custom__create_uid	base	ir.model.fields	189
1594	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view_custom__create_date	base	ir.model.fields	190
1595	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view_custom__write_uid	base	ir.model.fields	191
1596	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view_custom__write_date	base	ir.model.fields	192
1597	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__name	base	ir.model.fields	193
1598	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__model	base	ir.model.fields	194
1599	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__key	base	ir.model.fields	195
1600	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__priority	base	ir.model.fields	196
1601	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__type	base	ir.model.fields	197
1602	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__arch	base	ir.model.fields	198
1603	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__arch_base	base	ir.model.fields	199
1604	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__arch_db	base	ir.model.fields	200
1605	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__arch_fs	base	ir.model.fields	201
1606	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__arch_updated	base	ir.model.fields	202
1607	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__arch_prev	base	ir.model.fields	203
1608	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__inherit_id	base	ir.model.fields	204
1609	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__inherit_children_ids	base	ir.model.fields	205
1610	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__field_parent	base	ir.model.fields	206
1611	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__model_data_id	base	ir.model.fields	207
1612	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__xml_id	base	ir.model.fields	208
1613	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__groups_id	base	ir.model.fields	209
1614	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__mode	base	ir.model.fields	210
1615	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__active	base	ir.model.fields	211
1616	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__id	base	ir.model.fields	212
1617	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view____last_update	base	ir.model.fields	213
1618	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__display_name	base	ir.model.fields	214
1619	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__create_uid	base	ir.model.fields	215
1620	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__create_date	base	ir.model.fields	216
1621	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__write_uid	base	ir.model.fields	217
1622	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_ui_view__write_date	base	ir.model.fields	218
1623	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__view_id	base	ir.model.fields	219
1624	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__view_name	base	ir.model.fields	220
1625	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__has_diff	base	ir.model.fields	221
1626	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__arch_diff	base	ir.model.fields	222
1627	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__reset_mode	base	ir.model.fields	223
1628	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__compare_view_id	base	ir.model.fields	224
1629	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__arch_to_compare	base	ir.model.fields	225
1630	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__id	base	ir.model.fields	226
1631	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard____last_update	base	ir.model.fields	227
1632	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__display_name	base	ir.model.fields	228
1633	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__create_uid	base	ir.model.fields	229
1634	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__create_date	base	ir.model.fields	230
1635	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__write_uid	base	ir.model.fields	231
1636	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_reset_view_arch_wizard__write_date	base	ir.model.fields	232
1637	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__name	base	ir.model.fields	233
1638	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__bundle	base	ir.model.fields	234
1639	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__directive	base	ir.model.fields	235
1640	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__path	base	ir.model.fields	236
1641	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__target	base	ir.model.fields	237
1642	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__active	base	ir.model.fields	238
1643	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__sequence	base	ir.model.fields	239
1644	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__id	base	ir.model.fields	240
1645	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset____last_update	base	ir.model.fields	241
1646	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__display_name	base	ir.model.fields	242
1647	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__create_uid	base	ir.model.fields	243
1648	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__create_date	base	ir.model.fields	244
1649	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__write_uid	base	ir.model.fields	245
1650	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_asset__write_date	base	ir.model.fields	246
1651	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__name	base	ir.model.fields	247
1652	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__type	base	ir.model.fields	248
1653	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__xml_id	base	ir.model.fields	249
1654	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__help	base	ir.model.fields	250
1655	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__binding_model_id	base	ir.model.fields	251
1656	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__binding_type	base	ir.model.fields	252
1657	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__binding_view_types	base	ir.model.fields	253
1658	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__id	base	ir.model.fields	254
1659	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions____last_update	base	ir.model.fields	255
1660	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__display_name	base	ir.model.fields	256
1661	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__create_uid	base	ir.model.fields	257
1662	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__create_date	base	ir.model.fields	258
1663	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__write_uid	base	ir.model.fields	259
1664	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_actions__write_date	base	ir.model.fields	260
1665	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__name	base	ir.model.fields	261
1666	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__type	base	ir.model.fields	262
1667	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__xml_id	base	ir.model.fields	263
1668	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__help	base	ir.model.fields	264
1669	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__binding_model_id	base	ir.model.fields	265
1670	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__binding_type	base	ir.model.fields	266
1671	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__binding_view_types	base	ir.model.fields	267
1672	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__id	base	ir.model.fields	268
1673	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window____last_update	base	ir.model.fields	269
1674	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__display_name	base	ir.model.fields	270
1675	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__create_uid	base	ir.model.fields	271
1676	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__create_date	base	ir.model.fields	272
1677	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__write_uid	base	ir.model.fields	273
1678	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__write_date	base	ir.model.fields	274
1679	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__view_id	base	ir.model.fields	275
1680	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__domain	base	ir.model.fields	276
1681	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__context	base	ir.model.fields	277
1682	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__res_id	base	ir.model.fields	278
1683	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__res_model	base	ir.model.fields	279
1684	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__target	base	ir.model.fields	280
1685	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__view_mode	base	ir.model.fields	281
1686	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__usage	base	ir.model.fields	282
1687	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__view_ids	base	ir.model.fields	283
1688	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__views	base	ir.model.fields	284
1689	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__limit	base	ir.model.fields	285
1690	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__groups_id	base	ir.model.fields	286
1691	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__search_view_id	base	ir.model.fields	287
1692	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__filter	base	ir.model.fields	288
1693	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window__search_view	base	ir.model.fields	289
1694	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view__sequence	base	ir.model.fields	290
1695	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view__view_id	base	ir.model.fields	291
1696	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view__view_mode	base	ir.model.fields	292
1697	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view__act_window_id	base	ir.model.fields	293
1698	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view__multi	base	ir.model.fields	294
1699	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view__id	base	ir.model.fields	295
1700	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view____last_update	base	ir.model.fields	296
1701	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view__display_name	base	ir.model.fields	297
1702	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view__create_uid	base	ir.model.fields	298
1703	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view__create_date	base	ir.model.fields	299
1704	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view__write_uid	base	ir.model.fields	300
1705	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_view__write_date	base	ir.model.fields	301
1706	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__name	base	ir.model.fields	302
1707	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__type	base	ir.model.fields	303
1708	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__xml_id	base	ir.model.fields	304
1709	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__help	base	ir.model.fields	305
1710	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__binding_model_id	base	ir.model.fields	306
1711	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__binding_type	base	ir.model.fields	307
1712	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__binding_view_types	base	ir.model.fields	308
1713	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__id	base	ir.model.fields	309
1714	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close____last_update	base	ir.model.fields	310
1715	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__display_name	base	ir.model.fields	311
1716	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__create_uid	base	ir.model.fields	312
1717	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__create_date	base	ir.model.fields	313
1718	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__write_uid	base	ir.model.fields	314
1719	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_window_close__write_date	base	ir.model.fields	315
1720	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__name	base	ir.model.fields	316
1721	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__type	base	ir.model.fields	317
1722	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__xml_id	base	ir.model.fields	318
1723	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__help	base	ir.model.fields	319
1724	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__binding_model_id	base	ir.model.fields	320
1725	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__binding_type	base	ir.model.fields	321
1726	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__binding_view_types	base	ir.model.fields	322
1727	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__id	base	ir.model.fields	323
1728	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url____last_update	base	ir.model.fields	324
1729	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__display_name	base	ir.model.fields	325
1730	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__create_uid	base	ir.model.fields	326
1731	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__create_date	base	ir.model.fields	327
1732	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__write_uid	base	ir.model.fields	328
1733	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__write_date	base	ir.model.fields	329
1734	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__url	base	ir.model.fields	330
1735	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_act_url__target	base	ir.model.fields	331
1736	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__name	base	ir.model.fields	332
1737	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__type	base	ir.model.fields	333
1738	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__xml_id	base	ir.model.fields	334
1739	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__help	base	ir.model.fields	335
1740	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__binding_model_id	base	ir.model.fields	336
1741	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__binding_type	base	ir.model.fields	337
1742	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__binding_view_types	base	ir.model.fields	338
1743	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__id	base	ir.model.fields	339
1744	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server____last_update	base	ir.model.fields	340
1745	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__display_name	base	ir.model.fields	341
1746	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__create_uid	base	ir.model.fields	342
1747	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__create_date	base	ir.model.fields	343
1748	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__write_uid	base	ir.model.fields	344
1749	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__write_date	base	ir.model.fields	345
1750	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__usage	base	ir.model.fields	346
1751	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__state	base	ir.model.fields	347
1752	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__sequence	base	ir.model.fields	348
1753	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__model_id	base	ir.model.fields	349
1754	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__model_name	base	ir.model.fields	350
1755	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__code	base	ir.model.fields	351
1756	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__child_ids	base	ir.model.fields	352
1757	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__crud_model_id	base	ir.model.fields	353
1758	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__crud_model_name	base	ir.model.fields	354
1759	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__link_field_id	base	ir.model.fields	355
1760	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__fields_lines	base	ir.model.fields	356
1761	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_server__groups_id	base	ir.model.fields	357
1762	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines__server_id	base	ir.model.fields	358
1763	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines__col1	base	ir.model.fields	359
1764	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines__value	base	ir.model.fields	360
1765	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines__evaluation_type	base	ir.model.fields	361
1766	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines__resource_ref	base	ir.model.fields	362
1767	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines__id	base	ir.model.fields	363
1768	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines____last_update	base	ir.model.fields	364
1769	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines__display_name	base	ir.model.fields	365
1770	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines__create_uid	base	ir.model.fields	366
1771	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines__create_date	base	ir.model.fields	367
1772	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines__write_uid	base	ir.model.fields	368
1773	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_server_object_lines__write_date	base	ir.model.fields	369
1774	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_todo__action_id	base	ir.model.fields	370
1775	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_todo__sequence	base	ir.model.fields	371
1776	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_todo__state	base	ir.model.fields	372
1777	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_todo__name	base	ir.model.fields	373
1778	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_todo__id	base	ir.model.fields	374
1779	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_todo____last_update	base	ir.model.fields	375
1780	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_todo__display_name	base	ir.model.fields	376
1781	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_todo__create_uid	base	ir.model.fields	377
1782	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_todo__create_date	base	ir.model.fields	378
1783	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_todo__write_uid	base	ir.model.fields	379
1784	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_todo__write_date	base	ir.model.fields	380
1785	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__name	base	ir.model.fields	381
1786	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__type	base	ir.model.fields	382
1787	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__xml_id	base	ir.model.fields	383
1788	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__help	base	ir.model.fields	384
1789	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__binding_model_id	base	ir.model.fields	385
1790	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__binding_type	base	ir.model.fields	386
1791	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__binding_view_types	base	ir.model.fields	387
1792	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__id	base	ir.model.fields	388
1793	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client____last_update	base	ir.model.fields	389
1794	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__display_name	base	ir.model.fields	390
1795	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__create_uid	base	ir.model.fields	391
1796	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__create_date	base	ir.model.fields	392
1797	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__write_uid	base	ir.model.fields	393
1798	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__write_date	base	ir.model.fields	394
1799	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__tag	base	ir.model.fields	395
1800	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__target	base	ir.model.fields	396
1801	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__res_model	base	ir.model.fields	397
1802	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__context	base	ir.model.fields	398
1803	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__params	base	ir.model.fields	399
1804	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_client__params_store	base	ir.model.fields	400
1805	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__name	base	ir.model.fields	401
1806	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__type	base	ir.model.fields	402
1807	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__xml_id	base	ir.model.fields	403
1808	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__help	base	ir.model.fields	404
1809	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__binding_model_id	base	ir.model.fields	405
1810	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__binding_type	base	ir.model.fields	406
1811	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__binding_view_types	base	ir.model.fields	407
1812	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__id	base	ir.model.fields	408
1813	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report____last_update	base	ir.model.fields	409
1814	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__display_name	base	ir.model.fields	410
1815	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__create_uid	base	ir.model.fields	411
1816	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__create_date	base	ir.model.fields	412
1817	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__write_uid	base	ir.model.fields	413
1818	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__write_date	base	ir.model.fields	414
1819	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__model	base	ir.model.fields	415
1820	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__model_id	base	ir.model.fields	416
1821	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__report_type	base	ir.model.fields	417
1822	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__report_name	base	ir.model.fields	418
1823	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__report_file	base	ir.model.fields	419
1824	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__groups_id	base	ir.model.fields	420
1825	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__multi	base	ir.model.fields	421
1826	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__paperformat_id	base	ir.model.fields	422
1827	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__print_report_name	base	ir.model.fields	423
1828	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__attachment_use	base	ir.model.fields	424
1829	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_actions_report__attachment	base	ir.model.fields	425
1830	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__name	base	ir.model.fields	426
1831	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__description	base	ir.model.fields	427
1832	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__res_name	base	ir.model.fields	428
1833	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__res_model	base	ir.model.fields	429
1834	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__res_field	base	ir.model.fields	430
1835	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__res_id	base	ir.model.fields	431
1836	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__company_id	base	ir.model.fields	432
1837	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__type	base	ir.model.fields	433
1838	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__url	base	ir.model.fields	434
1839	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__public	base	ir.model.fields	435
1840	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__access_token	base	ir.model.fields	436
1841	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__raw	base	ir.model.fields	437
1842	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__datas	base	ir.model.fields	438
1843	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__db_datas	base	ir.model.fields	439
1844	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__store_fname	base	ir.model.fields	440
1845	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__file_size	base	ir.model.fields	441
1846	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__checksum	base	ir.model.fields	442
1847	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__mimetype	base	ir.model.fields	443
1848	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__index_content	base	ir.model.fields	444
1849	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__id	base	ir.model.fields	445
1850	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment____last_update	base	ir.model.fields	446
1851	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__display_name	base	ir.model.fields	447
1852	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__create_uid	base	ir.model.fields	448
1853	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__create_date	base	ir.model.fields	449
1854	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__write_uid	base	ir.model.fields	450
1855	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_attachment__write_date	base	ir.model.fields	451
1856	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__ir_actions_server_id	base	ir.model.fields	452
1857	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__cron_name	base	ir.model.fields	453
1858	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__user_id	base	ir.model.fields	454
1859	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__active	base	ir.model.fields	455
1860	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__interval_number	base	ir.model.fields	456
1861	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__interval_type	base	ir.model.fields	457
1862	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__numbercall	base	ir.model.fields	458
1863	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__doall	base	ir.model.fields	459
1864	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__nextcall	base	ir.model.fields	460
1865	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__lastcall	base	ir.model.fields	461
1866	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__priority	base	ir.model.fields	462
1867	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__id	base	ir.model.fields	463
1868	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron____last_update	base	ir.model.fields	464
1869	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__display_name	base	ir.model.fields	465
1870	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__create_uid	base	ir.model.fields	466
1871	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__create_date	base	ir.model.fields	467
1872	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__write_uid	base	ir.model.fields	468
1873	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__write_date	base	ir.model.fields	469
1874	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__name	base	ir.model.fields	470
1875	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__type	base	ir.model.fields	471
1876	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__xml_id	base	ir.model.fields	472
1877	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__help	base	ir.model.fields	473
1878	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__binding_model_id	base	ir.model.fields	474
1879	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__binding_type	base	ir.model.fields	475
1880	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__binding_view_types	base	ir.model.fields	476
1881	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__usage	base	ir.model.fields	477
1882	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__state	base	ir.model.fields	478
1883	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__sequence	base	ir.model.fields	479
1884	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__model_id	base	ir.model.fields	480
1885	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__model_name	base	ir.model.fields	481
1886	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__code	base	ir.model.fields	482
1887	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__child_ids	base	ir.model.fields	483
1888	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__crud_model_id	base	ir.model.fields	484
1889	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__crud_model_name	base	ir.model.fields	485
1890	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__link_field_id	base	ir.model.fields	486
1891	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__fields_lines	base	ir.model.fields	487
1892	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron__groups_id	base	ir.model.fields	488
1893	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron_trigger__cron_id	base	ir.model.fields	489
1894	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron_trigger__call_at	base	ir.model.fields	490
1895	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron_trigger__id	base	ir.model.fields	491
1896	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron_trigger____last_update	base	ir.model.fields	492
1897	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron_trigger__display_name	base	ir.model.fields	493
1898	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron_trigger__create_uid	base	ir.model.fields	494
1899	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron_trigger__create_date	base	ir.model.fields	495
1900	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron_trigger__write_uid	base	ir.model.fields	496
1901	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_cron_trigger__write_date	base	ir.model.fields	497
1902	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__name	base	ir.model.fields	498
1903	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__user_id	base	ir.model.fields	499
1904	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__domain	base	ir.model.fields	500
1905	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__context	base	ir.model.fields	501
1906	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__sort	base	ir.model.fields	502
1907	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__model_id	base	ir.model.fields	503
1908	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__is_default	base	ir.model.fields	504
1909	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__action_id	base	ir.model.fields	505
1910	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__active	base	ir.model.fields	506
1911	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__id	base	ir.model.fields	507
1912	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters____last_update	base	ir.model.fields	508
1913	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__display_name	base	ir.model.fields	509
1914	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__create_uid	base	ir.model.fields	510
1915	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__create_date	base	ir.model.fields	511
1916	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__write_uid	base	ir.model.fields	512
1917	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_filters__write_date	base	ir.model.fields	513
1918	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default__field_id	base	ir.model.fields	514
1919	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default__user_id	base	ir.model.fields	515
1920	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default__company_id	base	ir.model.fields	516
1921	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default__condition	base	ir.model.fields	517
1922	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default__json_value	base	ir.model.fields	518
1923	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default__id	base	ir.model.fields	519
1924	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default____last_update	base	ir.model.fields	520
1925	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default__display_name	base	ir.model.fields	521
1926	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default__create_uid	base	ir.model.fields	522
1927	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default__create_date	base	ir.model.fields	523
1928	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default__write_uid	base	ir.model.fields	524
1929	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_default__write_date	base	ir.model.fields	525
1930	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation__name	base	ir.model.fields	526
1931	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation__res_id	base	ir.model.fields	527
1932	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation__lang	base	ir.model.fields	528
1933	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation__type	base	ir.model.fields	529
1934	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation__src	base	ir.model.fields	530
1935	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation__value	base	ir.model.fields	531
1936	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation__module	base	ir.model.fields	532
1937	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation__state	base	ir.model.fields	533
1938	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation__comments	base	ir.model.fields	534
1939	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation__id	base	ir.model.fields	535
1940	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation____last_update	base	ir.model.fields	536
1941	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_translation__display_name	base	ir.model.fields	537
1942	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports__name	base	ir.model.fields	538
1943	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports__resource	base	ir.model.fields	539
1944	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports__export_fields	base	ir.model.fields	540
1945	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports__id	base	ir.model.fields	541
1946	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports____last_update	base	ir.model.fields	542
1947	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports__display_name	base	ir.model.fields	543
1948	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports__create_uid	base	ir.model.fields	544
1949	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports__create_date	base	ir.model.fields	545
1950	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports__write_uid	base	ir.model.fields	546
1951	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports__write_date	base	ir.model.fields	547
1952	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports_line__name	base	ir.model.fields	548
1953	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports_line__export_id	base	ir.model.fields	549
1954	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports_line__id	base	ir.model.fields	550
1955	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports_line____last_update	base	ir.model.fields	551
1956	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports_line__display_name	base	ir.model.fields	552
1957	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports_line__create_uid	base	ir.model.fields	553
1958	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports_line__create_date	base	ir.model.fields	554
1959	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports_line__write_uid	base	ir.model.fields	555
1960	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_exports_line__write_date	base	ir.model.fields	556
1961	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__name	base	ir.model.fields	557
1962	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__active	base	ir.model.fields	558
1963	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__model_id	base	ir.model.fields	559
1964	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__groups	base	ir.model.fields	560
1965	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__domain_force	base	ir.model.fields	561
1966	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__perm_read	base	ir.model.fields	562
1967	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__perm_write	base	ir.model.fields	563
1968	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__perm_create	base	ir.model.fields	564
1969	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__perm_unlink	base	ir.model.fields	565
1970	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__id	base	ir.model.fields	566
1971	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule____last_update	base	ir.model.fields	567
1972	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__display_name	base	ir.model.fields	568
1973	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__create_uid	base	ir.model.fields	569
1974	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__create_date	base	ir.model.fields	570
1975	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__write_uid	base	ir.model.fields	571
1976	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__write_date	base	ir.model.fields	572
1977	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_rule__global	base	ir.model.fields	573
1978	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_config_parameter__key	base	ir.model.fields	574
1979	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_config_parameter__value	base	ir.model.fields	575
1980	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_config_parameter__id	base	ir.model.fields	576
1981	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_config_parameter____last_update	base	ir.model.fields	577
1982	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_config_parameter__display_name	base	ir.model.fields	578
1983	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_config_parameter__create_uid	base	ir.model.fields	579
1984	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_config_parameter__create_date	base	ir.model.fields	580
1985	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_config_parameter__write_uid	base	ir.model.fields	581
1986	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_config_parameter__write_date	base	ir.model.fields	582
1987	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__name	base	ir.model.fields	583
1988	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__from_filter	base	ir.model.fields	584
1989	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__smtp_host	base	ir.model.fields	585
1990	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__smtp_port	base	ir.model.fields	586
1991	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__smtp_authentication	base	ir.model.fields	587
1992	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__smtp_user	base	ir.model.fields	588
1993	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__smtp_pass	base	ir.model.fields	589
1994	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__smtp_encryption	base	ir.model.fields	590
1995	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__smtp_ssl_certificate	base	ir.model.fields	591
1996	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__smtp_ssl_private_key	base	ir.model.fields	592
1997	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__smtp_debug	base	ir.model.fields	593
1998	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__sequence	base	ir.model.fields	594
1999	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__active	base	ir.model.fields	595
2000	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__id	base	ir.model.fields	596
2001	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server____last_update	base	ir.model.fields	597
2002	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__display_name	base	ir.model.fields	598
2003	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__create_uid	base	ir.model.fields	599
2004	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__create_date	base	ir.model.fields	600
2005	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__write_uid	base	ir.model.fields	601
2006	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_mail_server__write_date	base	ir.model.fields	602
2007	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__create_uid	base	ir.model.fields	603
2008	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__create_date	base	ir.model.fields	604
2009	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__write_uid	base	ir.model.fields	605
2010	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__write_date	base	ir.model.fields	606
2011	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__name	base	ir.model.fields	607
2012	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__type	base	ir.model.fields	608
2013	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__dbname	base	ir.model.fields	609
2014	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__level	base	ir.model.fields	610
2015	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__message	base	ir.model.fields	611
2016	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__path	base	ir.model.fields	612
2017	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__func	base	ir.model.fields	613
2018	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__line	base	ir.model.fields	614
2019	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__id	base	ir.model.fields	615
2020	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging____last_update	base	ir.model.fields	616
2021	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_logging__display_name	base	ir.model.fields	617
2022	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__name	base	ir.model.fields	618
2023	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__res_id	base	ir.model.fields	619
2024	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__company_id	base	ir.model.fields	620
2025	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__fields_id	base	ir.model.fields	621
2026	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__value_float	base	ir.model.fields	622
2027	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__value_integer	base	ir.model.fields	623
2028	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__value_text	base	ir.model.fields	624
2029	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__value_binary	base	ir.model.fields	625
2030	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__value_reference	base	ir.model.fields	626
2031	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__value_datetime	base	ir.model.fields	627
2032	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__type	base	ir.model.fields	628
2033	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__id	base	ir.model.fields	629
2034	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property____last_update	base	ir.model.fields	630
2035	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__display_name	base	ir.model.fields	631
3046	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_am_ET	base	res.lang	2
2036	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__create_uid	base	ir.model.fields	632
2037	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__create_date	base	ir.model.fields	633
2038	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__write_uid	base	ir.model.fields	634
2039	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_property__write_date	base	ir.model.fields	635
2040	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__name	base	ir.model.fields	636
2041	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__parent_id	base	ir.model.fields	637
2042	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__child_ids	base	ir.model.fields	638
2043	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__module_nr	base	ir.model.fields	639
2044	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__module_ids	base	ir.model.fields	640
2045	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__description	base	ir.model.fields	641
2046	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__sequence	base	ir.model.fields	642
2047	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__visible	base	ir.model.fields	643
2048	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__exclusive	base	ir.model.fields	644
2049	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__xml_id	base	ir.model.fields	645
2050	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__id	base	ir.model.fields	646
2051	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category____last_update	base	ir.model.fields	647
2052	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__display_name	base	ir.model.fields	648
2053	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__create_uid	base	ir.model.fields	649
2054	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__create_date	base	ir.model.fields	650
2055	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__write_uid	base	ir.model.fields	651
2056	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_category__write_date	base	ir.model.fields	652
2057	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__name	base	ir.model.fields	653
2058	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__category_id	base	ir.model.fields	654
2059	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__shortdesc	base	ir.model.fields	655
2060	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__summary	base	ir.model.fields	656
2061	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__description	base	ir.model.fields	657
2062	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__description_html	base	ir.model.fields	658
2063	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__author	base	ir.model.fields	659
2064	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__maintainer	base	ir.model.fields	660
2065	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__contributors	base	ir.model.fields	661
2066	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__website	base	ir.model.fields	662
2067	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__installed_version	base	ir.model.fields	663
2068	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__latest_version	base	ir.model.fields	664
2069	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__published_version	base	ir.model.fields	665
2070	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__url	base	ir.model.fields	666
2071	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__sequence	base	ir.model.fields	667
2072	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__dependencies_id	base	ir.model.fields	668
2073	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__exclusion_ids	base	ir.model.fields	669
2074	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__auto_install	base	ir.model.fields	670
2075	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__state	base	ir.model.fields	671
2076	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__demo	base	ir.model.fields	672
2077	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__license	base	ir.model.fields	673
2078	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__menus_by_module	base	ir.model.fields	674
2079	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__reports_by_module	base	ir.model.fields	675
2080	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__views_by_module	base	ir.model.fields	676
2081	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__application	base	ir.model.fields	677
2082	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__icon	base	ir.model.fields	678
2083	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__icon_image	base	ir.model.fields	679
2084	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__to_buy	base	ir.model.fields	680
2085	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__has_iap	base	ir.model.fields	681
2086	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__id	base	ir.model.fields	682
2087	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module____last_update	base	ir.model.fields	683
2088	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__display_name	base	ir.model.fields	684
2089	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__create_uid	base	ir.model.fields	685
2090	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__create_date	base	ir.model.fields	686
2091	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__write_uid	base	ir.model.fields	687
2092	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module__write_date	base	ir.model.fields	688
2093	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency__name	base	ir.model.fields	689
2094	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency__module_id	base	ir.model.fields	690
2095	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency__depend_id	base	ir.model.fields	691
2096	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency__state	base	ir.model.fields	692
2097	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency__auto_install_required	base	ir.model.fields	693
2098	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency__id	base	ir.model.fields	694
2099	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency____last_update	base	ir.model.fields	695
2100	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency__display_name	base	ir.model.fields	696
2101	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency__create_uid	base	ir.model.fields	697
2102	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency__create_date	base	ir.model.fields	698
2103	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency__write_uid	base	ir.model.fields	699
2104	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_dependency__write_date	base	ir.model.fields	700
2105	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_exclusion__name	base	ir.model.fields	701
2106	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_exclusion__module_id	base	ir.model.fields	702
2107	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_exclusion__exclusion_id	base	ir.model.fields	703
2108	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_exclusion__state	base	ir.model.fields	704
2109	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_exclusion__id	base	ir.model.fields	705
2110	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_exclusion____last_update	base	ir.model.fields	706
2111	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_exclusion__display_name	base	ir.model.fields	707
2112	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_exclusion__create_uid	base	ir.model.fields	708
2113	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_exclusion__create_date	base	ir.model.fields	709
2114	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_exclusion__write_uid	base	ir.model.fields	710
2115	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_module_module_exclusion__write_date	base	ir.model.fields	711
2116	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo__id	base	ir.model.fields	712
2117	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo____last_update	base	ir.model.fields	713
2118	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo__display_name	base	ir.model.fields	714
2119	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo__create_uid	base	ir.model.fields	715
2120	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo__create_date	base	ir.model.fields	716
2121	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo__write_uid	base	ir.model.fields	717
2122	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo__write_date	base	ir.model.fields	718
2123	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure__module_id	base	ir.model.fields	719
2124	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure__error	base	ir.model.fields	720
2125	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure__wizard_id	base	ir.model.fields	721
2126	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure__id	base	ir.model.fields	722
2127	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure____last_update	base	ir.model.fields	723
2128	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure__display_name	base	ir.model.fields	724
2129	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure__create_uid	base	ir.model.fields	725
2130	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure__create_date	base	ir.model.fields	726
2131	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure__write_uid	base	ir.model.fields	727
2132	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure__write_date	base	ir.model.fields	728
2133	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure_wizard__failure_ids	base	ir.model.fields	729
2134	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure_wizard__failures_count	base	ir.model.fields	730
2135	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure_wizard__id	base	ir.model.fields	731
2136	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure_wizard____last_update	base	ir.model.fields	732
2137	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure_wizard__display_name	base	ir.model.fields	733
2138	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure_wizard__create_uid	base	ir.model.fields	734
2139	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure_wizard__create_date	base	ir.model.fields	735
2140	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure_wizard__write_uid	base	ir.model.fields	736
2141	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_demo_failure_wizard__write_date	base	ir.model.fields	737
2142	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout__view_id	base	ir.model.fields	738
2143	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout__image	base	ir.model.fields	739
2144	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout__pdf	base	ir.model.fields	740
2145	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout__sequence	base	ir.model.fields	741
2146	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout__name	base	ir.model.fields	742
2147	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout__id	base	ir.model.fields	743
2148	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout____last_update	base	ir.model.fields	744
2149	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout__display_name	base	ir.model.fields	745
2150	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout__create_uid	base	ir.model.fields	746
2151	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout__create_date	base	ir.model.fields	747
2152	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout__write_uid	base	ir.model.fields	748
2153	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_layout__write_date	base	ir.model.fields	749
2154	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__name	base	ir.model.fields	750
2155	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__default	base	ir.model.fields	751
2156	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__format	base	ir.model.fields	752
2157	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__margin_top	base	ir.model.fields	753
2158	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__margin_bottom	base	ir.model.fields	754
2159	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__margin_left	base	ir.model.fields	755
2160	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__margin_right	base	ir.model.fields	756
2161	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__page_height	base	ir.model.fields	757
2162	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__page_width	base	ir.model.fields	758
2163	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__orientation	base	ir.model.fields	759
2164	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__header_line	base	ir.model.fields	760
2165	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__header_spacing	base	ir.model.fields	761
2166	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__disable_shrinking	base	ir.model.fields	762
2167	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__dpi	base	ir.model.fields	763
2168	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__report_ids	base	ir.model.fields	764
2169	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__print_page_width	base	ir.model.fields	765
2170	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__print_page_height	base	ir.model.fields	766
2171	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__id	base	ir.model.fields	767
2172	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat____last_update	base	ir.model.fields	768
2173	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__display_name	base	ir.model.fields	769
2174	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__create_uid	base	ir.model.fields	770
2175	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__create_date	base	ir.model.fields	771
2176	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__write_uid	base	ir.model.fields	772
2177	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_report_paperformat__write_date	base	ir.model.fields	773
2178	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__create_date	base	ir.model.fields	774
2179	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__session	base	ir.model.fields	775
2180	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__name	base	ir.model.fields	776
2181	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__duration	base	ir.model.fields	777
2182	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__init_stack_trace	base	ir.model.fields	778
2183	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__sql	base	ir.model.fields	779
2184	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__traces_async	base	ir.model.fields	780
2185	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__traces_sync	base	ir.model.fields	781
2186	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__qweb	base	ir.model.fields	782
2187	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__entry_count	base	ir.model.fields	783
2188	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__speedscope	base	ir.model.fields	784
2189	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__speedscope_url	base	ir.model.fields	785
2190	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__id	base	ir.model.fields	786
2191	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile____last_update	base	ir.model.fields	787
2192	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_ir_profile__display_name	base	ir.model.fields	788
2193	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_enable_profiling_wizard__duration	base	ir.model.fields	789
2194	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_enable_profiling_wizard__expiration	base	ir.model.fields	790
2195	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_enable_profiling_wizard__id	base	ir.model.fields	791
2196	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_enable_profiling_wizard____last_update	base	ir.model.fields	792
2197	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_enable_profiling_wizard__display_name	base	ir.model.fields	793
2198	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_enable_profiling_wizard__create_uid	base	ir.model.fields	794
2199	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_enable_profiling_wizard__create_date	base	ir.model.fields	795
2200	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_enable_profiling_wizard__write_uid	base	ir.model.fields	796
2201	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_enable_profiling_wizard__write_date	base	ir.model.fields	797
2202	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_image_mixin__image_1920	base	ir.model.fields	798
2203	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_image_mixin__image_1024	base	ir.model.fields	799
2204	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_image_mixin__image_512	base	ir.model.fields	800
2205	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_image_mixin__image_256	base	ir.model.fields	801
2206	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_image_mixin__image_128	base	ir.model.fields	802
2207	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_avatar_mixin__image_1920	base	ir.model.fields	803
2208	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_avatar_mixin__image_1024	base	ir.model.fields	804
2209	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_avatar_mixin__image_512	base	ir.model.fields	805
2210	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_avatar_mixin__image_256	base	ir.model.fields	806
2211	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_avatar_mixin__image_128	base	ir.model.fields	807
2212	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_avatar_mixin__avatar_1920	base	ir.model.fields	808
2213	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_avatar_mixin__avatar_1024	base	ir.model.fields	809
2214	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_avatar_mixin__avatar_512	base	ir.model.fields	810
2215	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_avatar_mixin__avatar_256	base	ir.model.fields	811
2216	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_avatar_mixin__avatar_128	base	ir.model.fields	812
2217	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__name	base	ir.model.fields	813
2218	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__code	base	ir.model.fields	814
2219	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__address_format	base	ir.model.fields	815
2220	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__address_view_id	base	ir.model.fields	816
2221	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__currency_id	base	ir.model.fields	817
2222	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__image_url	base	ir.model.fields	818
2223	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__phone_code	base	ir.model.fields	819
2224	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__country_group_ids	base	ir.model.fields	820
2225	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__state_ids	base	ir.model.fields	821
2226	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__name_position	base	ir.model.fields	822
2227	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__vat_label	base	ir.model.fields	823
2228	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__state_required	base	ir.model.fields	824
2229	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__zip_required	base	ir.model.fields	825
2230	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__id	base	ir.model.fields	826
2231	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country____last_update	base	ir.model.fields	827
2232	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__display_name	base	ir.model.fields	828
2233	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__create_uid	base	ir.model.fields	829
2234	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__create_date	base	ir.model.fields	830
2235	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__write_uid	base	ir.model.fields	831
2236	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country__write_date	base	ir.model.fields	832
2237	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_group__name	base	ir.model.fields	833
2238	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_group__country_ids	base	ir.model.fields	834
2239	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_group__id	base	ir.model.fields	835
2240	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_group____last_update	base	ir.model.fields	836
2241	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_group__display_name	base	ir.model.fields	837
2242	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_group__create_uid	base	ir.model.fields	838
2243	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_group__create_date	base	ir.model.fields	839
2244	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_group__write_uid	base	ir.model.fields	840
2245	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_group__write_date	base	ir.model.fields	841
2246	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_state__country_id	base	ir.model.fields	842
2247	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_state__name	base	ir.model.fields	843
2248	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_state__code	base	ir.model.fields	844
2249	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_state__id	base	ir.model.fields	845
2250	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_state____last_update	base	ir.model.fields	846
2251	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_state__display_name	base	ir.model.fields	847
2252	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_state__create_uid	base	ir.model.fields	848
2253	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_state__create_date	base	ir.model.fields	849
2254	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_state__write_uid	base	ir.model.fields	850
2255	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_country_state__write_date	base	ir.model.fields	851
2256	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__name	base	ir.model.fields	852
2257	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__code	base	ir.model.fields	853
2258	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__iso_code	base	ir.model.fields	854
2259	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__url_code	base	ir.model.fields	855
2260	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__active	base	ir.model.fields	856
2261	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__direction	base	ir.model.fields	857
2262	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__date_format	base	ir.model.fields	858
2263	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__time_format	base	ir.model.fields	859
2264	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__week_start	base	ir.model.fields	860
2265	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__grouping	base	ir.model.fields	861
2266	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__decimal_point	base	ir.model.fields	862
2267	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__thousands_sep	base	ir.model.fields	863
2268	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__flag_image	base	ir.model.fields	864
2269	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__flag_image_url	base	ir.model.fields	865
2270	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__id	base	ir.model.fields	866
2271	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang____last_update	base	ir.model.fields	867
2272	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__display_name	base	ir.model.fields	868
2273	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__create_uid	base	ir.model.fields	869
2274	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__create_date	base	ir.model.fields	870
2275	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__write_uid	base	ir.model.fields	871
2276	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_lang__write_date	base	ir.model.fields	872
2277	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__name	base	ir.model.fields	873
2278	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__color	base	ir.model.fields	874
2279	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__parent_id	base	ir.model.fields	875
2280	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__child_ids	base	ir.model.fields	876
2281	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__active	base	ir.model.fields	877
2282	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__parent_path	base	ir.model.fields	878
2283	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__partner_ids	base	ir.model.fields	879
2284	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__id	base	ir.model.fields	880
2285	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category____last_update	base	ir.model.fields	881
2286	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__display_name	base	ir.model.fields	882
2287	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__create_uid	base	ir.model.fields	883
2288	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__create_date	base	ir.model.fields	884
2289	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__write_uid	base	ir.model.fields	885
2290	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_category__write_date	base	ir.model.fields	886
2291	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_title__name	base	ir.model.fields	887
2292	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_title__shortcut	base	ir.model.fields	888
2293	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_title__id	base	ir.model.fields	889
2294	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_title____last_update	base	ir.model.fields	890
2295	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_title__display_name	base	ir.model.fields	891
2296	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_title__create_uid	base	ir.model.fields	892
2297	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_title__create_date	base	ir.model.fields	893
2298	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_title__write_uid	base	ir.model.fields	894
2299	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_title__write_date	base	ir.model.fields	895
2300	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__image_1920	base	ir.model.fields	896
2301	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__image_1024	base	ir.model.fields	897
2302	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__image_512	base	ir.model.fields	898
2303	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__image_256	base	ir.model.fields	899
2304	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__image_128	base	ir.model.fields	900
2305	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__avatar_1920	base	ir.model.fields	901
2306	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__avatar_1024	base	ir.model.fields	902
2307	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__avatar_512	base	ir.model.fields	903
2308	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__avatar_256	base	ir.model.fields	904
2309	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__avatar_128	base	ir.model.fields	905
2310	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__name	base	ir.model.fields	906
2311	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__display_name	base	ir.model.fields	907
2312	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__date	base	ir.model.fields	908
2313	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__title	base	ir.model.fields	909
2314	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__parent_id	base	ir.model.fields	910
2315	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__parent_name	base	ir.model.fields	911
2316	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__child_ids	base	ir.model.fields	912
2317	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__ref	base	ir.model.fields	913
2318	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__lang	base	ir.model.fields	914
2319	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__active_lang_count	base	ir.model.fields	915
2320	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__tz	base	ir.model.fields	916
2321	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__tz_offset	base	ir.model.fields	917
2322	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__user_id	base	ir.model.fields	918
2323	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__vat	base	ir.model.fields	919
2324	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__same_vat_partner_id	base	ir.model.fields	920
2325	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__bank_ids	base	ir.model.fields	921
2326	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__website	base	ir.model.fields	922
2327	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__comment	base	ir.model.fields	923
2328	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__category_id	base	ir.model.fields	924
2329	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__credit_limit	base	ir.model.fields	925
2330	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__active	base	ir.model.fields	926
2331	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__employee	base	ir.model.fields	927
2332	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__function	base	ir.model.fields	928
2333	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__type	base	ir.model.fields	929
2334	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__street	base	ir.model.fields	930
2335	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__street2	base	ir.model.fields	931
2336	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__zip	base	ir.model.fields	932
2337	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__city	base	ir.model.fields	933
2338	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__state_id	base	ir.model.fields	934
2339	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__country_id	base	ir.model.fields	935
2340	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__country_code	base	ir.model.fields	936
2341	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__partner_latitude	base	ir.model.fields	937
2342	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__partner_longitude	base	ir.model.fields	938
2343	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__email	base	ir.model.fields	939
2344	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__email_formatted	base	ir.model.fields	940
2345	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__phone	base	ir.model.fields	941
2346	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__mobile	base	ir.model.fields	942
2347	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__is_company	base	ir.model.fields	943
2348	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__industry_id	base	ir.model.fields	944
2349	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__company_type	base	ir.model.fields	945
2350	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__company_id	base	ir.model.fields	946
2351	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__color	base	ir.model.fields	947
2352	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__user_ids	base	ir.model.fields	948
2353	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__partner_share	base	ir.model.fields	949
2354	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__contact_address	base	ir.model.fields	950
2355	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__commercial_partner_id	base	ir.model.fields	951
2356	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__commercial_company_name	base	ir.model.fields	952
2357	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__company_name	base	ir.model.fields	953
2358	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__barcode	base	ir.model.fields	954
2359	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__self	base	ir.model.fields	955
2360	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__id	base	ir.model.fields	956
2361	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner____last_update	base	ir.model.fields	957
2362	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__create_uid	base	ir.model.fields	958
2363	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__create_date	base	ir.model.fields	959
2364	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__write_uid	base	ir.model.fields	960
2365	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner__write_date	base	ir.model.fields	961
2366	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_industry__name	base	ir.model.fields	962
2367	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_industry__full_name	base	ir.model.fields	963
2368	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_industry__active	base	ir.model.fields	964
2369	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_industry__id	base	ir.model.fields	965
2370	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_industry____last_update	base	ir.model.fields	966
2371	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_industry__display_name	base	ir.model.fields	967
2372	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_industry__create_uid	base	ir.model.fields	968
2373	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_industry__create_date	base	ir.model.fields	969
2374	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_industry__write_uid	base	ir.model.fields	970
2375	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_industry__write_date	base	ir.model.fields	971
2376	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__name	base	ir.model.fields	972
2377	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__street	base	ir.model.fields	973
2378	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__street2	base	ir.model.fields	974
2379	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__zip	base	ir.model.fields	975
2380	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__city	base	ir.model.fields	976
2381	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__state	base	ir.model.fields	977
2382	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__country	base	ir.model.fields	978
2383	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__email	base	ir.model.fields	979
2384	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__phone	base	ir.model.fields	980
2385	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__active	base	ir.model.fields	981
2386	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__bic	base	ir.model.fields	982
2387	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__id	base	ir.model.fields	983
2388	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank____last_update	base	ir.model.fields	984
2389	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__display_name	base	ir.model.fields	985
2390	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__create_uid	base	ir.model.fields	986
2391	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__create_date	base	ir.model.fields	987
2392	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__write_uid	base	ir.model.fields	988
2393	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_bank__write_date	base	ir.model.fields	989
2394	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__active	base	ir.model.fields	990
2395	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__acc_type	base	ir.model.fields	991
2396	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__acc_number	base	ir.model.fields	992
2397	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__sanitized_acc_number	base	ir.model.fields	993
2398	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__acc_holder_name	base	ir.model.fields	994
2399	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__partner_id	base	ir.model.fields	995
2400	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__bank_id	base	ir.model.fields	996
2401	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__bank_name	base	ir.model.fields	997
2402	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__bank_bic	base	ir.model.fields	998
2403	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__sequence	base	ir.model.fields	999
2404	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__currency_id	base	ir.model.fields	1000
2405	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__company_id	base	ir.model.fields	1001
2406	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__id	base	ir.model.fields	1002
2407	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank____last_update	base	ir.model.fields	1003
2408	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__display_name	base	ir.model.fields	1004
2409	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__create_uid	base	ir.model.fields	1005
2410	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__create_date	base	ir.model.fields	1006
2411	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__write_uid	base	ir.model.fields	1007
2412	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_partner_bank__write_date	base	ir.model.fields	1008
2413	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config__id	base	ir.model.fields	1009
2414	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config____last_update	base	ir.model.fields	1010
2415	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config__display_name	base	ir.model.fields	1011
2416	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config__create_uid	base	ir.model.fields	1012
2417	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config__create_date	base	ir.model.fields	1013
2418	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config__write_uid	base	ir.model.fields	1014
2419	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config__write_date	base	ir.model.fields	1015
2420	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_installer__id	base	ir.model.fields	1016
2421	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_installer____last_update	base	ir.model.fields	1017
2422	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_installer__display_name	base	ir.model.fields	1018
2423	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_installer__create_uid	base	ir.model.fields	1019
2424	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_installer__create_date	base	ir.model.fields	1020
2425	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_installer__write_uid	base	ir.model.fields	1021
2426	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_installer__write_date	base	ir.model.fields	1022
2427	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_settings__id	base	ir.model.fields	1023
2428	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_settings____last_update	base	ir.model.fields	1024
2429	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_settings__display_name	base	ir.model.fields	1025
2430	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_settings__create_uid	base	ir.model.fields	1026
2431	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_settings__create_date	base	ir.model.fields	1027
2432	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_settings__write_uid	base	ir.model.fields	1028
2433	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_config_settings__write_date	base	ir.model.fields	1029
2434	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__name	base	ir.model.fields	1030
2435	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__full_name	base	ir.model.fields	1031
2436	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__symbol	base	ir.model.fields	1032
2437	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__rate	base	ir.model.fields	1033
2438	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__inverse_rate	base	ir.model.fields	1034
2439	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__rate_string	base	ir.model.fields	1035
2440	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__rate_ids	base	ir.model.fields	1036
2441	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__rounding	base	ir.model.fields	1037
2442	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__decimal_places	base	ir.model.fields	1038
2443	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__active	base	ir.model.fields	1039
2444	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__position	base	ir.model.fields	1040
2445	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__date	base	ir.model.fields	1041
2446	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__currency_unit_label	base	ir.model.fields	1042
2447	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__currency_subunit_label	base	ir.model.fields	1043
2448	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__is_current_company_currency	base	ir.model.fields	1044
2449	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__id	base	ir.model.fields	1045
2450	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency____last_update	base	ir.model.fields	1046
2451	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__display_name	base	ir.model.fields	1047
2452	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__create_uid	base	ir.model.fields	1048
2453	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__create_date	base	ir.model.fields	1049
2454	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__write_uid	base	ir.model.fields	1050
2455	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency__write_date	base	ir.model.fields	1051
2456	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__name	base	ir.model.fields	1052
2457	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__rate	base	ir.model.fields	1053
2458	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__company_rate	base	ir.model.fields	1054
2459	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__inverse_company_rate	base	ir.model.fields	1055
2460	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__currency_id	base	ir.model.fields	1056
2461	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__company_id	base	ir.model.fields	1057
2462	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__id	base	ir.model.fields	1058
2463	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate____last_update	base	ir.model.fields	1059
2464	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__display_name	base	ir.model.fields	1060
2465	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__create_uid	base	ir.model.fields	1061
2466	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__create_date	base	ir.model.fields	1062
2467	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__write_uid	base	ir.model.fields	1063
2468	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_currency_rate__write_date	base	ir.model.fields	1064
2469	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__name	base	ir.model.fields	1065
2470	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__sequence	base	ir.model.fields	1066
2471	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__parent_id	base	ir.model.fields	1067
2472	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__child_ids	base	ir.model.fields	1068
2473	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__partner_id	base	ir.model.fields	1069
2474	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__report_header	base	ir.model.fields	1070
2475	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__report_footer	base	ir.model.fields	1071
2476	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__company_details	base	ir.model.fields	1072
2477	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__logo	base	ir.model.fields	1073
2478	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__logo_web	base	ir.model.fields	1074
2479	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__currency_id	base	ir.model.fields	1075
2480	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__user_ids	base	ir.model.fields	1076
2481	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__street	base	ir.model.fields	1077
2482	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__street2	base	ir.model.fields	1078
2483	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__zip	base	ir.model.fields	1079
2484	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__city	base	ir.model.fields	1080
2485	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__state_id	base	ir.model.fields	1081
2486	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__bank_ids	base	ir.model.fields	1082
2487	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__country_id	base	ir.model.fields	1083
2488	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__email	base	ir.model.fields	1084
2489	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__phone	base	ir.model.fields	1085
2490	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__mobile	base	ir.model.fields	1086
2491	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__website	base	ir.model.fields	1087
2492	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__vat	base	ir.model.fields	1088
2493	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__company_registry	base	ir.model.fields	1089
2494	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__paperformat_id	base	ir.model.fields	1090
2495	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__external_report_layout_id	base	ir.model.fields	1091
2496	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__base_onboarding_company_state	base	ir.model.fields	1092
2497	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__favicon	base	ir.model.fields	1093
2498	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__font	base	ir.model.fields	1094
2499	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__primary_color	base	ir.model.fields	1095
2500	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__secondary_color	base	ir.model.fields	1096
2501	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__layout_background	base	ir.model.fields	1097
2502	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__layout_background_image	base	ir.model.fields	1098
2503	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__id	base	ir.model.fields	1099
2504	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company____last_update	base	ir.model.fields	1100
2505	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__display_name	base	ir.model.fields	1101
2506	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__create_uid	base	ir.model.fields	1102
2507	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__create_date	base	ir.model.fields	1103
2508	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__write_uid	base	ir.model.fields	1104
2509	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_company__write_date	base	ir.model.fields	1105
2510	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__name	base	ir.model.fields	1106
2511	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__users	base	ir.model.fields	1107
2512	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__model_access	base	ir.model.fields	1108
2513	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__rule_groups	base	ir.model.fields	1109
2514	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__menu_access	base	ir.model.fields	1110
2515	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__view_access	base	ir.model.fields	1111
2516	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__comment	base	ir.model.fields	1112
2517	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__category_id	base	ir.model.fields	1113
2518	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__color	base	ir.model.fields	1114
2519	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__full_name	base	ir.model.fields	1115
2520	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__share	base	ir.model.fields	1116
2521	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__id	base	ir.model.fields	1117
2522	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups____last_update	base	ir.model.fields	1118
2523	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__display_name	base	ir.model.fields	1119
2524	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__create_uid	base	ir.model.fields	1120
2525	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__create_date	base	ir.model.fields	1121
2526	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__write_uid	base	ir.model.fields	1122
2527	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__write_date	base	ir.model.fields	1123
2528	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__implied_ids	base	ir.model.fields	1124
2529	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_groups__trans_implied_ids	base	ir.model.fields	1125
2530	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_log__id	base	ir.model.fields	1126
2531	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_log____last_update	base	ir.model.fields	1127
2532	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_log__display_name	base	ir.model.fields	1128
2533	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_log__create_uid	base	ir.model.fields	1129
2534	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_log__create_date	base	ir.model.fields	1130
2535	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_log__write_uid	base	ir.model.fields	1131
2536	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_log__write_date	base	ir.model.fields	1132
2537	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__partner_id	base	ir.model.fields	1133
2538	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__login	base	ir.model.fields	1134
2539	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__password	base	ir.model.fields	1135
2540	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__new_password	base	ir.model.fields	1136
2541	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__signature	base	ir.model.fields	1137
2542	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__active	base	ir.model.fields	1138
2543	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__active_partner	base	ir.model.fields	1139
2544	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__action_id	base	ir.model.fields	1140
2545	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__groups_id	base	ir.model.fields	1141
2546	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__log_ids	base	ir.model.fields	1142
2547	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__login_date	base	ir.model.fields	1143
2548	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__share	base	ir.model.fields	1144
2549	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__companies_count	base	ir.model.fields	1145
2550	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__tz_offset	base	ir.model.fields	1146
2551	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__company_id	base	ir.model.fields	1147
2552	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__company_ids	base	ir.model.fields	1148
2553	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__name	base	ir.model.fields	1149
2554	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__email	base	ir.model.fields	1150
2555	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__accesses_count	base	ir.model.fields	1151
2556	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__rules_count	base	ir.model.fields	1152
2557	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__groups_count	base	ir.model.fields	1153
2558	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__id	base	ir.model.fields	1154
2559	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users____last_update	base	ir.model.fields	1155
2560	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__display_name	base	ir.model.fields	1156
2561	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__create_uid	base	ir.model.fields	1157
2562	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__create_date	base	ir.model.fields	1158
2563	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__write_uid	base	ir.model.fields	1159
2564	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__write_date	base	ir.model.fields	1160
2565	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__api_key_ids	base	ir.model.fields	1161
2566	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__image_1920	base	ir.model.fields	1162
2567	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__image_1024	base	ir.model.fields	1163
2568	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__image_512	base	ir.model.fields	1164
2569	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__image_256	base	ir.model.fields	1165
2570	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__image_128	base	ir.model.fields	1166
2571	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__avatar_1920	base	ir.model.fields	1167
2572	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__avatar_1024	base	ir.model.fields	1168
2573	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__avatar_512	base	ir.model.fields	1169
2574	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__avatar_256	base	ir.model.fields	1170
2575	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__avatar_128	base	ir.model.fields	1171
2576	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__date	base	ir.model.fields	1172
2577	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__title	base	ir.model.fields	1173
2578	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__parent_id	base	ir.model.fields	1174
2579	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__parent_name	base	ir.model.fields	1175
2580	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__child_ids	base	ir.model.fields	1176
2581	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__ref	base	ir.model.fields	1177
2582	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__lang	base	ir.model.fields	1178
2583	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__active_lang_count	base	ir.model.fields	1179
2584	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__tz	base	ir.model.fields	1180
2585	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__user_id	base	ir.model.fields	1181
2586	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__vat	base	ir.model.fields	1182
2587	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__same_vat_partner_id	base	ir.model.fields	1183
2588	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__bank_ids	base	ir.model.fields	1184
2589	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__website	base	ir.model.fields	1185
2590	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__comment	base	ir.model.fields	1186
2591	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__category_id	base	ir.model.fields	1187
2592	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__credit_limit	base	ir.model.fields	1188
2593	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__employee	base	ir.model.fields	1189
2594	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__function	base	ir.model.fields	1190
2595	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__type	base	ir.model.fields	1191
2596	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__street	base	ir.model.fields	1192
2597	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__street2	base	ir.model.fields	1193
2598	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__zip	base	ir.model.fields	1194
2599	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__city	base	ir.model.fields	1195
2600	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__state_id	base	ir.model.fields	1196
2601	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__country_id	base	ir.model.fields	1197
2602	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__country_code	base	ir.model.fields	1198
2603	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__partner_latitude	base	ir.model.fields	1199
2604	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__partner_longitude	base	ir.model.fields	1200
2605	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__email_formatted	base	ir.model.fields	1201
2606	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__phone	base	ir.model.fields	1202
2607	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__mobile	base	ir.model.fields	1203
2608	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__is_company	base	ir.model.fields	1204
2609	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__industry_id	base	ir.model.fields	1205
2610	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__company_type	base	ir.model.fields	1206
2611	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__color	base	ir.model.fields	1207
2612	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__user_ids	base	ir.model.fields	1208
2613	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__partner_share	base	ir.model.fields	1209
2614	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__contact_address	base	ir.model.fields	1210
2615	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__commercial_partner_id	base	ir.model.fields	1211
2616	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__commercial_company_name	base	ir.model.fields	1212
2617	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__company_name	base	ir.model.fields	1213
2618	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__barcode	base	ir.model.fields	1214
2619	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users__self	base	ir.model.fields	1215
2620	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_identitycheck__request	base	ir.model.fields	1216
2621	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_identitycheck__password	base	ir.model.fields	1217
2622	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_identitycheck__id	base	ir.model.fields	1218
2623	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_identitycheck____last_update	base	ir.model.fields	1219
2624	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_identitycheck__display_name	base	ir.model.fields	1220
2625	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_identitycheck__create_uid	base	ir.model.fields	1221
2626	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_identitycheck__create_date	base	ir.model.fields	1222
2627	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_identitycheck__write_uid	base	ir.model.fields	1223
2628	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_identitycheck__write_date	base	ir.model.fields	1224
2629	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_wizard__user_ids	base	ir.model.fields	1225
2630	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_wizard__id	base	ir.model.fields	1226
2631	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_wizard____last_update	base	ir.model.fields	1227
2632	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_wizard__display_name	base	ir.model.fields	1228
2633	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_wizard__create_uid	base	ir.model.fields	1229
2634	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_wizard__create_date	base	ir.model.fields	1230
2635	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_wizard__write_uid	base	ir.model.fields	1231
2636	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_wizard__write_date	base	ir.model.fields	1232
2637	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_user__wizard_id	base	ir.model.fields	1233
2638	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_user__user_id	base	ir.model.fields	1234
2639	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_user__user_login	base	ir.model.fields	1235
2640	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_user__new_passwd	base	ir.model.fields	1236
2641	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_user__id	base	ir.model.fields	1237
2642	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_user____last_update	base	ir.model.fields	1238
2643	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_user__display_name	base	ir.model.fields	1239
2644	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_user__create_uid	base	ir.model.fields	1240
2645	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_user__create_date	base	ir.model.fields	1241
2646	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_user__write_uid	base	ir.model.fields	1242
2647	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_change_password_user__write_date	base	ir.model.fields	1243
2648	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys__name	base	ir.model.fields	1244
2649	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys__user_id	base	ir.model.fields	1245
2650	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys__scope	base	ir.model.fields	1246
2651	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys__create_date	base	ir.model.fields	1247
2652	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys__id	base	ir.model.fields	1248
2653	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys____last_update	base	ir.model.fields	1249
2654	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys__display_name	base	ir.model.fields	1250
2655	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys_description__name	base	ir.model.fields	1251
2656	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys_description__id	base	ir.model.fields	1252
2657	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys_description____last_update	base	ir.model.fields	1253
2658	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys_description__display_name	base	ir.model.fields	1254
2659	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys_description__create_uid	base	ir.model.fields	1255
2660	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys_description__create_date	base	ir.model.fields	1256
2661	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys_description__write_uid	base	ir.model.fields	1257
2662	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys_description__write_date	base	ir.model.fields	1258
2663	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys_show__id	base	ir.model.fields	1259
2664	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_res_users_apikeys_show__key	base	ir.model.fields	1260
2665	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_decimal_precision__name	base	ir.model.fields	1261
2666	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_decimal_precision__digits	base	ir.model.fields	1262
2667	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_decimal_precision__id	base	ir.model.fields	1263
2668	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_decimal_precision____last_update	base	ir.model.fields	1264
2669	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_decimal_precision__display_name	base	ir.model.fields	1265
2670	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_decimal_precision__create_uid	base	ir.model.fields	1266
2671	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_decimal_precision__create_date	base	ir.model.fields	1267
2672	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_decimal_precision__write_uid	base	ir.model.fields	1268
2673	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_decimal_precision__write_date	base	ir.model.fields	1269
2674	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_update__updated	base	ir.model.fields	1270
2675	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_update__added	base	ir.model.fields	1271
2676	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_update__state	base	ir.model.fields	1272
2677	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_update__id	base	ir.model.fields	1273
2678	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_update____last_update	base	ir.model.fields	1274
2679	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_update__display_name	base	ir.model.fields	1275
2680	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_update__create_uid	base	ir.model.fields	1276
2681	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_update__create_date	base	ir.model.fields	1277
2682	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_update__write_uid	base	ir.model.fields	1278
2683	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_update__write_date	base	ir.model.fields	1279
2684	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_install__lang	base	ir.model.fields	1280
2685	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_install__overwrite	base	ir.model.fields	1281
2686	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_install__state	base	ir.model.fields	1282
2687	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_install__id	base	ir.model.fields	1283
2688	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_install____last_update	base	ir.model.fields	1284
2689	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_install__display_name	base	ir.model.fields	1285
2690	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_install__create_uid	base	ir.model.fields	1286
2691	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_install__create_date	base	ir.model.fields	1287
2692	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_install__write_uid	base	ir.model.fields	1288
2693	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_install__write_date	base	ir.model.fields	1289
2694	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import__name	base	ir.model.fields	1290
2695	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import__code	base	ir.model.fields	1291
2696	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import__data	base	ir.model.fields	1292
2697	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import__filename	base	ir.model.fields	1293
2698	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import__overwrite	base	ir.model.fields	1294
2699	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import__id	base	ir.model.fields	1295
2700	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import____last_update	base	ir.model.fields	1296
2701	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import__display_name	base	ir.model.fields	1297
2702	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import__create_uid	base	ir.model.fields	1298
2703	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import__create_date	base	ir.model.fields	1299
2704	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import__write_uid	base	ir.model.fields	1300
2705	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_import__write_date	base	ir.model.fields	1301
2706	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_upgrade__module_info	base	ir.model.fields	1302
2707	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_upgrade__id	base	ir.model.fields	1303
2708	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_upgrade____last_update	base	ir.model.fields	1304
2709	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_upgrade__display_name	base	ir.model.fields	1305
2710	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_upgrade__create_uid	base	ir.model.fields	1306
2711	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_upgrade__create_date	base	ir.model.fields	1307
2712	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_upgrade__write_uid	base	ir.model.fields	1308
2713	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_upgrade__write_date	base	ir.model.fields	1309
2714	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_uninstall__show_all	base	ir.model.fields	1310
2715	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_uninstall__module_id	base	ir.model.fields	1311
2716	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_uninstall__module_ids	base	ir.model.fields	1312
2717	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_uninstall__model_ids	base	ir.model.fields	1313
2718	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_uninstall__id	base	ir.model.fields	1314
2719	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_uninstall____last_update	base	ir.model.fields	1315
2720	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_uninstall__display_name	base	ir.model.fields	1316
2721	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_uninstall__create_uid	base	ir.model.fields	1317
2722	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_uninstall__create_date	base	ir.model.fields	1318
2723	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_uninstall__write_uid	base	ir.model.fields	1319
2724	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_module_uninstall__write_date	base	ir.model.fields	1320
2725	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__name	base	ir.model.fields	1321
2726	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__lang	base	ir.model.fields	1322
2727	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__format	base	ir.model.fields	1323
2728	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__modules	base	ir.model.fields	1324
2729	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__data	base	ir.model.fields	1325
2730	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__state	base	ir.model.fields	1326
2731	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__id	base	ir.model.fields	1327
2732	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export____last_update	base	ir.model.fields	1328
2733	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__display_name	base	ir.model.fields	1329
2734	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__create_uid	base	ir.model.fields	1330
2735	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__create_date	base	ir.model.fields	1331
2736	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__write_uid	base	ir.model.fields	1332
2737	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_language_export__write_date	base	ir.model.fields	1333
2738	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_update_translations__lang	base	ir.model.fields	1334
2739	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_update_translations__id	base	ir.model.fields	1335
2740	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_update_translations____last_update	base	ir.model.fields	1336
2741	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_update_translations__display_name	base	ir.model.fields	1337
2742	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_update_translations__create_uid	base	ir.model.fields	1338
2743	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_update_translations__create_date	base	ir.model.fields	1339
2744	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_update_translations__write_uid	base	ir.model.fields	1340
2745	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_update_translations__write_date	base	ir.model.fields	1341
2746	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_line__wizard_id	base	ir.model.fields	1342
2747	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_line__min_id	base	ir.model.fields	1343
2748	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_line__aggr_ids	base	ir.model.fields	1344
2749	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_line__id	base	ir.model.fields	1345
2750	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_line____last_update	base	ir.model.fields	1346
2751	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_line__display_name	base	ir.model.fields	1347
2752	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_line__create_uid	base	ir.model.fields	1348
2753	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_line__create_date	base	ir.model.fields	1349
2754	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_line__write_uid	base	ir.model.fields	1350
2755	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_line__write_date	base	ir.model.fields	1351
2756	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__group_by_email	base	ir.model.fields	1352
2757	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__group_by_name	base	ir.model.fields	1353
2758	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__group_by_is_company	base	ir.model.fields	1354
2759	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__group_by_vat	base	ir.model.fields	1355
2760	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__group_by_parent_id	base	ir.model.fields	1356
2761	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__state	base	ir.model.fields	1357
2762	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__number_group	base	ir.model.fields	1358
2763	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__current_line_id	base	ir.model.fields	1359
2764	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__line_ids	base	ir.model.fields	1360
2765	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__partner_ids	base	ir.model.fields	1361
2766	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__dst_partner_id	base	ir.model.fields	1362
2767	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__exclude_contact	base	ir.model.fields	1363
2768	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__exclude_journal_item	base	ir.model.fields	1364
2769	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__maximum_group	base	ir.model.fields	1365
2770	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__id	base	ir.model.fields	1366
2771	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard____last_update	base	ir.model.fields	1367
2772	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__display_name	base	ir.model.fields	1368
2773	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__create_uid	base	ir.model.fields	1369
2774	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__create_date	base	ir.model.fields	1370
2775	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__write_uid	base	ir.model.fields	1371
2776	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	field_base_partner_merge_automatic_wizard__write_date	base	ir.model.fields	1372
2874	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:57.429843	\N	f	selection__ir_attachment__type__url	base	ir.model.fields.selection	98
3044	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_bank_1	base	res.bank	1
3045	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_en	base	res.lang	1
3048	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_ar_SY	base	res.lang	4
3049	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_eu_ES	base	res.lang	5
3050	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_bn_IN	base	res.lang	6
3051	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_bs_BA	base	res.lang	7
3052	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_bg	base	res.lang	8
3053	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_ca_ES	base	res.lang	9
3054	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_zh_CN	base	res.lang	10
3055	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_zh_HK	base	res.lang	11
3056	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_zh_TW	base	res.lang	12
3057	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_hr	base	res.lang	13
3058	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_cs_CZ	base	res.lang	14
3059	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_da_DK	base	res.lang	15
3060	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_nl_BE	base	res.lang	16
3061	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_nl	base	res.lang	17
3062	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_en_AU	base	res.lang	18
3063	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_en_CA	base	res.lang	19
3064	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_en_GB	base	res.lang	20
3065	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_en_IN	base	res.lang	21
3066	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_et_EE	base	res.lang	22
3067	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_fi	base	res.lang	23
3068	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_fr_BE	base	res.lang	24
3069	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_fr_CA	base	res.lang	25
3070	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_fr_CH	base	res.lang	26
3071	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_fr	base	res.lang	27
3072	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_gl_ES	base	res.lang	28
3073	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_ka_GE	base	res.lang	29
3074	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_de	base	res.lang	30
3075	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_de_CH	base	res.lang	31
3076	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_el_GR	base	res.lang	32
3077	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_gu_IN	base	res.lang	33
3078	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_he_IL	base	res.lang	34
3079	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_hi_IN	base	res.lang	35
3080	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_hu	base	res.lang	36
3081	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_id	base	res.lang	37
3082	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_it	base	res.lang	38
3083	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_ja_JP	base	res.lang	39
3084	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_kab_DZ	base	res.lang	40
3085	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_km	base	res.lang	41
3086	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_ko_KP	base	res.lang	42
3087	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_ko_KR	base	res.lang	43
3088	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_lo_LA	base	res.lang	44
3089	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_lv	base	res.lang	45
3090	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_lt	base	res.lang	46
3091	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_lb	base	res.lang	47
3092	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_mk	base	res.lang	48
3093	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_mn	base	res.lang	49
3094	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_ms	base	res.lang	50
3096	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_nb_NO	base	res.lang	52
3097	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_fa_IR	base	res.lang	53
3098	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_pl	base	res.lang	54
3099	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_pt_AO	base	res.lang	55
3100	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_pt_BR	base	res.lang	56
3101	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_pt	base	res.lang	57
3102	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_ro	base	res.lang	58
3103	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_ru	base	res.lang	59
3104	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_sr_RS	base	res.lang	60
3105	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_sr@latin	base	res.lang	61
3106	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_sk	base	res.lang	62
3107	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_sl_SI	base	res.lang	63
3108	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_AR	base	res.lang	64
3109	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_BO	base	res.lang	65
3110	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_CL	base	res.lang	66
3111	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_CO	base	res.lang	67
3112	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_CR	base	res.lang	68
3113	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_DO	base	res.lang	69
3114	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_EC	base	res.lang	70
3115	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_GT	base	res.lang	71
3116	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_MX	base	res.lang	72
3117	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_PA	base	res.lang	73
3118	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_PE	base	res.lang	74
3119	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_PY	base	res.lang	75
3120	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_UY	base	res.lang	76
3121	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es_VE	base	res.lang	77
3122	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_es	base	res.lang	78
3123	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_sv_SE	base	res.lang	79
3124	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_th	base	res.lang	80
3125	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_tl	base	res.lang	81
3126	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_tr	base	res.lang	82
3127	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_uk_UA	base	res.lang	83
3128	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_vi_VN	base	res.lang	84
3129	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_sq_AL	base	res.lang	85
3130	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_te_IN	base	res.lang	86
3095	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_my	base	res.lang	51
3047	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	lang_ar	base	res.lang	3
3	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	main_partner	base	res.partner	1
3134	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	partner_root	base	res.partner	2
3135	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	partner_admin	base	res.partner	3
3136	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	public_partner	base	res.partner	4
3137	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_title_madam	base	res.partner.title	1
3138	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_title_miss	base	res.partner.title	2
3139	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_title_mister	base	res.partner.title	3
3140	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_title_doctor	base	res.partner.title	4
3141	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_title_prof	base	res.partner.title	5
3142	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_A	base	res.partner.industry	1
3143	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_B	base	res.partner.industry	2
3144	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_C	base	res.partner.industry	3
3145	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_D	base	res.partner.industry	4
3146	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_E	base	res.partner.industry	5
3147	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_F	base	res.partner.industry	6
3148	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_G	base	res.partner.industry	7
3149	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_H	base	res.partner.industry	8
3150	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_I	base	res.partner.industry	9
3151	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_J	base	res.partner.industry	10
3152	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_K	base	res.partner.industry	11
3153	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_L	base	res.partner.industry	12
3154	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_M	base	res.partner.industry	13
3155	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_N	base	res.partner.industry	14
3156	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_O	base	res.partner.industry	15
3157	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_P	base	res.partner.industry	16
3158	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_Q	base	res.partner.industry	17
3159	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_R	base	res.partner.industry	18
3160	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_S	base	res.partner.industry	19
3161	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_T	base	res.partner.industry	20
3162	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_industry_U	base	res.partner.industry	21
3163	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	USD	base	res.currency	2
3164	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	VEF	base	res.currency	3
3165	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CAD	base	res.currency	4
3166	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CHF	base	res.currency	5
3167	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BRL	base	res.currency	6
3168	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CNY	base	res.currency	7
3169	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CNH	base	res.currency	8
3170	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	COP	base	res.currency	9
3171	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CZK	base	res.currency	10
3172	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	DKK	base	res.currency	11
3173	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	HUF	base	res.currency	12
3174	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	IDR	base	res.currency	13
3175	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	LVL	base	res.currency	14
3176	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	NOK	base	res.currency	15
3177	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	XPF	base	res.currency	16
3178	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	PAB	base	res.currency	17
3179	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	PLN	base	res.currency	18
3180	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SEK	base	res.currency	19
3181	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ARS	base	res.currency	20
3182	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	INR	base	res.currency	21
3183	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	AUD	base	res.currency	22
3184	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	UAH	base	res.currency	23
3185	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	VND	base	res.currency	24
3186	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	HKD	base	res.currency	25
3187	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	JPY	base	res.currency	26
3188	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BGN	base	res.currency	27
3189	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	LTL	base	res.currency	28
3190	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	RON	base	res.currency	29
3191	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	HRK	base	res.currency	30
3192	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	RUB	base	res.currency	31
3193	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	TRY	base	res.currency	32
3194	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	KRW	base	res.currency	33
3195	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MXN	base	res.currency	34
3196	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MYR	base	res.currency	35
3197	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	NZD	base	res.currency	36
3198	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	PHP	base	res.currency	37
3199	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SGD	base	res.currency	38
3200	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ZAR	base	res.currency	39
3201	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CRC	base	res.currency	40
3202	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MUR	base	res.currency	41
3203	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	XOF	base	res.currency	42
3204	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	XAF	base	res.currency	43
3205	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	UGX	base	res.currency	44
3206	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	HNL	base	res.currency	45
3207	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CLP	base	res.currency	46
3208	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	UYU	base	res.currency	47
3209	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	AFN	base	res.currency	48
3210	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	AOA	base	res.currency	49
3211	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	XCD	base	res.currency	50
3212	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	AMD	base	res.currency	51
3213	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	AWG	base	res.currency	52
3214	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	AZN	base	res.currency	53
3215	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BSD	base	res.currency	54
3216	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BHD	base	res.currency	55
3217	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BDT	base	res.currency	56
3218	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BBD	base	res.currency	57
3219	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BYR	base	res.currency	58
3220	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BYN	base	res.currency	59
3221	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BZD	base	res.currency	60
3222	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BMD	base	res.currency	61
3223	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BTN	base	res.currency	62
3224	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BOB	base	res.currency	63
3225	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BAM	base	res.currency	64
3226	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BWP	base	res.currency	65
3227	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BIF	base	res.currency	66
3228	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	KHR	base	res.currency	67
3229	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	KYD	base	res.currency	68
3230	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	KMF	base	res.currency	69
3231	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CDF	base	res.currency	70
3232	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CUP	base	res.currency	71
3233	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ANG	base	res.currency	72
3234	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	DJF	base	res.currency	73
3235	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	DOP	base	res.currency	74
3236	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	EGP	base	res.currency	75
3237	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SVC	base	res.currency	76
3238	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ERN	base	res.currency	77
3239	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ETB	base	res.currency	78
3240	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	FKP	base	res.currency	79
3241	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	FJD	base	res.currency	80
3242	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	GEL	base	res.currency	81
3243	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	GIP	base	res.currency	82
3244	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	GNF	base	res.currency	83
3245	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	GYD	base	res.currency	84
3246	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	HTG	base	res.currency	85
3247	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ISK	base	res.currency	86
3248	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	IRR	base	res.currency	87
3249	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	IQD	base	res.currency	88
3250	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ILS	base	res.currency	89
3251	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	JMD	base	res.currency	90
3252	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	JOD	base	res.currency	91
3253	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	KZT	base	res.currency	92
3254	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	KES	base	res.currency	93
3255	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	KWD	base	res.currency	94
3256	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	KGS	base	res.currency	95
3257	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	LAK	base	res.currency	96
3258	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	LBP	base	res.currency	97
3259	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	LSL	base	res.currency	98
3260	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	LRD	base	res.currency	99
3261	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	LYD	base	res.currency	100
3262	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MOP	base	res.currency	101
3263	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MKD	base	res.currency	102
3264	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MGA	base	res.currency	103
3265	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MWK	base	res.currency	104
3266	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MVR	base	res.currency	105
3267	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MRO	base	res.currency	106
3268	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MRU	base	res.currency	107
3269	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MDL	base	res.currency	108
3270	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MNT	base	res.currency	109
3271	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MAD	base	res.currency	110
3272	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	BND	base	res.currency	111
3273	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	DZD	base	res.currency	112
3274	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	GHS	base	res.currency	113
3275	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	GMD	base	res.currency	114
3276	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MZN	base	res.currency	115
3277	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	MMK	base	res.currency	116
3278	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	NAD	base	res.currency	117
3279	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	NPR	base	res.currency	118
3280	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ALL	base	res.currency	119
3281	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	NIO	base	res.currency	120
3282	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	NGN	base	res.currency	121
3283	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	KPW	base	res.currency	122
3284	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ZWL	base	res.currency	123
3285	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ZIG	base	res.currency	124
3286	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ZMW	base	res.currency	125
3287	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	YER	base	res.currency	126
1	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	EUR	base	res.currency	1
3289	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	VUV	base	res.currency	127
3290	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	UZS	base	res.currency	128
3291	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	AED	base	res.currency	129
3292	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	TMT	base	res.currency	130
3293	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	TND	base	res.currency	131
3294	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	TTD	base	res.currency	132
3295	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	TOP	base	res.currency	133
3296	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	THB	base	res.currency	134
3297	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	TZS	base	res.currency	135
3298	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	TJS	base	res.currency	136
3299	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	TWD	base	res.currency	137
3300	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SYP	base	res.currency	138
3301	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SZL	base	res.currency	139
3302	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SRD	base	res.currency	140
3303	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SDG	base	res.currency	141
3304	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	LKR	base	res.currency	142
3305	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SSP	base	res.currency	143
3306	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	GBP	base	res.currency	144
3307	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SOS	base	res.currency	145
3308	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SBD	base	res.currency	146
3309	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SLL	base	res.currency	147
3310	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SCR	base	res.currency	148
3311	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	RSD	base	res.currency	149
3312	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SAR	base	res.currency	150
3313	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	STD	base	res.currency	151
3314	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	WST	base	res.currency	152
3315	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	SHP	base	res.currency	153
3316	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	RWF	base	res.currency	154
3317	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	QAR	base	res.currency	155
3318	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	PEN	base	res.currency	156
3319	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	PYG	base	res.currency	157
3320	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	PGK	base	res.currency	158
3321	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	PKR	base	res.currency	159
3322	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	OMR	base	res.currency	160
3323	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CVE	base	res.currency	161
3324	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	COU	base	res.currency	162
3325	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CLF	base	res.currency	163
3326	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	CUC	base	res.currency	164
3327	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	GTQ	base	res.currency	165
3328	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	VES	base	res.currency	166
3329	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	UYW	base	res.currency	167
3330	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	UYI	base	res.currency	168
3331	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	STN	base	res.currency	169
2	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	main_company	base	res.company	1
4	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	user_root	base	res.users	1
3334	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	user_admin	base	res.users	2
3335	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	default_user_res_partner	base	res.partner	5
3338	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	paperformat_euro	base	report.paperformat	1
3339	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	paperformat_us	base	report.paperformat	2
3340	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	paperformat_batch_deposit	base	report.paperformat	3
3341	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ad	base	res.country	1
3342	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ae	base	res.country	2
3343	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	af	base	res.country	3
3344	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ag	base	res.country	4
3345	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ai	base	res.country	5
3346	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	al	base	res.country	6
3347	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	am	base	res.country	7
3348	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ao	base	res.country	8
3349	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	aq	base	res.country	9
3350	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ar	base	res.country	10
3351	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	as	base	res.country	11
3352	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	at	base	res.country	12
3353	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	au	base	res.country	13
3354	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	aw	base	res.country	14
3355	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ax	base	res.country	15
3356	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	az	base	res.country	16
3357	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ba	base	res.country	17
3358	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bb	base	res.country	18
3359	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bd	base	res.country	19
3360	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	be	base	res.country	20
3361	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bf	base	res.country	21
3362	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bg	base	res.country	22
3363	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bh	base	res.country	23
3364	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bi	base	res.country	24
3365	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bj	base	res.country	25
3366	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bl	base	res.country	26
3367	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bm	base	res.country	27
3368	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bn	base	res.country	28
3369	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bo	base	res.country	29
3370	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bq	base	res.country	30
3371	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	br	base	res.country	31
3372	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bs	base	res.country	32
3373	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bt	base	res.country	33
3374	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bv	base	res.country	34
3375	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bw	base	res.country	35
3376	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	by	base	res.country	36
3377	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	bz	base	res.country	37
3378	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ca	base	res.country	38
3379	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cc	base	res.country	39
3380	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cf	base	res.country	40
3381	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cd	base	res.country	41
3382	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cg	base	res.country	42
3383	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ch	base	res.country	43
3384	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ci	base	res.country	44
3385	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ck	base	res.country	45
3386	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cl	base	res.country	46
3387	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cm	base	res.country	47
3388	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cn	base	res.country	48
3389	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	co	base	res.country	49
3390	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cr	base	res.country	50
3391	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cu	base	res.country	51
3392	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cv	base	res.country	52
3393	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cw	base	res.country	53
3394	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cx	base	res.country	54
3395	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cy	base	res.country	55
3396	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	cz	base	res.country	56
3397	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	de	base	res.country	57
3398	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	dj	base	res.country	58
3399	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	dk	base	res.country	59
3400	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	dm	base	res.country	60
3401	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	do	base	res.country	61
3402	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	dz	base	res.country	62
3403	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ec	base	res.country	63
3404	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ee	base	res.country	64
3405	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	eg	base	res.country	65
3406	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	eh	base	res.country	66
3407	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	er	base	res.country	67
3408	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	es	base	res.country	68
3409	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	et	base	res.country	69
3410	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	fi	base	res.country	70
3411	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	fj	base	res.country	71
3412	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	fk	base	res.country	72
3413	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	fm	base	res.country	73
3414	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	fo	base	res.country	74
3415	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	fr	base	res.country	75
3416	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ga	base	res.country	76
3417	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gd	base	res.country	77
3418	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ge	base	res.country	78
3419	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gf	base	res.country	79
3420	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gh	base	res.country	80
3421	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gi	base	res.country	81
3422	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gg	base	res.country	82
3423	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gl	base	res.country	83
3424	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gm	base	res.country	84
3425	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gn	base	res.country	85
3426	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gp	base	res.country	86
3427	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gq	base	res.country	87
3428	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gr	base	res.country	88
3429	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gs	base	res.country	89
3430	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gt	base	res.country	90
3431	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gu	base	res.country	91
3432	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gw	base	res.country	92
3433	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gy	base	res.country	93
3434	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	hk	base	res.country	94
3435	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	hm	base	res.country	95
3436	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	hn	base	res.country	96
3437	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	hr	base	res.country	97
3438	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ht	base	res.country	98
3439	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	hu	base	res.country	99
3440	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	id	base	res.country	100
3441	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ie	base	res.country	101
3442	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	il	base	res.country	102
3443	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	im	base	res.country	103
3444	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	in	base	res.country	104
3445	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	io	base	res.country	105
3446	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	iq	base	res.country	106
3447	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ir	base	res.country	107
3448	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	is	base	res.country	108
3449	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	it	base	res.country	109
3450	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	je	base	res.country	110
3451	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	jm	base	res.country	111
3452	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	jo	base	res.country	112
3453	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	jp	base	res.country	113
3454	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ke	base	res.country	114
3455	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	kg	base	res.country	115
3456	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	kh	base	res.country	116
3457	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ki	base	res.country	117
3458	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	km	base	res.country	118
3459	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	kn	base	res.country	119
3460	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	kp	base	res.country	120
3461	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	kr	base	res.country	121
3462	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	kw	base	res.country	122
3463	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ky	base	res.country	123
3464	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	kz	base	res.country	124
3465	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	la	base	res.country	125
3466	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	lb	base	res.country	126
3467	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	lc	base	res.country	127
3468	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	li	base	res.country	128
3469	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	lk	base	res.country	129
3470	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	lr	base	res.country	130
3471	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ls	base	res.country	131
3472	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	lt	base	res.country	132
3473	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	lu	base	res.country	133
3474	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	lv	base	res.country	134
3475	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ly	base	res.country	135
3476	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ma	base	res.country	136
3477	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mc	base	res.country	137
3478	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	md	base	res.country	138
3479	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	me	base	res.country	139
3480	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mf	base	res.country	140
3481	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mg	base	res.country	141
3482	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mh	base	res.country	142
3483	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mk	base	res.country	143
3484	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ml	base	res.country	144
3485	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mm	base	res.country	145
3486	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mn	base	res.country	146
3487	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mo	base	res.country	147
3488	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mp	base	res.country	148
3489	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mq	base	res.country	149
3490	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mr	base	res.country	150
3491	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ms	base	res.country	151
3492	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mt	base	res.country	152
3493	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mu	base	res.country	153
3494	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mv	base	res.country	154
3495	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mw	base	res.country	155
3496	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mx	base	res.country	156
3497	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	my	base	res.country	157
3498	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	mz	base	res.country	158
3499	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	na	base	res.country	159
3500	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	nc	base	res.country	160
3501	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ne	base	res.country	161
3502	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	nf	base	res.country	162
3503	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ng	base	res.country	163
3504	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ni	base	res.country	164
3505	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	nl	base	res.country	165
3506	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	no	base	res.country	166
3507	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	np	base	res.country	167
3508	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	nr	base	res.country	168
3509	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	nu	base	res.country	169
3510	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	nz	base	res.country	170
3511	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	om	base	res.country	171
3512	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	pa	base	res.country	172
3513	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	pe	base	res.country	173
3514	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	pf	base	res.country	174
3515	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	pg	base	res.country	175
3516	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ph	base	res.country	176
3517	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	pk	base	res.country	177
3518	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	pl	base	res.country	178
3519	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	pm	base	res.country	179
3520	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	pn	base	res.country	180
3521	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	pr	base	res.country	181
3522	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ps	base	res.country	182
3523	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	pt	base	res.country	183
3524	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	pw	base	res.country	184
3525	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	py	base	res.country	185
3526	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	qa	base	res.country	186
3527	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	re	base	res.country	187
3528	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ro	base	res.country	188
3529	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	rs	base	res.country	189
3530	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ru	base	res.country	190
3531	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	rw	base	res.country	191
3532	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sa	base	res.country	192
3533	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sb	base	res.country	193
3534	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sc	base	res.country	194
3535	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sd	base	res.country	195
3536	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	se	base	res.country	196
3537	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sg	base	res.country	197
3538	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sh	base	res.country	198
3539	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	si	base	res.country	199
3540	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sj	base	res.country	200
3541	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sk	base	res.country	201
3542	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sl	base	res.country	202
3543	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sm	base	res.country	203
3544	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sn	base	res.country	204
3545	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	so	base	res.country	205
3546	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sr	base	res.country	206
3547	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ss	base	res.country	207
3548	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	st	base	res.country	208
3549	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sv	base	res.country	209
3550	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sx	base	res.country	210
3551	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sy	base	res.country	211
3552	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sz	base	res.country	212
3553	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tc	base	res.country	213
3554	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	td	base	res.country	214
3555	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tf	base	res.country	215
3556	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tg	base	res.country	216
3557	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	th	base	res.country	217
3558	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tj	base	res.country	218
3559	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tk	base	res.country	219
3560	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tm	base	res.country	220
3561	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tn	base	res.country	221
3562	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	to	base	res.country	222
3563	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tl	base	res.country	223
3564	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tr	base	res.country	224
3565	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tt	base	res.country	225
3566	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tv	base	res.country	226
3567	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tw	base	res.country	227
3568	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	tz	base	res.country	228
3569	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ua	base	res.country	229
3570	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ug	base	res.country	230
3571	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	uk	base	res.country	231
3572	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	um	base	res.country	232
3573	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	us	base	res.country	233
3574	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	uy	base	res.country	234
3575	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	uz	base	res.country	235
3576	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	va	base	res.country	236
3577	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	vc	base	res.country	237
3578	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ve	base	res.country	238
3579	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	vg	base	res.country	239
3580	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	vi	base	res.country	240
3581	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	vn	base	res.country	241
3582	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	vu	base	res.country	242
3583	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	wf	base	res.country	243
3584	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ws	base	res.country	244
3585	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ye	base	res.country	245
3586	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	yt	base	res.country	246
3587	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	za	base	res.country	247
3588	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	zm	base	res.country	248
3589	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	zw	base	res.country	249
3590	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	xk	base	res.country	250
3591	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	europe	base	res.country.group	1
3592	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	south_america	base	res.country.group	2
3593	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	sepa_zone	base	res.country.group	3
3594	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	gulf_cooperation_council	base	res.country.group	4
3595	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	demo_force_install_action	base	ir.actions.act_window	1
3596	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	demo_force_install_form	base	ir.ui.view	1
3597	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	icp_mail_catchall_alias	base	ir.config_parameter	7
3598	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	icp_mail_bounce_alias	base	ir.config_parameter	8
3599	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	icp_mail_default_from	base	ir.config_parameter	9
3607	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	group_allow_export	base	res.groups	7
3336	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	default_user	base	res.users	3
3337	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	public_user	base	res.users	4
3614	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	template_portal_user_id_res_partner	base	res.partner	6
3615	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	template_portal_user_id	base	res.users	5
3616	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	default_template_user_config	base	ir.config_parameter	10
3617	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	group_private_addresses	base	res.groups	11
3618	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_users_log_rule	base	ir.rule	1
3619	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_rule	base	ir.rule	2
3620	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_portal_public_rule	base	ir.rule	3
3621	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ir_default_user_rule	base	ir.rule	4
3622	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ir_default_system_rule	base	ir.rule	5
3623	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ir_ui_view_custom_personal	base	ir.rule	6
3624	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_bank_rule	base	ir.rule	7
3625	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_currency_rate_rule	base	ir.rule	8
3626	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	change_password_rule	base	ir.rule	9
3627	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_rule_private_employee	base	ir.rule	10
3628	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_partner_rule_private_group	base	ir.rule	11
3629	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ir_filters_admin_all_rights_rule	base	ir.rule	12
3630	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ir_filters_employee_rule	base	ir.rule	13
3631	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ir_filters_delete_own_rule	base	ir.rule	14
3632	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	ir_filters_portal_public_rule	base	ir.rule	15
3633	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_company_rule_portal	base	ir.rule	16
3634	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_company_rule_employee	base	ir.rule	17
3635	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_company_rule_public	base	ir.rule	18
3636	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_company_rule_erp_manager	base	ir.rule	19
3637	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_users_identity_check	base	ir.rule	20
3638	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	res_users_rule	base	ir.rule	21
3639	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	api_key_public	base	ir.rule	22
3640	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	api_key_user	base	ir.rule	23
3641	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	t	api_key_admin	base	ir.rule	24
3642	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_board_root	base	ir.ui.menu	1
3643	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_reporting_dashboard	base	ir.ui.menu	2
3644	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_reporting_config	base	ir.ui.menu	3
3646	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_management	base	ir.ui.menu	5
3647	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_administration_shortcut	base	ir.ui.menu	6
3648	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_users	base	ir.ui.menu	7
3649	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_translation	base	ir.ui.menu	8
3650	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_translation_app	base	ir.ui.menu	9
3651	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_translation_export	base	ir.ui.menu	10
3652	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_config	base	ir.ui.menu	11
3653	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_custom	base	ir.ui.menu	12
3654	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	next_id_2	base	ir.ui.menu	13
3655	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_email	base	ir.ui.menu	14
3656	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	next_id_9	base	ir.ui.menu	15
3657	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_automation	base	ir.ui.menu	16
3658	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_security	base	ir.ui.menu	17
3659	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_ir_property	base	ir.ui.menu	18
3660	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_tests	base	ir.ui.menu	19
3645	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_administration	base	ir.ui.menu	4
3662	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	action_client_base_menu	base	ir.actions.client	2
3663	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	open_menu	base	ir.actions.todo	1
3664	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	action_open_website	base	ir.actions.act_url	3
3665	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	view_decimal_precision_form	base	ir.ui.view	2
3666	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	view_decimal_precision_tree	base	ir.ui.view	3
3667	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	action_decimal_precision_form	base	ir.actions.act_window	4
3668	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	menu_decimal_precision_form	base	ir.ui.menu	20
3669	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	res_config_view_base	base	ir.ui.view	4
3670	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	res_config_installer	base	ir.ui.view	5
3671	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_au_1	base	res.country.state	1
3672	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_au_2	base	res.country.state	2
3673	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_au_3	base	res.country.state	3
3674	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_au_4	base	res.country.state	4
3675	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_au_5	base	res.country.state	5
3676	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_au_6	base	res.country.state	6
3677	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_au_7	base	res.country.state	7
3678	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_au_8	base	res.country.state	8
3679	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_1	base	res.country.state	9
3680	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_2	base	res.country.state	10
3681	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_3	base	res.country.state	11
3682	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_4	base	res.country.state	12
3683	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_5	base	res.country.state	13
3684	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_6	base	res.country.state	14
3685	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_7	base	res.country.state	15
3686	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_8	base	res.country.state	16
3687	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_9	base	res.country.state	17
3688	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_10	base	res.country.state	18
3689	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_11	base	res.country.state	19
3690	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_12	base	res.country.state	20
3691	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_13	base	res.country.state	21
3692	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_14	base	res.country.state	22
3693	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_15	base	res.country.state	23
3694	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_16	base	res.country.state	24
3695	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_17	base	res.country.state	25
3696	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_18	base	res.country.state	26
3697	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_19	base	res.country.state	27
3698	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_20	base	res.country.state	28
3699	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_21	base	res.country.state	29
3700	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_22	base	res.country.state	30
3701	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_23	base	res.country.state	31
3702	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_24	base	res.country.state	32
3703	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_25	base	res.country.state	33
3704	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_26	base	res.country.state	34
3705	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_27	base	res.country.state	35
3706	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_28	base	res.country.state	36
3707	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_29	base	res.country.state	37
3708	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_30	base	res.country.state	38
3709	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_31	base	res.country.state	39
3710	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_32	base	res.country.state	40
3711	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_33	base	res.country.state	41
3712	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_34	base	res.country.state	42
3713	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_35	base	res.country.state	43
3714	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_36	base	res.country.state	44
3715	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_37	base	res.country.state	45
3716	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_38	base	res.country.state	46
3717	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_39	base	res.country.state	47
3718	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_40	base	res.country.state	48
3719	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_41	base	res.country.state	49
3720	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_42	base	res.country.state	50
3721	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_43	base	res.country.state	51
3722	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_44	base	res.country.state	52
3723	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_45	base	res.country.state	53
3724	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_46	base	res.country.state	54
3725	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_47	base	res.country.state	55
3726	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_48	base	res.country.state	56
3727	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_49	base	res.country.state	57
3728	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_50	base	res.country.state	58
3729	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_51	base	res.country.state	59
3730	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_as	base	res.country.state	60
3731	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_fm	base	res.country.state	61
3732	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_gu	base	res.country.state	62
3733	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_mh	base	res.country.state	63
3734	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_mp	base	res.country.state	64
3735	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_pw	base	res.country.state	65
3736	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_pr	base	res.country.state	66
3737	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_vi	base	res.country.state	67
3738	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_aa	base	res.country.state	68
3739	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_ae	base	res.country.state	69
3740	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_us_ap	base	res.country.state	70
3741	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_ac	base	res.country.state	71
3742	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_al	base	res.country.state	72
3743	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_ap	base	res.country.state	73
3744	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_am	base	res.country.state	74
3745	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_ba	base	res.country.state	75
3746	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_ce	base	res.country.state	76
3747	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_df	base	res.country.state	77
3748	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_es	base	res.country.state	78
3749	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_go	base	res.country.state	79
3750	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_ma	base	res.country.state	80
3751	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_mt	base	res.country.state	81
3752	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_ms	base	res.country.state	82
3753	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_mg	base	res.country.state	83
3754	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_pa	base	res.country.state	84
3755	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_pb	base	res.country.state	85
3756	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_pr	base	res.country.state	86
3757	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_pe	base	res.country.state	87
3758	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_pi	base	res.country.state	88
3759	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_rj	base	res.country.state	89
3760	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_rn	base	res.country.state	90
3761	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_rs	base	res.country.state	91
3762	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_ro	base	res.country.state	92
3763	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_rr	base	res.country.state	93
3764	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_sc	base	res.country.state	94
3765	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_sp	base	res.country.state	95
3766	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_se	base	res.country.state	96
3767	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_br_to	base	res.country.state	97
3768	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ad	base	res.country.state	98
3769	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_al	base	res.country.state	99
3770	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_alt	base	res.country.state	100
3771	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_amu	base	res.country.state	101
3772	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ark	base	res.country.state	102
3773	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ast	base	res.country.state	103
3774	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ba	base	res.country.state	104
3775	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_bel	base	res.country.state	105
3776	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_bry	base	res.country.state	106
3777	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_bu	base	res.country.state	107
3778	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ce	base	res.country.state	108
3779	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_che	base	res.country.state	109
3780	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_chu	base	res.country.state	110
3781	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_cu	base	res.country.state	111
3782	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_da	base	res.country.state	112
3783	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_in	base	res.country.state	113
3784	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_irk	base	res.country.state	114
3785	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_iva	base	res.country.state	115
3786	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kam	base	res.country.state	116
3787	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kb	base	res.country.state	117
3788	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kgd	base	res.country.state	118
3789	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kl	base	res.country.state	119
3790	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_klu	base	res.country.state	120
3791	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kc	base	res.country.state	121
3792	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kr	base	res.country.state	122
3793	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kem	base	res.country.state	123
3794	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kha	base	res.country.state	124
3795	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kk	base	res.country.state	125
3796	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_khm	base	res.country.state	126
3797	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kir	base	res.country.state	127
3798	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ko	base	res.country.state	128
3799	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kos	base	res.country.state	129
3800	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kda	base	res.country.state	130
3801	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kya	base	res.country.state	131
3802	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_kgn	base	res.country.state	132
3803	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_krs	base	res.country.state	133
3804	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_len	base	res.country.state	134
3805	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_lip	base	res.country.state	135
3806	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_mag	base	res.country.state	136
3807	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_me	base	res.country.state	137
3808	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_mo	base	res.country.state	138
3809	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_mos	base	res.country.state	139
3810	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_mow	base	res.country.state	140
3811	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_mur	base	res.country.state	141
3812	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_niz	base	res.country.state	142
3813	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ngr	base	res.country.state	143
3814	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_nvs	base	res.country.state	144
3815	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_oms	base	res.country.state	145
3816	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ore	base	res.country.state	146
3817	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_orl	base	res.country.state	147
3818	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_pnz	base	res.country.state	148
3819	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_per	base	res.country.state	149
3820	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_pri	base	res.country.state	150
3821	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_psk	base	res.country.state	151
3822	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ros	base	res.country.state	152
3823	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_rya	base	res.country.state	153
3824	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_sa	base	res.country.state	154
3825	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_sak	base	res.country.state	155
3826	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_sam	base	res.country.state	156
3827	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_spe	base	res.country.state	157
3828	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_sar	base	res.country.state	158
3829	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_se	base	res.country.state	159
3830	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_smo	base	res.country.state	160
3831	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_sta	base	res.country.state	161
3832	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_sve	base	res.country.state	162
3833	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_tam	base	res.country.state	163
3834	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ta	base	res.country.state	164
3835	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_tom	base	res.country.state	165
3836	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_tul	base	res.country.state	166
3837	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_tve	base	res.country.state	167
3838	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_tyu	base	res.country.state	168
3839	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ty	base	res.country.state	169
3840	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_ud	base	res.country.state	170
3841	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_uly	base	res.country.state	171
3842	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_vla	base	res.country.state	172
3843	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_vgg	base	res.country.state	173
3844	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_vlg	base	res.country.state	174
3845	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_vor	base	res.country.state	175
3846	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_yan	base	res.country.state	176
3847	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_yar	base	res.country.state	177
3848	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ru_yev	base	res.country.state	178
3849	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_ave	base	res.country.state	179
3850	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_bve	base	res.country.state	180
3851	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_cmt	base	res.country.state	181
3852	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_cqm	base	res.country.state	182
3853	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_epr	base	res.country.state	183
3854	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_esc	base	res.country.state	184
3855	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_gua	base	res.country.state	185
3856	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_hue	base	res.country.state	186
3857	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_iza	base	res.country.state	187
3858	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_jal	base	res.country.state	188
3859	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_jut	base	res.country.state	189
3860	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_pet	base	res.country.state	190
3861	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_que	base	res.country.state	191
3862	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_qui	base	res.country.state	192
3863	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_ret	base	res.country.state	193
3864	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_sac	base	res.country.state	194
3865	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_sma	base	res.country.state	195
3866	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_sro	base	res.country.state	196
3867	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_sol	base	res.country.state	197
3868	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_suc	base	res.country.state	198
3869	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_tot	base	res.country.state	199
3870	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_gt_zac	base	res.country.state	200
3871	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-23	base	res.country.state	201
3872	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-05	base	res.country.state	202
3873	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-02	base	res.country.state	203
3874	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-12	base	res.country.state	204
3875	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-38	base	res.country.state	205
3876	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-18	base	res.country.state	206
3877	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-40	base	res.country.state	207
3878	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-07	base	res.country.state	208
3879	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-21	base	res.country.state	209
3880	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-10	base	res.country.state	210
3881	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-34	base	res.country.state	211
3882	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-01	base	res.country.state	212
3883	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-28	base	res.country.state	213
3884	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-08	base	res.country.state	214
3885	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-17	base	res.country.state	215
3886	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-03	base	res.country.state	216
3887	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-37	base	res.country.state	217
3888	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-46	base	res.country.state	218
3889	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-14	base	res.country.state	219
3890	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-39	base	res.country.state	220
3891	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-43	base	res.country.state	221
3892	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-26	base	res.country.state	222
3893	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-24	base	res.country.state	223
3894	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-04	base	res.country.state	224
3895	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-45	base	res.country.state	225
3896	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-20	base	res.country.state	226
3897	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-42	base	res.country.state	227
3898	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-29	base	res.country.state	228
3899	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-15	base	res.country.state	229
3900	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-44	base	res.country.state	230
3901	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-33	base	res.country.state	231
3902	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-47	base	res.country.state	232
3903	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-27	base	res.country.state	233
3904	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-41	base	res.country.state	234
3905	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-11	base	res.country.state	235
3906	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-25	base	res.country.state	236
3907	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-32	base	res.country.state	237
3908	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-22	base	res.country.state	238
3909	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-09	base	res.country.state	239
3910	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-36	base	res.country.state	240
3911	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-31	base	res.country.state	241
3912	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-16	base	res.country.state	242
3913	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-13	base	res.country.state	243
3914	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-30	base	res.country.state	244
3915	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-06	base	res.country.state	245
3916	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-35	base	res.country.state	246
3917	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_jp_jp-19	base	res.country.state	247
3918	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-01	base	res.country.state	248
3919	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-02	base	res.country.state	249
3920	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-03	base	res.country.state	250
3921	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-04	base	res.country.state	251
3922	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-05	base	res.country.state	252
3923	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-06	base	res.country.state	253
3924	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-07	base	res.country.state	254
3925	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-08	base	res.country.state	255
3926	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-09	base	res.country.state	256
3927	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-10	base	res.country.state	257
3928	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-11	base	res.country.state	258
3929	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-12	base	res.country.state	259
3930	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-13	base	res.country.state	260
3931	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-14	base	res.country.state	261
3932	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-15	base	res.country.state	262
3933	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-16	base	res.country.state	263
3934	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-17	base	res.country.state	264
3935	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-18	base	res.country.state	265
3936	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-20	base	res.country.state	266
3937	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pt_pt-30	base	res.country.state	267
3938	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_dk	base	res.country.state	268
3939	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_ba	base	res.country.state	269
3940	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_bh	base	res.country.state	270
3941	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_fym	base	res.country.state	271
3942	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_gh	base	res.country.state	272
3943	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_alx	base	res.country.state	273
3944	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_is	base	res.country.state	274
3945	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_gz	base	res.country.state	275
3946	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_mnf	base	res.country.state	276
3947	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_mn	base	res.country.state	277
3948	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_c	base	res.country.state	278
3949	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_kb	base	res.country.state	279
3950	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_lx	base	res.country.state	280
3951	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_wad	base	res.country.state	281
3952	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_shr	base	res.country.state	282
3953	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_su	base	res.country.state	283
3954	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_suz	base	res.country.state	284
3955	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_asn	base	res.country.state	285
3956	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_ast	base	res.country.state	286
3957	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_bns	base	res.country.state	287
3958	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_pts	base	res.country.state	288
3959	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_dt	base	res.country.state	289
3960	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_hu	base	res.country.state	290
3961	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_js	base	res.country.state	291
3962	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_kfs	base	res.country.state	292
3963	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_mt	base	res.country.state	293
3964	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_kn	base	res.country.state	294
3965	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_sin	base	res.country.state	295
3966	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_eg_shg	base	res.country.state	296
3967	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_za_ec	base	res.country.state	297
3968	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_za_fs	base	res.country.state	298
3969	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_za_gt	base	res.country.state	299
3970	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_za_nl	base	res.country.state	300
3971	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_za_lp	base	res.country.state	301
3972	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_za_mp	base	res.country.state	302
3973	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_za_nc	base	res.country.state	303
3974	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_za_nw	base	res.country.state	304
3975	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_za_wc	base	res.country.state	305
3976	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ag	base	res.country.state	306
3977	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_al	base	res.country.state	307
3978	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_an	base	res.country.state	308
3979	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ao	base	res.country.state	309
3980	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ar	base	res.country.state	310
3981	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ap	base	res.country.state	311
3982	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_at	base	res.country.state	312
3983	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_av	base	res.country.state	313
3984	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ba	base	res.country.state	314
3985	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_bt	base	res.country.state	315
3986	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_bl	base	res.country.state	316
3987	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_bn	base	res.country.state	317
3988	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_bg	base	res.country.state	318
3989	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_bi	base	res.country.state	319
3990	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_bo	base	res.country.state	320
3991	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_bz	base	res.country.state	321
3992	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_bs	base	res.country.state	322
3993	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_br	base	res.country.state	323
3994	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ca	base	res.country.state	324
3995	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_cl	base	res.country.state	325
3996	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_cb	base	res.country.state	326
3997	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ci	base	res.country.state	327
3998	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ce	base	res.country.state	328
3999	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ct	base	res.country.state	329
4000	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_cz	base	res.country.state	330
4001	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ch	base	res.country.state	331
4002	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_co	base	res.country.state	332
4003	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_cs	base	res.country.state	333
4004	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_cr	base	res.country.state	334
4005	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_kr	base	res.country.state	335
4006	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_cn	base	res.country.state	336
4007	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_en	base	res.country.state	337
4008	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_fm	base	res.country.state	338
4009	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_fe	base	res.country.state	339
4010	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_fi	base	res.country.state	340
4011	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_fg	base	res.country.state	341
4012	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_fc	base	res.country.state	342
4013	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_fr	base	res.country.state	343
4014	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ge	base	res.country.state	344
4015	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_go	base	res.country.state	345
4016	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_gr	base	res.country.state	346
4017	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_im	base	res.country.state	347
4018	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_is	base	res.country.state	348
4019	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_sp	base	res.country.state	349
4020	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_aq	base	res.country.state	350
4021	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_lt	base	res.country.state	351
4022	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_le	base	res.country.state	352
4023	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_lc	base	res.country.state	353
4024	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_li	base	res.country.state	354
4025	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_lo	base	res.country.state	355
4026	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_lu	base	res.country.state	356
4027	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_mc	base	res.country.state	357
4028	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_mn	base	res.country.state	358
4029	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ms	base	res.country.state	359
4030	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_mt	base	res.country.state	360
4031	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_vs	base	res.country.state	361
4032	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_me	base	res.country.state	362
4033	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_mi	base	res.country.state	363
4034	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_mo	base	res.country.state	364
4035	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_mb	base	res.country.state	365
4036	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_na	base	res.country.state	366
4037	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_no	base	res.country.state	367
4038	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_nu	base	res.country.state	368
4039	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_og	base	res.country.state	369
4040	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ot	base	res.country.state	370
4041	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_or	base	res.country.state	371
4042	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pd	base	res.country.state	372
4043	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pa	base	res.country.state	373
4044	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pr	base	res.country.state	374
4045	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pv	base	res.country.state	375
4046	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pg	base	res.country.state	376
4047	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pu	base	res.country.state	377
4048	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pe	base	res.country.state	378
4049	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pc	base	res.country.state	379
4050	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pi	base	res.country.state	380
4051	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pt	base	res.country.state	381
4052	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pn	base	res.country.state	382
4053	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_pz	base	res.country.state	383
4054	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_po	base	res.country.state	384
4055	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_rg	base	res.country.state	385
4056	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ra	base	res.country.state	386
4057	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_rc	base	res.country.state	387
4058	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_re	base	res.country.state	388
4059	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ri	base	res.country.state	389
4060	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_rn	base	res.country.state	390
4061	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_rm	base	res.country.state	391
4062	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ro	base	res.country.state	392
4063	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_sa	base	res.country.state	393
4064	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ss	base	res.country.state	394
4065	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_sv	base	res.country.state	395
4066	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_si	base	res.country.state	396
4067	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_sr	base	res.country.state	397
4068	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_so	base	res.country.state	398
4069	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_su	base	res.country.state	399
4070	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ta	base	res.country.state	400
4071	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_te	base	res.country.state	401
4072	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_tr	base	res.country.state	402
4073	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_to	base	res.country.state	403
4074	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_tp	base	res.country.state	404
4075	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_tn	base	res.country.state	405
4076	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_tv	base	res.country.state	406
4077	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ts	base	res.country.state	407
4078	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ud	base	res.country.state	408
4079	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_va	base	res.country.state	409
4080	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_ve	base	res.country.state	410
4081	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_vb	base	res.country.state	411
4082	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_vc	base	res.country.state	412
4083	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_vr	base	res.country.state	413
4084	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_vv	base	res.country.state	414
4085	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_vi	base	res.country.state	415
4086	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_it_vt	base	res.country.state	416
4087	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_c	base	res.country.state	417
4088	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_vi	base	res.country.state	418
4089	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_ab	base	res.country.state	419
4090	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_a	base	res.country.state	420
4091	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_al	base	res.country.state	421
4092	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_o	base	res.country.state	422
4093	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_av	base	res.country.state	423
4094	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_ba	base	res.country.state	424
4095	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_pm	base	res.country.state	425
4096	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_b	base	res.country.state	426
4097	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_bu	base	res.country.state	427
4098	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_cc	base	res.country.state	428
4099	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_ca	base	res.country.state	429
4100	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_s	base	res.country.state	430
4101	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_cs	base	res.country.state	431
4102	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_ce	base	res.country.state	432
4103	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_cr	base	res.country.state	433
4104	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_co	base	res.country.state	434
4105	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_cu	base	res.country.state	435
4106	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_gi	base	res.country.state	436
4107	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_gr	base	res.country.state	437
4108	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_gu	base	res.country.state	438
4109	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_ss	base	res.country.state	439
4110	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_h	base	res.country.state	440
4111	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_hu	base	res.country.state	441
4112	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_j	base	res.country.state	442
4113	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_lo	base	res.country.state	443
4114	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_gc	base	res.country.state	444
4115	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_le	base	res.country.state	445
4116	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_l	base	res.country.state	446
4117	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_lu	base	res.country.state	447
4118	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_m	base	res.country.state	448
4119	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_ma	base	res.country.state	449
4120	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_ml	base	res.country.state	450
4121	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_mu	base	res.country.state	451
4122	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_na	base	res.country.state	452
4123	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_or	base	res.country.state	453
4124	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_p	base	res.country.state	454
4125	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_po	base	res.country.state	455
4126	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_sa	base	res.country.state	456
4127	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_tf	base	res.country.state	457
4128	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_sg	base	res.country.state	458
4129	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_se	base	res.country.state	459
4130	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_so	base	res.country.state	460
4131	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_t	base	res.country.state	461
4132	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_te	base	res.country.state	462
4133	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_to	base	res.country.state	463
4134	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_v	base	res.country.state	464
4135	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_va	base	res.country.state	465
4136	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_bi	base	res.country.state	466
4137	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_za	base	res.country.state	467
4138	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_es_z	base	res.country.state	468
4139	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_jhr	base	res.country.state	469
4140	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_kdh	base	res.country.state	470
4141	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_ktn	base	res.country.state	471
4142	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_kul	base	res.country.state	472
4143	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_lbn	base	res.country.state	473
4144	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_mlk	base	res.country.state	474
4145	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_nsn	base	res.country.state	475
4146	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_phg	base	res.country.state	476
4147	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_prk	base	res.country.state	477
4148	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_pls	base	res.country.state	478
4149	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_png	base	res.country.state	479
4150	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_pjy	base	res.country.state	480
4151	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_sbh	base	res.country.state	481
4152	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_swk	base	res.country.state	482
4153	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_sgr	base	res.country.state	483
4154	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_my_trg	base	res.country.state	484
4155	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_ags	base	res.country.state	485
4156	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_bc	base	res.country.state	486
4157	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_bcs	base	res.country.state	487
4158	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_chih	base	res.country.state	488
4159	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_col	base	res.country.state	489
4160	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_camp	base	res.country.state	490
4161	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_coah	base	res.country.state	491
4162	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_chis	base	res.country.state	492
4163	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_df	base	res.country.state	493
4164	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_dgo	base	res.country.state	494
4165	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_gro	base	res.country.state	495
4166	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_gto	base	res.country.state	496
4167	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_hgo	base	res.country.state	497
4168	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_jal	base	res.country.state	498
4169	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_mich	base	res.country.state	499
4170	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_mor	base	res.country.state	500
4171	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_mex	base	res.country.state	501
4172	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_nay	base	res.country.state	502
4173	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_nl	base	res.country.state	503
4174	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_oax	base	res.country.state	504
4175	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_pue	base	res.country.state	505
4176	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_q_roo	base	res.country.state	506
4177	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_qro	base	res.country.state	507
4178	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_sin	base	res.country.state	508
4179	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_slp	base	res.country.state	509
4180	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_son	base	res.country.state	510
4181	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_tab	base	res.country.state	511
4182	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_tlax	base	res.country.state	512
4183	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_tamps	base	res.country.state	513
4184	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_ver	base	res.country.state	514
4185	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_yuc	base	res.country.state	515
4186	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mx_zac	base	res.country.state	516
4187	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_auk	base	res.country.state	517
4188	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_bop	base	res.country.state	518
4189	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_can	base	res.country.state	519
4190	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_gis	base	res.country.state	520
4191	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_hkb	base	res.country.state	521
4192	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_mwt	base	res.country.state	522
4193	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_mbh	base	res.country.state	523
4194	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_nsn	base	res.country.state	524
4195	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_ntl	base	res.country.state	525
4196	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_ota	base	res.country.state	526
4197	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_stl	base	res.country.state	527
4198	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_tki	base	res.country.state	528
4199	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_tas	base	res.country.state	529
4200	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_wko	base	res.country.state	530
4201	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_wgn	base	res.country.state	531
4202	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nz_wtc	base	res.country.state	532
4203	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_ab	base	res.country.state	533
4204	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_bc	base	res.country.state	534
4205	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_mb	base	res.country.state	535
4206	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_nb	base	res.country.state	536
4207	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_nl	base	res.country.state	537
4208	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_nt	base	res.country.state	538
4209	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_ns	base	res.country.state	539
4210	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_nu	base	res.country.state	540
4211	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_on	base	res.country.state	541
4212	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_pe	base	res.country.state	542
4213	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_qc	base	res.country.state	543
4214	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_sk	base	res.country.state	544
4215	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ca_yt	base	res.country.state	545
4216	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ae_az	base	res.country.state	546
4217	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ae_aj	base	res.country.state	547
4218	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ae_du	base	res.country.state	548
4219	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ae_fu	base	res.country.state	549
4220	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ae_rk	base	res.country.state	550
4221	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ae_sh	base	res.country.state	551
4222	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ae_uq	base	res.country.state	552
4223	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_c	base	res.country.state	553
4224	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_b	base	res.country.state	554
4225	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_k	base	res.country.state	555
4226	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_h	base	res.country.state	556
4227	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_u	base	res.country.state	557
4228	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_x	base	res.country.state	558
4229	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_w	base	res.country.state	559
4230	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_e	base	res.country.state	560
4231	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_p	base	res.country.state	561
4232	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_y	base	res.country.state	562
4233	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_l	base	res.country.state	563
4234	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_f	base	res.country.state	564
4235	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_m	base	res.country.state	565
4236	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_n	base	res.country.state	566
4237	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_q	base	res.country.state	567
4238	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_r	base	res.country.state	568
4239	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_a	base	res.country.state	569
4240	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_j	base	res.country.state	570
4241	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_d	base	res.country.state	571
4242	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_z	base	res.country.state	572
4243	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_s	base	res.country.state	573
4244	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_g	base	res.country.state	574
4245	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_v	base	res.country.state	575
4246	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ar_t	base	res.country.state	576
4247	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_an	base	res.country.state	577
4248	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_ap	base	res.country.state	578
4249	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_ar	base	res.country.state	579
4250	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_as	base	res.country.state	580
4251	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_br	base	res.country.state	581
4252	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_ch	base	res.country.state	582
4253	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_cg	base	res.country.state	583
4254	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_dn	base	res.country.state	584
4255	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_dd	base	res.country.state	585
4256	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_dl	base	res.country.state	586
4257	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_ga	base	res.country.state	587
4258	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_gj	base	res.country.state	588
4259	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_hr	base	res.country.state	589
4260	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_hp	base	res.country.state	590
4261	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_jk	base	res.country.state	591
4262	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_jh	base	res.country.state	592
4263	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_ka	base	res.country.state	593
4264	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_kl	base	res.country.state	594
4265	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_ld	base	res.country.state	595
4266	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_mp	base	res.country.state	596
4267	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_mh	base	res.country.state	597
4268	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_mn	base	res.country.state	598
4269	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_ml	base	res.country.state	599
4270	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_mz	base	res.country.state	600
4271	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_nl	base	res.country.state	601
4272	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_or	base	res.country.state	602
4273	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_py	base	res.country.state	603
4274	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_pb	base	res.country.state	604
4275	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_rj	base	res.country.state	605
4276	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_sk	base	res.country.state	606
4277	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_tn	base	res.country.state	607
4278	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_ts	base	res.country.state	608
4279	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_tr	base	res.country.state	609
4280	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_up	base	res.country.state	610
4281	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_uk	base	res.country.state	611
4282	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_in_wb	base	res.country.state	612
4283	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_ac	base	res.country.state	613
4284	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_ba	base	res.country.state	614
4285	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_bb	base	res.country.state	615
4286	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_bt	base	res.country.state	616
4287	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_be	base	res.country.state	617
4288	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_go	base	res.country.state	618
4289	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_jk	base	res.country.state	619
4290	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_ja	base	res.country.state	620
4291	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_jb	base	res.country.state	621
4292	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_jt	base	res.country.state	622
4293	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_ji	base	res.country.state	623
4294	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_kb	base	res.country.state	624
4295	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_ks	base	res.country.state	625
4296	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_kt	base	res.country.state	626
4297	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_ki	base	res.country.state	627
4298	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_ku	base	res.country.state	628
4299	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_kr	base	res.country.state	629
4300	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_la	base	res.country.state	630
4301	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_ma	base	res.country.state	631
4302	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_mu	base	res.country.state	632
4303	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_nb	base	res.country.state	633
4304	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_nt	base	res.country.state	634
4305	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_pa	base	res.country.state	635
4306	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_pb	base	res.country.state	636
4307	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_ps	base	res.country.state	637
4308	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_pt	base	res.country.state	638
4309	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_pp	base	res.country.state	639
4310	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_ri	base	res.country.state	640
4311	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_sr	base	res.country.state	641
4312	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_sn	base	res.country.state	642
4313	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_st	base	res.country.state	643
4314	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_sg	base	res.country.state	644
4315	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_sa	base	res.country.state	645
4316	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_sb	base	res.country.state	646
4317	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_ss	base	res.country.state	647
4318	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_su	base	res.country.state	648
4319	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_id_yo	base	res.country.state	649
4320	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_01	base	res.country.state	650
4321	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_02	base	res.country.state	651
4322	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_03	base	res.country.state	652
4323	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_04	base	res.country.state	653
4324	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_05	base	res.country.state	654
4325	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_06	base	res.country.state	655
4326	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_07	base	res.country.state	656
4327	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_08	base	res.country.state	657
4328	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_09	base	res.country.state	658
4329	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_10	base	res.country.state	659
4330	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_11	base	res.country.state	660
4331	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_12	base	res.country.state	661
4332	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_13	base	res.country.state	662
4333	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_14	base	res.country.state	663
4334	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_15	base	res.country.state	664
4335	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_16	base	res.country.state	665
4336	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_17	base	res.country.state	666
4337	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_18	base	res.country.state	667
4338	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_19	base	res.country.state	668
4339	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_20	base	res.country.state	669
4340	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_21	base	res.country.state	670
4341	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_22	base	res.country.state	671
4342	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_23	base	res.country.state	672
4343	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_24	base	res.country.state	673
4344	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_25	base	res.country.state	674
4345	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_26	base	res.country.state	675
4346	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_27	base	res.country.state	676
4347	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_28	base	res.country.state	677
4348	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_29	base	res.country.state	678
4349	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_30	base	res.country.state	679
4350	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_31	base	res.country.state	680
4351	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_32	base	res.country.state	681
4352	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_co_33	base	res.country.state	682
4353	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_01	base	res.country.state	683
4354	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_02	base	res.country.state	684
4355	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_03	base	res.country.state	685
4356	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_04	base	res.country.state	686
4357	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_05	base	res.country.state	687
4358	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_06	base	res.country.state	688
4359	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_07	base	res.country.state	689
4360	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_08	base	res.country.state	690
4361	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_09	base	res.country.state	691
4362	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_10	base	res.country.state	692
4363	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_11	base	res.country.state	693
4364	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_12	base	res.country.state	694
4365	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_13	base	res.country.state	695
4366	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_14	base	res.country.state	696
4367	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_15	base	res.country.state	697
4368	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_16	base	res.country.state	698
4369	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_17	base	res.country.state	699
4370	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_18	base	res.country.state	700
4371	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_19	base	res.country.state	701
4372	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_20	base	res.country.state	702
4373	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_23	base	res.country.state	703
4374	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_24	base	res.country.state	704
4375	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_25	base	res.country.state	705
4376	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_26	base	res.country.state	706
4377	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_27	base	res.country.state	707
4378	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_28	base	res.country.state	708
4379	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_29	base	res.country.state	709
4380	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_32	base	res.country.state	710
4381	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_34	base	res.country.state	711
4382	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_mn_35	base	res.country.state	712
4383	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk1	base	res.country.state	713
4384	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk2	base	res.country.state	714
4385	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk3	base	res.country.state	715
4386	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk4	base	res.country.state	716
4387	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk5	base	res.country.state	717
4388	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk6	base	res.country.state	718
4389	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk7	base	res.country.state	719
4390	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk8	base	res.country.state	720
4391	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk9	base	res.country.state	721
4392	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk10	base	res.country.state	722
4393	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk11	base	res.country.state	723
4394	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk12	base	res.country.state	724
4395	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk13	base	res.country.state	725
4396	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk14	base	res.country.state	726
4397	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk15	base	res.country.state	727
4398	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk16	base	res.country.state	728
4399	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk17	base	res.country.state	729
4400	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk18	base	res.country.state	730
4401	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk19	base	res.country.state	731
4402	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk20	base	res.country.state	732
4403	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk21	base	res.country.state	733
4404	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk22	base	res.country.state	734
4405	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk23	base	res.country.state	735
4406	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk24	base	res.country.state	736
4407	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk25	base	res.country.state	737
4408	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk26	base	res.country.state	738
4409	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk27	base	res.country.state	739
4410	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk28	base	res.country.state	740
4411	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk29	base	res.country.state	741
4412	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk30	base	res.country.state	742
4413	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk31	base	res.country.state	743
4414	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk32	base	res.country.state	744
4415	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk33	base	res.country.state	745
4416	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk34	base	res.country.state	746
4417	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk35	base	res.country.state	747
4418	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk36	base	res.country.state	748
4419	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk37	base	res.country.state	749
4420	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk38	base	res.country.state	750
4421	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk39	base	res.country.state	751
4422	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk40	base	res.country.state	752
4423	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk41	base	res.country.state	753
4424	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk42	base	res.country.state	754
4425	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk43	base	res.country.state	755
4426	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk44	base	res.country.state	756
4427	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk45	base	res.country.state	757
4428	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk46	base	res.country.state	758
4429	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk47	base	res.country.state	759
4430	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk48	base	res.country.state	760
4431	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk49	base	res.country.state	761
4432	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk50	base	res.country.state	762
4433	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk51	base	res.country.state	763
4434	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk52	base	res.country.state	764
4435	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk53	base	res.country.state	765
4436	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk54	base	res.country.state	766
4437	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk55	base	res.country.state	767
4438	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk56	base	res.country.state	768
4439	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk57	base	res.country.state	769
4440	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk58	base	res.country.state	770
4441	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk59	base	res.country.state	771
4442	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk60	base	res.country.state	772
4443	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk61	base	res.country.state	773
4444	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk62	base	res.country.state	774
4445	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk63	base	res.country.state	775
4446	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk64	base	res.country.state	776
4447	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk65	base	res.country.state	777
4448	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk66	base	res.country.state	778
4449	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk67	base	res.country.state	779
4450	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk68	base	res.country.state	780
4451	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk69	base	res.country.state	781
4452	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk70	base	res.country.state	782
4453	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk71	base	res.country.state	783
4454	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk72	base	res.country.state	784
4455	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk73	base	res.country.state	785
4456	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk74	base	res.country.state	786
4457	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk75	base	res.country.state	787
4458	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk76	base	res.country.state	788
4459	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk77	base	res.country.state	789
4460	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk78	base	res.country.state	790
4461	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk79	base	res.country.state	791
4462	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk80	base	res.country.state	792
4463	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk81	base	res.country.state	793
4464	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk82	base	res.country.state	794
4465	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk83	base	res.country.state	795
4466	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk84	base	res.country.state	796
4467	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk85	base	res.country.state	797
4468	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk86	base	res.country.state	798
4469	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk87	base	res.country.state	799
4470	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk88	base	res.country.state	800
4471	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk89	base	res.country.state	801
4472	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk90	base	res.country.state	802
4473	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk91	base	res.country.state	803
4474	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk92	base	res.country.state	804
4475	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk93	base	res.country.state	805
4476	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk94	base	res.country.state	806
4477	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk95	base	res.country.state	807
4478	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk96	base	res.country.state	808
4479	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk97	base	res.country.state	809
4480	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk98	base	res.country.state	810
4481	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk99	base	res.country.state	811
4482	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk100	base	res.country.state	812
4483	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk101	base	res.country.state	813
4484	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk102	base	res.country.state	814
4485	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk103	base	res.country.state	815
4486	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk104	base	res.country.state	816
4487	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk105	base	res.country.state	817
4488	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk106	base	res.country.state	818
4489	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk107	base	res.country.state	819
4490	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk108	base	res.country.state	820
4491	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk109	base	res.country.state	821
4492	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk110	base	res.country.state	822
4493	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk111	base	res.country.state	823
4494	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk112	base	res.country.state	824
4495	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk113	base	res.country.state	825
4496	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk114	base	res.country.state	826
4497	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk115	base	res.country.state	827
4498	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk116	base	res.country.state	828
4499	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk117	base	res.country.state	829
4500	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk118	base	res.country.state	830
4501	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_uk119	base	res.country.state	831
4502	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_AB	base	res.country.state	832
4503	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_AG	base	res.country.state	833
4504	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_AR	base	res.country.state	834
4505	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_B	base	res.country.state	835
4506	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_BC	base	res.country.state	836
4507	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_BH	base	res.country.state	837
4508	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_BN	base	res.country.state	838
4509	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_BR	base	res.country.state	839
4510	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_BT	base	res.country.state	840
4511	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_BV	base	res.country.state	841
4512	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_BZ	base	res.country.state	842
4513	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_CJ	base	res.country.state	843
4514	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_CL	base	res.country.state	844
4515	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_CS	base	res.country.state	845
4516	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_CT	base	res.country.state	846
4517	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_CV	base	res.country.state	847
4518	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_DB	base	res.country.state	848
4519	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_DJ	base	res.country.state	849
4520	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_GJ	base	res.country.state	850
4521	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_GL	base	res.country.state	851
4522	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_GR	base	res.country.state	852
4523	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_HD	base	res.country.state	853
4524	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_HR	base	res.country.state	854
4525	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_IF	base	res.country.state	855
4526	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_IL	base	res.country.state	856
4527	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_IS	base	res.country.state	857
4528	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_MH	base	res.country.state	858
4529	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_MM	base	res.country.state	859
4530	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_MS	base	res.country.state	860
4531	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_NT	base	res.country.state	861
4532	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_OT	base	res.country.state	862
4533	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_PH	base	res.country.state	863
4534	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_SB	base	res.country.state	864
4535	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_SJ	base	res.country.state	865
4536	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_SM	base	res.country.state	866
4537	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_SV	base	res.country.state	867
4538	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_TL	base	res.country.state	868
4539	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_TM	base	res.country.state	869
4540	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_TR	base	res.country.state	870
4541	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_VL	base	res.country.state	871
4542	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_VN	base	res.country.state	872
4543	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	RO_VS	base	res.country.state	873
4544	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_BJ	base	res.country.state	874
4545	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_SH	base	res.country.state	875
4546	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_ZJ	base	res.country.state	876
4547	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_TJ	base	res.country.state	877
4548	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_AH	base	res.country.state	878
4549	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_FJ	base	res.country.state	879
4550	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_CQ	base	res.country.state	880
4551	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_JX	base	res.country.state	881
4552	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_SD	base	res.country.state	882
4553	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_HA	base	res.country.state	883
4554	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_NM	base	res.country.state	884
4555	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_HB	base	res.country.state	885
4556	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_XJ	base	res.country.state	886
4557	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_HN	base	res.country.state	887
4558	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_NX	base	res.country.state	888
4559	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_GD	base	res.country.state	889
4560	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_XZ	base	res.country.state	890
4561	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_HI	base	res.country.state	891
4562	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_GX	base	res.country.state	892
4563	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_SC	base	res.country.state	893
4564	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_HE	base	res.country.state	894
4565	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_GZ	base	res.country.state	895
4566	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_SX	base	res.country.state	896
4567	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_YN	base	res.country.state	897
4568	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_LN	base	res.country.state	898
4569	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_SN	base	res.country.state	899
4570	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_JL	base	res.country.state	900
4571	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_GS	base	res.country.state	901
4572	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_HL	base	res.country.state	902
4573	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_QH	base	res.country.state	903
4574	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_JS	base	res.country.state	904
4575	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_TW	base	res.country.state	905
4576	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_HK	base	res.country.state	906
4577	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cn_MO	base	res.country.state	907
4578	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_et_1	base	res.country.state	908
4579	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_et_2	base	res.country.state	909
4580	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_et_3	base	res.country.state	910
4581	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_et_4	base	res.country.state	911
4582	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_et_5	base	res.country.state	912
4583	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_et_6	base	res.country.state	913
4584	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_et_7	base	res.country.state	914
4585	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_et_8	base	res.country.state	915
4586	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_et_9	base	res.country.state	916
4587	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_et_10	base	res.country.state	917
4588	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_et_11	base	res.country.state	918
4589	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_1	base	res.country.state	919
4590	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_2	base	res.country.state	920
4591	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_3	base	res.country.state	921
4592	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_4	base	res.country.state	922
4593	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_5	base	res.country.state	923
4594	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_6	base	res.country.state	924
4595	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_7	base	res.country.state	925
4596	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_8	base	res.country.state	926
4597	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_9	base	res.country.state	927
4598	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_10	base	res.country.state	928
4599	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_11	base	res.country.state	929
4600	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_12	base	res.country.state	930
4601	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_13	base	res.country.state	931
4602	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_14	base	res.country.state	932
4603	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_15	base	res.country.state	933
4604	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_16	base	res.country.state	934
4605	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_17	base	res.country.state	935
4606	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_18	base	res.country.state	936
4607	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_19	base	res.country.state	937
4608	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_20	base	res.country.state	938
4609	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_21	base	res.country.state	939
4610	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_22	base	res.country.state	940
4611	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_23	base	res.country.state	941
4612	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_24	base	res.country.state	942
4613	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_25	base	res.country.state	943
4614	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_26	base	res.country.state	944
4615	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_27	base	res.country.state	945
4616	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_28	base	res.country.state	946
4617	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_29	base	res.country.state	947
4618	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_30	base	res.country.state	948
4619	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_31	base	res.country.state	949
4620	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ie_32	base	res.country.state	950
4621	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_dr	base	res.country.state	951
4622	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_fl	base	res.country.state	952
4623	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_fr	base	res.country.state	953
4624	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_ge	base	res.country.state	954
4625	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_gr	base	res.country.state	955
4626	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_li	base	res.country.state	956
4627	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_nb	base	res.country.state	957
4628	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_nh	base	res.country.state	958
4629	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_ov	base	res.country.state	959
4630	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_ut	base	res.country.state	960
4631	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_ze	base	res.country.state	961
4632	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_zh	base	res.country.state	962
4633	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_bq1	base	res.country.state	963
4634	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_bq2	base	res.country.state	964
4635	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_nl_bq3	base	res.country.state	965
4636	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_01	base	res.country.state	966
4637	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_02	base	res.country.state	967
4638	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_03	base	res.country.state	968
4639	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_04	base	res.country.state	969
4640	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_05	base	res.country.state	970
4641	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_06	base	res.country.state	971
4642	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_07	base	res.country.state	972
4643	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_08	base	res.country.state	973
4644	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_09	base	res.country.state	974
4645	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_10	base	res.country.state	975
4646	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_11	base	res.country.state	976
4647	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_12	base	res.country.state	977
4648	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_13	base	res.country.state	978
4649	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_14	base	res.country.state	979
4650	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_15	base	res.country.state	980
4651	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_16	base	res.country.state	981
4652	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_17	base	res.country.state	982
4653	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_18	base	res.country.state	983
4654	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_19	base	res.country.state	984
4655	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_20	base	res.country.state	985
4656	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_21	base	res.country.state	986
4657	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_22	base	res.country.state	987
4658	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_23	base	res.country.state	988
4659	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_24	base	res.country.state	989
4660	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_25	base	res.country.state	990
4661	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_26	base	res.country.state	991
4662	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_27	base	res.country.state	992
4663	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_28	base	res.country.state	993
4664	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_29	base	res.country.state	994
4665	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_30	base	res.country.state	995
4666	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_31	base	res.country.state	996
4667	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_32	base	res.country.state	997
4668	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_33	base	res.country.state	998
4669	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_34	base	res.country.state	999
4670	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_35	base	res.country.state	1000
4671	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_36	base	res.country.state	1001
4672	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_37	base	res.country.state	1002
4673	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_38	base	res.country.state	1003
4674	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_39	base	res.country.state	1004
4675	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_40	base	res.country.state	1005
4676	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_41	base	res.country.state	1006
4677	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_42	base	res.country.state	1007
4678	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_43	base	res.country.state	1008
4679	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_44	base	res.country.state	1009
4680	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_45	base	res.country.state	1010
4681	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_46	base	res.country.state	1011
4682	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_47	base	res.country.state	1012
4683	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_48	base	res.country.state	1013
4684	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_49	base	res.country.state	1014
4685	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_50	base	res.country.state	1015
4686	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_51	base	res.country.state	1016
4687	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_52	base	res.country.state	1017
4688	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_53	base	res.country.state	1018
4689	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_54	base	res.country.state	1019
4690	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_55	base	res.country.state	1020
4691	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_56	base	res.country.state	1021
4692	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_57	base	res.country.state	1022
4693	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_58	base	res.country.state	1023
4694	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_59	base	res.country.state	1024
4695	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_60	base	res.country.state	1025
4696	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_61	base	res.country.state	1026
4697	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_62	base	res.country.state	1027
4698	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_63	base	res.country.state	1028
4699	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_64	base	res.country.state	1029
4700	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_65	base	res.country.state	1030
4701	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_66	base	res.country.state	1031
4702	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_67	base	res.country.state	1032
4703	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_68	base	res.country.state	1033
4704	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_69	base	res.country.state	1034
4705	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_70	base	res.country.state	1035
4706	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_71	base	res.country.state	1036
4707	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_72	base	res.country.state	1037
4708	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_73	base	res.country.state	1038
4709	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_74	base	res.country.state	1039
4710	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_75	base	res.country.state	1040
4711	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_76	base	res.country.state	1041
4712	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_77	base	res.country.state	1042
4713	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_78	base	res.country.state	1043
4714	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_79	base	res.country.state	1044
4715	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_80	base	res.country.state	1045
4716	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_tr_81	base	res.country.state	1046
4717	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-44	base	res.country.state	1047
4718	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-57	base	res.country.state	1048
4719	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-31	base	res.country.state	1049
4720	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-54	base	res.country.state	1050
4721	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-53	base	res.country.state	1051
4722	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-55	base	res.country.state	1052
4723	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-56	base	res.country.state	1053
4724	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-58	base	res.country.state	1054
4725	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-43	base	res.country.state	1055
4726	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-40	base	res.country.state	1056
4727	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-50	base	res.country.state	1057
4728	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-04	base	res.country.state	1058
4729	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-59	base	res.country.state	1059
4730	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-CT	base	res.country.state	1060
4731	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-71	base	res.country.state	1061
4732	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-33	base	res.country.state	1062
4733	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-DN	base	res.country.state	1063
4734	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-39	base	res.country.state	1064
4735	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-72	base	res.country.state	1065
4736	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-45	base	res.country.state	1066
4737	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-30	base	res.country.state	1067
4738	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-14	base	res.country.state	1068
4739	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-SG	base	res.country.state	1069
4740	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-61	base	res.country.state	1070
4741	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-73	base	res.country.state	1071
4742	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-03	base	res.country.state	1072
4743	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-HN	base	res.country.state	1073
4744	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-63	base	res.country.state	1074
4745	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-HP	base	res.country.state	1075
4746	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-23	base	res.country.state	1076
4747	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-66	base	res.country.state	1077
4748	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-47	base	res.country.state	1078
4749	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-34	base	res.country.state	1079
4750	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-28	base	res.country.state	1080
4751	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-41	base	res.country.state	1081
4752	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-02	base	res.country.state	1082
4753	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-01	base	res.country.state	1083
4754	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-35	base	res.country.state	1084
4755	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-09	base	res.country.state	1085
4756	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-22	base	res.country.state	1086
4757	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-18	base	res.country.state	1087
4758	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-67	base	res.country.state	1088
4759	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-36	base	res.country.state	1089
4760	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-68	base	res.country.state	1090
4761	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-32	base	res.country.state	1091
4762	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-24	base	res.country.state	1092
4763	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-13	base	res.country.state	1093
4764	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-27	base	res.country.state	1094
4765	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-29	base	res.country.state	1095
4766	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-25	base	res.country.state	1096
4767	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-05	base	res.country.state	1097
4768	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-52	base	res.country.state	1098
4769	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-20	base	res.country.state	1099
4770	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-46	base	res.country.state	1100
4771	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-21	base	res.country.state	1101
4772	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-69	base	res.country.state	1102
4773	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-37	base	res.country.state	1103
4774	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-07	base	res.country.state	1104
4775	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-26	base	res.country.state	1105
4776	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-51	base	res.country.state	1106
4777	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-49	base	res.country.state	1107
4778	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-70	base	res.country.state	1108
4779	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_vn_VN-06	base	res.country.state	1109
4780	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_SJ	base	res.country.state	1110
4781	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_A	base	res.country.state	1111
4782	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_H	base	res.country.state	1112
4783	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_C	base	res.country.state	1113
4784	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_P	base	res.country.state	1114
4785	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_G	base	res.country.state	1115
4786	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_L	base	res.country.state	1116
4787	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_01	base	res.country.state	1117
4788	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_02	base	res.country.state	1118
4789	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_03	base	res.country.state	1119
4790	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_04	base	res.country.state	1120
4791	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_05	base	res.country.state	1121
4792	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_06	base	res.country.state	1122
4793	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_07	base	res.country.state	1123
4794	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_08	base	res.country.state	1124
4795	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_09	base	res.country.state	1125
4796	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_10	base	res.country.state	1126
4797	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_11	base	res.country.state	1127
4798	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_12	base	res.country.state	1128
4799	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_13	base	res.country.state	1129
4800	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_14	base	res.country.state	1130
4801	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_15	base	res.country.state	1131
4802	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_16	base	res.country.state	1132
4803	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_17	base	res.country.state	1133
4804	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_18	base	res.country.state	1134
4805	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_19	base	res.country.state	1135
4806	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_20	base	res.country.state	1136
4807	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_21	base	res.country.state	1137
4808	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_22	base	res.country.state	1138
4809	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_23	base	res.country.state	1139
4810	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_24	base	res.country.state	1140
4811	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_25	base	res.country.state	1141
4812	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_26	base	res.country.state	1142
4813	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_27	base	res.country.state	1143
4814	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_28	base	res.country.state	1144
4815	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_29	base	res.country.state	1145
4816	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_30	base	res.country.state	1146
4817	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_31	base	res.country.state	1147
4818	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_DO_32	base	res.country.state	1148
4819	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_01	base	res.country.state	1149
4820	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_02	base	res.country.state	1150
4821	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_03	base	res.country.state	1151
4822	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_04	base	res.country.state	1152
4823	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_05	base	res.country.state	1153
4824	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_06	base	res.country.state	1154
4825	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_07	base	res.country.state	1155
4826	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_08	base	res.country.state	1156
4827	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_09	base	res.country.state	1157
4828	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_10	base	res.country.state	1158
4829	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_11	base	res.country.state	1159
4830	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_12	base	res.country.state	1160
4831	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_13	base	res.country.state	1161
4832	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_14	base	res.country.state	1162
4833	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_15	base	res.country.state	1163
4834	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_16	base	res.country.state	1164
4835	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_17	base	res.country.state	1165
4836	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_18	base	res.country.state	1166
4837	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_19	base	res.country.state	1167
4838	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_20	base	res.country.state	1168
4839	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_21	base	res.country.state	1169
4840	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_22	base	res.country.state	1170
4841	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_23	base	res.country.state	1171
4842	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_24	base	res.country.state	1172
4843	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_pe_25	base	res.country.state	1173
4844	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_01	base	res.country.state	1174
4845	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_02	base	res.country.state	1175
4846	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_03	base	res.country.state	1176
4847	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_04	base	res.country.state	1177
4848	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_05	base	res.country.state	1178
4849	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_06	base	res.country.state	1179
4850	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_07	base	res.country.state	1180
4851	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_08	base	res.country.state	1181
4852	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_09	base	res.country.state	1182
4853	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_10	base	res.country.state	1183
4854	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_11	base	res.country.state	1184
4855	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_12	base	res.country.state	1185
4856	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_13	base	res.country.state	1186
4857	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_14	base	res.country.state	1187
4858	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_15	base	res.country.state	1188
4859	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_cl_16	base	res.country.state	1189
4860	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_37	base	res.country.state	1190
4861	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_39	base	res.country.state	1191
4862	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_44	base	res.country.state	1192
4863	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_49	base	res.country.state	1193
4864	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_51	base	res.country.state	1194
4865	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_57	base	res.country.state	1195
4866	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_59	base	res.country.state	1196
4867	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_65	base	res.country.state	1197
4868	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_67	base	res.country.state	1198
4869	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_70	base	res.country.state	1199
4870	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_74	base	res.country.state	1200
4871	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_78	base	res.country.state	1201
4872	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_82	base	res.country.state	1202
4873	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_84	base	res.country.state	1203
4874	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_ee_86	base	res.country.state	1204
4875	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_001	base	res.country.state	1205
4876	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_002	base	res.country.state	1206
4877	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_003	base	res.country.state	1207
4878	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_004	base	res.country.state	1208
4879	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_005	base	res.country.state	1209
4880	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_006	base	res.country.state	1210
4881	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_007	base	res.country.state	1211
4882	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_008	base	res.country.state	1212
4883	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_009	base	res.country.state	1213
4884	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_010	base	res.country.state	1214
4885	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_011	base	res.country.state	1215
4886	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_012	base	res.country.state	1216
4887	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_013	base	res.country.state	1217
4888	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_014	base	res.country.state	1218
4889	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_015	base	res.country.state	1219
4890	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_016	base	res.country.state	1220
4891	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_017	base	res.country.state	1221
4892	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_018	base	res.country.state	1222
4893	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_019	base	res.country.state	1223
4894	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_020	base	res.country.state	1224
4895	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_021	base	res.country.state	1225
4896	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_022	base	res.country.state	1226
4897	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_023	base	res.country.state	1227
4898	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_024	base	res.country.state	1228
4899	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_025	base	res.country.state	1229
4900	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_026	base	res.country.state	1230
4901	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_027	base	res.country.state	1231
4902	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_028	base	res.country.state	1232
4903	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_029	base	res.country.state	1233
4904	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_030	base	res.country.state	1234
4905	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_031	base	res.country.state	1235
4906	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_032	base	res.country.state	1236
4907	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_033	base	res.country.state	1237
4908	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_034	base	res.country.state	1238
4909	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_035	base	res.country.state	1239
4910	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_036	base	res.country.state	1240
4911	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_037	base	res.country.state	1241
4912	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_038	base	res.country.state	1242
4913	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_039	base	res.country.state	1243
4914	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_040	base	res.country.state	1244
4915	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_041	base	res.country.state	1245
4916	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_042	base	res.country.state	1246
4917	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_043	base	res.country.state	1247
4918	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_044	base	res.country.state	1248
4919	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_045	base	res.country.state	1249
4920	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_046	base	res.country.state	1250
4921	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_047	base	res.country.state	1251
4922	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_048	base	res.country.state	1252
4923	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_049	base	res.country.state	1253
4924	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_050	base	res.country.state	1254
4925	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_051	base	res.country.state	1255
4926	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_052	base	res.country.state	1256
4927	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_053	base	res.country.state	1257
4928	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_054	base	res.country.state	1258
4929	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_055	base	res.country.state	1259
4930	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_056	base	res.country.state	1260
4931	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_057	base	res.country.state	1261
4932	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_058	base	res.country.state	1262
4933	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_059	base	res.country.state	1263
4934	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_060	base	res.country.state	1264
4935	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_061	base	res.country.state	1265
4936	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_062	base	res.country.state	1266
4937	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_063	base	res.country.state	1267
4938	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_064	base	res.country.state	1268
4939	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_065	base	res.country.state	1269
4940	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_066	base	res.country.state	1270
4941	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_067	base	res.country.state	1271
4942	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_068	base	res.country.state	1272
4943	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_069	base	res.country.state	1273
4944	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_070	base	res.country.state	1274
4945	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_071	base	res.country.state	1275
4946	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_072	base	res.country.state	1276
4947	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_073	base	res.country.state	1277
4948	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_074	base	res.country.state	1278
4949	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_075	base	res.country.state	1279
4950	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_076	base	res.country.state	1280
4951	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_077	base	res.country.state	1281
4952	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_078	base	res.country.state	1282
4953	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_079	base	res.country.state	1283
4954	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_080	base	res.country.state	1284
4955	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_081	base	res.country.state	1285
4956	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_082	base	res.country.state	1286
4957	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_083	base	res.country.state	1287
4958	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_084	base	res.country.state	1288
4959	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_085	base	res.country.state	1289
4960	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_086	base	res.country.state	1290
4961	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_087	base	res.country.state	1291
4962	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_088	base	res.country.state	1292
4963	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_089	base	res.country.state	1293
4964	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_090	base	res.country.state	1294
4965	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_091	base	res.country.state	1295
4966	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_092	base	res.country.state	1296
4967	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_093	base	res.country.state	1297
4968	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_094	base	res.country.state	1298
4969	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_095	base	res.country.state	1299
4970	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_096	base	res.country.state	1300
4971	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_097	base	res.country.state	1301
4972	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_098	base	res.country.state	1302
4973	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_099	base	res.country.state	1303
4974	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_100	base	res.country.state	1304
4975	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_101	base	res.country.state	1305
4976	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_102	base	res.country.state	1306
4977	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_103	base	res.country.state	1307
4978	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_104	base	res.country.state	1308
4979	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_105	base	res.country.state	1309
4980	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_106	base	res.country.state	1310
4981	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_107	base	res.country.state	1311
4982	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_108	base	res.country.state	1312
4983	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_109	base	res.country.state	1313
4984	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_110	base	res.country.state	1314
4985	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_dgv	base	res.country.state	1315
4986	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_jel	base	res.country.state	1316
4987	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_jkb	base	res.country.state	1317
4988	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_jur	base	res.country.state	1318
4989	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_lpx	base	res.country.state	1319
4990	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_rez	base	res.country.state	1320
4991	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_rix	base	res.country.state	1321
4992	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_vmr	base	res.country.state	1322
4993	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lv_ven	base	res.country.state	1323
4994	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lt_al	base	res.country.state	1324
4995	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lt_ku	base	res.country.state	1325
4996	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lt_kl	base	res.country.state	1326
4997	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lt_mr	base	res.country.state	1327
4998	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lt_pn	base	res.country.state	1328
4999	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lt_sa	base	res.country.state	1329
5000	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lt_ta	base	res.country.state	1330
5001	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lt_te	base	res.country.state	1331
5002	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lt_ut	base	res.country.state	1332
5003	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_lt_vl	base	res.country.state	1333
5004	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_01	base	res.country.state	1334
5005	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_02	base	res.country.state	1335
5006	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_03	base	res.country.state	1336
5007	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_04	base	res.country.state	1337
5008	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_05	base	res.country.state	1338
5009	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_06	base	res.country.state	1339
5010	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_07	base	res.country.state	1340
5011	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_08	base	res.country.state	1341
5012	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_09	base	res.country.state	1342
5013	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_10	base	res.country.state	1343
5014	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_11	base	res.country.state	1344
5015	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_12	base	res.country.state	1345
5016	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_13	base	res.country.state	1346
5017	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_14	base	res.country.state	1347
5018	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_15	base	res.country.state	1348
5019	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_16	base	res.country.state	1349
5020	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_17	base	res.country.state	1350
5021	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_18	base	res.country.state	1351
5022	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_fi_19	base	res.country.state	1352
5023	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_k	base	res.country.state	1353
5024	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_w	base	res.country.state	1354
5025	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_i	base	res.country.state	1355
5026	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_x	base	res.country.state	1356
5027	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_n	base	res.country.state	1357
5028	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_z	base	res.country.state	1358
5029	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_f	base	res.country.state	1359
5030	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_h	base	res.country.state	1360
5031	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_g	base	res.country.state	1361
5032	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_bd	base	res.country.state	1362
5033	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_m	base	res.country.state	1363
5034	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_ab	base	res.country.state	1364
5035	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_d	base	res.country.state	1365
5036	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_c	base	res.country.state	1366
5037	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se_s	base	res.country.state	1367
5038	\N	2026-01-22 02:33:34.171596	2026-01-22 02:33:34.171596	\N	f	state_se