--
-- PostgreSQL database dump
--

-- Dumped from database version 16.9 (Ubuntu 16.9-1.pgdg20.04+1)
-- Dumped by pg_dump version 16.9 (Ubuntu 16.9-1.pgdg24.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_cache_signaling_assets; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_assets
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_assets OWNER TO runbot;

--
-- Name: base_cache_signaling_default; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_default
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_default OWNER TO runbot;

--
-- Name: base_cache_signaling_groups; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_groups
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_groups OWNER TO runbot;

--
-- Name: base_cache_signaling_routing; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_routing
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_routing OWNER TO runbot;

--
-- Name: base_cache_signaling_templates; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_templates
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_templates OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone
);


ALTER TABLE public.bus_presence OWNER TO runbot;

--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_presence_id_seq OWNER TO runbot;

--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    account_token character varying(43),
    balance character varying,
    state character varying,
    service_locked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_id IS 'Service';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.balance IS 'Balance';


--
-- Name: COLUMN iap_account.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.state IS 'State';


--
-- Name: COLUMN iap_account.service_locked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_locked IS 'Service Locked';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account.warning_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.warning_threshold IS 'Email Alert Threshold';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: iap_account_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_users_rel (
    iap_account_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_users_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_users_rel IS 'RELATION BETWEEN iap_account AND res_users';


--
-- Name: iap_service; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_service (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    technical_name character varying NOT NULL,
    description jsonb NOT NULL,
    unit_name jsonb NOT NULL,
    integer_balance boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_service OWNER TO runbot;

--
-- Name: TABLE iap_service; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_service IS 'IAP Service';


--
-- Name: COLUMN iap_service.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_uid IS 'Created by';


--
-- Name: COLUMN iap_service.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_service.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.name IS 'Name';


--
-- Name: COLUMN iap_service.technical_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.technical_name IS 'Technical Name';


--
-- Name: COLUMN iap_service.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.description IS 'Description';


--
-- Name: COLUMN iap_service.unit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_service.integer_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.integer_balance IS 'Integer Balance';


--
-- Name: COLUMN iap_service.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_date IS 'Created on';


--
-- Name: COLUMN iap_service.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_date IS 'Last Updated on';


--
-- Name: iap_service_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_service_id_seq OWNER TO runbot;

--
-- Name: iap_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_service_id_seq OWNED BY public.iap_service.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    path character varying,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.path IS 'Path to show in the URL';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    domain character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.domain IS 'Filter domain';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    selection_value integer,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    model_name character varying,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_webhook_field_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer NOT NULL,
    priority integer,
    failure_count integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying NOT NULL,
    active boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    first_failure_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_cron_check_strictly_positive_interval CHECK ((interval_number > 0))
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.failure_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.failure_count IS 'Failure Count';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.first_failure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.first_failure_date IS 'First Failure Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_cron_check_strictly_positive_interval ON ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_cron_check_strictly_positive_interval ON public.ir_cron IS 'CHECK(interval_number > 0)';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_progress (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    remaining integer,
    done integer,
    timed_out_counter integer,
    create_uid integer,
    write_uid integer,
    deactivate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_progress OWNER TO runbot;

--
-- Name: TABLE ir_cron_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_progress IS 'Progress of Scheduled Actions';


--
-- Name: COLUMN ir_cron_progress.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_progress.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.remaining IS 'Remaining';


--
-- Name: COLUMN ir_cron_progress.done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.done IS 'Done';


--
-- Name: COLUMN ir_cron_progress.timed_out_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.timed_out_counter IS 'Timed Out Counter';


--
-- Name: COLUMN ir_cron_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_progress.deactivate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.deactivate IS 'Deactivate';


--
-- Name: COLUMN ir_cron_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_date IS 'Last Updated on';


--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_progress_id_seq OWNER TO runbot;

--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_progress_id_seq OWNED BY public.ir_cron_progress.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    json_value character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default.json_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.json_value IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_embedded_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions (
    id integer NOT NULL,
    sequence integer,
    parent_action_id integer NOT NULL,
    parent_res_id integer,
    action_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    parent_res_model character varying NOT NULL,
    python_method character varying,
    default_view_mode character varying,
    domain character varying,
    context character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_embedded_actions_check_only_one_action_defined CHECK ((((action_id IS NOT NULL) AND (python_method IS NULL)) OR ((action_id IS NULL) AND (python_method IS NOT NULL)))),
    CONSTRAINT ir_embedded_actions_check_python_method_requires_name CHECK ((NOT ((python_method IS NOT NULL) AND (name IS NULL))))
);


ALTER TABLE public.ir_embedded_actions OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions IS 'Embedded Actions';


--
-- Name: COLUMN ir_embedded_actions.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.sequence IS 'Sequence';


--
-- Name: COLUMN ir_embedded_actions.parent_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_action_id IS 'Parent Action';


--
-- Name: COLUMN ir_embedded_actions.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_id IS 'Active Parent Id';


--
-- Name: COLUMN ir_embedded_actions.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.action_id IS 'Action';


--
-- Name: COLUMN ir_embedded_actions.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.user_id IS 'User';


--
-- Name: COLUMN ir_embedded_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_embedded_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_embedded_actions.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_model IS 'Active Parent Model';


--
-- Name: COLUMN ir_embedded_actions.python_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.python_method IS 'Python Method';


--
-- Name: COLUMN ir_embedded_actions.default_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.default_view_mode IS 'Default View';


--
-- Name: COLUMN ir_embedded_actions.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.domain IS 'Domain';


--
-- Name: COLUMN ir_embedded_actions.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.context IS 'Context';


--
-- Name: COLUMN ir_embedded_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.name IS 'Name';


--
-- Name: COLUMN ir_embedded_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_embedded_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON public.ir_embedded_actions IS 'CHECK(
                (action_id IS NOT NULL AND python_method IS NULL) OR
                (action_id IS NULL AND python_method IS NOT NULL)
            )';


--
-- Name: CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON public.ir_embedded_actions IS 'CHECK(
                NOT (python_method IS NOT NULL AND name IS NULL)
            )';


--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_embedded_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNER TO runbot;

--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNED BY public.ir_embedded_actions.id;


--
-- Name: ir_embedded_actions_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions_res_groups_rel (
    ir_embedded_actions_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.ir_embedded_actions_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions_res_groups_rel IS 'RELATION BETWEEN ir_embedded_actions AND res_groups';


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    user_id integer,
    action_id integer,
    embedded_action_id integer,
    embedded_parent_res_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    sort character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_filters_check_res_id_only_when_embedded_action CHECK ((NOT ((embedded_parent_res_id IS NOT NULL) AND (embedded_action_id IS NULL)))),
    CONSTRAINT ir_filters_check_sort_json CHECK (((sort IS NULL) OR (jsonb_typeof((sort)::jsonb) = 'array'::text)))
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.embedded_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_action_id IS 'Embedded Action';


--
-- Name: COLUMN ir_filters.embedded_parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_parent_res_id IS 'Embedded Parent Res';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON public.ir_filters IS 'CHECK(
                NOT (embedded_parent_res_id IS NOT NULL AND embedded_action_id IS NULL)
            )';


--
-- Name: CONSTRAINT ir_filters_check_sort_json ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_sort_json ON public.ir_filters IS 'CHECK(sort IS NULL OR jsonb_typeof(sort::jsonb) = ''array'')';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_email_size double precision,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    CONSTRAINT ir_mail_server_certificate_requires_tls CHECK ((((smtp_encryption)::text <> 'none'::text) OR ((smtp_authentication)::text <> 'certificate'::text)))
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.max_email_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.max_email_size IS 'Max Email Size';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: CONSTRAINT ir_mail_server_certificate_requires_tls ON ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_mail_server_certificate_requires_tls ON public.ir_mail_server IS 'CHECK(smtp_encryption != ''none'' OR smtp_authentication != ''certificate'')';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    name jsonb NOT NULL,
    info text,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    company_dependent boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field Definition';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.company_dependent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.company_dependent IS 'Company Dependent';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


ALTER TABLE public.ir_model_inherit OWNER TO runbot;

--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_id IS 'Parent';


--
-- Name: COLUMN ir_model_inherit.parent_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_field_id IS 'Parent Field';


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_inherit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_inherit_id_seq OWNER TO runbot;

--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_inherit_id_seq OWNED BY public.ir_model_inherit.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    module_type character varying,
    imported boolean
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.module_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN ir_module_module.imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.imported IS 'Imported Module';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    create_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: module_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_country (
    module_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.module_country OWNER TO runbot;

--
-- Name: TABLE module_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_country IS 'RELATION BETWEEN ir_module_module AND res_country';


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: rel_server_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_server_actions (
    server_id integer NOT NULL,
    action_id integer NOT NULL
);


ALTER TABLE public.rel_server_actions OWNER TO runbot;

--
-- Name: TABLE rel_server_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_server_actions IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    css_margins boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.css_margins; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.css_margins IS 'Use css margins';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    mobile character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.mobile IS 'Mobile';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    web_app_name character varying,
    company_id integer NOT NULL,
    user_default_rights boolean,
    module_base_import boolean,
    module_google_calendar boolean,
    module_microsoft_calendar boolean,
    module_mail_plugin boolean,
    module_auth_oauth boolean,
    module_auth_ldap boolean,
    module_account_inter_company_rules boolean,
    module_voip boolean,
    module_web_unsplash boolean,
    module_sms boolean,
    module_partner_autocomplete boolean,
    module_base_geolocalize boolean,
    module_google_recaptcha boolean,
    module_website_cf_turnstile boolean,
    group_multi_currency boolean,
    show_effect boolean,
    module_product_images boolean,
    profiling_enabled_until timestamp without time zone,
    unsplash_access_key character varying,
    unsplash_app_id character varying
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.web_app_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.web_app_name IS 'Web App Name';


--
-- Name: COLUMN res_config_settings.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.company_id IS 'Company';


--
-- Name: COLUMN res_config_settings.user_default_rights; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.user_default_rights IS 'Default Access Rights';


--
-- Name: COLUMN res_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_import IS 'Allow users to import data from CSV/XLS/XLSX/ODS files';


--
-- Name: COLUMN res_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN res_config_settings.module_microsoft_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_calendar IS 'Allow the users to synchronize their calendar with Outlook Calendar';


--
-- Name: COLUMN res_config_settings.module_mail_plugin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_mail_plugin IS 'Allow integration with the mail plugins';


--
-- Name: COLUMN res_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_oauth IS 'Use external authentication providers (OAuth)';


--
-- Name: COLUMN res_config_settings.module_auth_ldap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_ldap IS 'LDAP Authentication';


--
-- Name: COLUMN res_config_settings.module_account_inter_company_rules; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_account_inter_company_rules IS 'Manage Inter Company';


--
-- Name: COLUMN res_config_settings.module_voip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_voip IS 'VoIP';


--
-- Name: COLUMN res_config_settings.module_web_unsplash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_web_unsplash IS 'Unsplash Image Library';


--
-- Name: COLUMN res_config_settings.module_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_sms IS 'SMS';


--
-- Name: COLUMN res_config_settings.module_partner_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_partner_autocomplete IS 'Partner Autocomplete';


--
-- Name: COLUMN res_config_settings.module_base_geolocalize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_geolocalize IS 'GeoLocalize';


--
-- Name: COLUMN res_config_settings.module_google_recaptcha; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_recaptcha IS 'reCAPTCHA';


--
-- Name: COLUMN res_config_settings.module_website_cf_turnstile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_website_cf_turnstile IS 'Cloudflare Turnstile';


--
-- Name: COLUMN res_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_multi_currency IS 'Multi-Currencies';


--
-- Name: COLUMN res_config_settings.show_effect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.show_effect IS 'Show Effect';


--
-- Name: COLUMN res_config_settings.module_product_images; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_product_images IS 'Get product pictures using barcode';


--
-- Name: COLUMN res_config_settings.profiling_enabled_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.profiling_enabled_until IS 'Profiling enabled until';


--
-- Name: COLUMN res_config_settings.unsplash_access_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_access_key IS 'Access Key';


--
-- Name: COLUMN res_config_settings.unsplash_app_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_app_id IS 'Application ID';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2) NOT NULL,
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    iso_numeric integer,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label jsonb,
    currency_subunit_label jsonb,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.iso_numeric; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.iso_numeric IS 'Currency numeric code.';


--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_device_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_device_log (
    id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    session_identifier character varying NOT NULL,
    platform character varying,
    browser character varying,
    ip_address character varying,
    country character varying,
    city character varying,
    device_type character varying,
    revoked boolean,
    first_activity timestamp without time zone,
    last_activity timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_device_log OWNER TO runbot;

--
-- Name: TABLE res_device_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_device_log IS 'Device Log';


--
-- Name: COLUMN res_device_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.user_id IS 'User';


--
-- Name: COLUMN res_device_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_device_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_device_log.session_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.session_identifier IS 'Session Identifier';


--
-- Name: COLUMN res_device_log.platform; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.platform IS 'Platform';


--
-- Name: COLUMN res_device_log.browser; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.browser IS 'Browser';


--
-- Name: COLUMN res_device_log.ip_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.ip_address IS 'IP Address';


--
-- Name: COLUMN res_device_log.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.country IS 'Country';


--
-- Name: COLUMN res_device_log.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.city IS 'City';


--
-- Name: COLUMN res_device_log.device_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.device_type IS 'Device Type';


--
-- Name: COLUMN res_device_log.revoked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.revoked IS 'Revoked';


--
-- Name: COLUMN res_device_log.first_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.first_activity IS 'First Activity';


--
-- Name: COLUMN res_device_log.last_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.last_activity IS 'Last Activity';


--
-- Name: COLUMN res_device_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_date IS 'Created on';


--
-- Name: COLUMN res_device_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_date IS 'Last Updated on';


--
-- Name: res_device; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.res_device AS
 SELECT id,
    user_id,
    create_uid,
    write_uid,
    session_identifier,
    platform,
    browser,
    ip_address,
    country,
    city,
    device_type,
    revoked,
    first_activity,
    last_activity,
    create_date,
    write_date
   FROM public.res_device_log d
  WHERE ((NOT (EXISTS ( SELECT 1
           FROM public.res_device_log d2
          WHERE ((d2.user_id = d.user_id) AND ((d2.session_identifier)::text = (d.session_identifier)::text) AND (NOT ((d2.platform)::text IS DISTINCT FROM (d.platform)::text)) AND (NOT ((d2.browser)::text IS DISTINCT FROM (d.browser)::text)) AND ((d2.last_activity > d.last_activity) OR ((d2.last_activity = d.last_activity) AND (d2.id > d.id))) AND (d2.revoked = false))))) AND (revoked = false));


ALTER VIEW public.res_device OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_device_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_device_log_id_seq OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_device_log_id_seq OWNED BY public.res_device_log.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    category_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    api_key_duration double precision,
    CONSTRAINT res_groups_check_api_key_duration CHECK ((api_key_duration >= (0)::double precision))
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.category_id IS 'Application';


--
-- Name: COLUMN res_groups.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.color IS 'Color Index';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_groups.api_key_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.api_key_duration IS 'API Keys maximum duration days';


--
-- Name: CONSTRAINT res_groups_check_api_key_duration ON res_groups; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_groups_check_api_key_duration ON public.res_groups IS 'CHECK(api_key_duration >= 0)';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    short_time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.short_time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.short_time_format IS 'Short Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


ALTER TABLE public.res_lang_install_rel OWNER TO runbot;

--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    title integer,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    mobile character varying,
    commercial_company_name character varying,
    company_name character varying,
    barcode jsonb,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.title IS 'Title';


--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.complete_name IS 'Complete Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.mobile IS 'Mobile';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.barcode IS 'Barcode';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_partner_title; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_title (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    shortcut jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_title OWNER TO runbot;

--
-- Name: TABLE res_partner_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_title IS 'Partner Title';


--
-- Name: COLUMN res_partner_title.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_title.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_title.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.name IS 'Title';


--
-- Name: COLUMN res_partner_title.shortcut; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.shortcut IS 'Abbreviation';


--
-- Name: COLUMN res_partner_title.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_title.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_date IS 'Last Updated on';


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_title_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_title_id_seq OWNER TO runbot;

--
-- Name: res_partner_title_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_title_id_seq OWNED BY public.res_partner_title.id;


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    totp_secret character varying,
    tour_enabled boolean
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users.tour_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.tour_enabled IS 'Onboarding';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    duration character varying NOT NULL,
    expiration_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.duration IS 'Duration';


--
-- Name: COLUMN res_users_apikeys_description.expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.expiration_date IS 'Expiration Date';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_deletion OWNER TO runbot;

--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_deletion_id_seq OWNER TO runbot;

--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    auth_method character varying,
    password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.auth_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.auth_method IS 'Auth Method';


--
-- Name: COLUMN res_users_identitycheck.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.password IS 'Password';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: res_users_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_settings OWNER TO runbot;

--
-- Name: TABLE res_users_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings IS 'User Settings';


--
-- Name: COLUMN res_users_settings.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.user_id IS 'User';


--
-- Name: COLUMN res_users_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_date IS 'Last Updated on';


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_id_seq OWNED BY public.res_users_settings.id;


--
-- Name: res_users_web_tour_tour_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_web_tour_tour_rel (
    web_tour_tour_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_users_web_tour_tour_rel OWNER TO runbot;

--
-- Name: TABLE res_users_web_tour_tour_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_web_tour_tour_rel IS 'RELATION BETWEEN web_tour_tour AND res_users';


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: web_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


ALTER TABLE public.web_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test IS 'Web Editor Converter Test';


--
-- Name: COLUMN web_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN web_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN web_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN web_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN web_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN web_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN web_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN web_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN web_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN web_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN web_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN web_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."binary" IS 'Binary';


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNED BY public.web_editor_converter_test.id;


--
-- Name: web_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test_sub IS 'Web Editor Converter Subtest';


--
-- Name: COLUMN web_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN web_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNED BY public.web_editor_converter_test_sub.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    url character varying,
    rainbow_man_message jsonb,
    custom boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Name';


--
-- Name: COLUMN web_tour_tour.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.url IS 'Starting URL';


--
-- Name: COLUMN web_tour_tour.rainbow_man_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.rainbow_man_message IS 'Rainbow Man Message';


--
-- Name: COLUMN web_tour_tour.custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.custom IS 'Custom';


--
-- Name: COLUMN web_tour_tour.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: web_tour_tour_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour_step (
    id integer NOT NULL,
    tour_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    trigger character varying NOT NULL,
    content character varying,
    run character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour_step OWNER TO runbot;

--
-- Name: TABLE web_tour_tour_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour_step IS 'Tour''s step';


--
-- Name: COLUMN web_tour_tour_step.tour_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.tour_id IS 'Tour';


--
-- Name: COLUMN web_tour_tour_step.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour_step.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.trigger IS 'Trigger';


--
-- Name: COLUMN web_tour_tour_step.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.content IS 'Content';


--
-- Name: COLUMN web_tour_tour_step.run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.run IS 'Run';


--
-- Name: COLUMN web_tour_tour_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNED BY public.web_tour_tour_step.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_module ALTER COLUMN id SET DEFAULT nextval('public.base_import_module_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: bus_presence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_presence ALTER COLUMN id SET DEFAULT nextval('public.bus_presence_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: iap_account id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_account ALTER COLUMN id SET DEFAULT nextval('public.iap_account_id_seq'::regclass);


--
-- Name: iap_service id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_service ALTER COLUMN id SET DEFAULT nextval('public.iap_service_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_progress id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_progress ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_progress_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_embedded_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_embedded_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_embedded_actions_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_inherit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_inherit ALTER COLUMN id SET DEFAULT nextval('public.ir_model_inherit_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_device_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_device_log ALTER COLUMN id SET DEFAULT nextval('public.res_device_log_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_partner_title id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_title ALTER COLUMN id SET DEFAULT nextval('public.res_partner_title_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: res_users_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: web_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_id_seq'::regclass);


--
-- Name: web_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: web_tour_tour_step id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour_step ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_step_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_device (id, name, user_id, scope, expiration_date, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_wizard (id, user_id, create_uid, write_uid, secret, url, code, create_date, write_date, qrcode) FROM stdin;
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_enable_profiling_wizard (id, create_uid, write_uid, duration, expiration, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_import (id, create_uid, write_uid, res_model, file_name, file_type, create_date, write_date, file) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_mapping (id, create_uid, write_uid, res_model, column_name, field_name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_module; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_module (id, create_uid, write_uid, state, import_message, modules_dependencies, force, with_demo, create_date, write_date, module_file) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_export (id, model_id, create_uid, write_uid, name, lang, format, export_type, domain, state, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_import (id, create_uid, write_uid, name, code, filename, overwrite, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_install (id, create_uid, write_uid, overwrite, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall (id, module_id, create_uid, write_uid, show_all, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_update (id, updated, added, create_uid, write_uid, state, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_upgrade (id, create_uid, write_uid, module_info, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard (id, number_group, current_line_id, dst_partner_id, maximum_group, create_uid, write_uid, state, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, exclude_contact, exclude_journal_item, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, create_uid, write_uid, aggr_ids, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_bus; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_bus (id, create_uid, write_uid, channel, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_presence; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_presence (id, user_id, status, last_poll, last_presence) FROM stdin;
\.


--
-- Data for Name: change_password_own; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_own (id, create_uid, write_uid, new_password, confirm_password, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_user; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_user (id, wizard_id, user_id, create_uid, write_uid, user_login, new_passwd, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: decimal_precision; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.decimal_precision (id, digits, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: iap_account; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account (id, service_id, create_uid, write_uid, name, account_token, balance, state, service_locked, create_date, write_date, warning_threshold) FROM stdin;
\.


--
-- Data for Name: iap_account_res_company_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account_res_company_rel (iap_account_id, res_company_id) FROM stdin;
\.


--
-- Data for Name: iap_account_res_users_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account_res_users_rel (iap_account_id, res_users_id) FROM stdin;
\.


--
-- Data for Name: iap_service; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_service (id, create_uid, write_uid, name, technical_name, description, unit_name, integer_balance, create_date, write_date) FROM stdin;
1	1	1	Lead Generation	reveal	{"en_US": "Get quality leads and opportunities: convert your website visitors into leads, generate leads based on a set of criteria and enrich the company data of your opportunities."}	{"en_US": "Credits"}	t	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
\.


--
-- Data for Name: ir_act_client; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_client (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, tag, target, res_model, context, params_store) FROM stdin;
2	\N	1	1	ir.actions.client	\N	action	list,form	{"en_US": "Open Settings Menu"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	reload	current	\N	{}	\\x7b276d656e755f6964273a20317d
\.


--
-- Data for Name: ir_act_report_xml; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_report_xml (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, paperformat_id, model, report_type, report_name, report_file, attachment, domain, print_report_name, multi, attachment_use) FROM stdin;
37	3	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Model Overview"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	ir.model	qweb-pdf	base.report_irmodeloverview	base.report_irmodeloverview	\N	\N	\N	\N	\N
42	68	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Technical guide"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	ir.module.module	qweb-pdf	base.report_irmodulereference	base.report_irmodulereference	\N	\N	\N	\N	\N
78	96	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Preview Internal Report"}	\N	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651	\N	res.company	qweb-pdf	web.preview_internalreport	web.preview_internalreport	\N	\N	\N	\N	\N
79	96	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Preview External Report"}	\N	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651	\N	res.company	qweb-pdf	web.preview_externalreport	web.preview_externalreport	\N	\N	\N	\N	\N
80	96	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Report Layout Preview"}	\N	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651	\N	res.company	qweb-pdf	web.preview_layout_report	web.preview_layout_report	\N	\N	\N	\N	\N
\.


--
-- Data for Name: ir_act_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, sequence, model_id, crud_model_id, link_field_id, update_field_id, update_related_model_id, selection_value, usage, state, model_name, update_path, update_m2m_operation, update_boolean_value, evaluation_type, resource_ref, webhook_url, code, value) FROM stdin;
12	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Config: Run Remaining Action Todo"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	5	92	\N	\N	\N	\N	\N	ir_actions_server	code	res.config	\N	add	true	value	\N	\N	\nconfig = model.next() or {}\nif config.get('type') not in ('ir.actions.act_window_close',):\n    action = config\n	\N
35	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Base: Auto-vacuum internal data"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	5	40	\N	\N	\N	\N	\N	ir_cron	code	ir.autovacuum	\N	add	true	value	\N	\N	model._run_vacuum_cleaner()	\N
36	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Base: Portal Users Deletion"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	5	108	\N	\N	\N	\N	\N	ir_cron	code	res.users.deletion	\N	add	true	value	\N	\N	model._gc_portal_users(batch_size=50)	\N
51	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Failed to install demo data for some modules, demo disabled"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	5	73	\N	\N	\N	\N	\N	ir_actions_server	code	ir.demo_failure.wizard	\N	add	true	value	\N	\N	\nfailures = env['ir.demo_failure'].search([\n    ('wizard_id', '=', False),\n])\nrecord = model.create({\n    'failure_ids': [Command.set(failures.ids)],\n})\naction = {\n    'type': 'ir.actions.act_window',\n    'res_id': record.id,\n    'res_model': 'ir.demo_failure.wizard',\n    'target': 'new',\n    'views': [(env.ref('base.demo_failures_dialog').id, 'form')],\n}\n        	\N
82	88	1	1	ir.actions.server	\N	action	form,list	{"en_US": "Download (vCard)"}	\N	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651	5	88	\N	\N	\N	\N	\N	ir_actions_server	code	res.partner	\N	add	true	value	\N	\N	\n            action = {\n                'type': 'ir.actions.act_url',\n                'url': '/web/partner/vcard?partner_ids=' + ','.join(map(str, records.ids)),\n                'target': 'download',\n            }\n        	\N
83	99	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Disable two-factor authentication"}	\N	2026-01-22 18:40:05.375352	2026-01-22 18:40:05.375352	5	99	\N	\N	\N	\N	\N	ir_actions_server	code	res.users	\N	add	true	value	\N	\N	\n            action = records.action_totp_disable()\n        	\N
87	133	1	1	ir.actions.server	\N	action	form	{"en_US": "Export JS"}	\N	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702	5	133	\N	\N	\N	\N	\N	ir_actions_server	code	web_tour.tour	\N	add	true	value	\N	\N	\nif records:\n    action = records.export_js_file()\n        	\N
\.


--
-- Data for Name: ir_act_server_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_group_rel (act_id, gid) FROM stdin;
83	2
\.


--
-- Data for Name: ir_act_server_webhook_field_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_webhook_field_rel (server_id, field_id) FROM stdin;
\.


--
-- Data for Name: ir_act_url; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_url (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, target, url) FROM stdin;
3	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Home Menu"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	self	/web
40	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Third-Party Apps"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	new	https://apps.odoo.com/apps/modules
41	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Theme Store"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	new	https://apps.odoo.com/apps/themes
\.


--
-- Data for Name: ir_act_window; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, view_id, res_id, "limit", search_view_id, domain, context, res_model, target, view_mode, mobile_view_mode, usage, filter) FROM stdin;
1	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Load demo data"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	ir.demo	new	form	kanban	\N	\N
4	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Decimal Accuracy"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	decimal.precision	current	list,form	kanban	\N	\N
5	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Actions"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	6	\N	80	7	\N	{}	ir.actions.actions	current	list,form	kanban	\N	\N
6	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Reports"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	9	\N	80	10	\N	{}	ir.actions.report	current	list,form	kanban	\N	\N
7	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Window Actions"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	14	\N	{}	ir.actions.act_window	current	list,form	kanban	\N	\N
8	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Client Actions"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	15	\N	80	\N	\N	{}	ir.actions.client	current	list,form	kanban	\N	\N
9	\N	1	1	ir.actions.act_window	server-actions	action	list,form	{"en_US": "Server Actions"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	17	\N	80	18	\N	{'key':'server_action'}	ir.actions.server	current	list,form	kanban	\N	\N
10	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Embedded Actions"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	20	\N	80	\N	\N	{}	ir.embedded.actions	current	list,form	kanban	\N	\N
11	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Configuration Wizards"}	{"en_US": "<p>The configuration wizards are used to help you configure a new instance of Odoo. They are launched during the installation of new modules, but you can choose to restart some wizards manually from this menu.</p>"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	21	\N	80	\N	\N	{}	ir.actions.todo	current	list,form	kanban	\N	\N
13	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Assets"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	25	\N	80	\N	\N	{'search_default_active': 1}	ir.asset	current	list,form	kanban	\N	\N
14	\N	1	1	ir.actions.act_window	system-parameters	action	list,form	{"en_US": "System Parameters"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	ir.config_parameter	current	list,form	kanban	\N	\N
15	\N	1	1	ir.actions.act_window	crons	action	list,form	{"en_US": "Scheduled Actions"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	31	\N	80	\N	\N	{'search_default_all': 1}	ir.cron	current	list,form,calendar	kanban	\N	\N
16	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Scheduled Actions Triggers"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	ir.cron.trigger	current	list,form	kanban	\N	\N
17	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "User-defined Filters"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	ir.filters	current	list,form	kanban	\N	\N
18	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Outgoing Mail Servers"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	41	\N	80	42	\N	{}	ir.mail_server	current	list,form	kanban	\N	\N
19	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Create Menu"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{'model_id': active_id}	wizard.ir.model.menu.create	new	form	kanban	\N	\N
20	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Models"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	45	\N	80	\N	\N	{}	ir.model	current	list,form	kanban	\N	\N
21	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fields"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	48	\N	80	\N	\N	{}	ir.model.fields	current	list,form	kanban	\N	\N
22	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fields Selection"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	51	\N	80	\N	\N	{}	ir.model.fields.selection	current	list,form	kanban	\N	\N
23	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "External Identifiers"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	54	\N	80	\N	\N	{}	ir.model.data	current	list,form	kanban	\N	\N
24	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Model Constraints"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	57	\N	80	58	\N	{}	ir.model.constraint	current	list,form	kanban	\N	\N
25	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "ManyToMany Relations"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	60	\N	80	\N	\N	{}	ir.model.relation	current	list,form	kanban	\N	\N
26	\N	1	1	ir.actions.act_window	access-rights	action	list,form	{"en_US": "Access Rights"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	62	\N	80	64	\N	{}	ir.model.access	current	list,form	kanban	\N	\N
27	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Attachments"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a new document\\n                </p>\\n                <p>\\n                    Also you will find here all the related documents and download it by clicking on any individual document.\\n                </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	67	\N	{}	ir.attachment	current	list,form	kanban	\N	\N
28	\N	1	1	ir.actions.act_window	record-rules	action	list,form	{"en_US": "Record Rules"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	69	\N	80	70	\N	{}	ir.rule	current	list,form	kanban	\N	\N
29	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Sequences"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	72	\N	80	\N	\N	{'active_test': False}	ir.sequence	current	list,form	kanban	\N	\N
30	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Menu Items"}	{"en_US": "<p>Manage and customize the items available and displayed in your Odoo system menu. You can delete an item by clicking on the box at the beginning of each line and then delete it through the button that appeared. Items can be assigned to specific groups in order to make them accessible to some users within the system.</p>"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	75	\N	80	76	\N	{'ir.ui.menu.full_list':True}	ir.ui.menu	current	list,form	kanban	\N	\N
31	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Views"}	{"en_US": "<p>Views allows you to personalize each view of Odoo. You can add new fields, move fields, rename them or delete the ones that you do not need.</p>"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	78	\N	80	\N	\N	{'search_default_active': 1}	ir.ui.view	current	list,form	kanban	\N	\N
32	16	1	1	ir.actions.act_window	\N	action	form,list	{"en_US": "Compare/Reset"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	reset.view.arch.wizard	new	form	kanban	\N	\N
33	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Customized Views"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">Create a customized view</p><p>Customized views are used when users reorganize the content of their dashboard views (via web client)</p>"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	ir.ui.view.custom	current	list,form	kanban	\N	\N
34	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "User-defined Defaults"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	86	\N	{}	ir.default	current	list,form	kanban	\N	\N
38	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Logging"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	90	\N	{}	ir.logging	current	list,form	kanban	\N	\N
39	\N	1	1	ir.actions.act_window	apps	action	list,form	{"en_US": "Apps"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No module found!\\n              </p><p>\\n                You should try other search criteria.\\n              </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	95	\N	{'search_default_app':1}	ir.module.module	current	kanban,list,form	kanban	\N	\N
43	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Module Update"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	base.module.update	new	form	kanban	\N	\N
44	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Add Languages"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	base.language.install	new	form	kanban	\N	\N
45	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Import Translation"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	base.language.import	new	form	kanban	\N	\N
46	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Apply Schedule Upgrade"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N
47	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Module Upgrade Install"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	105	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N
48	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Export Translation"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	base.language.export	new	form	kanban	\N	\N
49	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Deduplicate Contacts"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{'active_test': False}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N
50	88	1	1	ir.actions.act_window	\N	action	list	{"en_US": "Merge"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N
52	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Ir profile"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{'search_default_group_session': 1}	ir.profile	current	list,form	kanban	\N	\N
53	\N	1	1	ir.actions.act_window	companies	action	list,form	{"en_US": "Companies"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new company\\n              </p><p>\\n                Create and manage the companies that will be managed by Odoo from here. Shops or subsidiaries can be created and maintained from here.\\n              </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	[('parent_id', '=', False)]	{}	res.company	current	list,kanban,form	kanban	\N	\N
54	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Languages"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	120	\N	{'active_test': False}	res.lang	current	list,form	kanban	\N	\N
55	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Contact Titles"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Title\\n                </p><p>\\n                    Manage Contact Titles as well as their abbreviations (e.g. \\"Mr.\\", \\"Mrs.\\", etc).\\n                </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	[]	{}	res.partner.title	current	list,form	kanban	\N	\N
56	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact in your address book\\n              </p><p>\\n                Odoo helps you track all activities related to your contacts.\\n              </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	128	\N	{'res_partner_search_mode': 'customer'}	res.partner	current	kanban,list,form	kanban	\N	\N
57	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new customer in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a customer.\\n              </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	[]	{'res_partner_search_mode': 'customer', 'default_is_company': True}	res.partner	current	kanban,list,form	kanban	\N	t
58	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Vendors"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new vendor in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a vendor.\\n              </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	[]	{'res_partner_search_mode': 'supplier', 'default_is_company': True}	res.partner	current	kanban,list,form	kanban	\N	t
59	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Contact Tags"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact Tag\\n              </p><p>\\n                Assign tags to your contacts to organize, filter and track them.\\n              </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	132	\N	{}	res.partner.category	current	list,form	kanban	\N	\N
60	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Industries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create an Industry\\n              </p><p>\\n                Specify industries to classify your contacts and draw up reports.\\n              </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	135	\N	{}	res.partner.industry	current	list,form	kanban	\N	\N
61	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Banks"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank\\n              </p><p>\\n                Banks are the financial institutions at which you and your contacts have their accounts.\\n              </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	138	\N	{}	res.bank	current	list,form	kanban	\N	\N
62	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Bank Accounts"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank Account\\n              </p><p>\\n                From here you can manage all bank accounts linked to you and your contacts.\\n              </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	res.partner.bank	current	list,form	kanban	\N	\N
63	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Countries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No Country Found!\\n                </p><p>\\n                    Manage the list of countries that can be set on your contacts.\\n                </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	res.country	current	list,form	kanban	\N	\N
64	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Country Group"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Country Group\\n                </p><p>\\n                    Use groups to organize countries that are frequently selected together (e.g. \\"LATAM\\", \\"BeNeLux\\", \\"ASEAN\\").\\n                </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	res.country.group	current	list,form	kanban	\N	\N
65	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fed. States"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a State\\n                </p><p>\\n                    Federal States belong to countries and are part of your contacts' addresses.\\n                </p>\\n            "}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	147	\N	80	\N	\N	{}	res.country.state	current	list,form	kanban	\N	\N
66	94	1	1	ir.actions.act_window	\N	action	form	{"en_US": "Show Currency Rates"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	151	\N	80	\N	[('currency_id','=', active_id)]	{'default_currency_id': active_id}	res.currency.rate	current	list,form	kanban	\N	\N
67	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Currencies"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	153	\N	{'active_test': False}	res.currency	current	list,kanban,form	kanban	\N	\N
68	99	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Change Password"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	change.password.wizard	new	form	kanban	\N	\N
69	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Groups"}	{"en_US": "<p>A group is a set of functional areas that will be assigned to the user in order to give them access and rights to specific applications and tasks in the system. You can create custom groups or edit the ones existing by default in order to customize the view of the menu that users will be able to see. Whether they can have a read, write, create and delete access right can be managed from here.</p>"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{'search_default_filter_no_share': 1, 'ir.ui.menu.full_list': 1}	res.groups	current	list,form	kanban	\N	\N
70	\N	1	1	ir.actions.act_window	users	action	list,form	{"en_US": "Users"}	{"en_US": "<p>Create and manage users that will connect to the system. Users can be deactivated should there be a period of time during which they will/should not connect to the system. You can assign them groups in order to give them specific access to the applications they need to use in the system.</p>"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	164	\N	80	166	\N	{'search_default_filter_no_share': 1, 'show_user_group_warning': True}	res.users	current	list,kanban,form	kanban	\N	\N
71	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "API Key: description input wizard"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	res.users.apikeys.description	new	form	kanban	\N	\N
72	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Change My Preferences"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	res.users	new	form	kanban	\N	\N
73	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "API Keys Listing"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	171	\N	80	\N	\N	{}	res.users.apikeys	current	list	kanban	\N	\N
74	\N	1	1	ir.actions.act_window	user-device	action	list,form	{"en_US": "User Devices"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	res.device	current	list,kanban,form	kanban	\N	\N
75	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Settings"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	res.config.settings	inline	form	kanban	\N	\N
76	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Paper Format General Configuration"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	report.paperformat	current	list,form	kanban	\N	\N
77	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Reports"}	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N	80	\N	\N	{}	ir.actions.report	current	list,form	kanban	\N	\N
81	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Configure your document layout"}	\N	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651	215	\N	80	\N	\N	{"dialog_size": "extra-large"}	base.document.layout	new	form	kanban	\N	\N
84	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Import Module"}	\N	2026-01-22 18:40:07.014423	2026-01-22 18:40:07.014423	\N	\N	80	\N	\N	{}	base.import.module	new	form	kanban	\N	\N
85	\N	1	1	ir.actions.act_window	settings	action	list,form	{"en_US": "Settings"}	\N	2026-01-22 18:40:07.336495	2026-01-22 18:40:07.336495	\N	\N	80	\N	\N	{'module' : 'general_settings', 'bin_size': False}	res.config.settings	inline	form	kanban	\N	\N
86	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Tours"}	\N	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702	231	\N	80	232	\N	{}	web_tour.tour	current	list,form	kanban	\N	\N
88	\N	1	1	ir.actions.act_window	iap-accounts	action	list,form	{"en_US": "IAP Account"}	\N	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693	\N	\N	80	\N	\N	{}	iap.account	current	list,form	kanban	\N	\N
\.


--
-- Data for Name: ir_act_window_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_group_rel (act_id, gid) FROM stdin;
73	4
\.


--
-- Data for Name: ir_act_window_view; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_view (id, sequence, view_id, act_window_id, create_uid, write_uid, view_mode, multi, create_date, write_date) FROM stdin;
1	1	12	7	1	1	list	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
2	2	13	7	1	1	form	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
3	0	129	56	1	1	kanban	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
4	2	126	56	1	1	form	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
5	1	123	56	1	1	list	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
6	1	129	57	1	1	kanban	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
7	2	123	57	1	1	list	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
8	3	126	57	1	1	form	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
9	1	129	58	1	1	kanban	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
10	2	123	58	1	1	list	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
11	3	126	58	1	1	form	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
12	10	164	70	1	1	list	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
13	20	163	70	1	1	form	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
14	10	170	72	1	1	form	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
\.


--
-- Data for Name: ir_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_actions_todo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions_todo (id, action_id, sequence, create_uid, write_uid, state, name, create_date, write_date) FROM stdin;
1	2	100	1	1	done	Open Menu	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
2	51	1	1	1	done	Demo Failure Notification	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
\.


--
-- Data for Name: ir_asset; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_asset (id, sequence, create_uid, write_uid, name, bundle, directive, path, target, active, create_date, write_date) FROM stdin;
1	16	1	1	13 0 color system support primary variables SCSS	web._assets_primary_variables	append	web_editor/static/src/scss/13_0_color_system_support_primary_variables.scss	\N	f	2026-01-22 18:40:08.923404	2026-01-22 18:40:08.923404
\.


--
-- Data for Name: ir_attachment; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_attachment (id, res_id, company_id, file_size, create_uid, write_uid, name, res_model, res_field, type, url, access_token, store_fname, checksum, mimetype, description, index_content, public, create_date, write_date, db_datas, original_id) FROM stdin;
1	3	1	9152	1	1	flag_image	res.lang	flag_image	binary	\N	\N	44/44d1661b24fa9f688091c8256535434b60aafba7	44d1661b24fa9f688091c8256535434b60aafba7	image/png	\N	image	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N
2	65	1	15497	1	1	flag_image	res.lang	flag_image	binary	\N	\N	62/627090759f9a66678c28c1bc3c3039b37f40f66e	627090759f9a66678c28c1bc3c3039b37f40f66e	image/png	\N	image	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N
3	11	1	192	1	1	flag_image	res.lang	flag_image	binary	\N	\N	05/055ffc5cce56e142234ffc466012dff7edc2c7e7	055ffc5cce56e142234ffc466012dff7edc2c7e7	image/png	\N	image	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N
4	1	1	11445	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N
5	1	1	11445	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N
6	1	1	11445	1	1	image_512	res.partner	image_512	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N
7	1	1	12556	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0ce8c97df3ec768af51696ede284aac75b0eec18	0ce8c97df3ec768af51696ede284aac75b0eec18	image/png	\N	image	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N
8	1	1	5254	1	1	image_128	res.partner	image_128	binary	\N	\N	60/60a2a24a2fcfd3b3045bbaa75c5d68815df9d541	60a2a24a2fcfd3b3045bbaa75c5d68815df9d541	image/png	\N	image	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N
9	1	1	2063	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	b7/b73a9deb85def8a1a00e4d545c4f79747d78f487	b73a9deb85def8a1a00e4d545c4f79747d78f487	image/png	\N	image	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N
10	15	1	2282	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	3d/3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	image/png	\N	image	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N
11	16	1	4667	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	1c/1c2a8239bc7e06429116c40bc1d1334c621ca379	1c2a8239bc7e06429116c40bc1d1334c621ca379	image/png	\N	image	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	\N
12	\N	1	\N	1	1	placeholder.png	\N	\N	url	/web/static/img/placeholder.png	\N	\N	\N	image/png	\N	\N	t	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651	\N	\N
13	\N	1	854	1	1	res.company.scss	\N	\N	binary	web/static/asset_styles_company_report.scss	\N	54/542922906caac0fe5d253e2c7d913758eb0a7f6e	542922906caac0fe5d253e2c7d913758eb0a7f6e	text/scss	\N	                // Simplified color-contrast function to replicate bootstrap in report preview.\n                @function preview-color-contrast($background) {\n                    @if (lightness($background) > 50) {\n                        @return black;\n                    } @else {\n                        @return white;\n                    }\n                }\n                .o_company_1_layout {\n                    font-family: Lato;\n                    h2 {\n                        color: #212529;\n                    }\n                    #informations strong {\n                        color: #212529;\n                    }\n                    .o_total strong {\n                        color: #212529;\n                    }\n                    .o_company_tagline {\n                        color: #212529\n                    }\n            }	\N	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651	\N	\N
\.


--
-- Data for Name: ir_config_parameter; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_config_parameter (id, create_uid, write_uid, key, value, create_date, write_date) FROM stdin;
4	1	1	web.base.url	http://localhost:8069	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
5	1	1	base.login_cooldown_after	10	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
6	1	1	base.login_cooldown_duration	60	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
7	1	1	base.template_portal_user_id	5	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
8	1	1	base.default_max_email_size	10	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
1	1	1	database.secret	acb928a2-dca7-4e06-a093-e1a06847efe2	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
2	1	1	database.uuid	c2173b33-f7c1-11f0-8ae9-b5a057563a20	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
3	1	1	database.create_date	2026-01-22 18:40:00	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
9	1	1	base_setup.show_effect	True	2026-01-22 18:40:07.336495	2026-01-22 18:40:07.336495
10	1	1	base_setup.default_user_rights	True	2026-01-22 18:40:07.336495	2026-01-22 18:40:07.336495
\.


--
-- Data for Name: ir_cron; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron (id, ir_actions_server_id, user_id, interval_number, priority, failure_count, create_uid, write_uid, cron_name, interval_type, active, nextcall, lastcall, first_failure_date, create_date, write_date) FROM stdin;
1	35	1	1	3	0	1	1	Base: Auto-vacuum internal data	days	t	2026-01-22 18:39:58	\N	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
2	36	1	1	8	0	1	1	Base: Portal Users Deletion	days	t	2026-01-22 18:39:58	\N	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
\.


--
-- Data for Name: ir_cron_progress; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron_progress (id, cron_id, remaining, done, timed_out_counter, create_uid, write_uid, deactivate, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_cron_trigger; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron_trigger (id, cron_id, create_uid, write_uid, call_at, create_date, write_date) FROM stdin;
1	1	1	1	2026-01-22 18:41:10.746482	2026-01-22 18:40:10.566031	2026-01-22 18:40:10.566031
\.


--
-- Data for Name: ir_default; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_default (id, field_id, user_id, company_id, create_uid, write_uid, condition, json_value, create_date, write_date) FROM stdin;
1	909	\N	\N	1	1	\N	"en_US"	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
\.


--
-- Data for Name: ir_demo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure (id, module_id, wizard_id, create_uid, write_uid, error, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_embedded_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_embedded_actions (id, sequence, parent_action_id, parent_res_id, action_id, user_id, create_uid, write_uid, parent_res_model, python_method, default_view_mode, domain, context, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_embedded_actions_res_groups_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_embedded_actions_res_groups_rel (ir_embedded_actions_id, res_groups_id) FROM stdin;
\.


--
-- Data for Name: ir_exports; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports (id, create_uid, write_uid, name, resource, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports_line (id, export_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_filters; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_filters (id, user_id, action_id, embedded_action_id, embedded_parent_res_id, create_uid, write_uid, name, sort, model_id, domain, context, is_default, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_logging; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_logging (id, create_uid, write_uid, name, type, dbname, level, path, func, line, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_mail_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_mail_server (id, smtp_port, sequence, create_uid, write_uid, name, from_filter, smtp_host, smtp_authentication, smtp_user, smtp_pass, smtp_encryption, smtp_debug, active, create_date, write_date, max_email_size, smtp_ssl_certificate, smtp_ssl_private_key) FROM stdin;
\.


--
-- Data for Name: ir_model; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model (id, create_uid, write_uid, model, "order", state, name, info, transient, create_date, write_date) FROM stdin;
1	\N	\N	base	id	base	{"en_US": "Base"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
2	\N	\N	_unknown	id	base	{"en_US": "Unknown"}	\n    Abstract model used as a substitute for relational fields with an unknown\n    comodel.\n    	f	\N	\N
3	\N	\N	ir.model	model	base	{"en_US": "Models"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
4	\N	\N	ir.model.fields	name	base	{"en_US": "Fields"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
5	\N	\N	ir.model.inherit	id	base	{"en_US": "Model Inheritance Tree"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
6	\N	\N	ir.model.fields.selection	sequence, id	base	{"en_US": "Fields Selection"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
7	\N	\N	ir.model.constraint	id	base	{"en_US": "Model Constraint"}	\n    This model tracks PostgreSQL foreign keys and constraints used by Odoo\n    models.\n    	f	\N	\N
8	\N	\N	ir.model.relation	id	base	{"en_US": "Relation Model"}	\n    This model tracks PostgreSQL tables used to implement Odoo many2many\n    relations.\n    	f	\N	\N
9	\N	\N	ir.model.access	model_id,group_id,name,id	base	{"en_US": "Model Access"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
10	\N	\N	ir.model.data	module, model, name	base	{"en_US": "Model Data"}	Holds external identifier keys for records in the database.\n       This has two main uses:\n\n           * allows easy data integration with third-party systems,\n             making import/export/sync of data possible, as records\n             can be uniquely identified across multiple systems\n           * allows tracking the origin of data installed by Odoo\n             modules themselves, thus making it possible to later\n             update them seamlessly.\n    	f	\N	\N
11	\N	\N	wizard.ir.model.menu.create	id	base	{"en_US": "Create Menu Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
12	\N	\N	ir.sequence	name	base	{"en_US": "Sequence"}	 Sequence model.\n\n    The sequence model allows to define and use so-called sequence objects.\n    Such objects are used to generate unique identifiers in a transaction-safe\n    way.\n\n    	f	\N	\N
13	\N	\N	ir.sequence.date_range	id	base	{"en_US": "Sequence Date Range"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
14	\N	\N	ir.ui.menu	sequence,id	base	{"en_US": "Menu"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
15	\N	\N	ir.ui.view.custom	create_date desc	base	{"en_US": "Custom View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
16	\N	\N	ir.ui.view	priority,name,id	base	{"en_US": "View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
17	\N	\N	reset.view.arch.wizard	id	base	{"en_US": "Reset View Architecture Wizard"}	 A wizard to compare and reset views architecture. 	t	\N	\N
18	\N	\N	ir.asset	sequence, id	base	{"en_US": "Asset"}	This model contributes to two things:\n\n        1. It provides a function returning a list of all file paths declared\n        in a given list of addons (see _get_addon_paths);\n\n        2. It allows to create 'ir.asset' records to add additional directives\n        to certain bundles.\n    	f	\N	\N
19	\N	\N	ir.actions.actions	name	base	{"en_US": "Actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
20	\N	\N	ir.actions.act_window	name	base	{"en_US": "Action Window"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
21	\N	\N	ir.actions.act_window.view	sequence,id	base	{"en_US": "Action Window View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
22	\N	\N	ir.actions.act_window_close	name	base	{"en_US": "Action Window Close"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
23	\N	\N	ir.actions.act_url	name	base	{"en_US": "Action URL"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
24	\N	\N	ir.actions.server	sequence,name	base	{"en_US": "Server Actions"}	 Server actions model. Server action work on a base model and offer various\n    type of actions that can be executed automatically, for example using base\n    action rules, of manually, by adding the action in the 'More' contextual\n    menu.\n\n    Since Odoo 8.0 a button 'Create Menu Action' button is available on the\n    action form view. It creates an entry in the More menu of the base model.\n    This allows to create server actions and run them in mass mode easily through\n    the interface.\n\n    The available actions are :\n\n    - 'Execute Python Code': a block of python code that will be executed\n    - 'Create a new Record': create a new record with new values\n    - 'Write on a Record': update the values of a record\n    - 'Execute several actions': define an action that triggers several other\n      server actions\n    	f	\N	\N
25	\N	\N	ir.actions.todo	sequence, id	base	{"en_US": "Configuration Wizards"}	\n    Configuration Wizards\n    	f	\N	\N
26	\N	\N	ir.actions.client	name	base	{"en_US": "Client Action"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
27	\N	\N	ir.embedded.actions	sequence, id	base	{"en_US": "Embedded Actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
28	\N	\N	ir.actions.report	name, id	base	{"en_US": "Report Action"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
29	\N	\N	ir.attachment	id desc	base	{"en_US": "Attachment"}	Attachments are used to link binary files or url to any openerp document.\n\n    External attachment storage\n    ---------------------------\n\n    The computed field ``datas`` is implemented using ``_file_read``,\n    ``_file_write`` and ``_file_delete``, which can be overridden to implement\n    other storage engines. Such methods should check for other location pseudo\n    uri (example: hdfs://hadoopserver).\n\n    The default implementation is the file:dirname location that stores files\n    on the local filesystem using name based on their sha1 hash\n    	f	\N	\N
30	\N	\N	ir.binary	id	base	{"en_US": "File streaming helper model for controllers"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
31	\N	\N	ir.cron	cron_name	base	{"en_US": "Scheduled Actions"}	 Model describing cron jobs (also called actions or tasks).\n    	f	\N	\N
32	\N	\N	ir.cron.trigger	id	base	{"en_US": "Triggered actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
33	\N	\N	ir.cron.progress	id	base	{"en_US": "Progress of Scheduled Actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
34	\N	\N	ir.filters	model_id, name, id desc	base	{"en_US": "Filters"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
35	\N	\N	ir.default	id	base	{"en_US": "Default Values"}	 User-defined default values for fields. 	f	\N	\N
36	\N	\N	ir.exports	name	base	{"en_US": "Exports"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
37	\N	\N	ir.exports.line	id	base	{"en_US": "Exports Line"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
38	\N	\N	ir.rule	model_id DESC,id	base	{"en_US": "Record Rule"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
39	\N	\N	ir.config_parameter	key	base	{"en_US": "System Parameter"}	Per-database storage of configuration key-value pairs.	f	\N	\N
40	\N	\N	ir.autovacuum	id	base	{"en_US": "Automatic Vacuum"}	 Helper model to the ``@api.autovacuum`` method decorator. 	f	\N	\N
41	\N	\N	ir.mail_server	sequence, id	base	{"en_US": "Mail Server"}	Represents an SMTP server, able to send outgoing emails, with SSL and TLS capabilities.	f	\N	\N
42	\N	\N	ir.fields.converter	id	base	{"en_US": "Fields Converter"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
44	\N	\N	ir.qweb.field	id	base	{"en_US": "Qweb Field"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
43	\N	\N	ir.qweb	id	base	{"en_US": "Qweb"}	 IrQWeb object for rendering editor stuff\n    	f	\N	\N
45	\N	\N	ir.qweb.field.integer	id	base	{"en_US": "Qweb Field Integer"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
46	\N	\N	ir.qweb.field.float	id	base	{"en_US": "Qweb Field Float"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
47	\N	\N	ir.qweb.field.date	id	base	{"en_US": "Qweb Field Date"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
48	\N	\N	ir.qweb.field.datetime	id	base	{"en_US": "Qweb Field Datetime"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
49	\N	\N	ir.qweb.field.text	id	base	{"en_US": "Qweb Field Text"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
50	\N	\N	ir.qweb.field.selection	id	base	{"en_US": "Qweb Field Selection"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
51	\N	\N	ir.qweb.field.many2one	id	base	{"en_US": "Qweb Field Many to One"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
52	\N	\N	ir.qweb.field.many2many	id	base	{"en_US": "Qweb field many2many"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
53	\N	\N	ir.qweb.field.one2many	id	base	{"en_US": "Qweb field one2many"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
54	\N	\N	ir.qweb.field.html	id	base	{"en_US": "Qweb Field HTML"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
56	\N	\N	ir.qweb.field.image_url	id	base	{"en_US": "Qweb Field Image"}	 ``image_url`` widget rendering, inserts an image tag in the\n    document.\n    	f	\N	\N
57	\N	\N	ir.qweb.field.monetary	id	base	{"en_US": "Qweb Field Monetary"}	 ``monetary`` converter, has a mandatory option\n    ``display_currency`` only if field is not of type Monetary.\n    Otherwise, if we are in presence of a monetary field, the field definition must\n    have a currency_field attribute set.\n\n    The currency is used for formatting *and rounding* of the float value. It\n    is assumed that the linked res_currency has a non-empty rounding value and\n    res.currency's ``round`` method is used to perform rounding.\n\n    .. note:: the monetary converter internally adds the qweb context to its\n              options mapping, so that the context is available to callees.\n              It's set under the ``_values`` key.\n    	f	\N	\N
58	\N	\N	ir.qweb.field.float_time	id	base	{"en_US": "Qweb Field Float Time"}	 ``float_time`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "01:30").\n\n    Can be used on any numerical field.\n    	f	\N	\N
59	\N	\N	ir.qweb.field.time	id	base	{"en_US": "QWeb Field Time"}	 ``time`` converter, to display integer or fractional value as\n    human-readable time (e.g. 1.5 as "1:30 AM"). The unit of this value\n    is in hours.\n\n    Can be used on any numerical field between: 0 <= value < 24\n    	f	\N	\N
60	\N	\N	ir.qweb.field.duration	id	base	{"en_US": "Qweb Field Duration"}	 ``duration`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "1 hour 30 minutes").\n\n    Can be used on any numerical field.\n\n    Has an option ``unit`` which can be one of ``second``, ``minute``,\n    ``hour``, ``day``, ``week`` or ``year``, used to interpret the numerical\n    field value before converting it. By default use ``second``.\n\n    Has an option ``round``. By default use ``second``.\n\n    Has an option ``digital`` to display 01:00 instead of 1 hour\n\n    Sub-second values will be ignored.\n    	f	\N	\N
55	\N	\N	ir.qweb.field.image	id	base	{"en_US": "Qweb Field Image"}	\n    Widget options:\n\n    ``class``\n        set as attribute on the generated <img> tag\n    	f	\N	\N
61	\N	\N	ir.qweb.field.relative	id	base	{"en_US": "Qweb Field Relative"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
62	\N	\N	ir.qweb.field.barcode	id	base	{"en_US": "Qweb Field Barcode"}	 ``barcode`` widget rendering, inserts a data:uri-using image tag in the\n    document. May be overridden by e.g. the website module to generate links\n    instead.\n    	f	\N	\N
63	\N	\N	ir.qweb.field.contact	id	base	{"en_US": "Qweb Field Contact"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
64	\N	\N	ir.qweb.field.qweb	id	base	{"en_US": "Qweb Field qweb"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N
65	\N	\N	ir.http	id	base	{"en_US": "HTTP Routing"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
66	\N	\N	ir.logging	id DESC	base	{"en_US": "Logging"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
67	\N	\N	ir.module.category	name	base	{"en_US": "Application"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
68	\N	\N	ir.module.module	application desc,sequence,name	base	{"en_US": "Module"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
69	\N	\N	ir.module.module.dependency	id	base	{"en_US": "Module dependency"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
70	\N	\N	ir.module.module.exclusion	id	base	{"en_US": "Module exclusion"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
71	\N	\N	ir.demo	id	base	{"en_US": "Demo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
72	\N	\N	ir.demo_failure	id	base	{"en_US": "Demo failure"}	 Stores modules for which we could not install demo data\n    	t	\N	\N
73	\N	\N	ir.demo_failure.wizard	id	base	{"en_US": "Demo Failure wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
74	\N	\N	report.layout	sequence	base	{"en_US": "Report Layout"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
75	\N	\N	report.paperformat	id	base	{"en_US": "Paper Format Config"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
76	\N	\N	ir.profile	session desc, id desc	base	{"en_US": "Profiling results"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
77	\N	\N	base.enable.profiling.wizard	id	base	{"en_US": "Enable profiling for some time"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
78	\N	\N	image.mixin	id	base	{"en_US": "Image Mixin"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
79	\N	\N	avatar.mixin	id	base	{"en_US": "Avatar Mixin"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
80	\N	\N	res.country	name	base	{"en_US": "Country"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
81	\N	\N	res.country.group	id	base	{"en_US": "Country Group"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
82	\N	\N	res.country.state	code	base	{"en_US": "Country state"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
83	\N	\N	res.lang	active desc,name	base	{"en_US": "Languages"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
84	\N	\N	format.vat.label.mixin	id	base	{"en_US": "Country Specific VAT Label"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
85	\N	\N	format.address.mixin	id	base	{"en_US": "Address Format"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
86	\N	\N	res.partner.category	name	base	{"en_US": "Partner Tags"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
87	\N	\N	res.partner.title	name	base	{"en_US": "Partner Title"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
88	\N	\N	res.partner	complete_name ASC, id DESC	base	{"en_US": "Contact"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
89	\N	\N	res.partner.industry	name	base	{"en_US": "Industry"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
90	\N	\N	res.bank	name	base	{"en_US": "Bank"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
91	\N	\N	res.partner.bank	sequence, id	base	{"en_US": "Bank Accounts"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
92	\N	\N	res.config	id	base	{"en_US": "Config"}	 Base classes for new-style configuration items\n\n    Configuration items should inherit from this class, implement\n    the execute method (and optionally the cancel one) and have\n    their view inherit from the related res_config_view_base view.\n    	t	\N	\N
93	\N	\N	res.config.settings	id	base	{"en_US": "Config Settings"}	 Base configuration wizard for application settings.  It provides support for setting\n        default values, assigning groups to employee users, and installing modules.\n        To make such a 'settings' wizard, define a model like::\n\n            class MyConfigWizard(models.TransientModel):\n                _name = 'my.settings'\n                _inherit = 'res.config.settings'\n\n                default_foo = fields.type(..., default_model='my.model'),\n                group_bar = fields.Boolean(..., group='base.group_user', implied_group='my.group'),\n                module_baz = fields.Boolean(...),\n                config_qux = fields.Char(..., config_parameter='my.parameter')\n                other_field = fields.type(...),\n\n        The method ``execute`` provides some support based on a naming convention:\n\n        *   For a field like 'default_XXX', ``execute`` sets the (global) default value of\n            the field 'XXX' in the model named by ``default_model`` to the field's value.\n\n        *   For a boolean field like 'group_XXX', ``execute`` adds/removes 'implied_group'\n            to/from the implied groups of 'group', depending on the field's value.\n            By default 'group' is the group Employee.  Groups are given by their xml id.\n            The attribute 'group' may contain several xml ids, separated by commas.\n\n        *   For a selection field like 'group_XXX' composed of 2 string values ('0' and '1'),\n            ``execute`` adds/removes 'implied_group' to/from the implied groups of 'group',\n            depending on the field's value.\n            By default 'group' is the group Employee.  Groups are given by their xml id.\n            The attribute 'group' may contain several xml ids, separated by commas.\n\n        *   For a boolean field like 'module_XXX', ``execute`` triggers the immediate\n            installation of the module named 'XXX' if the field has value ``True``.\n\n        *   For a selection field like 'module_XXX' composed of 2 string values ('0' and '1'),\n            ``execute`` triggers the immediate installation of the module named 'XXX'\n            if the field has the value ``'1'``.\n\n        *   For a field with no specific prefix BUT an attribute 'config_parameter',\n            ``execute``` will save its value in an ir.config.parameter (global setting for the\n            database).\n\n        *   For the other fields, the method ``execute`` invokes `set_values`.\n            Override it to implement the effect of those fields.\n\n        The method ``default_get`` retrieves values that reflect the current status of the\n        fields like 'default_XXX', 'group_XXX', 'module_XXX' and config_XXX.\n        It also invokes all methods with a name that starts with 'get_default_';\n        such methods can be defined to provide current values for other fields.\n    	t	\N	\N
94	\N	\N	res.currency	active desc, name	base	{"en_US": "Currency"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
95	\N	\N	res.currency.rate	name desc	base	{"en_US": "Currency Rate"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
96	\N	\N	res.company	sequence, name	base	{"en_US": "Companies"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
97	\N	\N	res.groups	name	base	{"en_US": "Access Groups"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
98	\N	\N	res.users.log	id desc	base	{"en_US": "Users Log"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
99	\N	\N	res.users	name, login	base	{"en_US": "User"}	 User class. A res.users record models an OpenERP user and is different\n        from an employee.\n\n        res.users class now inherits from res.partner. The partner model is\n        used to store the data related to the partner: lang, name, address,\n        avatar, ... The user model is now dedicated to technical data.\n    	f	\N	\N
100	\N	\N	res.users.identitycheck	id	base	{"en_US": "Password Check Wizard"}	 Wizard used to re-check the user's credentials (password) and eventually\n    revoke access to his account to every device he has an active session on.\n\n    Might be useful before the more security-sensitive operations, users might be\n    leaving their computer unlocked & unattended. Re-checking credentials mitigates\n    some of the risk of a third party using such an unattended device to manipulate\n    the account.\n    	t	\N	\N
101	\N	\N	change.password.wizard	id	base	{"en_US": "Change Password Wizard"}	 A wizard to manage the change of users' passwords. 	t	\N	\N
102	\N	\N	change.password.user	id	base	{"en_US": "User, Change Password Wizard"}	 A model to configure users in the change password wizard. 	t	\N	\N
103	\N	\N	change.password.own	id	base	{"en_US": "User, change own password wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
104	\N	\N	res.users.apikeys	id	base	{"en_US": "Users API Keys"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
105	\N	\N	res.users.apikeys.description	id	base	{"en_US": "API Key Description"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
106	\N	\N	res.users.apikeys.show	id	base	{"en_US": "Show API Key"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
107	\N	\N	res.users.settings	id	base	{"en_US": "User Settings"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
108	\N	\N	res.users.deletion	id	base	{"en_US": "Users Deletion Request"}	User deletion requests.\n\n    Those requests are logged in a different model to keep a trace of this action and the\n    deletion is done in a CRON. Indeed, removing a user can be a heavy operation on\n    large database (because of create_uid, write_uid on each model, which are not always\n    indexed). This model just remove the users added in the deletion queue, remaining code\n    must deal with other consideration (archiving, blacklist email...).\n    	f	\N	\N
109	\N	\N	res.device.log	id	base	{"en_US": "Device Log"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
110	\N	\N	res.device	last_activity desc	base	{"en_US": "Devices"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
111	\N	\N	decimal.precision	id	base	{"en_US": "Decimal Precision"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
112	\N	\N	report.base.report_irmodulereference	id	base	{"en_US": "Module Reference Report (base)"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
113	\N	\N	base.module.update	id	base	{"en_US": "Update Module"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
114	\N	\N	base.language.install	id	base	{"en_US": "Install Language"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
115	\N	\N	base.language.import	id	base	{"en_US": "Language Import"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
116	\N	\N	base.module.upgrade	id	base	{"en_US": "Upgrade Module"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
117	\N	\N	base.module.uninstall	id	base	{"en_US": "Module Uninstall"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
118	\N	\N	base.language.export	id	base	{"en_US": "Language Export"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
119	\N	\N	base.partner.merge.line	min_id asc	base	{"en_US": "Merge Partner Line"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
120	\N	\N	base.partner.merge.automatic.wizard	id	base	{"en_US": "Merge Partner Wizard"}	\n        The idea behind this wizard is to create a list of potential partners to\n        merge. We use two objects, the first one is the wizard for the end-user.\n        And the second will contain the partner list to merge.\n    	t	\N	\N
122	\N	\N	base.document.layout	id	base	{"en_US": "Company Document Layout"}	\n    Customise the company document layout and display a live preview\n    	t	\N	\N
123	\N	\N	auth_totp.device	id	base	{"en_US": "Authentication Device"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
124	\N	\N	auth_totp.wizard	id	base	{"en_US": "2-Factor Setup Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N
125	\N	\N	base_import.mapping	id	base	{"en_US": "Base Import Mapping"}	 mapping of previous column:field selections\n\n    This is useful when repeatedly importing from a third-party\n    system: column names generated by the external system may\n    not match Odoo's field names or labels. This model is used\n    to save the mapping between column names and fields so that\n    next time a user imports from the same third-party systems\n    we can automatically match the columns to the correct field\n    without them having to re-enter the mapping every single\n    time.\n    	f	\N	\N
126	\N	\N	base_import.import	id	base	{"en_US": "Base Import"}	\n    This model is used to prepare the loading of data coming from a user file.\n\n    Here is the process that is followed:\n\n    #. The user selects a file to import.\n    #. File parsing and mapping suggestion (see "parse_preview" method)\n\n       #. Extract the current model's importable fields tree (see :meth:`get_fields_tree`).\n       #. Read the file (see :meth:`_read_file`) and extract header names and file\n          length (used for batch import).\n       #. Extract headers types from the data preview (10 first line of the file)\n          (see :meth:`_extract_headers_types`).\n       #. Try to find for each header a field to map with (see :meth:`_get_mapping_suggestions`)\n\n          - First check the previously saved mappings between the header name\n            and one of the model's fields.\n          - If no mapping found, try an exact match comparison using fields\n            technical names, labels and user language translated labels.\n          - If nothing found, try a fuzzy match using word distance between\n            header name and fields tachnical names, labels and user language\n            translated labels. Keep only the closest match.\n\n       #. Prepare examples for each columns using the first non null value from each column.\n       #. Send the info back to the UI where the user can modify the suggested mapping.\n    #. Execute the import: There are two import mode with uses the same process. (see :meth:`execute_import`)\n\n       #. Test import: Try to import but rollback the transaction. This allows\n          the check errors during the import process and allow the user to\n          choose import options for the different encountered errors.\n       #. Real import: Try to import the file using the configured mapping and\n          the eventual "error mapping options". If import encounters blocking\n          errors, the transaction is rollbacked and the user is allowed to\n          choose import options for the different errors.\n\n          - Get file data and fields to import into (see :meth:`_convert_import_data`).\n          - Parse date, float and binary data (see :meth:`_parse_import_data`).\n          - Handle multiple mapping -> concatenate char/text/many2many columns\n            mapped on the same field (see :meth:`_handle_multi_mapping`).\n          - Handle fallback values for boolean and selection fields, in case\n            input data does not match any allowed values (see :meth:`_handle_fallback_values`).\n          - Load data (see ir.model "load" method).\n          - Rollback transaction if test mode or if encountered error.\n          - Save mapping if any import is successful to ease later mapping suggestions.\n          - Return import result to the UI (success or errors if any).\n    	t	\N	\N
127	\N	\N	base.import.module	id	base	{"en_US": "Import Module"}	 Import Module 	t	\N	\N
128	\N	\N	kpi.provider	id	base	{"en_US": "KPI Provider"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
129	\N	\N	bus.bus	id	base	{"en_US": "Communication Bus"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
130	\N	\N	bus.listener.mixin	id	base	{"en_US": "Can send messages via bus.bus"}	Allow sending messages related to the current model via as a bus.bus channel.\n\n    The model needs to be allowed as a valid channel for the bus in `_build_bus_channel_list`.\n    	f	\N	\N
131	\N	\N	bus.presence	id	base	{"en_US": "User Presence"}	 User Presence\n        Its status is 'online', 'away' or 'offline'. This model should be a one2one, but is not\n        attached to res_users to avoid database concurrence errors. Since the 'update_presence' method is executed\n        at each poll, if the user have multiple opened tabs, concurrence errors can happend, but are 'muted-logged'.\n    	f	\N	\N
132	\N	\N	ir.websocket	id	base	{"en_US": "websocket message handling"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
133	\N	\N	web_tour.tour	sequence, name, id	base	{"en_US": "Tours"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
134	\N	\N	web_tour.tour.step	sequence, id	base	{"en_US": "Tour's step"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
135	\N	\N	iap.account	id	base	{"en_US": "IAP Account"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
136	\N	\N	iap.enrich.api	id	base	{"en_US": "IAP Lead Enrichment API"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
137	\N	\N	iap.service	id	base	{"en_US": "IAP Service"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
139	\N	\N	html.field.history.mixin	id	base	{"en_US": "Field html History"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
140	\N	\N	web_editor.assets	id	base	{"en_US": "Assets Utils"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N
141	\N	\N	web_editor.converter.test	id	base	{"en_US": "Web Editor Converter Test"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
142	\N	\N	web_editor.converter.test.sub	id	base	{"en_US": "Web Editor Converter Subtest"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N
\.


--
-- Data for Name: ir_model_access; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_access (id, model_id, group_id, create_uid, write_uid, name, active, perm_read, perm_write, perm_create, perm_unlink, create_date, write_date) FROM stdin;
1	111	4	1	1	decimal.precision configuration	t	t	t	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
2	29	1	1	1	ir_attachment group_user	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
3	29	\N	1	1	ir_attachment group_portal_public	t	f	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
4	31	4	1	1	ir_cron group_cron	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
5	33	4	1	1	ir_cron_progress group_cron	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
6	32	4	1	1	ir_cron_trigger group_cron	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
7	36	8	1	1	ir_exports group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
8	37	1	1	1	ir_exports_line group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
9	3	2	1	1	ir_model group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
10	7	2	1	1	ir_model_constraint group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
11	8	2	1	1	ir_model_relation group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
12	5	\N	1	1	ir_model_inherit nobody	t	f	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
13	9	2	1	1	ir_model_access_group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
14	10	2	1	1	ir_model_data group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
15	4	2	1	1	ir_model_fields group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
16	6	2	1	1	ir_model_fields_selection group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
17	3	1	1	1	ir_model_all	t	f	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
18	10	1	1	1	ir_model_data user	t	f	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
19	4	1	1	1	ir_model_fields all	t	f	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
20	6	1	1	1	ir_model_fields_selection all	t	f	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
21	67	2	1	1	ir_module_category group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
22	68	4	1	1	ir_module_module group_user	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
23	69	4	1	1	ir_module_module_dependency group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
24	70	4	1	1	ir_module_module_exclusion group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
25	38	2	1	1	ir_rule group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
26	12	1	1	1	ir_sequence group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
27	12	4	1	1	ir_sequence group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
28	13	1	1	1	ir_sequence_date_range group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
29	13	4	1	1	ir_sequence_date_range group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
30	14	1	1	1	ir_ui_menu group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
31	14	4	1	1	ir_ui_menu group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
32	16	\N	1	1	ir_ui_view group_user	t	f	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
33	16	4	1	1	ir_ui_view group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
34	17	4	1	1	reset_view_arch_wizard group_system	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
35	15	4	1	1	ir_ui_view_custom_group_user	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
36	35	\N	1	1	ir_default all	t	f	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
37	35	1	1	1	ir_default group_user	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
38	35	4	1	1	ir_default group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
39	96	2	1	1	res_company group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
40	96	11	1	1	res_company group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
41	96	10	1	1	res_company group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
42	96	1	1	1	res_company group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
43	80	11	1	1	res_country group_user_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
44	80	10	1	1	res_country group_user_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
45	80	1	1	1	res_country group_user_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
46	82	11	1	1	res_country_state group_user_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
47	82	10	1	1	res_country_state group_user_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
48	82	1	1	1	res_country_state group_user_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
49	81	11	1	1	res_country_group group_user_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
50	81	10	1	1	res_country_group group_user_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
51	81	1	1	1	res_country_group group_user_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
52	80	9	1	1	res_country group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
53	80	4	1	1	res_country_group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
54	82	9	1	1	res_country_state group_user	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
55	81	9	1	1	res_country_group group_user	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
56	94	11	1	1	res_currency group_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
57	94	10	1	1	res_currency group_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
58	94	1	1	1	res_currency group_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
59	95	11	1	1	res_currency_rate group_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
60	95	10	1	1	res_currency_rate group_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
61	95	1	1	1	res_currency_rate group_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
62	94	4	1	1	res_currency group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
63	95	4	1	1	res_currency_rate group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
64	97	2	1	1	res_groups group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
65	97	1	1	1	res_groups group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
66	83	11	1	1	res_lang group_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
67	83	10	1	1	res_lang group_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
68	83	1	1	1	res_lang group_all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
69	83	4	1	1	res_lang group_user	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
70	88	11	1	1	res_partner group_public	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
71	88	10	1	1	res_partner group_portal	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
72	88	9	1	1	res_partner group_partner_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
73	88	1	1	1	res_partner group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
74	91	1	1	1	res_partner_bank group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
75	91	9	1	1	res_partner_bank group_partner_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
76	86	1	1	1	res_partner_category group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
77	86	9	1	1	res_partner_category group_partner_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
78	89	1	1	1	res_partner_industry group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
79	89	4	1	1	res_partner_industry group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
80	87	9	1	1	res_partner_title group_partner_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
81	87	1	1	1	res_partner_title group_user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
82	99	11	1	1	res_users all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
83	99	10	1	1	res_users all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
84	99	1	1	1	res_users all	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
85	99	2	1	1	res_users group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
86	108	\N	1	1	res_users_deletion all	t	f	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
87	108	2	1	1	res_users_deletion group_erp_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
88	98	4	1	1	res_users_log_all	t	t	f	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
89	100	1	1	1	id check employees	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
90	100	10	1	1	id check portal	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
91	104	1	1	1	API keys access employees	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
92	104	10	1	1	API keys access portal	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
93	105	1	1	1	API key wizard employees	t	t	f	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
94	105	10	1	1	API key wizard	t	t	f	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
95	106	1	1	1	API key result employees	t	t	f	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
96	107	\N	1	1	res.users.settings	t	f	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
97	107	1	1	1	res.users.settings	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
98	18	4	1	1	ir_asset_group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
99	19	4	1	1	ir_actions_group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
100	20	4	1	1	ir_actions_act_window_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
101	22	4	1	1	ir_actions_act_window_close_group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
102	28	4	1	1	ir_actions_report_group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
103	25	4	1	1	ir_actions_todo group system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
104	21	4	1	1	ir_actions_act_window_view_group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
105	23	4	1	1	ir_actions_act_url_group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
106	24	4	1	1	ir_actions_server_group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
107	27	1	1	1	ir_embedded_actions_group_user	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
108	26	4	1	1	ir_actions_client all	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
109	90	4	1	1	res_bank_group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
110	90	9	1	1	res_bank_group_partner_manager	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
111	90	1	1	1	res_bank user	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
112	34	2	1	1	ir_filters all	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
113	34	1	1	1	ir_filters all	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
114	34	10	1	1	ir_filters all	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
115	34	11	1	1	ir_filters all	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
116	39	4	1	1	ir_config_parameter_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
117	41	4	1	1	ir_mail_server	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
118	66	2	1	1	ir_logging admin	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
119	75	1	1	1	ir_actions_report_paperformat group_portal	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
120	75	4	1	1	ir_actions_report_paperformat group_system	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
121	74	1	1	1	access_report_layout	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
122	11	4	1	1	access.wizard.ir.model.menu.create	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
123	17	2	1	1	access.reset.view.arch.wizard	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
124	71	4	1	1	access.ir.demo	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
125	72	4	1	1	access.ir.demo_failure	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
126	73	4	1	1	access.ir.demo_failure.wizard	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
127	92	4	1	1	access.res.config	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
128	93	4	1	1	access.res.config.settings	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
129	101	2	1	1	access.change.password.wizard	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
130	102	2	1	1	access.change.password.user	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
131	103	1	1	1	access.change.password.own	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
132	113	4	1	1	access.base.module.update	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
133	114	4	1	1	access.base.language.install	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
134	115	4	1	1	access.base.language.import	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
135	116	4	1	1	access.base.module.upgrade	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
136	117	4	1	1	access.base.module.uninstall	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
137	118	1	1	1	access.base.language.export	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
138	119	9	1	1	access.base.partner.merge.line	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
139	120	9	1	1	access.base.partner.merge.automatic.wizard	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
140	76	4	1	1	ir_profile	t	t	t	t	t	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
141	77	4	1	1	access.base.enable.profiling.wizard	t	t	t	t	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
142	110	1	1	1	access_res_device	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
143	109	1	1	1	access_res_device_log	t	t	f	f	f	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
144	122	4	1	1	access.base.document.layout	t	t	t	t	f	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651
145	124	1	1	1	auth_totp wizard access rules	t	t	t	t	t	2026-01-22 18:40:05.375352	2026-01-22 18:40:05.375352
146	123	1	1	1	TOTP Device access employees	t	t	f	f	f	2026-01-22 18:40:05.375352	2026-01-22 18:40:05.375352
147	123	10	1	1	TOTP Device access portal	t	t	f	f	f	2026-01-22 18:40:05.375352	2026-01-22 18:40:05.375352
148	125	1	1	1	base.import.mapping	t	t	t	t	t	2026-01-22 18:40:05.753436	2026-01-22 18:40:05.753436
149	126	1	1	1	access.base_import.import	t	t	t	t	f	2026-01-22 18:40:05.753436	2026-01-22 18:40:05.753436
150	127	4	1	1	access.base.import.module	t	t	t	t	f	2026-01-22 18:40:07.014423	2026-01-22 18:40:07.014423
151	129	\N	1	1	bus.bus public	t	f	f	f	f	2026-01-22 18:40:07.603895	2026-01-22 18:40:07.603895
152	131	1	1	1	bus.presence	t	t	t	t	t	2026-01-22 18:40:07.603895	2026-01-22 18:40:07.603895
153	131	10	1	1	bus.presence	t	t	t	t	t	2026-01-22 18:40:07.603895	2026-01-22 18:40:07.603895
154	133	4	1	1	access_web_tour_tour_admin	t	t	t	t	t	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
155	133	1	1	1	access_web_tour_tour_readonly	t	t	f	f	f	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
156	134	4	1	1	access_web_tour_tour_step_admin	t	t	t	t	t	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
157	134	1	1	1	access_web_tour_tour_step_readonly	t	t	f	f	f	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
158	135	4	1	1	iap.account.manager	t	t	t	t	t	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
159	135	1	1	1	iap.account.user	t	t	f	t	f	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
160	137	4	1	1	iap.service.manager	t	t	t	t	t	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
161	137	1	1	1	iap.service.user	t	t	f	f	f	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
162	141	4	1	1	access_web_editor_converter_test	t	t	t	t	t	2026-01-22 18:40:08.923404	2026-01-22 18:40:08.923404
163	142	4	1	1	access_web_editor_converter_test_sub	t	t	t	t	t	2026-01-22 18:40:08.923404	2026-01-22 18:40:08.923404
\.


--
-- Data for Name: ir_model_constraint; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_constraint (id, model, module, create_uid, write_uid, name, definition, type, message, write_date, create_date) FROM stdin;
1	3	155	1	1	ir_model_obj_name_uniq	unique(model)	u	{"en_US": "Each model must have a unique name."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
2	4	155	1	1	ir_model_fields_name_unique	unique(model,name)	u	{"en_US": "Field names must be unique per model."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
3	4	155	1	1	ir_model_fields_size_gt_zero	check(size>=0)	u	{"en_US": "Size of the field cannot be negative."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
4	4	155	1	1	ir_model_fields_name_manual_field	check(state != 'manual' or name like 'x\\_%')	u	{"en_US": "Custom fields must have a name that starts with 'x_'!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
5	5	155	1	1	ir_model_inherit_uniq	unique(model_id,parent_id)	u	{"en_US": "Models inherits from another only once"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
6	6	155	1	1	ir_model_fields_selection_selection_field_uniq	unique(field_id,value)	u	{"en_US": "Selections values must be unique per field"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
7	7	155	1	1	ir_model_constraint_module_name_uniq	unique(name,module)	u	{"en_US": "Constraints with the same name are unique per module."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
8	10	155	1	1	ir_model_data_name_nospaces	check(name not like '% %')	u	{"en_US": "External IDs cannot contain spaces"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
9	13	155	1	1	ir_sequence_date_range_unique_range_per_sequence	unique(sequence_id,date_from,date_to)	u	{"en_US": "You cannot create two date ranges for the same sequence with the same date range."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
10	16	155	1	1	ir_ui_view_inheritance_mode	check(mode != 'extension' or inherit_id is not null)	u	{"en_US": "Invalid inheritance mode: if the mode is 'extension', the view must extend an other view"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
11	16	155	1	1	ir_ui_view_qweb_required_key	check(type != 'qweb' or key is not null)	u	{"en_US": "Invalid key: QWeb view should have a key"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
12	19	155	1	1	ir_actions_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
13	20	155	1	1	ir_act_window_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
14	23	155	1	1	ir_act_url_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
15	24	155	1	1	ir_act_server_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
16	26	155	1	1	ir_act_client_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
17	27	155	1	1	ir_embedded_actions_check_only_one_action_defined	check(\n               (action_id is not null and python_method is null) or\n               (action_id is null and python_method is not null)\n            )	u	{"en_US": "Constraint to ensure that either an XML action or a python_method is defined, but not both."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
18	27	155	1	1	ir_embedded_actions_check_python_method_requires_name	check(\n                not(python_method is not null and name is null)\n            )	u	{"en_US": "Constraint to ensure that if a python_method is defined, then the name must also be defined."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
19	28	155	1	1	ir_act_report_xml_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
20	31	155	1	1	ir_cron_check_strictly_positive_interval	check(interval_number > 0)	u	{"en_US": "The interval number must be a strictly positive number."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
21	34	155	1	1	ir_filters_name_model_uid_unique	unique(model_id,user_id,action_id,embedded_action_id,embedded_parent_res_id,name)	u	{"en_US": "Filter names must be unique"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
22	34	155	1	1	ir_filters_check_res_id_only_when_embedded_action	check(\n                not(embedded_parent_res_id is not null and embedded_action_id is null)\n            )	u	{"en_US": "Constraint to ensure that the embedded_parent_res_id is only defined when a top_action_id is defined."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
23	34	155	1	1	ir_filters_check_sort_json	check(sort is null or jsonb_typeof(sort::jsonb) = 'array')	u	{"en_US": "Invalid sort definition"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
24	38	155	1	1	ir_rule_no_access_rights	check(perm_read!=false or perm_write!=false or perm_create!=false or perm_unlink!=false)	u	{"en_US": "Rule must have at least one checked access right!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
25	39	155	1	1	ir_config_parameter_key_uniq	unique(key)	u	{"en_US": "Key must be unique."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
26	41	155	1	1	ir_mail_server_certificate_requires_tls	check(smtp_encryption != 'none' or smtp_authentication != 'certificate')	u	{"en_US": "Certificate-based authentication requires a TLS transport"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
27	68	155	1	1	ir_module_module_name_uniq	unique(name)	u	{"en_US": "The name of the module must be unique!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
28	80	155	1	1	res_country_name_uniq	unique(name)	u	{"en_US": "The name of the country must be unique!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
29	80	155	1	1	res_country_code_uniq	unique(code)	u	{"en_US": "The code of the country must be unique!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
30	82	155	1	1	res_country_state_name_code_uniq	unique(country_id,code)	u	{"en_US": "The code of the state must be unique by country!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
31	83	155	1	1	res_lang_name_uniq	unique(name)	u	{"en_US": "The name of the language must be unique!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
32	83	155	1	1	res_lang_code_uniq	unique(code)	u	{"en_US": "The code of the language must be unique!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
33	83	155	1	1	res_lang_url_code_uniq	unique(url_code)	u	{"en_US": "The URL code of the language must be unique!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
34	88	155	1	1	res_partner_check_name	check((type='contact' and name is not null) or(type!='contact') )	u	{"en_US": "Contacts require a name"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
35	91	155	1	1	res_partner_bank_unique_number	unique(sanitized_acc_number,partner_id)	u	{"en_US": "The combination Account Number/Partner must be unique."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
36	94	155	1	1	res_currency_unique_name	unique(name)	u	{"en_US": "The currency code must be unique!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
37	94	155	1	1	res_currency_rounding_gt_zero	check(rounding>0)	u	{"en_US": "The rounding factor must be greater than 0!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
38	95	155	1	1	res_currency_rate_unique_name_per_day	unique(name,currency_id,company_id)	u	{"en_US": "Only one currency rate per day allowed!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
39	95	155	1	1	res_currency_rate_currency_rate_check	check(rate>0)	u	{"en_US": "The currency rate must be strictly positive."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
40	96	155	1	1	res_company_name_uniq	unique(name)	u	{"en_US": "The company name must be unique!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
41	97	155	1	1	res_groups_name_uniq	unique(category_id,name)	u	{"en_US": "The name of the group must be unique within an application!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
42	97	155	1	1	res_groups_check_api_key_duration	check(api_key_duration >= 0)	u	{"en_US": "The api key duration cannot be a negative value."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
43	99	155	1	1	res_users_login_key	unique(login)	u	{"en_US": "You can not have two users with the same login!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
44	107	155	1	1	res_users_settings_unique_user_id	unique(user_id)	u	{"en_US": "One user should only have one user settings."}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
45	111	155	1	1	decimal_precision_name_uniq	unique(name)	u	{"en_US": "Only one value can be defined for each given usage!"}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
46	3	155	1	1	ir_model_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
47	3	155	1	1	ir_model_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
48	4	155	1	1	ir_model_fields_group_rel_field_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
49	4	155	1	1	ir_model_fields_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
50	4	155	1	1	ir_model_fields_relation_field_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
51	4	155	1	1	ir_model_fields_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
52	4	155	1	1	ir_model_fields_related_field_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
53	4	155	1	1	ir_model_fields_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
54	4	155	1	1	ir_model_fields_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
55	5	155	1	1	ir_model_inherit_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
56	5	155	1	1	ir_model_inherit_parent_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
57	5	155	1	1	ir_model_inherit_parent_field_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
58	6	155	1	1	ir_model_fields_selection_field_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
59	6	155	1	1	ir_model_fields_selection_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
60	6	155	1	1	ir_model_fields_selection_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
61	7	155	1	1	ir_model_constraint_model_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
62	7	155	1	1	ir_model_constraint_module_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
63	7	155	1	1	ir_model_constraint_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
64	7	155	1	1	ir_model_constraint_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
65	8	155	1	1	ir_model_relation_model_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
66	8	155	1	1	ir_model_relation_module_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
67	8	155	1	1	ir_model_relation_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
68	8	155	1	1	ir_model_relation_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
69	9	155	1	1	ir_model_access_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
70	9	155	1	1	ir_model_access_group_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
71	9	155	1	1	ir_model_access_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
72	9	155	1	1	ir_model_access_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
73	10	155	1	1	ir_model_data_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
74	10	155	1	1	ir_model_data_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
75	11	155	1	1	wizard_ir_model_menu_create_menu_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
76	11	155	1	1	wizard_ir_model_menu_create_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
77	11	155	1	1	wizard_ir_model_menu_create_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
78	12	155	1	1	ir_sequence_company_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
79	12	155	1	1	ir_sequence_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
80	12	155	1	1	ir_sequence_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
81	13	155	1	1	ir_sequence_date_range_sequence_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
82	13	155	1	1	ir_sequence_date_range_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
83	13	155	1	1	ir_sequence_date_range_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
84	97	155	1	1	ir_ui_menu_group_rel_menu_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
85	14	155	1	1	ir_ui_menu_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
86	14	155	1	1	ir_ui_menu_parent_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
87	14	155	1	1	ir_ui_menu_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
88	14	155	1	1	ir_ui_menu_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
89	15	155	1	1	ir_ui_view_custom_ref_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
90	15	155	1	1	ir_ui_view_custom_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
91	15	155	1	1	ir_ui_view_custom_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
92	15	155	1	1	ir_ui_view_custom_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
93	97	155	1	1	ir_ui_view_group_rel_view_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
94	16	155	1	1	ir_ui_view_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
95	16	155	1	1	ir_ui_view_inherit_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
96	16	155	1	1	ir_ui_view_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
97	16	155	1	1	ir_ui_view_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
98	17	155	1	1	reset_view_arch_wizard_view_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
99	17	155	1	1	reset_view_arch_wizard_compare_view_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
100	17	155	1	1	reset_view_arch_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
101	17	155	1	1	reset_view_arch_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
102	18	155	1	1	ir_asset_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
103	18	155	1	1	ir_asset_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
104	22	155	1	1	ir_actions_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
105	22	155	1	1	ir_actions_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
106	22	155	1	1	ir_actions_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
107	20	155	1	1	ir_act_window_group_rel_act_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
108	20	155	1	1	ir_act_window_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
109	20	155	1	1	ir_act_window_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
110	20	155	1	1	ir_act_window_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
111	20	155	1	1	ir_act_window_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
112	20	155	1	1	ir_act_window_view_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
113	20	155	1	1	ir_act_window_search_view_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
114	21	155	1	1	ir_act_window_view_view_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
115	21	155	1	1	ir_act_window_view_act_window_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
116	21	155	1	1	ir_act_window_view_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
117	21	155	1	1	ir_act_window_view_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
118	23	155	1	1	ir_act_url_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
119	23	155	1	1	ir_act_url_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
120	23	155	1	1	ir_act_url_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
121	24	155	1	1	rel_server_actions_server_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
122	24	155	1	1	rel_server_actions_action_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
123	24	155	1	1	ir_act_server_group_rel_act_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
124	24	155	1	1	ir_act_server_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
125	24	155	1	1	ir_act_server_webhook_field_rel_server_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
126	24	155	1	1	ir_act_server_webhook_field_rel_field_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
127	24	155	1	1	ir_act_server_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
128	24	155	1	1	ir_act_server_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
129	24	155	1	1	ir_act_server_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
130	24	155	1	1	ir_act_server_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
131	24	155	1	1	ir_act_server_crud_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
132	24	155	1	1	ir_act_server_link_field_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
133	24	155	1	1	ir_act_server_update_field_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
134	24	155	1	1	ir_act_server_update_related_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
135	24	155	1	1	ir_act_server_selection_value_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
136	25	155	1	1	ir_actions_todo_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
137	25	155	1	1	ir_actions_todo_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
138	26	155	1	1	ir_act_client_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
139	26	155	1	1	ir_act_client_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
140	26	155	1	1	ir_act_client_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
141	27	155	1	1	ir_embedded_actions_res_groups_rel_ir_embedded_actions_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
142	27	155	1	1	ir_embedded_actions_res_groups_rel_res_groups_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
143	27	155	1	1	ir_embedded_actions_parent_action_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
144	27	155	1	1	ir_embedded_actions_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
145	27	155	1	1	ir_embedded_actions_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
146	27	155	1	1	ir_embedded_actions_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
147	28	155	1	1	res_groups_report_rel_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
148	28	155	1	1	res_groups_report_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
149	28	155	1	1	ir_act_report_xml_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
150	28	155	1	1	ir_act_report_xml_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
151	28	155	1	1	ir_act_report_xml_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
152	28	155	1	1	ir_act_report_xml_paperformat_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
153	29	155	1	1	ir_attachment_company_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
154	29	155	1	1	ir_attachment_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
155	29	155	1	1	ir_attachment_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
156	31	155	1	1	ir_cron_ir_actions_server_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
157	31	155	1	1	ir_cron_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
158	31	155	1	1	ir_cron_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
159	31	155	1	1	ir_cron_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
160	32	155	1	1	ir_cron_trigger_cron_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
161	32	155	1	1	ir_cron_trigger_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
162	32	155	1	1	ir_cron_trigger_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
163	33	155	1	1	ir_cron_progress_cron_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
164	33	155	1	1	ir_cron_progress_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
165	33	155	1	1	ir_cron_progress_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
166	34	155	1	1	ir_filters_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
167	34	155	1	1	ir_filters_embedded_action_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
168	34	155	1	1	ir_filters_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
169	34	155	1	1	ir_filters_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
170	35	155	1	1	ir_default_field_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
171	35	155	1	1	ir_default_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
172	35	155	1	1	ir_default_company_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
173	35	155	1	1	ir_default_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
174	35	155	1	1	ir_default_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
175	36	155	1	1	ir_exports_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
176	36	155	1	1	ir_exports_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
177	37	155	1	1	ir_exports_line_export_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
178	37	155	1	1	ir_exports_line_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
179	37	155	1	1	ir_exports_line_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
180	97	155	1	1	rule_group_rel_rule_group_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
181	38	155	1	1	rule_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
182	38	155	1	1	ir_rule_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
183	38	155	1	1	ir_rule_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
184	38	155	1	1	ir_rule_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
185	39	155	1	1	ir_config_parameter_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
186	39	155	1	1	ir_config_parameter_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
187	41	155	1	1	ir_mail_server_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
188	41	155	1	1	ir_mail_server_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
189	67	155	1	1	ir_module_category_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
190	67	155	1	1	ir_module_category_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
191	68	155	1	1	module_country_module_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
192	68	155	1	1	module_country_country_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
193	68	155	1	1	ir_module_module_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
194	68	155	1	1	ir_module_module_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
195	70	155	1	1	ir_module_module_exclusion_module_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
196	70	155	1	1	ir_module_module_exclusion_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
197	70	155	1	1	ir_module_module_exclusion_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
198	71	155	1	1	ir_demo_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
199	71	155	1	1	ir_demo_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
200	72	155	1	1	ir_demo_failure_module_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
201	72	155	1	1	ir_demo_failure_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
202	72	155	1	1	ir_demo_failure_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
203	72	155	1	1	ir_demo_failure_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
204	73	155	1	1	ir_demo_failure_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
205	73	155	1	1	ir_demo_failure_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
206	74	155	1	1	report_layout_view_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
207	74	155	1	1	report_layout_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
208	74	155	1	1	report_layout_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
209	75	155	1	1	report_paperformat_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
210	75	155	1	1	report_paperformat_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
211	77	155	1	1	base_enable_profiling_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
212	77	155	1	1	base_enable_profiling_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
213	81	155	1	1	res_country_res_country_group_rel_res_country_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
214	80	155	1	1	res_country_res_country_group_rel_res_country_group_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
215	80	155	1	1	res_country_address_view_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
216	80	155	1	1	res_country_currency_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
217	80	155	1	1	res_country_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
218	80	155	1	1	res_country_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
219	81	155	1	1	res_country_group_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
220	81	155	1	1	res_country_group_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
221	82	155	1	1	res_country_state_country_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
222	82	155	1	1	res_country_state_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
223	82	155	1	1	res_country_state_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
224	83	155	1	1	res_lang_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
225	83	155	1	1	res_lang_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
226	88	155	1	1	res_partner_res_partner_category_rel_category_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
227	86	155	1	1	res_partner_res_partner_category_rel_partner_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
228	86	155	1	1	res_partner_category_parent_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
229	86	155	1	1	res_partner_category_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
230	86	155	1	1	res_partner_category_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
231	87	155	1	1	res_partner_title_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
232	87	155	1	1	res_partner_title_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
233	88	155	1	1	res_partner_title_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
234	88	155	1	1	res_partner_parent_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
235	88	155	1	1	res_partner_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
236	88	155	1	1	res_partner_state_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
237	88	155	1	1	res_partner_country_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
238	88	155	1	1	res_partner_industry_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
239	88	155	1	1	res_partner_company_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
240	88	155	1	1	res_partner_commercial_partner_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
241	88	155	1	1	res_partner_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
242	88	155	1	1	res_partner_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
243	89	155	1	1	res_partner_industry_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
244	89	155	1	1	res_partner_industry_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
245	90	155	1	1	res_bank_state_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
246	90	155	1	1	res_bank_country_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
247	90	155	1	1	res_bank_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
248	90	155	1	1	res_bank_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
249	91	155	1	1	res_partner_bank_partner_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
250	91	155	1	1	res_partner_bank_bank_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
251	91	155	1	1	res_partner_bank_currency_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
252	91	155	1	1	res_partner_bank_company_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
253	91	155	1	1	res_partner_bank_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
254	91	155	1	1	res_partner_bank_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
255	92	155	1	1	res_config_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
256	92	155	1	1	res_config_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
257	93	155	1	1	res_config_settings_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
258	93	155	1	1	res_config_settings_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
259	94	155	1	1	res_currency_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
260	94	155	1	1	res_currency_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
261	95	155	1	1	res_currency_rate_currency_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
262	95	155	1	1	res_currency_rate_company_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
263	95	155	1	1	res_currency_rate_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
264	95	155	1	1	res_currency_rate_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
265	99	155	1	1	res_company_users_rel_cid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
266	96	155	1	1	res_company_users_rel_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
267	96	155	1	1	res_company_parent_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
268	96	155	1	1	res_company_partner_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
269	96	155	1	1	res_company_currency_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
270	96	155	1	1	res_company_paperformat_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
271	96	155	1	1	res_company_external_report_layout_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
272	96	155	1	1	res_company_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
273	96	155	1	1	res_company_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
274	99	155	1	1	res_groups_users_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
275	97	155	1	1	res_groups_users_rel_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
276	97	155	1	1	res_groups_implied_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
277	97	155	1	1	res_groups_implied_rel_hid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
278	97	155	1	1	res_groups_category_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
279	97	155	1	1	res_groups_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
280	97	155	1	1	res_groups_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
281	98	155	1	1	res_users_log_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
282	98	155	1	1	res_users_log_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
283	99	155	1	1	res_users_partner_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
284	99	155	1	1	res_users_company_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
285	99	155	1	1	res_users_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
286	99	155	1	1	res_users_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
287	100	155	1	1	res_users_identitycheck_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
288	100	155	1	1	res_users_identitycheck_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
289	101	155	1	1	change_password_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
290	101	155	1	1	change_password_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
291	102	155	1	1	change_password_user_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
292	102	155	1	1	change_password_user_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
293	102	155	1	1	change_password_user_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
294	102	155	1	1	change_password_user_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
295	103	155	1	1	change_password_own_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
296	103	155	1	1	change_password_own_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
297	105	155	1	1	res_users_apikeys_description_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
298	105	155	1	1	res_users_apikeys_description_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
299	107	155	1	1	res_users_settings_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
300	107	155	1	1	res_users_settings_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
301	107	155	1	1	res_users_settings_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
302	108	155	1	1	res_users_deletion_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
303	108	155	1	1	res_users_deletion_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
304	108	155	1	1	res_users_deletion_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
305	109	155	1	1	res_device_log_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
306	109	155	1	1	res_device_log_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
307	109	155	1	1	res_device_log_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
308	111	155	1	1	decimal_precision_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
309	111	155	1	1	decimal_precision_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
310	113	155	1	1	base_module_update_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
311	113	155	1	1	base_module_update_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
312	114	155	1	1	res_lang_install_rel_language_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
313	114	155	1	1	res_lang_install_rel_lang_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
314	114	155	1	1	base_language_install_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
315	114	155	1	1	base_language_install_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
316	115	155	1	1	base_language_import_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
317	115	155	1	1	base_language_import_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
318	116	155	1	1	base_module_upgrade_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
319	116	155	1	1	base_module_upgrade_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
320	117	155	1	1	base_module_uninstall_module_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
321	117	155	1	1	base_module_uninstall_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
322	117	155	1	1	base_module_uninstall_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
323	118	155	1	1	rel_modules_langexport_wiz_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
324	118	155	1	1	rel_modules_langexport_module_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
325	118	155	1	1	base_language_export_model_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
326	118	155	1	1	base_language_export_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
327	118	155	1	1	base_language_export_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
328	119	155	1	1	base_partner_merge_line_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
329	119	155	1	1	base_partner_merge_line_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
330	119	155	1	1	base_partner_merge_line_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
331	120	155	1	1	base_partner_merge_automatic__base_partner_merge_automatic_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
332	120	155	1	1	base_partner_merge_automatic_wizard_res_par_res_partner_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
333	120	155	1	1	base_partner_merge_automatic_wizard_current_line_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
334	120	155	1	1	base_partner_merge_automatic_wizard_dst_partner_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
335	120	155	1	1	base_partner_merge_automatic_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
336	120	155	1	1	base_partner_merge_automatic_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834
337	122	1111	1	1	base_document_layout_company_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651
338	122	1111	1	1	base_document_layout_report_layout_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651
339	122	1111	1	1	base_document_layout_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651
340	122	1111	1	1	base_document_layout_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:00.599651	2026-01-22 18:40:00.599651
341	124	145	1	1	auth_totp_wizard_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:05.375352	2026-01-22 18:40:05.375352
342	124	145	1	1	auth_totp_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:05.375352	2026-01-22 18:40:05.375352
343	124	145	1	1	auth_totp_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:05.375352	2026-01-22 18:40:05.375352
344	125	171	1	1	base_import_mapping_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:05.753436	2026-01-22 18:40:05.753436
345	125	171	1	1	base_import_mapping_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:05.753436	2026-01-22 18:40:05.753436
346	126	171	1	1	base_import_import_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:05.753436	2026-01-22 18:40:05.753436
347	126	171	1	1	base_import_import_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:05.753436	2026-01-22 18:40:05.753436
348	127	172	1	1	base_import_module_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.014423	2026-01-22 18:40:07.014423
349	127	172	1	1	base_import_module_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.014423	2026-01-22 18:40:07.014423
350	93	186	1	1	res_config_settings_company_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.336495	2026-01-22 18:40:07.336495
351	129	209	1	1	bus_bus_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.603895	2026-01-22 18:40:07.603895
352	129	209	1	1	bus_bus_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.603895	2026-01-22 18:40:07.603895
353	131	209	1	1	bus_presence_user_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.603895	2026-01-22 18:40:07.603895
354	133	1153	1	1	web_tour_tour_uniq_name	unique(name)	u	{"en_US": "A tour already exists with this name . Tour's name must be unique!"}	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
355	133	1153	1	1	res_users_web_tour_tour_rel_web_tour_tour_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
356	133	1153	1	1	res_users_web_tour_tour_rel_res_users_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
357	133	1153	1	1	web_tour_tour_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
358	133	1153	1	1	web_tour_tour_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
359	134	1153	1	1	web_tour_tour_step_tour_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
360	134	1153	1	1	web_tour_tour_step_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
361	134	1153	1	1	web_tour_tour_step_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:07.920702	2026-01-22 18:40:07.920702
362	29	324	1	1	ir_attachment_original_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.224169	2026-01-22 18:40:08.224169
363	137	330	1	1	iap_service_unique_technical_name	unique(technical_name)	u	{"en_US": "Only one service can exist with a specific technical_name"}	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
364	135	330	1	1	iap_account_res_company_rel_iap_account_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
365	135	330	1	1	iap_account_res_company_rel_res_company_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
366	135	330	1	1	iap_account_res_users_rel_iap_account_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
367	135	330	1	1	iap_account_res_users_rel_res_users_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
368	135	330	1	1	iap_account_service_id_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
369	135	330	1	1	iap_account_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
370	135	330	1	1	iap_account_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
371	137	330	1	1	iap_service_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
372	137	330	1	1	iap_service_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.61693	2026-01-22 18:40:08.61693
373	141	1120	1	1	web_editor_converter_test_many2one_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.923404	2026-01-22 18:40:08.923404
374	141	1120	1	1	web_editor_converter_test_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.923404	2026-01-22 18:40:08.923404
375	141	1120	1	1	web_editor_converter_test_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.923404	2026-01-22 18:40:08.923404
376	142	1120	1	1	web_editor_converter_test_sub_create_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.923404	2026-01-22 18:40:08.923404
377	142	1120	1	1	web_editor_converter_test_sub_write_uid_fkey	\N	f	{"en_US": null}	2026-01-22 18:40:08.923404	2026-01-22 18:40:08.923404
\.


--
-- Data for Name: ir_model_data; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_data (id, create_uid, create_date, write_date, write_uid, res_id, noupdate, name, module, model) FROM stdin;
1	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	USD	base	res.currency
2	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	main_company	base	res.company
3	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	main_partner	base	res.partner
4	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	user_root	base	res.users
5	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	group_user	base	res.groups
6	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	module_category_accounting	base	ir.module.category
7	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	t	module_category_accounting_accounting	base	ir.module.category
8	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	module_account	base	ir.module.module
9	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	t	module_account_add_gln	base	ir.module.module
10	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	t	module_category_uncategorized	base	ir.module.category
11	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	t	module_account_analytic_distribution_manual	base	ir.module.module
12	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	t	module_category_accounting_and_finance	base	ir.module.category
13	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	t	module_account_analytic_parent	base	ir.module.module
14	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	t	module_category_analytic_accounting	base	ir.module.category
15	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	t	module_account_analytic_required	base	ir.module.module
16	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	6	t	module_account_analytic_sequence	base	ir.module.module
17	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	6	t	module_category_account	base	ir.module.category
18	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	7	t	module_account_analytic_spread_by_tag	base	ir.module.module
19	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	8	t	module_account_analytic_tag	base	ir.module.module
20	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	9	t	module_account_asset_compute_batch	base	ir.module.module
21	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	10	t	module_account_asset_force_account	base	ir.module.module
22	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	11	t	module_account_asset_low_value	base	ir.module.module
23	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	12	t	module_account_asset_management	base	ir.module.module
24	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	13	t	module_account_asset_number	base	ir.module.module
25	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	14	t	module_account_asset_transfer	base	ir.module.module
26	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	15	t	module_account_billing	base	ir.module.module
27	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	16	t	module_account_cash_deposit	base	ir.module.module
28	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	17	t	module_account_chart_update	base	ir.module.module
29	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	18	t	module_account_check_deposit	base	ir.module.module
30	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	19	t	module_account_check_printing	base	ir.module.module
31	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	20	t	module_account_cutoff_accrual_subscription	base	ir.module.module
32	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	21	t	module_account_cutoff_base	base	ir.module.module
33	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	22	t	module_account_cutoff_picking	base	ir.module.module
34	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	23	t	module_account_cutoff_start_end_dates	base	ir.module.module
35	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	24	t	module_account_dashboard_banner	base	ir.module.module
36	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	25	t	module_account_dashboard_banner_mis_builder	base	ir.module.module
37	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	26	t	module_account_debit_note	base	ir.module.module
38	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	27	t	module_account_edi	base	ir.module.module
39	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	28	t	module_account_edi_proxy_client	base	ir.module.module
40	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	29	t	module_account_edi_ubl_cii	base	ir.module.module
41	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	30	t	module_account_edi_ubl_cii_tax_extension	base	ir.module.module
42	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	7	t	module_category_reporting	base	ir.module.category
43	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	31	t	module_account_financial_report	base	ir.module.module
44	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	32	t	module_account_financial_report_sale	base	ir.module.module
45	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	8	t	module_category_invoices_and_payments	base	ir.module.category
46	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	33	t	module_account_fiscal_position_vat_check	base	ir.module.module
47	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	34	t	module_account_fiscal_year	base	ir.module.module
48	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	35	t	module_account_fiscal_year_auto_create	base	ir.module.module
49	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	36	t	module_account_fiscal_year_closing	base	ir.module.module
50	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	37	t	module_account_fleet	base	ir.module.module
51	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	38	t	module_account_global_discount	base	ir.module.module
52	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	39	t	module_account_in_payment	base	ir.module.module
53	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	40	t	module_account_invoice_auto_send_by_email	base	ir.module.module
54	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	41	t	module_account_invoice_check_total	base	ir.module.module
55	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	42	t	module_account_invoice_constraint_chronology	base	ir.module.module
56	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	43	t	module_account_invoice_crm_tag	base	ir.module.module
57	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	44	t	module_account_invoice_date_due	base	ir.module.module
58	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	45	t	module_account_invoice_fiscal_position_update	base	ir.module.module
59	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	46	t	module_account_invoice_fixed_discount	base	ir.module.module
60	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	47	t	module_account_invoice_payment_term_date_due	base	ir.module.module
61	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	48	t	module_account_invoice_pricelist	base	ir.module.module
62	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	9	t	module_category_sales	base	ir.module.category
63	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	49	t	module_account_invoice_pricelist_sale	base	ir.module.module
64	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	50	t	module_account_invoice_refund_link	base	ir.module.module
65	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	51	t	module_account_invoice_refund_reason	base	ir.module.module
66	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	52	t	module_account_invoice_section_sale_order	base	ir.module.module
67	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	53	t	module_account_invoice_show_currency_rate	base	ir.module.module
68	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	54	t	module_account_invoice_start_end_dates	base	ir.module.module
69	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	55	t	module_account_invoice_supplier_ref_unique	base	ir.module.module
70	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	56	t	module_account_invoice_supplierinfo_update	base	ir.module.module
71	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	10	t	module_category_localization_	base	ir.module.category
72	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	11	t	module_category_localization___accounting	base	ir.module.category
73	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	57	t	module_account_invoice_tax_required	base	ir.module.module
74	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	58	t	module_account_invoice_transmit_method	base	ir.module.module
75	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	59	t	module_account_invoice_transmit_method_substitution_rule	base	ir.module.module
76	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	60	t	module_account_invoice_tree_currency	base	ir.module.module
77	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	61	t	module_account_invoice_triple_discount	base	ir.module.module
78	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	62	t	module_account_invoice_warn_message	base	ir.module.module
79	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	63	t	module_account_journal_general_sequence	base	ir.module.module
80	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	64	t	module_account_journal_lock_date	base	ir.module.module
81	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	65	t	module_account_journal_restrict_mode	base	ir.module.module
82	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	66	t	module_account_loan	base	ir.module.module
83	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	67	t	module_account_lock_date_update	base	ir.module.module
84	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	68	t	module_account_lock_to_date	base	ir.module.module
85	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	69	t	module_account_mail_autosubscribe	base	ir.module.module
86	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	70	t	module_account_manual_currency	base	ir.module.module
87	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	71	t	module_account_maturity_date_default	base	ir.module.module
88	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	72	t	module_account_move_analytic_link	base	ir.module.module
89	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	73	t	module_account_move_auto_post_ref	base	ir.module.module
90	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	12	t	module_category_finance	base	ir.module.category
91	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	74	t	module_account_move_base_import	base	ir.module.module
92	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	13	t	module_category_usability	base	ir.module.category
93	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	75	t	module_account_move_cancel_confirm	base	ir.module.module
94	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	76	t	module_account_move_fiscal_year	base	ir.module.module
95	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	14	t	module_category_generic	base	ir.module.category
96	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	77	t	module_account_move_line_purchase_info	base	ir.module.module
97	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	78	t	module_account_move_line_sale_info	base	ir.module.module
98	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	15	t	module_category_warehouse_management	base	ir.module.category
99	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	79	t	module_account_move_line_stock_info	base	ir.module.module
100	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	80	t	module_account_move_line_tax_editable	base	ir.module.module
101	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	81	t	module_account_move_name_sequence	base	ir.module.module
102	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	82	t	module_account_move_post_date_user	base	ir.module.module
103	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	83	t	module_account_move_print	base	ir.module.module
104	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	84	t	module_account_move_reconcile_forbid_cancel	base	ir.module.module
105	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	85	t	module_account_move_template	base	ir.module.module
106	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	16	t	module_category_accounts	base	ir.module.category
107	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	86	t	module_account_move_tier_validation	base	ir.module.module
108	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	87	t	module_account_move_tier_validation_approver	base	ir.module.module
109	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	88	t	module_account_move_update_analytic	base	ir.module.module
110	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	89	t	module_account_netting	base	ir.module.module
111	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	90	t	module_account_operating_unit	base	ir.module.module
112	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	91	t	module_account_partner_reconcile	base	ir.module.module
113	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	92	t	module_account_partner_required	base	ir.module.module
114	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	93	t	module_account_payment	base	ir.module.module
115	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	94	t	module_account_peppol	base	ir.module.module
116	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	95	t	module_account_peppol_selfbilling	base	ir.module.module
117	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	17	t	module_category_accounting_payment	base	ir.module.category
118	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	96	t	module_account_qr_code_emv	base	ir.module.module
119	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	97	t	module_account_qr_code_sepa	base	ir.module.module
120	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	98	t	module_account_receipt_journal	base	ir.module.module
121	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	99	t	module_account_reconcile_analytic_tag	base	ir.module.module
122	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	100	t	module_account_reconcile_model_oca	base	ir.module.module
123	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	101	t	module_account_reconcile_oca	base	ir.module.module
124	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	102	t	module_account_reconcile_oca_add_default_filters	base	ir.module.module
125	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	103	t	module_account_reconcile_oca_queue	base	ir.module.module
126	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	104	t	module_account_sequence_option	base	ir.module.module
127	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	105	t	module_account_spread_cost_revenue	base	ir.module.module
128	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	106	t	module_account_statement_base	base	ir.module.module
129	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	107	t	module_account_tax_balance	base	ir.module.module
130	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	108	t	module_account_tax_group_widget_base_amount	base	ir.module.module
131	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	109	t	module_account_tax_legal_notes_translate	base	ir.module.module
132	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	110	t	module_account_tax_python	base	ir.module.module
133	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	111	t	module_account_test	base	ir.module.module
134	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	112	t	module_account_update_tax_tags	base	ir.module.module
135	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	113	t	module_account_usability	base	ir.module.module
136	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	114	t	module_account_warn_option	base	ir.module.module
137	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	115	t	module_analytic	base	ir.module.module
138	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	18	t	module_category_generic_modules	base	ir.module.category
139	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	19	t	module_category_generic_modules_projects_and_services	base	ir.module.category
140	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	116	t	module_analytic_base_department	base	ir.module.module
141	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	117	t	module_analytic_hr_department_restriction	base	ir.module.module
142	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	118	t	module_analytic_operating_unit	base	ir.module.module
143	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	20	t	module_category_server_ux	base	ir.module.category
144	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	119	t	module_announcement	base	ir.module.module
145	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	21	t	module_category_hidden	base	ir.module.category
146	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	22	t	module_category_hidden_tools	base	ir.module.category
147	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	120	t	module_attachment_indexation	base	ir.module.module
148	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	121	t	module_attachment_queue	base	ir.module.module
149	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	122	t	module_attachment_synchronize	base	ir.module.module
150	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	23	t	module_category_tools	base	ir.module.category
151	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	123	t	module_attachment_unindex_content	base	ir.module.module
152	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	124	t	module_auditlog	base	ir.module.module
153	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	24	t	module_category_base	base	ir.module.category
154	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	125	t	module_auth_admin_passkey	base	ir.module.module
155	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	126	t	module_auth_api_key	base	ir.module.module
156	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	127	t	module_auth_api_key_group	base	ir.module.module
157	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	128	t	module_auth_api_key_server_env	base	ir.module.module
158	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	129	t	module_auth_jwt	base	ir.module.module
159	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	130	t	module_auth_jwt_demo	base	ir.module.module
160	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	131	t	module_auth_ldap	base	ir.module.module
161	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	132	t	module_auth_oauth	base	ir.module.module
162	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	133	t	module_auth_oauth_filter_by_domain	base	ir.module.module
163	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	25	t	module_category_tool	base	ir.module.category
164	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	134	t	module_auth_oauth_multi_token	base	ir.module.module
165	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	135	t	module_auth_oidc	base	ir.module.module
166	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	136	t	module_auth_oidc_environment	base	ir.module.module
167	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	137	t	module_auth_passkey	base	ir.module.module
168	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	138	t	module_auth_password_policy	base	ir.module.module
169	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	139	t	module_auth_password_policy_portal	base	ir.module.module
170	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	140	t	module_auth_password_policy_signup	base	ir.module.module
171	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	141	t	module_auth_saml	base	ir.module.module
172	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	142	t	module_auth_session_timeout	base	ir.module.module
173	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	143	t	module_auth_signup	base	ir.module.module
174	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	26	t	module_category_authentication	base	ir.module.category
175	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	144	t	module_auth_signup_verify_email	base	ir.module.module
176	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	27	t	module_category_extra_tools	base	ir.module.category
177	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	145	t	module_auth_totp	base	ir.module.module
178	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	146	t	module_auth_totp_mail	base	ir.module.module
179	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	147	t	module_auth_totp_mail_enforce	base	ir.module.module
180	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	148	t	module_auth_totp_portal	base	ir.module.module
181	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	149	t	module_auth_user_case_insensitive	base	ir.module.module
182	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	150	t	module_auto_backup	base	ir.module.module
183	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	151	t	module_autovacuum_message_attachment	base	ir.module.module
184	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	152	t	module_barcode_action	base	ir.module.module
185	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	153	t	module_barcodes	base	ir.module.module
186	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	154	t	module_barcodes_gs1_nomenclature	base	ir.module.module
187	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	155	t	module_base	base	ir.module.module
188	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	156	t	module_base_address_extended	base	ir.module.module
189	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	28	t	module_category_sales_sales	base	ir.module.category
190	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	157	t	module_base_automation	base	ir.module.module
191	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	158	t	module_base_cancel_confirm	base	ir.module.module
192	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	159	t	module_base_comment_template	base	ir.module.module
193	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	160	t	module_base_cron_exclusion	base	ir.module.module
194	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	161	t	module_base_custom_filter	base	ir.module.module
195	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	162	t	module_base_exception	base	ir.module.module
196	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	29	t	module_category_personalization	base	ir.module.category
197	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	163	t	module_base_export_manager	base	ir.module.module
198	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	164	t	module_base_external_dbsource	base	ir.module.module
199	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	165	t	module_base_fontawesome	base	ir.module.module
200	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	166	t	module_base_fontawesome_web_editor	base	ir.module.module
201	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	167	t	module_base_force_record_noupdate	base	ir.module.module
202	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	168	t	module_base_geolocalize	base	ir.module.module
203	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	169	t	module_base_global_discount	base	ir.module.module
204	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	170	t	module_base_iban	base	ir.module.module
205	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	171	t	module_base_import	base	ir.module.module
206	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	172	t	module_base_import_module	base	ir.module.module
207	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	30	t	module_category_server_tools	base	ir.module.category
208	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	173	t	module_base_import_security_group	base	ir.module.module
209	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	174	t	module_base_install_request	base	ir.module.module
210	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	31	t	module_category_technical_settings	base	ir.module.category
211	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	175	t	module_base_m2m_custom_field	base	ir.module.module
212	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	176	t	module_base_menu_visibility_restriction	base	ir.module.module
213	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	32	t	module_category_others	base	ir.module.category
214	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	177	t	module_base_model_restrict_update	base	ir.module.module
215	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	178	t	module_base_name_search_improved	base	ir.module.module
216	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	179	t	module_base_optional_quick_create	base	ir.module.module
217	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	180	t	module_base_partition	base	ir.module.module
218	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	33	t	module_category_generic_modules_base	base	ir.module.category
219	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	181	t	module_base_remote	base	ir.module.module
220	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	182	t	module_base_revision	base	ir.module.module
221	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	183	t	module_base_search_custom_field_filter	base	ir.module.module
222	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	184	t	module_base_search_fuzzy	base	ir.module.module
223	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	185	t	module_base_sequence_option	base	ir.module.module
224	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	186	t	module_base_setup	base	ir.module.module
225	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	187	t	module_base_sparse_field	base	ir.module.module
226	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	188	t	module_base_sparse_field_list_support	base	ir.module.module
227	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	189	t	module_base_substate	base	ir.module.module
228	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	190	t	module_base_technical_features	base	ir.module.module
229	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	34	t	module_category_hidden_dependency	base	ir.module.category
230	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	191	t	module_base_technical_user	base	ir.module.module
231	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	192	t	module_base_temporary_action	base	ir.module.module
232	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	193	t	module_base_tier_validation	base	ir.module.module
233	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	194	t	module_base_tier_validation_correction	base	ir.module.module
234	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	195	t	module_base_tier_validation_formula	base	ir.module.module
235	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	196	t	module_base_tier_validation_forward	base	ir.module.module
236	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	197	t	module_base_tier_validation_server_action	base	ir.module.module
237	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	198	t	module_base_time_window	base	ir.module.module
238	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	199	t	module_base_transaction_id	base	ir.module.module
239	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	200	t	module_base_user_empty_password	base	ir.module.module
240	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	201	t	module_base_user_role	base	ir.module.module
241	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	202	t	module_base_user_role_company	base	ir.module.module
242	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	203	t	module_base_user_show_email	base	ir.module.module
243	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	204	t	module_base_vat	base	ir.module.module
244	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	205	t	module_base_view_inheritance_extension	base	ir.module.module
245	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	206	t	module_base_warn_option	base	ir.module.module
246	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	207	t	module_bi_sql_editor	base	ir.module.module
247	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	35	t	module_category_productivity	base	ir.module.category
248	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	208	t	module_board	base	ir.module.module
249	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	209	t	module_bus	base	ir.module.module
250	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	210	t	module_bus_alt_connection	base	ir.module.module
251	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	36	t	module_category_productivity_calendar	base	ir.module.category
252	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	211	t	module_calendar	base	ir.module.module
253	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	212	t	module_calendar_sms	base	ir.module.module
254	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	213	t	module_certificate	base	ir.module.module
255	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	214	t	module_chained_swapper	base	ir.module.module
256	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	215	t	module_cloud_storage	base	ir.module.module
257	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	216	t	module_cloud_storage_azure	base	ir.module.module
258	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	217	t	module_cloud_storage_google	base	ir.module.module
259	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	218	t	module_cloud_storage_migration	base	ir.module.module
260	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	37	t	module_category_sales_crm	base	ir.module.category
261	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	219	t	module_contacts	base	ir.module.module
262	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	220	t	module_crm	base	ir.module.module
263	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	221	t	module_crm_iap_enrich	base	ir.module.module
264	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	222	t	module_crm_iap_mine	base	ir.module.module
265	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	223	t	module_crm_livechat	base	ir.module.module
266	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	224	t	module_crm_mail_plugin	base	ir.module.module
267	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	225	t	module_crm_operating_unit	base	ir.module.module
268	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	226	t	module_crm_sms	base	ir.module.module
269	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	227	t	module_data_encryption	base	ir.module.module
270	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	38	t	module_category_productivity_data_cleaning	base	ir.module.category
271	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	228	t	module_data_recycle	base	ir.module.module
272	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	229	t	module_database_cleanup	base	ir.module.module
273	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	230	t	module_database_size	base	ir.module.module
274	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	231	t	module_date_range	base	ir.module.module
275	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	232	t	module_date_range_account	base	ir.module.module
276	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	233	t	module_dbfilter_from_header	base	ir.module.module
277	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	234	t	module_default_multi_user	base	ir.module.module
278	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	39	t	module_category_sales_delivery	base	ir.module.category
279	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	235	t	module_delivery	base	ir.module.module
280	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	40	t	module_category_inventory	base	ir.module.category
281	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	41	t	module_category_inventory_delivery	base	ir.module.category
282	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	236	t	module_delivery_mondialrelay	base	ir.module.module
283	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	237	t	module_delivery_stock_picking_batch	base	ir.module.module
284	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	238	t	module_developer_menu	base	ir.module.module
285	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	42	t	module_category_marketing	base	ir.module.category
286	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	239	t	module_digest	base	ir.module.module
287	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	240	t	module_disable_odoo_online	base	ir.module.module
288	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	241	t	module_document_quick_access	base	ir.module.module
289	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	242	t	module_document_quick_access_folder_auto_classification	base	ir.module.module
290	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	43	t	module_category_marketing_events	base	ir.module.category
291	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	243	t	module_event	base	ir.module.module
292	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	244	t	module_event_booth	base	ir.module.module
293	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	245	t	module_event_booth_sale	base	ir.module.module
294	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	246	t	module_event_crm	base	ir.module.module
295	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	247	t	module_event_crm_sale	base	ir.module.module
296	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	248	t	module_event_product	base	ir.module.module
297	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	249	t	module_event_sale	base	ir.module.module
298	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	250	t	module_event_sms	base	ir.module.module
299	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	251	t	module_excel_import_export	base	ir.module.module
300	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	252	t	module_fetchmail_attach_from_folder	base	ir.module.module
301	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	253	t	module_fetchmail_notify_error_to_sender	base	ir.module.module
302	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	254	t	module_filter_multi_user	base	ir.module.module
303	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	44	t	module_category_human_resources	base	ir.module.category
304	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	45	t	module_category_human_resources_fleet	base	ir.module.category
305	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	255	t	module_fleet	base	ir.module.module
306	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	256	t	module_gamification	base	ir.module.module
307	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	257	t	module_gamification_sale_crm	base	ir.module.module
308	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	258	t	module_google_account	base	ir.module.module
309	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	259	t	module_google_calendar	base	ir.module.module
310	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	260	t	module_google_gmail	base	ir.module.module
311	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	261	t	module_google_recaptcha	base	ir.module.module
312	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	46	t	module_category_human_resources_employees	base	ir.module.category
313	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	262	t	module_hr	base	ir.module.module
314	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	263	t	module_hr_appraisal_oca	base	ir.module.module
315	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	47	t	module_category_human_resources_attendances	base	ir.module.category
316	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	264	t	module_hr_attendance	base	ir.module.module
317	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	265	t	module_hr_calendar	base	ir.module.module
318	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	48	t	module_category_human_resources_contracts	base	ir.module.category
319	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	266	t	module_hr_contract	base	ir.module.module
320	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	267	t	module_hr_contract_employee_calendar_planning	base	ir.module.module
321	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	49	t	module_category_generic_modules_human_resources	base	ir.module.category
322	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	268	t	module_hr_contract_reference	base	ir.module.module
323	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	269	t	module_hr_contract_renew	base	ir.module.module
324	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	270	t	module_hr_course	base	ir.module.module
325	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	271	t	module_hr_department_code	base	ir.module.module
326	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	272	t	module_hr_employee_age	base	ir.module.module
327	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	273	t	module_hr_employee_birthday_mail	base	ir.module.module
328	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	274	t	module_hr_employee_calendar_planning	base	ir.module.module
329	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	275	t	module_hr_employee_firstname	base	ir.module.module
330	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	276	t	module_hr_employee_id	base	ir.module.module
331	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	277	t	module_hr_employee_language	base	ir.module.module
332	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	278	t	module_hr_employee_medical_examination	base	ir.module.module
333	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	279	t	module_hr_employee_partner_external	base	ir.module.module
334	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	280	t	module_hr_employee_phone_extension	base	ir.module.module
335	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	281	t	module_hr_employee_ppe	base	ir.module.module
336	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	282	t	module_hr_employee_relative	base	ir.module.module
337	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	283	t	module_hr_employee_second_lastname	base	ir.module.module
338	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	284	t	module_hr_employee_service	base	ir.module.module
339	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	285	t	module_hr_employee_service_contract	base	ir.module.module
340	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	286	t	module_hr_employee_ssn	base	ir.module.module
341	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	50	t	module_category_human_resources_expenses	base	ir.module.category
342	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	287	t	module_hr_expense	base	ir.module.module
343	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	288	t	module_hr_expense_advance_clearing	base	ir.module.module
344	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	289	t	module_hr_expense_advance_clearing_sequence	base	ir.module.module
345	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	290	t	module_hr_expense_analytic_tag	base	ir.module.module
346	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	291	t	module_hr_expense_cancel	base	ir.module.module
347	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	292	t	module_hr_expense_invoice	base	ir.module.module
348	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	293	t	module_hr_expense_payment	base	ir.module.module
349	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	294	t	module_hr_expense_sequence	base	ir.module.module
350	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	295	t	module_hr_expense_tier_validation	base	ir.module.module
351	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	296	t	module_hr_fleet	base	ir.module.module
352	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	297	t	module_hr_gamification	base	ir.module.module
353	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	51	t	module_category_human_resources_time_off	base	ir.module.category
354	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	298	t	module_hr_holidays	base	ir.module.module
355	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	299	t	module_hr_holidays_attendance	base	ir.module.module
356	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	300	t	module_hr_holidays_contract	base	ir.module.module
357	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	52	t	module_category_human_resources_remote_work	base	ir.module.category
358	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	301	t	module_hr_homeworking	base	ir.module.module
359	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	302	t	module_hr_homeworking_calendar	base	ir.module.module
360	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	53	t	module_category_services	base	ir.module.category
361	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	54	t	module_category_services_employee_hourly_cost	base	ir.module.category
362	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	303	t	module_hr_hourly_cost	base	ir.module.module
363	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	304	t	module_hr_job_category	base	ir.module.module
364	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	305	t	module_hr_livechat	base	ir.module.module
365	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	306	t	module_hr_maintenance	base	ir.module.module
366	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	307	t	module_hr_org_chart	base	ir.module.module
367	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	308	t	module_hr_personal_equipment_request	base	ir.module.module
368	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	309	t	module_hr_presence	base	ir.module.module
369	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	310	t	module_hr_professional_category	base	ir.module.module
370	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	55	t	module_category_human_resources_recruitment	base	ir.module.category
371	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	311	t	module_hr_recruitment	base	ir.module.module
372	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	312	t	module_hr_recruitment_skills	base	ir.module.module
373	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	313	t	module_hr_recruitment_sms	base	ir.module.module
374	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	314	t	module_hr_recruitment_survey	base	ir.module.module
375	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	315	t	module_hr_skills	base	ir.module.module
376	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	316	t	module_hr_skills_slides	base	ir.module.module
377	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	317	t	module_hr_skills_survey	base	ir.module.module
378	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	56	t	module_category_services_timesheets	base	ir.module.category
379	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	318	t	module_hr_timesheet	base	ir.module.module
380	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	319	t	module_hr_timesheet_analytic_tag	base	ir.module.module
381	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	320	t	module_hr_timesheet_attendance	base	ir.module.module
382	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	321	t	module_hr_work_entry	base	ir.module.module
383	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	322	t	module_hr_work_entry_contract	base	ir.module.module
384	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	57	t	module_category_human_resources_payroll	base	ir.module.category
385	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	323	t	module_hr_work_entry_holidays	base	ir.module.module
386	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	324	t	module_html_editor	base	ir.module.module
387	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	325	t	module_html_text	base	ir.module.module
388	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	326	t	module_http_routing	base	ir.module.module
389	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	327	t	module_hw_drivers	base	ir.module.module
390	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	58	t	module_category_sales_point_of_sale	base	ir.module.category
391	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	328	t	module_hw_escpos	base	ir.module.module
392	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	329	t	module_hw_posbox_homepage	base	ir.module.module
393	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	330	t	module_iap	base	ir.module.module
394	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	331	t	module_iap_alternative_provider	base	ir.module.module
395	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	332	t	module_iap_crm	base	ir.module.module
396	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	333	t	module_iap_mail	base	ir.module.module
397	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	59	t	module_category_website	base	ir.module.category
398	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	60	t	module_category_website_live_chat	base	ir.module.category
399	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	334	t	module_im_livechat	base	ir.module.module
400	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	335	t	module_impersonate_login	base	ir.module.module
401	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	336	t	module_jsonifier	base	ir.module.module
402	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	61	t	module_category_hidden_tests	base	ir.module.category
403	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	337	t	module_l10n_account_edi_ubl_cii_tests	base	ir.module.module
404	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	62	t	module_category_accounting_localizations	base	ir.module.category
405	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	338	t	module_l10n_account_withholding_tax	base	ir.module.module
406	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	339	t	module_l10n_account_withholding_tax_pos	base	ir.module.module
407	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	63	t	module_category_accounting_localizations_account_charts	base	ir.module.category
408	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	340	t	module_l10n_ae	base	ir.module.module
409	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	64	t	module_category_accounting_localizations_edi	base	ir.module.category
410	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	341	t	module_l10n_anz_ubl_pint	base	ir.module.module
411	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	342	t	module_l10n_ar	base	ir.module.module
412	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	65	t	module_category_accounting_localizations_point_of_sale	base	ir.module.category
413	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	343	t	module_l10n_ar_pos	base	ir.module.module
414	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	66	t	module_category_accounting_localizations_website	base	ir.module.category
415	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	344	t	module_l10n_ar_website_sale	base	ir.module.module
416	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	345	t	module_l10n_ar_withholding	base	ir.module.module
417	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	346	t	module_l10n_at	base	ir.module.module
418	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	347	t	module_l10n_au	base	ir.module.module
419	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	348	t	module_l10n_bd	base	ir.module.module
420	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	349	t	module_l10n_be	base	ir.module.module
421	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	67	t	module_category_localization	base	ir.module.category
422	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	68	t	module_category_localization_point_of_sale	base	ir.module.category
423	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	350	t	module_l10n_be_pos_restaurant	base	ir.module.module
424	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	351	t	module_l10n_be_pos_sale	base	ir.module.module
425	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	352	t	module_l10n_bf	base	ir.module.module
426	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	353	t	module_l10n_bg	base	ir.module.module
427	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	354	t	module_l10n_bg_ledger	base	ir.module.module
428	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	355	t	module_l10n_bh	base	ir.module.module
429	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	356	t	module_l10n_bj	base	ir.module.module
430	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	357	t	module_l10n_bo	base	ir.module.module
431	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	358	t	module_l10n_br	base	ir.module.module
432	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	359	t	module_l10n_br_sales	base	ir.module.module
433	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	360	t	module_l10n_br_website_sale	base	ir.module.module
434	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	361	t	module_l10n_ca	base	ir.module.module
435	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	362	t	module_l10n_cd	base	ir.module.module
436	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	363	t	module_l10n_cf	base	ir.module.module
437	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	364	t	module_l10n_cg	base	ir.module.module
438	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	365	t	module_l10n_ch	base	ir.module.module
439	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	366	t	module_l10n_ch_pos	base	ir.module.module
440	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	367	t	module_l10n_ci	base	ir.module.module
441	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	368	t	module_l10n_cl	base	ir.module.module
442	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	369	t	module_l10n_cm	base	ir.module.module
443	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	370	t	module_l10n_cn	base	ir.module.module
444	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	371	t	module_l10n_cn_city	base	ir.module.module
445	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	372	t	module_l10n_co	base	ir.module.module
446	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	373	t	module_l10n_co_pos	base	ir.module.module
447	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	374	t	module_l10n_cr	base	ir.module.module
448	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	375	t	module_l10n_cy	base	ir.module.module
449	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	376	t	module_l10n_cz	base	ir.module.module
450	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	377	t	module_l10n_de	base	ir.module.module
451	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	378	t	module_l10n_din5008	base	ir.module.module
452	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	379	t	module_l10n_din5008_expense	base	ir.module.module
453	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	380	t	module_l10n_din5008_purchase	base	ir.module.module
454	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	381	t	module_l10n_din5008_repair	base	ir.module.module
455	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	382	t	module_l10n_din5008_sale	base	ir.module.module
456	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	383	t	module_l10n_din5008_stock	base	ir.module.module
457	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	384	t	module_l10n_dk	base	ir.module.module
458	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	385	t	module_l10n_dk_nemhandel	base	ir.module.module
459	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	386	t	module_l10n_dk_oioubl	base	ir.module.module
460	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	387	t	module_l10n_do	base	ir.module.module
461	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	388	t	module_l10n_dz	base	ir.module.module
462	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	389	t	module_l10n_ec	base	ir.module.module
463	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	390	t	module_l10n_ec_stock	base	ir.module.module
464	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	391	t	module_l10n_ec_website_sale	base	ir.module.module
465	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	392	t	module_l10n_ee	base	ir.module.module
466	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	393	t	module_l10n_eg	base	ir.module.module
467	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	394	t	module_l10n_eg_edi_eta	base	ir.module.module
468	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	395	t	module_l10n_es	base	ir.module.module
469	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	396	t	module_l10n_es_edi_facturae	base	ir.module.module
470	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	397	t	module_l10n_es_edi_sii	base	ir.module.module
471	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	398	t	module_l10n_es_edi_tbai	base	ir.module.module
472	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	399	t	module_l10n_es_edi_tbai_pos	base	ir.module.module
473	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	400	t	module_l10n_es_edi_verifactu	base	ir.module.module
474	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	401	t	module_l10n_es_edi_verifactu_pos	base	ir.module.module
475	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	402	t	module_l10n_es_modelo130	base	ir.module.module
476	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	403	t	module_l10n_es_pos	base	ir.module.module
477	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	404	t	module_l10n_et	base	ir.module.module
478	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	405	t	module_l10n_eu_oss	base	ir.module.module
479	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	406	t	module_l10n_fi	base	ir.module.module
480	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	407	t	module_l10n_fi_sale	base	ir.module.module
481	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	408	t	module_l10n_fr	base	ir.module.module
482	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	409	t	module_l10n_fr_account	base	ir.module.module
483	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	410	t	module_l10n_fr_facturx_chorus_pro	base	ir.module.module
484	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	411	t	module_l10n_fr_hr_holidays	base	ir.module.module
485	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	412	t	module_l10n_fr_hr_work_entry_holidays	base	ir.module.module
486	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	413	t	module_l10n_fr_pos_cert	base	ir.module.module
487	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	414	t	module_l10n_ga	base	ir.module.module
488	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	415	t	module_l10n_gcc_invoice	base	ir.module.module
489	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	416	t	module_l10n_gcc_invoice_stock_account	base	ir.module.module
490	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	417	t	module_l10n_gcc_pos	base	ir.module.module
491	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	418	t	module_l10n_gn	base	ir.module.module
492	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	419	t	module_l10n_gq	base	ir.module.module
493	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	420	t	module_l10n_gr	base	ir.module.module
494	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	421	t	module_l10n_gr_edi	base	ir.module.module
495	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	422	t	module_l10n_gt	base	ir.module.module
496	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	423	t	module_l10n_gw	base	ir.module.module
497	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	424	t	module_l10n_hk	base	ir.module.module
498	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	425	t	module_l10n_hn	base	ir.module.module
499	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	426	t	module_l10n_hr	base	ir.module.module
500	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	69	t	module_category_accounting_localizations_reporting	base	ir.module.category
501	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	427	t	module_l10n_hr_edi	base	ir.module.module
502	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	428	t	module_l10n_hr_kuna	base	ir.module.module
503	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	429	t	module_l10n_hu	base	ir.module.module
504	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	430	t	module_l10n_hu_edi	base	ir.module.module
505	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	431	t	module_l10n_id	base	ir.module.module
506	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	432	t	module_l10n_id_efaktur	base	ir.module.module
507	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	433	t	module_l10n_id_efaktur_coretax	base	ir.module.module
508	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	434	t	module_l10n_id_pos	base	ir.module.module
509	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	435	t	module_l10n_ie	base	ir.module.module
510	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	436	t	module_l10n_il	base	ir.module.module
511	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	437	t	module_l10n_in	base	ir.module.module
512	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	438	t	module_l10n_in_edi	base	ir.module.module
513	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	439	t	module_l10n_in_edi_ewaybill	base	ir.module.module
514	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	440	t	module_l10n_in_ewaybill_port	base	ir.module.module
515	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	441	t	module_l10n_in_ewaybill_stock	base	ir.module.module
516	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	442	t	module_l10n_in_gstin_status	base	ir.module.module
517	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	443	t	module_l10n_in_hr_holidays	base	ir.module.module
518	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	444	t	module_l10n_in_pos	base	ir.module.module
519	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	70	t	module_category_accounting_localizations_purchase	base	ir.module.category
520	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	445	t	module_l10n_in_purchase	base	ir.module.module
521	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	446	t	module_l10n_in_purchase_stock	base	ir.module.module
522	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	71	t	module_category_accounting_localizations_sale	base	ir.module.category
523	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	447	t	module_l10n_in_sale	base	ir.module.module
524	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	448	t	module_l10n_in_sale_stock	base	ir.module.module
525	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	449	t	module_l10n_in_stock	base	ir.module.module
526	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	450	t	module_l10n_in_withholding	base	ir.module.module
527	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	451	t	module_l10n_in_withholding_payment	base	ir.module.module
528	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	452	t	module_l10n_iq	base	ir.module.module
529	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	453	t	module_l10n_it	base	ir.module.module
530	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	454	t	module_l10n_it_edi	base	ir.module.module
531	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	455	t	module_l10n_it_edi_doi	base	ir.module.module
532	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	456	t	module_l10n_it_edi_ndd	base	ir.module.module
533	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	457	t	module_l10n_it_edi_ndd_account_dn	base	ir.module.module
534	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	458	t	module_l10n_it_edi_sale	base	ir.module.module
535	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	459	t	module_l10n_it_edi_website_sale	base	ir.module.module
536	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	460	t	module_l10n_it_edi_withholding	base	ir.module.module
537	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	461	t	module_l10n_it_stock_ddt	base	ir.module.module
538	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	462	t	module_l10n_jo	base	ir.module.module
539	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	463	t	module_l10n_jo_edi	base	ir.module.module
540	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	464	t	module_l10n_jo_edi_extended	base	ir.module.module
541	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	465	t	module_l10n_jp	base	ir.module.module
542	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	466	t	module_l10n_jp_ubl_pint	base	ir.module.module
543	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	467	t	module_l10n_ke	base	ir.module.module
544	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	468	t	module_l10n_ke_edi_tremol	base	ir.module.module
545	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	469	t	module_l10n_kh	base	ir.module.module
546	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	470	t	module_l10n_km	base	ir.module.module
547	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	471	t	module_l10n_kr	base	ir.module.module
548	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	472	t	module_l10n_kw	base	ir.module.module
549	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	473	t	module_l10n_kz	base	ir.module.module
550	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	474	t	module_l10n_latam_base	base	ir.module.module
551	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	475	t	module_l10n_latam_check	base	ir.module.module
552	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	476	t	module_l10n_latam_invoice_document	base	ir.module.module
553	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	477	t	module_l10n_lb_account	base	ir.module.module
554	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	478	t	module_l10n_lt	base	ir.module.module
555	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	479	t	module_l10n_lu	base	ir.module.module
556	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	480	t	module_l10n_lv	base	ir.module.module
557	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	481	t	module_l10n_ma	base	ir.module.module
558	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	482	t	module_l10n_mc	base	ir.module.module
559	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	483	t	module_l10n_ml	base	ir.module.module
560	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	484	t	module_l10n_mn	base	ir.module.module
561	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	485	t	module_l10n_mr	base	ir.module.module
562	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	486	t	module_l10n_mt	base	ir.module.module
563	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	487	t	module_l10n_mt_pos	base	ir.module.module
564	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	488	t	module_l10n_mu_account	base	ir.module.module
565	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	489	t	module_l10n_mx	base	ir.module.module
566	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	490	t	module_l10n_mx_hr	base	ir.module.module
567	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	491	t	module_l10n_my	base	ir.module.module
568	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	492	t	module_l10n_my_edi	base	ir.module.module
569	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	493	t	module_l10n_my_edi_extended	base	ir.module.module
570	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	494	t	module_l10n_my_edi_pos	base	ir.module.module
571	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	495	t	module_l10n_my_ubl_pint	base	ir.module.module
572	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	496	t	module_l10n_mz	base	ir.module.module
573	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	497	t	module_l10n_ne	base	ir.module.module
574	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	498	t	module_l10n_ng	base	ir.module.module
575	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	499	t	module_l10n_nl	base	ir.module.module
576	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	500	t	module_l10n_no	base	ir.module.module
577	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	501	t	module_l10n_nz	base	ir.module.module
578	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	502	t	module_l10n_om	base	ir.module.module
579	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	503	t	module_l10n_pa	base	ir.module.module
580	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	504	t	module_l10n_pe	base	ir.module.module
581	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	505	t	module_l10n_pe_pos	base	ir.module.module
582	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	506	t	module_l10n_pe_website_sale	base	ir.module.module
583	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	507	t	module_l10n_ph	base	ir.module.module
584	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	508	t	module_l10n_pk	base	ir.module.module
585	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	509	t	module_l10n_pl	base	ir.module.module
586	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	510	t	module_l10n_pl_taxable_supply_date	base	ir.module.module
587	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	511	t	module_l10n_pt	base	ir.module.module
588	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	512	t	module_l10n_qa	base	ir.module.module
589	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	513	t	module_l10n_ro	base	ir.module.module
590	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	514	t	module_l10n_ro_edi	base	ir.module.module
591	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	515	t	module_l10n_ro_edi_stock	base	ir.module.module
592	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	516	t	module_l10n_ro_edi_stock_batch	base	ir.module.module
593	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	517	t	module_l10n_ro_efactura_synchronize	base	ir.module.module
594	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	518	t	module_l10n_rs	base	ir.module.module
595	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	519	t	module_l10n_rs_edi	base	ir.module.module
596	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	520	t	module_l10n_rw	base	ir.module.module
597	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	521	t	module_l10n_sa	base	ir.module.module
598	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	522	t	module_l10n_sa_edi	base	ir.module.module
599	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	523	t	module_l10n_sa_edi_pos	base	ir.module.module
600	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	524	t	module_l10n_sa_pos	base	ir.module.module
601	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	525	t	module_l10n_se	base	ir.module.module
602	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	526	t	module_l10n_sg	base	ir.module.module
603	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	527	t	module_l10n_sg_ubl_pint	base	ir.module.module
604	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	528	t	module_l10n_si	base	ir.module.module
605	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	529	t	module_l10n_sk	base	ir.module.module
606	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	530	t	module_l10n_sn	base	ir.module.module
607	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	531	t	module_l10n_syscohada	base	ir.module.module
608	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	532	t	module_l10n_td	base	ir.module.module
609	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	533	t	module_l10n_test_pos_qr_payment	base	ir.module.module
610	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	534	t	module_l10n_tg	base	ir.module.module
611	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	535	t	module_l10n_th	base	ir.module.module
612	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	536	t	module_l10n_th_account_tax	base	ir.module.module
613	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	537	t	module_l10n_th_account_tax_report	base	ir.module.module
614	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	72	t	module_category_report	base	ir.module.category
615	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	538	t	module_l10n_th_account_wht_cert_form	base	ir.module.module
616	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	539	t	module_l10n_th_amount_to_text	base	ir.module.module
617	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	540	t	module_l10n_th_base_sequence	base	ir.module.module
618	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	541	t	module_l10n_th_base_utils	base	ir.module.module
619	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	542	t	module_l10n_th_mis_report	base	ir.module.module
620	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	73	t	module_category_localization_asia	base	ir.module.category
621	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	543	t	module_l10n_th_partner	base	ir.module.module
622	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	74	t	module_category_localization___tools	base	ir.module.category
623	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	544	t	module_l10n_th_tier_department	base	ir.module.module
624	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	545	t	module_l10n_th_tier_department_demo	base	ir.module.module
625	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	546	t	module_l10n_tn	base	ir.module.module
626	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	547	t	module_l10n_tr	base	ir.module.module
627	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	548	t	module_l10n_tr_nilvera	base	ir.module.module
628	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	549	t	module_l10n_tr_nilvera_edispatch	base	ir.module.module
629	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	550	t	module_l10n_tr_nilvera_einvoice	base	ir.module.module
630	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	551	t	module_l10n_tr_nilvera_einvoice_extended	base	ir.module.module
631	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	552	t	module_l10n_tw	base	ir.module.module
632	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	553	t	module_l10n_tw_edi_ecpay	base	ir.module.module
633	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	75	t	module_category_website_sale	base	ir.module.category
634	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	76	t	module_category_website_sale_localizations	base	ir.module.category
635	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	77	t	module_category_website_sale_localizations_edi	base	ir.module.category
636	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	554	t	module_l10n_tw_edi_ecpay_website_sale	base	ir.module.module
637	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	555	t	module_l10n_tz_account	base	ir.module.module
638	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	556	t	module_l10n_ua	base	ir.module.module
639	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	557	t	module_l10n_ug	base	ir.module.module
640	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	558	t	module_l10n_uk	base	ir.module.module
641	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	559	t	module_l10n_us	base	ir.module.module
642	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	560	t	module_l10n_us_account	base	ir.module.module
643	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	561	t	module_l10n_uy	base	ir.module.module
644	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	562	t	module_l10n_uy_pos	base	ir.module.module
645	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	563	t	module_l10n_uy_website_sale	base	ir.module.module
646	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	564	t	module_l10n_ve	base	ir.module.module
647	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	565	t	module_l10n_vn	base	ir.module.module
648	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	566	t	module_l10n_vn_edi_viettel	base	ir.module.module
649	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	567	t	module_l10n_za	base	ir.module.module
650	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	568	t	module_l10n_zm_account	base	ir.module.module
651	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	569	t	module_link_tracker	base	ir.module.module
652	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	570	t	module_loyalty	base	ir.module.module
653	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	78	t	module_category_human_resources_lunch	base	ir.module.category
654	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	571	t	module_lunch	base	ir.module.module
655	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	79	t	module_category_productivity_discuss	base	ir.module.category
656	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	572	t	module_mail	base	ir.module.module
657	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	573	t	module_mail_bot	base	ir.module.module
658	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	574	t	module_mail_bot_hr	base	ir.module.module
659	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	575	t	module_mail_cleanup	base	ir.module.module
660	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	576	t	module_mail_environment	base	ir.module.module
661	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	577	t	module_mail_environment_google_gmail	base	ir.module.module
662	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	578	t	module_mail_group	base	ir.module.module
663	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	579	t	module_mail_message_destiny_link_template	base	ir.module.module
664	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	580	t	module_mail_plugin	base	ir.module.module
665	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	80	t	module_category_manufacturing	base	ir.module.category
666	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	81	t	module_category_manufacturing_maintenance	base	ir.module.category
667	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	581	t	module_maintenance	base	ir.module.module
668	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	82	t	module_category_marketing_social_marketing	base	ir.module.category
669	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	582	t	module_marketing_card	base	ir.module.module
670	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	83	t	module_category_marketing_email_marketing	base	ir.module.category
671	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	583	t	module_mass_mailing	base	ir.module.module
672	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	584	t	module_mass_mailing_crm	base	ir.module.module
673	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	585	t	module_mass_mailing_crm_sms	base	ir.module.module
674	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	586	t	module_mass_mailing_event	base	ir.module.module
675	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	587	t	module_mass_mailing_event_sms	base	ir.module.module
676	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	588	t	module_mass_mailing_event_track	base	ir.module.module
677	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	589	t	module_mass_mailing_event_track_sms	base	ir.module.module
678	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	590	t	module_mass_mailing_sale	base	ir.module.module
679	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	591	t	module_mass_mailing_sale_sms	base	ir.module.module
680	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	592	t	module_mass_mailing_slides	base	ir.module.module
681	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	593	t	module_mass_mailing_sms	base	ir.module.module
682	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	594	t	module_mass_mailing_themes	base	ir.module.module
683	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	595	t	module_membership	base	ir.module.module
684	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	596	t	module_microsoft_account	base	ir.module.module
685	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	597	t	module_microsoft_calendar	base	ir.module.module
686	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	598	t	module_microsoft_outlook	base	ir.module.module
687	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	599	t	module_mis_builder	base	ir.module.module
688	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	600	t	module_mis_builder_budget	base	ir.module.module
689	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	601	t	module_mis_builder_cash_flow	base	ir.module.module
690	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	602	t	module_mis_builder_demo	base	ir.module.module
691	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	603	t	module_mis_template_financial_report	base	ir.module.module
692	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	604	t	module_module_analysis	base	ir.module.module
693	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	605	t	module_module_auto_update	base	ir.module.module
694	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	606	t	module_module_change_auto_install	base	ir.module.module
695	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	84	t	module_category_manufacturing_manufacturing	base	ir.module.category
696	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	607	t	module_mrp	base	ir.module.module
697	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	608	t	module_mrp_account	base	ir.module.module
698	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	609	t	module_mrp_landed_costs	base	ir.module.module
699	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	610	t	module_mrp_operating_unit	base	ir.module.module
700	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	611	t	module_mrp_product_expiry	base	ir.module.module
701	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	85	t	module_category_inventory_inventory	base	ir.module.category
702	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	612	t	module_mrp_repair	base	ir.module.module
703	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	613	t	module_mrp_subcontracting	base	ir.module.module
704	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	614	t	module_mrp_subcontracting_account	base	ir.module.module
705	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	86	t	module_category_inventory_purchase	base	ir.module.category
706	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	615	t	module_mrp_subcontracting_dropshipping	base	ir.module.module
707	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	616	t	module_mrp_subcontracting_landed_costs	base	ir.module.module
708	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	87	t	module_category_manufacturing_purchase	base	ir.module.category
709	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	617	t	module_mrp_subcontracting_purchase	base	ir.module.module
710	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	88	t	module_category_manufacturing_repair	base	ir.module.category
711	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	618	t	module_mrp_subcontracting_repair	base	ir.module.module
712	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	619	t	module_multi_step_wizard	base	ir.module.module
713	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	620	t	module_onboarding	base	ir.module.module
714	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	621	t	module_onchange_helper	base	ir.module.module
715	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	622	t	module_operating_unit	base	ir.module.module
716	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	623	t	module_operating_unit_access_all	base	ir.module.module
717	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	624	t	module_partner_autocomplete	base	ir.module.module
718	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	625	t	module_partner_invoicing_mode	base	ir.module.module
719	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	626	t	module_partner_invoicing_mode_at_shipping	base	ir.module.module
720	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	627	t	module_partner_invoicing_mode_monthly	base	ir.module.module
721	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	628	t	module_partner_statement	base	ir.module.module
722	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	89	t	module_category_purchase_management	base	ir.module.category
723	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	629	t	module_partner_supplierinfo_smartbutton	base	ir.module.module
724	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	630	t	module_password_security	base	ir.module.module
725	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	631	t	module_payment	base	ir.module.module
726	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	90	t	module_category_accounting_payment_providers	base	ir.module.category
727	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	632	t	module_payment_adyen	base	ir.module.module
728	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	633	t	module_payment_aps	base	ir.module.module
729	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	634	t	module_payment_asiapay	base	ir.module.module
730	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	635	t	module_payment_authorize	base	ir.module.module
731	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	636	t	module_payment_buckaroo	base	ir.module.module
732	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	637	t	module_payment_custom	base	ir.module.module
733	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	638	t	module_payment_demo	base	ir.module.module
734	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	639	t	module_payment_flutterwave	base	ir.module.module
735	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	640	t	module_payment_mercado_pago	base	ir.module.module
736	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	641	t	module_payment_mollie	base	ir.module.module
737	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	642	t	module_payment_nuvei	base	ir.module.module
738	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	643	t	module_payment_paypal	base	ir.module.module
739	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	644	t	module_payment_razorpay	base	ir.module.module
740	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	645	t	module_payment_razorpay_oauth	base	ir.module.module
741	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	646	t	module_payment_stripe	base	ir.module.module
742	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	647	t	module_payment_worldline	base	ir.module.module
743	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	648	t	module_payment_xendit	base	ir.module.module
744	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	649	t	module_pdf_xml_attachment	base	ir.module.module
745	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	650	t	module_phone_validation	base	ir.module.module
746	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	651	t	module_point_of_sale	base	ir.module.module
747	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	652	t	module_portal	base	ir.module.module
748	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	653	t	module_portal_account_personal_data_only	base	ir.module.module
749	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	654	t	module_portal_odoo_debranding	base	ir.module.module
750	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	655	t	module_portal_rating	base	ir.module.module
751	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	656	t	module_pos_account_tax_python	base	ir.module.module
752	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	657	t	module_pos_adyen	base	ir.module.module
753	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	91	t	module_category_point_of_sale,_accounting	base	ir.module.category
754	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	658	t	module_pos_analytic_by_config	base	ir.module.module
755	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	659	t	module_pos_discount	base	ir.module.module
756	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	660	t	module_pos_epson_printer	base	ir.module.module
757	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	92	t	module_category_technical	base	ir.module.category
758	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	661	t	module_pos_event	base	ir.module.module
759	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	662	t	module_pos_event_sale	base	ir.module.module
760	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	663	t	module_pos_hr	base	ir.module.module
3899	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	78	f	lang_es_PA	base	res.lang
761	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	664	t	module_pos_hr_restaurant	base	ir.module.module
762	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	665	t	module_pos_loyalty	base	ir.module.module
763	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	666	t	module_pos_mercado_pago	base	ir.module.module
764	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	667	t	module_pos_mrp	base	ir.module.module
765	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	668	t	module_pos_online_payment	base	ir.module.module
766	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	669	t	module_pos_online_payment_self_order	base	ir.module.module
767	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	670	t	module_pos_paytm	base	ir.module.module
768	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	671	t	module_pos_pine_labs	base	ir.module.module
769	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	672	t	module_pos_razorpay	base	ir.module.module
770	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	673	t	module_pos_restaurant	base	ir.module.module
771	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	93	t	module_category_point_of_sale	base	ir.module.category
772	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	674	t	module_pos_restaurant_adyen	base	ir.module.module
773	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	675	t	module_pos_restaurant_loyalty	base	ir.module.module
774	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	676	t	module_pos_restaurant_stripe	base	ir.module.module
775	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	677	t	module_pos_sale	base	ir.module.module
776	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	678	t	module_pos_sale_loyalty	base	ir.module.module
777	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	679	t	module_pos_sale_margin	base	ir.module.module
778	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	680	t	module_pos_self_order	base	ir.module.module
779	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	681	t	module_pos_self_order_adyen	base	ir.module.module
780	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	682	t	module_pos_self_order_epson_printer	base	ir.module.module
781	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	683	t	module_pos_self_order_razorpay	base	ir.module.module
782	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	684	t	module_pos_self_order_sale	base	ir.module.module
783	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	685	t	module_pos_self_order_stripe	base	ir.module.module
784	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	686	t	module_pos_six	base	ir.module.module
785	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	94	t	module_category_send_sms_to_customer_for_order_confirmation	base	ir.module.category
786	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	687	t	module_pos_sms	base	ir.module.module
787	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	688	t	module_pos_stripe	base	ir.module.module
788	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	689	t	module_pos_viva_wallet	base	ir.module.module
789	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	690	t	module_privacy_lookup	base	ir.module.module
790	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	95	t	module_category_warehouse	base	ir.module.category
791	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	691	t	module_procurement_auto_create_group	base	ir.module.module
792	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	96	t	module_category_procurements	base	ir.module.category
793	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	692	t	module_procurement_purchase_no_grouping	base	ir.module.module
794	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	693	t	module_product	base	ir.module.module
795	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	694	t	module_product_category_tax	base	ir.module.module
796	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	695	t	module_product_customerinfo_invoice	base	ir.module.module
797	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	696	t	module_product_email_template	base	ir.module.module
798	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	697	t	module_product_expiry	base	ir.module.module
799	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	698	t	module_product_form_account_move_line_link	base	ir.module.module
800	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	699	t	module_product_images	base	ir.module.module
801	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	97	t	module_category_purchase	base	ir.module.category
802	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	700	t	module_product_main_seller	base	ir.module.module
803	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	701	t	module_product_margin	base	ir.module.module
804	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	702	t	module_product_matrix	base	ir.module.module
805	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	703	t	module_product_route_profile	base	ir.module.module
806	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	704	t	module_product_supplier_code_purchase	base	ir.module.module
807	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	705	t	module_product_supplierinfo_purchase_contact	base	ir.module.module
808	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	706	t	module_product_supplierinfo_qty_multiplier	base	ir.module.module
809	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	707	t	module_product_supplierinfo_update_price	base	ir.module.module
810	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	98	t	module_category_services_project	base	ir.module.category
811	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	708	t	module_project	base	ir.module.module
812	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	709	t	module_project_account	base	ir.module.module
813	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	99	t	module_category_project	base	ir.module.category
814	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	710	t	module_project_administrator_restricted_visibility	base	ir.module.module
815	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	711	t	module_project_department	base	ir.module.module
816	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	712	t	module_project_group	base	ir.module.module
817	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	713	t	module_project_hr	base	ir.module.module
818	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	100	t	module_category_services_expenses	base	ir.module.category
819	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	714	t	module_project_hr_expense	base	ir.module.module
820	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	715	t	module_project_hr_skills	base	ir.module.module
821	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	716	t	module_project_key	base	ir.module.module
822	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	717	t	module_project_mail_plugin	base	ir.module.module
823	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	718	t	module_project_merge	base	ir.module.module
824	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	719	t	module_project_milestone_status	base	ir.module.module
825	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	720	t	module_project_mrp	base	ir.module.module
826	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	721	t	module_project_mrp_account	base	ir.module.module
827	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	722	t	module_project_mrp_sale	base	ir.module.module
828	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	723	t	module_project_mrp_stock_landed_costs	base	ir.module.module
829	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	724	t	module_project_parent	base	ir.module.module
830	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	725	t	module_project_parent_task_filter	base	ir.module.module
831	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	726	t	module_project_pivot	base	ir.module.module
832	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	727	t	module_project_portal_task_visibility	base	ir.module.module
833	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	728	t	module_project_purchase	base	ir.module.module
834	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	729	t	module_project_purchase_link	base	ir.module.module
835	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	730	t	module_project_purchase_stock	base	ir.module.module
836	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	731	t	module_project_role	base	ir.module.module
837	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	732	t	module_project_sale_expense	base	ir.module.module
838	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	733	t	module_project_sequence	base	ir.module.module
839	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	734	t	module_project_sms	base	ir.module.module
840	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	101	t	module_category_project_management	base	ir.module.category
841	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	735	t	module_project_stage_extra_info	base	ir.module.module
842	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	736	t	module_project_stage_last_update_date	base	ir.module.module
843	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	737	t	module_project_stakeholder	base	ir.module.module
844	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	738	t	module_project_stock	base	ir.module.module
845	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	739	t	module_project_stock_account	base	ir.module.module
846	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	740	t	module_project_stock_landed_costs	base	ir.module.module
847	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	741	t	module_project_tag_hierarchy	base	ir.module.module
848	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	742	t	module_project_tag_multicompany	base	ir.module.module
849	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	743	t	module_project_tag_security	base	ir.module.module
850	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	744	t	module_project_task_add_very_high	base	ir.module.module
851	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	745	t	module_project_task_ancestor	base	ir.module.module
852	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	746	t	module_project_task_code	base	ir.module.module
853	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	747	t	module_project_task_code_portal	base	ir.module.module
854	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	748	t	module_project_task_default_stage	base	ir.module.module
855	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	749	t	module_project_task_description_portal	base	ir.module.module
856	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	750	t	module_project_task_description_template	base	ir.module.module
857	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	751	t	module_project_task_material	base	ir.module.module
858	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	752	t	module_project_task_name_with_id	base	ir.module.module
859	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	753	t	module_project_task_note	base	ir.module.module
860	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	754	t	module_project_task_parent_completion_blocking	base	ir.module.module
861	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	755	t	module_project_task_parent_due_auto	base	ir.module.module
862	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	756	t	module_project_task_personal_stage_auto_fold	base	ir.module.module
863	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	757	t	module_project_task_pull_request	base	ir.module.module
864	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	758	t	module_project_task_pull_request_state	base	ir.module.module
865	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	759	t	module_project_task_stage_lock	base	ir.module.module
866	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	760	t	module_project_task_stage_mgmt	base	ir.module.module
867	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	761	t	module_project_task_stage_state	base	ir.module.module
868	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	762	t	module_project_task_stock	base	ir.module.module
869	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	763	t	module_project_task_stock_product_set	base	ir.module.module
870	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	764	t	module_project_task_tag	base	ir.module.module
871	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	765	t	module_project_template	base	ir.module.module
872	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	766	t	module_project_timeline	base	ir.module.module
873	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	767	t	module_project_timeline_hr_timesheet	base	ir.module.module
874	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	768	t	module_project_timesheet_holidays	base	ir.module.module
875	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	769	t	module_project_timesheet_time_control	base	ir.module.module
876	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	102	t	module_category_productivity_to-do	base	ir.module.category
877	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	770	t	module_project_todo	base	ir.module.module
878	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	771	t	module_project_type	base	ir.module.module
879	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	772	t	module_project_version	base	ir.module.module
880	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	773	t	module_purchase	base	ir.module.module
881	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	774	t	module_purchase_advance_payment	base	ir.module.module
882	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	103	t	module_category_purchases	base	ir.module.category
883	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	775	t	module_purchase_all_shipments	base	ir.module.module
884	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	776	t	module_purchase_allowed_product	base	ir.module.module
885	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	777	t	module_purchase_analytic	base	ir.module.module
886	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	104	t	module_category_purchases,_accounting	base	ir.module.category
887	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	778	t	module_purchase_analytic_distribution_model_warehouse	base	ir.module.module
888	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	779	t	module_purchase_analytic_global	base	ir.module.module
889	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	780	t	module_purchase_analytic_tag	base	ir.module.module
890	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	781	t	module_purchase_blanket_order	base	ir.module.module
891	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	782	t	module_purchase_cancel_reason	base	ir.module.module
892	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	783	t	module_purchase_commercial_partner	base	ir.module.module
893	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	784	t	module_purchase_container	base	ir.module.module
894	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	785	t	module_purchase_default_terms_conditions	base	ir.module.module
895	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	786	t	module_purchase_delivery_split_date	base	ir.module.module
896	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	787	t	module_purchase_deposit	base	ir.module.module
897	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	788	t	module_purchase_edi_ubl_bis3	base	ir.module.module
898	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	105	t	module_category_generic_modules_purchase	base	ir.module.category
899	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	789	t	module_purchase_exception	base	ir.module.module
900	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	790	t	module_purchase_fop_shipping	base	ir.module.module
901	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	791	t	module_purchase_force_invoiced	base	ir.module.module
902	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	792	t	module_purchase_force_invoiced_quantity	base	ir.module.module
903	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	793	t	module_purchase_invoice_method	base	ir.module.module
904	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	794	t	module_purchase_invoice_plan	base	ir.module.module
905	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	795	t	module_purchase_invoice_status_line	base	ir.module.module
906	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	796	t	module_purchase_last_price_info	base	ir.module.module
907	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	797	t	module_purchase_line_procurement_group	base	ir.module.module
908	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	798	t	module_purchase_line_reassign	base	ir.module.module
909	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	799	t	module_purchase_location_by_line	base	ir.module.module
910	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	800	t	module_purchase_lot	base	ir.module.module
911	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	801	t	module_purchase_manual_currency	base	ir.module.module
912	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	802	t	module_purchase_manual_delivery	base	ir.module.module
913	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	803	t	module_purchase_mrp	base	ir.module.module
914	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	804	t	module_purchase_no_rfq	base	ir.module.module
915	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	805	t	module_purchase_open_qty	base	ir.module.module
916	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	806	t	module_purchase_operating_unit	base	ir.module.module
917	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	807	t	module_purchase_order_approval_block	base	ir.module.module
918	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	808	t	module_purchase_order_archive	base	ir.module.module
919	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	809	t	module_purchase_order_general_discount	base	ir.module.module
920	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	810	t	module_purchase_order_line_menu	base	ir.module.module
921	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	811	t	module_purchase_order_line_original_date	base	ir.module.module
922	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	812	t	module_purchase_order_line_sequence	base	ir.module.module
923	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	813	t	module_purchase_order_line_stock_available	base	ir.module.module
924	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	814	t	module_purchase_order_owner	base	ir.module.module
925	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	815	t	module_purchase_order_product_recommendation	base	ir.module.module
926	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	816	t	module_purchase_order_product_recommendation_brand	base	ir.module.module
927	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	817	t	module_purchase_order_product_recommendation_xlsx	base	ir.module.module
928	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	818	t	module_purchase_order_qty_change_no_recompute	base	ir.module.module
929	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	819	t	module_purchase_order_secondary_unit	base	ir.module.module
930	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	820	t	module_purchase_order_supplier_return	base	ir.module.module
931	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	821	t	module_purchase_order_supplierinfo_update	base	ir.module.module
932	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	822	t	module_purchase_order_type	base	ir.module.module
933	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	823	t	module_purchase_order_type_dashboard	base	ir.module.module
934	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	824	t	module_purchase_order_uninvoiced_amount	base	ir.module.module
935	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	825	t	module_purchase_order_uninvoiced_amount_line	base	ir.module.module
936	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	826	t	module_purchase_partner_incoterm	base	ir.module.module
937	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	827	t	module_purchase_partner_selectable_option	base	ir.module.module
938	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	828	t	module_purchase_product_matrix	base	ir.module.module
939	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	829	t	module_purchase_receipt_expectation	base	ir.module.module
940	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	830	t	module_purchase_reception_notify	base	ir.module.module
941	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	831	t	module_purchase_reception_status	base	ir.module.module
942	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	832	t	module_purchase_reception_status_line	base	ir.module.module
943	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	106	t	module_category_repair	base	ir.module.category
944	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	107	t	module_category_repair_purchase	base	ir.module.category
945	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	833	t	module_purchase_repair	base	ir.module.module
946	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	834	t	module_purchase_representative	base	ir.module.module
947	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	835	t	module_purchase_request	base	ir.module.module
948	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	836	t	module_purchase_request_cancel_confirm	base	ir.module.module
949	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	837	t	module_purchase_request_department	base	ir.module.module
950	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	838	t	module_purchase_request_exception	base	ir.module.module
951	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	839	t	module_purchase_request_substate	base	ir.module.module
952	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	840	t	module_purchase_request_tier_validation	base	ir.module.module
953	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	841	t	module_purchase_request_to_requisition	base	ir.module.module
954	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	842	t	module_purchase_request_type	base	ir.module.module
955	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	843	t	module_purchase_requisition	base	ir.module.module
956	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	844	t	module_purchase_requisition_line_description	base	ir.module.module
957	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	845	t	module_purchase_requisition_sale	base	ir.module.module
958	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	846	t	module_purchase_requisition_stock	base	ir.module.module
959	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	847	t	module_purchase_sale_link_by_origin	base	ir.module.module
960	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	848	t	module_purchase_security	base	ir.module.module
961	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	849	t	module_purchase_stock	base	ir.module.module
962	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	850	t	module_purchase_stock_analytic	base	ir.module.module
963	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	851	t	module_purchase_stock_manual_currency	base	ir.module.module
964	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	852	t	module_purchase_stock_packaging	base	ir.module.module
965	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	853	t	module_purchase_stock_picking_return_invoicing	base	ir.module.module
966	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	854	t	module_purchase_stock_price_unit_sync	base	ir.module.module
967	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	855	t	module_purchase_stock_reception_status	base	ir.module.module
968	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	856	t	module_purchase_substate	base	ir.module.module
969	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	857	t	module_purchase_tag	base	ir.module.module
970	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	858	t	module_purchase_tier_validation	base	ir.module.module
971	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	859	t	module_purchase_triple_discount	base	ir.module.module
972	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	860	t	module_purchase_uninvoiced_amount_force_invoiced_line	base	ir.module.module
973	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	861	t	module_purchase_unreconciled	base	ir.module.module
974	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	862	t	module_purchase_warn_message	base	ir.module.module
975	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	863	t	module_purchase_warn_option	base	ir.module.module
976	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	864	t	module_purchase_work_acceptance	base	ir.module.module
977	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	865	t	module_purchase_work_acceptance_invoice_plan	base	ir.module.module
978	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	866	t	module_rating	base	ir.module.module
979	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	108	t	module_category_maintenance	base	ir.module.category
980	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	867	t	module_remove_odoo_enterprise	base	ir.module.module
981	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	868	t	module_repair	base	ir.module.module
982	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	869	t	module_report_context	base	ir.module.module
983	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	870	t	module_report_csv	base	ir.module.module
984	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	871	t	module_report_display_name_in_footer	base	ir.module.module
985	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	872	t	module_report_footer_html	base	ir.module.module
986	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	873	t	module_report_pdf_form	base	ir.module.module
987	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	874	t	module_report_pdf_zip_download	base	ir.module.module
988	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	875	t	module_report_py3o	base	ir.module.module
989	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	876	t	module_report_py3o_fusion_server	base	ir.module.module
990	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	877	t	module_report_qr	base	ir.module.module
991	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	878	t	module_report_qweb_element_page_visibility	base	ir.module.module
992	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	879	t	module_report_qweb_encrypt	base	ir.module.module
993	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	880	t	module_report_qweb_field_option	base	ir.module.module
994	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	109	t	module_category_reports	base	ir.module.category
995	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	110	t	module_category_reports_qweb	base	ir.module.category
996	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	881	t	module_report_qweb_operating_unit	base	ir.module.module
997	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	882	t	module_report_qweb_parameter	base	ir.module.module
998	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	883	t	module_report_qweb_pdf_cover	base	ir.module.module
999	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	884	t	module_report_qweb_pdf_watermark	base	ir.module.module
1000	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	885	t	module_report_substitute	base	ir.module.module
1001	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	886	t	module_report_wkhtmltopdf_param	base	ir.module.module
1002	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	887	t	module_report_xlsx	base	ir.module.module
1003	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	888	t	module_report_xlsx_helper	base	ir.module.module
1004	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	889	t	module_report_xml	base	ir.module.module
1005	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	890	t	module_res_partner_operating_unit	base	ir.module.module
1006	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	891	t	module_resource	base	ir.module.module
1007	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	892	t	module_resource_mail	base	ir.module.module
1008	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	893	t	module_rpc_helper	base	ir.module.module
1009	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	894	t	module_sale	base	ir.module.module
1010	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	895	t	module_sale_analytic_distribution_model_warehouse	base	ir.module.module
1011	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	896	t	module_sale_analytic_tag	base	ir.module.module
1012	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	897	t	module_sale_async_emails	base	ir.module.module
1013	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	898	t	module_sale_credit_note_reversal	base	ir.module.module
1014	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	899	t	module_sale_crm	base	ir.module.module
1015	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	900	t	module_sale_edi_ubl	base	ir.module.module
1016	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	901	t	module_sale_expense	base	ir.module.module
1017	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	902	t	module_sale_expense_margin	base	ir.module.module
1018	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	903	t	module_sale_gelato	base	ir.module.module
1019	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	904	t	module_sale_gelato_stock	base	ir.module.module
1020	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	905	t	module_sale_line_refund_to_invoice_qty	base	ir.module.module
1021	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	906	t	module_sale_loyalty	base	ir.module.module
1022	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	907	t	module_sale_loyalty_delivery	base	ir.module.module
1023	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	908	t	module_sale_management	base	ir.module.module
1024	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	909	t	module_sale_margin	base	ir.module.module
1025	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	910	t	module_sale_mrp	base	ir.module.module
1026	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	911	t	module_sale_mrp_margin	base	ir.module.module
1027	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	111	t	module_category_sales_management	base	ir.module.category
1028	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	912	t	module_sale_operating_unit	base	ir.module.module
1029	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	913	t	module_sale_order_invoicing_grouping_criteria	base	ir.module.module
1030	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	914	t	module_sale_order_invoicing_qty_percentage	base	ir.module.module
1031	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	915	t	module_sale_pdf_quote_builder	base	ir.module.module
1032	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	916	t	module_sale_product_matrix	base	ir.module.module
1033	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	917	t	module_sale_project	base	ir.module.module
1034	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	918	t	module_sale_project_copy_tasks	base	ir.module.module
1035	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	919	t	module_sale_project_stock	base	ir.module.module
1036	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	920	t	module_sale_project_stock_account	base	ir.module.module
1037	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	921	t	module_sale_project_task_recurrency	base	ir.module.module
1038	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	922	t	module_sale_project_task_selection	base	ir.module.module
1039	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	923	t	module_sale_purchase	base	ir.module.module
1040	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	924	t	module_sale_purchase_force_vendor	base	ir.module.module
1041	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	925	t	module_sale_purchase_project	base	ir.module.module
1042	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	926	t	module_sale_purchase_stock	base	ir.module.module
1043	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	927	t	module_sale_service	base	ir.module.module
1044	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	928	t	module_sale_sms	base	ir.module.module
1045	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	929	t	module_sale_stock	base	ir.module.module
1046	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	930	t	module_sale_stock_margin	base	ir.module.module
1047	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	931	t	module_sale_stock_operating_unit	base	ir.module.module
1048	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	932	t	module_sale_stock_picking_invoicing	base	ir.module.module
1049	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	933	t	module_sale_timesheet	base	ir.module.module
1050	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	934	t	module_sale_timesheet_margin	base	ir.module.module
1051	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	935	t	module_sales_team	base	ir.module.module
1052	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	936	t	module_sales_team_operating_unit	base	ir.module.module
1053	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	937	t	module_scheduler_error_mailer	base	ir.module.module
1054	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	938	t	module_sentry	base	ir.module.module
1055	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	939	t	module_sequence_check_digit	base	ir.module.module
1056	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	940	t	module_sequence_reset_period	base	ir.module.module
1057	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	941	t	module_server_action_mass_edit	base	ir.module.module
1058	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	942	t	module_server_action_mass_edit_onchange	base	ir.module.module
1059	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	943	t	module_server_action_sort	base	ir.module.module
1060	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	944	t	module_server_environment	base	ir.module.module
1061	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	945	t	module_server_environment_data_encryption	base	ir.module.module
1062	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	946	t	module_server_environment_ir_config_parameter	base	ir.module.module
1063	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	947	t	module_session_db	base	ir.module.module
1064	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	948	t	module_sms	base	ir.module.module
1065	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	949	t	module_sms_twilio	base	ir.module.module
1066	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	950	t	module_snailmail	base	ir.module.module
1067	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	951	t	module_snailmail_account	base	ir.module.module
1068	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	952	t	module_social_media	base	ir.module.module
1069	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	953	t	module_spreadsheet	base	ir.module.module
1070	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	954	t	module_spreadsheet_account	base	ir.module.module
1071	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	112	t	module_category_productivity_dashboard	base	ir.module.category
1072	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	955	t	module_spreadsheet_dashboard	base	ir.module.module
1073	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	956	t	module_spreadsheet_dashboard_account	base	ir.module.module
1074	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	957	t	module_spreadsheet_dashboard_event_sale	base	ir.module.module
1075	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	958	t	module_spreadsheet_dashboard_hr_expense	base	ir.module.module
1076	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	959	t	module_spreadsheet_dashboard_hr_timesheet	base	ir.module.module
1077	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	960	t	module_spreadsheet_dashboard_im_livechat	base	ir.module.module
1078	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	961	t	module_spreadsheet_dashboard_pos_hr	base	ir.module.module
1079	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	962	t	module_spreadsheet_dashboard_pos_restaurant	base	ir.module.module
1080	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	963	t	module_spreadsheet_dashboard_sale	base	ir.module.module
1081	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	964	t	module_spreadsheet_dashboard_sale_timesheet	base	ir.module.module
1082	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	965	t	module_spreadsheet_dashboard_stock_account	base	ir.module.module
1083	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	966	t	module_spreadsheet_dashboard_website_sale	base	ir.module.module
1084	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	967	t	module_spreadsheet_dashboard_website_sale_slides	base	ir.module.module
1085	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	113	t	module_category_generic_modules_others	base	ir.module.category
1086	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	968	t	module_sql_export	base	ir.module.module
1087	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	969	t	module_sql_export_excel	base	ir.module.module
1088	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	970	t	module_sql_export_mail	base	ir.module.module
1089	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	971	t	module_sql_request_abstract	base	ir.module.module
1090	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	972	t	module_stock	base	ir.module.module
1091	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	973	t	module_stock_account	base	ir.module.module
1092	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	974	t	module_stock_account_move_reset_to_draft	base	ir.module.module
1093	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	975	t	module_stock_analytic	base	ir.module.module
1094	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	976	t	module_stock_archive_constraint	base	ir.module.module
1095	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	977	t	module_stock_change_qty_reason	base	ir.module.module
1096	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	978	t	module_stock_cycle_count	base	ir.module.module
1097	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	979	t	module_stock_delivery	base	ir.module.module
1098	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	980	t	module_stock_demand_estimate	base	ir.module.module
1099	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	981	t	module_stock_demand_estimate_matrix	base	ir.module.module
1100	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	982	t	module_stock_dropshipping	base	ir.module.module
1101	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	983	t	module_stock_fleet	base	ir.module.module
1102	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	984	t	module_stock_inventory	base	ir.module.module
1103	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	985	t	module_stock_inventory_count_to_zero	base	ir.module.module
1104	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	986	t	module_stock_inventory_discrepancy	base	ir.module.module
1105	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	987	t	module_stock_inventory_lockdown	base	ir.module.module
1106	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	114	t	module_category_inventory,_logistic,_storage	base	ir.module.category
1107	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	988	t	module_stock_inventory_preparation_filter	base	ir.module.module
1108	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	989	t	module_stock_inventory_verification_request	base	ir.module.module
1109	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	990	t	module_stock_landed_costs	base	ir.module.module
1110	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	991	t	module_stock_landed_costs_analytic	base	ir.module.module
1111	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	115	t	module_category_stock_management	base	ir.module.category
1112	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	992	t	module_stock_location_bin_name	base	ir.module.module
1113	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	993	t	module_stock_location_children	base	ir.module.module
1114	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	994	t	module_stock_location_empty	base	ir.module.module
1115	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	995	t	module_stock_location_fill_state	base	ir.module.module
1116	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	996	t	module_stock_location_fill_state_qty_picked	base	ir.module.module
1117	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	997	t	module_stock_location_is_sublocation	base	ir.module.module
1118	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	998	t	module_stock_location_lockdown	base	ir.module.module
1119	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	999	t	module_stock_location_pending_move	base	ir.module.module
1120	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1000	t	module_stock_location_position	base	ir.module.module
1121	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	116	t	module_category_stock	base	ir.module.category
1122	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1001	t	module_stock_location_tray	base	ir.module.module
1123	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1002	t	module_stock_location_zone	base	ir.module.module
1124	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1003	t	module_stock_lot_condition	base	ir.module.module
1125	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1004	t	module_stock_lot_image	base	ir.module.module
1126	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1005	t	module_stock_move_common_dest	base	ir.module.module
1127	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1006	t	module_stock_move_location	base	ir.module.module
1128	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1007	t	module_stock_move_location_purchase_uom	base	ir.module.module
1129	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1008	t	module_stock_move_packaging_qty	base	ir.module.module
1130	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1009	t	module_stock_move_purchase_uom	base	ir.module.module
1131	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1010	t	module_stock_move_reset_quantity	base	ir.module.module
1132	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	117	t	module_category_generic_modules_sales_and_purchases	base	ir.module.category
1133	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1011	t	module_stock_operating_unit	base	ir.module.module
1134	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1012	t	module_stock_operating_unit_access_all	base	ir.module.module
1135	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1013	t	module_stock_package_type_volume	base	ir.module.module
1136	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1014	t	module_stock_packaging_calculator	base	ir.module.module
1137	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1015	t	module_stock_picking_batch	base	ir.module.module
1138	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1016	t	module_stock_picking_batch_packaging_qty	base	ir.module.module
1139	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1017	t	module_stock_picking_completion_info	base	ir.module.module
1140	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1018	t	module_stock_picking_invoicing	base	ir.module.module
1141	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1019	t	module_stock_picking_product_assortment	base	ir.module.module
1142	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1020	t	module_stock_picking_return_refund_option	base	ir.module.module
1143	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1021	t	module_stock_picking_show_linked	base	ir.module.module
1144	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1022	t	module_stock_picking_stage	base	ir.module.module
1145	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1023	t	module_stock_picking_supplier_ref	base	ir.module.module
1146	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1024	t	module_stock_picking_volume	base	ir.module.module
1147	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1025	t	module_stock_picking_volume_packaging	base	ir.module.module
1148	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1026	t	module_stock_product_qty_by_packaging	base	ir.module.module
1149	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1027	t	module_stock_putaway_product_template	base	ir.module.module
1150	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1028	t	module_stock_quant_cost_info	base	ir.module.module
1151	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1029	t	module_stock_quant_reservation_info	base	ir.module.module
1152	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1030	t	module_stock_quant_reservation_info_mrp	base	ir.module.module
1153	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1031	t	module_stock_restrict_immediate_adjustment	base	ir.module.module
1154	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1032	t	module_stock_route_location_source	base	ir.module.module
1155	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1033	t	module_stock_route_mto	base	ir.module.module
1156	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1034	t	module_stock_secondary_unit	base	ir.module.module
1157	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1035	t	module_stock_sms	base	ir.module.module
1158	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1036	t	module_stock_storage_category_capacity_name	base	ir.module.module
1159	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1037	t	module_stock_valuation_layer_inventory_filter	base	ir.module.module
1160	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1038	t	module_stock_vertical_lift	base	ir.module.module
1161	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1039	t	module_stock_vertical_lift_empty_tray_check	base	ir.module.module
1162	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1040	t	module_stock_vertical_lift_packaging_level	base	ir.module.module
3900	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	79	f	lang_es_PE	base	res.lang
1163	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1041	t	module_stock_vertical_lift_qty_by_packaging	base	ir.module.module
1164	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1042	t	module_stock_vertical_lift_server_env	base	ir.module.module
1165	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1043	t	module_stock_vertical_lift_storage_type	base	ir.module.module
1166	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1044	t	module_stock_vlm_mgmt	base	ir.module.module
1167	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1045	t	module_stock_warehouse_calendar	base	ir.module.module
1168	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1046	t	module_stock_warehouse_out_pull	base	ir.module.module
1169	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1047	t	module_stock_warehouse_resupply_route_push	base	ir.module.module
1170	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1048	t	module_stock_warehouse_security	base	ir.module.module
1171	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1049	t	module_supplier_calendar	base	ir.module.module
1172	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	118	t	module_category_marketing_surveys	base	ir.module.category
1173	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1050	t	module_survey	base	ir.module.module
1174	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1051	t	module_template_content_swapper	base	ir.module.module
1175	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1052	t	module_test_access_rights	base	ir.module.module
1176	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1053	t	module_test_action_bindings	base	ir.module.module
1177	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1054	t	module_test_apikeys	base	ir.module.module
1178	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1055	t	module_test_assetsbundle	base	ir.module.module
1179	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1056	t	module_test_auditlog	base	ir.module.module
1180	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1057	t	module_test_auth_custom	base	ir.module.module
1181	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1058	t	module_test_base_automation	base	ir.module.module
1182	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1059	t	module_test_base_time_window	base	ir.module.module
1183	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1060	t	module_test_convert	base	ir.module.module
1184	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1061	t	module_test_converter	base	ir.module.module
1185	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1062	t	module_test_crm_full	base	ir.module.module
1186	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1063	t	module_test_data_module	base	ir.module.module
1187	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1064	t	module_test_data_module_install	base	ir.module.module
1188	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1065	t	module_test_discuss_full	base	ir.module.module
1189	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1066	t	module_test_event_full	base	ir.module.module
1190	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1067	t	module_test_exceptions	base	ir.module.module
1191	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1068	t	module_test_hr_contract_calendar	base	ir.module.module
1192	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1069	t	module_test_html_field_history	base	ir.module.module
1193	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1070	t	module_test_http	base	ir.module.module
1194	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1071	t	module_test_import_export	base	ir.module.module
1195	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1072	t	module_test_inherit	base	ir.module.module
1196	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1073	t	module_test_inherit_depends	base	ir.module.module
1197	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1074	t	module_test_inherits	base	ir.module.module
1198	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1075	t	module_test_inherits_depends	base	ir.module.module
1199	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1076	t	module_test_limits	base	ir.module.module
1200	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1077	t	module_test_lint	base	ir.module.module
1201	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1078	t	module_test_mail	base	ir.module.module
1202	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1079	t	module_test_mail_full	base	ir.module.module
1203	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1080	t	module_test_mail_sms	base	ir.module.module
1204	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1081	t	module_test_main_flows	base	ir.module.module
1205	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1082	t	module_test_mass_mailing	base	ir.module.module
1206	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1083	t	module_test_mimetypes	base	ir.module.module
1207	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1084	t	module_test_new_api	base	ir.module.module
1208	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1085	t	module_test_performance	base	ir.module.module
1209	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1086	t	module_test_read_group	base	ir.module.module
1210	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1087	t	module_test_resource	base	ir.module.module
1211	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1088	t	module_test_rpc	base	ir.module.module
1212	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1089	t	module_test_sale_product_configurators	base	ir.module.module
1213	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1090	t	module_test_sale_purchase_edi_ubl	base	ir.module.module
1214	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1091	t	module_test_search_panel	base	ir.module.module
1215	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1092	t	module_test_spreadsheet	base	ir.module.module
1216	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1093	t	module_test_testing_utilities	base	ir.module.module
1217	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1094	t	module_test_translation_import	base	ir.module.module
1218	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1095	t	module_test_uninstall	base	ir.module.module
1219	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1096	t	module_test_website	base	ir.module.module
1220	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1097	t	module_test_website_modules	base	ir.module.module
1221	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1098	t	module_test_website_slides_full	base	ir.module.module
1222	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	119	t	module_category_theme	base	ir.module.category
1223	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1099	t	module_theme_default	base	ir.module.module
1224	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1100	t	module_tracking_manager	base	ir.module.module
1225	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1101	t	module_tracking_manager_domain	base	ir.module.module
1226	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1102	t	module_transifex	base	ir.module.module
1227	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1103	t	module_uom	base	ir.module.module
1228	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	120	t	module_category_migration	base	ir.module.category
1229	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1104	t	module_upgrade_analysis	base	ir.module.module
1230	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1105	t	module_user_log_view	base	ir.module.module
1231	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1106	t	module_users_ldap_mail	base	ir.module.module
1232	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1107	t	module_utm	base	ir.module.module
1233	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	121	t	module_category_vault	base	ir.module.category
1234	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1108	t	module_vault	base	ir.module.module
1235	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1109	t	module_vault_share	base	ir.module.module
1236	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1110	t	module_vendor_transport_lead_time	base	ir.module.module
1237	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1111	t	module_web	base	ir.module.module
1238	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1112	t	module_web_calendar_slot_duration	base	ir.module.module
1239	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1113	t	module_web_chatter_position	base	ir.module.module
1240	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	122	t	module_category_web	base	ir.module.category
1241	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1114	t	module_web_company_color	base	ir.module.module
1242	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1115	t	module_web_copy_confirm	base	ir.module.module
1243	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1116	t	module_web_dark_mode	base	ir.module.module
1244	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1117	t	module_web_datetime_picker_default_time	base	ir.module.module
1245	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1118	t	module_web_dialog_size	base	ir.module.module
1246	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1119	t	module_web_disable_export_group	base	ir.module.module
1247	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1120	t	module_web_editor	base	ir.module.module
1248	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1121	t	module_web_editor_class_selector	base	ir.module.module
1249	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1122	t	module_web_editor_disable_chatgpt	base	ir.module.module
1250	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1123	t	module_web_environment_ribbon	base	ir.module.module
1251	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1124	t	module_web_excel_export_dynamic_expand	base	ir.module.module
1252	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1125	t	module_web_favicon	base	ir.module.module
1253	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1126	t	module_web_filter_header_button	base	ir.module.module
1254	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1127	t	module_web_form_banner	base	ir.module.module
1255	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1128	t	module_web_group_expand	base	ir.module.module
1256	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1129	t	module_web_hierarchy	base	ir.module.module
1257	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1130	t	module_web_ir_actions_act_multi	base	ir.module.module
1258	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1131	t	module_web_ir_actions_act_window_message	base	ir.module.module
1259	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1132	t	module_web_m2x_options	base	ir.module.module
1260	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1133	t	module_web_m2x_options_manager	base	ir.module.module
1261	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1134	t	module_web_no_bubble	base	ir.module.module
1262	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1135	t	module_web_notify	base	ir.module.module
1263	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1136	t	module_web_notify_channel_message	base	ir.module.module
1264	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1137	t	module_web_notify_upgrade	base	ir.module.module
1265	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1138	t	module_web_pivot_computed_measure	base	ir.module.module
1266	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1139	t	module_web_pwa_customize	base	ir.module.module
1267	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1140	t	module_web_quick_start_screen	base	ir.module.module
1268	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1141	t	module_web_refresher	base	ir.module.module
1269	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1142	t	module_web_remember_tree_column_width	base	ir.module.module
1270	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1143	t	module_web_responsive	base	ir.module.module
1271	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1144	t	module_web_save_discard_button	base	ir.module.module
1272	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1145	t	module_web_search_with_and	base	ir.module.module
1273	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1146	t	module_web_send_message_popup	base	ir.module.module
1274	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1147	t	module_web_session_auto_close	base	ir.module.module
1275	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1148	t	module_web_sort_menu	base	ir.module.module
1276	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1149	t	module_web_systray_button_init_action	base	ir.module.module
1277	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1150	t	module_web_theme_classic	base	ir.module.module
1278	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1151	t	module_web_timeline	base	ir.module.module
1279	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1152	t	module_web_touchscreen	base	ir.module.module
1280	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1153	t	module_web_tour	base	ir.module.module
1281	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1154	t	module_web_tree_column_keyboard_resize	base	ir.module.module
1282	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1155	t	module_web_tree_dynamic_colored_field	base	ir.module.module
1283	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1156	t	module_web_tree_many2one_clickable	base	ir.module.module
1284	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1157	t	module_web_unsplash	base	ir.module.module
1285	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1158	t	module_web_widget_bokeh_chart	base	ir.module.module
1286	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1159	t	module_web_widget_domain_editor_dialog	base	ir.module.module
1287	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1160	t	module_web_widget_dropdown_dynamic	base	ir.module.module
1288	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1161	t	module_web_widget_mpld3_chart	base	ir.module.module
1289	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1162	t	module_web_widget_numeric_step	base	ir.module.module
1290	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1163	t	module_web_widget_one2many_tree_line_duplicate	base	ir.module.module
1291	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1164	t	module_web_widget_open_tab	base	ir.module.module
1292	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1165	t	module_web_widget_popover	base	ir.module.module
1293	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1166	t	module_web_widget_product_label_section_and_note_full_label	base	ir.module.module
1294	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1167	t	module_web_widget_product_label_section_and_note_name_visibility	base	ir.module.module
1295	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1168	t	module_web_widget_url_advanced	base	ir.module.module
1296	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1169	t	module_web_widget_x2many_2d_matrix	base	ir.module.module
1297	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	123	t	module_category_website_website	base	ir.module.category
1298	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1170	t	module_website	base	ir.module.module
1299	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1171	t	module_website_blog	base	ir.module.module
1300	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1172	t	module_website_cf_turnstile	base	ir.module.module
1301	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1173	t	module_website_crm	base	ir.module.module
1302	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1174	t	module_website_crm_iap_reveal	base	ir.module.module
1303	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1175	t	module_website_crm_livechat	base	ir.module.module
1304	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1176	t	module_website_crm_partner_assign	base	ir.module.module
1305	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1177	t	module_website_crm_sms	base	ir.module.module
1306	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1178	t	module_website_customer	base	ir.module.module
1307	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1179	t	module_website_event	base	ir.module.module
1308	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1180	t	module_website_event_booth	base	ir.module.module
1309	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1181	t	module_website_event_booth_exhibitor	base	ir.module.module
1310	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1182	t	module_website_event_booth_sale	base	ir.module.module
1311	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1183	t	module_website_event_booth_sale_exhibitor	base	ir.module.module
1312	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1184	t	module_website_event_crm	base	ir.module.module
1313	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1185	t	module_website_event_exhibitor	base	ir.module.module
1314	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1186	t	module_website_event_jitsi	base	ir.module.module
1315	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1187	t	module_website_event_meet	base	ir.module.module
1316	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1188	t	module_website_event_meet_quiz	base	ir.module.module
1317	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1189	t	module_website_event_sale	base	ir.module.module
1318	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1190	t	module_website_event_track	base	ir.module.module
1319	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1191	t	module_website_event_track_live	base	ir.module.module
1320	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1192	t	module_website_event_track_live_quiz	base	ir.module.module
1321	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1193	t	module_website_event_track_quiz	base	ir.module.module
1322	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1194	t	module_website_forum	base	ir.module.module
1323	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1195	t	module_website_google_map	base	ir.module.module
1324	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1196	t	module_website_hr_recruitment	base	ir.module.module
1325	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1197	t	module_website_jitsi	base	ir.module.module
1326	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1198	t	module_website_links	base	ir.module.module
1327	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1199	t	module_website_livechat	base	ir.module.module
1328	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1200	t	module_website_mail	base	ir.module.module
1329	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1201	t	module_website_mail_group	base	ir.module.module
1330	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1202	t	module_website_mass_mailing	base	ir.module.module
1331	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1203	t	module_website_mass_mailing_sms	base	ir.module.module
1332	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1204	t	module_website_membership	base	ir.module.module
1333	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1205	t	module_website_partner	base	ir.module.module
1334	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1206	t	module_website_payment	base	ir.module.module
1335	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1207	t	module_website_payment_authorize	base	ir.module.module
1336	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1208	t	module_website_profile	base	ir.module.module
1337	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1209	t	module_website_project	base	ir.module.module
1338	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1210	t	module_website_sale	base	ir.module.module
1339	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1211	t	module_website_sale_autocomplete	base	ir.module.module
1340	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1212	t	module_website_sale_collect	base	ir.module.module
1341	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1213	t	module_website_sale_comparison	base	ir.module.module
1342	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1214	t	module_website_sale_comparison_wishlist	base	ir.module.module
1343	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1215	t	module_website_sale_gelato	base	ir.module.module
1344	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1216	t	module_website_sale_loyalty	base	ir.module.module
1345	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1217	t	module_website_sale_mass_mailing	base	ir.module.module
1346	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1218	t	module_website_sale_mondialrelay	base	ir.module.module
1347	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1219	t	module_website_sale_mrp	base	ir.module.module
1348	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1220	t	module_website_sale_slides	base	ir.module.module
1349	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1221	t	module_website_sale_stock	base	ir.module.module
1350	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1222	t	module_website_sale_stock_wishlist	base	ir.module.module
1351	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1223	t	module_website_sale_wishlist	base	ir.module.module
1352	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	124	t	module_category_website_elearning	base	ir.module.category
1353	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1224	t	module_website_slides	base	ir.module.module
1354	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1225	t	module_website_slides_forum	base	ir.module.module
1355	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1226	t	module_website_slides_survey	base	ir.module.module
1356	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1227	t	module_website_sms	base	ir.module.module
1357	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	f	model_base	base	ir.model
1358	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	f	model__unknown	base	ir.model
1359	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	f	model_ir_model	base	ir.model
1360	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	f	model_ir_model_fields	base	ir.model
1361	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	f	model_ir_model_inherit	base	ir.model
1362	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	6	f	model_ir_model_fields_selection	base	ir.model
1363	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	7	f	model_ir_model_constraint	base	ir.model
1364	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	8	f	model_ir_model_relation	base	ir.model
1365	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	9	f	model_ir_model_access	base	ir.model
1366	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	10	f	model_ir_model_data	base	ir.model
1367	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	11	f	model_wizard_ir_model_menu_create	base	ir.model
1368	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	12	f	model_ir_sequence	base	ir.model
1369	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	13	f	model_ir_sequence_date_range	base	ir.model
1370	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	14	f	model_ir_ui_menu	base	ir.model
1371	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	15	f	model_ir_ui_view_custom	base	ir.model
1372	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	16	f	model_ir_ui_view	base	ir.model
1373	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	17	f	model_reset_view_arch_wizard	base	ir.model
1374	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	18	f	model_ir_asset	base	ir.model
1375	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	19	f	model_ir_actions_actions	base	ir.model
1376	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	20	f	model_ir_actions_act_window	base	ir.model
1377	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	21	f	model_ir_actions_act_window_view	base	ir.model
1378	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	22	f	model_ir_actions_act_window_close	base	ir.model
1379	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	23	f	model_ir_actions_act_url	base	ir.model
1380	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	24	f	model_ir_actions_server	base	ir.model
1381	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	25	f	model_ir_actions_todo	base	ir.model
1382	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	26	f	model_ir_actions_client	base	ir.model
1383	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	27	f	model_ir_embedded_actions	base	ir.model
1384	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	28	f	model_ir_actions_report	base	ir.model
1385	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	29	f	model_ir_attachment	base	ir.model
1386	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	30	f	model_ir_binary	base	ir.model
1387	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	31	f	model_ir_cron	base	ir.model
1388	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	32	f	model_ir_cron_trigger	base	ir.model
1389	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	33	f	model_ir_cron_progress	base	ir.model
1390	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	34	f	model_ir_filters	base	ir.model
1391	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	35	f	model_ir_default	base	ir.model
1392	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	36	f	model_ir_exports	base	ir.model
1393	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	37	f	model_ir_exports_line	base	ir.model
1394	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	38	f	model_ir_rule	base	ir.model
1395	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	39	f	model_ir_config_parameter	base	ir.model
1396	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	40	f	model_ir_autovacuum	base	ir.model
1397	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	41	f	model_ir_mail_server	base	ir.model
1398	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	42	f	model_ir_fields_converter	base	ir.model
1399	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	43	f	model_ir_qweb	base	ir.model
1400	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	44	f	model_ir_qweb_field	base	ir.model
1401	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	45	f	model_ir_qweb_field_integer	base	ir.model
1402	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	46	f	model_ir_qweb_field_float	base	ir.model
1403	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	47	f	model_ir_qweb_field_date	base	ir.model
1404	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	48	f	model_ir_qweb_field_datetime	base	ir.model
1405	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	49	f	model_ir_qweb_field_text	base	ir.model
1406	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	50	f	model_ir_qweb_field_selection	base	ir.model
1407	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	51	f	model_ir_qweb_field_many2one	base	ir.model
1408	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	52	f	model_ir_qweb_field_many2many	base	ir.model
1409	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	53	f	model_ir_qweb_field_one2many	base	ir.model
1410	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	54	f	model_ir_qweb_field_html	base	ir.model
1411	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	55	f	model_ir_qweb_field_image	base	ir.model
1412	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	56	f	model_ir_qweb_field_image_url	base	ir.model
1413	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	57	f	model_ir_qweb_field_monetary	base	ir.model
1414	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	58	f	model_ir_qweb_field_float_time	base	ir.model
1415	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	59	f	model_ir_qweb_field_time	base	ir.model
1416	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	60	f	model_ir_qweb_field_duration	base	ir.model
1417	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	61	f	model_ir_qweb_field_relative	base	ir.model
1418	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	62	f	model_ir_qweb_field_barcode	base	ir.model
1419	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	63	f	model_ir_qweb_field_contact	base	ir.model
1420	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	64	f	model_ir_qweb_field_qweb	base	ir.model
1421	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	65	f	model_ir_http	base	ir.model
1422	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	66	f	model_ir_logging	base	ir.model
1423	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	67	f	model_ir_module_category	base	ir.model
1424	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	68	f	model_ir_module_module	base	ir.model
1425	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	69	f	model_ir_module_module_dependency	base	ir.model
1426	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	70	f	model_ir_module_module_exclusion	base	ir.model
1427	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	71	f	model_ir_demo	base	ir.model
1428	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	72	f	model_ir_demo_failure	base	ir.model
1429	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	73	f	model_ir_demo_failure_wizard	base	ir.model
1430	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	74	f	model_report_layout	base	ir.model
1431	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	75	f	model_report_paperformat	base	ir.model
1432	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	76	f	model_ir_profile	base	ir.model
1433	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	77	f	model_base_enable_profiling_wizard	base	ir.model
1434	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	78	f	model_image_mixin	base	ir.model
1435	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	79	f	model_avatar_mixin	base	ir.model
1436	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	80	f	model_res_country	base	ir.model
1437	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	81	f	model_res_country_group	base	ir.model
1438	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	82	f	model_res_country_state	base	ir.model
1439	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	83	f	model_res_lang	base	ir.model
1440	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	84	f	model_format_vat_label_mixin	base	ir.model
1441	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	85	f	model_format_address_mixin	base	ir.model
1442	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	86	f	model_res_partner_category	base	ir.model
1443	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	87	f	model_res_partner_title	base	ir.model
1444	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	88	f	model_res_partner	base	ir.model
1445	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	89	f	model_res_partner_industry	base	ir.model
1446	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	90	f	model_res_bank	base	ir.model
1447	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	91	f	model_res_partner_bank	base	ir.model
1448	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	92	f	model_res_config	base	ir.model
1449	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	93	f	model_res_config_settings	base	ir.model
1450	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	94	f	model_res_currency	base	ir.model
1451	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	95	f	model_res_currency_rate	base	ir.model
1452	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	96	f	model_res_company	base	ir.model
1453	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	97	f	model_res_groups	base	ir.model
1454	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	98	f	model_res_users_log	base	ir.model
1455	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	99	f	model_res_users	base	ir.model
1456	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	100	f	model_res_users_identitycheck	base	ir.model
1457	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	101	f	model_change_password_wizard	base	ir.model
1458	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	102	f	model_change_password_user	base	ir.model
1459	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	103	f	model_change_password_own	base	ir.model
1460	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	104	f	model_res_users_apikeys	base	ir.model
1461	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	105	f	model_res_users_apikeys_description	base	ir.model
1462	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	106	f	model_res_users_apikeys_show	base	ir.model
1463	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	107	f	model_res_users_settings	base	ir.model
1464	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	108	f	model_res_users_deletion	base	ir.model
1465	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	109	f	model_res_device_log	base	ir.model
1466	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	110	f	model_res_device	base	ir.model
1467	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	111	f	model_decimal_precision	base	ir.model
1468	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	112	f	model_report_base_report_irmodulereference	base	ir.model
1469	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	113	f	model_base_module_update	base	ir.model
1470	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	114	f	model_base_language_install	base	ir.model
1471	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	115	f	model_base_language_import	base	ir.model
1472	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	116	f	model_base_module_upgrade	base	ir.model
1473	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	117	f	model_base_module_uninstall	base	ir.model
1474	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	118	f	model_base_language_export	base	ir.model
1475	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	119	f	model_base_partner_merge_line	base	ir.model
1476	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	120	f	model_base_partner_merge_automatic_wizard	base	ir.model
1477	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	f	field_ir_model__name	base	ir.model.fields
1478	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	f	field_ir_model__model	base	ir.model.fields
1479	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	f	field_ir_model__order	base	ir.model.fields
1480	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	f	field_ir_model__info	base	ir.model.fields
1481	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	f	field_ir_model__field_id	base	ir.model.fields
1482	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	6	f	field_ir_model__inherited_model_ids	base	ir.model.fields
1483	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	7	f	field_ir_model__state	base	ir.model.fields
1484	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	8	f	field_ir_model__access_ids	base	ir.model.fields
1485	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	9	f	field_ir_model__rule_ids	base	ir.model.fields
1486	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	10	f	field_ir_model__transient	base	ir.model.fields
1487	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	11	f	field_ir_model__modules	base	ir.model.fields
1488	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	12	f	field_ir_model__view_ids	base	ir.model.fields
1489	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	13	f	field_ir_model__count	base	ir.model.fields
1490	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	14	f	field_ir_model__id	base	ir.model.fields
1491	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	15	f	field_ir_model__display_name	base	ir.model.fields
1492	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	16	f	field_ir_model__create_uid	base	ir.model.fields
1493	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	17	f	field_ir_model__create_date	base	ir.model.fields
1494	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	18	f	field_ir_model__write_uid	base	ir.model.fields
1495	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	19	f	field_ir_model__write_date	base	ir.model.fields
1496	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	20	f	field_ir_model_fields__name	base	ir.model.fields
1497	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	21	f	field_ir_model_fields__complete_name	base	ir.model.fields
1498	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	22	f	field_ir_model_fields__model	base	ir.model.fields
1499	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	23	f	field_ir_model_fields__relation	base	ir.model.fields
1500	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	24	f	field_ir_model_fields__relation_field	base	ir.model.fields
1501	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	25	f	field_ir_model_fields__relation_field_id	base	ir.model.fields
1502	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	26	f	field_ir_model_fields__model_id	base	ir.model.fields
1503	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	27	f	field_ir_model_fields__field_description	base	ir.model.fields
1504	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	28	f	field_ir_model_fields__help	base	ir.model.fields
1505	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	29	f	field_ir_model_fields__ttype	base	ir.model.fields
1506	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	30	f	field_ir_model_fields__selection	base	ir.model.fields
1507	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	31	f	field_ir_model_fields__selection_ids	base	ir.model.fields
1508	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	32	f	field_ir_model_fields__copied	base	ir.model.fields
1509	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	33	f	field_ir_model_fields__related	base	ir.model.fields
1510	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	34	f	field_ir_model_fields__related_field_id	base	ir.model.fields
1511	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	35	f	field_ir_model_fields__required	base	ir.model.fields
1512	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	36	f	field_ir_model_fields__readonly	base	ir.model.fields
1513	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	37	f	field_ir_model_fields__index	base	ir.model.fields
1514	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	38	f	field_ir_model_fields__translate	base	ir.model.fields
1515	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	39	f	field_ir_model_fields__company_dependent	base	ir.model.fields
1516	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	40	f	field_ir_model_fields__size	base	ir.model.fields
1517	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	41	f	field_ir_model_fields__state	base	ir.model.fields
1518	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	42	f	field_ir_model_fields__on_delete	base	ir.model.fields
1519	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	43	f	field_ir_model_fields__domain	base	ir.model.fields
1520	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	44	f	field_ir_model_fields__groups	base	ir.model.fields
1521	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	45	f	field_ir_model_fields__group_expand	base	ir.model.fields
1522	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	46	f	field_ir_model_fields__selectable	base	ir.model.fields
1523	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	47	f	field_ir_model_fields__modules	base	ir.model.fields
1524	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	48	f	field_ir_model_fields__relation_table	base	ir.model.fields
1525	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	49	f	field_ir_model_fields__column1	base	ir.model.fields
1526	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	50	f	field_ir_model_fields__column2	base	ir.model.fields
1527	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	51	f	field_ir_model_fields__compute	base	ir.model.fields
1528	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	52	f	field_ir_model_fields__depends	base	ir.model.fields
1529	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	53	f	field_ir_model_fields__store	base	ir.model.fields
1530	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	54	f	field_ir_model_fields__currency_field	base	ir.model.fields
1531	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	55	f	field_ir_model_fields__sanitize	base	ir.model.fields
1532	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	56	f	field_ir_model_fields__sanitize_overridable	base	ir.model.fields
1533	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	57	f	field_ir_model_fields__sanitize_tags	base	ir.model.fields
1534	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	58	f	field_ir_model_fields__sanitize_attributes	base	ir.model.fields
1535	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	59	f	field_ir_model_fields__sanitize_style	base	ir.model.fields
1536	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	60	f	field_ir_model_fields__sanitize_form	base	ir.model.fields
1537	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	61	f	field_ir_model_fields__strip_style	base	ir.model.fields
1538	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	62	f	field_ir_model_fields__strip_classes	base	ir.model.fields
1539	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	63	f	field_ir_model_fields__id	base	ir.model.fields
1540	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	64	f	field_ir_model_fields__display_name	base	ir.model.fields
1541	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	65	f	field_ir_model_fields__create_uid	base	ir.model.fields
1542	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	66	f	field_ir_model_fields__create_date	base	ir.model.fields
1543	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	67	f	field_ir_model_fields__write_uid	base	ir.model.fields
1544	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	68	f	field_ir_model_fields__write_date	base	ir.model.fields
1545	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	69	f	field_ir_model_inherit__model_id	base	ir.model.fields
1546	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	70	f	field_ir_model_inherit__parent_id	base	ir.model.fields
1547	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	71	f	field_ir_model_inherit__parent_field_id	base	ir.model.fields
1548	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	72	f	field_ir_model_inherit__id	base	ir.model.fields
1549	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	73	f	field_ir_model_inherit__display_name	base	ir.model.fields
1550	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	74	f	field_ir_model_fields_selection__field_id	base	ir.model.fields
1551	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	75	f	field_ir_model_fields_selection__value	base	ir.model.fields
1552	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	76	f	field_ir_model_fields_selection__name	base	ir.model.fields
1553	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	77	f	field_ir_model_fields_selection__sequence	base	ir.model.fields
1554	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	78	f	field_ir_model_fields_selection__id	base	ir.model.fields
1555	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	79	f	field_ir_model_fields_selection__display_name	base	ir.model.fields
1556	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	80	f	field_ir_model_fields_selection__create_uid	base	ir.model.fields
1557	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	81	f	field_ir_model_fields_selection__create_date	base	ir.model.fields
1558	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	82	f	field_ir_model_fields_selection__write_uid	base	ir.model.fields
1559	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	83	f	field_ir_model_fields_selection__write_date	base	ir.model.fields
1560	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	84	f	field_ir_model_constraint__name	base	ir.model.fields
1561	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	85	f	field_ir_model_constraint__definition	base	ir.model.fields
1562	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	86	f	field_ir_model_constraint__message	base	ir.model.fields
1563	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	87	f	field_ir_model_constraint__model	base	ir.model.fields
1564	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	88	f	field_ir_model_constraint__module	base	ir.model.fields
1565	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	89	f	field_ir_model_constraint__type	base	ir.model.fields
1566	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	90	f	field_ir_model_constraint__write_date	base	ir.model.fields
1567	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	91	f	field_ir_model_constraint__create_date	base	ir.model.fields
1568	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	92	f	field_ir_model_constraint__id	base	ir.model.fields
1569	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	93	f	field_ir_model_constraint__display_name	base	ir.model.fields
1570	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	94	f	field_ir_model_constraint__create_uid	base	ir.model.fields
1571	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	95	f	field_ir_model_constraint__write_uid	base	ir.model.fields
1572	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	96	f	field_ir_model_relation__name	base	ir.model.fields
1573	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	97	f	field_ir_model_relation__model	base	ir.model.fields
1574	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	98	f	field_ir_model_relation__module	base	ir.model.fields
1575	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	99	f	field_ir_model_relation__write_date	base	ir.model.fields
1576	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	100	f	field_ir_model_relation__create_date	base	ir.model.fields
1577	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	101	f	field_ir_model_relation__id	base	ir.model.fields
1578	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	102	f	field_ir_model_relation__display_name	base	ir.model.fields
1579	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	103	f	field_ir_model_relation__create_uid	base	ir.model.fields
1580	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	104	f	field_ir_model_relation__write_uid	base	ir.model.fields
1581	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	105	f	field_ir_model_access__name	base	ir.model.fields
1582	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	106	f	field_ir_model_access__active	base	ir.model.fields
1583	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	107	f	field_ir_model_access__model_id	base	ir.model.fields
1584	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	108	f	field_ir_model_access__group_id	base	ir.model.fields
1585	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	109	f	field_ir_model_access__perm_read	base	ir.model.fields
1586	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	110	f	field_ir_model_access__perm_write	base	ir.model.fields
1587	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	111	f	field_ir_model_access__perm_create	base	ir.model.fields
1588	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	112	f	field_ir_model_access__perm_unlink	base	ir.model.fields
1589	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	113	f	field_ir_model_access__id	base	ir.model.fields
1590	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	114	f	field_ir_model_access__display_name	base	ir.model.fields
1591	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	115	f	field_ir_model_access__create_uid	base	ir.model.fields
1592	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	116	f	field_ir_model_access__create_date	base	ir.model.fields
1593	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	117	f	field_ir_model_access__write_uid	base	ir.model.fields
1594	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	118	f	field_ir_model_access__write_date	base	ir.model.fields
1595	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	119	f	field_ir_model_data__name	base	ir.model.fields
1596	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	120	f	field_ir_model_data__complete_name	base	ir.model.fields
1597	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	121	f	field_ir_model_data__model	base	ir.model.fields
1598	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	122	f	field_ir_model_data__module	base	ir.model.fields
1599	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	123	f	field_ir_model_data__res_id	base	ir.model.fields
1600	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	124	f	field_ir_model_data__noupdate	base	ir.model.fields
1601	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	125	f	field_ir_model_data__reference	base	ir.model.fields
1602	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	126	f	field_ir_model_data__id	base	ir.model.fields
1603	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	127	f	field_ir_model_data__display_name	base	ir.model.fields
1604	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	128	f	field_ir_model_data__create_uid	base	ir.model.fields
1605	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	129	f	field_ir_model_data__create_date	base	ir.model.fields
1606	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	130	f	field_ir_model_data__write_uid	base	ir.model.fields
1607	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	131	f	field_ir_model_data__write_date	base	ir.model.fields
1608	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	132	f	field_wizard_ir_model_menu_create__menu_id	base	ir.model.fields
1609	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	133	f	field_wizard_ir_model_menu_create__name	base	ir.model.fields
1610	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	134	f	field_wizard_ir_model_menu_create__id	base	ir.model.fields
1611	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	135	f	field_wizard_ir_model_menu_create__display_name	base	ir.model.fields
1612	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	136	f	field_wizard_ir_model_menu_create__create_uid	base	ir.model.fields
1613	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	137	f	field_wizard_ir_model_menu_create__create_date	base	ir.model.fields
1614	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	138	f	field_wizard_ir_model_menu_create__write_uid	base	ir.model.fields
1615	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	139	f	field_wizard_ir_model_menu_create__write_date	base	ir.model.fields
1616	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	140	f	field_ir_sequence__name	base	ir.model.fields
1617	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	141	f	field_ir_sequence__code	base	ir.model.fields
1618	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	142	f	field_ir_sequence__implementation	base	ir.model.fields
1619	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	143	f	field_ir_sequence__active	base	ir.model.fields
1620	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	144	f	field_ir_sequence__prefix	base	ir.model.fields
1621	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	145	f	field_ir_sequence__suffix	base	ir.model.fields
1622	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	146	f	field_ir_sequence__number_next	base	ir.model.fields
1623	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	147	f	field_ir_sequence__number_next_actual	base	ir.model.fields
1624	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	148	f	field_ir_sequence__number_increment	base	ir.model.fields
1625	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	149	f	field_ir_sequence__padding	base	ir.model.fields
1626	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	150	f	field_ir_sequence__company_id	base	ir.model.fields
1627	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	151	f	field_ir_sequence__use_date_range	base	ir.model.fields
1628	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	152	f	field_ir_sequence__date_range_ids	base	ir.model.fields
1629	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	153	f	field_ir_sequence__id	base	ir.model.fields
1630	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	154	f	field_ir_sequence__display_name	base	ir.model.fields
1631	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	155	f	field_ir_sequence__create_uid	base	ir.model.fields
1632	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	156	f	field_ir_sequence__create_date	base	ir.model.fields
1633	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	157	f	field_ir_sequence__write_uid	base	ir.model.fields
1634	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	158	f	field_ir_sequence__write_date	base	ir.model.fields
1635	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	159	f	field_ir_sequence_date_range__date_from	base	ir.model.fields
1636	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	160	f	field_ir_sequence_date_range__date_to	base	ir.model.fields
1637	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	161	f	field_ir_sequence_date_range__sequence_id	base	ir.model.fields
1638	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	162	f	field_ir_sequence_date_range__number_next	base	ir.model.fields
1639	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	163	f	field_ir_sequence_date_range__number_next_actual	base	ir.model.fields
1640	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	164	f	field_ir_sequence_date_range__id	base	ir.model.fields
1641	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	165	f	field_ir_sequence_date_range__display_name	base	ir.model.fields
1642	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	166	f	field_ir_sequence_date_range__create_uid	base	ir.model.fields
1643	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	167	f	field_ir_sequence_date_range__create_date	base	ir.model.fields
1644	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	168	f	field_ir_sequence_date_range__write_uid	base	ir.model.fields
1645	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	169	f	field_ir_sequence_date_range__write_date	base	ir.model.fields
1646	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	170	f	field_ir_ui_menu__name	base	ir.model.fields
1647	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	171	f	field_ir_ui_menu__active	base	ir.model.fields
1648	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	172	f	field_ir_ui_menu__sequence	base	ir.model.fields
1649	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	173	f	field_ir_ui_menu__child_id	base	ir.model.fields
1650	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	174	f	field_ir_ui_menu__parent_id	base	ir.model.fields
1651	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	175	f	field_ir_ui_menu__parent_path	base	ir.model.fields
1652	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	176	f	field_ir_ui_menu__groups_id	base	ir.model.fields
1653	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	177	f	field_ir_ui_menu__complete_name	base	ir.model.fields
1654	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	178	f	field_ir_ui_menu__web_icon	base	ir.model.fields
1655	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	179	f	field_ir_ui_menu__action	base	ir.model.fields
1656	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	180	f	field_ir_ui_menu__web_icon_data	base	ir.model.fields
1657	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	181	f	field_ir_ui_menu__id	base	ir.model.fields
1658	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	182	f	field_ir_ui_menu__display_name	base	ir.model.fields
1659	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	183	f	field_ir_ui_menu__create_uid	base	ir.model.fields
1660	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	184	f	field_ir_ui_menu__create_date	base	ir.model.fields
1661	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	185	f	field_ir_ui_menu__write_uid	base	ir.model.fields
1662	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	186	f	field_ir_ui_menu__write_date	base	ir.model.fields
1663	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	187	f	field_ir_ui_view_custom__ref_id	base	ir.model.fields
1664	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	188	f	field_ir_ui_view_custom__user_id	base	ir.model.fields
1665	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	189	f	field_ir_ui_view_custom__arch	base	ir.model.fields
1666	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	190	f	field_ir_ui_view_custom__id	base	ir.model.fields
1667	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	191	f	field_ir_ui_view_custom__display_name	base	ir.model.fields
1668	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	192	f	field_ir_ui_view_custom__create_uid	base	ir.model.fields
1669	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	193	f	field_ir_ui_view_custom__create_date	base	ir.model.fields
1670	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	194	f	field_ir_ui_view_custom__write_uid	base	ir.model.fields
1671	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	195	f	field_ir_ui_view_custom__write_date	base	ir.model.fields
1672	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	196	f	field_ir_ui_view__name	base	ir.model.fields
1673	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	197	f	field_ir_ui_view__model	base	ir.model.fields
1674	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	198	f	field_ir_ui_view__key	base	ir.model.fields
1675	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	199	f	field_ir_ui_view__priority	base	ir.model.fields
1676	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	200	f	field_ir_ui_view__type	base	ir.model.fields
1677	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	201	f	field_ir_ui_view__arch	base	ir.model.fields
1678	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	202	f	field_ir_ui_view__arch_base	base	ir.model.fields
1679	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	203	f	field_ir_ui_view__arch_db	base	ir.model.fields
1680	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	204	f	field_ir_ui_view__arch_fs	base	ir.model.fields
1681	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	205	f	field_ir_ui_view__arch_updated	base	ir.model.fields
1682	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	206	f	field_ir_ui_view__arch_prev	base	ir.model.fields
1683	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	207	f	field_ir_ui_view__inherit_id	base	ir.model.fields
1684	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	208	f	field_ir_ui_view__inherit_children_ids	base	ir.model.fields
1685	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	209	f	field_ir_ui_view__model_data_id	base	ir.model.fields
1686	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	210	f	field_ir_ui_view__xml_id	base	ir.model.fields
1687	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	211	f	field_ir_ui_view__groups_id	base	ir.model.fields
1688	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	212	f	field_ir_ui_view__mode	base	ir.model.fields
1689	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	213	f	field_ir_ui_view__warning_info	base	ir.model.fields
1690	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	214	f	field_ir_ui_view__active	base	ir.model.fields
1691	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	215	f	field_ir_ui_view__model_id	base	ir.model.fields
1692	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	216	f	field_ir_ui_view__id	base	ir.model.fields
1693	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	217	f	field_ir_ui_view__display_name	base	ir.model.fields
1694	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	218	f	field_ir_ui_view__create_uid	base	ir.model.fields
1695	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	219	f	field_ir_ui_view__create_date	base	ir.model.fields
1696	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	220	f	field_ir_ui_view__write_uid	base	ir.model.fields
1697	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	221	f	field_ir_ui_view__write_date	base	ir.model.fields
1698	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	222	f	field_reset_view_arch_wizard__view_id	base	ir.model.fields
1699	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	223	f	field_reset_view_arch_wizard__view_name	base	ir.model.fields
1700	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	224	f	field_reset_view_arch_wizard__has_diff	base	ir.model.fields
1701	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	225	f	field_reset_view_arch_wizard__arch_diff	base	ir.model.fields
1702	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	226	f	field_reset_view_arch_wizard__reset_mode	base	ir.model.fields
1703	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	227	f	field_reset_view_arch_wizard__compare_view_id	base	ir.model.fields
1704	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	228	f	field_reset_view_arch_wizard__arch_to_compare	base	ir.model.fields
1705	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	229	f	field_reset_view_arch_wizard__id	base	ir.model.fields
1706	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	230	f	field_reset_view_arch_wizard__display_name	base	ir.model.fields
1707	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	231	f	field_reset_view_arch_wizard__create_uid	base	ir.model.fields
1708	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	232	f	field_reset_view_arch_wizard__create_date	base	ir.model.fields
1709	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	233	f	field_reset_view_arch_wizard__write_uid	base	ir.model.fields
1710	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	234	f	field_reset_view_arch_wizard__write_date	base	ir.model.fields
1711	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	235	f	field_ir_asset__name	base	ir.model.fields
1712	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	236	f	field_ir_asset__bundle	base	ir.model.fields
1713	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	237	f	field_ir_asset__directive	base	ir.model.fields
1714	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	238	f	field_ir_asset__path	base	ir.model.fields
1715	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	239	f	field_ir_asset__target	base	ir.model.fields
1716	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	240	f	field_ir_asset__active	base	ir.model.fields
1717	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	241	f	field_ir_asset__sequence	base	ir.model.fields
1718	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	242	f	field_ir_asset__id	base	ir.model.fields
1719	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	243	f	field_ir_asset__display_name	base	ir.model.fields
1720	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	244	f	field_ir_asset__create_uid	base	ir.model.fields
1721	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	245	f	field_ir_asset__create_date	base	ir.model.fields
1722	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	246	f	field_ir_asset__write_uid	base	ir.model.fields
1723	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	247	f	field_ir_asset__write_date	base	ir.model.fields
1724	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	248	f	field_ir_actions_actions__name	base	ir.model.fields
1725	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	249	f	field_ir_actions_actions__type	base	ir.model.fields
1726	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	250	f	field_ir_actions_actions__xml_id	base	ir.model.fields
1727	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	251	f	field_ir_actions_actions__path	base	ir.model.fields
1728	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	252	f	field_ir_actions_actions__help	base	ir.model.fields
1729	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	253	f	field_ir_actions_actions__binding_model_id	base	ir.model.fields
1730	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	254	f	field_ir_actions_actions__binding_type	base	ir.model.fields
1731	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	255	f	field_ir_actions_actions__binding_view_types	base	ir.model.fields
1732	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	256	f	field_ir_actions_actions__id	base	ir.model.fields
1733	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	257	f	field_ir_actions_actions__display_name	base	ir.model.fields
1734	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	258	f	field_ir_actions_actions__create_uid	base	ir.model.fields
1735	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	259	f	field_ir_actions_actions__create_date	base	ir.model.fields
1736	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	260	f	field_ir_actions_actions__write_uid	base	ir.model.fields
1737	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	261	f	field_ir_actions_actions__write_date	base	ir.model.fields
1738	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	262	f	field_ir_actions_act_window__name	base	ir.model.fields
1739	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	263	f	field_ir_actions_act_window__type	base	ir.model.fields
1740	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	264	f	field_ir_actions_act_window__xml_id	base	ir.model.fields
1741	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	265	f	field_ir_actions_act_window__path	base	ir.model.fields
1742	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	266	f	field_ir_actions_act_window__help	base	ir.model.fields
1743	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	267	f	field_ir_actions_act_window__binding_model_id	base	ir.model.fields
1744	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	268	f	field_ir_actions_act_window__binding_type	base	ir.model.fields
1745	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	269	f	field_ir_actions_act_window__binding_view_types	base	ir.model.fields
1746	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	270	f	field_ir_actions_act_window__id	base	ir.model.fields
1747	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	271	f	field_ir_actions_act_window__display_name	base	ir.model.fields
1748	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	272	f	field_ir_actions_act_window__create_uid	base	ir.model.fields
1749	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	273	f	field_ir_actions_act_window__create_date	base	ir.model.fields
1750	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	274	f	field_ir_actions_act_window__write_uid	base	ir.model.fields
1751	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	275	f	field_ir_actions_act_window__write_date	base	ir.model.fields
1752	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	276	f	field_ir_actions_act_window__view_id	base	ir.model.fields
1753	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	277	f	field_ir_actions_act_window__domain	base	ir.model.fields
1754	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	278	f	field_ir_actions_act_window__context	base	ir.model.fields
1755	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	279	f	field_ir_actions_act_window__res_id	base	ir.model.fields
1756	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	280	f	field_ir_actions_act_window__res_model	base	ir.model.fields
1757	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	281	f	field_ir_actions_act_window__target	base	ir.model.fields
1758	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	282	f	field_ir_actions_act_window__view_mode	base	ir.model.fields
1759	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	283	f	field_ir_actions_act_window__mobile_view_mode	base	ir.model.fields
1760	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	284	f	field_ir_actions_act_window__usage	base	ir.model.fields
1761	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	285	f	field_ir_actions_act_window__view_ids	base	ir.model.fields
1762	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	286	f	field_ir_actions_act_window__views	base	ir.model.fields
1763	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	287	f	field_ir_actions_act_window__limit	base	ir.model.fields
1764	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	288	f	field_ir_actions_act_window__groups_id	base	ir.model.fields
1765	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	289	f	field_ir_actions_act_window__search_view_id	base	ir.model.fields
1766	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	290	f	field_ir_actions_act_window__embedded_action_ids	base	ir.model.fields
1767	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	291	f	field_ir_actions_act_window__filter	base	ir.model.fields
1768	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	292	f	field_ir_actions_act_window_view__sequence	base	ir.model.fields
1769	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	293	f	field_ir_actions_act_window_view__view_id	base	ir.model.fields
1770	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	294	f	field_ir_actions_act_window_view__view_mode	base	ir.model.fields
1771	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	295	f	field_ir_actions_act_window_view__act_window_id	base	ir.model.fields
1772	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	296	f	field_ir_actions_act_window_view__multi	base	ir.model.fields
1773	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	297	f	field_ir_actions_act_window_view__id	base	ir.model.fields
1774	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	298	f	field_ir_actions_act_window_view__display_name	base	ir.model.fields
1775	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	299	f	field_ir_actions_act_window_view__create_uid	base	ir.model.fields
1776	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	300	f	field_ir_actions_act_window_view__create_date	base	ir.model.fields
1777	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	301	f	field_ir_actions_act_window_view__write_uid	base	ir.model.fields
1778	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	302	f	field_ir_actions_act_window_view__write_date	base	ir.model.fields
1779	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	303	f	field_ir_actions_act_window_close__name	base	ir.model.fields
1780	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	304	f	field_ir_actions_act_window_close__type	base	ir.model.fields
1781	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	305	f	field_ir_actions_act_window_close__xml_id	base	ir.model.fields
1782	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	306	f	field_ir_actions_act_window_close__path	base	ir.model.fields
1783	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	307	f	field_ir_actions_act_window_close__help	base	ir.model.fields
1784	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	308	f	field_ir_actions_act_window_close__binding_model_id	base	ir.model.fields
1785	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	309	f	field_ir_actions_act_window_close__binding_type	base	ir.model.fields
1786	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	310	f	field_ir_actions_act_window_close__binding_view_types	base	ir.model.fields
1787	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	311	f	field_ir_actions_act_window_close__id	base	ir.model.fields
1788	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	312	f	field_ir_actions_act_window_close__display_name	base	ir.model.fields
1789	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	313	f	field_ir_actions_act_window_close__create_uid	base	ir.model.fields
1790	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	314	f	field_ir_actions_act_window_close__create_date	base	ir.model.fields
1791	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	315	f	field_ir_actions_act_window_close__write_uid	base	ir.model.fields
1792	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	316	f	field_ir_actions_act_window_close__write_date	base	ir.model.fields
1793	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	317	f	field_ir_actions_act_url__name	base	ir.model.fields
1794	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	318	f	field_ir_actions_act_url__type	base	ir.model.fields
1795	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	319	f	field_ir_actions_act_url__xml_id	base	ir.model.fields
1796	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	320	f	field_ir_actions_act_url__path	base	ir.model.fields
1797	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	321	f	field_ir_actions_act_url__help	base	ir.model.fields
1798	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	322	f	field_ir_actions_act_url__binding_model_id	base	ir.model.fields
1799	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	323	f	field_ir_actions_act_url__binding_type	base	ir.model.fields
1800	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	324	f	field_ir_actions_act_url__binding_view_types	base	ir.model.fields
1801	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	325	f	field_ir_actions_act_url__id	base	ir.model.fields
1802	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	326	f	field_ir_actions_act_url__display_name	base	ir.model.fields
1803	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	327	f	field_ir_actions_act_url__create_uid	base	ir.model.fields
1804	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	328	f	field_ir_actions_act_url__create_date	base	ir.model.fields
1805	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	329	f	field_ir_actions_act_url__write_uid	base	ir.model.fields
1806	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	330	f	field_ir_actions_act_url__write_date	base	ir.model.fields
1807	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	331	f	field_ir_actions_act_url__url	base	ir.model.fields
1808	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	332	f	field_ir_actions_act_url__target	base	ir.model.fields
1809	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	333	f	field_ir_actions_server__name	base	ir.model.fields
1810	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	334	f	field_ir_actions_server__type	base	ir.model.fields
1811	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	335	f	field_ir_actions_server__xml_id	base	ir.model.fields
1812	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	336	f	field_ir_actions_server__path	base	ir.model.fields
1813	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	337	f	field_ir_actions_server__help	base	ir.model.fields
1814	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	338	f	field_ir_actions_server__binding_model_id	base	ir.model.fields
1815	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	339	f	field_ir_actions_server__binding_type	base	ir.model.fields
1816	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	340	f	field_ir_actions_server__binding_view_types	base	ir.model.fields
1817	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	341	f	field_ir_actions_server__id	base	ir.model.fields
1818	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	342	f	field_ir_actions_server__display_name	base	ir.model.fields
1819	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	343	f	field_ir_actions_server__create_uid	base	ir.model.fields
1820	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	344	f	field_ir_actions_server__create_date	base	ir.model.fields
1821	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	345	f	field_ir_actions_server__write_uid	base	ir.model.fields
1822	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	346	f	field_ir_actions_server__write_date	base	ir.model.fields
1823	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	347	f	field_ir_actions_server__usage	base	ir.model.fields
1824	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	348	f	field_ir_actions_server__state	base	ir.model.fields
1825	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	349	f	field_ir_actions_server__sequence	base	ir.model.fields
1826	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	350	f	field_ir_actions_server__model_id	base	ir.model.fields
1827	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	351	f	field_ir_actions_server__available_model_ids	base	ir.model.fields
1828	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	352	f	field_ir_actions_server__model_name	base	ir.model.fields
1829	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	353	f	field_ir_actions_server__code	base	ir.model.fields
1830	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	354	f	field_ir_actions_server__child_ids	base	ir.model.fields
1831	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	355	f	field_ir_actions_server__crud_model_id	base	ir.model.fields
1832	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	356	f	field_ir_actions_server__crud_model_name	base	ir.model.fields
1833	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	357	f	field_ir_actions_server__link_field_id	base	ir.model.fields
1834	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	358	f	field_ir_actions_server__groups_id	base	ir.model.fields
1835	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	359	f	field_ir_actions_server__update_field_id	base	ir.model.fields
1836	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	360	f	field_ir_actions_server__update_path	base	ir.model.fields
1837	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	361	f	field_ir_actions_server__update_related_model_id	base	ir.model.fields
1838	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	362	f	field_ir_actions_server__update_field_type	base	ir.model.fields
1839	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	363	f	field_ir_actions_server__update_m2m_operation	base	ir.model.fields
1840	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	364	f	field_ir_actions_server__update_boolean_value	base	ir.model.fields
1841	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	365	f	field_ir_actions_server__value	base	ir.model.fields
1842	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	366	f	field_ir_actions_server__evaluation_type	base	ir.model.fields
1843	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	367	f	field_ir_actions_server__resource_ref	base	ir.model.fields
1844	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	368	f	field_ir_actions_server__selection_value	base	ir.model.fields
1845	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	369	f	field_ir_actions_server__value_field_to_show	base	ir.model.fields
1846	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	370	f	field_ir_actions_server__webhook_url	base	ir.model.fields
1847	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	371	f	field_ir_actions_server__webhook_field_ids	base	ir.model.fields
1848	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	372	f	field_ir_actions_server__webhook_sample_payload	base	ir.model.fields
1849	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	373	f	field_ir_actions_todo__action_id	base	ir.model.fields
1850	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	374	f	field_ir_actions_todo__sequence	base	ir.model.fields
1851	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	375	f	field_ir_actions_todo__state	base	ir.model.fields
1852	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	376	f	field_ir_actions_todo__name	base	ir.model.fields
1853	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	377	f	field_ir_actions_todo__id	base	ir.model.fields
1854	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	378	f	field_ir_actions_todo__display_name	base	ir.model.fields
1855	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	379	f	field_ir_actions_todo__create_uid	base	ir.model.fields
1856	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	380	f	field_ir_actions_todo__create_date	base	ir.model.fields
1857	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	381	f	field_ir_actions_todo__write_uid	base	ir.model.fields
1858	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	382	f	field_ir_actions_todo__write_date	base	ir.model.fields
1859	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	383	f	field_ir_actions_client__name	base	ir.model.fields
1860	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	384	f	field_ir_actions_client__type	base	ir.model.fields
1861	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	385	f	field_ir_actions_client__xml_id	base	ir.model.fields
1862	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	386	f	field_ir_actions_client__path	base	ir.model.fields
1863	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	387	f	field_ir_actions_client__help	base	ir.model.fields
1864	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	388	f	field_ir_actions_client__binding_model_id	base	ir.model.fields
1865	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	389	f	field_ir_actions_client__binding_type	base	ir.model.fields
1866	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	390	f	field_ir_actions_client__binding_view_types	base	ir.model.fields
1867	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	391	f	field_ir_actions_client__id	base	ir.model.fields
1868	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	392	f	field_ir_actions_client__display_name	base	ir.model.fields
1869	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	393	f	field_ir_actions_client__create_uid	base	ir.model.fields
1870	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	394	f	field_ir_actions_client__create_date	base	ir.model.fields
1871	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	395	f	field_ir_actions_client__write_uid	base	ir.model.fields
1872	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	396	f	field_ir_actions_client__write_date	base	ir.model.fields
1873	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	397	f	field_ir_actions_client__tag	base	ir.model.fields
1874	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	398	f	field_ir_actions_client__target	base	ir.model.fields
1875	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	399	f	field_ir_actions_client__res_model	base	ir.model.fields
1876	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	400	f	field_ir_actions_client__context	base	ir.model.fields
1877	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	401	f	field_ir_actions_client__params	base	ir.model.fields
1878	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	402	f	field_ir_actions_client__params_store	base	ir.model.fields
1879	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	403	f	field_ir_embedded_actions__name	base	ir.model.fields
1880	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	404	f	field_ir_embedded_actions__sequence	base	ir.model.fields
1881	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	405	f	field_ir_embedded_actions__parent_action_id	base	ir.model.fields
1882	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	406	f	field_ir_embedded_actions__parent_res_id	base	ir.model.fields
1883	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	407	f	field_ir_embedded_actions__parent_res_model	base	ir.model.fields
1884	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	408	f	field_ir_embedded_actions__action_id	base	ir.model.fields
1885	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	409	f	field_ir_embedded_actions__python_method	base	ir.model.fields
1886	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	410	f	field_ir_embedded_actions__user_id	base	ir.model.fields
1887	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	411	f	field_ir_embedded_actions__is_deletable	base	ir.model.fields
1888	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	412	f	field_ir_embedded_actions__default_view_mode	base	ir.model.fields
1889	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	413	f	field_ir_embedded_actions__filter_ids	base	ir.model.fields
1890	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	414	f	field_ir_embedded_actions__is_visible	base	ir.model.fields
1891	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	415	f	field_ir_embedded_actions__domain	base	ir.model.fields
1892	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	416	f	field_ir_embedded_actions__context	base	ir.model.fields
1893	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	417	f	field_ir_embedded_actions__groups_ids	base	ir.model.fields
1894	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	418	f	field_ir_embedded_actions__id	base	ir.model.fields
1895	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	419	f	field_ir_embedded_actions__display_name	base	ir.model.fields
1896	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	420	f	field_ir_embedded_actions__create_uid	base	ir.model.fields
1897	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	421	f	field_ir_embedded_actions__create_date	base	ir.model.fields
1898	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	422	f	field_ir_embedded_actions__write_uid	base	ir.model.fields
1899	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	423	f	field_ir_embedded_actions__write_date	base	ir.model.fields
1900	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	424	f	field_ir_actions_report__name	base	ir.model.fields
1901	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	425	f	field_ir_actions_report__type	base	ir.model.fields
1902	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	426	f	field_ir_actions_report__xml_id	base	ir.model.fields
1903	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	427	f	field_ir_actions_report__path	base	ir.model.fields
1904	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	428	f	field_ir_actions_report__help	base	ir.model.fields
1905	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	429	f	field_ir_actions_report__binding_model_id	base	ir.model.fields
1906	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	430	f	field_ir_actions_report__binding_type	base	ir.model.fields
1907	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	431	f	field_ir_actions_report__binding_view_types	base	ir.model.fields
1908	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	432	f	field_ir_actions_report__id	base	ir.model.fields
1909	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	433	f	field_ir_actions_report__display_name	base	ir.model.fields
3901	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	80	f	lang_es_PY	base	res.lang
1910	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	434	f	field_ir_actions_report__create_uid	base	ir.model.fields
1911	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	435	f	field_ir_actions_report__create_date	base	ir.model.fields
1912	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	436	f	field_ir_actions_report__write_uid	base	ir.model.fields
1913	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	437	f	field_ir_actions_report__write_date	base	ir.model.fields
1914	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	438	f	field_ir_actions_report__model	base	ir.model.fields
1915	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	439	f	field_ir_actions_report__model_id	base	ir.model.fields
1916	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	440	f	field_ir_actions_report__report_type	base	ir.model.fields
1917	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	441	f	field_ir_actions_report__report_name	base	ir.model.fields
1918	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	442	f	field_ir_actions_report__report_file	base	ir.model.fields
1919	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	443	f	field_ir_actions_report__groups_id	base	ir.model.fields
1920	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	444	f	field_ir_actions_report__multi	base	ir.model.fields
1921	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	445	f	field_ir_actions_report__paperformat_id	base	ir.model.fields
1922	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	446	f	field_ir_actions_report__print_report_name	base	ir.model.fields
1923	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	447	f	field_ir_actions_report__attachment_use	base	ir.model.fields
1924	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	448	f	field_ir_actions_report__attachment	base	ir.model.fields
1925	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	449	f	field_ir_actions_report__domain	base	ir.model.fields
1926	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	450	f	field_ir_attachment__name	base	ir.model.fields
1927	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	451	f	field_ir_attachment__description	base	ir.model.fields
1928	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	452	f	field_ir_attachment__res_name	base	ir.model.fields
1929	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	453	f	field_ir_attachment__res_model	base	ir.model.fields
1930	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	454	f	field_ir_attachment__res_field	base	ir.model.fields
1931	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	455	f	field_ir_attachment__res_id	base	ir.model.fields
1932	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	456	f	field_ir_attachment__company_id	base	ir.model.fields
1933	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	457	f	field_ir_attachment__type	base	ir.model.fields
1934	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	458	f	field_ir_attachment__url	base	ir.model.fields
1935	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	459	f	field_ir_attachment__public	base	ir.model.fields
1936	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	460	f	field_ir_attachment__access_token	base	ir.model.fields
1937	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	461	f	field_ir_attachment__raw	base	ir.model.fields
1938	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	462	f	field_ir_attachment__datas	base	ir.model.fields
1939	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	463	f	field_ir_attachment__db_datas	base	ir.model.fields
1940	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	464	f	field_ir_attachment__store_fname	base	ir.model.fields
1941	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	465	f	field_ir_attachment__file_size	base	ir.model.fields
1942	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	466	f	field_ir_attachment__checksum	base	ir.model.fields
1943	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	467	f	field_ir_attachment__mimetype	base	ir.model.fields
1944	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	468	f	field_ir_attachment__index_content	base	ir.model.fields
1945	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	469	f	field_ir_attachment__id	base	ir.model.fields
1946	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	470	f	field_ir_attachment__display_name	base	ir.model.fields
1947	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	471	f	field_ir_attachment__create_uid	base	ir.model.fields
1948	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	472	f	field_ir_attachment__create_date	base	ir.model.fields
1949	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	473	f	field_ir_attachment__write_uid	base	ir.model.fields
1950	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	474	f	field_ir_attachment__write_date	base	ir.model.fields
1951	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	475	f	field_ir_cron__ir_actions_server_id	base	ir.model.fields
1952	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	476	f	field_ir_cron__cron_name	base	ir.model.fields
1953	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	477	f	field_ir_cron__user_id	base	ir.model.fields
1954	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	478	f	field_ir_cron__active	base	ir.model.fields
1955	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	479	f	field_ir_cron__interval_number	base	ir.model.fields
1956	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	480	f	field_ir_cron__interval_type	base	ir.model.fields
1957	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	481	f	field_ir_cron__nextcall	base	ir.model.fields
1958	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	482	f	field_ir_cron__lastcall	base	ir.model.fields
1959	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	483	f	field_ir_cron__priority	base	ir.model.fields
1960	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	484	f	field_ir_cron__failure_count	base	ir.model.fields
1961	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	485	f	field_ir_cron__first_failure_date	base	ir.model.fields
1962	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	486	f	field_ir_cron__id	base	ir.model.fields
1963	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	487	f	field_ir_cron__display_name	base	ir.model.fields
1964	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	488	f	field_ir_cron__create_uid	base	ir.model.fields
1965	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	489	f	field_ir_cron__create_date	base	ir.model.fields
1966	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	490	f	field_ir_cron__write_uid	base	ir.model.fields
1967	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	491	f	field_ir_cron__write_date	base	ir.model.fields
1968	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	492	f	field_ir_cron__name	base	ir.model.fields
1969	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	493	f	field_ir_cron__type	base	ir.model.fields
1970	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	494	f	field_ir_cron__xml_id	base	ir.model.fields
1971	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	495	f	field_ir_cron__path	base	ir.model.fields
1972	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	496	f	field_ir_cron__help	base	ir.model.fields
1973	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	497	f	field_ir_cron__binding_model_id	base	ir.model.fields
1974	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	498	f	field_ir_cron__binding_type	base	ir.model.fields
1975	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	499	f	field_ir_cron__binding_view_types	base	ir.model.fields
1976	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	500	f	field_ir_cron__usage	base	ir.model.fields
1977	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	501	f	field_ir_cron__state	base	ir.model.fields
1978	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	502	f	field_ir_cron__sequence	base	ir.model.fields
1979	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	503	f	field_ir_cron__model_id	base	ir.model.fields
1980	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	504	f	field_ir_cron__available_model_ids	base	ir.model.fields
1981	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	505	f	field_ir_cron__model_name	base	ir.model.fields
1982	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	506	f	field_ir_cron__code	base	ir.model.fields
1983	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	507	f	field_ir_cron__child_ids	base	ir.model.fields
1984	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	508	f	field_ir_cron__crud_model_id	base	ir.model.fields
1985	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	509	f	field_ir_cron__crud_model_name	base	ir.model.fields
1986	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	510	f	field_ir_cron__link_field_id	base	ir.model.fields
1987	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	511	f	field_ir_cron__groups_id	base	ir.model.fields
1988	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	512	f	field_ir_cron__update_field_id	base	ir.model.fields
1989	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	513	f	field_ir_cron__update_path	base	ir.model.fields
1990	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	514	f	field_ir_cron__update_related_model_id	base	ir.model.fields
1991	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	515	f	field_ir_cron__update_field_type	base	ir.model.fields
1992	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	516	f	field_ir_cron__update_m2m_operation	base	ir.model.fields
1993	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	517	f	field_ir_cron__update_boolean_value	base	ir.model.fields
1994	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	518	f	field_ir_cron__value	base	ir.model.fields
1995	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	519	f	field_ir_cron__evaluation_type	base	ir.model.fields
1996	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	520	f	field_ir_cron__resource_ref	base	ir.model.fields
1997	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	521	f	field_ir_cron__selection_value	base	ir.model.fields
1998	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	522	f	field_ir_cron__value_field_to_show	base	ir.model.fields
1999	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	523	f	field_ir_cron__webhook_url	base	ir.model.fields
2000	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	524	f	field_ir_cron__webhook_field_ids	base	ir.model.fields
2001	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	525	f	field_ir_cron__webhook_sample_payload	base	ir.model.fields
2002	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	526	f	field_ir_cron_trigger__cron_id	base	ir.model.fields
2003	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	527	f	field_ir_cron_trigger__call_at	base	ir.model.fields
2004	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	528	f	field_ir_cron_trigger__id	base	ir.model.fields
2005	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	529	f	field_ir_cron_trigger__display_name	base	ir.model.fields
2006	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	530	f	field_ir_cron_trigger__create_uid	base	ir.model.fields
2007	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	531	f	field_ir_cron_trigger__create_date	base	ir.model.fields
2008	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	532	f	field_ir_cron_trigger__write_uid	base	ir.model.fields
2009	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	533	f	field_ir_cron_trigger__write_date	base	ir.model.fields
2010	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	534	f	field_ir_cron_progress__cron_id	base	ir.model.fields
2011	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	535	f	field_ir_cron_progress__remaining	base	ir.model.fields
2012	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	536	f	field_ir_cron_progress__done	base	ir.model.fields
2013	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	537	f	field_ir_cron_progress__deactivate	base	ir.model.fields
2014	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	538	f	field_ir_cron_progress__timed_out_counter	base	ir.model.fields
2015	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	539	f	field_ir_cron_progress__id	base	ir.model.fields
2016	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	540	f	field_ir_cron_progress__display_name	base	ir.model.fields
2017	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	541	f	field_ir_cron_progress__create_uid	base	ir.model.fields
2018	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	542	f	field_ir_cron_progress__create_date	base	ir.model.fields
2019	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	543	f	field_ir_cron_progress__write_uid	base	ir.model.fields
2020	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	544	f	field_ir_cron_progress__write_date	base	ir.model.fields
2021	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	545	f	field_ir_filters__name	base	ir.model.fields
2022	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	546	f	field_ir_filters__user_id	base	ir.model.fields
2023	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	547	f	field_ir_filters__domain	base	ir.model.fields
2024	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	548	f	field_ir_filters__context	base	ir.model.fields
2025	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	549	f	field_ir_filters__sort	base	ir.model.fields
2026	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	550	f	field_ir_filters__model_id	base	ir.model.fields
2027	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	551	f	field_ir_filters__is_default	base	ir.model.fields
2028	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	552	f	field_ir_filters__action_id	base	ir.model.fields
2029	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	553	f	field_ir_filters__embedded_action_id	base	ir.model.fields
2030	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	554	f	field_ir_filters__embedded_parent_res_id	base	ir.model.fields
2031	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	555	f	field_ir_filters__active	base	ir.model.fields
2032	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	556	f	field_ir_filters__id	base	ir.model.fields
2033	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	557	f	field_ir_filters__display_name	base	ir.model.fields
2034	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	558	f	field_ir_filters__create_uid	base	ir.model.fields
2035	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	559	f	field_ir_filters__create_date	base	ir.model.fields
2036	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	560	f	field_ir_filters__write_uid	base	ir.model.fields
2037	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	561	f	field_ir_filters__write_date	base	ir.model.fields
2038	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	562	f	field_ir_default__field_id	base	ir.model.fields
2039	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	563	f	field_ir_default__user_id	base	ir.model.fields
2040	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	564	f	field_ir_default__company_id	base	ir.model.fields
2041	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	565	f	field_ir_default__condition	base	ir.model.fields
2042	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	566	f	field_ir_default__json_value	base	ir.model.fields
2043	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	567	f	field_ir_default__id	base	ir.model.fields
2044	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	568	f	field_ir_default__display_name	base	ir.model.fields
2045	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	569	f	field_ir_default__create_uid	base	ir.model.fields
2046	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	570	f	field_ir_default__create_date	base	ir.model.fields
2047	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	571	f	field_ir_default__write_uid	base	ir.model.fields
2048	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	572	f	field_ir_default__write_date	base	ir.model.fields
2049	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	573	f	field_ir_exports__name	base	ir.model.fields
2050	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	574	f	field_ir_exports__resource	base	ir.model.fields
2051	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	575	f	field_ir_exports__export_fields	base	ir.model.fields
2052	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	576	f	field_ir_exports__id	base	ir.model.fields
2053	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	577	f	field_ir_exports__display_name	base	ir.model.fields
2054	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	578	f	field_ir_exports__create_uid	base	ir.model.fields
2055	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	579	f	field_ir_exports__create_date	base	ir.model.fields
2056	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	580	f	field_ir_exports__write_uid	base	ir.model.fields
2057	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	581	f	field_ir_exports__write_date	base	ir.model.fields
2058	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	582	f	field_ir_exports_line__name	base	ir.model.fields
2059	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	583	f	field_ir_exports_line__export_id	base	ir.model.fields
2060	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	584	f	field_ir_exports_line__id	base	ir.model.fields
2061	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	585	f	field_ir_exports_line__display_name	base	ir.model.fields
2062	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	586	f	field_ir_exports_line__create_uid	base	ir.model.fields
2063	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	587	f	field_ir_exports_line__create_date	base	ir.model.fields
2064	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	588	f	field_ir_exports_line__write_uid	base	ir.model.fields
2065	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	589	f	field_ir_exports_line__write_date	base	ir.model.fields
2066	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	590	f	field_ir_rule__name	base	ir.model.fields
2067	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	591	f	field_ir_rule__active	base	ir.model.fields
2068	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	592	f	field_ir_rule__model_id	base	ir.model.fields
2069	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	593	f	field_ir_rule__groups	base	ir.model.fields
2070	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	594	f	field_ir_rule__domain_force	base	ir.model.fields
2071	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	595	f	field_ir_rule__perm_read	base	ir.model.fields
2072	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	596	f	field_ir_rule__perm_write	base	ir.model.fields
2073	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	597	f	field_ir_rule__perm_create	base	ir.model.fields
2074	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	598	f	field_ir_rule__perm_unlink	base	ir.model.fields
2075	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	599	f	field_ir_rule__id	base	ir.model.fields
2076	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	600	f	field_ir_rule__display_name	base	ir.model.fields
2077	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	601	f	field_ir_rule__create_uid	base	ir.model.fields
2078	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	602	f	field_ir_rule__create_date	base	ir.model.fields
2079	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	603	f	field_ir_rule__write_uid	base	ir.model.fields
2080	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	604	f	field_ir_rule__write_date	base	ir.model.fields
2081	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	605	f	field_ir_rule__global	base	ir.model.fields
2082	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	606	f	field_ir_config_parameter__key	base	ir.model.fields
2083	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	607	f	field_ir_config_parameter__value	base	ir.model.fields
2084	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	608	f	field_ir_config_parameter__id	base	ir.model.fields
2085	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	609	f	field_ir_config_parameter__display_name	base	ir.model.fields
2086	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	610	f	field_ir_config_parameter__create_uid	base	ir.model.fields
2087	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	611	f	field_ir_config_parameter__create_date	base	ir.model.fields
2088	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	612	f	field_ir_config_parameter__write_uid	base	ir.model.fields
2089	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	613	f	field_ir_config_parameter__write_date	base	ir.model.fields
2090	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	614	f	field_ir_mail_server__name	base	ir.model.fields
2091	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	615	f	field_ir_mail_server__from_filter	base	ir.model.fields
2092	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	616	f	field_ir_mail_server__smtp_host	base	ir.model.fields
2093	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	617	f	field_ir_mail_server__smtp_port	base	ir.model.fields
2094	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	618	f	field_ir_mail_server__smtp_authentication	base	ir.model.fields
2095	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	619	f	field_ir_mail_server__smtp_authentication_info	base	ir.model.fields
2096	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	620	f	field_ir_mail_server__smtp_user	base	ir.model.fields
2097	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	621	f	field_ir_mail_server__smtp_pass	base	ir.model.fields
2098	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	622	f	field_ir_mail_server__smtp_encryption	base	ir.model.fields
2099	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	623	f	field_ir_mail_server__smtp_ssl_certificate	base	ir.model.fields
2100	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	624	f	field_ir_mail_server__smtp_ssl_private_key	base	ir.model.fields
2101	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	625	f	field_ir_mail_server__smtp_debug	base	ir.model.fields
2102	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	626	f	field_ir_mail_server__max_email_size	base	ir.model.fields
2103	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	627	f	field_ir_mail_server__sequence	base	ir.model.fields
2104	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	628	f	field_ir_mail_server__active	base	ir.model.fields
2105	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	629	f	field_ir_mail_server__id	base	ir.model.fields
2106	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	630	f	field_ir_mail_server__display_name	base	ir.model.fields
2107	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	631	f	field_ir_mail_server__create_uid	base	ir.model.fields
2108	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	632	f	field_ir_mail_server__create_date	base	ir.model.fields
2109	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	633	f	field_ir_mail_server__write_uid	base	ir.model.fields
2110	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	634	f	field_ir_mail_server__write_date	base	ir.model.fields
2111	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	635	f	field_ir_logging__create_uid	base	ir.model.fields
2112	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	636	f	field_ir_logging__create_date	base	ir.model.fields
2113	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	637	f	field_ir_logging__write_uid	base	ir.model.fields
2114	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	638	f	field_ir_logging__write_date	base	ir.model.fields
2115	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	639	f	field_ir_logging__name	base	ir.model.fields
2116	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	640	f	field_ir_logging__type	base	ir.model.fields
2117	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	641	f	field_ir_logging__dbname	base	ir.model.fields
2118	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	642	f	field_ir_logging__level	base	ir.model.fields
2119	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	643	f	field_ir_logging__message	base	ir.model.fields
2120	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	644	f	field_ir_logging__path	base	ir.model.fields
2121	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	645	f	field_ir_logging__func	base	ir.model.fields
2122	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	646	f	field_ir_logging__line	base	ir.model.fields
2123	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	647	f	field_ir_logging__id	base	ir.model.fields
2124	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	648	f	field_ir_logging__display_name	base	ir.model.fields
2125	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	649	f	field_ir_module_category__name	base	ir.model.fields
2126	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	650	f	field_ir_module_category__parent_id	base	ir.model.fields
2127	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	651	f	field_ir_module_category__child_ids	base	ir.model.fields
2128	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	652	f	field_ir_module_category__module_ids	base	ir.model.fields
2129	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	653	f	field_ir_module_category__description	base	ir.model.fields
2130	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	654	f	field_ir_module_category__sequence	base	ir.model.fields
2131	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	655	f	field_ir_module_category__visible	base	ir.model.fields
2132	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	656	f	field_ir_module_category__exclusive	base	ir.model.fields
2133	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	657	f	field_ir_module_category__xml_id	base	ir.model.fields
2134	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	658	f	field_ir_module_category__id	base	ir.model.fields
2135	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	659	f	field_ir_module_category__display_name	base	ir.model.fields
2136	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	660	f	field_ir_module_category__create_uid	base	ir.model.fields
2137	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	661	f	field_ir_module_category__create_date	base	ir.model.fields
2138	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	662	f	field_ir_module_category__write_uid	base	ir.model.fields
2139	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	663	f	field_ir_module_category__write_date	base	ir.model.fields
2140	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	664	f	field_ir_module_module__name	base	ir.model.fields
2141	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	665	f	field_ir_module_module__category_id	base	ir.model.fields
2142	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	666	f	field_ir_module_module__shortdesc	base	ir.model.fields
2143	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	667	f	field_ir_module_module__summary	base	ir.model.fields
2144	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	668	f	field_ir_module_module__description	base	ir.model.fields
2145	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	669	f	field_ir_module_module__description_html	base	ir.model.fields
2146	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	670	f	field_ir_module_module__author	base	ir.model.fields
2147	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	671	f	field_ir_module_module__maintainer	base	ir.model.fields
2148	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	672	f	field_ir_module_module__contributors	base	ir.model.fields
2149	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	673	f	field_ir_module_module__website	base	ir.model.fields
2150	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	674	f	field_ir_module_module__installed_version	base	ir.model.fields
2151	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	675	f	field_ir_module_module__latest_version	base	ir.model.fields
2152	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	676	f	field_ir_module_module__published_version	base	ir.model.fields
2153	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	677	f	field_ir_module_module__url	base	ir.model.fields
2154	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	678	f	field_ir_module_module__sequence	base	ir.model.fields
2155	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	679	f	field_ir_module_module__dependencies_id	base	ir.model.fields
2156	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	680	f	field_ir_module_module__country_ids	base	ir.model.fields
2157	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	681	f	field_ir_module_module__exclusion_ids	base	ir.model.fields
2158	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	682	f	field_ir_module_module__auto_install	base	ir.model.fields
2159	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	683	f	field_ir_module_module__state	base	ir.model.fields
2160	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	684	f	field_ir_module_module__demo	base	ir.model.fields
2161	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	685	f	field_ir_module_module__license	base	ir.model.fields
2162	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	686	f	field_ir_module_module__menus_by_module	base	ir.model.fields
2163	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	687	f	field_ir_module_module__reports_by_module	base	ir.model.fields
2164	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	688	f	field_ir_module_module__views_by_module	base	ir.model.fields
2165	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	689	f	field_ir_module_module__application	base	ir.model.fields
2166	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	690	f	field_ir_module_module__icon	base	ir.model.fields
2167	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	691	f	field_ir_module_module__icon_image	base	ir.model.fields
2168	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	692	f	field_ir_module_module__icon_flag	base	ir.model.fields
2169	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	693	f	field_ir_module_module__to_buy	base	ir.model.fields
2170	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	694	f	field_ir_module_module__has_iap	base	ir.model.fields
2171	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	695	f	field_ir_module_module__id	base	ir.model.fields
2172	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	696	f	field_ir_module_module__display_name	base	ir.model.fields
2173	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	697	f	field_ir_module_module__create_uid	base	ir.model.fields
2174	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	698	f	field_ir_module_module__create_date	base	ir.model.fields
2175	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	699	f	field_ir_module_module__write_uid	base	ir.model.fields
2176	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	700	f	field_ir_module_module__write_date	base	ir.model.fields
2177	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	701	f	field_ir_module_module_dependency__name	base	ir.model.fields
2178	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	702	f	field_ir_module_module_dependency__module_id	base	ir.model.fields
2179	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	703	f	field_ir_module_module_dependency__depend_id	base	ir.model.fields
2180	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	704	f	field_ir_module_module_dependency__state	base	ir.model.fields
2181	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	705	f	field_ir_module_module_dependency__auto_install_required	base	ir.model.fields
2182	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	706	f	field_ir_module_module_dependency__id	base	ir.model.fields
2183	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	707	f	field_ir_module_module_dependency__display_name	base	ir.model.fields
2184	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	708	f	field_ir_module_module_exclusion__name	base	ir.model.fields
2185	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	709	f	field_ir_module_module_exclusion__module_id	base	ir.model.fields
2186	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	710	f	field_ir_module_module_exclusion__exclusion_id	base	ir.model.fields
2187	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	711	f	field_ir_module_module_exclusion__state	base	ir.model.fields
2188	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	712	f	field_ir_module_module_exclusion__id	base	ir.model.fields
2189	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	713	f	field_ir_module_module_exclusion__display_name	base	ir.model.fields
2190	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	714	f	field_ir_module_module_exclusion__create_uid	base	ir.model.fields
2191	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	715	f	field_ir_module_module_exclusion__create_date	base	ir.model.fields
2192	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	716	f	field_ir_module_module_exclusion__write_uid	base	ir.model.fields
2193	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	717	f	field_ir_module_module_exclusion__write_date	base	ir.model.fields
2194	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	718	f	field_ir_demo__id	base	ir.model.fields
2195	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	719	f	field_ir_demo__display_name	base	ir.model.fields
2196	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	720	f	field_ir_demo__create_uid	base	ir.model.fields
2197	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	721	f	field_ir_demo__create_date	base	ir.model.fields
2198	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	722	f	field_ir_demo__write_uid	base	ir.model.fields
2199	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	723	f	field_ir_demo__write_date	base	ir.model.fields
2200	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	724	f	field_ir_demo_failure__module_id	base	ir.model.fields
2201	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	725	f	field_ir_demo_failure__error	base	ir.model.fields
2202	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	726	f	field_ir_demo_failure__wizard_id	base	ir.model.fields
2203	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	727	f	field_ir_demo_failure__id	base	ir.model.fields
2204	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	728	f	field_ir_demo_failure__display_name	base	ir.model.fields
2205	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	729	f	field_ir_demo_failure__create_uid	base	ir.model.fields
2206	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	730	f	field_ir_demo_failure__create_date	base	ir.model.fields
2207	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	731	f	field_ir_demo_failure__write_uid	base	ir.model.fields
2208	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	732	f	field_ir_demo_failure__write_date	base	ir.model.fields
2209	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	733	f	field_ir_demo_failure_wizard__failure_ids	base	ir.model.fields
2210	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	734	f	field_ir_demo_failure_wizard__failures_count	base	ir.model.fields
2211	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	735	f	field_ir_demo_failure_wizard__id	base	ir.model.fields
2212	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	736	f	field_ir_demo_failure_wizard__display_name	base	ir.model.fields
2213	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	737	f	field_ir_demo_failure_wizard__create_uid	base	ir.model.fields
2214	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	738	f	field_ir_demo_failure_wizard__create_date	base	ir.model.fields
2215	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	739	f	field_ir_demo_failure_wizard__write_uid	base	ir.model.fields
2216	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	740	f	field_ir_demo_failure_wizard__write_date	base	ir.model.fields
2217	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	741	f	field_report_layout__view_id	base	ir.model.fields
2218	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	742	f	field_report_layout__image	base	ir.model.fields
2219	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	743	f	field_report_layout__pdf	base	ir.model.fields
2220	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	744	f	field_report_layout__sequence	base	ir.model.fields
2221	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	745	f	field_report_layout__name	base	ir.model.fields
2222	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	746	f	field_report_layout__id	base	ir.model.fields
2223	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	747	f	field_report_layout__display_name	base	ir.model.fields
2224	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	748	f	field_report_layout__create_uid	base	ir.model.fields
2225	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	749	f	field_report_layout__create_date	base	ir.model.fields
2226	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	750	f	field_report_layout__write_uid	base	ir.model.fields
2227	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	751	f	field_report_layout__write_date	base	ir.model.fields
2228	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	752	f	field_report_paperformat__name	base	ir.model.fields
2229	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	753	f	field_report_paperformat__default	base	ir.model.fields
2230	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	754	f	field_report_paperformat__format	base	ir.model.fields
2231	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	755	f	field_report_paperformat__margin_top	base	ir.model.fields
2232	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	756	f	field_report_paperformat__margin_bottom	base	ir.model.fields
2233	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	757	f	field_report_paperformat__margin_left	base	ir.model.fields
2234	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	758	f	field_report_paperformat__margin_right	base	ir.model.fields
2235	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	759	f	field_report_paperformat__page_height	base	ir.model.fields
2236	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	760	f	field_report_paperformat__page_width	base	ir.model.fields
2237	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	761	f	field_report_paperformat__orientation	base	ir.model.fields
2238	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	762	f	field_report_paperformat__header_line	base	ir.model.fields
2239	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	763	f	field_report_paperformat__header_spacing	base	ir.model.fields
2240	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	764	f	field_report_paperformat__disable_shrinking	base	ir.model.fields
2241	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	765	f	field_report_paperformat__dpi	base	ir.model.fields
2242	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	766	f	field_report_paperformat__report_ids	base	ir.model.fields
2243	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	767	f	field_report_paperformat__print_page_width	base	ir.model.fields
3902	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	81	f	lang_es_UY	base	res.lang
2244	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	768	f	field_report_paperformat__print_page_height	base	ir.model.fields
2245	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	769	f	field_report_paperformat__css_margins	base	ir.model.fields
2246	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	770	f	field_report_paperformat__id	base	ir.model.fields
2247	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	771	f	field_report_paperformat__display_name	base	ir.model.fields
2248	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	772	f	field_report_paperformat__create_uid	base	ir.model.fields
2249	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	773	f	field_report_paperformat__create_date	base	ir.model.fields
2250	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	774	f	field_report_paperformat__write_uid	base	ir.model.fields
2251	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	775	f	field_report_paperformat__write_date	base	ir.model.fields
2252	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	776	f	field_ir_profile__create_date	base	ir.model.fields
2253	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	777	f	field_ir_profile__session	base	ir.model.fields
2254	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	778	f	field_ir_profile__name	base	ir.model.fields
2255	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	779	f	field_ir_profile__duration	base	ir.model.fields
2256	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	780	f	field_ir_profile__init_stack_trace	base	ir.model.fields
2257	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	781	f	field_ir_profile__sql	base	ir.model.fields
2258	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	782	f	field_ir_profile__sql_count	base	ir.model.fields
2259	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	783	f	field_ir_profile__traces_async	base	ir.model.fields
2260	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	784	f	field_ir_profile__traces_sync	base	ir.model.fields
2261	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	785	f	field_ir_profile__qweb	base	ir.model.fields
2262	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	786	f	field_ir_profile__entry_count	base	ir.model.fields
2263	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	787	f	field_ir_profile__speedscope	base	ir.model.fields
2264	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	788	f	field_ir_profile__speedscope_url	base	ir.model.fields
2265	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	789	f	field_ir_profile__id	base	ir.model.fields
2266	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	790	f	field_ir_profile__display_name	base	ir.model.fields
2267	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	791	f	field_base_enable_profiling_wizard__duration	base	ir.model.fields
2268	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	792	f	field_base_enable_profiling_wizard__expiration	base	ir.model.fields
2269	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	793	f	field_base_enable_profiling_wizard__id	base	ir.model.fields
2270	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	794	f	field_base_enable_profiling_wizard__display_name	base	ir.model.fields
2271	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	795	f	field_base_enable_profiling_wizard__create_uid	base	ir.model.fields
2272	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	796	f	field_base_enable_profiling_wizard__create_date	base	ir.model.fields
2273	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	797	f	field_base_enable_profiling_wizard__write_uid	base	ir.model.fields
2274	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	798	f	field_base_enable_profiling_wizard__write_date	base	ir.model.fields
2275	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	799	f	field_image_mixin__image_1920	base	ir.model.fields
2276	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	800	f	field_image_mixin__image_1024	base	ir.model.fields
2277	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	801	f	field_image_mixin__image_512	base	ir.model.fields
2278	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	802	f	field_image_mixin__image_256	base	ir.model.fields
2279	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	803	f	field_image_mixin__image_128	base	ir.model.fields
2280	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	804	f	field_avatar_mixin__image_1920	base	ir.model.fields
2281	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	805	f	field_avatar_mixin__image_1024	base	ir.model.fields
2282	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	806	f	field_avatar_mixin__image_512	base	ir.model.fields
2283	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	807	f	field_avatar_mixin__image_256	base	ir.model.fields
2284	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	808	f	field_avatar_mixin__image_128	base	ir.model.fields
2285	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	809	f	field_avatar_mixin__avatar_1920	base	ir.model.fields
2286	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	810	f	field_avatar_mixin__avatar_1024	base	ir.model.fields
2287	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	811	f	field_avatar_mixin__avatar_512	base	ir.model.fields
2288	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	812	f	field_avatar_mixin__avatar_256	base	ir.model.fields
2289	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	813	f	field_avatar_mixin__avatar_128	base	ir.model.fields
2290	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	814	f	field_res_country__name	base	ir.model.fields
2291	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	815	f	field_res_country__code	base	ir.model.fields
2292	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	816	f	field_res_country__address_format	base	ir.model.fields
2293	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	817	f	field_res_country__address_view_id	base	ir.model.fields
2294	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	818	f	field_res_country__currency_id	base	ir.model.fields
2295	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	819	f	field_res_country__image_url	base	ir.model.fields
2296	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	820	f	field_res_country__phone_code	base	ir.model.fields
2297	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	821	f	field_res_country__country_group_ids	base	ir.model.fields
2298	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	822	f	field_res_country__state_ids	base	ir.model.fields
2299	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	823	f	field_res_country__name_position	base	ir.model.fields
2300	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	824	f	field_res_country__vat_label	base	ir.model.fields
2301	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	825	f	field_res_country__state_required	base	ir.model.fields
2302	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	826	f	field_res_country__zip_required	base	ir.model.fields
2303	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	827	f	field_res_country__id	base	ir.model.fields
2304	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	828	f	field_res_country__display_name	base	ir.model.fields
2305	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	829	f	field_res_country__create_uid	base	ir.model.fields
2306	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	830	f	field_res_country__create_date	base	ir.model.fields
2307	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	831	f	field_res_country__write_uid	base	ir.model.fields
2308	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	832	f	field_res_country__write_date	base	ir.model.fields
2309	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	833	f	field_res_country_group__name	base	ir.model.fields
2310	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	834	f	field_res_country_group__country_ids	base	ir.model.fields
2311	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	835	f	field_res_country_group__id	base	ir.model.fields
2312	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	836	f	field_res_country_group__display_name	base	ir.model.fields
2313	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	837	f	field_res_country_group__create_uid	base	ir.model.fields
2314	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	838	f	field_res_country_group__create_date	base	ir.model.fields
2315	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	839	f	field_res_country_group__write_uid	base	ir.model.fields
2316	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	840	f	field_res_country_group__write_date	base	ir.model.fields
2317	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	841	f	field_res_country_state__country_id	base	ir.model.fields
2318	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	842	f	field_res_country_state__name	base	ir.model.fields
2319	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	843	f	field_res_country_state__code	base	ir.model.fields
2320	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	844	f	field_res_country_state__id	base	ir.model.fields
2321	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	845	f	field_res_country_state__display_name	base	ir.model.fields
2322	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	846	f	field_res_country_state__create_uid	base	ir.model.fields
2323	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	847	f	field_res_country_state__create_date	base	ir.model.fields
2324	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	848	f	field_res_country_state__write_uid	base	ir.model.fields
2325	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	849	f	field_res_country_state__write_date	base	ir.model.fields
2326	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	850	f	field_res_lang__name	base	ir.model.fields
2327	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	851	f	field_res_lang__code	base	ir.model.fields
2328	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	852	f	field_res_lang__iso_code	base	ir.model.fields
2329	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	853	f	field_res_lang__url_code	base	ir.model.fields
2330	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	854	f	field_res_lang__active	base	ir.model.fields
2331	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	855	f	field_res_lang__direction	base	ir.model.fields
2332	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	856	f	field_res_lang__date_format	base	ir.model.fields
2333	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	857	f	field_res_lang__time_format	base	ir.model.fields
2334	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	858	f	field_res_lang__short_time_format	base	ir.model.fields
2335	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	859	f	field_res_lang__week_start	base	ir.model.fields
2336	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	860	f	field_res_lang__grouping	base	ir.model.fields
2337	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	861	f	field_res_lang__decimal_point	base	ir.model.fields
2338	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	862	f	field_res_lang__thousands_sep	base	ir.model.fields
2339	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	863	f	field_res_lang__flag_image	base	ir.model.fields
2340	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	864	f	field_res_lang__flag_image_url	base	ir.model.fields
2341	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	865	f	field_res_lang__id	base	ir.model.fields
2342	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	866	f	field_res_lang__display_name	base	ir.model.fields
2343	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	867	f	field_res_lang__create_uid	base	ir.model.fields
2344	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	868	f	field_res_lang__create_date	base	ir.model.fields
2345	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	869	f	field_res_lang__write_uid	base	ir.model.fields
2346	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	870	f	field_res_lang__write_date	base	ir.model.fields
2347	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	871	f	field_res_partner_category__name	base	ir.model.fields
2348	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	872	f	field_res_partner_category__color	base	ir.model.fields
2349	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	873	f	field_res_partner_category__parent_id	base	ir.model.fields
2350	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	874	f	field_res_partner_category__child_ids	base	ir.model.fields
2351	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	875	f	field_res_partner_category__active	base	ir.model.fields
2352	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	876	f	field_res_partner_category__parent_path	base	ir.model.fields
2353	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	877	f	field_res_partner_category__partner_ids	base	ir.model.fields
2354	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	878	f	field_res_partner_category__id	base	ir.model.fields
2355	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	879	f	field_res_partner_category__display_name	base	ir.model.fields
2356	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	880	f	field_res_partner_category__create_uid	base	ir.model.fields
2357	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	881	f	field_res_partner_category__create_date	base	ir.model.fields
2358	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	882	f	field_res_partner_category__write_uid	base	ir.model.fields
2359	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	883	f	field_res_partner_category__write_date	base	ir.model.fields
2360	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	884	f	field_res_partner_title__name	base	ir.model.fields
2361	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	885	f	field_res_partner_title__shortcut	base	ir.model.fields
2362	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	886	f	field_res_partner_title__id	base	ir.model.fields
2363	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	887	f	field_res_partner_title__display_name	base	ir.model.fields
2364	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	888	f	field_res_partner_title__create_uid	base	ir.model.fields
2365	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	889	f	field_res_partner_title__create_date	base	ir.model.fields
2366	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	890	f	field_res_partner_title__write_uid	base	ir.model.fields
2367	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	891	f	field_res_partner_title__write_date	base	ir.model.fields
2368	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	892	f	field_res_partner__image_1920	base	ir.model.fields
2369	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	893	f	field_res_partner__image_1024	base	ir.model.fields
2370	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	894	f	field_res_partner__image_512	base	ir.model.fields
2371	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	895	f	field_res_partner__image_256	base	ir.model.fields
2372	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	896	f	field_res_partner__image_128	base	ir.model.fields
2373	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	897	f	field_res_partner__avatar_1920	base	ir.model.fields
2374	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	898	f	field_res_partner__avatar_1024	base	ir.model.fields
2375	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	899	f	field_res_partner__avatar_512	base	ir.model.fields
2376	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	900	f	field_res_partner__avatar_256	base	ir.model.fields
2377	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	901	f	field_res_partner__avatar_128	base	ir.model.fields
3903	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	82	f	lang_es_VE	base	res.lang
2378	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	902	f	field_res_partner__name	base	ir.model.fields
2379	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	903	f	field_res_partner__complete_name	base	ir.model.fields
2380	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	904	f	field_res_partner__title	base	ir.model.fields
2381	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	905	f	field_res_partner__parent_id	base	ir.model.fields
2382	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	906	f	field_res_partner__parent_name	base	ir.model.fields
2383	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	907	f	field_res_partner__child_ids	base	ir.model.fields
2384	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	908	f	field_res_partner__ref	base	ir.model.fields
2385	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	909	f	field_res_partner__lang	base	ir.model.fields
2386	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	910	f	field_res_partner__active_lang_count	base	ir.model.fields
2387	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	911	f	field_res_partner__tz	base	ir.model.fields
2388	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	912	f	field_res_partner__tz_offset	base	ir.model.fields
2389	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	913	f	field_res_partner__user_id	base	ir.model.fields
2390	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	914	f	field_res_partner__vat	base	ir.model.fields
2391	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	915	f	field_res_partner__vat_label	base	ir.model.fields
2392	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	916	f	field_res_partner__same_vat_partner_id	base	ir.model.fields
2393	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	917	f	field_res_partner__same_company_registry_partner_id	base	ir.model.fields
2394	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	918	f	field_res_partner__company_registry	base	ir.model.fields
2395	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	919	f	field_res_partner__company_registry_label	base	ir.model.fields
2396	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	920	f	field_res_partner__bank_ids	base	ir.model.fields
2397	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	921	f	field_res_partner__website	base	ir.model.fields
2398	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	922	f	field_res_partner__comment	base	ir.model.fields
2399	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	923	f	field_res_partner__category_id	base	ir.model.fields
2400	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	924	f	field_res_partner__active	base	ir.model.fields
2401	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	925	f	field_res_partner__employee	base	ir.model.fields
2402	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	926	f	field_res_partner__function	base	ir.model.fields
2403	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	927	f	field_res_partner__type	base	ir.model.fields
2404	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	928	f	field_res_partner__street	base	ir.model.fields
2405	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	929	f	field_res_partner__street2	base	ir.model.fields
2406	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	930	f	field_res_partner__zip	base	ir.model.fields
2407	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	931	f	field_res_partner__city	base	ir.model.fields
2408	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	932	f	field_res_partner__state_id	base	ir.model.fields
2409	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	933	f	field_res_partner__country_id	base	ir.model.fields
2410	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	934	f	field_res_partner__country_code	base	ir.model.fields
2411	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	935	f	field_res_partner__partner_latitude	base	ir.model.fields
2412	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	936	f	field_res_partner__partner_longitude	base	ir.model.fields
2413	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	937	f	field_res_partner__email	base	ir.model.fields
2414	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	938	f	field_res_partner__email_formatted	base	ir.model.fields
2415	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	939	f	field_res_partner__phone	base	ir.model.fields
2416	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	940	f	field_res_partner__mobile	base	ir.model.fields
2417	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	941	f	field_res_partner__is_company	base	ir.model.fields
2418	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	942	f	field_res_partner__is_public	base	ir.model.fields
2419	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	943	f	field_res_partner__industry_id	base	ir.model.fields
2420	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	944	f	field_res_partner__company_type	base	ir.model.fields
2421	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	945	f	field_res_partner__company_id	base	ir.model.fields
2422	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	946	f	field_res_partner__color	base	ir.model.fields
2423	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	947	f	field_res_partner__user_ids	base	ir.model.fields
2424	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	948	f	field_res_partner__partner_share	base	ir.model.fields
2425	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	949	f	field_res_partner__contact_address	base	ir.model.fields
2426	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	950	f	field_res_partner__commercial_partner_id	base	ir.model.fields
2427	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	951	f	field_res_partner__commercial_company_name	base	ir.model.fields
2428	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	952	f	field_res_partner__company_name	base	ir.model.fields
2429	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	953	f	field_res_partner__barcode	base	ir.model.fields
2430	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	954	f	field_res_partner__self	base	ir.model.fields
2431	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	955	f	field_res_partner__id	base	ir.model.fields
2432	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	956	f	field_res_partner__display_name	base	ir.model.fields
2433	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	957	f	field_res_partner__create_uid	base	ir.model.fields
2434	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	958	f	field_res_partner__create_date	base	ir.model.fields
2435	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	959	f	field_res_partner__write_uid	base	ir.model.fields
2436	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	960	f	field_res_partner__write_date	base	ir.model.fields
2437	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	961	f	field_res_partner_industry__name	base	ir.model.fields
2438	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	962	f	field_res_partner_industry__full_name	base	ir.model.fields
2439	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	963	f	field_res_partner_industry__active	base	ir.model.fields
2440	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	964	f	field_res_partner_industry__id	base	ir.model.fields
2441	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	965	f	field_res_partner_industry__display_name	base	ir.model.fields
2442	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	966	f	field_res_partner_industry__create_uid	base	ir.model.fields
2443	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	967	f	field_res_partner_industry__create_date	base	ir.model.fields
2444	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	968	f	field_res_partner_industry__write_uid	base	ir.model.fields
3904	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	83	f	lang_es	base	res.lang
2445	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	969	f	field_res_partner_industry__write_date	base	ir.model.fields
2446	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	970	f	field_res_bank__name	base	ir.model.fields
2447	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	971	f	field_res_bank__street	base	ir.model.fields
2448	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	972	f	field_res_bank__street2	base	ir.model.fields
2449	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	973	f	field_res_bank__zip	base	ir.model.fields
2450	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	974	f	field_res_bank__city	base	ir.model.fields
2451	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	975	f	field_res_bank__state	base	ir.model.fields
2452	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	976	f	field_res_bank__country	base	ir.model.fields
2453	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	977	f	field_res_bank__country_code	base	ir.model.fields
2454	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	978	f	field_res_bank__email	base	ir.model.fields
2455	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	979	f	field_res_bank__phone	base	ir.model.fields
2456	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	980	f	field_res_bank__active	base	ir.model.fields
2457	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	981	f	field_res_bank__bic	base	ir.model.fields
2458	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	982	f	field_res_bank__id	base	ir.model.fields
2459	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	983	f	field_res_bank__display_name	base	ir.model.fields
2460	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	984	f	field_res_bank__create_uid	base	ir.model.fields
2461	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	985	f	field_res_bank__create_date	base	ir.model.fields
2462	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	986	f	field_res_bank__write_uid	base	ir.model.fields
2463	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	987	f	field_res_bank__write_date	base	ir.model.fields
2464	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	988	f	field_res_partner_bank__active	base	ir.model.fields
2465	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	989	f	field_res_partner_bank__acc_type	base	ir.model.fields
2466	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	990	f	field_res_partner_bank__acc_number	base	ir.model.fields
2467	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	991	f	field_res_partner_bank__sanitized_acc_number	base	ir.model.fields
2468	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	992	f	field_res_partner_bank__acc_holder_name	base	ir.model.fields
2469	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	993	f	field_res_partner_bank__partner_id	base	ir.model.fields
2470	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	994	f	field_res_partner_bank__allow_out_payment	base	ir.model.fields
2471	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	995	f	field_res_partner_bank__bank_id	base	ir.model.fields
2472	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	996	f	field_res_partner_bank__bank_name	base	ir.model.fields
2473	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	997	f	field_res_partner_bank__bank_bic	base	ir.model.fields
2474	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	998	f	field_res_partner_bank__sequence	base	ir.model.fields
2475	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	999	f	field_res_partner_bank__currency_id	base	ir.model.fields
2476	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1000	f	field_res_partner_bank__company_id	base	ir.model.fields
2477	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1001	f	field_res_partner_bank__country_code	base	ir.model.fields
2478	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1002	f	field_res_partner_bank__id	base	ir.model.fields
2479	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1003	f	field_res_partner_bank__display_name	base	ir.model.fields
2480	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1004	f	field_res_partner_bank__create_uid	base	ir.model.fields
2481	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1005	f	field_res_partner_bank__create_date	base	ir.model.fields
2482	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1006	f	field_res_partner_bank__write_uid	base	ir.model.fields
2483	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1007	f	field_res_partner_bank__write_date	base	ir.model.fields
2484	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1008	f	field_res_config__id	base	ir.model.fields
2485	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1009	f	field_res_config__display_name	base	ir.model.fields
2486	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1010	f	field_res_config__create_uid	base	ir.model.fields
2487	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1011	f	field_res_config__create_date	base	ir.model.fields
2488	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1012	f	field_res_config__write_uid	base	ir.model.fields
2489	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1013	f	field_res_config__write_date	base	ir.model.fields
2490	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1014	f	field_res_config_settings__id	base	ir.model.fields
2491	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1015	f	field_res_config_settings__display_name	base	ir.model.fields
2492	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1016	f	field_res_config_settings__create_uid	base	ir.model.fields
2493	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1017	f	field_res_config_settings__create_date	base	ir.model.fields
2494	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1018	f	field_res_config_settings__write_uid	base	ir.model.fields
2495	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1019	f	field_res_config_settings__write_date	base	ir.model.fields
2496	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1020	f	field_res_currency__name	base	ir.model.fields
2497	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1021	f	field_res_currency__iso_numeric	base	ir.model.fields
2498	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1022	f	field_res_currency__full_name	base	ir.model.fields
2499	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1023	f	field_res_currency__symbol	base	ir.model.fields
2500	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1024	f	field_res_currency__rate	base	ir.model.fields
2501	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1025	f	field_res_currency__inverse_rate	base	ir.model.fields
2502	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1026	f	field_res_currency__rate_string	base	ir.model.fields
2503	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1027	f	field_res_currency__rate_ids	base	ir.model.fields
2504	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1028	f	field_res_currency__rounding	base	ir.model.fields
2505	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1029	f	field_res_currency__decimal_places	base	ir.model.fields
2506	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1030	f	field_res_currency__active	base	ir.model.fields
2507	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1031	f	field_res_currency__position	base	ir.model.fields
2508	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1032	f	field_res_currency__date	base	ir.model.fields
2509	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1033	f	field_res_currency__currency_unit_label	base	ir.model.fields
2510	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1034	f	field_res_currency__currency_subunit_label	base	ir.model.fields
2511	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1035	f	field_res_currency__is_current_company_currency	base	ir.model.fields
2512	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1036	f	field_res_currency__id	base	ir.model.fields
2513	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1037	f	field_res_currency__display_name	base	ir.model.fields
2514	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1038	f	field_res_currency__create_uid	base	ir.model.fields
2515	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1039	f	field_res_currency__create_date	base	ir.model.fields
2516	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1040	f	field_res_currency__write_uid	base	ir.model.fields
2517	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1041	f	field_res_currency__write_date	base	ir.model.fields
2518	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1042	f	field_res_currency_rate__name	base	ir.model.fields
2519	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1043	f	field_res_currency_rate__rate	base	ir.model.fields
2520	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1044	f	field_res_currency_rate__company_rate	base	ir.model.fields
2521	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1045	f	field_res_currency_rate__inverse_company_rate	base	ir.model.fields
2522	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1046	f	field_res_currency_rate__currency_id	base	ir.model.fields
2523	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1047	f	field_res_currency_rate__company_id	base	ir.model.fields
2524	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1048	f	field_res_currency_rate__id	base	ir.model.fields
2525	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1049	f	field_res_currency_rate__display_name	base	ir.model.fields
2526	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1050	f	field_res_currency_rate__create_uid	base	ir.model.fields
2527	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1051	f	field_res_currency_rate__create_date	base	ir.model.fields
2528	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1052	f	field_res_currency_rate__write_uid	base	ir.model.fields
2529	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1053	f	field_res_currency_rate__write_date	base	ir.model.fields
2530	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1054	f	field_res_company__name	base	ir.model.fields
2531	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1055	f	field_res_company__active	base	ir.model.fields
2532	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1056	f	field_res_company__sequence	base	ir.model.fields
2533	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1057	f	field_res_company__parent_id	base	ir.model.fields
2534	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1058	f	field_res_company__child_ids	base	ir.model.fields
2535	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1059	f	field_res_company__all_child_ids	base	ir.model.fields
2536	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1060	f	field_res_company__parent_path	base	ir.model.fields
2537	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1061	f	field_res_company__parent_ids	base	ir.model.fields
2538	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1062	f	field_res_company__root_id	base	ir.model.fields
2539	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1063	f	field_res_company__partner_id	base	ir.model.fields
2540	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1064	f	field_res_company__report_header	base	ir.model.fields
2541	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1065	f	field_res_company__report_footer	base	ir.model.fields
2542	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1066	f	field_res_company__company_details	base	ir.model.fields
2543	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1067	f	field_res_company__is_company_details_empty	base	ir.model.fields
2544	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1068	f	field_res_company__logo	base	ir.model.fields
2545	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1069	f	field_res_company__logo_web	base	ir.model.fields
2546	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1070	f	field_res_company__uses_default_logo	base	ir.model.fields
2547	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1071	f	field_res_company__currency_id	base	ir.model.fields
2548	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1072	f	field_res_company__user_ids	base	ir.model.fields
2549	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1073	f	field_res_company__street	base	ir.model.fields
2550	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1074	f	field_res_company__street2	base	ir.model.fields
2551	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1075	f	field_res_company__zip	base	ir.model.fields
2552	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1076	f	field_res_company__city	base	ir.model.fields
2553	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1077	f	field_res_company__state_id	base	ir.model.fields
2554	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1078	f	field_res_company__bank_ids	base	ir.model.fields
2555	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1079	f	field_res_company__country_id	base	ir.model.fields
2556	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1080	f	field_res_company__country_code	base	ir.model.fields
2557	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1081	f	field_res_company__email	base	ir.model.fields
2558	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1082	f	field_res_company__phone	base	ir.model.fields
2559	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1083	f	field_res_company__mobile	base	ir.model.fields
2560	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1084	f	field_res_company__website	base	ir.model.fields
2561	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1085	f	field_res_company__vat	base	ir.model.fields
2562	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1086	f	field_res_company__company_registry	base	ir.model.fields
2563	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1087	f	field_res_company__paperformat_id	base	ir.model.fields
2564	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1088	f	field_res_company__external_report_layout_id	base	ir.model.fields
2565	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1089	f	field_res_company__font	base	ir.model.fields
2566	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1090	f	field_res_company__primary_color	base	ir.model.fields
2567	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1091	f	field_res_company__secondary_color	base	ir.model.fields
2568	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1092	f	field_res_company__color	base	ir.model.fields
2569	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1093	f	field_res_company__layout_background	base	ir.model.fields
2570	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1094	f	field_res_company__layout_background_image	base	ir.model.fields
2571	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1095	f	field_res_company__uninstalled_l10n_module_ids	base	ir.model.fields
2572	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1096	f	field_res_company__id	base	ir.model.fields
2573	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1097	f	field_res_company__display_name	base	ir.model.fields
2574	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1098	f	field_res_company__create_uid	base	ir.model.fields
2575	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1099	f	field_res_company__create_date	base	ir.model.fields
2576	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1100	f	field_res_company__write_uid	base	ir.model.fields
2577	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1101	f	field_res_company__write_date	base	ir.model.fields
2578	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1102	f	field_res_groups__name	base	ir.model.fields
2579	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1103	f	field_res_groups__users	base	ir.model.fields
3905	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	84	f	lang_sw	base	res.lang
2580	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1104	f	field_res_groups__model_access	base	ir.model.fields
2581	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1105	f	field_res_groups__rule_groups	base	ir.model.fields
2582	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1106	f	field_res_groups__menu_access	base	ir.model.fields
2583	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1107	f	field_res_groups__view_access	base	ir.model.fields
2584	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1108	f	field_res_groups__comment	base	ir.model.fields
2585	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1109	f	field_res_groups__category_id	base	ir.model.fields
2586	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1110	f	field_res_groups__color	base	ir.model.fields
2587	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1111	f	field_res_groups__full_name	base	ir.model.fields
2588	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1112	f	field_res_groups__share	base	ir.model.fields
2589	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1113	f	field_res_groups__api_key_duration	base	ir.model.fields
2590	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1114	f	field_res_groups__id	base	ir.model.fields
2591	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1115	f	field_res_groups__display_name	base	ir.model.fields
2592	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1116	f	field_res_groups__create_uid	base	ir.model.fields
2593	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1117	f	field_res_groups__create_date	base	ir.model.fields
2594	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1118	f	field_res_groups__write_uid	base	ir.model.fields
2595	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1119	f	field_res_groups__write_date	base	ir.model.fields
2596	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1120	f	field_res_groups__implied_ids	base	ir.model.fields
2597	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1121	f	field_res_groups__trans_implied_ids	base	ir.model.fields
2598	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1122	f	field_res_users_log__id	base	ir.model.fields
2599	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1123	f	field_res_users_log__display_name	base	ir.model.fields
2600	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1124	f	field_res_users_log__create_uid	base	ir.model.fields
2601	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1125	f	field_res_users_log__create_date	base	ir.model.fields
2602	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1126	f	field_res_users_log__write_uid	base	ir.model.fields
2603	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1127	f	field_res_users_log__write_date	base	ir.model.fields
2604	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1128	f	field_res_users__partner_id	base	ir.model.fields
2605	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1129	f	field_res_users__login	base	ir.model.fields
2606	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1130	f	field_res_users__password	base	ir.model.fields
2607	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1131	f	field_res_users__new_password	base	ir.model.fields
2608	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1132	f	field_res_users__signature	base	ir.model.fields
2609	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1133	f	field_res_users__active	base	ir.model.fields
2610	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1134	f	field_res_users__active_partner	base	ir.model.fields
2611	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1135	f	field_res_users__action_id	base	ir.model.fields
2612	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1136	f	field_res_users__groups_id	base	ir.model.fields
2613	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1137	f	field_res_users__log_ids	base	ir.model.fields
2614	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1138	f	field_res_users__device_ids	base	ir.model.fields
2615	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1139	f	field_res_users__login_date	base	ir.model.fields
2616	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1140	f	field_res_users__share	base	ir.model.fields
2617	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1141	f	field_res_users__companies_count	base	ir.model.fields
2618	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1142	f	field_res_users__tz_offset	base	ir.model.fields
2619	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1143	f	field_res_users__res_users_settings_ids	base	ir.model.fields
2620	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1144	f	field_res_users__res_users_settings_id	base	ir.model.fields
2621	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1145	f	field_res_users__company_id	base	ir.model.fields
2622	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1146	f	field_res_users__company_ids	base	ir.model.fields
2623	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1147	f	field_res_users__name	base	ir.model.fields
2624	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1148	f	field_res_users__email	base	ir.model.fields
2625	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1149	f	field_res_users__accesses_count	base	ir.model.fields
2626	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1150	f	field_res_users__rules_count	base	ir.model.fields
2627	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1151	f	field_res_users__groups_count	base	ir.model.fields
2628	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1152	f	field_res_users__id	base	ir.model.fields
2629	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1153	f	field_res_users__display_name	base	ir.model.fields
2630	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1154	f	field_res_users__create_uid	base	ir.model.fields
2631	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1155	f	field_res_users__create_date	base	ir.model.fields
2632	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1156	f	field_res_users__write_uid	base	ir.model.fields
2633	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1157	f	field_res_users__write_date	base	ir.model.fields
2634	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1158	f	field_res_users__user_group_warning	base	ir.model.fields
2635	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1159	f	field_res_users__api_key_ids	base	ir.model.fields
2636	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1160	f	field_res_users__image_1920	base	ir.model.fields
2637	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1161	f	field_res_users__image_1024	base	ir.model.fields
2638	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1162	f	field_res_users__image_512	base	ir.model.fields
2639	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1163	f	field_res_users__image_256	base	ir.model.fields
2640	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1164	f	field_res_users__image_128	base	ir.model.fields
2641	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1165	f	field_res_users__avatar_1920	base	ir.model.fields
2642	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1166	f	field_res_users__avatar_1024	base	ir.model.fields
2643	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1167	f	field_res_users__avatar_512	base	ir.model.fields
2644	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1168	f	field_res_users__avatar_256	base	ir.model.fields
2645	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1169	f	field_res_users__avatar_128	base	ir.model.fields
2646	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1170	f	field_res_users__complete_name	base	ir.model.fields
2647	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1171	f	field_res_users__title	base	ir.model.fields
2648	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1172	f	field_res_users__parent_id	base	ir.model.fields
2649	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1173	f	field_res_users__parent_name	base	ir.model.fields
2650	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1174	f	field_res_users__child_ids	base	ir.model.fields
2651	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1175	f	field_res_users__ref	base	ir.model.fields
2652	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1176	f	field_res_users__lang	base	ir.model.fields
2653	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1177	f	field_res_users__active_lang_count	base	ir.model.fields
2654	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1178	f	field_res_users__tz	base	ir.model.fields
2655	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1179	f	field_res_users__user_id	base	ir.model.fields
2656	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1180	f	field_res_users__vat	base	ir.model.fields
2657	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1181	f	field_res_users__vat_label	base	ir.model.fields
2658	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1182	f	field_res_users__same_vat_partner_id	base	ir.model.fields
2659	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1183	f	field_res_users__same_company_registry_partner_id	base	ir.model.fields
2660	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1184	f	field_res_users__company_registry	base	ir.model.fields
2661	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1185	f	field_res_users__company_registry_label	base	ir.model.fields
2662	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1186	f	field_res_users__bank_ids	base	ir.model.fields
2663	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1187	f	field_res_users__website	base	ir.model.fields
2664	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1188	f	field_res_users__comment	base	ir.model.fields
2665	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1189	f	field_res_users__category_id	base	ir.model.fields
2666	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1190	f	field_res_users__employee	base	ir.model.fields
2667	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1191	f	field_res_users__function	base	ir.model.fields
2668	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1192	f	field_res_users__type	base	ir.model.fields
2669	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1193	f	field_res_users__street	base	ir.model.fields
2670	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1194	f	field_res_users__street2	base	ir.model.fields
2671	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1195	f	field_res_users__zip	base	ir.model.fields
2672	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1196	f	field_res_users__city	base	ir.model.fields
2673	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1197	f	field_res_users__state_id	base	ir.model.fields
2674	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1198	f	field_res_users__country_id	base	ir.model.fields
2675	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1199	f	field_res_users__country_code	base	ir.model.fields
2676	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1200	f	field_res_users__partner_latitude	base	ir.model.fields
2677	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1201	f	field_res_users__partner_longitude	base	ir.model.fields
2678	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1202	f	field_res_users__email_formatted	base	ir.model.fields
2679	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1203	f	field_res_users__phone	base	ir.model.fields
2680	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1204	f	field_res_users__mobile	base	ir.model.fields
2681	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1205	f	field_res_users__is_company	base	ir.model.fields
2682	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1206	f	field_res_users__is_public	base	ir.model.fields
2683	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1207	f	field_res_users__industry_id	base	ir.model.fields
2684	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1208	f	field_res_users__company_type	base	ir.model.fields
2685	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1209	f	field_res_users__color	base	ir.model.fields
2686	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1210	f	field_res_users__user_ids	base	ir.model.fields
2687	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1211	f	field_res_users__partner_share	base	ir.model.fields
2688	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1212	f	field_res_users__contact_address	base	ir.model.fields
2689	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1213	f	field_res_users__commercial_partner_id	base	ir.model.fields
2690	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1214	f	field_res_users__commercial_company_name	base	ir.model.fields
2691	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1215	f	field_res_users__company_name	base	ir.model.fields
2692	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1216	f	field_res_users__barcode	base	ir.model.fields
2693	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1217	f	field_res_users__self	base	ir.model.fields
2694	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1218	f	field_res_users_identitycheck__request	base	ir.model.fields
2695	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1219	f	field_res_users_identitycheck__auth_method	base	ir.model.fields
2696	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1220	f	field_res_users_identitycheck__password	base	ir.model.fields
2697	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1221	f	field_res_users_identitycheck__id	base	ir.model.fields
2698	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1222	f	field_res_users_identitycheck__display_name	base	ir.model.fields
2699	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1223	f	field_res_users_identitycheck__create_uid	base	ir.model.fields
2700	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1224	f	field_res_users_identitycheck__create_date	base	ir.model.fields
2701	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1225	f	field_res_users_identitycheck__write_uid	base	ir.model.fields
2702	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1226	f	field_res_users_identitycheck__write_date	base	ir.model.fields
2703	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1227	f	field_change_password_wizard__user_ids	base	ir.model.fields
2704	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1228	f	field_change_password_wizard__id	base	ir.model.fields
2705	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1229	f	field_change_password_wizard__display_name	base	ir.model.fields
2706	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1230	f	field_change_password_wizard__create_uid	base	ir.model.fields
2707	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1231	f	field_change_password_wizard__create_date	base	ir.model.fields
2708	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1232	f	field_change_password_wizard__write_uid	base	ir.model.fields
2709	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1233	f	field_change_password_wizard__write_date	base	ir.model.fields
2710	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1234	f	field_change_password_user__wizard_id	base	ir.model.fields
2711	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1235	f	field_change_password_user__user_id	base	ir.model.fields
2712	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1236	f	field_change_password_user__user_login	base	ir.model.fields
2713	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1237	f	field_change_password_user__new_passwd	base	ir.model.fields
2714	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1238	f	field_change_password_user__id	base	ir.model.fields
2715	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1239	f	field_change_password_user__display_name	base	ir.model.fields
2716	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1240	f	field_change_password_user__create_uid	base	ir.model.fields
2717	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1241	f	field_change_password_user__create_date	base	ir.model.fields
2718	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1242	f	field_change_password_user__write_uid	base	ir.model.fields
2719	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1243	f	field_change_password_user__write_date	base	ir.model.fields
2720	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1244	f	field_change_password_own__new_password	base	ir.model.fields
2721	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1245	f	field_change_password_own__confirm_password	base	ir.model.fields
2722	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1246	f	field_change_password_own__id	base	ir.model.fields
2723	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1247	f	field_change_password_own__display_name	base	ir.model.fields
2724	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1248	f	field_change_password_own__create_uid	base	ir.model.fields
2725	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1249	f	field_change_password_own__create_date	base	ir.model.fields
2726	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1250	f	field_change_password_own__write_uid	base	ir.model.fields
2727	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1251	f	field_change_password_own__write_date	base	ir.model.fields
2728	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1252	f	field_res_users_apikeys__name	base	ir.model.fields
2729	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1253	f	field_res_users_apikeys__user_id	base	ir.model.fields
2730	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1254	f	field_res_users_apikeys__scope	base	ir.model.fields
2731	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1255	f	field_res_users_apikeys__create_date	base	ir.model.fields
2732	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1256	f	field_res_users_apikeys__expiration_date	base	ir.model.fields
2733	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1257	f	field_res_users_apikeys__id	base	ir.model.fields
2734	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1258	f	field_res_users_apikeys__display_name	base	ir.model.fields
2735	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1259	f	field_res_users_apikeys_description__name	base	ir.model.fields
2736	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1260	f	field_res_users_apikeys_description__duration	base	ir.model.fields
2737	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1261	f	field_res_users_apikeys_description__expiration_date	base	ir.model.fields
2738	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1262	f	field_res_users_apikeys_description__id	base	ir.model.fields
2739	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1263	f	field_res_users_apikeys_description__display_name	base	ir.model.fields
2740	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1264	f	field_res_users_apikeys_description__create_uid	base	ir.model.fields
2741	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1265	f	field_res_users_apikeys_description__create_date	base	ir.model.fields
2742	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1266	f	field_res_users_apikeys_description__write_uid	base	ir.model.fields
2743	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1267	f	field_res_users_apikeys_description__write_date	base	ir.model.fields
2744	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1268	f	field_res_users_apikeys_show__id	base	ir.model.fields
2745	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1269	f	field_res_users_apikeys_show__key	base	ir.model.fields
2746	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1270	f	field_res_users_settings__user_id	base	ir.model.fields
2747	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1271	f	field_res_users_settings__id	base	ir.model.fields
2748	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1272	f	field_res_users_settings__display_name	base	ir.model.fields
2749	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1273	f	field_res_users_settings__create_uid	base	ir.model.fields
2750	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1274	f	field_res_users_settings__create_date	base	ir.model.fields
2751	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1275	f	field_res_users_settings__write_uid	base	ir.model.fields
2752	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1276	f	field_res_users_settings__write_date	base	ir.model.fields
2753	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1277	f	field_res_users_deletion__user_id	base	ir.model.fields
2754	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1278	f	field_res_users_deletion__user_id_int	base	ir.model.fields
2755	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1279	f	field_res_users_deletion__state	base	ir.model.fields
2756	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1280	f	field_res_users_deletion__id	base	ir.model.fields
2757	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1281	f	field_res_users_deletion__display_name	base	ir.model.fields
2758	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1282	f	field_res_users_deletion__create_uid	base	ir.model.fields
2759	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1283	f	field_res_users_deletion__create_date	base	ir.model.fields
2760	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1284	f	field_res_users_deletion__write_uid	base	ir.model.fields
2761	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1285	f	field_res_users_deletion__write_date	base	ir.model.fields
2762	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1286	f	field_res_device_log__session_identifier	base	ir.model.fields
2763	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1287	f	field_res_device_log__platform	base	ir.model.fields
2764	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1288	f	field_res_device_log__browser	base	ir.model.fields
2765	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1289	f	field_res_device_log__ip_address	base	ir.model.fields
2766	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1290	f	field_res_device_log__country	base	ir.model.fields
2767	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1291	f	field_res_device_log__city	base	ir.model.fields
2768	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1292	f	field_res_device_log__device_type	base	ir.model.fields
2769	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1293	f	field_res_device_log__user_id	base	ir.model.fields
2770	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1294	f	field_res_device_log__first_activity	base	ir.model.fields
2771	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1295	f	field_res_device_log__last_activity	base	ir.model.fields
2772	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1296	f	field_res_device_log__revoked	base	ir.model.fields
2773	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1297	f	field_res_device_log__is_current	base	ir.model.fields
2774	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1298	f	field_res_device_log__linked_ip_addresses	base	ir.model.fields
2775	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1299	f	field_res_device_log__id	base	ir.model.fields
2776	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1300	f	field_res_device_log__display_name	base	ir.model.fields
2777	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1301	f	field_res_device_log__create_uid	base	ir.model.fields
2778	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1302	f	field_res_device_log__create_date	base	ir.model.fields
2779	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1303	f	field_res_device_log__write_uid	base	ir.model.fields
3906	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	85	f	lang_sv_SE	base	res.lang
2780	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1304	f	field_res_device_log__write_date	base	ir.model.fields
2781	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1305	f	field_res_device__session_identifier	base	ir.model.fields
2782	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1306	f	field_res_device__platform	base	ir.model.fields
2783	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1307	f	field_res_device__browser	base	ir.model.fields
2784	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1308	f	field_res_device__ip_address	base	ir.model.fields
2785	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1309	f	field_res_device__country	base	ir.model.fields
2786	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1310	f	field_res_device__city	base	ir.model.fields
2787	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1311	f	field_res_device__device_type	base	ir.model.fields
2788	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1312	f	field_res_device__user_id	base	ir.model.fields
2789	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1313	f	field_res_device__first_activity	base	ir.model.fields
2790	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1314	f	field_res_device__last_activity	base	ir.model.fields
2791	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1315	f	field_res_device__revoked	base	ir.model.fields
2792	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1316	f	field_res_device__is_current	base	ir.model.fields
2793	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1317	f	field_res_device__linked_ip_addresses	base	ir.model.fields
2794	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1318	f	field_res_device__id	base	ir.model.fields
2795	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1319	f	field_res_device__display_name	base	ir.model.fields
2796	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1320	f	field_res_device__create_uid	base	ir.model.fields
2797	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1321	f	field_res_device__create_date	base	ir.model.fields
2798	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1322	f	field_res_device__write_uid	base	ir.model.fields
2799	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1323	f	field_res_device__write_date	base	ir.model.fields
2800	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1324	f	field_decimal_precision__name	base	ir.model.fields
2801	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1325	f	field_decimal_precision__digits	base	ir.model.fields
2802	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1326	f	field_decimal_precision__id	base	ir.model.fields
2803	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1327	f	field_decimal_precision__display_name	base	ir.model.fields
2804	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1328	f	field_decimal_precision__create_uid	base	ir.model.fields
2805	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1329	f	field_decimal_precision__create_date	base	ir.model.fields
2806	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1330	f	field_decimal_precision__write_uid	base	ir.model.fields
2807	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1331	f	field_decimal_precision__write_date	base	ir.model.fields
2808	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1332	f	field_base_module_update__updated	base	ir.model.fields
2809	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1333	f	field_base_module_update__added	base	ir.model.fields
2810	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1334	f	field_base_module_update__state	base	ir.model.fields
2811	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1335	f	field_base_module_update__id	base	ir.model.fields
2812	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1336	f	field_base_module_update__display_name	base	ir.model.fields
2813	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1337	f	field_base_module_update__create_uid	base	ir.model.fields
2814	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1338	f	field_base_module_update__create_date	base	ir.model.fields
2815	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1339	f	field_base_module_update__write_uid	base	ir.model.fields
2816	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1340	f	field_base_module_update__write_date	base	ir.model.fields
2817	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1341	f	field_base_language_install__lang_ids	base	ir.model.fields
2818	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1342	f	field_base_language_install__overwrite	base	ir.model.fields
2819	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1343	f	field_base_language_install__first_lang_id	base	ir.model.fields
2820	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1344	f	field_base_language_install__id	base	ir.model.fields
2821	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1345	f	field_base_language_install__display_name	base	ir.model.fields
2822	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1346	f	field_base_language_install__create_uid	base	ir.model.fields
2823	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1347	f	field_base_language_install__create_date	base	ir.model.fields
2824	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1348	f	field_base_language_install__write_uid	base	ir.model.fields
2825	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1349	f	field_base_language_install__write_date	base	ir.model.fields
2826	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1350	f	field_base_language_import__name	base	ir.model.fields
2827	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1351	f	field_base_language_import__code	base	ir.model.fields
2828	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1352	f	field_base_language_import__data	base	ir.model.fields
2829	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1353	f	field_base_language_import__filename	base	ir.model.fields
2830	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1354	f	field_base_language_import__overwrite	base	ir.model.fields
2831	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1355	f	field_base_language_import__id	base	ir.model.fields
2832	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1356	f	field_base_language_import__display_name	base	ir.model.fields
2833	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1357	f	field_base_language_import__create_uid	base	ir.model.fields
2834	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1358	f	field_base_language_import__create_date	base	ir.model.fields
2835	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1359	f	field_base_language_import__write_uid	base	ir.model.fields
2836	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1360	f	field_base_language_import__write_date	base	ir.model.fields
2837	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1361	f	field_base_module_upgrade__module_info	base	ir.model.fields
2838	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1362	f	field_base_module_upgrade__id	base	ir.model.fields
2839	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1363	f	field_base_module_upgrade__display_name	base	ir.model.fields
2840	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1364	f	field_base_module_upgrade__create_uid	base	ir.model.fields
2841	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1365	f	field_base_module_upgrade__create_date	base	ir.model.fields
2842	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1366	f	field_base_module_upgrade__write_uid	base	ir.model.fields
2843	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1367	f	field_base_module_upgrade__write_date	base	ir.model.fields
2844	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1368	f	field_base_module_uninstall__show_all	base	ir.model.fields
2845	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1369	f	field_base_module_uninstall__module_id	base	ir.model.fields
2846	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1370	f	field_base_module_uninstall__module_ids	base	ir.model.fields
2847	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1371	f	field_base_module_uninstall__model_ids	base	ir.model.fields
2848	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1372	f	field_base_module_uninstall__id	base	ir.model.fields
2849	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1373	f	field_base_module_uninstall__display_name	base	ir.model.fields
2850	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1374	f	field_base_module_uninstall__create_uid	base	ir.model.fields
2851	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1375	f	field_base_module_uninstall__create_date	base	ir.model.fields
2852	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1376	f	field_base_module_uninstall__write_uid	base	ir.model.fields
2853	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1377	f	field_base_module_uninstall__write_date	base	ir.model.fields
2854	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1378	f	field_base_language_export__name	base	ir.model.fields
2855	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1379	f	field_base_language_export__lang	base	ir.model.fields
2856	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1380	f	field_base_language_export__format	base	ir.model.fields
2857	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1381	f	field_base_language_export__export_type	base	ir.model.fields
2858	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1382	f	field_base_language_export__modules	base	ir.model.fields
2859	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1383	f	field_base_language_export__model_id	base	ir.model.fields
2860	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1384	f	field_base_language_export__model_name	base	ir.model.fields
2861	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1385	f	field_base_language_export__domain	base	ir.model.fields
2862	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1386	f	field_base_language_export__data	base	ir.model.fields
2863	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1387	f	field_base_language_export__state	base	ir.model.fields
2864	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1388	f	field_base_language_export__id	base	ir.model.fields
2865	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1389	f	field_base_language_export__display_name	base	ir.model.fields
2866	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1390	f	field_base_language_export__create_uid	base	ir.model.fields
2867	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1391	f	field_base_language_export__create_date	base	ir.model.fields
2868	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1392	f	field_base_language_export__write_uid	base	ir.model.fields
2869	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1393	f	field_base_language_export__write_date	base	ir.model.fields
2870	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1394	f	field_base_partner_merge_line__wizard_id	base	ir.model.fields
2871	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1395	f	field_base_partner_merge_line__min_id	base	ir.model.fields
2872	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1396	f	field_base_partner_merge_line__aggr_ids	base	ir.model.fields
2873	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1397	f	field_base_partner_merge_line__id	base	ir.model.fields
2874	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1398	f	field_base_partner_merge_line__display_name	base	ir.model.fields
2875	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1399	f	field_base_partner_merge_line__create_uid	base	ir.model.fields
2876	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1400	f	field_base_partner_merge_line__create_date	base	ir.model.fields
2877	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1401	f	field_base_partner_merge_line__write_uid	base	ir.model.fields
2878	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1402	f	field_base_partner_merge_line__write_date	base	ir.model.fields
2879	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1403	f	field_base_partner_merge_automatic_wizard__group_by_email	base	ir.model.fields
2880	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1404	f	field_base_partner_merge_automatic_wizard__group_by_name	base	ir.model.fields
2881	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1405	f	field_base_partner_merge_automatic_wizard__group_by_is_company	base	ir.model.fields
2882	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1406	f	field_base_partner_merge_automatic_wizard__group_by_vat	base	ir.model.fields
2883	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1407	f	field_base_partner_merge_automatic_wizard__group_by_parent_id	base	ir.model.fields
2884	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1408	f	field_base_partner_merge_automatic_wizard__state	base	ir.model.fields
2885	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1409	f	field_base_partner_merge_automatic_wizard__number_group	base	ir.model.fields
2886	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1410	f	field_base_partner_merge_automatic_wizard__current_line_id	base	ir.model.fields
2887	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1411	f	field_base_partner_merge_automatic_wizard__line_ids	base	ir.model.fields
2888	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1412	f	field_base_partner_merge_automatic_wizard__partner_ids	base	ir.model.fields
2889	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1413	f	field_base_partner_merge_automatic_wizard__dst_partner_id	base	ir.model.fields
2890	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1414	f	field_base_partner_merge_automatic_wizard__exclude_contact	base	ir.model.fields
2891	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1415	f	field_base_partner_merge_automatic_wizard__exclude_journal_item	base	ir.model.fields
2892	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1416	f	field_base_partner_merge_automatic_wizard__maximum_group	base	ir.model.fields
2893	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1417	f	field_base_partner_merge_automatic_wizard__id	base	ir.model.fields
2894	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1418	f	field_base_partner_merge_automatic_wizard__display_name	base	ir.model.fields
2895	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1419	f	field_base_partner_merge_automatic_wizard__create_uid	base	ir.model.fields
2896	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1420	f	field_base_partner_merge_automatic_wizard__create_date	base	ir.model.fields
2897	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1421	f	field_base_partner_merge_automatic_wizard__write_uid	base	ir.model.fields
2898	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1422	f	field_base_partner_merge_automatic_wizard__write_date	base	ir.model.fields
2899	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	f	selection__ir_model__state__manual	base	ir.model.fields.selection
2900	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	f	selection__ir_model__state__base	base	ir.model.fields.selection
2901	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	f	selection__ir_model_fields__ttype__binary	base	ir.model.fields.selection
2902	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	f	selection__ir_model_fields__ttype__boolean	base	ir.model.fields.selection
2903	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	f	selection__ir_model_fields__ttype__char	base	ir.model.fields.selection
2904	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	6	f	selection__ir_model_fields__ttype__date	base	ir.model.fields.selection
2905	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	7	f	selection__ir_model_fields__ttype__datetime	base	ir.model.fields.selection
2906	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	8	f	selection__ir_model_fields__ttype__float	base	ir.model.fields.selection
2907	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	9	f	selection__ir_model_fields__ttype__html	base	ir.model.fields.selection
2908	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	10	f	selection__ir_model_fields__ttype__integer	base	ir.model.fields.selection
2909	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	11	f	selection__ir_model_fields__ttype__json	base	ir.model.fields.selection
2910	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	12	f	selection__ir_model_fields__ttype__many2many	base	ir.model.fields.selection
2911	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	13	f	selection__ir_model_fields__ttype__many2one	base	ir.model.fields.selection
2912	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	14	f	selection__ir_model_fields__ttype__many2one_reference	base	ir.model.fields.selection
2913	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	15	f	selection__ir_model_fields__ttype__monetary	base	ir.model.fields.selection
2914	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	16	f	selection__ir_model_fields__ttype__one2many	base	ir.model.fields.selection
2915	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	17	f	selection__ir_model_fields__ttype__properties	base	ir.model.fields.selection
2916	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	18	f	selection__ir_model_fields__ttype__properties_definition	base	ir.model.fields.selection
2917	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	19	f	selection__ir_model_fields__ttype__reference	base	ir.model.fields.selection
2918	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	20	f	selection__ir_model_fields__ttype__selection	base	ir.model.fields.selection
2919	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	21	f	selection__ir_model_fields__ttype__text	base	ir.model.fields.selection
2920	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	22	f	selection__ir_model_fields__state__manual	base	ir.model.fields.selection
2921	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	23	f	selection__ir_model_fields__state__base	base	ir.model.fields.selection
2922	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	24	f	selection__ir_model_fields__on_delete__cascade	base	ir.model.fields.selection
2923	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	25	f	selection__ir_model_fields__on_delete__set_null	base	ir.model.fields.selection
2924	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	26	f	selection__ir_model_fields__on_delete__restrict	base	ir.model.fields.selection
2925	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	27	f	selection__ir_sequence__implementation__standard	base	ir.model.fields.selection
2926	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	28	f	selection__ir_sequence__implementation__no_gap	base	ir.model.fields.selection
2927	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	29	f	selection__ir_ui_menu__action__ir_actions_report	base	ir.model.fields.selection
2928	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	30	f	selection__ir_ui_menu__action__ir_actions_act_window	base	ir.model.fields.selection
2929	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	31	f	selection__ir_ui_menu__action__ir_actions_act_url	base	ir.model.fields.selection
2930	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	32	f	selection__ir_ui_menu__action__ir_actions_server	base	ir.model.fields.selection
2931	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	33	f	selection__ir_ui_menu__action__ir_actions_client	base	ir.model.fields.selection
2932	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	34	f	selection__ir_ui_view__type__list	base	ir.model.fields.selection
2933	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	35	f	selection__ir_ui_view__type__form	base	ir.model.fields.selection
2934	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	36	f	selection__ir_ui_view__type__graph	base	ir.model.fields.selection
2935	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	37	f	selection__ir_ui_view__type__pivot	base	ir.model.fields.selection
2936	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	38	f	selection__ir_ui_view__type__calendar	base	ir.model.fields.selection
2937	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	39	f	selection__ir_ui_view__type__kanban	base	ir.model.fields.selection
2938	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	40	f	selection__ir_ui_view__type__search	base	ir.model.fields.selection
2939	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	41	f	selection__ir_ui_view__type__qweb	base	ir.model.fields.selection
2940	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	42	f	selection__ir_ui_view__mode__primary	base	ir.model.fields.selection
2941	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	43	f	selection__ir_ui_view__mode__extension	base	ir.model.fields.selection
2942	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	44	f	selection__reset_view_arch_wizard__reset_mode__soft	base	ir.model.fields.selection
2943	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	45	f	selection__reset_view_arch_wizard__reset_mode__hard	base	ir.model.fields.selection
2944	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	46	f	selection__reset_view_arch_wizard__reset_mode__other_view	base	ir.model.fields.selection
2945	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	47	f	selection__ir_asset__directive__append	base	ir.model.fields.selection
2946	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	48	f	selection__ir_asset__directive__prepend	base	ir.model.fields.selection
2947	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	49	f	selection__ir_asset__directive__after	base	ir.model.fields.selection
2948	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	50	f	selection__ir_asset__directive__before	base	ir.model.fields.selection
2949	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	51	f	selection__ir_asset__directive__remove	base	ir.model.fields.selection
2950	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	52	f	selection__ir_asset__directive__replace	base	ir.model.fields.selection
2951	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	53	f	selection__ir_asset__directive__include	base	ir.model.fields.selection
2952	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	54	f	selection__ir_actions_actions__binding_type__action	base	ir.model.fields.selection
2953	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	55	f	selection__ir_actions_actions__binding_type__report	base	ir.model.fields.selection
2954	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	56	f	selection__ir_actions_act_window__binding_type__action	base	ir.model.fields.selection
2955	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	57	f	selection__ir_actions_act_window__binding_type__report	base	ir.model.fields.selection
2956	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	58	f	selection__ir_actions_act_window__target__current	base	ir.model.fields.selection
2957	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	59	f	selection__ir_actions_act_window__target__new	base	ir.model.fields.selection
2958	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	60	f	selection__ir_actions_act_window__target__inline	base	ir.model.fields.selection
2959	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	61	f	selection__ir_actions_act_window__target__fullscreen	base	ir.model.fields.selection
2960	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	62	f	selection__ir_actions_act_window__target__main	base	ir.model.fields.selection
2961	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	63	f	selection__ir_actions_act_window_view__view_mode__list	base	ir.model.fields.selection
2962	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	64	f	selection__ir_actions_act_window_view__view_mode__form	base	ir.model.fields.selection
2963	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	65	f	selection__ir_actions_act_window_view__view_mode__graph	base	ir.model.fields.selection
2964	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	66	f	selection__ir_actions_act_window_view__view_mode__pivot	base	ir.model.fields.selection
2965	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	67	f	selection__ir_actions_act_window_view__view_mode__calendar	base	ir.model.fields.selection
2966	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	68	f	selection__ir_actions_act_window_view__view_mode__kanban	base	ir.model.fields.selection
2967	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	69	f	selection__ir_actions_act_window_close__binding_type__action	base	ir.model.fields.selection
2968	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	70	f	selection__ir_actions_act_window_close__binding_type__report	base	ir.model.fields.selection
2969	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	71	f	selection__ir_actions_act_url__binding_type__action	base	ir.model.fields.selection
2970	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	72	f	selection__ir_actions_act_url__binding_type__report	base	ir.model.fields.selection
2971	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	73	f	selection__ir_actions_act_url__target__new	base	ir.model.fields.selection
2972	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	74	f	selection__ir_actions_act_url__target__self	base	ir.model.fields.selection
2973	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	75	f	selection__ir_actions_act_url__target__download	base	ir.model.fields.selection
2974	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	76	f	selection__ir_actions_server__binding_type__action	base	ir.model.fields.selection
2975	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	77	f	selection__ir_actions_server__binding_type__report	base	ir.model.fields.selection
2976	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	78	f	selection__ir_actions_server__usage__ir_actions_server	base	ir.model.fields.selection
2977	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	79	f	selection__ir_actions_server__usage__ir_cron	base	ir.model.fields.selection
2978	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	80	f	selection__ir_actions_server__state__object_write	base	ir.model.fields.selection
2979	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	81	f	selection__ir_actions_server__state__object_create	base	ir.model.fields.selection
2980	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	82	f	selection__ir_actions_server__state__code	base	ir.model.fields.selection
2981	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	83	f	selection__ir_actions_server__state__webhook	base	ir.model.fields.selection
2982	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	84	f	selection__ir_actions_server__state__multi	base	ir.model.fields.selection
2983	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	85	f	selection__ir_actions_server__update_m2m_operation__add	base	ir.model.fields.selection
2984	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	86	f	selection__ir_actions_server__update_m2m_operation__remove	base	ir.model.fields.selection
2985	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	87	f	selection__ir_actions_server__update_m2m_operation__set	base	ir.model.fields.selection
2986	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	88	f	selection__ir_actions_server__update_m2m_operation__clear	base	ir.model.fields.selection
2987	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	89	f	selection__ir_actions_server__update_boolean_value__true	base	ir.model.fields.selection
2988	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	90	f	selection__ir_actions_server__update_boolean_value__false	base	ir.model.fields.selection
2989	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	91	f	selection__ir_actions_server__evaluation_type__value	base	ir.model.fields.selection
2990	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	92	f	selection__ir_actions_server__evaluation_type__equation	base	ir.model.fields.selection
2991	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	93	f	selection__ir_actions_server__value_field_to_show__value	base	ir.model.fields.selection
2992	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	94	f	selection__ir_actions_server__value_field_to_show__resource_ref	base	ir.model.fields.selection
2993	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	95	f	selection__ir_actions_server__value_field_to_show__update_boolean_value	base	ir.model.fields.selection
2994	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	96	f	selection__ir_actions_server__value_field_to_show__selection_value	base	ir.model.fields.selection
2995	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	97	f	selection__ir_actions_todo__state__open	base	ir.model.fields.selection
2996	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	98	f	selection__ir_actions_todo__state__done	base	ir.model.fields.selection
2997	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	99	f	selection__ir_actions_client__binding_type__action	base	ir.model.fields.selection
2998	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	100	f	selection__ir_actions_client__binding_type__report	base	ir.model.fields.selection
2999	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	101	f	selection__ir_actions_client__target__current	base	ir.model.fields.selection
3000	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	102	f	selection__ir_actions_client__target__new	base	ir.model.fields.selection
3001	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	103	f	selection__ir_actions_client__target__fullscreen	base	ir.model.fields.selection
3002	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	104	f	selection__ir_actions_client__target__main	base	ir.model.fields.selection
3003	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	105	f	selection__ir_actions_report__binding_type__action	base	ir.model.fields.selection
3004	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	106	f	selection__ir_actions_report__binding_type__report	base	ir.model.fields.selection
3005	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	107	f	selection__ir_actions_report__report_type__qweb-html	base	ir.model.fields.selection
3006	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	108	f	selection__ir_actions_report__report_type__qweb-pdf	base	ir.model.fields.selection
3007	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	109	f	selection__ir_actions_report__report_type__qweb-text	base	ir.model.fields.selection
3008	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	110	f	selection__ir_attachment__type__url	base	ir.model.fields.selection
3009	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	111	f	selection__ir_attachment__type__binary	base	ir.model.fields.selection
3010	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	112	f	selection__ir_cron__interval_type__minutes	base	ir.model.fields.selection
3011	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	113	f	selection__ir_cron__interval_type__hours	base	ir.model.fields.selection
3012	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	114	f	selection__ir_cron__interval_type__days	base	ir.model.fields.selection
3013	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	115	f	selection__ir_cron__interval_type__weeks	base	ir.model.fields.selection
3014	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	116	f	selection__ir_cron__interval_type__months	base	ir.model.fields.selection
3015	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	117	f	selection__ir_mail_server__smtp_authentication__login	base	ir.model.fields.selection
3016	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	118	f	selection__ir_mail_server__smtp_authentication__certificate	base	ir.model.fields.selection
3017	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	119	f	selection__ir_mail_server__smtp_authentication__cli	base	ir.model.fields.selection
3018	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	120	f	selection__ir_mail_server__smtp_encryption__none	base	ir.model.fields.selection
3019	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	121	f	selection__ir_mail_server__smtp_encryption__starttls	base	ir.model.fields.selection
3020	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	122	f	selection__ir_mail_server__smtp_encryption__ssl	base	ir.model.fields.selection
3021	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	123	f	selection__ir_logging__type__client	base	ir.model.fields.selection
3022	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	124	f	selection__ir_logging__type__server	base	ir.model.fields.selection
3023	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	125	f	selection__ir_module_module__state__uninstallable	base	ir.model.fields.selection
3024	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	126	f	selection__ir_module_module__state__uninstalled	base	ir.model.fields.selection
3025	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	127	f	selection__ir_module_module__state__installed	base	ir.model.fields.selection
3026	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	128	f	selection__ir_module_module__state__to_upgrade	base	ir.model.fields.selection
3027	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	129	f	selection__ir_module_module__state__to_remove	base	ir.model.fields.selection
3028	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	130	f	selection__ir_module_module__state__to_install	base	ir.model.fields.selection
3029	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	131	f	selection__ir_module_module__license__gpl-2	base	ir.model.fields.selection
3030	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	132	f	selection__ir_module_module__license__gpl-2_or_any_later_version	base	ir.model.fields.selection
3031	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	133	f	selection__ir_module_module__license__gpl-3	base	ir.model.fields.selection
3032	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	134	f	selection__ir_module_module__license__gpl-3_or_any_later_version	base	ir.model.fields.selection
3033	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	135	f	selection__ir_module_module__license__agpl-3	base	ir.model.fields.selection
3034	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	136	f	selection__ir_module_module__license__lgpl-3	base	ir.model.fields.selection
3035	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	137	f	selection__ir_module_module__license__other_osi_approved_licence	base	ir.model.fields.selection
3036	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	138	f	selection__ir_module_module__license__oeel-1	base	ir.model.fields.selection
3037	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	139	f	selection__ir_module_module__license__opl-1	base	ir.model.fields.selection
3038	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	140	f	selection__ir_module_module__license__other_proprietary	base	ir.model.fields.selection
3039	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	141	f	selection__ir_module_module_dependency__state__uninstallable	base	ir.model.fields.selection
3040	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	142	f	selection__ir_module_module_dependency__state__uninstalled	base	ir.model.fields.selection
3041	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	143	f	selection__ir_module_module_dependency__state__installed	base	ir.model.fields.selection
3042	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	144	f	selection__ir_module_module_dependency__state__to_upgrade	base	ir.model.fields.selection
3043	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	145	f	selection__ir_module_module_dependency__state__to_remove	base	ir.model.fields.selection
3044	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	146	f	selection__ir_module_module_dependency__state__to_install	base	ir.model.fields.selection
3045	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	147	f	selection__ir_module_module_dependency__state__unknown	base	ir.model.fields.selection
3046	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	148	f	selection__ir_module_module_exclusion__state__uninstallable	base	ir.model.fields.selection
3047	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	149	f	selection__ir_module_module_exclusion__state__uninstalled	base	ir.model.fields.selection
3048	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	150	f	selection__ir_module_module_exclusion__state__installed	base	ir.model.fields.selection
3049	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	151	f	selection__ir_module_module_exclusion__state__to_upgrade	base	ir.model.fields.selection
3050	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	152	f	selection__ir_module_module_exclusion__state__to_remove	base	ir.model.fields.selection
3051	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	153	f	selection__ir_module_module_exclusion__state__to_install	base	ir.model.fields.selection
3052	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	154	f	selection__ir_module_module_exclusion__state__unknown	base	ir.model.fields.selection
3053	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	155	f	selection__report_paperformat__format__a0	base	ir.model.fields.selection
3054	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	156	f	selection__report_paperformat__format__a1	base	ir.model.fields.selection
3055	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	157	f	selection__report_paperformat__format__a2	base	ir.model.fields.selection
3056	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	158	f	selection__report_paperformat__format__a3	base	ir.model.fields.selection
3057	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	159	f	selection__report_paperformat__format__a4	base	ir.model.fields.selection
3058	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	160	f	selection__report_paperformat__format__a5	base	ir.model.fields.selection
3059	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	161	f	selection__report_paperformat__format__a6	base	ir.model.fields.selection
3060	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	162	f	selection__report_paperformat__format__a7	base	ir.model.fields.selection
3061	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	163	f	selection__report_paperformat__format__a8	base	ir.model.fields.selection
3062	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	164	f	selection__report_paperformat__format__a9	base	ir.model.fields.selection
3063	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	165	f	selection__report_paperformat__format__b0	base	ir.model.fields.selection
3064	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	166	f	selection__report_paperformat__format__b1	base	ir.model.fields.selection
3065	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	167	f	selection__report_paperformat__format__b2	base	ir.model.fields.selection
3066	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	168	f	selection__report_paperformat__format__b3	base	ir.model.fields.selection
3067	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	169	f	selection__report_paperformat__format__b4	base	ir.model.fields.selection
3068	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	170	f	selection__report_paperformat__format__b5	base	ir.model.fields.selection
3069	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	171	f	selection__report_paperformat__format__b6	base	ir.model.fields.selection
3070	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	172	f	selection__report_paperformat__format__b7	base	ir.model.fields.selection
3071	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	173	f	selection__report_paperformat__format__b8	base	ir.model.fields.selection
3072	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	174	f	selection__report_paperformat__format__b9	base	ir.model.fields.selection
3073	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	175	f	selection__report_paperformat__format__b10	base	ir.model.fields.selection
3074	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	176	f	selection__report_paperformat__format__c5e	base	ir.model.fields.selection
3075	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	177	f	selection__report_paperformat__format__comm10e	base	ir.model.fields.selection
3076	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	178	f	selection__report_paperformat__format__dle	base	ir.model.fields.selection
3077	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	179	f	selection__report_paperformat__format__executive	base	ir.model.fields.selection
3078	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	180	f	selection__report_paperformat__format__folio	base	ir.model.fields.selection
3079	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	181	f	selection__report_paperformat__format__ledger	base	ir.model.fields.selection
3080	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	182	f	selection__report_paperformat__format__legal	base	ir.model.fields.selection
3081	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	183	f	selection__report_paperformat__format__letter	base	ir.model.fields.selection
3082	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	184	f	selection__report_paperformat__format__tabloid	base	ir.model.fields.selection
3083	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	185	f	selection__report_paperformat__format__custom	base	ir.model.fields.selection
3084	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	186	f	selection__report_paperformat__orientation__landscape	base	ir.model.fields.selection
3085	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	187	f	selection__report_paperformat__orientation__portrait	base	ir.model.fields.selection
3086	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	188	f	selection__base_enable_profiling_wizard__duration__minutes_5	base	ir.model.fields.selection
3087	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	189	f	selection__base_enable_profiling_wizard__duration__hours_1	base	ir.model.fields.selection
3088	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	190	f	selection__base_enable_profiling_wizard__duration__days_1	base	ir.model.fields.selection
3089	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	191	f	selection__base_enable_profiling_wizard__duration__months_1	base	ir.model.fields.selection
3090	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	192	f	selection__res_country__name_position__before	base	ir.model.fields.selection
3091	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	193	f	selection__res_country__name_position__after	base	ir.model.fields.selection
3092	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	194	f	selection__res_lang__direction__ltr	base	ir.model.fields.selection
3093	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	195	f	selection__res_lang__direction__rtl	base	ir.model.fields.selection
3094	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	196	f	selection__res_lang__week_start__1	base	ir.model.fields.selection
3095	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	197	f	selection__res_lang__week_start__2	base	ir.model.fields.selection
3096	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	198	f	selection__res_lang__week_start__3	base	ir.model.fields.selection
3097	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	199	f	selection__res_lang__week_start__4	base	ir.model.fields.selection
3098	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	200	f	selection__res_lang__week_start__5	base	ir.model.fields.selection
3099	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	201	f	selection__res_lang__week_start__6	base	ir.model.fields.selection
3100	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	202	f	selection__res_lang__week_start__7	base	ir.model.fields.selection
3101	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	203	f	selection__res_partner__tz__africa/abidjan	base	ir.model.fields.selection
3102	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	204	f	selection__res_partner__tz__africa/accra	base	ir.model.fields.selection
3103	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	205	f	selection__res_partner__tz__africa/addis_ababa	base	ir.model.fields.selection
3104	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	206	f	selection__res_partner__tz__africa/algiers	base	ir.model.fields.selection
3105	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	207	f	selection__res_partner__tz__africa/asmara	base	ir.model.fields.selection
3106	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	208	f	selection__res_partner__tz__africa/asmera	base	ir.model.fields.selection
3107	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	209	f	selection__res_partner__tz__africa/bamako	base	ir.model.fields.selection
3108	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	210	f	selection__res_partner__tz__africa/bangui	base	ir.model.fields.selection
3109	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	211	f	selection__res_partner__tz__africa/banjul	base	ir.model.fields.selection
3110	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	212	f	selection__res_partner__tz__africa/bissau	base	ir.model.fields.selection
3111	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	213	f	selection__res_partner__tz__africa/blantyre	base	ir.model.fields.selection
3112	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	214	f	selection__res_partner__tz__africa/brazzaville	base	ir.model.fields.selection
3113	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	215	f	selection__res_partner__tz__africa/bujumbura	base	ir.model.fields.selection
3114	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	216	f	selection__res_partner__tz__africa/cairo	base	ir.model.fields.selection
3115	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	217	f	selection__res_partner__tz__africa/casablanca	base	ir.model.fields.selection
3116	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	218	f	selection__res_partner__tz__africa/ceuta	base	ir.model.fields.selection
3117	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	219	f	selection__res_partner__tz__africa/conakry	base	ir.model.fields.selection
3118	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	220	f	selection__res_partner__tz__africa/dakar	base	ir.model.fields.selection
3119	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	221	f	selection__res_partner__tz__africa/dar_es_salaam	base	ir.model.fields.selection
3120	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	222	f	selection__res_partner__tz__africa/djibouti	base	ir.model.fields.selection
3121	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	223	f	selection__res_partner__tz__africa/douala	base	ir.model.fields.selection
3122	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	224	f	selection__res_partner__tz__africa/el_aaiun	base	ir.model.fields.selection
3123	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	225	f	selection__res_partner__tz__africa/freetown	base	ir.model.fields.selection
3124	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	226	f	selection__res_partner__tz__africa/gaborone	base	ir.model.fields.selection
3125	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	227	f	selection__res_partner__tz__africa/harare	base	ir.model.fields.selection
3126	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	228	f	selection__res_partner__tz__africa/johannesburg	base	ir.model.fields.selection
3127	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	229	f	selection__res_partner__tz__africa/juba	base	ir.model.fields.selection
3128	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	230	f	selection__res_partner__tz__africa/kampala	base	ir.model.fields.selection
3129	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	231	f	selection__res_partner__tz__africa/khartoum	base	ir.model.fields.selection
3130	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	232	f	selection__res_partner__tz__africa/kigali	base	ir.model.fields.selection
3131	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	233	f	selection__res_partner__tz__africa/kinshasa	base	ir.model.fields.selection
3132	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	234	f	selection__res_partner__tz__africa/lagos	base	ir.model.fields.selection
3133	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	235	f	selection__res_partner__tz__africa/libreville	base	ir.model.fields.selection
3134	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	236	f	selection__res_partner__tz__africa/lome	base	ir.model.fields.selection
3135	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	237	f	selection__res_partner__tz__africa/luanda	base	ir.model.fields.selection
3136	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	238	f	selection__res_partner__tz__africa/lubumbashi	base	ir.model.fields.selection
3137	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	239	f	selection__res_partner__tz__africa/lusaka	base	ir.model.fields.selection
3138	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	240	f	selection__res_partner__tz__africa/malabo	base	ir.model.fields.selection
3139	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	241	f	selection__res_partner__tz__africa/maputo	base	ir.model.fields.selection
3140	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	242	f	selection__res_partner__tz__africa/maseru	base	ir.model.fields.selection
3141	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	243	f	selection__res_partner__tz__africa/mbabane	base	ir.model.fields.selection
3142	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	244	f	selection__res_partner__tz__africa/mogadishu	base	ir.model.fields.selection
3143	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	245	f	selection__res_partner__tz__africa/monrovia	base	ir.model.fields.selection
3144	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	246	f	selection__res_partner__tz__africa/nairobi	base	ir.model.fields.selection
3145	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	247	f	selection__res_partner__tz__africa/ndjamena	base	ir.model.fields.selection
3146	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	248	f	selection__res_partner__tz__africa/niamey	base	ir.model.fields.selection
3147	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	249	f	selection__res_partner__tz__africa/nouakchott	base	ir.model.fields.selection
3148	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	250	f	selection__res_partner__tz__africa/ouagadougou	base	ir.model.fields.selection
3149	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	251	f	selection__res_partner__tz__africa/porto-novo	base	ir.model.fields.selection
3150	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	252	f	selection__res_partner__tz__africa/sao_tome	base	ir.model.fields.selection
3151	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	253	f	selection__res_partner__tz__africa/timbuktu	base	ir.model.fields.selection
3152	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	254	f	selection__res_partner__tz__africa/tripoli	base	ir.model.fields.selection
3153	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	255	f	selection__res_partner__tz__africa/tunis	base	ir.model.fields.selection
3154	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	256	f	selection__res_partner__tz__africa/windhoek	base	ir.model.fields.selection
3155	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	257	f	selection__res_partner__tz__america/adak	base	ir.model.fields.selection
3156	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	258	f	selection__res_partner__tz__america/anchorage	base	ir.model.fields.selection
3157	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	259	f	selection__res_partner__tz__america/anguilla	base	ir.model.fields.selection
3158	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	260	f	selection__res_partner__tz__america/antigua	base	ir.model.fields.selection
3159	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	261	f	selection__res_partner__tz__america/araguaina	base	ir.model.fields.selection
3160	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	262	f	selection__res_partner__tz__america/argentina/buenos_aires	base	ir.model.fields.selection
3161	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	263	f	selection__res_partner__tz__america/argentina/catamarca	base	ir.model.fields.selection
3162	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	264	f	selection__res_partner__tz__america/argentina/comodrivadavia	base	ir.model.fields.selection
3163	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	265	f	selection__res_partner__tz__america/argentina/cordoba	base	ir.model.fields.selection
3164	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	266	f	selection__res_partner__tz__america/argentina/jujuy	base	ir.model.fields.selection
3165	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	267	f	selection__res_partner__tz__america/argentina/la_rioja	base	ir.model.fields.selection
3166	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	268	f	selection__res_partner__tz__america/argentina/mendoza	base	ir.model.fields.selection
3167	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	269	f	selection__res_partner__tz__america/argentina/rio_gallegos	base	ir.model.fields.selection
3168	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	270	f	selection__res_partner__tz__america/argentina/salta	base	ir.model.fields.selection
3169	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	271	f	selection__res_partner__tz__america/argentina/san_juan	base	ir.model.fields.selection
3170	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	272	f	selection__res_partner__tz__america/argentina/san_luis	base	ir.model.fields.selection
3171	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	273	f	selection__res_partner__tz__america/argentina/tucuman	base	ir.model.fields.selection
3172	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	274	f	selection__res_partner__tz__america/argentina/ushuaia	base	ir.model.fields.selection
3173	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	275	f	selection__res_partner__tz__america/aruba	base	ir.model.fields.selection
3174	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	276	f	selection__res_partner__tz__america/asuncion	base	ir.model.fields.selection
3175	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	277	f	selection__res_partner__tz__america/atikokan	base	ir.model.fields.selection
3176	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	278	f	selection__res_partner__tz__america/atka	base	ir.model.fields.selection
3177	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	279	f	selection__res_partner__tz__america/bahia	base	ir.model.fields.selection
3178	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	280	f	selection__res_partner__tz__america/bahia_banderas	base	ir.model.fields.selection
3179	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	281	f	selection__res_partner__tz__america/barbados	base	ir.model.fields.selection
3180	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	282	f	selection__res_partner__tz__america/belem	base	ir.model.fields.selection
3181	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	283	f	selection__res_partner__tz__america/belize	base	ir.model.fields.selection
3182	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	284	f	selection__res_partner__tz__america/blanc-sablon	base	ir.model.fields.selection
3183	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	285	f	selection__res_partner__tz__america/boa_vista	base	ir.model.fields.selection
3184	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	286	f	selection__res_partner__tz__america/bogota	base	ir.model.fields.selection
3185	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	287	f	selection__res_partner__tz__america/boise	base	ir.model.fields.selection
3186	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	288	f	selection__res_partner__tz__america/buenos_aires	base	ir.model.fields.selection
3187	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	289	f	selection__res_partner__tz__america/cambridge_bay	base	ir.model.fields.selection
3188	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	290	f	selection__res_partner__tz__america/campo_grande	base	ir.model.fields.selection
3189	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	291	f	selection__res_partner__tz__america/cancun	base	ir.model.fields.selection
3190	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	292	f	selection__res_partner__tz__america/caracas	base	ir.model.fields.selection
3191	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	293	f	selection__res_partner__tz__america/catamarca	base	ir.model.fields.selection
3192	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	294	f	selection__res_partner__tz__america/cayenne	base	ir.model.fields.selection
3193	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	295	f	selection__res_partner__tz__america/cayman	base	ir.model.fields.selection
3194	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	296	f	selection__res_partner__tz__america/chicago	base	ir.model.fields.selection
3195	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	297	f	selection__res_partner__tz__america/chihuahua	base	ir.model.fields.selection
3196	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	298	f	selection__res_partner__tz__america/ciudad_juarez	base	ir.model.fields.selection
3197	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	299	f	selection__res_partner__tz__america/coral_harbour	base	ir.model.fields.selection
3198	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	300	f	selection__res_partner__tz__america/cordoba	base	ir.model.fields.selection
3199	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	301	f	selection__res_partner__tz__america/costa_rica	base	ir.model.fields.selection
3200	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	302	f	selection__res_partner__tz__america/coyhaique	base	ir.model.fields.selection
3201	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	303	f	selection__res_partner__tz__america/creston	base	ir.model.fields.selection
3202	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	304	f	selection__res_partner__tz__america/cuiaba	base	ir.model.fields.selection
3203	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	305	f	selection__res_partner__tz__america/curacao	base	ir.model.fields.selection
3204	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	306	f	selection__res_partner__tz__america/danmarkshavn	base	ir.model.fields.selection
3205	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	307	f	selection__res_partner__tz__america/dawson	base	ir.model.fields.selection
3206	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	308	f	selection__res_partner__tz__america/dawson_creek	base	ir.model.fields.selection
3207	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	309	f	selection__res_partner__tz__america/denver	base	ir.model.fields.selection
3208	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	310	f	selection__res_partner__tz__america/detroit	base	ir.model.fields.selection
3209	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	311	f	selection__res_partner__tz__america/dominica	base	ir.model.fields.selection
3210	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	312	f	selection__res_partner__tz__america/edmonton	base	ir.model.fields.selection
3211	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	313	f	selection__res_partner__tz__america/eirunepe	base	ir.model.fields.selection
3212	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	314	f	selection__res_partner__tz__america/el_salvador	base	ir.model.fields.selection
3213	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	315	f	selection__res_partner__tz__america/ensenada	base	ir.model.fields.selection
3214	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	316	f	selection__res_partner__tz__america/fort_nelson	base	ir.model.fields.selection
3215	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	317	f	selection__res_partner__tz__america/fort_wayne	base	ir.model.fields.selection
3216	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	318	f	selection__res_partner__tz__america/fortaleza	base	ir.model.fields.selection
3217	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	319	f	selection__res_partner__tz__america/glace_bay	base	ir.model.fields.selection
3218	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	320	f	selection__res_partner__tz__america/godthab	base	ir.model.fields.selection
3219	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	321	f	selection__res_partner__tz__america/goose_bay	base	ir.model.fields.selection
3220	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	322	f	selection__res_partner__tz__america/grand_turk	base	ir.model.fields.selection
3221	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	323	f	selection__res_partner__tz__america/grenada	base	ir.model.fields.selection
3222	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	324	f	selection__res_partner__tz__america/guadeloupe	base	ir.model.fields.selection
3223	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	325	f	selection__res_partner__tz__america/guatemala	base	ir.model.fields.selection
3224	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	326	f	selection__res_partner__tz__america/guayaquil	base	ir.model.fields.selection
3225	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	327	f	selection__res_partner__tz__america/guyana	base	ir.model.fields.selection
3226	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	328	f	selection__res_partner__tz__america/halifax	base	ir.model.fields.selection
3227	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	329	f	selection__res_partner__tz__america/havana	base	ir.model.fields.selection
3228	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	330	f	selection__res_partner__tz__america/hermosillo	base	ir.model.fields.selection
3229	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	331	f	selection__res_partner__tz__america/indiana/indianapolis	base	ir.model.fields.selection
3230	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	332	f	selection__res_partner__tz__america/indiana/knox	base	ir.model.fields.selection
3231	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	333	f	selection__res_partner__tz__america/indiana/marengo	base	ir.model.fields.selection
3232	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	334	f	selection__res_partner__tz__america/indiana/petersburg	base	ir.model.fields.selection
3233	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	335	f	selection__res_partner__tz__america/indiana/tell_city	base	ir.model.fields.selection
3234	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	336	f	selection__res_partner__tz__america/indiana/vevay	base	ir.model.fields.selection
3235	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	337	f	selection__res_partner__tz__america/indiana/vincennes	base	ir.model.fields.selection
3236	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	338	f	selection__res_partner__tz__america/indiana/winamac	base	ir.model.fields.selection
3237	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	339	f	selection__res_partner__tz__america/indianapolis	base	ir.model.fields.selection
3238	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	340	f	selection__res_partner__tz__america/inuvik	base	ir.model.fields.selection
3239	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	341	f	selection__res_partner__tz__america/iqaluit	base	ir.model.fields.selection
3240	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	342	f	selection__res_partner__tz__america/jamaica	base	ir.model.fields.selection
3241	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	343	f	selection__res_partner__tz__america/jujuy	base	ir.model.fields.selection
3242	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	344	f	selection__res_partner__tz__america/juneau	base	ir.model.fields.selection
3243	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	345	f	selection__res_partner__tz__america/kentucky/louisville	base	ir.model.fields.selection
3244	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	346	f	selection__res_partner__tz__america/kentucky/monticello	base	ir.model.fields.selection
3245	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	347	f	selection__res_partner__tz__america/knox_in	base	ir.model.fields.selection
3246	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	348	f	selection__res_partner__tz__america/kralendijk	base	ir.model.fields.selection
3247	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	349	f	selection__res_partner__tz__america/la_paz	base	ir.model.fields.selection
3248	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	350	f	selection__res_partner__tz__america/lima	base	ir.model.fields.selection
3249	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	351	f	selection__res_partner__tz__america/los_angeles	base	ir.model.fields.selection
3250	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	352	f	selection__res_partner__tz__america/louisville	base	ir.model.fields.selection
3251	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	353	f	selection__res_partner__tz__america/lower_princes	base	ir.model.fields.selection
3252	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	354	f	selection__res_partner__tz__america/maceio	base	ir.model.fields.selection
3253	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	355	f	selection__res_partner__tz__america/managua	base	ir.model.fields.selection
3254	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	356	f	selection__res_partner__tz__america/manaus	base	ir.model.fields.selection
3255	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	357	f	selection__res_partner__tz__america/marigot	base	ir.model.fields.selection
3256	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	358	f	selection__res_partner__tz__america/martinique	base	ir.model.fields.selection
3257	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	359	f	selection__res_partner__tz__america/matamoros	base	ir.model.fields.selection
3258	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	360	f	selection__res_partner__tz__america/mazatlan	base	ir.model.fields.selection
3259	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	361	f	selection__res_partner__tz__america/mendoza	base	ir.model.fields.selection
3260	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	362	f	selection__res_partner__tz__america/menominee	base	ir.model.fields.selection
3261	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	363	f	selection__res_partner__tz__america/merida	base	ir.model.fields.selection
3262	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	364	f	selection__res_partner__tz__america/metlakatla	base	ir.model.fields.selection
3263	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	365	f	selection__res_partner__tz__america/mexico_city	base	ir.model.fields.selection
3264	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	366	f	selection__res_partner__tz__america/miquelon	base	ir.model.fields.selection
3265	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	367	f	selection__res_partner__tz__america/moncton	base	ir.model.fields.selection
3266	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	368	f	selection__res_partner__tz__america/monterrey	base	ir.model.fields.selection
3267	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	369	f	selection__res_partner__tz__america/montevideo	base	ir.model.fields.selection
3268	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	370	f	selection__res_partner__tz__america/montreal	base	ir.model.fields.selection
3269	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	371	f	selection__res_partner__tz__america/montserrat	base	ir.model.fields.selection
3270	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	372	f	selection__res_partner__tz__america/nassau	base	ir.model.fields.selection
3271	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	373	f	selection__res_partner__tz__america/new_york	base	ir.model.fields.selection
3272	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	374	f	selection__res_partner__tz__america/nipigon	base	ir.model.fields.selection
3273	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	375	f	selection__res_partner__tz__america/nome	base	ir.model.fields.selection
3274	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	376	f	selection__res_partner__tz__america/noronha	base	ir.model.fields.selection
3275	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	377	f	selection__res_partner__tz__america/north_dakota/beulah	base	ir.model.fields.selection
3276	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	378	f	selection__res_partner__tz__america/north_dakota/center	base	ir.model.fields.selection
3277	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	379	f	selection__res_partner__tz__america/north_dakota/new_salem	base	ir.model.fields.selection
3278	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	380	f	selection__res_partner__tz__america/nuuk	base	ir.model.fields.selection
3279	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	381	f	selection__res_partner__tz__america/ojinaga	base	ir.model.fields.selection
3280	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	382	f	selection__res_partner__tz__america/panama	base	ir.model.fields.selection
3281	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	383	f	selection__res_partner__tz__america/pangnirtung	base	ir.model.fields.selection
3282	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	384	f	selection__res_partner__tz__america/paramaribo	base	ir.model.fields.selection
3283	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	385	f	selection__res_partner__tz__america/phoenix	base	ir.model.fields.selection
3284	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	386	f	selection__res_partner__tz__america/port-au-prince	base	ir.model.fields.selection
3285	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	387	f	selection__res_partner__tz__america/port_of_spain	base	ir.model.fields.selection
3286	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	388	f	selection__res_partner__tz__america/porto_acre	base	ir.model.fields.selection
3287	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	389	f	selection__res_partner__tz__america/porto_velho	base	ir.model.fields.selection
3288	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	390	f	selection__res_partner__tz__america/puerto_rico	base	ir.model.fields.selection
3289	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	391	f	selection__res_partner__tz__america/punta_arenas	base	ir.model.fields.selection
3290	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	392	f	selection__res_partner__tz__america/rainy_river	base	ir.model.fields.selection
3291	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	393	f	selection__res_partner__tz__america/rankin_inlet	base	ir.model.fields.selection
3292	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	394	f	selection__res_partner__tz__america/recife	base	ir.model.fields.selection
3293	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	395	f	selection__res_partner__tz__america/regina	base	ir.model.fields.selection
3294	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	396	f	selection__res_partner__tz__america/resolute	base	ir.model.fields.selection
3295	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	397	f	selection__res_partner__tz__america/rio_branco	base	ir.model.fields.selection
3296	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	398	f	selection__res_partner__tz__america/rosario	base	ir.model.fields.selection
3297	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	399	f	selection__res_partner__tz__america/santa_isabel	base	ir.model.fields.selection
3298	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	400	f	selection__res_partner__tz__america/santarem	base	ir.model.fields.selection
3299	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	401	f	selection__res_partner__tz__america/santiago	base	ir.model.fields.selection
3300	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	402	f	selection__res_partner__tz__america/santo_domingo	base	ir.model.fields.selection
3301	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	403	f	selection__res_partner__tz__america/sao_paulo	base	ir.model.fields.selection
3302	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	404	f	selection__res_partner__tz__america/scoresbysund	base	ir.model.fields.selection
3303	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	405	f	selection__res_partner__tz__america/shiprock	base	ir.model.fields.selection
3304	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	406	f	selection__res_partner__tz__america/sitka	base	ir.model.fields.selection
3305	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	407	f	selection__res_partner__tz__america/st_barthelemy	base	ir.model.fields.selection
3306	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	408	f	selection__res_partner__tz__america/st_johns	base	ir.model.fields.selection
3307	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	409	f	selection__res_partner__tz__america/st_kitts	base	ir.model.fields.selection
3308	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	410	f	selection__res_partner__tz__america/st_lucia	base	ir.model.fields.selection
3309	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	411	f	selection__res_partner__tz__america/st_thomas	base	ir.model.fields.selection
3310	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	412	f	selection__res_partner__tz__america/st_vincent	base	ir.model.fields.selection
3311	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	413	f	selection__res_partner__tz__america/swift_current	base	ir.model.fields.selection
3312	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	414	f	selection__res_partner__tz__america/tegucigalpa	base	ir.model.fields.selection
3313	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	415	f	selection__res_partner__tz__america/thule	base	ir.model.fields.selection
3314	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	416	f	selection__res_partner__tz__america/thunder_bay	base	ir.model.fields.selection
3315	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	417	f	selection__res_partner__tz__america/tijuana	base	ir.model.fields.selection
3316	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	418	f	selection__res_partner__tz__america/toronto	base	ir.model.fields.selection
3317	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	419	f	selection__res_partner__tz__america/tortola	base	ir.model.fields.selection
3318	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	420	f	selection__res_partner__tz__america/vancouver	base	ir.model.fields.selection
3319	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	421	f	selection__res_partner__tz__america/virgin	base	ir.model.fields.selection
3320	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	422	f	selection__res_partner__tz__america/whitehorse	base	ir.model.fields.selection
3321	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	423	f	selection__res_partner__tz__america/winnipeg	base	ir.model.fields.selection
3322	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	424	f	selection__res_partner__tz__america/yakutat	base	ir.model.fields.selection
3323	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	425	f	selection__res_partner__tz__america/yellowknife	base	ir.model.fields.selection
3324	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	426	f	selection__res_partner__tz__antarctica/casey	base	ir.model.fields.selection
3325	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	427	f	selection__res_partner__tz__antarctica/davis	base	ir.model.fields.selection
3326	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	428	f	selection__res_partner__tz__antarctica/dumontdurville	base	ir.model.fields.selection
3327	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	429	f	selection__res_partner__tz__antarctica/macquarie	base	ir.model.fields.selection
3328	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	430	f	selection__res_partner__tz__antarctica/mawson	base	ir.model.fields.selection
3329	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	431	f	selection__res_partner__tz__antarctica/mcmurdo	base	ir.model.fields.selection
3330	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	432	f	selection__res_partner__tz__antarctica/palmer	base	ir.model.fields.selection
3331	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	433	f	selection__res_partner__tz__antarctica/rothera	base	ir.model.fields.selection
3332	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	434	f	selection__res_partner__tz__antarctica/south_pole	base	ir.model.fields.selection
3333	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	435	f	selection__res_partner__tz__antarctica/syowa	base	ir.model.fields.selection
3334	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	436	f	selection__res_partner__tz__antarctica/troll	base	ir.model.fields.selection
3335	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	437	f	selection__res_partner__tz__antarctica/vostok	base	ir.model.fields.selection
3336	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	438	f	selection__res_partner__tz__arctic/longyearbyen	base	ir.model.fields.selection
3337	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	439	f	selection__res_partner__tz__asia/aden	base	ir.model.fields.selection
3338	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	440	f	selection__res_partner__tz__asia/almaty	base	ir.model.fields.selection
3339	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	441	f	selection__res_partner__tz__asia/amman	base	ir.model.fields.selection
3340	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	442	f	selection__res_partner__tz__asia/anadyr	base	ir.model.fields.selection
3341	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	443	f	selection__res_partner__tz__asia/aqtau	base	ir.model.fields.selection
3342	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	444	f	selection__res_partner__tz__asia/aqtobe	base	ir.model.fields.selection
3343	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	445	f	selection__res_partner__tz__asia/ashgabat	base	ir.model.fields.selection
3344	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	446	f	selection__res_partner__tz__asia/ashkhabad	base	ir.model.fields.selection
3345	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	447	f	selection__res_partner__tz__asia/atyrau	base	ir.model.fields.selection
3346	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	448	f	selection__res_partner__tz__asia/baghdad	base	ir.model.fields.selection
3347	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	449	f	selection__res_partner__tz__asia/bahrain	base	ir.model.fields.selection
3348	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	450	f	selection__res_partner__tz__asia/baku	base	ir.model.fields.selection
3349	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	451	f	selection__res_partner__tz__asia/bangkok	base	ir.model.fields.selection
3350	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	452	f	selection__res_partner__tz__asia/barnaul	base	ir.model.fields.selection
3351	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	453	f	selection__res_partner__tz__asia/beirut	base	ir.model.fields.selection
3352	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	454	f	selection__res_partner__tz__asia/bishkek	base	ir.model.fields.selection
3353	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	455	f	selection__res_partner__tz__asia/brunei	base	ir.model.fields.selection
3354	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	456	f	selection__res_partner__tz__asia/calcutta	base	ir.model.fields.selection
3355	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	457	f	selection__res_partner__tz__asia/chita	base	ir.model.fields.selection
3356	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	458	f	selection__res_partner__tz__asia/choibalsan	base	ir.model.fields.selection
3357	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	459	f	selection__res_partner__tz__asia/chongqing	base	ir.model.fields.selection
3358	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	460	f	selection__res_partner__tz__asia/chungking	base	ir.model.fields.selection
3359	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	461	f	selection__res_partner__tz__asia/colombo	base	ir.model.fields.selection
3360	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	462	f	selection__res_partner__tz__asia/dacca	base	ir.model.fields.selection
3361	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	463	f	selection__res_partner__tz__asia/damascus	base	ir.model.fields.selection
3362	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	464	f	selection__res_partner__tz__asia/dhaka	base	ir.model.fields.selection
3363	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	465	f	selection__res_partner__tz__asia/dili	base	ir.model.fields.selection
3364	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	466	f	selection__res_partner__tz__asia/dubai	base	ir.model.fields.selection
3365	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	467	f	selection__res_partner__tz__asia/dushanbe	base	ir.model.fields.selection
3366	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	468	f	selection__res_partner__tz__asia/famagusta	base	ir.model.fields.selection
3367	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	469	f	selection__res_partner__tz__asia/gaza	base	ir.model.fields.selection
3368	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	470	f	selection__res_partner__tz__asia/harbin	base	ir.model.fields.selection
3369	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	471	f	selection__res_partner__tz__asia/hebron	base	ir.model.fields.selection
3370	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	472	f	selection__res_partner__tz__asia/ho_chi_minh	base	ir.model.fields.selection
3371	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	473	f	selection__res_partner__tz__asia/hong_kong	base	ir.model.fields.selection
3372	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	474	f	selection__res_partner__tz__asia/hovd	base	ir.model.fields.selection
3373	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	475	f	selection__res_partner__tz__asia/irkutsk	base	ir.model.fields.selection
3374	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	476	f	selection__res_partner__tz__asia/istanbul	base	ir.model.fields.selection
3375	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	477	f	selection__res_partner__tz__asia/jakarta	base	ir.model.fields.selection
3376	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	478	f	selection__res_partner__tz__asia/jayapura	base	ir.model.fields.selection
3377	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	479	f	selection__res_partner__tz__asia/jerusalem	base	ir.model.fields.selection
3378	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	480	f	selection__res_partner__tz__asia/kabul	base	ir.model.fields.selection
3379	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	481	f	selection__res_partner__tz__asia/kamchatka	base	ir.model.fields.selection
3380	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	482	f	selection__res_partner__tz__asia/karachi	base	ir.model.fields.selection
3381	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	483	f	selection__res_partner__tz__asia/kashgar	base	ir.model.fields.selection
3382	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	484	f	selection__res_partner__tz__asia/kathmandu	base	ir.model.fields.selection
3383	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	485	f	selection__res_partner__tz__asia/katmandu	base	ir.model.fields.selection
3384	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	486	f	selection__res_partner__tz__asia/khandyga	base	ir.model.fields.selection
3385	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	487	f	selection__res_partner__tz__asia/kolkata	base	ir.model.fields.selection
3386	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	488	f	selection__res_partner__tz__asia/krasnoyarsk	base	ir.model.fields.selection
3387	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	489	f	selection__res_partner__tz__asia/kuala_lumpur	base	ir.model.fields.selection
3388	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	490	f	selection__res_partner__tz__asia/kuching	base	ir.model.fields.selection
3389	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	491	f	selection__res_partner__tz__asia/kuwait	base	ir.model.fields.selection
3390	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	492	f	selection__res_partner__tz__asia/macao	base	ir.model.fields.selection
3391	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	493	f	selection__res_partner__tz__asia/macau	base	ir.model.fields.selection
3392	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	494	f	selection__res_partner__tz__asia/magadan	base	ir.model.fields.selection
3393	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	495	f	selection__res_partner__tz__asia/makassar	base	ir.model.fields.selection
3394	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	496	f	selection__res_partner__tz__asia/manila	base	ir.model.fields.selection
3395	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	497	f	selection__res_partner__tz__asia/muscat	base	ir.model.fields.selection
3396	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	498	f	selection__res_partner__tz__asia/nicosia	base	ir.model.fields.selection
3397	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	499	f	selection__res_partner__tz__asia/novokuznetsk	base	ir.model.fields.selection
3398	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	500	f	selection__res_partner__tz__asia/novosibirsk	base	ir.model.fields.selection
3399	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	501	f	selection__res_partner__tz__asia/omsk	base	ir.model.fields.selection
3400	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	502	f	selection__res_partner__tz__asia/oral	base	ir.model.fields.selection
3401	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	503	f	selection__res_partner__tz__asia/phnom_penh	base	ir.model.fields.selection
3402	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	504	f	selection__res_partner__tz__asia/pontianak	base	ir.model.fields.selection
3403	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	505	f	selection__res_partner__tz__asia/pyongyang	base	ir.model.fields.selection
3404	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	506	f	selection__res_partner__tz__asia/qatar	base	ir.model.fields.selection
3405	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	507	f	selection__res_partner__tz__asia/qostanay	base	ir.model.fields.selection
3406	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	508	f	selection__res_partner__tz__asia/qyzylorda	base	ir.model.fields.selection
3407	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	509	f	selection__res_partner__tz__asia/rangoon	base	ir.model.fields.selection
3408	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	510	f	selection__res_partner__tz__asia/riyadh	base	ir.model.fields.selection
3409	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	511	f	selection__res_partner__tz__asia/saigon	base	ir.model.fields.selection
3410	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	512	f	selection__res_partner__tz__asia/sakhalin	base	ir.model.fields.selection
3411	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	513	f	selection__res_partner__tz__asia/samarkand	base	ir.model.fields.selection
3412	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	514	f	selection__res_partner__tz__asia/seoul	base	ir.model.fields.selection
3413	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	515	f	selection__res_partner__tz__asia/shanghai	base	ir.model.fields.selection
3414	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	516	f	selection__res_partner__tz__asia/singapore	base	ir.model.fields.selection
3415	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	517	f	selection__res_partner__tz__asia/srednekolymsk	base	ir.model.fields.selection
3416	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	518	f	selection__res_partner__tz__asia/taipei	base	ir.model.fields.selection
3417	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	519	f	selection__res_partner__tz__asia/tashkent	base	ir.model.fields.selection
3418	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	520	f	selection__res_partner__tz__asia/tbilisi	base	ir.model.fields.selection
3419	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	521	f	selection__res_partner__tz__asia/tehran	base	ir.model.fields.selection
3420	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	522	f	selection__res_partner__tz__asia/tel_aviv	base	ir.model.fields.selection
3421	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	523	f	selection__res_partner__tz__asia/thimbu	base	ir.model.fields.selection
3422	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	524	f	selection__res_partner__tz__asia/thimphu	base	ir.model.fields.selection
3423	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	525	f	selection__res_partner__tz__asia/tokyo	base	ir.model.fields.selection
3424	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	526	f	selection__res_partner__tz__asia/tomsk	base	ir.model.fields.selection
3425	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	527	f	selection__res_partner__tz__asia/ujung_pandang	base	ir.model.fields.selection
3426	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	528	f	selection__res_partner__tz__asia/ulaanbaatar	base	ir.model.fields.selection
3427	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	529	f	selection__res_partner__tz__asia/ulan_bator	base	ir.model.fields.selection
3428	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	530	f	selection__res_partner__tz__asia/urumqi	base	ir.model.fields.selection
3429	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	531	f	selection__res_partner__tz__asia/ust-nera	base	ir.model.fields.selection
3430	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	532	f	selection__res_partner__tz__asia/vientiane	base	ir.model.fields.selection
3431	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	533	f	selection__res_partner__tz__asia/vladivostok	base	ir.model.fields.selection
3432	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	534	f	selection__res_partner__tz__asia/yakutsk	base	ir.model.fields.selection
3433	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	535	f	selection__res_partner__tz__asia/yangon	base	ir.model.fields.selection
3434	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	536	f	selection__res_partner__tz__asia/yekaterinburg	base	ir.model.fields.selection
3435	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	537	f	selection__res_partner__tz__asia/yerevan	base	ir.model.fields.selection
3436	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	538	f	selection__res_partner__tz__atlantic/azores	base	ir.model.fields.selection
3437	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	539	f	selection__res_partner__tz__atlantic/bermuda	base	ir.model.fields.selection
3438	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	540	f	selection__res_partner__tz__atlantic/canary	base	ir.model.fields.selection
3439	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	541	f	selection__res_partner__tz__atlantic/cape_verde	base	ir.model.fields.selection
3440	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	542	f	selection__res_partner__tz__atlantic/faeroe	base	ir.model.fields.selection
3441	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	543	f	selection__res_partner__tz__atlantic/faroe	base	ir.model.fields.selection
3442	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	544	f	selection__res_partner__tz__atlantic/jan_mayen	base	ir.model.fields.selection
3443	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	545	f	selection__res_partner__tz__atlantic/madeira	base	ir.model.fields.selection
3444	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	546	f	selection__res_partner__tz__atlantic/reykjavik	base	ir.model.fields.selection
3445	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	547	f	selection__res_partner__tz__atlantic/south_georgia	base	ir.model.fields.selection
3446	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	548	f	selection__res_partner__tz__atlantic/st_helena	base	ir.model.fields.selection
3447	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	549	f	selection__res_partner__tz__atlantic/stanley	base	ir.model.fields.selection
3448	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	550	f	selection__res_partner__tz__australia/act	base	ir.model.fields.selection
3449	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	551	f	selection__res_partner__tz__australia/adelaide	base	ir.model.fields.selection
3450	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	552	f	selection__res_partner__tz__australia/brisbane	base	ir.model.fields.selection
3451	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	553	f	selection__res_partner__tz__australia/broken_hill	base	ir.model.fields.selection
3452	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	554	f	selection__res_partner__tz__australia/canberra	base	ir.model.fields.selection
3453	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	555	f	selection__res_partner__tz__australia/currie	base	ir.model.fields.selection
3454	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	556	f	selection__res_partner__tz__australia/darwin	base	ir.model.fields.selection
3455	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	557	f	selection__res_partner__tz__australia/eucla	base	ir.model.fields.selection
3456	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	558	f	selection__res_partner__tz__australia/hobart	base	ir.model.fields.selection
3457	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	559	f	selection__res_partner__tz__australia/lhi	base	ir.model.fields.selection
3458	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	560	f	selection__res_partner__tz__australia/lindeman	base	ir.model.fields.selection
3459	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	561	f	selection__res_partner__tz__australia/lord_howe	base	ir.model.fields.selection
3460	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	562	f	selection__res_partner__tz__australia/melbourne	base	ir.model.fields.selection
3461	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	563	f	selection__res_partner__tz__australia/nsw	base	ir.model.fields.selection
3462	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	564	f	selection__res_partner__tz__australia/north	base	ir.model.fields.selection
3463	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	565	f	selection__res_partner__tz__australia/perth	base	ir.model.fields.selection
3464	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	566	f	selection__res_partner__tz__australia/queensland	base	ir.model.fields.selection
3465	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	567	f	selection__res_partner__tz__australia/south	base	ir.model.fields.selection
3581	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	683	f	selection__res_partner__tz__japan	base	ir.model.fields.selection
3466	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	568	f	selection__res_partner__tz__australia/sydney	base	ir.model.fields.selection
3467	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	569	f	selection__res_partner__tz__australia/tasmania	base	ir.model.fields.selection
3468	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	570	f	selection__res_partner__tz__australia/victoria	base	ir.model.fields.selection
3469	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	571	f	selection__res_partner__tz__australia/west	base	ir.model.fields.selection
3470	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	572	f	selection__res_partner__tz__australia/yancowinna	base	ir.model.fields.selection
3471	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	573	f	selection__res_partner__tz__brazil/acre	base	ir.model.fields.selection
3472	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	574	f	selection__res_partner__tz__brazil/denoronha	base	ir.model.fields.selection
3473	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	575	f	selection__res_partner__tz__brazil/east	base	ir.model.fields.selection
3474	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	576	f	selection__res_partner__tz__brazil/west	base	ir.model.fields.selection
3475	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	577	f	selection__res_partner__tz__cet	base	ir.model.fields.selection
3476	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	578	f	selection__res_partner__tz__cst6cdt	base	ir.model.fields.selection
3477	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	579	f	selection__res_partner__tz__canada/atlantic	base	ir.model.fields.selection
3478	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	580	f	selection__res_partner__tz__canada/central	base	ir.model.fields.selection
3479	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	581	f	selection__res_partner__tz__canada/eastern	base	ir.model.fields.selection
3480	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	582	f	selection__res_partner__tz__canada/mountain	base	ir.model.fields.selection
3481	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	583	f	selection__res_partner__tz__canada/newfoundland	base	ir.model.fields.selection
3482	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	584	f	selection__res_partner__tz__canada/pacific	base	ir.model.fields.selection
3483	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	585	f	selection__res_partner__tz__canada/saskatchewan	base	ir.model.fields.selection
3484	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	586	f	selection__res_partner__tz__canada/yukon	base	ir.model.fields.selection
3485	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	587	f	selection__res_partner__tz__chile/continental	base	ir.model.fields.selection
3486	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	588	f	selection__res_partner__tz__chile/easterisland	base	ir.model.fields.selection
3487	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	589	f	selection__res_partner__tz__cuba	base	ir.model.fields.selection
3488	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	590	f	selection__res_partner__tz__eet	base	ir.model.fields.selection
3489	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	591	f	selection__res_partner__tz__est	base	ir.model.fields.selection
3490	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	592	f	selection__res_partner__tz__est5edt	base	ir.model.fields.selection
3491	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	593	f	selection__res_partner__tz__egypt	base	ir.model.fields.selection
3492	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	594	f	selection__res_partner__tz__eire	base	ir.model.fields.selection
3493	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	595	f	selection__res_partner__tz__europe/amsterdam	base	ir.model.fields.selection
3494	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	596	f	selection__res_partner__tz__europe/andorra	base	ir.model.fields.selection
3495	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	597	f	selection__res_partner__tz__europe/astrakhan	base	ir.model.fields.selection
3496	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	598	f	selection__res_partner__tz__europe/athens	base	ir.model.fields.selection
3497	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	599	f	selection__res_partner__tz__europe/belfast	base	ir.model.fields.selection
3498	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	600	f	selection__res_partner__tz__europe/belgrade	base	ir.model.fields.selection
3499	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	601	f	selection__res_partner__tz__europe/berlin	base	ir.model.fields.selection
3500	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	602	f	selection__res_partner__tz__europe/bratislava	base	ir.model.fields.selection
3501	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	603	f	selection__res_partner__tz__europe/brussels	base	ir.model.fields.selection
3502	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	604	f	selection__res_partner__tz__europe/bucharest	base	ir.model.fields.selection
3503	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	605	f	selection__res_partner__tz__europe/budapest	base	ir.model.fields.selection
3504	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	606	f	selection__res_partner__tz__europe/busingen	base	ir.model.fields.selection
3505	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	607	f	selection__res_partner__tz__europe/chisinau	base	ir.model.fields.selection
3506	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	608	f	selection__res_partner__tz__europe/copenhagen	base	ir.model.fields.selection
3507	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	609	f	selection__res_partner__tz__europe/dublin	base	ir.model.fields.selection
3508	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	610	f	selection__res_partner__tz__europe/gibraltar	base	ir.model.fields.selection
3509	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	611	f	selection__res_partner__tz__europe/guernsey	base	ir.model.fields.selection
3510	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	612	f	selection__res_partner__tz__europe/helsinki	base	ir.model.fields.selection
3511	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	613	f	selection__res_partner__tz__europe/isle_of_man	base	ir.model.fields.selection
3512	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	614	f	selection__res_partner__tz__europe/istanbul	base	ir.model.fields.selection
3513	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	615	f	selection__res_partner__tz__europe/jersey	base	ir.model.fields.selection
3514	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	616	f	selection__res_partner__tz__europe/kaliningrad	base	ir.model.fields.selection
3515	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	617	f	selection__res_partner__tz__europe/kiev	base	ir.model.fields.selection
3516	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	618	f	selection__res_partner__tz__europe/kirov	base	ir.model.fields.selection
3517	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	619	f	selection__res_partner__tz__europe/kyiv	base	ir.model.fields.selection
3518	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	620	f	selection__res_partner__tz__europe/lisbon	base	ir.model.fields.selection
3519	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	621	f	selection__res_partner__tz__europe/ljubljana	base	ir.model.fields.selection
3520	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	622	f	selection__res_partner__tz__europe/london	base	ir.model.fields.selection
3521	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	623	f	selection__res_partner__tz__europe/luxembourg	base	ir.model.fields.selection
3522	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	624	f	selection__res_partner__tz__europe/madrid	base	ir.model.fields.selection
3907	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	86	f	lang_th	base	res.lang
3523	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	625	f	selection__res_partner__tz__europe/malta	base	ir.model.fields.selection
3524	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	626	f	selection__res_partner__tz__europe/mariehamn	base	ir.model.fields.selection
3525	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	627	f	selection__res_partner__tz__europe/minsk	base	ir.model.fields.selection
3526	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	628	f	selection__res_partner__tz__europe/monaco	base	ir.model.fields.selection
3527	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	629	f	selection__res_partner__tz__europe/moscow	base	ir.model.fields.selection
3528	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	630	f	selection__res_partner__tz__europe/nicosia	base	ir.model.fields.selection
3529	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	631	f	selection__res_partner__tz__europe/oslo	base	ir.model.fields.selection
3530	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	632	f	selection__res_partner__tz__europe/paris	base	ir.model.fields.selection
3531	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	633	f	selection__res_partner__tz__europe/podgorica	base	ir.model.fields.selection
3532	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	634	f	selection__res_partner__tz__europe/prague	base	ir.model.fields.selection
3533	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	635	f	selection__res_partner__tz__europe/riga	base	ir.model.fields.selection
3534	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	636	f	selection__res_partner__tz__europe/rome	base	ir.model.fields.selection
3535	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	637	f	selection__res_partner__tz__europe/samara	base	ir.model.fields.selection
3536	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	638	f	selection__res_partner__tz__europe/san_marino	base	ir.model.fields.selection
3537	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	639	f	selection__res_partner__tz__europe/sarajevo	base	ir.model.fields.selection
3538	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	640	f	selection__res_partner__tz__europe/saratov	base	ir.model.fields.selection
3539	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	641	f	selection__res_partner__tz__europe/simferopol	base	ir.model.fields.selection
3540	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	642	f	selection__res_partner__tz__europe/skopje	base	ir.model.fields.selection
3541	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	643	f	selection__res_partner__tz__europe/sofia	base	ir.model.fields.selection
3542	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	644	f	selection__res_partner__tz__europe/stockholm	base	ir.model.fields.selection
3543	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	645	f	selection__res_partner__tz__europe/tallinn	base	ir.model.fields.selection
3544	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	646	f	selection__res_partner__tz__europe/tirane	base	ir.model.fields.selection
3545	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	647	f	selection__res_partner__tz__europe/tiraspol	base	ir.model.fields.selection
3546	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	648	f	selection__res_partner__tz__europe/ulyanovsk	base	ir.model.fields.selection
3547	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	649	f	selection__res_partner__tz__europe/uzhgorod	base	ir.model.fields.selection
3548	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	650	f	selection__res_partner__tz__europe/vaduz	base	ir.model.fields.selection
3549	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	651	f	selection__res_partner__tz__europe/vatican	base	ir.model.fields.selection
3550	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	652	f	selection__res_partner__tz__europe/vienna	base	ir.model.fields.selection
3551	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	653	f	selection__res_partner__tz__europe/vilnius	base	ir.model.fields.selection
3552	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	654	f	selection__res_partner__tz__europe/volgograd	base	ir.model.fields.selection
3553	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	655	f	selection__res_partner__tz__europe/warsaw	base	ir.model.fields.selection
3554	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	656	f	selection__res_partner__tz__europe/zagreb	base	ir.model.fields.selection
3555	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	657	f	selection__res_partner__tz__europe/zaporozhye	base	ir.model.fields.selection
3556	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	658	f	selection__res_partner__tz__europe/zurich	base	ir.model.fields.selection
3557	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	659	f	selection__res_partner__tz__gb	base	ir.model.fields.selection
3558	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	660	f	selection__res_partner__tz__gb-eire	base	ir.model.fields.selection
3559	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	661	f	selection__res_partner__tz__gmt	base	ir.model.fields.selection
3560	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	662	f	selection__res_partner__tz__gmt+0	base	ir.model.fields.selection
3561	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	663	f	selection__res_partner__tz__gmt-0	base	ir.model.fields.selection
3562	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	664	f	selection__res_partner__tz__gmt0	base	ir.model.fields.selection
3563	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	665	f	selection__res_partner__tz__greenwich	base	ir.model.fields.selection
3564	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	666	f	selection__res_partner__tz__hst	base	ir.model.fields.selection
3565	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	667	f	selection__res_partner__tz__hongkong	base	ir.model.fields.selection
3566	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	668	f	selection__res_partner__tz__iceland	base	ir.model.fields.selection
3567	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	669	f	selection__res_partner__tz__indian/antananarivo	base	ir.model.fields.selection
3568	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	670	f	selection__res_partner__tz__indian/chagos	base	ir.model.fields.selection
3569	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	671	f	selection__res_partner__tz__indian/christmas	base	ir.model.fields.selection
3570	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	672	f	selection__res_partner__tz__indian/cocos	base	ir.model.fields.selection
3571	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	673	f	selection__res_partner__tz__indian/comoro	base	ir.model.fields.selection
3572	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	674	f	selection__res_partner__tz__indian/kerguelen	base	ir.model.fields.selection
3573	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	675	f	selection__res_partner__tz__indian/mahe	base	ir.model.fields.selection
3574	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	676	f	selection__res_partner__tz__indian/maldives	base	ir.model.fields.selection
3575	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	677	f	selection__res_partner__tz__indian/mauritius	base	ir.model.fields.selection
3576	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	678	f	selection__res_partner__tz__indian/mayotte	base	ir.model.fields.selection
3577	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	679	f	selection__res_partner__tz__indian/reunion	base	ir.model.fields.selection
3578	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	680	f	selection__res_partner__tz__iran	base	ir.model.fields.selection
3579	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	681	f	selection__res_partner__tz__israel	base	ir.model.fields.selection
3580	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	682	f	selection__res_partner__tz__jamaica	base	ir.model.fields.selection
3582	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	684	f	selection__res_partner__tz__kwajalein	base	ir.model.fields.selection
3583	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	685	f	selection__res_partner__tz__libya	base	ir.model.fields.selection
3584	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	686	f	selection__res_partner__tz__met	base	ir.model.fields.selection
3585	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	687	f	selection__res_partner__tz__mst	base	ir.model.fields.selection
3586	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	688	f	selection__res_partner__tz__mst7mdt	base	ir.model.fields.selection
3587	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	689	f	selection__res_partner__tz__mexico/bajanorte	base	ir.model.fields.selection
3588	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	690	f	selection__res_partner__tz__mexico/bajasur	base	ir.model.fields.selection
3589	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	691	f	selection__res_partner__tz__mexico/general	base	ir.model.fields.selection
3590	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	692	f	selection__res_partner__tz__nz	base	ir.model.fields.selection
3591	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	693	f	selection__res_partner__tz__nz-chat	base	ir.model.fields.selection
3592	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	694	f	selection__res_partner__tz__navajo	base	ir.model.fields.selection
3593	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	695	f	selection__res_partner__tz__prc	base	ir.model.fields.selection
3594	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	696	f	selection__res_partner__tz__pst8pdt	base	ir.model.fields.selection
3595	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	697	f	selection__res_partner__tz__pacific/apia	base	ir.model.fields.selection
3596	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	698	f	selection__res_partner__tz__pacific/auckland	base	ir.model.fields.selection
3597	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	699	f	selection__res_partner__tz__pacific/bougainville	base	ir.model.fields.selection
3598	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	700	f	selection__res_partner__tz__pacific/chatham	base	ir.model.fields.selection
3599	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	701	f	selection__res_partner__tz__pacific/chuuk	base	ir.model.fields.selection
3600	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	702	f	selection__res_partner__tz__pacific/easter	base	ir.model.fields.selection
3601	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	703	f	selection__res_partner__tz__pacific/efate	base	ir.model.fields.selection
3602	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	704	f	selection__res_partner__tz__pacific/enderbury	base	ir.model.fields.selection
3603	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	705	f	selection__res_partner__tz__pacific/fakaofo	base	ir.model.fields.selection
3604	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	706	f	selection__res_partner__tz__pacific/fiji	base	ir.model.fields.selection
3605	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	707	f	selection__res_partner__tz__pacific/funafuti	base	ir.model.fields.selection
3606	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	708	f	selection__res_partner__tz__pacific/galapagos	base	ir.model.fields.selection
3607	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	709	f	selection__res_partner__tz__pacific/gambier	base	ir.model.fields.selection
3608	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	710	f	selection__res_partner__tz__pacific/guadalcanal	base	ir.model.fields.selection
3609	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	711	f	selection__res_partner__tz__pacific/guam	base	ir.model.fields.selection
3610	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	712	f	selection__res_partner__tz__pacific/honolulu	base	ir.model.fields.selection
3611	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	713	f	selection__res_partner__tz__pacific/johnston	base	ir.model.fields.selection
3612	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	714	f	selection__res_partner__tz__pacific/kanton	base	ir.model.fields.selection
3613	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	715	f	selection__res_partner__tz__pacific/kiritimati	base	ir.model.fields.selection
3614	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	716	f	selection__res_partner__tz__pacific/kosrae	base	ir.model.fields.selection
3615	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	717	f	selection__res_partner__tz__pacific/kwajalein	base	ir.model.fields.selection
3616	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	718	f	selection__res_partner__tz__pacific/majuro	base	ir.model.fields.selection
3617	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	719	f	selection__res_partner__tz__pacific/marquesas	base	ir.model.fields.selection
3618	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	720	f	selection__res_partner__tz__pacific/midway	base	ir.model.fields.selection
3619	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	721	f	selection__res_partner__tz__pacific/nauru	base	ir.model.fields.selection
3620	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	722	f	selection__res_partner__tz__pacific/niue	base	ir.model.fields.selection
3621	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	723	f	selection__res_partner__tz__pacific/norfolk	base	ir.model.fields.selection
3622	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	724	f	selection__res_partner__tz__pacific/noumea	base	ir.model.fields.selection
3623	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	725	f	selection__res_partner__tz__pacific/pago_pago	base	ir.model.fields.selection
3624	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	726	f	selection__res_partner__tz__pacific/palau	base	ir.model.fields.selection
3625	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	727	f	selection__res_partner__tz__pacific/pitcairn	base	ir.model.fields.selection
3626	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	728	f	selection__res_partner__tz__pacific/pohnpei	base	ir.model.fields.selection
3627	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	729	f	selection__res_partner__tz__pacific/ponape	base	ir.model.fields.selection
3628	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	730	f	selection__res_partner__tz__pacific/port_moresby	base	ir.model.fields.selection
3629	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	731	f	selection__res_partner__tz__pacific/rarotonga	base	ir.model.fields.selection
3630	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	732	f	selection__res_partner__tz__pacific/saipan	base	ir.model.fields.selection
3631	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	733	f	selection__res_partner__tz__pacific/samoa	base	ir.model.fields.selection
3632	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	734	f	selection__res_partner__tz__pacific/tahiti	base	ir.model.fields.selection
3633	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	735	f	selection__res_partner__tz__pacific/tarawa	base	ir.model.fields.selection
3634	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	736	f	selection__res_partner__tz__pacific/tongatapu	base	ir.model.fields.selection
3635	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	737	f	selection__res_partner__tz__pacific/truk	base	ir.model.fields.selection
3636	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	738	f	selection__res_partner__tz__pacific/wake	base	ir.model.fields.selection
3637	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	739	f	selection__res_partner__tz__pacific/wallis	base	ir.model.fields.selection
3638	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	740	f	selection__res_partner__tz__pacific/yap	base	ir.model.fields.selection
3908	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	87	f	lang_tl	base	res.lang
3639	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	741	f	selection__res_partner__tz__poland	base	ir.model.fields.selection
3640	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	742	f	selection__res_partner__tz__portugal	base	ir.model.fields.selection
3641	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	743	f	selection__res_partner__tz__roc	base	ir.model.fields.selection
3642	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	744	f	selection__res_partner__tz__rok	base	ir.model.fields.selection
3643	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	745	f	selection__res_partner__tz__singapore	base	ir.model.fields.selection
3644	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	746	f	selection__res_partner__tz__turkey	base	ir.model.fields.selection
3645	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	747	f	selection__res_partner__tz__uct	base	ir.model.fields.selection
3646	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	748	f	selection__res_partner__tz__us/alaska	base	ir.model.fields.selection
3647	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	749	f	selection__res_partner__tz__us/aleutian	base	ir.model.fields.selection
3648	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	750	f	selection__res_partner__tz__us/arizona	base	ir.model.fields.selection
3649	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	751	f	selection__res_partner__tz__us/central	base	ir.model.fields.selection
3650	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	752	f	selection__res_partner__tz__us/east-indiana	base	ir.model.fields.selection
3651	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	753	f	selection__res_partner__tz__us/eastern	base	ir.model.fields.selection
3652	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	754	f	selection__res_partner__tz__us/hawaii	base	ir.model.fields.selection
3653	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	755	f	selection__res_partner__tz__us/indiana-starke	base	ir.model.fields.selection
3654	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	756	f	selection__res_partner__tz__us/michigan	base	ir.model.fields.selection
3655	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	757	f	selection__res_partner__tz__us/mountain	base	ir.model.fields.selection
3656	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	758	f	selection__res_partner__tz__us/pacific	base	ir.model.fields.selection
3657	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	759	f	selection__res_partner__tz__us/samoa	base	ir.model.fields.selection
3658	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	760	f	selection__res_partner__tz__utc	base	ir.model.fields.selection
3659	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	761	f	selection__res_partner__tz__universal	base	ir.model.fields.selection
3660	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	762	f	selection__res_partner__tz__w-su	base	ir.model.fields.selection
3661	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	763	f	selection__res_partner__tz__wet	base	ir.model.fields.selection
3662	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	764	f	selection__res_partner__tz__zulu	base	ir.model.fields.selection
3663	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	765	f	selection__res_partner__tz__etc/gmt	base	ir.model.fields.selection
3664	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	766	f	selection__res_partner__tz__etc/gmt+0	base	ir.model.fields.selection
3665	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	767	f	selection__res_partner__tz__etc/gmt+1	base	ir.model.fields.selection
3666	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	768	f	selection__res_partner__tz__etc/gmt+10	base	ir.model.fields.selection
3667	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	769	f	selection__res_partner__tz__etc/gmt+11	base	ir.model.fields.selection
3668	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	770	f	selection__res_partner__tz__etc/gmt+12	base	ir.model.fields.selection
3669	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	771	f	selection__res_partner__tz__etc/gmt+2	base	ir.model.fields.selection
3670	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	772	f	selection__res_partner__tz__etc/gmt+3	base	ir.model.fields.selection
3671	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	773	f	selection__res_partner__tz__etc/gmt+4	base	ir.model.fields.selection
3672	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	774	f	selection__res_partner__tz__etc/gmt+5	base	ir.model.fields.selection
3673	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	775	f	selection__res_partner__tz__etc/gmt+6	base	ir.model.fields.selection
3674	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	776	f	selection__res_partner__tz__etc/gmt+7	base	ir.model.fields.selection
3675	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	777	f	selection__res_partner__tz__etc/gmt+8	base	ir.model.fields.selection
3676	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	778	f	selection__res_partner__tz__etc/gmt+9	base	ir.model.fields.selection
3677	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	779	f	selection__res_partner__tz__etc/gmt-0	base	ir.model.fields.selection
3678	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	780	f	selection__res_partner__tz__etc/gmt-1	base	ir.model.fields.selection
3679	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	781	f	selection__res_partner__tz__etc/gmt-10	base	ir.model.fields.selection
3680	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	782	f	selection__res_partner__tz__etc/gmt-11	base	ir.model.fields.selection
3681	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	783	f	selection__res_partner__tz__etc/gmt-12	base	ir.model.fields.selection
3682	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	784	f	selection__res_partner__tz__etc/gmt-13	base	ir.model.fields.selection
3683	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	785	f	selection__res_partner__tz__etc/gmt-14	base	ir.model.fields.selection
3684	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	786	f	selection__res_partner__tz__etc/gmt-2	base	ir.model.fields.selection
3685	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	787	f	selection__res_partner__tz__etc/gmt-3	base	ir.model.fields.selection
3686	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	788	f	selection__res_partner__tz__etc/gmt-4	base	ir.model.fields.selection
3687	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	789	f	selection__res_partner__tz__etc/gmt-5	base	ir.model.fields.selection
3688	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	790	f	selection__res_partner__tz__etc/gmt-6	base	ir.model.fields.selection
3689	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	791	f	selection__res_partner__tz__etc/gmt-7	base	ir.model.fields.selection
3690	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	792	f	selection__res_partner__tz__etc/gmt-8	base	ir.model.fields.selection
3691	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	793	f	selection__res_partner__tz__etc/gmt-9	base	ir.model.fields.selection
3692	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	794	f	selection__res_partner__tz__etc/gmt0	base	ir.model.fields.selection
3693	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	795	f	selection__res_partner__tz__etc/greenwich	base	ir.model.fields.selection
3694	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	796	f	selection__res_partner__tz__etc/uct	base	ir.model.fields.selection
3695	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	797	f	selection__res_partner__tz__etc/utc	base	ir.model.fields.selection
3696	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	798	f	selection__res_partner__tz__etc/universal	base	ir.model.fields.selection
3813	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	32	f	model_inherit__res_partner__image_mixin	base	ir.model.inherit
3697	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	799	f	selection__res_partner__tz__etc/zulu	base	ir.model.fields.selection
3698	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	800	f	selection__res_partner__type__contact	base	ir.model.fields.selection
3699	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	801	f	selection__res_partner__type__invoice	base	ir.model.fields.selection
3700	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	802	f	selection__res_partner__type__delivery	base	ir.model.fields.selection
3701	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	803	f	selection__res_partner__type__other	base	ir.model.fields.selection
3702	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	804	f	selection__res_partner__company_type__person	base	ir.model.fields.selection
3703	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	805	f	selection__res_partner__company_type__company	base	ir.model.fields.selection
3704	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	806	f	selection__res_currency__position__after	base	ir.model.fields.selection
3705	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	807	f	selection__res_currency__position__before	base	ir.model.fields.selection
3706	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	808	f	selection__res_company__font__lato	base	ir.model.fields.selection
3707	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	809	f	selection__res_company__font__roboto	base	ir.model.fields.selection
3708	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	810	f	selection__res_company__font__open_sans	base	ir.model.fields.selection
3709	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	811	f	selection__res_company__font__montserrat	base	ir.model.fields.selection
3710	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	812	f	selection__res_company__font__oswald	base	ir.model.fields.selection
3711	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	813	f	selection__res_company__font__raleway	base	ir.model.fields.selection
3712	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	814	f	selection__res_company__font__tajawal	base	ir.model.fields.selection
3713	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	815	f	selection__res_company__font__fira_mono	base	ir.model.fields.selection
3714	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	816	f	selection__res_company__layout_background__blank	base	ir.model.fields.selection
3715	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	817	f	selection__res_company__layout_background__demo_logo	base	ir.model.fields.selection
3716	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	818	f	selection__res_company__layout_background__custom	base	ir.model.fields.selection
3717	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	819	f	selection__res_users_identitycheck__auth_method__password	base	ir.model.fields.selection
3718	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	820	f	selection__res_users_deletion__state__todo	base	ir.model.fields.selection
3719	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	821	f	selection__res_users_deletion__state__done	base	ir.model.fields.selection
3720	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	822	f	selection__res_users_deletion__state__fail	base	ir.model.fields.selection
3721	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	823	f	selection__res_device_log__device_type__computer	base	ir.model.fields.selection
3722	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	824	f	selection__res_device_log__device_type__mobile	base	ir.model.fields.selection
3723	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	825	f	selection__res_device__device_type__computer	base	ir.model.fields.selection
3724	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	826	f	selection__res_device__device_type__mobile	base	ir.model.fields.selection
3725	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	827	f	selection__base_module_update__state__init	base	ir.model.fields.selection
3726	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	828	f	selection__base_module_update__state__done	base	ir.model.fields.selection
3727	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	829	f	selection__base_language_export__format__csv	base	ir.model.fields.selection
3728	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	830	f	selection__base_language_export__format__po	base	ir.model.fields.selection
3729	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	831	f	selection__base_language_export__format__tgz	base	ir.model.fields.selection
3730	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	832	f	selection__base_language_export__export_type__module	base	ir.model.fields.selection
3731	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	833	f	selection__base_language_export__export_type__model	base	ir.model.fields.selection
3732	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	834	f	selection__base_language_export__state__choose	base	ir.model.fields.selection
3733	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	835	f	selection__base_language_export__state__get	base	ir.model.fields.selection
3734	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	836	f	selection__base_partner_merge_automatic_wizard__state__option	base	ir.model.fields.selection
3735	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	837	f	selection__base_partner_merge_automatic_wizard__state__selection	base	ir.model.fields.selection
3736	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	838	f	selection__base_partner_merge_automatic_wizard__state__finished	base	ir.model.fields.selection
3737	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	f	constraint_ir_model_obj_name_uniq	base	ir.model.constraint
3738	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	f	constraint_ir_model_fields_name_unique	base	ir.model.constraint
3739	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	f	constraint_ir_model_fields_size_gt_zero	base	ir.model.constraint
3740	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	f	constraint_ir_model_fields_name_manual_field	base	ir.model.constraint
3741	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	f	constraint_ir_model_inherit_uniq	base	ir.model.constraint
3742	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	6	f	constraint_ir_model_fields_selection_selection_field_uniq	base	ir.model.constraint
3743	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	7	f	constraint_ir_model_constraint_module_name_uniq	base	ir.model.constraint
3744	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	8	f	constraint_ir_model_data_name_nospaces	base	ir.model.constraint
3745	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	9	f	constraint_ir_sequence_date_range_unique_range_per_sequence	base	ir.model.constraint
3746	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	10	f	constraint_ir_ui_view_inheritance_mode	base	ir.model.constraint
3747	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	11	f	constraint_ir_ui_view_qweb_required_key	base	ir.model.constraint
3748	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	12	f	constraint_ir_actions_path_unique	base	ir.model.constraint
3749	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	13	f	constraint_ir_act_window_path_unique	base	ir.model.constraint
3750	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	14	f	constraint_ir_act_url_path_unique	base	ir.model.constraint
3751	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	15	f	constraint_ir_act_server_path_unique	base	ir.model.constraint
3752	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	16	f	constraint_ir_act_client_path_unique	base	ir.model.constraint
3753	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	17	f	constraint_ir_embedded_actions_check_only_one_action_defined	base	ir.model.constraint
3754	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	18	f	constraint_ir_embedded_actions_check_python_method_requires_name	base	ir.model.constraint
3755	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	19	f	constraint_ir_act_report_xml_path_unique	base	ir.model.constraint
3756	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	20	f	constraint_ir_cron_check_strictly_positive_interval	base	ir.model.constraint
3757	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	21	f	constraint_ir_filters_name_model_uid_unique	base	ir.model.constraint
3758	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	22	f	constraint_ir_filters_check_res_id_only_when_embedded_action	base	ir.model.constraint
3759	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	23	f	constraint_ir_filters_check_sort_json	base	ir.model.constraint
3760	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	24	f	constraint_ir_rule_no_access_rights	base	ir.model.constraint
3761	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	25	f	constraint_ir_config_parameter_key_uniq	base	ir.model.constraint
3762	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	26	f	constraint_ir_mail_server_certificate_requires_tls	base	ir.model.constraint
3763	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	27	f	constraint_ir_module_module_name_uniq	base	ir.model.constraint
3764	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	28	f	constraint_res_country_name_uniq	base	ir.model.constraint
3765	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	29	f	constraint_res_country_code_uniq	base	ir.model.constraint
3766	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	30	f	constraint_res_country_state_name_code_uniq	base	ir.model.constraint
3767	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	31	f	constraint_res_lang_name_uniq	base	ir.model.constraint
3768	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	32	f	constraint_res_lang_code_uniq	base	ir.model.constraint
3769	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	33	f	constraint_res_lang_url_code_uniq	base	ir.model.constraint
3770	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	34	f	constraint_res_partner_check_name	base	ir.model.constraint
3771	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	35	f	constraint_res_partner_bank_unique_number	base	ir.model.constraint
3772	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	36	f	constraint_res_currency_unique_name	base	ir.model.constraint
3773	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	37	f	constraint_res_currency_rounding_gt_zero	base	ir.model.constraint
3774	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	38	f	constraint_res_currency_rate_unique_name_per_day	base	ir.model.constraint
3775	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	39	f	constraint_res_currency_rate_currency_rate_check	base	ir.model.constraint
3776	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	40	f	constraint_res_company_name_uniq	base	ir.model.constraint
3777	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	41	f	constraint_res_groups_name_uniq	base	ir.model.constraint
3778	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	42	f	constraint_res_groups_check_api_key_duration	base	ir.model.constraint
3779	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	43	f	constraint_res_users_login_key	base	ir.model.constraint
3780	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	44	f	constraint_res_users_settings_unique_user_id	base	ir.model.constraint
3781	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	45	f	constraint_decimal_precision_name_uniq	base	ir.model.constraint
3782	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	f	model_inherit__ir_actions_act_window__ir_actions_actions	base	ir.model.inherit
3783	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	f	model_inherit__ir_actions_act_window_close__ir_actions_actions	base	ir.model.inherit
3784	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	f	model_inherit__ir_actions_act_url__ir_actions_actions	base	ir.model.inherit
3785	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	f	model_inherit__ir_actions_server__ir_actions_actions	base	ir.model.inherit
3786	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	f	model_inherit__ir_actions_client__ir_actions_actions	base	ir.model.inherit
3787	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	6	f	model_inherit__ir_actions_report__ir_actions_actions	base	ir.model.inherit
3788	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	7	f	model_inherit__ir_cron__ir_actions_server	base	ir.model.inherit
3789	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	8	f	model_inherit__ir_qweb_field_integer__ir_qweb_field	base	ir.model.inherit
3790	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	9	f	model_inherit__ir_qweb_field_float__ir_qweb_field	base	ir.model.inherit
3791	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	10	f	model_inherit__ir_qweb_field_date__ir_qweb_field	base	ir.model.inherit
3792	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	11	f	model_inherit__ir_qweb_field_datetime__ir_qweb_field	base	ir.model.inherit
3793	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	12	f	model_inherit__ir_qweb_field_text__ir_qweb_field	base	ir.model.inherit
3794	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	13	f	model_inherit__ir_qweb_field_selection__ir_qweb_field	base	ir.model.inherit
3795	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	14	f	model_inherit__ir_qweb_field_many2one__ir_qweb_field	base	ir.model.inherit
3796	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	15	f	model_inherit__ir_qweb_field_many2many__ir_qweb_field	base	ir.model.inherit
3797	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	16	f	model_inherit__ir_qweb_field_one2many__ir_qweb_field	base	ir.model.inherit
3798	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	17	f	model_inherit__ir_qweb_field_html__ir_qweb_field	base	ir.model.inherit
3799	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	18	f	model_inherit__ir_qweb_field_image__ir_qweb_field	base	ir.model.inherit
3800	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	19	f	model_inherit__ir_qweb_field_image_url__ir_qweb_field	base	ir.model.inherit
3801	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	20	f	model_inherit__ir_qweb_field_image_url__ir_qweb_field_image	base	ir.model.inherit
3802	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	21	f	model_inherit__ir_qweb_field_monetary__ir_qweb_field	base	ir.model.inherit
3803	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	22	f	model_inherit__ir_qweb_field_float_time__ir_qweb_field	base	ir.model.inherit
3804	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	23	f	model_inherit__ir_qweb_field_time__ir_qweb_field	base	ir.model.inherit
3805	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	24	f	model_inherit__ir_qweb_field_duration__ir_qweb_field	base	ir.model.inherit
3806	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	25	f	model_inherit__ir_qweb_field_relative__ir_qweb_field	base	ir.model.inherit
3807	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	26	f	model_inherit__ir_qweb_field_barcode__ir_qweb_field	base	ir.model.inherit
3808	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	27	f	model_inherit__ir_qweb_field_contact__ir_qweb_field	base	ir.model.inherit
3809	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	28	f	model_inherit__ir_qweb_field_contact__ir_qweb_field_many2one	base	ir.model.inherit
3810	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	29	f	model_inherit__ir_qweb_field_qweb__ir_qweb_field	base	ir.model.inherit
3811	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	30	f	model_inherit__ir_qweb_field_qweb__ir_qweb_field_many2one	base	ir.model.inherit
3812	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	31	f	model_inherit__avatar_mixin__image_mixin	base	ir.model.inherit
3814	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	33	f	model_inherit__res_partner__format_address_mixin	base	ir.model.inherit
3815	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	34	f	model_inherit__res_partner__format_vat_label_mixin	base	ir.model.inherit
3816	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	35	f	model_inherit__res_partner__avatar_mixin	base	ir.model.inherit
3817	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	36	f	model_inherit__res_company__format_address_mixin	base	ir.model.inherit
3818	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	37	f	model_inherit__res_company__format_vat_label_mixin	base	ir.model.inherit
3819	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	38	f	model_inherit__res_users__res_partner	base	ir.model.inherit
3820	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	39	f	model_inherit__res_device__res_device_log	base	ir.model.inherit
3821	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	res_bank_1	base	res.bank
3822	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	f	lang_en	base	res.lang
3823	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	f	lang_am_ET	base	res.lang
3824	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	f	lang_ar	base	res.lang
3825	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	f	lang_ar_SY	base	res.lang
3826	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	f	lang_az	base	res.lang
3827	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	6	f	lang_eu_ES	base	res.lang
3828	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	7	f	lang_be	base	res.lang
3829	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	8	f	lang_bn_IN	base	res.lang
3830	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	9	f	lang_bs_BA	base	res.lang
3831	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	10	f	lang_bg	base	res.lang
3832	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	11	f	lang_ca_ES	base	res.lang
3833	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	12	f	lang_zh_CN	base	res.lang
3834	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	13	f	lang_zh_HK	base	res.lang
3835	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	14	f	lang_zh_TW	base	res.lang
3836	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	15	f	lang_hr	base	res.lang
3837	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	16	f	lang_cs_CZ	base	res.lang
3838	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	17	f	lang_da_DK	base	res.lang
3839	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	18	f	lang_nl_BE	base	res.lang
3840	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	19	f	lang_nl	base	res.lang
3841	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	20	f	lang_en_AU	base	res.lang
3842	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	21	f	lang_en_CA	base	res.lang
3843	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	22	f	lang_en_GB	base	res.lang
3844	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	23	f	lang_en_IN	base	res.lang
3845	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	24	f	lang_en_NZ	base	res.lang
3846	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	25	f	lang_et_EE	base	res.lang
3847	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	26	f	lang_fi	base	res.lang
3848	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	27	f	lang_fr_BE	base	res.lang
3849	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	28	f	lang_fr_CA	base	res.lang
3850	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	29	f	lang_fr_CH	base	res.lang
3851	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	30	f	lang_fr	base	res.lang
3852	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	31	f	lang_gl_ES	base	res.lang
3853	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	32	f	lang_ka_GE	base	res.lang
3854	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	33	f	lang_de	base	res.lang
3855	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	34	f	lang_de_CH	base	res.lang
3856	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	35	f	lang_el_GR	base	res.lang
3857	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	36	f	lang_gu_IN	base	res.lang
3858	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	37	f	lang_he_IL	base	res.lang
3859	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	38	f	lang_hi_IN	base	res.lang
3860	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	39	f	lang_hu	base	res.lang
3861	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	40	f	lang_id	base	res.lang
3862	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	41	f	lang_it	base	res.lang
3863	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	42	f	lang_ja_JP	base	res.lang
3864	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	43	f	lang_kab_DZ	base	res.lang
3865	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	44	f	lang_km	base	res.lang
3866	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	45	f	lang_ko_KP	base	res.lang
3867	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	46	f	lang_ko_KR	base	res.lang
3868	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	47	f	lang_lo_LA	base	res.lang
3869	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	48	f	lang_lv	base	res.lang
3870	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	49	f	lang_lt	base	res.lang
3871	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	50	f	lang_lb	base	res.lang
3872	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	51	f	lang_mk	base	res.lang
3873	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	52	f	lang_ml	base	res.lang
3874	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	53	f	lang_mn	base	res.lang
3875	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	54	f	lang_ms	base	res.lang
3876	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	55	f	lang_my	base	res.lang
3877	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	56	f	lang_nb_NO	base	res.lang
3878	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	57	f	lang_fa_IR	base	res.lang
3879	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	58	f	lang_pl	base	res.lang
3880	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	59	f	lang_pt_AO	base	res.lang
3881	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	60	f	lang_pt_BR	base	res.lang
3882	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	61	f	lang_pt	base	res.lang
3883	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	62	f	lang_ro	base	res.lang
3884	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	63	f	lang_ru	base	res.lang
3885	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	64	f	lang_sr@Cyrl	base	res.lang
3886	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	65	f	lang_sr@latin	base	res.lang
3887	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	66	f	lang_sk	base	res.lang
3888	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	67	f	lang_sl_SI	base	res.lang
3889	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	68	f	lang_es_419	base	res.lang
3890	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	69	f	lang_es_AR	base	res.lang
3891	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	70	f	lang_es_BO	base	res.lang
3892	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	71	f	lang_es_CL	base	res.lang
3893	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	72	f	lang_es_CO	base	res.lang
3894	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	73	f	lang_es_CR	base	res.lang
3895	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	74	f	lang_es_DO	base	res.lang
3896	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	75	f	lang_es_EC	base	res.lang
3897	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	76	f	lang_es_GT	base	res.lang
3898	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	77	f	lang_es_MX	base	res.lang
3909	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	88	f	lang_tr	base	res.lang
3910	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	89	f	lang_uk_UA	base	res.lang
3911	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	90	f	lang_vi_VN	base	res.lang
3912	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	91	f	lang_sq_AL	base	res.lang
3913	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	92	f	lang_te_IN	base	res.lang
3921	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	t	partner_root	base	res.partner
3922	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	t	partner_admin	base	res.partner
3923	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	t	public_partner	base	res.partner
3924	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	res_partner_title_madam	base	res.partner.title
3925	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	t	res_partner_title_miss	base	res.partner.title
3926	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	t	res_partner_title_mister	base	res.partner.title
3927	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	t	res_partner_title_doctor	base	res.partner.title
3928	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	t	res_partner_title_prof	base	res.partner.title
3929	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	res_partner_industry_A	base	res.partner.industry
3930	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	t	res_partner_industry_B	base	res.partner.industry
3931	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	t	res_partner_industry_C	base	res.partner.industry
3932	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	t	res_partner_industry_D	base	res.partner.industry
3933	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	t	res_partner_industry_E	base	res.partner.industry
3934	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	6	t	res_partner_industry_F	base	res.partner.industry
3935	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	7	t	res_partner_industry_G	base	res.partner.industry
3936	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	8	t	res_partner_industry_H	base	res.partner.industry
3937	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	9	t	res_partner_industry_I	base	res.partner.industry
3938	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	10	t	res_partner_industry_J	base	res.partner.industry
3939	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	11	t	res_partner_industry_K	base	res.partner.industry
3940	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	12	t	res_partner_industry_L	base	res.partner.industry
3941	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	13	t	res_partner_industry_M	base	res.partner.industry
3942	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	14	t	res_partner_industry_N	base	res.partner.industry
3943	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	15	t	res_partner_industry_O	base	res.partner.industry
3944	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	16	t	res_partner_industry_P	base	res.partner.industry
3945	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	17	t	res_partner_industry_Q	base	res.partner.industry
3946	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	18	t	res_partner_industry_R	base	res.partner.industry
3947	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	19	t	res_partner_industry_S	base	res.partner.industry
3948	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	20	t	res_partner_industry_T	base	res.partner.industry
3949	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	21	t	res_partner_industry_U	base	res.partner.industry
3951	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	t	VEF	base	res.currency
3952	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	t	CAD	base	res.currency
3953	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	t	CHF	base	res.currency
3954	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	t	BRL	base	res.currency
3955	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	6	t	CNY	base	res.currency
3956	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	7	t	CNH	base	res.currency
3957	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	8	t	COP	base	res.currency
3958	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	9	t	CZK	base	res.currency
3959	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	10	t	DKK	base	res.currency
3960	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	11	t	HUF	base	res.currency
3961	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	12	t	IDR	base	res.currency
3962	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	13	t	LVL	base	res.currency
3963	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	14	t	NOK	base	res.currency
3964	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	15	t	XPF	base	res.currency
3965	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	16	t	PAB	base	res.currency
3966	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	17	t	PLN	base	res.currency
3967	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	18	t	SEK	base	res.currency
3968	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	19	t	ARS	base	res.currency
3969	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	20	t	INR	base	res.currency
3970	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	21	t	AUD	base	res.currency
3971	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	22	t	UAH	base	res.currency
3972	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	23	t	VND	base	res.currency
3973	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	24	t	HKD	base	res.currency
3974	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	25	t	JPY	base	res.currency
3975	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	26	t	BGN	base	res.currency
3976	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	27	t	LTL	base	res.currency
3977	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	28	t	RON	base	res.currency
3978	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	29	t	HRK	base	res.currency
3979	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	30	t	RUB	base	res.currency
3980	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	31	t	TRY	base	res.currency
3981	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	32	t	KRW	base	res.currency
3982	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	33	t	MXN	base	res.currency
3983	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	34	t	MYR	base	res.currency
3984	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	35	t	NZD	base	res.currency
3985	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	36	t	PHP	base	res.currency
3986	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	37	t	SGD	base	res.currency
3987	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	38	t	ZAR	base	res.currency
3988	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	39	t	CRC	base	res.currency
3989	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	40	t	MUR	base	res.currency
3990	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	41	t	XOF	base	res.currency
3991	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	42	t	XAF	base	res.currency
3992	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	43	t	UGX	base	res.currency
3993	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	44	t	HNL	base	res.currency
3994	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	45	t	CLP	base	res.currency
3995	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	46	t	UYU	base	res.currency
3996	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	47	t	AFN	base	res.currency
3997	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	48	t	AOA	base	res.currency
3998	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	49	t	XCD	base	res.currency
3999	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	50	t	AMD	base	res.currency
4000	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	51	t	AWG	base	res.currency
4001	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	52	t	AZN	base	res.currency
4002	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	53	t	BSD	base	res.currency
4003	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	54	t	BHD	base	res.currency
4004	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	55	t	BDT	base	res.currency
4005	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	56	t	BBD	base	res.currency
4006	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	57	t	BYR	base	res.currency
4007	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	58	t	BYN	base	res.currency
4008	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	59	t	BZD	base	res.currency
4009	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	60	t	BMD	base	res.currency
4010	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	61	t	BTN	base	res.currency
4011	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	62	t	BOB	base	res.currency
4012	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	63	t	BAM	base	res.currency
4013	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	64	t	BWP	base	res.currency
4014	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	65	t	BIF	base	res.currency
4015	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	66	t	KHR	base	res.currency
4016	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	67	t	KYD	base	res.currency
4017	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	68	t	KMF	base	res.currency
4018	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	69	t	CDF	base	res.currency
4019	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	70	t	CUP	base	res.currency
4020	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	71	t	ANG	base	res.currency
4021	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	72	t	XCG	base	res.currency
4022	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	73	t	DJF	base	res.currency
4023	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	74	t	DOP	base	res.currency
4024	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	75	t	EGP	base	res.currency
4025	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	76	t	SVC	base	res.currency
4026	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	77	t	ERN	base	res.currency
4027	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	78	t	ETB	base	res.currency
4028	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	79	t	FKP	base	res.currency
4029	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	80	t	FJD	base	res.currency
4030	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	81	t	GEL	base	res.currency
4031	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	82	t	GIP	base	res.currency
4032	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	83	t	GNF	base	res.currency
4033	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	84	t	GYD	base	res.currency
4034	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	85	t	HTG	base	res.currency
4035	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	86	t	ISK	base	res.currency
4036	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	87	t	IRR	base	res.currency
4037	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	88	t	IQD	base	res.currency
4038	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	89	t	ILS	base	res.currency
4039	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	90	t	JMD	base	res.currency
4040	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	91	t	JOD	base	res.currency
4041	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	92	t	KZT	base	res.currency
4042	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	93	t	KES	base	res.currency
4043	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	94	t	KWD	base	res.currency
4044	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	95	t	KGS	base	res.currency
4045	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	96	t	LAK	base	res.currency
4046	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	97	t	LBP	base	res.currency
4047	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	98	t	LSL	base	res.currency
4048	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	99	t	LRD	base	res.currency
4049	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	100	t	LYD	base	res.currency
4050	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	101	t	MOP	base	res.currency
4051	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	102	t	MKD	base	res.currency
4052	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	103	t	MGA	base	res.currency
4053	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	104	t	MWK	base	res.currency
4054	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	105	t	MVR	base	res.currency
4055	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	106	t	MRO	base	res.currency
4056	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	107	t	MRU	base	res.currency
4057	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	108	t	MDL	base	res.currency
4058	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	109	t	MNT	base	res.currency
4059	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	110	t	MAD	base	res.currency
4060	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	111	t	BND	base	res.currency
4061	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	112	t	DZD	base	res.currency
4062	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	113	t	GHS	base	res.currency
4063	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	114	t	GMD	base	res.currency
4064	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	115	t	MZN	base	res.currency
4065	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	116	t	MMK	base	res.currency
4066	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	117	t	NAD	base	res.currency
4067	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	118	t	NPR	base	res.currency
4068	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	119	t	ALL	base	res.currency
4069	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	120	t	NIO	base	res.currency
4070	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	121	t	NGN	base	res.currency
4071	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	122	t	KPW	base	res.currency
4072	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	123	t	ZIG	base	res.currency
4073	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	124	t	ZMW	base	res.currency
4074	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	125	t	YER	base	res.currency
4075	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	126	t	EUR	base	res.currency
4076	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	127	t	VUV	base	res.currency
4077	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	128	t	UZS	base	res.currency
4078	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	129	t	AED	base	res.currency
4079	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	130	t	TMT	base	res.currency
4080	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	131	t	TND	base	res.currency
4081	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	132	t	TTD	base	res.currency
4082	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	133	t	TOP	base	res.currency
4083	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	134	t	THB	base	res.currency
4084	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	135	t	TZS	base	res.currency
4085	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	136	t	TJS	base	res.currency
4086	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	137	t	TWD	base	res.currency
4087	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	138	t	SYP	base	res.currency
4088	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	139	t	SZL	base	res.currency
4089	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	140	t	SRD	base	res.currency
4090	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	141	t	SDG	base	res.currency
4091	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	142	t	LKR	base	res.currency
4092	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	143	t	SSP	base	res.currency
4093	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	144	t	GBP	base	res.currency
4094	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	145	t	SOS	base	res.currency
4095	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	146	t	SBD	base	res.currency
4096	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	147	t	SLL	base	res.currency
4097	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	148	t	SLE	base	res.currency
4098	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	149	t	SCR	base	res.currency
4099	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	150	t	RSD	base	res.currency
4100	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	151	t	SAR	base	res.currency
4101	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	152	t	STD	base	res.currency
4102	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	153	t	WST	base	res.currency
4103	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	154	t	SHP	base	res.currency
4104	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	155	t	RWF	base	res.currency
4105	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	156	t	QAR	base	res.currency
4106	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	157	t	PEN	base	res.currency
4107	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	158	t	PYG	base	res.currency
4108	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	159	t	PGK	base	res.currency
4109	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	160	t	PKR	base	res.currency
4110	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	161	t	OMR	base	res.currency
4111	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	162	t	CVE	base	res.currency
4112	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	163	t	COU	base	res.currency
4113	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	164	t	CLF	base	res.currency
4114	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	165	t	CUC	base	res.currency
4115	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	166	t	GTQ	base	res.currency
4116	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	167	t	VES	base	res.currency
4117	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	168	t	UYW	base	res.currency
4118	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	169	t	UYI	base	res.currency
4119	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	170	t	STN	base	res.currency
4122	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	t	user_admin	base	res.users
4123	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	user_admin_settings	base	res.users.settings
4124	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	t	default_user_res_partner	base	res.partner
4125	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	t	default_user	base	res.users
4126	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	t	public_user	base	res.users
4127	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	paperformat_euro	base	report.paperformat
4128	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	t	paperformat_us	base	report.paperformat
4129	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	t	paperformat_batch_deposit	base	report.paperformat
4130	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	1	t	ad	base	res.country
4131	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	2	t	ae	base	res.country
4132	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	3	t	af	base	res.country
4133	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	4	t	ag	base	res.country
4134	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	5	t	ai	base	res.country
4135	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	6	t	al	base	res.country
4136	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	7	t	am	base	res.country
4137	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	8	t	ao	base	res.country
4138	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	9	t	aq	base	res.country
4139	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	10	t	ar	base	res.country
4140	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	11	t	as	base	res.country
4141	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	12	t	at	base	res.country
4142	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	13	t	au	base	res.country
4143	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	14	t	aw	base	res.country
4144	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	15	t	ax	base	res.country
4145	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	16	t	az	base	res.country
4146	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	17	t	ba	base	res.country
4147	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	18	t	bb	base	res.country
4148	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	19	t	bd	base	res.country
4149	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	20	t	be	base	res.country
4150	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	21	t	bf	base	res.country
4151	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	22	t	bg	base	res.country
4152	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	23	t	bh	base	res.country
4153	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	24	t	bi	base	res.country
4154	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	25	t	bj	base	res.country
4155	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	26	t	bl	base	res.country
4156	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	27	t	bm	base	res.country
4157	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	28	t	bn	base	res.country
4158	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	29	t	bo	base	res.country
4159	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	30	t	bq	base	res.country
4160	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	31	t	br	base	res.country
4161	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	32	t	bs	base	res.country
4162	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	33	t	bt	base	res.country
4163	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	34	t	bv	base	res.country
4164	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	35	t	bw	base	res.country
4165	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	36	t	by	base	res.country
4166	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	37	t	bz	base	res.country
4167	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	38	t	ca	base	res.country
4168	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	39	t	cc	base	res.country
4169	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	40	t	cf	base	res.country
4170	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	41	t	cd	base	res.country
4171	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	42	t	cg	base	res.country
4172	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	43	t	ch	base	res.country
4173	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	44	t	ci	base	res.country
4174	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	45	t	ck	base	res.country
4175	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	46	t	cl	base	res.country
4176	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	47	t	cm	base	res.country
4177	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	48	t	cn	base	res.country
4178	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	49	t	co	base	res.country
4179	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	50	t	cr	base	res.country
4180	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	51	t	cu	base	res.country
4181	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	52	t	cv	base	res.country
4182	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	53	t	cw	base	res.country
4183	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	54	t	cx	base	res.country
4184	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	55	t	cy	base	res.country
4185	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	56	t	cz	base	res.country
4186	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	57	t	de	base	res.country
4187	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	58	t	dj	base	res.country
4188	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	59	t	dk	base	res.country
4189	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	60	t	dm	base	res.country
4190	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	61	t	do	base	res.country
4191	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	62	t	dz	base	res.country
4192	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	63	t	ec	base	res.country
4193	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	64	t	ee	base	res.country
4194	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	65	t	eg	base	res.country
4195	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	66	t	eh	base	res.country
4196	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	67	t	er	base	res.country
4197	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	68	t	es	base	res.country
4198	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	69	t	et	base	res.country
4199	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	70	t	fi	base	res.country
4200	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	71	t	fj	base	res.country
4201	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	72	t	fk	base	res.country
4202	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	73	t	fm	base	res.country
4203	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	74	t	fo	base	res.country
4204	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	75	t	fr	base	res.country
4205	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	76	t	ga	base	res.country
4206	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	77	t	gd	base	res.country
4207	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	78	t	ge	base	res.country
4208	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	79	t	gf	base	res.country
4209	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	80	t	gh	base	res.country
4210	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	81	t	gi	base	res.country
4211	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	82	t	gg	base	res.country
4212	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	83	t	gl	base	res.country
4213	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	84	t	gm	base	res.country
4214	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	85	t	gn	base	res.country
4215	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	86	t	gp	base	res.country
4216	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	87	t	gq	base	res.country
4217	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	88	t	gr	base	res.country
4218	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	89	t	gs	base	res.country
4219	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	90	t	gt	base	res.country
4220	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	91	t	gu	base	res.country
4221	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	92	t	gw	base	res.country
4222	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	93	t	gy	base	res.country
4223	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	94	t	hk	base	res.country
4224	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	95	t	hm	base	res.country
4225	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	96	t	hn	base	res.country
4226	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	97	t	hr	base	res.country
4227	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	98	t	ht	base	res.country
4228	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	99	t	hu	base	res.country
4229	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	100	t	id	base	res.country
4230	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	101	t	ie	base	res.country
4231	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	102	t	il	base	res.country
4232	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	103	t	im	base	res.country
4233	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	104	t	in	base	res.country
4234	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	105	t	io	base	res.country
4235	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	106	t	iq	base	res.country
4236	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	107	t	ir	base	res.country
4237	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	108	t	is	base	res.country
4238	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	109	t	it	base	res.country
4239	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	110	t	je	base	res.country
4240	\N	2026-01-22 18:39:41.684834	2026-01-22 18:39:41.684834	\N	111