--
-- PostgreSQL database dump
--

-- Dumped from database version 16.9 (Ubuntu 16.9-1.pgdg20.04+1)
-- Dumped by pg_dump version 16.9 (Ubuntu 16.9-1.pgdg24.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    message_main_attachment_id integer,
    plan_id integer NOT NULL,
    root_plan_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    line_seq integer,
    budgetable boolean
);


ALTER TABLE public.account_analytic_account OWNER TO runbot;

--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_analytic_account.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_account.root_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.root_plan_id IS 'Root Plan';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_account.line_seq; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.line_seq IS 'Line Seq';


--
-- Name: COLUMN account_analytic_account.budgetable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.budgetable IS 'Budgetable';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_account_id_seq OWNER TO runbot;

--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_applicability; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_applicability (
    id integer NOT NULL,
    analytic_plan_id integer,
    create_uid integer,
    write_uid integer,
    business_domain character varying NOT NULL,
    applicability character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_applicability OWNER TO runbot;

--
-- Name: TABLE account_analytic_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_applicability IS 'Analytic Plan''s Applicabilities';


--
-- Name: COLUMN account_analytic_applicability.analytic_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.analytic_plan_id IS 'Analytic Plan';


--
-- Name: COLUMN account_analytic_applicability.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_applicability.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_applicability.business_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.business_domain IS 'Domain';


--
-- Name: COLUMN account_analytic_applicability.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.applicability IS 'Applicability';


--
-- Name: COLUMN account_analytic_applicability.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_applicability.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_date IS 'Last Updated on';


--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_applicability_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNER TO runbot;

--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNED BY public.account_analytic_applicability.id;


--
-- Name: account_analytic_distribution_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_distribution_model (
    id integer NOT NULL,
    partner_id integer,
    partner_category_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    analytic_distribution jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_distribution_model OWNER TO runbot;

--
-- Name: TABLE account_analytic_distribution_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_distribution_model IS 'Analytic Distribution Model';


--
-- Name: COLUMN account_analytic_distribution_model.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_distribution_model.partner_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_category_id IS 'Partner Category';


--
-- Name: COLUMN account_analytic_distribution_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_distribution_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution_model.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.analytic_distribution IS 'Analytic';


--
-- Name: COLUMN account_analytic_distribution_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_date IS 'Last Updated on';


--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_distribution_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNER TO runbot;

--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNED BY public.account_analytic_distribution_model.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    product_uom_id integer,
    account_id integer NOT NULL,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    plan_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    category character varying,
    date date NOT NULL,
    amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    unit_amount double precision
);


ALTER TABLE public.account_analytic_line OWNER TO runbot;

--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.category IS 'Category';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_plan (
    id integer NOT NULL,
    parent_id integer,
    company_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    parent_path character varying,
    complete_name character varying,
    default_applicability character varying NOT NULL,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    message_main_attachment_id integer,
    code character varying
);


ALTER TABLE public.account_analytic_plan OWNER TO runbot;

--
-- Name: TABLE account_analytic_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_plan IS 'Analytic Plans';


--
-- Name: COLUMN account_analytic_plan.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_plan.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.color IS 'Color';


--
-- Name: COLUMN account_analytic_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.name IS 'Name';


--
-- Name: COLUMN account_analytic_plan.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_analytic_plan.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_plan.default_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.default_applicability IS 'Default Applicability';


--
-- Name: COLUMN account_analytic_plan.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.description IS 'Description';


--
-- Name: COLUMN account_analytic_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_plan.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_analytic_plan.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.code IS 'Code';


--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_plan_id_seq OWNER TO runbot;

--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_plan_id_seq OWNED BY public.account_analytic_plan.id;


--
-- Name: analytic_account_operating_unit_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.analytic_account_operating_unit_rel (
    analytic_account_id integer NOT NULL,
    operating_unit_id integer NOT NULL
);


ALTER TABLE public.analytic_account_operating_unit_rel OWNER TO runbot;

--
-- Name: TABLE analytic_account_operating_unit_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.analytic_account_operating_unit_rel IS 'RELATION BETWEEN account_analytic_account AND operating_unit';


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8) NOT NULL,
    key character varying NOT NULL,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: barcode_nomenclature; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_nomenclature (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying(32) NOT NULL,
    upc_ean_conv character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    gs1_separator_fnc1 character varying,
    is_gs1_nomenclature boolean
);


ALTER TABLE public.barcode_nomenclature OWNER TO runbot;

--
-- Name: TABLE barcode_nomenclature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_nomenclature IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_nomenclature.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_nomenclature.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.name IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.upc_ean_conv; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.upc_ean_conv IS 'UPC/EAN Conversion';


--
-- Name: COLUMN barcode_nomenclature.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_date IS 'Created on';


--
-- Name: COLUMN barcode_nomenclature.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_nomenclature.gs1_separator_fnc1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.gs1_separator_fnc1 IS 'FNC1 Separator';


--
-- Name: COLUMN barcode_nomenclature.is_gs1_nomenclature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.is_gs1_nomenclature IS 'Is GS1 Nomenclature';


--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_nomenclature_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNER TO runbot;

--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNED BY public.barcode_nomenclature.id;


--
-- Name: barcode_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_rule (
    id integer NOT NULL,
    barcode_nomenclature_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying(32) NOT NULL,
    encoding character varying NOT NULL,
    type character varying NOT NULL,
    pattern character varying NOT NULL,
    alias character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    associated_uom_id integer,
    gs1_content_type character varying,
    gs1_decimal_usage boolean
);


ALTER TABLE public.barcode_rule OWNER TO runbot;

--
-- Name: TABLE barcode_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_rule IS 'Barcode Rule';


--
-- Name: COLUMN barcode_rule.barcode_nomenclature_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.barcode_nomenclature_id IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.sequence IS 'Sequence';


--
-- Name: COLUMN barcode_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.name IS 'Rule Name';


--
-- Name: COLUMN barcode_rule.encoding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.encoding IS 'Encoding';


--
-- Name: COLUMN barcode_rule.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.type IS 'Type';


--
-- Name: COLUMN barcode_rule.pattern; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.pattern IS 'Barcode Pattern';


--
-- Name: COLUMN barcode_rule.alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.alias IS 'Alias';


--
-- Name: COLUMN barcode_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_date IS 'Created on';


--
-- Name: COLUMN barcode_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_rule.associated_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.associated_uom_id IS 'Associated Uom';


--
-- Name: COLUMN barcode_rule.gs1_content_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.gs1_content_type IS 'GS1 Content Type';


--
-- Name: COLUMN barcode_rule.gs1_decimal_usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.gs1_decimal_usage IS 'Decimal';


--
-- Name: barcode_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_rule_id_seq OWNER TO runbot;

--
-- Name: barcode_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_rule_id_seq OWNED BY public.barcode_rule.id;


--
-- Name: base_cache_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_tests_models_char; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char IS 'Tests : Base Import Model, Character';


--
-- Name: COLUMN base_import_tests_models_char.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_id_seq OWNED BY public.base_import_tests_models_char.id;


--
-- Name: base_import_tests_models_char_noreadonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_noreadonly (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_noreadonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_noreadonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_noreadonly IS 'Tests : Base Import Model, Character No readonly';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq OWNED BY public.base_import_tests_models_char_noreadonly.id;


--
-- Name: base_import_tests_models_char_readonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_readonly (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_readonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_readonly IS 'Tests : Base Import Model, Character readonly';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_readonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_readonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_readonly_id_seq OWNED BY public.base_import_tests_models_char_readonly.id;


--
-- Name: base_import_tests_models_char_required; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_required (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_required OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_required IS 'Tests : Base Import Model, Character required';


--
-- Name: COLUMN base_import_tests_models_char_required.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_required.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_required.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_required.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_required.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_required_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_required_id_seq OWNED BY public.base_import_tests_models_char_required.id;


--
-- Name: base_import_tests_models_char_states; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_states (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_states OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_states; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_states IS 'Tests : Base Import Model, Character states';


--
-- Name: COLUMN base_import_tests_models_char_states.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_states.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_states.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_states.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_states.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_states_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_states_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_states_id_seq OWNED BY public.base_import_tests_models_char_states.id;


--
-- Name: base_import_tests_models_char_stillreadonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_stillreadonly (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_stillreadonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_stillreadonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_stillreadonly IS 'Tests : Base Import Model, Character still readonly';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq OWNED BY public.base_import_tests_models_char_stillreadonly.id;


--
-- Name: base_import_tests_models_complex; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_complex (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    c character varying,
    d date,
    m numeric,
    dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    f double precision
);


ALTER TABLE public.base_import_tests_models_complex OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_complex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_complex IS 'Tests: Base Import Model Complex';


--
-- Name: COLUMN base_import_tests_models_complex.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_complex.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_complex.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_complex.c; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.c IS 'C';


--
-- Name: COLUMN base_import_tests_models_complex.d; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.d IS 'D';


--
-- Name: COLUMN base_import_tests_models_complex.m; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.m IS 'M';


--
-- Name: COLUMN base_import_tests_models_complex.dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.dt IS 'Dt';


--
-- Name: COLUMN base_import_tests_models_complex.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_complex.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_tests_models_complex.f; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.f IS 'F';


--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_complex_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_complex_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_complex_id_seq OWNED BY public.base_import_tests_models_complex.id;


--
-- Name: base_import_tests_models_float; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_float (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    value2 numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value double precision
);


ALTER TABLE public.base_import_tests_models_float OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_float IS 'Tests: Base Import Model Float';


--
-- Name: COLUMN base_import_tests_models_float.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_float.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_float.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_float.value2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.value2 IS 'Value2';


--
-- Name: COLUMN base_import_tests_models_float.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_float.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_tests_models_float.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.value IS 'Value';


--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_float_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_float_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_float_id_seq OWNED BY public.base_import_tests_models_float.id;


--
-- Name: base_import_tests_models_m2o; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o IS 'Tests : Base Import Model, Many to One';


--
-- Name: COLUMN base_import_tests_models_m2o.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_id_seq OWNED BY public.base_import_tests_models_m2o.id;


--
-- Name: base_import_tests_models_m2o_related; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_related OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_related IS 'Tests : Base Import Model, Many to One related';


--
-- Name: COLUMN base_import_tests_models_m2o_related.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_related_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_related_id_seq OWNED BY public.base_import_tests_models_m2o_related.id;


--
-- Name: base_import_tests_models_m2o_required; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_required (
    id integer NOT NULL,
    value integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_required OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required IS 'Tests : Base Import Model, Many to One required';


--
-- Name: COLUMN base_import_tests_models_m2o_required.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_required_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_id_seq OWNED BY public.base_import_tests_models_m2o_required.id;


--
-- Name: base_import_tests_models_m2o_required_related; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_required_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_required_related OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_required_related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required_related IS 'Tests : Base Import Model, Many to One required related';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq OWNED BY public.base_import_tests_models_m2o_required_related.id;


--
-- Name: base_import_tests_models_o2m; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_o2m (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_o2m OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_o2m; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_o2m IS 'Tests : Base Import Model, One to Many';


--
-- Name: COLUMN base_import_tests_models_o2m.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_o2m.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_o2m_child (
    id integer NOT NULL,
    parent_id integer,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_o2m_child OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_o2m_child; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_o2m_child IS 'Tests : Base Import Model, One to Many child';


--
-- Name: COLUMN base_import_tests_models_o2m_child.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.parent_id IS 'Parent';


--
-- Name: COLUMN base_import_tests_models_o2m_child.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_o2m_child_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_o2m_child_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_o2m_child_id_seq OWNED BY public.base_import_tests_models_o2m_child.id;


--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_o2m_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_o2m_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_o2m_id_seq OWNED BY public.base_import_tests_models_o2m.id;


--
-- Name: base_import_tests_models_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_preview (
    id integer NOT NULL,
    somevalue integer NOT NULL,
    othervalue integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_preview OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_preview IS 'Tests : Base Import Model Preview';


--
-- Name: COLUMN base_import_tests_models_preview.somevalue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.somevalue IS 'Some Value';


--
-- Name: COLUMN base_import_tests_models_preview.othervalue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.othervalue IS 'Other Variable';


--
-- Name: COLUMN base_import_tests_models_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_preview.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_preview_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_preview_id_seq OWNED BY public.base_import_tests_models_preview.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying(6) NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: base_substate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_substate (
    id integer NOT NULL,
    sequence integer,
    target_state_value_id integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    model character varying,
    name jsonb NOT NULL,
    description jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_substate OWNER TO runbot;

--
-- Name: TABLE base_substate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_substate IS 'Base Substate';


--
-- Name: COLUMN base_substate.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate.sequence IS 'Sequence';


--
-- Name: COLUMN base_substate.target_state_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate.target_state_value_id IS 'Target State Value';


--
-- Name: COLUMN base_substate.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate.mail_template_id IS 'Email Template';


--
-- Name: COLUMN base_substate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate.create_uid IS 'Created by';


--
-- Name: COLUMN base_substate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_substate.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate.model IS 'Apply on';


--
-- Name: COLUMN base_substate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate.name IS 'Substate Name';


--
-- Name: COLUMN base_substate.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate.description IS 'Description';


--
-- Name: COLUMN base_substate.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate.active IS 'Active';


--
-- Name: COLUMN base_substate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate.create_date IS 'Created on';


--
-- Name: COLUMN base_substate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate.write_date IS 'Last Updated on';


--
-- Name: base_substate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_substate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_substate_id_seq OWNER TO runbot;

--
-- Name: base_substate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_substate_id_seq OWNED BY public.base_substate.id;


--
-- Name: base_substate_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_substate_type (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    target_state_field character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_substate_type OWNER TO runbot;

--
-- Name: TABLE base_substate_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_substate_type IS 'Base Substate Type';


--
-- Name: COLUMN base_substate_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate_type.create_uid IS 'Created by';


--
-- Name: COLUMN base_substate_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_substate_type.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate_type.model IS 'Apply on';


--
-- Name: COLUMN base_substate_type.target_state_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate_type.target_state_field IS 'Target State Field';


--
-- Name: COLUMN base_substate_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate_type.name IS 'Name';


--
-- Name: COLUMN base_substate_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate_type.create_date IS 'Created on';


--
-- Name: COLUMN base_substate_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_substate_type.write_date IS 'Last Updated on';


--
-- Name: base_substate_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_substate_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_substate_type_id_seq OWNER TO runbot;

--
-- Name: base_substate_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_substate_type_id_seq OWNED BY public.base_substate_type.id;


--
-- Name: base_user_role_line_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_user_role_line_history (
    id integer NOT NULL,
    user_id integer,
    old_role_id integer,
    new_role_id integer,
    create_uid integer,
    write_uid integer,
    performed_action character varying NOT NULL,
    old_date_from date,
    new_date_from date,
    old_date_to date,
    new_date_to date,
    old_is_enabled boolean,
    new_is_enabled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_user_role_line_history OWNER TO runbot;

--
-- Name: TABLE base_user_role_line_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_user_role_line_history IS 'History of user roles';


--
-- Name: COLUMN base_user_role_line_history.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.user_id IS 'User';


--
-- Name: COLUMN base_user_role_line_history.old_role_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.old_role_id IS 'Old role';


--
-- Name: COLUMN base_user_role_line_history.new_role_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.new_role_id IS 'New role';


--
-- Name: COLUMN base_user_role_line_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.create_uid IS 'Created by';


--
-- Name: COLUMN base_user_role_line_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_user_role_line_history.performed_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.performed_action IS 'Action';


--
-- Name: COLUMN base_user_role_line_history.old_date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.old_date_from IS 'Old start date';


--
-- Name: COLUMN base_user_role_line_history.new_date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.new_date_from IS 'New start date';


--
-- Name: COLUMN base_user_role_line_history.old_date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.old_date_to IS 'Old end date';


--
-- Name: COLUMN base_user_role_line_history.new_date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.new_date_to IS 'New end date';


--
-- Name: COLUMN base_user_role_line_history.old_is_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.old_is_enabled IS 'Active before edit';


--
-- Name: COLUMN base_user_role_line_history.new_is_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.new_is_enabled IS 'Active after edit';


--
-- Name: COLUMN base_user_role_line_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.create_date IS 'Created on';


--
-- Name: COLUMN base_user_role_line_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_user_role_line_history.write_date IS 'Last Updated on';


--
-- Name: base_user_role_line_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_user_role_line_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_user_role_line_history_id_seq OWNER TO runbot;

--
-- Name: base_user_role_line_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_user_role_line_history_id_seq OWNED BY public.base_user_role_line_history.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    guest_id integer,
    CONSTRAINT bus_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.bus_presence OWNER TO runbot;

--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: COLUMN bus_presence.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.guest_id IS 'Guest';


--
-- Name: CONSTRAINT bus_presence_partner_or_guest_exists ON bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT bus_presence_partner_or_guest_exists ON public.bus_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_presence_id_seq OWNER TO runbot;

--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: calendar_alarm; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm (
    id integer NOT NULL,
    duration integer NOT NULL,
    duration_minutes integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    alarm_type character varying NOT NULL,
    "interval" character varying NOT NULL,
    name jsonb NOT NULL,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_alarm OWNER TO runbot;

--
-- Name: TABLE calendar_alarm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm IS 'Event Alarm';


--
-- Name: COLUMN calendar_alarm.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration IS 'Remind Before';


--
-- Name: COLUMN calendar_alarm.duration_minutes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration_minutes IS 'Duration in minutes';


--
-- Name: COLUMN calendar_alarm.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.mail_template_id IS 'Email Template';


--
-- Name: COLUMN calendar_alarm.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_alarm.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_alarm.alarm_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.alarm_type IS 'Type';


--
-- Name: COLUMN calendar_alarm."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm."interval" IS 'Unit';


--
-- Name: COLUMN calendar_alarm.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.name IS 'Name';


--
-- Name: COLUMN calendar_alarm.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.body IS 'Additional Message';


--
-- Name: COLUMN calendar_alarm.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_date IS 'Created on';


--
-- Name: COLUMN calendar_alarm.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_date IS 'Last Updated on';


--
-- Name: calendar_alarm_calendar_event_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm_calendar_event_rel (
    calendar_event_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


ALTER TABLE public.calendar_alarm_calendar_event_rel OWNER TO runbot;

--
-- Name: TABLE calendar_alarm_calendar_event_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm_calendar_event_rel IS 'RELATION BETWEEN calendar_event AND calendar_alarm';


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_alarm_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_alarm_id_seq OWNER TO runbot;

--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_alarm_id_seq OWNED BY public.calendar_alarm.id;


--
-- Name: calendar_attendee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_attendee (
    id integer NOT NULL,
    event_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    common_name character varying,
    access_token character varying,
    state character varying,
    availability character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_attendee OWNER TO runbot;

--
-- Name: TABLE calendar_attendee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_attendee IS 'Calendar Attendee Information';


--
-- Name: COLUMN calendar_attendee.event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.event_id IS 'Meeting linked';


--
-- Name: COLUMN calendar_attendee.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.partner_id IS 'Attendee';


--
-- Name: COLUMN calendar_attendee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_attendee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_attendee.common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.common_name IS 'Common name';


--
-- Name: COLUMN calendar_attendee.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_attendee.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.state IS 'Status';


--
-- Name: COLUMN calendar_attendee.availability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.availability IS 'Available/Busy';


--
-- Name: COLUMN calendar_attendee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_date IS 'Created on';


--
-- Name: COLUMN calendar_attendee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_date IS 'Last Updated on';


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_attendee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_attendee_id_seq OWNER TO runbot;

--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_attendee_id_seq OWNED BY public.calendar_attendee.id;


--
-- Name: calendar_event; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event (
    id integer NOT NULL,
    message_main_attachment_id integer,
    user_id integer,
    videocall_channel_id integer,
    res_id integer,
    res_model_id integer,
    recurrence_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location character varying,
    videocall_location character varying,
    access_token character varying,
    privacy character varying NOT NULL,
    show_as character varying NOT NULL,
    res_model character varying,
    start_date date,
    stop_date date,
    description text,
    active boolean,
    allday boolean,
    recurrency boolean,
    follow_recurrence boolean,
    start timestamp without time zone NOT NULL,
    stop timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.calendar_event OWNER TO runbot;

--
-- Name: TABLE calendar_event; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event IS 'Calendar Event';


--
-- Name: COLUMN calendar_event.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN calendar_event.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.user_id IS 'Organizer';


--
-- Name: COLUMN calendar_event.videocall_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_channel_id IS 'Discuss Channel';


--
-- Name: COLUMN calendar_event.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_id IS 'Document ID';


--
-- Name: COLUMN calendar_event.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model_id IS 'Document Model';


--
-- Name: COLUMN calendar_event.recurrence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrence_id IS 'Recurrence Rule';


--
-- Name: COLUMN calendar_event.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.name IS 'Meeting Subject';


--
-- Name: COLUMN calendar_event.location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.location IS 'Location';


--
-- Name: COLUMN calendar_event.videocall_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_location IS 'Meeting URL';


--
-- Name: COLUMN calendar_event.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_event.privacy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.privacy IS 'Privacy';


--
-- Name: COLUMN calendar_event.show_as; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.show_as IS 'Show as';


--
-- Name: COLUMN calendar_event.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model IS 'Document Model Name';


--
-- Name: COLUMN calendar_event.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start_date IS 'Start Date';


--
-- Name: COLUMN calendar_event.stop_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop_date IS 'End Date';


--
-- Name: COLUMN calendar_event.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.description IS 'Description';


--
-- Name: COLUMN calendar_event.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.active IS 'Active';


--
-- Name: COLUMN calendar_event.allday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.allday IS 'All Day';


--
-- Name: COLUMN calendar_event.recurrency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrency IS 'Recurrent';


--
-- Name: COLUMN calendar_event.follow_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.follow_recurrence IS 'Follow Recurrence';


--
-- Name: COLUMN calendar_event.start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start IS 'Start';


--
-- Name: COLUMN calendar_event.stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop IS 'Stop';


--
-- Name: COLUMN calendar_event.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_event.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.duration IS 'Duration';


--
-- Name: calendar_event_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_id_seq OWNER TO runbot;

--
-- Name: calendar_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_id_seq OWNED BY public.calendar_event.id;


--
-- Name: calendar_event_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_res_partner_rel (
    res_partner_id integer NOT NULL,
    calendar_event_id integer NOT NULL
);


ALTER TABLE public.calendar_event_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE calendar_event_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_res_partner_rel IS 'RELATION BETWEEN res_partner AND calendar_event';


--
-- Name: calendar_event_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_type (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_event_type OWNER TO runbot;

--
-- Name: TABLE calendar_event_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_type IS 'Event Meeting Type';


--
-- Name: COLUMN calendar_event_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.color IS 'Color';


--
-- Name: COLUMN calendar_event_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.name IS 'Name';


--
-- Name: COLUMN calendar_event_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_date IS 'Last Updated on';


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_type_id_seq OWNER TO runbot;

--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_type_id_seq OWNED BY public.calendar_event_type.id;


--
-- Name: calendar_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_filters (
    id integer NOT NULL,
    user_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    partner_checked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_filters OWNER TO runbot;

--
-- Name: TABLE calendar_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_filters IS 'Calendar Filters';


--
-- Name: COLUMN calendar_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.user_id IS 'Me';


--
-- Name: COLUMN calendar_filters.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_id IS 'Employee';


--
-- Name: COLUMN calendar_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.active IS 'Active';


--
-- Name: COLUMN calendar_filters.partner_checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_checked IS 'Checked';


--
-- Name: COLUMN calendar_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_date IS 'Created on';


--
-- Name: COLUMN calendar_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_date IS 'Last Updated on';


--
-- Name: calendar_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_filters_id_seq OWNER TO runbot;

--
-- Name: calendar_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_filters_id_seq OWNED BY public.calendar_filters.id;


--
-- Name: calendar_provider_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_provider_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    external_calendar_provider character varying,
    cal_client_id character varying,
    cal_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_provider_config OWNER TO runbot;

--
-- Name: TABLE calendar_provider_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_provider_config IS 'Calendar Provider Configuration Wizard';


--
-- Name: COLUMN calendar_provider_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_provider_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_provider_config.external_calendar_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.external_calendar_provider IS 'Choose an external calendar to configure';


--
-- Name: COLUMN calendar_provider_config.cal_client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_id IS 'Google Client_id';


--
-- Name: COLUMN calendar_provider_config.cal_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_secret IS 'Google Client_key';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN calendar_provider_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_date IS 'Created on';


--
-- Name: COLUMN calendar_provider_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_date IS 'Last Updated on';


--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_provider_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_provider_config_id_seq OWNER TO runbot;

--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_provider_config_id_seq OWNED BY public.calendar_provider_config.id;


--
-- Name: calendar_recurrence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_recurrence (
    id integer NOT NULL,
    base_event_id integer,
    "interval" integer,
    count integer,
    day integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    event_tz character varying,
    rrule character varying,
    rrule_type character varying,
    end_type character varying,
    month_by character varying,
    weekday character varying,
    byday character varying,
    until date,
    mon boolean,
    tue boolean,
    wed boolean,
    thu boolean,
    fri boolean,
    sat boolean,
    sun boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT calendar_recurrence_month_day CHECK ((((rrule_type)::text <> 'monthly'::text) OR ((month_by)::text <> 'day'::text) OR ((day >= 1) AND (day <= 31)) OR (((weekday)::text = ANY ((ARRAY['MON'::character varying, 'TUE'::character varying, 'WED'::character varying, 'THU'::character varying, 'FRI'::character varying, 'SAT'::character varying, 'SUN'::character varying])::text[])) AND ((byday)::text = ANY ((ARRAY['1'::character varying, '2'::character varying, '3'::character varying, '4'::character varying, '-1'::character varying])::text[])))))
);


ALTER TABLE public.calendar_recurrence OWNER TO runbot;

--
-- Name: TABLE calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_recurrence IS 'Event Recurrence Rule';


--
-- Name: COLUMN calendar_recurrence.base_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.base_event_id IS 'Base Event';


--
-- Name: COLUMN calendar_recurrence."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence."interval" IS 'Interval';


--
-- Name: COLUMN calendar_recurrence.count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.count IS 'Count';


--
-- Name: COLUMN calendar_recurrence.day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.day IS 'Day';


--
-- Name: COLUMN calendar_recurrence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_recurrence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_recurrence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.name IS 'Name';


--
-- Name: COLUMN calendar_recurrence.event_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.event_tz IS 'Timezone';


--
-- Name: COLUMN calendar_recurrence.rrule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule IS 'Rrule';


--
-- Name: COLUMN calendar_recurrence.rrule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule_type IS 'Rrule Type';


--
-- Name: COLUMN calendar_recurrence.end_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.end_type IS 'End Type';


--
-- Name: COLUMN calendar_recurrence.month_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.month_by IS 'Month By';


--
-- Name: COLUMN calendar_recurrence.weekday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.weekday IS 'Weekday';


--
-- Name: COLUMN calendar_recurrence.byday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.byday IS 'By day';


--
-- Name: COLUMN calendar_recurrence.until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.until IS 'Repeat Until';


--
-- Name: COLUMN calendar_recurrence.mon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.mon IS 'Mon';


--
-- Name: COLUMN calendar_recurrence.tue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.tue IS 'Tue';


--
-- Name: COLUMN calendar_recurrence.wed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.wed IS 'Wed';


--
-- Name: COLUMN calendar_recurrence.thu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.thu IS 'Thu';


--
-- Name: COLUMN calendar_recurrence.fri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.fri IS 'Fri';


--
-- Name: COLUMN calendar_recurrence.sat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sat IS 'Sat';


--
-- Name: COLUMN calendar_recurrence.sun; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sun IS 'Sun';


--
-- Name: COLUMN calendar_recurrence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_date IS 'Created on';


--
-- Name: COLUMN calendar_recurrence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT calendar_recurrence_month_day ON calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT calendar_recurrence_month_day ON public.calendar_recurrence IS 'CHECK (rrule_type != ''monthly'' OR month_by != ''day'' OR day >= 1 AND day <= 31 OR weekday in (''MON'', ''TUE'', ''WED'', ''THU'', ''FRI'', ''SAT'', ''SUN'') AND byday in (''1'', ''2'', ''3'', ''4'', ''-1''))';


--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_recurrence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_recurrence_id_seq OWNER TO runbot;

--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_recurrence_id_seq OWNED BY public.calendar_recurrence.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: comment_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.comment_wizard (
    id integer NOT NULL,
    res_id integer,
    create_uid integer,
    write_uid integer,
    validate_reject character varying,
    res_model character varying,
    comment character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.comment_wizard OWNER TO runbot;

--
-- Name: TABLE comment_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.comment_wizard IS 'Comment Wizard';


--
-- Name: COLUMN comment_wizard.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.comment_wizard.res_id IS 'Res';


--
-- Name: COLUMN comment_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.comment_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN comment_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.comment_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN comment_wizard.validate_reject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.comment_wizard.validate_reject IS 'Validate Reject';


--
-- Name: COLUMN comment_wizard.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.comment_wizard.res_model IS 'Res Model';


--
-- Name: COLUMN comment_wizard.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.comment_wizard.comment IS 'Comment';


--
-- Name: COLUMN comment_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.comment_wizard.create_date IS 'Created on';


--
-- Name: COLUMN comment_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.comment_wizard.write_date IS 'Last Updated on';


--
-- Name: comment_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.comment_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.comment_wizard_id_seq OWNER TO runbot;

--
-- Name: comment_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.comment_wizard_id_seq OWNED BY public.comment_wizard.id;


--
-- Name: comment_wizard_tier_review_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.comment_wizard_tier_review_rel (
    comment_wizard_id integer NOT NULL,
    tier_review_id integer NOT NULL
);


ALTER TABLE public.comment_wizard_tier_review_rel OWNER TO runbot;

--
-- Name: TABLE comment_wizard_tier_review_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.comment_wizard_tier_review_rel IS 'RELATION BETWEEN comment_wizard AND tier_review';


--
-- Name: crm_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_tag OWNER TO runbot;

--
-- Name: TABLE crm_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag IS 'CRM Tag';


--
-- Name: COLUMN crm_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.color IS 'Color';


--
-- Name: COLUMN crm_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.name IS 'Tag Name';


--
-- Name: COLUMN crm_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_date IS 'Created on';


--
-- Name: COLUMN crm_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_date IS 'Last Updated on';


--
-- Name: crm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_tag_id_seq OWNER TO runbot;

--
-- Name: crm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_tag_id_seq OWNED BY public.crm_tag.id;


--
-- Name: crm_team; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team (
    id integer NOT NULL,
    message_main_attachment_id integer,
    sequence integer,
    company_id integer,
    user_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_team OWNER TO runbot;

--
-- Name: TABLE crm_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team IS 'Sales Team';


--
-- Name: COLUMN crm_team.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN crm_team.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.sequence IS 'Sequence';


--
-- Name: COLUMN crm_team.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.company_id IS 'Company';


--
-- Name: COLUMN crm_team.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.user_id IS 'Team Leader';


--
-- Name: COLUMN crm_team.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.color IS 'Color Index';


--
-- Name: COLUMN crm_team.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.name IS 'Sales Team';


--
-- Name: COLUMN crm_team.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.active IS 'Active';


--
-- Name: COLUMN crm_team.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_date IS 'Created on';


--
-- Name: COLUMN crm_team.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_date IS 'Last Updated on';


--
-- Name: crm_team_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_id_seq OWNER TO runbot;

--
-- Name: crm_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_id_seq OWNED BY public.crm_team.id;


--
-- Name: crm_team_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team_member (
    id integer NOT NULL,
    message_main_attachment_id integer,
    crm_team_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_team_member OWNER TO runbot;

--
-- Name: TABLE crm_team_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team_member IS 'Sales Team Member';


--
-- Name: COLUMN crm_team_member.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN crm_team_member.crm_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.crm_team_id IS 'Sales Team';


--
-- Name: COLUMN crm_team_member.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_team_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team_member.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.active IS 'Active';


--
-- Name: COLUMN crm_team_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_date IS 'Created on';


--
-- Name: COLUMN crm_team_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_date IS 'Last Updated on';


--
-- Name: crm_team_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_member_id_seq OWNER TO runbot;

--
-- Name: crm_team_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_member_id_seq OWNED BY public.crm_team_member.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.email_template_attachment_rel OWNER TO runbot;

--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: employee_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.employee_category_rel (
    emp_id integer NOT NULL,
    category_id integer NOT NULL
);


ALTER TABLE public.employee_category_rel OWNER TO runbot;

--
-- Name: TABLE employee_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.employee_category_rel IS 'RELATION BETWEEN hr_employee AND hr_employee_category';


--
-- Name: exception_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.exception_rule (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    exception_type character varying NOT NULL,
    domain character varying,
    method character varying,
    name jsonb NOT NULL,
    description jsonb,
    code text,
    active boolean,
    is_blocking boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.exception_rule OWNER TO runbot;

--
-- Name: TABLE exception_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.exception_rule IS 'Exception Rule';


--
-- Name: COLUMN exception_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.sequence IS 'Sequence';


--
-- Name: COLUMN exception_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.create_uid IS 'Created by';


--
-- Name: COLUMN exception_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN exception_rule.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.model IS 'Apply on';


--
-- Name: COLUMN exception_rule.exception_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.exception_type IS 'Exception Type';


--
-- Name: COLUMN exception_rule.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.domain IS 'Domain';


--
-- Name: COLUMN exception_rule.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.method IS 'Method';


--
-- Name: COLUMN exception_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.name IS 'Exception Name';


--
-- Name: COLUMN exception_rule.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.description IS 'Description';


--
-- Name: COLUMN exception_rule.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.code IS 'Python Code';


--
-- Name: COLUMN exception_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.active IS 'Active';


--
-- Name: COLUMN exception_rule.is_blocking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.is_blocking IS 'Is Blocking';


--
-- Name: COLUMN exception_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.create_date IS 'Created on';


--
-- Name: COLUMN exception_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.exception_rule.write_date IS 'Last Updated on';


--
-- Name: exception_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.exception_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.exception_rule_id_seq OWNER TO runbot;

--
-- Name: exception_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.exception_rule_id_seq OWNED BY public.exception_rule.id;


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    port integer,
    object_id integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    server character varying,
    server_type character varying NOT NULL,
    "user" character varying,
    password character varying,
    script character varying,
    configuration text,
    active boolean,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_authorization_code character varying,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying
);


ALTER TABLE public.fetchmail_server OWNER TO runbot;

--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.google_gmail_authorization_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_authorization_code IS 'Authorization Code';


--
-- Name: COLUMN fetchmail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fetchmail_server_id_seq OWNER TO runbot;

--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: hr_contract_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_contract_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_contract_type OWNER TO runbot;

--
-- Name: TABLE hr_contract_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_contract_type IS 'Contract Type';


--
-- Name: COLUMN hr_contract_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_contract_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_contract_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_contract_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.name IS 'Name';


--
-- Name: COLUMN hr_contract_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_contract_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_date IS 'Last Updated on';


--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_contract_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_contract_type_id_seq OWNER TO runbot;

--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_contract_type_id_seq OWNED BY public.hr_contract_type.id;


--
-- Name: hr_department; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_department (
    id integer NOT NULL,
    message_main_attachment_id integer,
    company_id integer,
    parent_id integer,
    manager_id integer,
    color integer,
    master_department_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    parent_path character varying,
    note text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_department OWNER TO runbot;

--
-- Name: TABLE hr_department; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_department IS 'Department';


--
-- Name: COLUMN hr_department.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN hr_department.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.company_id IS 'Company';


--
-- Name: COLUMN hr_department.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_id IS 'Parent Department';


--
-- Name: COLUMN hr_department.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.manager_id IS 'Manager';


--
-- Name: COLUMN hr_department.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.color IS 'Color Index';


--
-- Name: COLUMN hr_department.master_department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.master_department_id IS 'Master Department';


--
-- Name: COLUMN hr_department.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_uid IS 'Created by';


--
-- Name: COLUMN hr_department.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_department.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.name IS 'Department Name';


--
-- Name: COLUMN hr_department.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.complete_name IS 'Complete Name';


--
-- Name: COLUMN hr_department.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_path IS 'Parent Path';


--
-- Name: COLUMN hr_department.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.note IS 'Note';


--
-- Name: COLUMN hr_department.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.active IS 'Active';


--
-- Name: COLUMN hr_department.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_date IS 'Created on';


--
-- Name: COLUMN hr_department.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_date IS 'Last Updated on';


--
-- Name: hr_department_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_department_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_department_id_seq OWNER TO runbot;

--
-- Name: hr_department_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_department_id_seq OWNED BY public.hr_department.id;


--
-- Name: hr_department_mail_channel_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_department_mail_channel_rel (
    mail_channel_id integer NOT NULL,
    hr_department_id integer NOT NULL
);


ALTER TABLE public.hr_department_mail_channel_rel OWNER TO runbot;

--
-- Name: TABLE hr_department_mail_channel_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_department_mail_channel_rel IS 'RELATION BETWEEN mail_channel AND hr_department';


--
-- Name: hr_departure_reason; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_reason (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_reason OWNER TO runbot;

--
-- Name: TABLE hr_departure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_reason IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_reason.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.sequence IS 'Sequence';


--
-- Name: COLUMN hr_departure_reason.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_reason.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_reason.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.name IS 'Reason';


--
-- Name: COLUMN hr_departure_reason.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_reason.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_date IS 'Last Updated on';


--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_reason_id_seq OWNER TO runbot;

--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_reason_id_seq OWNED BY public.hr_departure_reason.id;


--
-- Name: hr_departure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_wizard (
    id integer NOT NULL,
    departure_reason_id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    departure_date date NOT NULL,
    departure_description text,
    archive_private_address boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_wizard OWNER TO runbot;

--
-- Name: TABLE hr_departure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_wizard IS 'Departure Wizard';


--
-- Name: COLUMN hr_departure_wizard.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_wizard.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.employee_id IS 'Employee';


--
-- Name: COLUMN hr_departure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_wizard.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_date IS 'Departure Date';


--
-- Name: COLUMN hr_departure_wizard.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_departure_wizard.archive_private_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.archive_private_address IS 'Archive Private Address';


--
-- Name: COLUMN hr_departure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNED BY public.hr_departure_wizard.id;


--
-- Name: hr_employee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    company_id integer NOT NULL,
    resource_calendar_id integer,
    message_main_attachment_id integer,
    color integer,
    department_id integer,
    job_id integer,
    address_id integer,
    work_contact_id integer,
    work_location_id integer,
    user_id integer,
    parent_id integer,
    coach_id integer,
    address_home_id integer,
    country_id integer,
    children integer,
    country_of_birth integer,
    bank_account_id integer,
    km_home_work integer,
    departure_reason_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    job_title character varying,
    work_phone character varying,
    mobile_phone character varying,
    work_email character varying,
    employee_type character varying NOT NULL,
    gender character varying,
    marital character varying,
    spouse_complete_name character varying,
    place_of_birth character varying,
    ssnid character varying,
    sinid character varying,
    identification_id character varying,
    passport_id character varying,
    permit_no character varying,
    visa_no character varying,
    certificate character varying,
    study_field character varying,
    study_school character varying,
    emergency_contact character varying,
    emergency_phone character varying,
    barcode character varying,
    pin character varying,
    spouse_birthdate date,
    birthday date,
    visa_expire date,
    work_permit_expiration_date date,
    departure_date date,
    additional_note text,
    notes text,
    departure_description text,
    active boolean,
    work_permit_scheduled_activity boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee OWNER TO runbot;

--
-- Name: TABLE hr_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee IS 'Employee';


--
-- Name: COLUMN hr_employee.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.resource_id IS 'Resource';


--
-- Name: COLUMN hr_employee.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.company_id IS 'Company';


--
-- Name: COLUMN hr_employee.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN hr_employee.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN hr_employee.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.color IS 'Color Index';


--
-- Name: COLUMN hr_employee.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.department_id IS 'Department';


--
-- Name: COLUMN hr_employee.job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.job_id IS 'Job Position';


--
-- Name: COLUMN hr_employee.address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.address_id IS 'Work Address';


--
-- Name: COLUMN hr_employee.work_contact_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_contact_id IS 'Work Contact';


--
-- Name: COLUMN hr_employee.work_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_location_id IS 'Work Location';


--
-- Name: COLUMN hr_employee.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.user_id IS 'User';


--
-- Name: COLUMN hr_employee.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.parent_id IS 'Manager';


--
-- Name: COLUMN hr_employee.coach_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.coach_id IS 'Coach';


--
-- Name: COLUMN hr_employee.address_home_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.address_home_id IS 'Address';


--
-- Name: COLUMN hr_employee.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.country_id IS 'Nationality (Country)';


--
-- Name: COLUMN hr_employee.children; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.children IS 'Number of Dependent Children';


--
-- Name: COLUMN hr_employee.country_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.country_of_birth IS 'Country of Birth';


--
-- Name: COLUMN hr_employee.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.bank_account_id IS 'Bank Account Number';


--
-- Name: COLUMN hr_employee.km_home_work; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.km_home_work IS 'Home-Work Distance';


--
-- Name: COLUMN hr_employee.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_employee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.name IS 'Employee Name';


--
-- Name: COLUMN hr_employee.job_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.job_title IS 'Job Title';


--
-- Name: COLUMN hr_employee.work_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_phone IS 'Work Phone';


--
-- Name: COLUMN hr_employee.mobile_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.mobile_phone IS 'Work Mobile';


--
-- Name: COLUMN hr_employee.work_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_email IS 'Work Email';


--
-- Name: COLUMN hr_employee.employee_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.employee_type IS 'Employee Type';


--
-- Name: COLUMN hr_employee.gender; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.gender IS 'Gender';


--
-- Name: COLUMN hr_employee.marital; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.marital IS 'Marital Status';


--
-- Name: COLUMN hr_employee.spouse_complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.spouse_complete_name IS 'Spouse Complete Name';


--
-- Name: COLUMN hr_employee.place_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.place_of_birth IS 'Place of Birth';


--
-- Name: COLUMN hr_employee.ssnid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.ssnid IS 'SSN No';


--
-- Name: COLUMN hr_employee.sinid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.sinid IS 'SIN No';


--
-- Name: COLUMN hr_employee.identification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.identification_id IS 'Identification No';


--
-- Name: COLUMN hr_employee.passport_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.passport_id IS 'Passport No';


--
-- Name: COLUMN hr_employee.permit_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.permit_no IS 'Work Permit No';


--
-- Name: COLUMN hr_employee.visa_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_no IS 'Visa No';


--
-- Name: COLUMN hr_employee.certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.certificate IS 'Certificate Level';


--
-- Name: COLUMN hr_employee.study_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_field IS 'Field of Study';


--
-- Name: COLUMN hr_employee.study_school; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_school IS 'School';


--
-- Name: COLUMN hr_employee.emergency_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_contact IS 'Contact Name';


--
-- Name: COLUMN hr_employee.emergency_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_phone IS 'Contact Phone';


--
-- Name: COLUMN hr_employee.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.barcode IS 'Badge ID';


--
-- Name: COLUMN hr_employee.pin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.pin IS 'PIN';


--
-- Name: COLUMN hr_employee.spouse_birthdate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.spouse_birthdate IS 'Spouse Birthdate';


--
-- Name: COLUMN hr_employee.birthday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.birthday IS 'Date of Birth';


--
-- Name: COLUMN hr_employee.visa_expire; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_expire IS 'Visa Expiration Date';


--
-- Name: COLUMN hr_employee.work_permit_expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_expiration_date IS 'Work Permit Expiration Date';


--
-- Name: COLUMN hr_employee.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.departure_date IS 'Departure Date';


--
-- Name: COLUMN hr_employee.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.additional_note IS 'Additional Note';


--
-- Name: COLUMN hr_employee.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.notes IS 'Notes';


--
-- Name: COLUMN hr_employee.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_employee.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.active IS 'Active';


--
-- Name: COLUMN hr_employee.work_permit_scheduled_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_scheduled_activity IS 'Work Permit Scheduled Activity';


--
-- Name: COLUMN hr_employee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_date IS 'Last Updated on';


--
-- Name: hr_employee_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_category (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_category OWNER TO runbot;

--
-- Name: TABLE hr_employee_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_category IS 'Employee Category';


--
-- Name: COLUMN hr_employee_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.color IS 'Color Index';


--
-- Name: COLUMN hr_employee_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.name IS 'Tag Name';


--
-- Name: COLUMN hr_employee_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_date IS 'Last Updated on';


--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_category_id_seq OWNER TO runbot;

--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_category_id_seq OWNED BY public.hr_employee_category.id;


--
-- Name: hr_employee_hr_plan_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_plan_wizard_rel (
    employee_id integer NOT NULL,
    plan_wizard_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_plan_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_plan_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_plan_wizard_rel IS 'RELATION BETWEEN hr_plan_wizard AND hr_employee';


--
-- Name: hr_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_id_seq OWNER TO runbot;

--
-- Name: hr_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_id_seq OWNED BY public.hr_employee.id;


--
-- Name: hr_employee_public; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_public AS
 SELECT name,
    active,
    color,
    department_id,
    job_id,
    job_title,
    company_id,
    address_id,
    work_phone,
    mobile_phone,
    work_email,
    work_contact_id,
    work_location_id,
    user_id,
    resource_id,
    resource_calendar_id,
    parent_id,
    coach_id,
    employee_type,
    create_date,
    id,
    create_uid,
    write_uid,
    write_date
   FROM public.hr_employee emp;


ALTER VIEW public.hr_employee_public OWNER TO runbot;

--
-- Name: hr_job; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_job (
    id integer NOT NULL,
    message_main_attachment_id integer,
    sequence integer,
    expected_employees integer,
    no_of_employee integer,
    no_of_recruitment integer,
    no_of_hired_employee integer,
    department_id integer,
    company_id integer,
    contract_type_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description text,
    requirements text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_job_no_of_recruitment_positive CHECK ((no_of_recruitment >= 0))
);


ALTER TABLE public.hr_job OWNER TO runbot;

--
-- Name: TABLE hr_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_job IS 'Job Position';


--
-- Name: COLUMN hr_job.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN hr_job.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.sequence IS 'Sequence';


--
-- Name: COLUMN hr_job.expected_employees; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.expected_employees IS 'Total Forecasted Employees';


--
-- Name: COLUMN hr_job.no_of_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.no_of_employee IS 'Current Number of Employees';


--
-- Name: COLUMN hr_job.no_of_recruitment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.no_of_recruitment IS 'Target';


--
-- Name: COLUMN hr_job.no_of_hired_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.no_of_hired_employee IS 'Hired Employees';


--
-- Name: COLUMN hr_job.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.department_id IS 'Department';


--
-- Name: COLUMN hr_job.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.company_id IS 'Company';


--
-- Name: COLUMN hr_job.contract_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.contract_type_id IS 'Employment Type';


--
-- Name: COLUMN hr_job.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.create_uid IS 'Created by';


--
-- Name: COLUMN hr_job.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_job.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.name IS 'Job Position';


--
-- Name: COLUMN hr_job.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.description IS 'Job Description';


--
-- Name: COLUMN hr_job.requirements; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.requirements IS 'Requirements';


--
-- Name: COLUMN hr_job.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.active IS 'Active';


--
-- Name: COLUMN hr_job.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.create_date IS 'Created on';


--
-- Name: COLUMN hr_job.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_job_no_of_recruitment_positive ON hr_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_job_no_of_recruitment_positive ON public.hr_job IS 'CHECK(no_of_recruitment >= 0)';


--
-- Name: hr_job_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_job_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_job_id_seq OWNER TO runbot;

--
-- Name: hr_job_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_job_id_seq OWNED BY public.hr_job.id;


--
-- Name: hr_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_plan (
    id integer NOT NULL,
    company_id integer,
    department_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_plan OWNER TO runbot;

--
-- Name: TABLE hr_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_plan IS 'plan';


--
-- Name: COLUMN hr_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan.company_id IS 'Company';


--
-- Name: COLUMN hr_plan.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan.department_id IS 'Department';


--
-- Name: COLUMN hr_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan.create_uid IS 'Created by';


--
-- Name: COLUMN hr_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan.name IS 'Name';


--
-- Name: COLUMN hr_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan.active IS 'Active';


--
-- Name: COLUMN hr_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan.create_date IS 'Created on';


--
-- Name: COLUMN hr_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan.write_date IS 'Last Updated on';


--
-- Name: hr_plan_activity_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_plan_activity_type (
    id integer NOT NULL,
    company_id integer,
    activity_type_id integer,
    responsible_id integer,
    plan_id integer,
    create_uid integer,
    write_uid integer,
    summary character varying,
    responsible character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_plan_activity_type OWNER TO runbot;

--
-- Name: TABLE hr_plan_activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_plan_activity_type IS 'Plan activity type';


--
-- Name: COLUMN hr_plan_activity_type.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_activity_type.company_id IS 'Company';


--
-- Name: COLUMN hr_plan_activity_type.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_activity_type.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN hr_plan_activity_type.responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_activity_type.responsible_id IS 'Other Responsible';


--
-- Name: COLUMN hr_plan_activity_type.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_activity_type.plan_id IS 'Plan';


--
-- Name: COLUMN hr_plan_activity_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_activity_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_plan_activity_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_activity_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_plan_activity_type.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_activity_type.summary IS 'Summary';


--
-- Name: COLUMN hr_plan_activity_type.responsible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_activity_type.responsible IS 'Responsible';


--
-- Name: COLUMN hr_plan_activity_type.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_activity_type.note IS 'Note';


--
-- Name: COLUMN hr_plan_activity_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_activity_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_plan_activity_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_activity_type.write_date IS 'Last Updated on';


--
-- Name: hr_plan_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_plan_activity_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_plan_activity_type_id_seq OWNER TO runbot;

--
-- Name: hr_plan_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_plan_activity_type_id_seq OWNED BY public.hr_plan_activity_type.id;


--
-- Name: hr_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_plan_id_seq OWNER TO runbot;

--
-- Name: hr_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_plan_id_seq OWNED BY public.hr_plan.id;


--
-- Name: hr_plan_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_plan_wizard (
    id integer NOT NULL,
    plan_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_plan_wizard OWNER TO runbot;

--
-- Name: TABLE hr_plan_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_plan_wizard IS 'Plan Wizard';


--
-- Name: COLUMN hr_plan_wizard.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_wizard.plan_id IS 'Plan';


--
-- Name: COLUMN hr_plan_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_plan_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_plan_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_plan_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_plan_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_plan_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_plan_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_plan_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_plan_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_plan_wizard_id_seq OWNED BY public.hr_plan_wizard.id;


--
-- Name: hr_work_location; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_work_location (
    id integer NOT NULL,
    company_id integer NOT NULL,
    address_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location_number character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_work_location OWNER TO runbot;

--
-- Name: TABLE hr_work_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_work_location IS 'Work Location';


--
-- Name: COLUMN hr_work_location.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.company_id IS 'Company';


--
-- Name: COLUMN hr_work_location.address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.address_id IS 'Work Address';


--
-- Name: COLUMN hr_work_location.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.create_uid IS 'Created by';


--
-- Name: COLUMN hr_work_location.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_work_location.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.name IS 'Work Location';


--
-- Name: COLUMN hr_work_location.location_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.location_number IS 'Location Number';


--
-- Name: COLUMN hr_work_location.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.active IS 'Active';


--
-- Name: COLUMN hr_work_location.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.create_date IS 'Created on';


--
-- Name: COLUMN hr_work_location.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.write_date IS 'Last Updated on';


--
-- Name: hr_work_location_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_work_location_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_work_location_id_seq OWNER TO runbot;

--
-- Name: hr_work_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_work_location_id_seq OWNED BY public.hr_work_location.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    service_name character varying,
    account_token character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.service_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_name IS 'Service Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    crud_model_id integer,
    link_field_id integer,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    model_name character varying,
    code text,
    mass_edit_message text,
    template_id integer,
    activity_type_id integer,
    activity_date_deadline_range integer,
    activity_user_id integer,
    mail_post_method character varying,
    activity_summary character varying,
    activity_date_deadline_range_type character varying,
    activity_user_type character varying,
    activity_user_field_name character varying,
    activity_note text,
    mail_post_autofollow boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Target Model';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Action To Do';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.mass_edit_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mass_edit_message IS 'Message';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_type_id IS 'Activity';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN ir_act_server.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_id IS 'Responsible';


--
-- Name: COLUMN ir_act_server.mail_post_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_method IS 'Send as';


--
-- Name: COLUMN ir_act_server.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_summary IS 'Summary';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN ir_act_server.activity_user_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_type IS 'Activity User Type';


--
-- Name: COLUMN ir_act_server.activity_user_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_field_name IS 'User field name';


--
-- Name: COLUMN ir_act_server.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_note IS 'Note';


--
-- Name: COLUMN ir_act_server.mail_post_autofollow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_autofollow IS 'Subscribe Recipients';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_res_partner_rel (
    ir_act_server_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_res_partner_rel IS 'RELATION BETWEEN ir_act_server AND res_partner';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    usage character varying,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_server_mass_edit_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_server_mass_edit_line (
    id integer NOT NULL,
    sequence integer,
    server_action_id integer NOT NULL,
    field_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    widget_option character varying,
    apply_domain boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_server_mass_edit_line OWNER TO runbot;

--
-- Name: TABLE ir_actions_server_mass_edit_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_server_mass_edit_line IS 'Server Actions Mass Edit Lines';


--
-- Name: COLUMN ir_actions_server_mass_edit_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_mass_edit_line.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_server_mass_edit_line.server_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_mass_edit_line.server_action_id IS 'Server Action';


--
-- Name: COLUMN ir_actions_server_mass_edit_line.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_mass_edit_line.field_id IS 'Field';


--
-- Name: COLUMN ir_actions_server_mass_edit_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_mass_edit_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_server_mass_edit_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_mass_edit_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_server_mass_edit_line.widget_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_mass_edit_line.widget_option IS 'Widget Option';


--
-- Name: COLUMN ir_actions_server_mass_edit_line.apply_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_mass_edit_line.apply_domain IS 'Apply Domain';


--
-- Name: COLUMN ir_actions_server_mass_edit_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_mass_edit_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_server_mass_edit_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_mass_edit_line.write_date IS 'Last Updated on';


--
-- Name: ir_actions_server_mass_edit_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_server_mass_edit_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_server_mass_edit_line_id_seq OWNER TO runbot;

--
-- Name: ir_actions_server_mass_edit_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_server_mass_edit_line_id_seq OWNED BY public.ir_actions_server_mass_edit_line.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer,
    numbercall integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    interval_type character varying,
    cron_name jsonb,
    active boolean,
    doall boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.numbercall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.numbercall IS 'Number of Calls';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.doall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.doall IS 'Repeat Missed';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    json_value character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default.json_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.json_value IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    user_id integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    sort text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying NOT NULL,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    google_gmail_access_token_expiration integer,
    google_gmail_authorization_code character varying,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.google_gmail_authorization_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_authorization_code IS 'Authorization Code';


--
-- Name: COLUMN ir_mail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    name jsonb NOT NULL,
    info text,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_mail_thread boolean,
    is_mail_activity boolean,
    is_mail_blacklist boolean
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model.is_mail_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_thread IS 'Has Mail Thread';


--
-- Name: COLUMN ir_model.is_mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_activity IS 'Has Mail Activity';


--
-- Name: COLUMN ir_model.is_mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_blacklist IS 'Has Mail Blacklist';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    tracking integer,
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.tracking IS 'Enable Ordered Tracking';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_fields_tier_validation_exception_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_tier_validation_exception_rel (
    tier_validation_exception_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_tier_validation_exception_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_tier_validation_exception_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_tier_validation_exception_rel IS 'RELATION BETWEEN tier_validation_exception AND ir_model_fields';


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    create_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_property; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_property (
    id integer NOT NULL,
    company_id integer,
    fields_id integer NOT NULL,
    value_integer integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    res_id character varying,
    value_reference character varying,
    type character varying NOT NULL,
    value_text text,
    value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value_float double precision,
    value_binary bytea
);


ALTER TABLE public.ir_property OWNER TO runbot;

--
-- Name: TABLE ir_property; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_property IS 'Company Property';


--
-- Name: COLUMN ir_property.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.company_id IS 'Company';


--
-- Name: COLUMN ir_property.fields_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.fields_id IS 'Field';


--
-- Name: COLUMN ir_property.value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_integer IS 'Value Integer';


--
-- Name: COLUMN ir_property.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_uid IS 'Created by';


--
-- Name: COLUMN ir_property.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_property.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.name IS 'Name';


--
-- Name: COLUMN ir_property.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.res_id IS 'Resource';


--
-- Name: COLUMN ir_property.value_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_reference IS 'Value Reference';


--
-- Name: COLUMN ir_property.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.type IS 'Type';


--
-- Name: COLUMN ir_property.value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_text IS 'Value Text';


--
-- Name: COLUMN ir_property.value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_datetime IS 'Value Datetime';


--
-- Name: COLUMN ir_property.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.create_date IS 'Created on';


--
-- Name: COLUMN ir_property.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_property.value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_float IS 'Value Float';


--
-- Name: COLUMN ir_property.value_binary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_property.value_binary IS 'Value Binary';


--
-- Name: ir_property_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_property_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_property_id_seq OWNER TO runbot;

--
-- Name: ir_property_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_property_id_seq OWNED BY public.ir_property.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Apply for Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Apply for Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Apply for Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Apply for Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_server_object_lines; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_server_object_lines (
    id integer NOT NULL,
    server_id integer,
    col1 integer NOT NULL,
    create_uid integer,
    write_uid integer,
    evaluation_type character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_server_object_lines OWNER TO runbot;

--
-- Name: TABLE ir_server_object_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_server_object_lines IS 'Server Action value mapping';


--
-- Name: COLUMN ir_server_object_lines.server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.server_id IS 'Related Server Action';


--
-- Name: COLUMN ir_server_object_lines.col1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.col1 IS 'Field';


--
-- Name: COLUMN ir_server_object_lines.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.create_uid IS 'Created by';


--
-- Name: COLUMN ir_server_object_lines.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_server_object_lines.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.evaluation_type IS 'Evaluation Type';


--
-- Name: COLUMN ir_server_object_lines.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.value IS 'Value';


--
-- Name: COLUMN ir_server_object_lines.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.create_date IS 'Created on';


--
-- Name: COLUMN ir_server_object_lines.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_server_object_lines.write_date IS 'Last Updated on';


--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_server_object_lines_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_server_object_lines_id_seq OWNER TO runbot;

--
-- Name: ir_server_object_lines_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_server_object_lines_id_seq OWNED BY public.ir_server_object_lines.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    field_parent character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.field_parent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.field_parent IS 'Child Field';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: mail_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity (
    id integer NOT NULL,
    res_model_id integer NOT NULL,
    res_id integer,
    activity_type_id integer,
    user_id integer NOT NULL,
    request_partner_id integer,
    recommended_activity_type_id integer,
    previous_activity_type_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    res_name character varying,
    summary character varying,
    date_deadline date NOT NULL,
    note text,
    automated boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    calendar_event_id integer,
    CONSTRAINT mail_activity_check_res_id_is_set CHECK (((res_id IS NOT NULL) AND (res_id <> 0)))
);


ALTER TABLE public.mail_activity OWNER TO runbot;

--
-- Name: TABLE mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity IS 'Activity';


--
-- Name: COLUMN mail_activity.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model_id IS 'Document Model';


--
-- Name: COLUMN mail_activity.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_activity.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity.request_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.request_partner_id IS 'Requesting Partner';


--
-- Name: COLUMN mail_activity.recommended_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.recommended_activity_type_id IS 'Recommended Activity Type';


--
-- Name: COLUMN mail_activity.previous_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.previous_activity_type_id IS 'Previous Activity Type';


--
-- Name: COLUMN mail_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_activity.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_name IS 'Document Name';


--
-- Name: COLUMN mail_activity.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.summary IS 'Summary';


--
-- Name: COLUMN mail_activity.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.note IS 'Note';


--
-- Name: COLUMN mail_activity.automated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.automated IS 'Automated activity';


--
-- Name: COLUMN mail_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_activity.calendar_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.calendar_event_id IS 'Calendar Meeting';


--
-- Name: CONSTRAINT mail_activity_check_res_id_is_set ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_res_id_is_set ON public.mail_activity IS 'CHECK(res_id IS NOT NULL AND res_id !=0 )';


--
-- Name: mail_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_id_seq OWNER TO runbot;

--
-- Name: mail_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_id_seq OWNED BY public.mail_activity.id;


--
-- Name: mail_activity_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_rel (
    activity_id integer NOT NULL,
    recommended_id integer NOT NULL
);


ALTER TABLE public.mail_activity_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_rel IS 'RELATION BETWEEN mail_activity_type AND mail_activity_type';


--
-- Name: mail_activity_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    delay_count integer,
    triggered_next_type_id integer,
    default_user_id integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    icon character varying,
    decoration_type character varying,
    res_model character varying,
    chaining_type character varying NOT NULL,
    category character varying,
    name jsonb NOT NULL,
    summary jsonb,
    default_note jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_type OWNER TO runbot;

--
-- Name: TABLE mail_activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type IS 'Activity Type';


--
-- Name: COLUMN mail_activity_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_uid IS 'Create Uid';


--
-- Name: COLUMN mail_activity_type.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_count IS 'Schedule';


--
-- Name: COLUMN mail_activity_type.triggered_next_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.triggered_next_type_id IS 'Trigger';


--
-- Name: COLUMN mail_activity_type.default_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_user_id IS 'Default User';


--
-- Name: COLUMN mail_activity_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_type.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_type.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_from IS 'Delay Type';


--
-- Name: COLUMN mail_activity_type.icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.icon IS 'Icon';


--
-- Name: COLUMN mail_activity_type.decoration_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.decoration_type IS 'Decoration Type';


--
-- Name: COLUMN mail_activity_type.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_type.chaining_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.chaining_type IS 'Chaining Type';


--
-- Name: COLUMN mail_activity_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.category IS 'Action';


--
-- Name: COLUMN mail_activity_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.name IS 'Name';


--
-- Name: COLUMN mail_activity_type.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.summary IS 'Default Summary';


--
-- Name: COLUMN mail_activity_type.default_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_note IS 'Default Note';


--
-- Name: COLUMN mail_activity_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.active IS 'Active';


--
-- Name: COLUMN mail_activity_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_date IS 'Last Updated on';


--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_type_id_seq OWNER TO runbot;

--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_type_id_seq OWNED BY public.mail_activity_type.id;


--
-- Name: mail_activity_type_mail_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type_mail_template_rel (
    mail_activity_type_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_activity_type_mail_template_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_type_mail_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type_mail_template_rel IS 'RELATION BETWEEN mail_activity_type AND mail_template';


--
-- Name: mail_alias; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias (
    id integer NOT NULL,
    alias_model_id integer NOT NULL,
    alias_user_id integer,
    alias_force_thread_id integer,
    alias_parent_model_id integer,
    alias_parent_thread_id integer,
    create_uid integer,
    write_uid integer,
    alias_name character varying,
    alias_contact character varying NOT NULL,
    alias_bounced_content jsonb,
    alias_defaults text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias OWNER TO runbot;

--
-- Name: TABLE mail_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias IS 'Email Aliases';


--
-- Name: COLUMN mail_alias.alias_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_model_id IS 'Aliased Model';


--
-- Name: COLUMN mail_alias.alias_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_user_id IS 'Owner';


--
-- Name: COLUMN mail_alias.alias_force_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_force_thread_id IS 'Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_parent_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_model_id IS 'Parent Model';


--
-- Name: COLUMN mail_alias.alias_parent_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_thread_id IS 'Parent Record Thread ID';


--
-- Name: COLUMN mail_alias.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias.alias_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_name IS 'Alias Name';


--
-- Name: COLUMN mail_alias.alias_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_contact IS 'Alias Contact Security';


--
-- Name: COLUMN mail_alias.alias_bounced_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_bounced_content IS 'Custom Bounced Message';


--
-- Name: COLUMN mail_alias.alias_defaults; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_defaults IS 'Default Values';


--
-- Name: COLUMN mail_alias.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_date IS 'Last Updated on';


--
-- Name: mail_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_id_seq OWNER TO runbot;

--
-- Name: mail_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_id_seq OWNED BY public.mail_alias.id;


--
-- Name: mail_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist (
    id integer NOT NULL,
    message_main_attachment_id integer,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist OWNER TO runbot;

--
-- Name: TABLE mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist IS 'Mail Blacklist';


--
-- Name: COLUMN mail_blacklist.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN mail_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.email IS 'Email Address';


--
-- Name: COLUMN mail_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.active IS 'Active';


--
-- Name: COLUMN mail_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_id_seq OWNED BY public.mail_blacklist.id;


--
-- Name: mail_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE mail_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist_remove IS 'Remove email from blacklist wizard';


--
-- Name: COLUMN mail_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist_remove.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.email IS 'Email';


--
-- Name: COLUMN mail_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN mail_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNED BY public.mail_blacklist_remove.id;


--
-- Name: mail_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_channel (
    id integer NOT NULL,
    message_main_attachment_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    uuid character varying(50),
    description text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT mail_channel_channel_type_not_null CHECK ((channel_type IS NOT NULL)),
    CONSTRAINT mail_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR (group_public_id IS NULL)))
);


ALTER TABLE public.mail_channel OWNER TO runbot;

--
-- Name: TABLE mail_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_channel IS 'Discussion Channel';


--
-- Name: COLUMN mail_channel.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN mail_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN mail_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.create_uid IS 'Created by';


--
-- Name: COLUMN mail_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.name IS 'Name';


--
-- Name: COLUMN mail_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN mail_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN mail_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.uuid IS 'UUID';


--
-- Name: COLUMN mail_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.description IS 'Description';


--
-- Name: COLUMN mail_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.active IS 'Active';


--
-- Name: COLUMN mail_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.create_date IS 'Created on';


--
-- Name: COLUMN mail_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT mail_channel_channel_type_not_null ON mail_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_channel_channel_type_not_null ON public.mail_channel IS 'CHECK(channel_type IS NOT NULL)';


--
-- Name: CONSTRAINT mail_channel_group_public_id_check ON mail_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_channel_group_public_id_check ON public.mail_channel IS 'CHECK (channel_type = ''channel'' OR group_public_id IS NULL)';


--
-- Name: mail_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_channel_id_seq OWNER TO runbot;

--
-- Name: mail_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_channel_id_seq OWNED BY public.mail_channel.id;


--
-- Name: mail_channel_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    fold_state character varying,
    is_minimized boolean,
    is_pinned boolean,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT mail_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_channel_member OWNER TO runbot;

--
-- Name: TABLE mail_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_channel_member IS 'Listeners of a Channel';


--
-- Name: COLUMN mail_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.partner_id IS 'Recipient';


--
-- Name: COLUMN mail_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN mail_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN mail_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN mail_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN mail_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN mail_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN mail_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN mail_channel_member.fold_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.fold_state IS 'Conversation Fold State';


--
-- Name: COLUMN mail_channel_member.is_minimized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.is_minimized IS 'Conversation is minimized';


--
-- Name: COLUMN mail_channel_member.is_pinned; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.is_pinned IS 'Is pinned on the interface';


--
-- Name: COLUMN mail_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN mail_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN mail_channel_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN mail_channel_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_member.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT mail_channel_member_partner_or_guest_exists ON mail_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_channel_member_partner_or_guest_exists ON public.mail_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_channel_member_id_seq OWNER TO runbot;

--
-- Name: mail_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_channel_member_id_seq OWNED BY public.mail_channel_member.id;


--
-- Name: mail_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_channel_res_groups_rel (
    mail_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.mail_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE mail_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_channel_res_groups_rel IS 'RELATION BETWEEN mail_channel AND res_groups';


--
-- Name: mail_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.mail_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE mail_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN mail_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN mail_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN mail_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN mail_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN mail_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN mail_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN mail_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN mail_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN mail_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_channel_rtc_session.create_date IS 'Created on';


--
-- Name: mail_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: mail_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_channel_rtc_session_id_seq OWNED BY public.mail_channel_rtc_session.id;


--
-- Name: mail_compose_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message (
    id integer NOT NULL,
    template_id integer,
    parent_id integer,
    author_id integer,
    res_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    email_layout_xmlid character varying,
    email_from character varying,
    composition_mode character varying,
    model character varying,
    record_name character varying,
    message_type character varying NOT NULL,
    reply_to character varying,
    body text,
    active_domain text,
    email_add_signature boolean,
    use_active_domain boolean,
    is_log boolean,
    notify boolean,
    reply_to_force_new boolean,
    auto_delete boolean,
    auto_delete_message boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_compose_message OWNER TO runbot;

--
-- Name: TABLE mail_compose_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message IS 'Email composition wizard';


--
-- Name: COLUMN mail_compose_message.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_id IS 'Use template';


--
-- Name: COLUMN mail_compose_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_compose_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.author_id IS 'Author';


--
-- Name: COLUMN mail_compose_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_compose_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_compose_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_compose_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_compose_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_compose_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_compose_message.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.lang IS 'Language';


--
-- Name: COLUMN mail_compose_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subject IS 'Subject';


--
-- Name: COLUMN mail_compose_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_compose_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_from IS 'From';


--
-- Name: COLUMN mail_compose_message.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_mode IS 'Composition mode';


--
-- Name: COLUMN mail_compose_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_compose_message.record_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_compose_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.message_type IS 'Type';


--
-- Name: COLUMN mail_compose_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_compose_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.body IS 'Contents';


--
-- Name: COLUMN mail_compose_message.active_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.active_domain IS 'Active domain';


--
-- Name: COLUMN mail_compose_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_compose_message.use_active_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.use_active_domain IS 'Use active domain';


--
-- Name: COLUMN mail_compose_message.is_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.is_log IS 'Log as Internal Note';


--
-- Name: COLUMN mail_compose_message.notify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify IS 'Notify followers';


--
-- Name: COLUMN mail_compose_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to_force_new IS 'Considers answers as new thread';


--
-- Name: COLUMN mail_compose_message.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete IS 'Delete Emails';


--
-- Name: COLUMN mail_compose_message.auto_delete_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete_message IS 'Delete Message Copy';


--
-- Name: COLUMN mail_compose_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_compose_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_date IS 'Last Updated on';


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_compose_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_compose_message_id_seq OWNER TO runbot;

--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_compose_message_id_seq OWNED BY public.mail_compose_message.id;


--
-- Name: mail_compose_message_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_ir_attachments_rel (
    wizard_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_ir_attachments_rel IS 'RELATION BETWEEN mail_compose_message AND ir_attachment';


--
-- Name: mail_compose_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_res_partner_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_res_partner_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_followers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers (
    id integer NOT NULL,
    res_id integer,
    partner_id integer NOT NULL,
    res_model character varying NOT NULL
);


ALTER TABLE public.mail_followers OWNER TO runbot;

--
-- Name: TABLE mail_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers IS 'Document Followers';


--
-- Name: COLUMN mail_followers.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_followers.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.partner_id IS 'Related Partner';


--
-- Name: COLUMN mail_followers.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_model IS 'Related Document Model Name';


--
-- Name: mail_followers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_id_seq OWNER TO runbot;

--
-- Name: mail_followers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_id_seq OWNED BY public.mail_followers.id;


--
-- Name: mail_followers_mail_message_subtype_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_mail_message_subtype_rel (
    mail_followers_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


ALTER TABLE public.mail_followers_mail_message_subtype_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_mail_message_subtype_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_mail_message_subtype_rel IS 'RELATION BETWEEN mail_followers AND mail_message_subtype';


--
-- Name: mail_gateway_allowed; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_gateway_allowed (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying,
    email_normalized character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_gateway_allowed OWNER TO runbot;

--
-- Name: TABLE mail_gateway_allowed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_gateway_allowed IS 'Mail Gateway Allowed';


--
-- Name: COLUMN mail_gateway_allowed.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_uid IS 'Created by';


--
-- Name: COLUMN mail_gateway_allowed.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_gateway_allowed.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email IS 'Email Address';


--
-- Name: COLUMN mail_gateway_allowed.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN mail_gateway_allowed.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_date IS 'Created on';


--
-- Name: COLUMN mail_gateway_allowed.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_date IS 'Last Updated on';


--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_gateway_allowed_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNER TO runbot;

--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNED BY public.mail_gateway_allowed.id;


--
-- Name: mail_guest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_guest (
    id integer NOT NULL,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    access_token character varying NOT NULL,
    lang character varying,
    timezone character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_guest OWNER TO runbot;

--
-- Name: TABLE mail_guest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_guest IS 'Guest';


--
-- Name: COLUMN mail_guest.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.country_id IS 'Country';


--
-- Name: COLUMN mail_guest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_uid IS 'Created by';


--
-- Name: COLUMN mail_guest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_guest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.name IS 'Name';


--
-- Name: COLUMN mail_guest.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.access_token IS 'Access Token';


--
-- Name: COLUMN mail_guest.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.lang IS 'Language';


--
-- Name: COLUMN mail_guest.timezone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.timezone IS 'Timezone';


--
-- Name: COLUMN mail_guest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_date IS 'Created on';


--
-- Name: COLUMN mail_guest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_date IS 'Last Updated on';


--
-- Name: mail_guest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_guest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_guest_id_seq OWNER TO runbot;

--
-- Name: mail_guest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_guest_id_seq OWNED BY public.mail_guest.id;


--
-- Name: mail_ice_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_ice_server (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_type character varying NOT NULL,
    uri character varying NOT NULL,
    username character varying,
    credential character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_ice_server OWNER TO runbot;

--
-- Name: TABLE mail_ice_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_ice_server IS 'ICE server';


--
-- Name: COLUMN mail_ice_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_uid IS 'Created by';


--
-- Name: COLUMN mail_ice_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_ice_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.server_type IS 'Type';


--
-- Name: COLUMN mail_ice_server.uri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.uri IS 'URI';


--
-- Name: COLUMN mail_ice_server.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.username IS 'Username';


--
-- Name: COLUMN mail_ice_server.credential; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.credential IS 'Credential';


--
-- Name: COLUMN mail_ice_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_date IS 'Created on';


--
-- Name: COLUMN mail_ice_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_date IS 'Last Updated on';


--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_ice_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_ice_server_id_seq OWNER TO runbot;

--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_ice_server_id_seq OWNED BY public.mail_ice_server.id;


--
-- Name: mail_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_link_preview (
    id integer NOT NULL,
    message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_url character varying NOT NULL,
    og_type character varying,
    og_title character varying,
    og_image character varying,
    og_mimetype character varying,
    image_mimetype character varying,
    og_description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_link_preview IS 'Store link preview data';


--
-- Name: COLUMN mail_link_preview.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.message_id IS 'Message';


--
-- Name: COLUMN mail_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_link_preview.source_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.source_url IS 'URL';


--
-- Name: COLUMN mail_link_preview.og_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_type IS 'Type';


--
-- Name: COLUMN mail_link_preview.og_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_title IS 'Title';


--
-- Name: COLUMN mail_link_preview.og_image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_image IS 'Image';


--
-- Name: COLUMN mail_link_preview.og_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_mimetype IS 'MIME type';


--
-- Name: COLUMN mail_link_preview.image_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.image_mimetype IS 'Image MIME type';


--
-- Name: COLUMN mail_link_preview.og_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_description IS 'Description';


--
-- Name: COLUMN mail_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_date IS 'Create Date';


--
-- Name: COLUMN mail_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_link_preview_id_seq OWNED BY public.mail_link_preview.id;


--
-- Name: mail_mail; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    fetchmail_server_id integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    state character varying,
    failure_type character varying,
    body_html text,
    "references" text,
    headers text,
    email_to text,
    failure_reason text,
    is_notification boolean,
    auto_delete boolean,
    to_delete boolean,
    scheduled_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_mail OWNER TO runbot;

--
-- Name: TABLE mail_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail IS 'Outgoing Mails';


--
-- Name: COLUMN mail_mail.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_mail.fetchmail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.fetchmail_server_id IS 'Inbound Mail Server';


--
-- Name: COLUMN mail_mail.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_uid IS 'Created by';


--
-- Name: COLUMN mail_mail.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_mail.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_cc IS 'Cc';


--
-- Name: COLUMN mail_mail.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.state IS 'Status';


--
-- Name: COLUMN mail_mail.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_mail.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.body_html IS 'Text Contents';


--
-- Name: COLUMN mail_mail."references"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail."references" IS 'References';


--
-- Name: COLUMN mail_mail.headers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.headers IS 'Headers';


--
-- Name: COLUMN mail_mail.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_to IS 'To';


--
-- Name: COLUMN mail_mail.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_reason IS 'Failure Reason';


--
-- Name: COLUMN mail_mail.is_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.is_notification IS 'Notification Email';


--
-- Name: COLUMN mail_mail.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_mail.to_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.to_delete IS 'To Delete';


--
-- Name: COLUMN mail_mail.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.scheduled_date IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_mail.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_date IS 'Created on';


--
-- Name: COLUMN mail_mail.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_date IS 'Last Updated on';


--
-- Name: mail_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_mail_id_seq OWNER TO runbot;

--
-- Name: mail_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_mail_id_seq OWNED BY public.mail_mail.id;


--
-- Name: mail_mail_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail_res_partner_rel (
    mail_mail_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_mail_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_mail_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail_res_partner_rel IS 'RELATION BETWEEN mail_mail AND res_partner';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    parent_id integer,
    res_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    author_id integer,
    author_guest_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying,
    record_name character varying,
    message_type character varying NOT NULL,
    email_from character varying,
    message_id character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    body text,
    is_internal boolean,
    reply_to_force_new boolean,
    email_add_signature boolean,
    date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message OWNER TO runbot;

--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.record_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: mail_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_id_seq OWNER TO runbot;

--
-- Name: mail_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_id_seq OWNED BY public.mail_message.id;


--
-- Name: mail_message_reaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_reaction (
    id integer NOT NULL,
    message_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    content character varying NOT NULL,
    CONSTRAINT mail_message_reaction_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_message_reaction OWNER TO runbot;

--
-- Name: TABLE mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_reaction IS 'Message Reaction';


--
-- Name: COLUMN mail_message_reaction.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.message_id IS 'Message';


--
-- Name: COLUMN mail_message_reaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.partner_id IS 'Reacting Partner';


--
-- Name: COLUMN mail_message_reaction.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.guest_id IS 'Reacting Guest';


--
-- Name: COLUMN mail_message_reaction.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.content IS 'Content';


--
-- Name: CONSTRAINT mail_message_reaction_partner_or_guest_exists ON mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_message_reaction_partner_or_guest_exists ON public.mail_message_reaction IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_reaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_reaction_id_seq OWNER TO runbot;

--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_reaction_id_seq OWNED BY public.mail_message_reaction.id;


--
-- Name: mail_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_starred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_starred_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_starred_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_starred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_starred_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_schedule (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    notification_parameters text,
    scheduled_datetime timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_schedule OWNER TO runbot;

--
-- Name: TABLE mail_message_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_schedule IS 'Scheduled Messages';


--
-- Name: COLUMN mail_message_schedule.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_message_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_schedule.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.notification_parameters IS 'Notification Parameter';


--
-- Name: COLUMN mail_message_schedule.scheduled_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.scheduled_datetime IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_message_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_schedule_id_seq OWNED BY public.mail_message_schedule.id;


--
-- Name: mail_message_subtype; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_subtype (
    id integer NOT NULL,
    parent_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    relation_field character varying,
    res_model character varying,
    name jsonb NOT NULL,
    description jsonb,
    internal boolean,
    "default" boolean,
    hidden boolean,
    track_recipients boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_subtype OWNER TO runbot;

--
-- Name: TABLE mail_message_subtype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_subtype IS 'Message subtypes';


--
-- Name: COLUMN mail_message_subtype.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.parent_id IS 'Parent';


--
-- Name: COLUMN mail_message_subtype.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_subtype.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_subtype.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_subtype.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.relation_field IS 'Relation field';


--
-- Name: COLUMN mail_message_subtype.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.res_model IS 'Model';


--
-- Name: COLUMN mail_message_subtype.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.name IS 'Message Type';


--
-- Name: COLUMN mail_message_subtype.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.description IS 'Description';


--
-- Name: COLUMN mail_message_subtype.internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.internal IS 'Internal Only';


--
-- Name: COLUMN mail_message_subtype."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype."default" IS 'Default';


--
-- Name: COLUMN mail_message_subtype.hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.hidden IS 'Hidden';


--
-- Name: COLUMN mail_message_subtype.track_recipients; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.track_recipients IS 'Track Recipients';


--
-- Name: COLUMN mail_message_subtype.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_subtype.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_date IS 'Last Updated on';


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_subtype_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_subtype_id_seq OWNER TO runbot;

--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_subtype_id_seq OWNED BY public.mail_message_subtype.id;


--
-- Name: mail_notification; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification (
    id integer NOT NULL,
    author_id integer,
    mail_message_id integer NOT NULL,
    mail_mail_id integer,
    res_partner_id integer,
    notification_type character varying NOT NULL,
    notification_status character varying,
    failure_type character varying,
    failure_reason text,
    is_read boolean,
    read_date timestamp without time zone,
    CONSTRAINT mail_notification_notification_partner_required CHECK ((((notification_type)::text <> ALL ((ARRAY['email'::character varying, 'inbox'::character varying])::text[])) OR (res_partner_id IS NOT NULL)))
);


ALTER TABLE public.mail_notification OWNER TO runbot;

--
-- Name: TABLE mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification IS 'Message Notifications';


--
-- Name: COLUMN mail_notification.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.author_id IS 'Author';


--
-- Name: COLUMN mail_notification.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_notification.mail_mail_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_mail_id IS 'Mail';


--
-- Name: COLUMN mail_notification.res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.res_partner_id IS 'Recipient';


--
-- Name: COLUMN mail_notification.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_type IS 'Notification Type';


--
-- Name: COLUMN mail_notification.notification_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_status IS 'Status';


--
-- Name: COLUMN mail_notification.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_notification.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_reason IS 'Failure reason';


--
-- Name: COLUMN mail_notification.is_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.is_read IS 'Is Read';


--
-- Name: COLUMN mail_notification.read_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.read_date IS 'Read Date';


--
-- Name: CONSTRAINT mail_notification_notification_partner_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_required ON public.mail_notification IS 'CHECK(notification_type NOT IN (''email'', ''inbox'') OR res_partner_id IS NOT NULL)';


--
-- Name: mail_notification_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_notification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_notification_id_seq OWNER TO runbot;

--
-- Name: mail_notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_notification_id_seq OWNED BY public.mail_notification.id;


--
-- Name: mail_notification_mail_resend_message_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification_mail_resend_message_rel (
    mail_resend_message_id integer NOT NULL,
    mail_notification_id integer NOT NULL
);


ALTER TABLE public.mail_notification_mail_resend_message_rel OWNER TO runbot;

--
-- Name: TABLE mail_notification_mail_resend_message_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification_mail_resend_message_rel IS 'RELATION BETWEEN mail_resend_message AND mail_notification';


--
-- Name: mail_resend_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_resend_message (
    id integer NOT NULL,
    mail_message_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_resend_message OWNER TO runbot;

--
-- Name: TABLE mail_resend_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_resend_message IS 'Email resend wizard';


--
-- Name: COLUMN mail_resend_message.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_resend_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.write_date IS 'Last Updated on';


--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_resend_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_resend_message_id_seq OWNER TO runbot;

--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_resend_message_id_seq OWNED BY public.mail_resend_message.id;


--
-- Name: mail_resend_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_resend_partner (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    resend_wizard_id integer,
    create_uid integer,
    write_uid integer,
    message character varying,
    resend boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_resend_partner OWNER TO runbot;

--
-- Name: TABLE mail_resend_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_resend_partner IS 'Partner with additional information for mail resend';


--
-- Name: COLUMN mail_resend_partner.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.partner_id IS 'Partner';


--
-- Name: COLUMN mail_resend_partner.resend_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.resend_wizard_id IS 'Resend wizard';


--
-- Name: COLUMN mail_resend_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_partner.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.message IS 'Error message';


--
-- Name: COLUMN mail_resend_partner.resend; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.resend IS 'Try Again';


--
-- Name: COLUMN mail_resend_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.write_date IS 'Last Updated on';


--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_resend_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_resend_partner_id_seq OWNER TO runbot;

--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_resend_partner_id_seq OWNED BY public.mail_resend_partner.id;


--
-- Name: mail_shortcode; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_shortcode (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source character varying NOT NULL,
    description character varying,
    substitution text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_shortcode OWNER TO runbot;

--
-- Name: TABLE mail_shortcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_shortcode IS 'Canned Response / Shortcode';


--
-- Name: COLUMN mail_shortcode.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.create_uid IS 'Created by';


--
-- Name: COLUMN mail_shortcode.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_shortcode.source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.source IS 'Shortcut';


--
-- Name: COLUMN mail_shortcode.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.description IS 'Description';


--
-- Name: COLUMN mail_shortcode.substitution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.substitution IS 'Substitution';


--
-- Name: COLUMN mail_shortcode.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.create_date IS 'Created on';


--
-- Name: COLUMN mail_shortcode.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_shortcode.write_date IS 'Last Updated on';


--
-- Name: mail_shortcode_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_shortcode_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_shortcode_id_seq OWNER TO runbot;

--
-- Name: mail_shortcode_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_shortcode_id_seq OWNED BY public.mail_shortcode.id;


--
-- Name: mail_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template (
    id integer NOT NULL,
    model_id integer,
    report_template integer,
    mail_server_id integer,
    ref_ir_act_window integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    email_from character varying,
    email_to character varying,
    partner_to character varying,
    email_cc character varying,
    reply_to character varying,
    scheduled_date character varying,
    name jsonb,
    description jsonb,
    subject jsonb,
    body_html jsonb,
    report_name jsonb,
    active boolean,
    use_default_to boolean,
    auto_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template OWNER TO runbot;

--
-- Name: TABLE mail_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template IS 'Email Templates';


--
-- Name: COLUMN mail_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model_id IS 'Applies to';


--
-- Name: COLUMN mail_template.report_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN mail_template.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN mail_template.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN mail_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN mail_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.lang IS 'Language';


--
-- Name: COLUMN mail_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model IS 'Related Document Model';


--
-- Name: COLUMN mail_template.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_from IS 'From';


--
-- Name: COLUMN mail_template.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_to IS 'To (Emails)';


--
-- Name: COLUMN mail_template.partner_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.partner_to IS 'To (Partners)';


--
-- Name: COLUMN mail_template.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_cc IS 'Cc';


--
-- Name: COLUMN mail_template.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_template.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.name IS 'Name';


--
-- Name: COLUMN mail_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.description IS 'Template description';


--
-- Name: COLUMN mail_template.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.subject IS 'Subject';


--
-- Name: COLUMN mail_template.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.body_html IS 'Body';


--
-- Name: COLUMN mail_template.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.report_name IS 'Report Filename';


--
-- Name: COLUMN mail_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.active IS 'Active';


--
-- Name: COLUMN mail_template.use_default_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.use_default_to IS 'Default recipients';


--
-- Name: COLUMN mail_template.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_date IS 'Last Updated on';


--
-- Name: mail_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_id_seq OWNER TO runbot;

--
-- Name: mail_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_id_seq OWNED BY public.mail_template.id;


--
-- Name: mail_template_mail_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_mail_template_reset_rel (
    mail_template_reset_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_template_mail_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_mail_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_mail_template_reset_rel IS 'RELATION BETWEEN mail_template_reset AND mail_template';


--
-- Name: mail_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_preview (
    id integer NOT NULL,
    mail_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    resource_ref character varying,
    lang character varying,
    error_msg character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_preview OWNER TO runbot;

--
-- Name: TABLE mail_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_preview IS 'Email Template Preview';


--
-- Name: COLUMN mail_template_preview.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.mail_template_id IS 'Related Mail Template';


--
-- Name: COLUMN mail_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.resource_ref IS 'Record';


--
-- Name: COLUMN mail_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN mail_template_preview.error_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.error_msg IS 'Error Message';


--
-- Name: COLUMN mail_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_date IS 'Last Updated on';


--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_preview_id_seq OWNER TO runbot;

--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_preview_id_seq OWNED BY public.mail_template_preview.id;


--
-- Name: mail_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_reset OWNER TO runbot;

--
-- Name: TABLE mail_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_reset IS 'Mail Template Reset';


--
-- Name: COLUMN mail_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_date IS 'Last Updated on';


--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_reset_id_seq OWNER TO runbot;

--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_reset_id_seq OWNED BY public.mail_template_reset.id;


--
-- Name: mail_tracking_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_tracking_value (
    id integer NOT NULL,
    field integer NOT NULL,
    old_value_integer integer,
    new_value_integer integer,
    currency_id integer,
    mail_message_id integer NOT NULL,
    tracking_sequence integer,
    create_uid integer,
    write_uid integer,
    field_desc character varying NOT NULL,
    field_type character varying,
    old_value_char character varying,
    new_value_char character varying,
    old_value_text text,
    new_value_text text,
    old_value_datetime timestamp without time zone,
    new_value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    old_value_float double precision,
    old_value_monetary double precision,
    new_value_float double precision,
    new_value_monetary double precision
);


ALTER TABLE public.mail_tracking_value OWNER TO runbot;

--
-- Name: TABLE mail_tracking_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_tracking_value IS 'Mail Tracking Value';


--
-- Name: COLUMN mail_tracking_value.field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field IS 'Field';


--
-- Name: COLUMN mail_tracking_value.old_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_integer IS 'Old Value Integer';


--
-- Name: COLUMN mail_tracking_value.new_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_integer IS 'New Value Integer';


--
-- Name: COLUMN mail_tracking_value.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.currency_id IS 'Currency';


--
-- Name: COLUMN mail_tracking_value.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.mail_message_id IS 'Message ID';


--
-- Name: COLUMN mail_tracking_value.tracking_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.tracking_sequence IS 'Tracking field sequence';


--
-- Name: COLUMN mail_tracking_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_uid IS 'Created by';


--
-- Name: COLUMN mail_tracking_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_tracking_value.field_desc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_desc IS 'Field Description';


--
-- Name: COLUMN mail_tracking_value.field_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_type IS 'Field Type';


--
-- Name: COLUMN mail_tracking_value.old_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_char IS 'Old Value Char';


--
-- Name: COLUMN mail_tracking_value.new_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_char IS 'New Value Char';


--
-- Name: COLUMN mail_tracking_value.old_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_text IS 'Old Value Text';


--
-- Name: COLUMN mail_tracking_value.new_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_text IS 'New Value Text';


--
-- Name: COLUMN mail_tracking_value.old_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_datetime IS 'Old Value DateTime';


--
-- Name: COLUMN mail_tracking_value.new_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_datetime IS 'New Value Datetime';


--
-- Name: COLUMN mail_tracking_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_date IS 'Created on';


--
-- Name: COLUMN mail_tracking_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_tracking_value.old_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_float IS 'Old Value Float';


--
-- Name: COLUMN mail_tracking_value.old_value_monetary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_monetary IS 'Old Value Monetary';


--
-- Name: COLUMN mail_tracking_value.new_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_float IS 'New Value Float';


--
-- Name: COLUMN mail_tracking_value.new_value_monetary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_monetary IS 'New Value Monetary';


--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_tracking_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_tracking_value_id_seq OWNER TO runbot;

--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_tracking_value_id_seq OWNED BY public.mail_tracking_value.id;


--
-- Name: mail_wizard_invite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_wizard_invite (
    id integer NOT NULL,
    res_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    message text,
    send_mail boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_wizard_invite OWNER TO runbot;

--
-- Name: TABLE mail_wizard_invite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_wizard_invite IS 'Invite wizard';


--
-- Name: COLUMN mail_wizard_invite.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_wizard_invite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.create_uid IS 'Created by';


--
-- Name: COLUMN mail_wizard_invite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_wizard_invite.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_wizard_invite.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.message IS 'Message';


--
-- Name: COLUMN mail_wizard_invite.send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.send_mail IS 'Send Email';


--
-- Name: COLUMN mail_wizard_invite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.create_date IS 'Created on';


--
-- Name: COLUMN mail_wizard_invite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.write_date IS 'Last Updated on';


--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_wizard_invite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_wizard_invite_id_seq OWNER TO runbot;

--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_wizard_invite_id_seq OWNED BY public.mail_wizard_invite.id;


--
-- Name: mail_wizard_invite_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_wizard_invite_res_partner_rel (
    mail_wizard_invite_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_wizard_invite_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_wizard_invite_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_wizard_invite_res_partner_rel IS 'RELATION BETWEEN mail_wizard_invite AND res_partner';


--
-- Name: mass_editing_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mass_editing_wizard (
    id integer NOT NULL,
    selected_item_qty integer,
    remaining_item_qty integer,
    create_uid integer,
    write_uid integer,
    operation_description_info text,
    operation_description_warning text,
    operation_description_danger text,
    message text,
    write_record_by_record boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mass_editing_wizard OWNER TO runbot;

--
-- Name: TABLE mass_editing_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mass_editing_wizard IS 'Wizard for mass edition';


--
-- Name: COLUMN mass_editing_wizard.selected_item_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.selected_item_qty IS 'Selected Item Qty';


--
-- Name: COLUMN mass_editing_wizard.remaining_item_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.remaining_item_qty IS 'Remaining Item Qty';


--
-- Name: COLUMN mass_editing_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN mass_editing_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mass_editing_wizard.operation_description_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.operation_description_info IS 'Operation Description Info';


--
-- Name: COLUMN mass_editing_wizard.operation_description_warning; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.operation_description_warning IS 'Operation Description Warning';


--
-- Name: COLUMN mass_editing_wizard.operation_description_danger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.operation_description_danger IS 'Operation Description Danger';


--
-- Name: COLUMN mass_editing_wizard.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.message IS 'Message';


--
-- Name: COLUMN mass_editing_wizard.write_record_by_record; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.write_record_by_record IS 'Write Record By Record';


--
-- Name: COLUMN mass_editing_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.create_date IS 'Created on';


--
-- Name: COLUMN mass_editing_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mass_editing_wizard.write_date IS 'Last Updated on';


--
-- Name: mass_editing_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mass_editing_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mass_editing_wizard_id_seq OWNER TO runbot;

--
-- Name: mass_editing_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mass_editing_wizard_id_seq OWNED BY public.mass_editing_wizard.id;


--
-- Name: meeting_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.meeting_category_rel (
    event_id integer NOT NULL,
    type_id integer NOT NULL
);


ALTER TABLE public.meeting_category_rel OWNER TO runbot;

--
-- Name: TABLE meeting_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.meeting_category_rel IS 'RELATION BETWEEN calendar_event AND calendar_event_type';


--
-- Name: message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.message_attachment_rel (
    message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.message_attachment_rel IS 'RELATION BETWEEN mail_message AND ir_attachment';


--
-- Name: operating_unit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.operating_unit (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.operating_unit OWNER TO runbot;

--
-- Name: TABLE operating_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.operating_unit IS 'Operating Unit';


--
-- Name: COLUMN operating_unit.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.operating_unit.company_id IS 'Company';


--
-- Name: COLUMN operating_unit.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.operating_unit.partner_id IS 'Partner';


--
-- Name: COLUMN operating_unit.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.operating_unit.create_uid IS 'Created by';


--
-- Name: COLUMN operating_unit.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.operating_unit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN operating_unit.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.operating_unit.name IS 'Name';


--
-- Name: COLUMN operating_unit.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.operating_unit.code IS 'Code';


--
-- Name: COLUMN operating_unit.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.operating_unit.active IS 'Active';


--
-- Name: COLUMN operating_unit.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.operating_unit.create_date IS 'Created on';


--
-- Name: COLUMN operating_unit.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.operating_unit.write_date IS 'Last Updated on';


--
-- Name: operating_unit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.operating_unit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.operating_unit_id_seq OWNER TO runbot;

--
-- Name: operating_unit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.operating_unit_id_seq OWNED BY public.operating_unit.id;


--
-- Name: operating_unit_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.operating_unit_users_rel (
    operating_unit_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.operating_unit_users_rel OWNER TO runbot;

--
-- Name: TABLE operating_unit_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.operating_unit_users_rel IS 'RELATION BETWEEN operating_unit AND res_users';


--
-- Name: phone_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist (
    id integer NOT NULL,
    message_main_attachment_id integer,
    create_uid integer,
    write_uid integer,
    number character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist OWNER TO runbot;

--
-- Name: TABLE phone_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist IS 'Phone Blacklist';


--
-- Name: COLUMN phone_blacklist.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN phone_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.number IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.active IS 'Active';


--
-- Name: COLUMN phone_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_id_seq OWNED BY public.phone_blacklist.id;


--
-- Name: phone_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE phone_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist_remove IS 'Remove phone from blacklist';


--
-- Name: COLUMN phone_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist_remove.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.phone IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN phone_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNED BY public.phone_blacklist_remove.id;


--
-- Name: privacy_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    anonymized_name character varying NOT NULL,
    anonymized_email character varying NOT NULL,
    execution_details text,
    records_description text,
    additional_note text,
    date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_log OWNER TO runbot;

--
-- Name: TABLE privacy_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_log IS 'Privacy Log';


--
-- Name: COLUMN privacy_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.user_id IS 'Handled By';


--
-- Name: COLUMN privacy_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_log.anonymized_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_name IS 'Anonymized Name';


--
-- Name: COLUMN privacy_log.anonymized_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_email IS 'Anonymized Email';


--
-- Name: COLUMN privacy_log.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_log.records_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.records_description IS 'Found Records';


--
-- Name: COLUMN privacy_log.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.additional_note IS 'Additional Note';


--
-- Name: COLUMN privacy_log.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.date IS 'Date';


--
-- Name: COLUMN privacy_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_date IS 'Created on';


--
-- Name: COLUMN privacy_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_date IS 'Last Updated on';


--
-- Name: privacy_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_log_id_seq OWNER TO runbot;

--
-- Name: privacy_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_log_id_seq OWNED BY public.privacy_log.id;


--
-- Name: privacy_lookup_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard (
    id integer NOT NULL,
    log_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    email character varying NOT NULL,
    execution_details text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard IS 'Privacy Lookup Wizard';


--
-- Name: COLUMN privacy_lookup_wizard.log_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.log_id IS 'Log';


--
-- Name: COLUMN privacy_lookup_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.name IS 'Name';


--
-- Name: COLUMN privacy_lookup_wizard.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.email IS 'Email';


--
-- Name: COLUMN privacy_lookup_wizard.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNED BY public.privacy_lookup_wizard.id;


--
-- Name: privacy_lookup_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard_line (
    id integer NOT NULL,
    wizard_id integer,
    res_id integer NOT NULL,
    res_model_id integer,
    create_uid integer,
    write_uid integer,
    res_name character varying,
    res_model character varying,
    execution_details character varying,
    has_active boolean,
    is_active boolean,
    is_unlinked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard_line OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard_line IS 'Privacy Lookup Wizard Line';


--
-- Name: COLUMN privacy_lookup_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_id IS 'Resource ID';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model_id IS 'Related Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_name IS 'Resource name';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model IS 'Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard_line.has_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.has_active IS 'Has Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_active IS 'Is Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_unlinked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_unlinked IS 'Is Unlinked';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNED BY public.privacy_lookup_wizard_line.id;


--
-- Name: product_attr_exclusion_value_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attr_exclusion_value_ids_rel (
    product_template_attribute_exclusion_id integer NOT NULL,
    product_template_attribute_value_id integer NOT NULL
);


ALTER TABLE public.product_attr_exclusion_value_ids_rel OWNER TO runbot;

--
-- Name: TABLE product_attr_exclusion_value_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attr_exclusion_value_ids_rel IS 'RELATION BETWEEN product_template_attribute_exclusion AND product_template_attribute_value';


--
-- Name: product_attribute; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_variant character varying NOT NULL,
    display_type character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_attribute OWNER TO runbot;

--
-- Name: TABLE product_attribute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute IS 'Product Attribute';


--
-- Name: COLUMN product_attribute.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.sequence IS 'Sequence';


--
-- Name: COLUMN product_attribute.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute.create_variant; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_variant IS 'Variants Creation Mode';


--
-- Name: COLUMN product_attribute.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.display_type IS 'Display Type';


--
-- Name: COLUMN product_attribute.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.name IS 'Attribute';


--
-- Name: COLUMN product_attribute.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.write_date IS 'Last Updated on';


--
-- Name: product_attribute_custom_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_custom_value (
    id integer NOT NULL,
    custom_product_template_attribute_value_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    custom_value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_attribute_custom_value OWNER TO runbot;

--
-- Name: TABLE product_attribute_custom_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_custom_value IS 'Product Attribute Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.custom_product_template_attribute_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_product_template_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_attribute_custom_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_custom_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_custom_value.custom_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_value IS 'Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_custom_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_date IS 'Last Updated on';


--
-- Name: product_attribute_custom_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_attribute_custom_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_attribute_custom_value_id_seq OWNER TO runbot;

--
-- Name: product_attribute_custom_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_attribute_custom_value_id_seq OWNED BY public.product_attribute_custom_value.id;


--
-- Name: product_attribute_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_attribute_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_attribute_id_seq OWNER TO runbot;

--
-- Name: product_attribute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_attribute_id_seq OWNED BY public.product_attribute.id;


--
-- Name: product_attribute_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_product_template_rel (
    product_attribute_id integer NOT NULL,
    product_template_id integer NOT NULL
);


ALTER TABLE public.product_attribute_product_template_rel OWNER TO runbot;

--
-- Name: TABLE product_attribute_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_product_template_rel IS 'RELATION BETWEEN product_attribute AND product_template';


--
-- Name: product_attribute_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_value (
    id integer NOT NULL,
    sequence integer,
    attribute_id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    html_color character varying,
    name jsonb NOT NULL,
    is_custom boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_attribute_value OWNER TO runbot;

--
-- Name: TABLE product_attribute_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_value IS 'Attribute Value';


--
-- Name: COLUMN product_attribute_value.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.sequence IS 'Sequence';


--
-- Name: COLUMN product_attribute_value.attribute_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_attribute_value.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.color IS 'Color Index';


--
-- Name: COLUMN product_attribute_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_value.html_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.html_color IS 'Color';


--
-- Name: COLUMN product_attribute_value.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.name IS 'Value';


--
-- Name: COLUMN product_attribute_value.is_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.is_custom IS 'Is custom value';


--
-- Name: COLUMN product_attribute_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.write_date IS 'Last Updated on';


--
-- Name: product_attribute_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_attribute_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_attribute_value_id_seq OWNER TO runbot;

--
-- Name: product_attribute_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_attribute_value_id_seq OWNED BY public.product_attribute_value.id;


--
-- Name: product_attribute_value_product_template_attribute_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_value_product_template_attribute_line_rel (
    product_attribute_value_id integer NOT NULL,
    product_template_attribute_line_id integer NOT NULL
);


ALTER TABLE public.product_attribute_value_product_template_attribute_line_rel OWNER TO runbot;

--
-- Name: TABLE product_attribute_value_product_template_attribute_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_value_product_template_attribute_line_rel IS 'RELATION BETWEEN product_attribute_value AND product_template_attribute_line';


--
-- Name: product_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_category (
    id integer NOT NULL,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    parent_path character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_category OWNER TO runbot;

--
-- Name: TABLE product_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_category IS 'Product Category';


--
-- Name: COLUMN product_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN product_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.create_uid IS 'Created by';


--
-- Name: COLUMN product_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.name IS 'Name';


--
-- Name: COLUMN product_category.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.complete_name IS 'Complete Name';


--
-- Name: COLUMN product_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN product_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.create_date IS 'Created on';


--
-- Name: COLUMN product_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.write_date IS 'Last Updated on';


--
-- Name: product_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_category_id_seq OWNER TO runbot;

--
-- Name: product_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_category_id_seq OWNED BY public.product_category.id;


--
-- Name: product_label_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout (
    id integer NOT NULL,
    custom_quantity integer NOT NULL,
    create_uid integer,
    write_uid integer,
    print_format character varying NOT NULL,
    extra_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_label_layout OWNER TO runbot;

--
-- Name: TABLE product_label_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout IS 'Choose the sheet layout to print the labels';


--
-- Name: COLUMN product_label_layout.custom_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.custom_quantity IS 'Quantity';


--
-- Name: COLUMN product_label_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.create_uid IS 'Created by';


--
-- Name: COLUMN product_label_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_label_layout.print_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.print_format IS 'Format';


--
-- Name: COLUMN product_label_layout.extra_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.extra_html IS 'Extra Content';


--
-- Name: COLUMN product_label_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.create_date IS 'Created on';


--
-- Name: COLUMN product_label_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.write_date IS 'Last Updated on';


--
-- Name: product_label_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_label_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_label_layout_id_seq OWNER TO runbot;

--
-- Name: product_label_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_label_layout_id_seq OWNED BY public.product_label_layout.id;


--
-- Name: product_label_layout_product_product_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout_product_product_rel (
    product_label_layout_id integer NOT NULL,
    product_product_id integer NOT NULL
);


ALTER TABLE public.product_label_layout_product_product_rel OWNER TO runbot;

--
-- Name: TABLE product_label_layout_product_product_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout_product_product_rel IS 'RELATION BETWEEN product_label_layout AND product_product';


--
-- Name: product_label_layout_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout_product_template_rel (
    product_label_layout_id integer NOT NULL,
    product_template_id integer NOT NULL
);


ALTER TABLE public.product_label_layout_product_template_rel OWNER TO runbot;

--
-- Name: TABLE product_label_layout_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout_product_template_rel IS 'RELATION BETWEEN product_label_layout AND product_template';


--
-- Name: product_packaging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_packaging (
    id integer NOT NULL,
    sequence integer,
    product_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    barcode character varying,
    qty numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT product_packaging_positive_qty CHECK ((qty > (0)::numeric))
);


ALTER TABLE public.product_packaging OWNER TO runbot;

--
-- Name: TABLE product_packaging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_packaging IS 'Product Packaging';


--
-- Name: COLUMN product_packaging.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.sequence IS 'Sequence';


--
-- Name: COLUMN product_packaging.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.product_id IS 'Product';


--
-- Name: COLUMN product_packaging.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.company_id IS 'Company';


--
-- Name: COLUMN product_packaging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.create_uid IS 'Created by';


--
-- Name: COLUMN product_packaging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_packaging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.name IS 'Product Packaging';


--
-- Name: COLUMN product_packaging.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.barcode IS 'Barcode';


--
-- Name: COLUMN product_packaging.qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.qty IS 'Contained Quantity';


--
-- Name: COLUMN product_packaging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.create_date IS 'Created on';


--
-- Name: COLUMN product_packaging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_packaging.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT product_packaging_positive_qty ON product_packaging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT product_packaging_positive_qty ON public.product_packaging IS 'CHECK(qty > 0)';


--
-- Name: product_packaging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_packaging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_packaging_id_seq OWNER TO runbot;

--
-- Name: product_packaging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_packaging_id_seq OWNED BY public.product_packaging.id;


--
-- Name: product_pricelist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_pricelist (
    id integer NOT NULL,
    sequence integer,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    discount_policy character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_pricelist OWNER TO runbot;

--
-- Name: TABLE product_pricelist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_pricelist IS 'Pricelist';


--
-- Name: COLUMN product_pricelist.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.sequence IS 'Sequence';


--
-- Name: COLUMN product_pricelist.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.currency_id IS 'Currency';


--
-- Name: COLUMN product_pricelist.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.company_id IS 'Company';


--
-- Name: COLUMN product_pricelist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist.discount_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.discount_policy IS 'Discount Policy';


--
-- Name: COLUMN product_pricelist.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.name IS 'Pricelist Name';


--
-- Name: COLUMN product_pricelist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.active IS 'Active';


--
-- Name: COLUMN product_pricelist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.create_date IS 'Created on';


--
-- Name: COLUMN product_pricelist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.write_date IS 'Last Updated on';


--
-- Name: product_pricelist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_pricelist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_pricelist_id_seq OWNER TO runbot;

--
-- Name: product_pricelist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_pricelist_id_seq OWNED BY public.product_pricelist.id;


--
-- Name: product_pricelist_item; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_pricelist_item (
    id integer NOT NULL,
    pricelist_id integer NOT NULL,
    company_id integer,
    currency_id integer,
    categ_id integer,
    product_tmpl_id integer,
    product_id integer,
    base_pricelist_id integer,
    create_uid integer,
    write_uid integer,
    applied_on character varying NOT NULL,
    base character varying NOT NULL,
    compute_price character varying NOT NULL,
    min_quantity numeric,
    fixed_price numeric,
    price_discount numeric,
    price_round numeric,
    price_surcharge numeric,
    price_min_margin numeric,
    price_max_margin numeric,
    active boolean,
    date_start timestamp without time zone,
    date_end timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percent_price double precision
);


ALTER TABLE public.product_pricelist_item OWNER TO runbot;

--
-- Name: TABLE product_pricelist_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_pricelist_item IS 'Pricelist Rule';


--
-- Name: COLUMN product_pricelist_item.pricelist_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN product_pricelist_item.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.company_id IS 'Company';


--
-- Name: COLUMN product_pricelist_item.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.currency_id IS 'Currency';


--
-- Name: COLUMN product_pricelist_item.categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.categ_id IS 'Product Category';


--
-- Name: COLUMN product_pricelist_item.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.product_tmpl_id IS 'Product';


--
-- Name: COLUMN product_pricelist_item.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.product_id IS 'Product Variant';


--
-- Name: COLUMN product_pricelist_item.base_pricelist_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.base_pricelist_id IS 'Other Pricelist';


--
-- Name: COLUMN product_pricelist_item.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist_item.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist_item.applied_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.applied_on IS 'Apply On';


--
-- Name: COLUMN product_pricelist_item.base; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.base IS 'Based on';


--
-- Name: COLUMN product_pricelist_item.compute_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.compute_price IS 'Compute Price';


--
-- Name: COLUMN product_pricelist_item.min_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.min_quantity IS 'Min. Quantity';


--
-- Name: COLUMN product_pricelist_item.fixed_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.fixed_price IS 'Fixed Price';


--
-- Name: COLUMN product_pricelist_item.price_discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_discount IS 'Price Discount';


--
-- Name: COLUMN product_pricelist_item.price_round; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_round IS 'Price Rounding';


--
-- Name: COLUMN product_pricelist_item.price_surcharge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_surcharge IS 'Price Surcharge';


--
-- Name: COLUMN product_pricelist_item.price_min_margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_min_margin IS 'Min. Price Margin';


--
-- Name: COLUMN product_pricelist_item.price_max_margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_max_margin IS 'Max. Price Margin';


--
-- Name: COLUMN product_pricelist_item.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.active IS 'Active';


--
-- Name: COLUMN product_pricelist_item.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.date_start IS 'Start Date';


--
-- Name: COLUMN product_pricelist_item.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.date_end IS 'End Date';


--
-- Name: COLUMN product_pricelist_item.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.create_date IS 'Created on';


--
-- Name: COLUMN product_pricelist_item.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_pricelist_item.percent_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.percent_price IS 'Percentage Price';


--
-- Name: product_pricelist_item_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_pricelist_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_pricelist_item_id_seq OWNER TO runbot;

--
-- Name: product_pricelist_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_pricelist_item_id_seq OWNED BY public.product_pricelist_item.id;


--
-- Name: product_product; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_product (
    id integer NOT NULL,
    message_main_attachment_id integer,
    product_tmpl_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    default_code character varying,
    barcode character varying,
    combination_indices character varying,
    volume numeric,
    weight numeric,
    active boolean,
    can_image_variant_1024_be_zoomed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_product OWNER TO runbot;

--
-- Name: TABLE product_product; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_product IS 'Product Variant';


--
-- Name: COLUMN product_product.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN product_product.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_product.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.create_uid IS 'Created by';


--
-- Name: COLUMN product_product.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_product.default_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.default_code IS 'Internal Reference';


--
-- Name: COLUMN product_product.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.barcode IS 'Barcode';


--
-- Name: COLUMN product_product.combination_indices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.combination_indices IS 'Combination Indices';


--
-- Name: COLUMN product_product.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.volume IS 'Volume';


--
-- Name: COLUMN product_product.weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.weight IS 'Weight';


--
-- Name: COLUMN product_product.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.active IS 'Active';


--
-- Name: COLUMN product_product.can_image_variant_1024_be_zoomed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.can_image_variant_1024_be_zoomed IS 'Can Variant Image 1024 be zoomed';


--
-- Name: COLUMN product_product.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.create_date IS 'Created on';


--
-- Name: COLUMN product_product.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.write_date IS 'Last Updated on';


--
-- Name: product_product_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_product_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_product_id_seq OWNER TO runbot;

--
-- Name: product_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_product_id_seq OWNED BY public.product_product.id;


--
-- Name: product_supplierinfo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_supplierinfo (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    sequence integer,
    company_id integer,
    currency_id integer NOT NULL,
    product_id integer,
    product_tmpl_id integer,
    delay integer NOT NULL,
    create_uid integer,
    write_uid integer,
    product_name character varying,
    product_code character varying,
    date_start date,
    date_end date,
    min_qty numeric NOT NULL,
    price numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_supplierinfo OWNER TO runbot;

--
-- Name: TABLE product_supplierinfo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_supplierinfo IS 'Supplier Pricelist';


--
-- Name: COLUMN product_supplierinfo.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.partner_id IS 'Vendor';


--
-- Name: COLUMN product_supplierinfo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.sequence IS 'Sequence';


--
-- Name: COLUMN product_supplierinfo.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.company_id IS 'Company';


--
-- Name: COLUMN product_supplierinfo.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.currency_id IS 'Currency';


--
-- Name: COLUMN product_supplierinfo.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_id IS 'Product Variant';


--
-- Name: COLUMN product_supplierinfo.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_supplierinfo.delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.delay IS 'Delivery Lead Time';


--
-- Name: COLUMN product_supplierinfo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.create_uid IS 'Created by';


--
-- Name: COLUMN product_supplierinfo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_supplierinfo.product_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_name IS 'Vendor Product Name';


--
-- Name: COLUMN product_supplierinfo.product_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_code IS 'Vendor Product Code';


--
-- Name: COLUMN product_supplierinfo.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.date_start IS 'Start Date';


--
-- Name: COLUMN product_supplierinfo.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.date_end IS 'End Date';


--
-- Name: COLUMN product_supplierinfo.min_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.min_qty IS 'Quantity';


--
-- Name: COLUMN product_supplierinfo.price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.price IS 'Price';


--
-- Name: COLUMN product_supplierinfo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.create_date IS 'Created on';


--
-- Name: COLUMN product_supplierinfo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.write_date IS 'Last Updated on';


--
-- Name: product_supplierinfo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_supplierinfo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_supplierinfo_id_seq OWNER TO runbot;

--
-- Name: product_supplierinfo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_supplierinfo_id_seq OWNED BY public.product_supplierinfo.id;


--
-- Name: product_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_tag OWNER TO runbot;

--
-- Name: TABLE product_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_tag IS 'Product Tag';


--
-- Name: COLUMN product_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.color IS 'Color';


--
-- Name: COLUMN product_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.create_uid IS 'Created by';


--
-- Name: COLUMN product_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.name IS 'Tag Name';


--
-- Name: COLUMN product_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.create_date IS 'Created on';


--
-- Name: COLUMN product_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.write_date IS 'Last Updated on';


--
-- Name: product_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_tag_id_seq OWNER TO runbot;

--
-- Name: product_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_tag_id_seq OWNED BY public.product_tag.id;


--
-- Name: product_tag_product_product_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_tag_product_product_rel (
    product_product_id integer NOT NULL,
    product_tag_id integer NOT NULL
);


ALTER TABLE public.product_tag_product_product_rel OWNER TO runbot;

--
-- Name: TABLE product_tag_product_product_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_tag_product_product_rel IS 'RELATION BETWEEN product_product AND product_tag';


--
-- Name: product_tag_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_tag_product_template_rel (
    product_template_id integer NOT NULL,
    product_tag_id integer NOT NULL
);


ALTER TABLE public.product_tag_product_template_rel OWNER TO runbot;

--
-- Name: TABLE product_tag_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_tag_product_template_rel IS 'RELATION BETWEEN product_template AND product_tag';


--
-- Name: product_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template (
    id integer NOT NULL,
    message_main_attachment_id integer,
    sequence integer,
    categ_id integer NOT NULL,
    uom_id integer NOT NULL,
    uom_po_id integer NOT NULL,
    company_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    detailed_type character varying NOT NULL,
    type character varying,
    default_code character varying,
    priority character varying,
    name jsonb NOT NULL,
    description jsonb,
    description_purchase jsonb,
    description_sale jsonb,
    list_price numeric,
    volume numeric,
    weight numeric,
    sale_ok boolean,
    purchase_ok boolean,
    active boolean,
    can_image_1024_be_zoomed boolean,
    has_configurable_attributes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_template OWNER TO runbot;

--
-- Name: TABLE product_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template IS 'Product';


--
-- Name: COLUMN product_template.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN product_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.sequence IS 'Sequence';


--
-- Name: COLUMN product_template.categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.categ_id IS 'Product Category';


--
-- Name: COLUMN product_template.uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.uom_id IS 'Unit of Measure';


--
-- Name: COLUMN product_template.uom_po_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.uom_po_id IS 'Purchase UoM';


--
-- Name: COLUMN product_template.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.company_id IS 'Company';


--
-- Name: COLUMN product_template.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.color IS 'Color Index';


--
-- Name: COLUMN product_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.create_uid IS 'Created by';


--
-- Name: COLUMN product_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template.detailed_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.detailed_type IS 'Product Type';


--
-- Name: COLUMN product_template.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.type IS 'Type';


--
-- Name: COLUMN product_template.default_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.default_code IS 'Internal Reference';


--
-- Name: COLUMN product_template.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.priority IS 'Favorite';


--
-- Name: COLUMN product_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.name IS 'Name';


--
-- Name: COLUMN product_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description IS 'Description';


--
-- Name: COLUMN product_template.description_purchase; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_purchase IS 'Purchase Description';


--
-- Name: COLUMN product_template.description_sale; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_sale IS 'Sales Description';


--
-- Name: COLUMN product_template.list_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.list_price IS 'Sales Price';


--
-- Name: COLUMN product_template.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.volume IS 'Volume';


--
-- Name: COLUMN product_template.weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.weight IS 'Weight';


--
-- Name: COLUMN product_template.sale_ok; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.sale_ok IS 'Can be Sold';


--
-- Name: COLUMN product_template.purchase_ok; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.purchase_ok IS 'Can be Purchased';


--
-- Name: COLUMN product_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.active IS 'Active';


--
-- Name: COLUMN product_template.can_image_1024_be_zoomed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.can_image_1024_be_zoomed IS 'Can Image 1024 be zoomed';


--
-- Name: COLUMN product_template.has_configurable_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.has_configurable_attributes IS 'Is a configurable product';


--
-- Name: COLUMN product_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.create_date IS 'Created on';


--
-- Name: COLUMN product_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.write_date IS 'Last Updated on';


--
-- Name: product_template_attribute_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template_attribute_exclusion (
    id integer NOT NULL,
    product_template_attribute_value_id integer,
    product_tmpl_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_template_attribute_exclusion OWNER TO runbot;

--
-- Name: TABLE product_template_attribute_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template_attribute_exclusion IS 'Product Template Attribute Exclusion';


--
-- Name: COLUMN product_template_attribute_exclusion.product_template_attribute_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.product_template_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_template_attribute_exclusion.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_template_attribute_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN product_template_attribute_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template_attribute_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN product_template_attribute_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.write_date IS 'Last Updated on';


--
-- Name: product_template_attribute_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_template_attribute_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_template_attribute_exclusion_id_seq OWNER TO runbot;

--
-- Name: product_template_attribute_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_template_attribute_exclusion_id_seq OWNED BY public.product_template_attribute_exclusion.id;


--
-- Name: product_template_attribute_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template_attribute_line (
    id integer NOT NULL,
    product_tmpl_id integer NOT NULL,
    attribute_id integer NOT NULL,
    value_count integer,
    create_uid integer,
    write_uid integer,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_template_attribute_line OWNER TO runbot;

--
-- Name: TABLE product_template_attribute_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template_attribute_line IS 'Product Template Attribute Line';


--
-- Name: COLUMN product_template_attribute_line.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_template_attribute_line.attribute_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_template_attribute_line.value_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.value_count IS 'Value Count';


--
-- Name: COLUMN product_template_attribute_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.create_uid IS 'Created by';


--
-- Name: COLUMN product_template_attribute_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template_attribute_line.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.active IS 'Active';


--
-- Name: COLUMN product_template_attribute_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.create_date IS 'Created on';


--
-- Name: COLUMN product_template_attribute_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.write_date IS 'Last Updated on';


--
-- Name: product_template_attribute_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_template_attribute_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_template_attribute_line_id_seq OWNER TO runbot;

--
-- Name: product_template_attribute_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_template_attribute_line_id_seq OWNED BY public.product_template_attribute_line.id;


--
-- Name: product_template_attribute_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template_attribute_value (
    id integer NOT NULL,
    product_attribute_value_id integer NOT NULL,
    attribute_line_id integer NOT NULL,
    product_tmpl_id integer,
    attribute_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    price_extra numeric,
    ptav_active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_template_attribute_value OWNER TO runbot;

--
-- Name: TABLE product_template_attribute_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template_attribute_value IS 'Product Template Attribute Value';


--
-- Name: COLUMN product_template_attribute_value.product_attribute_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.product_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_template_attribute_value.attribute_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.attribute_line_id IS 'Attribute Line';


--
-- Name: COLUMN product_template_attribute_value.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_template_attribute_value.attribute_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_template_attribute_value.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.color IS 'Color';


--
-- Name: COLUMN product_template_attribute_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_template_attribute_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template_attribute_value.price_extra; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.price_extra IS 'Value Price Extra';


--
-- Name: COLUMN product_template_attribute_value.ptav_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.ptav_active IS 'Active';


--
-- Name: COLUMN product_template_attribute_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.create_date IS 'Created on';


--
-- Name: COLUMN product_template_attribute_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.write_date IS 'Last Updated on';


--
-- Name: product_template_attribute_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_template_attribute_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_template_attribute_value_id_seq OWNER TO runbot;

--
-- Name: product_template_attribute_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_template_attribute_value_id_seq OWNED BY public.product_template_attribute_value.id;


--
-- Name: product_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_template_id_seq OWNER TO runbot;

--
-- Name: product_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_template_id_seq OWNED BY public.product_template.id;


--
-- Name: product_variant_combination; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_variant_combination (
    product_product_id integer NOT NULL,
    product_template_attribute_value_id integer NOT NULL
);


ALTER TABLE public.product_variant_combination OWNER TO runbot;

--
-- Name: TABLE product_variant_combination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_variant_combination IS 'RELATION BETWEEN product_product AND product_template_attribute_value';


--
-- Name: rating_rating; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rating_rating (
    id integer NOT NULL,
    res_model_id integer,
    res_id integer NOT NULL,
    parent_res_model_id integer,
    parent_res_id integer,
    rated_partner_id integer,
    partner_id integer,
    message_id integer,
    create_uid integer,
    write_uid integer,
    res_name character varying,
    res_model character varying,
    parent_res_name character varying,
    parent_res_model character varying,
    rating_text character varying,
    access_token character varying,
    feedback text,
    is_internal boolean,
    consumed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rating double precision,
    CONSTRAINT rating_rating_rating_range CHECK (((rating >= (0)::double precision) AND (rating <= (5)::double precision)))
);


ALTER TABLE public.rating_rating OWNER TO runbot;

--
-- Name: TABLE rating_rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rating_rating IS 'Rating';


--
-- Name: COLUMN rating_rating.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.res_model_id IS 'Related Document Model';


--
-- Name: COLUMN rating_rating.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.res_id IS 'Document';


--
-- Name: COLUMN rating_rating.parent_res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.parent_res_model_id IS 'Parent Related Document Model';


--
-- Name: COLUMN rating_rating.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.parent_res_id IS 'Parent Document';


--
-- Name: COLUMN rating_rating.rated_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.rated_partner_id IS 'Rated Operator';


--
-- Name: COLUMN rating_rating.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.partner_id IS 'Customer';


--
-- Name: COLUMN rating_rating.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.message_id IS 'Message';


--
-- Name: COLUMN rating_rating.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.create_uid IS 'Created by';


--
-- Name: COLUMN rating_rating.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.write_uid IS 'Last Updated by';


--
-- Name: COLUMN rating_rating.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.res_name IS 'Resource name';


--
-- Name: COLUMN rating_rating.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.res_model IS 'Document Model';


--
-- Name: COLUMN rating_rating.parent_res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.parent_res_name IS 'Parent Document Name';


--
-- Name: COLUMN rating_rating.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.parent_res_model IS 'Parent Document Model';


--
-- Name: COLUMN rating_rating.rating_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.rating_text IS 'Rating';


--
-- Name: COLUMN rating_rating.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.access_token IS 'Security Token';


--
-- Name: COLUMN rating_rating.feedback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.feedback IS 'Comment';


--
-- Name: COLUMN rating_rating.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.is_internal IS 'Visible Internally Only';


--
-- Name: COLUMN rating_rating.consumed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.consumed IS 'Filled Rating';


--
-- Name: COLUMN rating_rating.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.create_date IS 'Submitted on';


--
-- Name: COLUMN rating_rating.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.write_date IS 'Last Updated on';


--
-- Name: COLUMN rating_rating.rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.rating IS 'Rating Value';


--
-- Name: CONSTRAINT rating_rating_rating_range ON rating_rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT rating_rating_rating_range ON public.rating_rating IS 'check(rating >= 0 and rating <= 5)';


--
-- Name: rating_rating_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.rating_rating_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.rating_rating_id_seq OWNER TO runbot;

--
-- Name: rating_rating_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.rating_rating_id_seq OWNED BY public.rating_rating.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: rel_server_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_server_actions (
    server_id integer NOT NULL,
    action_id integer NOT NULL
);


ALTER TABLE public.rel_server_actions OWNER TO runbot;

--
-- Name: TABLE rel_server_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_server_actions IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format ?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    bank_code character varying,
    bank_branch_code character varying
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_bank.bank_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bank_code IS 'Bank Code';


--
-- Name: COLUMN res_bank.bank_branch_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bank_branch_code IS 'Bank Branch Code';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    mobile character varying,
    base_onboarding_company_state character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_footer jsonb,
    report_header text,
    company_details text,
    active boolean,
    write_date timestamp without time zone,
    logo_web bytea,
    nomenclature_id integer,
    resource_calendar_id integer,
    hr_presence_control_email_amount integer,
    hr_presence_control_ip_list character varying
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.mobile IS 'Mobile';


--
-- Name: COLUMN res_company.base_onboarding_company_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.base_onboarding_company_state IS 'State of the onboarding company step';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.nomenclature_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.nomenclature_id IS 'Nomenclature';


--
-- Name: COLUMN res_company.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.resource_calendar_id IS 'Default Working Hours';


--
-- Name: COLUMN res_company.hr_presence_control_email_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_email_amount IS '# emails to send';


--
-- Name: COLUMN res_company.hr_presence_control_ip_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_ip_list IS 'Valid IP addresses';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_installer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_installer (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config_installer OWNER TO runbot;

--
-- Name: TABLE res_config_installer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_installer IS 'Config Installer';


--
-- Name: COLUMN res_config_installer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_installer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_installer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.create_date IS 'Created on';


--
-- Name: COLUMN res_config_installer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_installer.write_date IS 'Last Updated on';


--
-- Name: res_config_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_installer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_installer_id_seq OWNER TO runbot;

--
-- Name: res_config_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_installer_id_seq OWNED BY public.res_config_installer.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    company_id integer NOT NULL,
    user_default_rights boolean,
    external_email_server_default boolean,
    module_base_import boolean,
    module_google_calendar boolean,
    module_microsoft_calendar boolean,
    module_mail_plugin boolean,
    module_auth_oauth boolean,
    module_auth_ldap boolean,
    module_base_gengo boolean,
    module_account_inter_company_rules boolean,
    module_voip boolean,
    module_web_unsplash boolean,
    module_partner_autocomplete boolean,
    module_base_geolocalize boolean,
    module_google_recaptcha boolean,
    group_multi_currency boolean,
    show_effect boolean,
    module_product_images boolean,
    profiling_enabled_until timestamp without time zone,
    alias_domain character varying,
    twilio_account_sid character varying,
    twilio_account_token character varying,
    module_google_gmail boolean,
    module_microsoft_outlook boolean,
    restrict_template_rendering boolean,
    use_twilio_rtc_servers boolean,
    group_analytic_accounting boolean,
    auth_signup_template_user_id integer,
    auth_signup_uninvited character varying,
    auth_signup_reset_password boolean,
    module_base_tier_validation_formula boolean,
    module_base_tier_validation_forward boolean,
    google_gmail_client_identifier character varying,
    google_gmail_client_secret character varying,
    module_hr_presence boolean,
    module_hr_skills boolean,
    module_hr_homeworking boolean,
    hr_presence_control_login boolean,
    hr_presence_control_email boolean,
    hr_presence_control_ip boolean,
    module_hr_attendance boolean,
    hr_employee_self_edit boolean,
    product_pricelist_setting character varying,
    product_weight_in_lbs character varying,
    product_volume_volume_in_cubic_feet character varying,
    group_discount_per_so_line boolean,
    group_uom boolean,
    group_product_variant boolean,
    module_sale_product_matrix boolean,
    module_loyalty boolean,
    group_stock_packaging boolean,
    group_product_pricelist boolean,
    group_sale_pricelist boolean,
    unsplash_access_key character varying,
    unsplash_app_id character varying
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.company_id IS 'Company';


--
-- Name: COLUMN res_config_settings.user_default_rights; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.user_default_rights IS 'Default Access Rights';


--
-- Name: COLUMN res_config_settings.external_email_server_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.external_email_server_default IS 'Custom Email Servers';


--
-- Name: COLUMN res_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_import IS 'Allow users to import data from CSV/XLS/XLSX/ODS files';


--
-- Name: COLUMN res_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN res_config_settings.module_microsoft_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_calendar IS 'Allow the users to synchronize their calendar with Outlook Calendar';


--
-- Name: COLUMN res_config_settings.module_mail_plugin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_mail_plugin IS 'Allow integration with the mail plugins';


--
-- Name: COLUMN res_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_oauth IS 'Use external authentication providers (OAuth)';


--
-- Name: COLUMN res_config_settings.module_auth_ldap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_ldap IS 'LDAP Authentication';


--
-- Name: COLUMN res_config_settings.module_base_gengo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_gengo IS 'Translate Your Website with Gengo';


--
-- Name: COLUMN res_config_settings.module_account_inter_company_rules; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_account_inter_company_rules IS 'Manage Inter Company';


--
-- Name: COLUMN res_config_settings.module_voip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_voip IS 'Asterisk (VoIP)';


--
-- Name: COLUMN res_config_settings.module_web_unsplash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_web_unsplash IS 'Unsplash Image Library';


--
-- Name: COLUMN res_config_settings.module_partner_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_partner_autocomplete IS 'Partner Autocomplete';


--
-- Name: COLUMN res_config_settings.module_base_geolocalize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_geolocalize IS 'GeoLocalize';


--
-- Name: COLUMN res_config_settings.module_google_recaptcha; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_recaptcha IS 'reCAPTCHA';


--
-- Name: COLUMN res_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_multi_currency IS 'Multi-Currencies';


--
-- Name: COLUMN res_config_settings.show_effect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.show_effect IS 'Show Effect';


--
-- Name: COLUMN res_config_settings.module_product_images; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_product_images IS 'Get product pictures using barcode';


--
-- Name: COLUMN res_config_settings.profiling_enabled_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.profiling_enabled_until IS 'Profiling enabled until';


--
-- Name: COLUMN res_config_settings.alias_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.alias_domain IS 'Alias Domain';


--
-- Name: COLUMN res_config_settings.twilio_account_sid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_sid IS 'Twilio Account SID';


--
-- Name: COLUMN res_config_settings.twilio_account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_token IS 'Twilio Account Auth Token';


--
-- Name: COLUMN res_config_settings.module_google_gmail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_gmail IS 'Support Gmail Authentication';


--
-- Name: COLUMN res_config_settings.module_microsoft_outlook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_outlook IS 'Support Outlook Authentication';


--
-- Name: COLUMN res_config_settings.restrict_template_rendering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.restrict_template_rendering IS 'Restrict Template Rendering';


--
-- Name: COLUMN res_config_settings.use_twilio_rtc_servers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.use_twilio_rtc_servers IS 'Use Twilio ICE servers';


--
-- Name: COLUMN res_config_settings.group_analytic_accounting; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_analytic_accounting IS 'Analytic Accounting';


--
-- Name: COLUMN res_config_settings.auth_signup_template_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_template_user_id IS 'Template user for new users created through signup';


--
-- Name: COLUMN res_config_settings.auth_signup_uninvited; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_uninvited IS 'Customer Account';


--
-- Name: COLUMN res_config_settings.auth_signup_reset_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_reset_password IS 'Enable password reset from Login page';


--
-- Name: COLUMN res_config_settings.module_base_tier_validation_formula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_tier_validation_formula IS 'Tier Formula';


--
-- Name: COLUMN res_config_settings.module_base_tier_validation_forward; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_tier_validation_forward IS 'Tier Forward & Backward';


--
-- Name: COLUMN res_config_settings.google_gmail_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_identifier IS 'Gmail Client Id';


--
-- Name: COLUMN res_config_settings.google_gmail_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_secret IS 'Gmail Client Secret';


--
-- Name: COLUMN res_config_settings.module_hr_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_hr_presence IS 'Advanced Presence Control';


--
-- Name: COLUMN res_config_settings.module_hr_skills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_hr_skills IS 'Skills Management';


--
-- Name: COLUMN res_config_settings.module_hr_homeworking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_hr_homeworking IS 'Homeworking';


--
-- Name: COLUMN res_config_settings.hr_presence_control_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.hr_presence_control_login IS 'Based on user status in system';


--
-- Name: COLUMN res_config_settings.hr_presence_control_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.hr_presence_control_email IS 'Based on number of emails sent';


--
-- Name: COLUMN res_config_settings.hr_presence_control_ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.hr_presence_control_ip IS 'Based on IP Address';


--
-- Name: COLUMN res_config_settings.module_hr_attendance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_hr_attendance IS 'Based on attendances';


--
-- Name: COLUMN res_config_settings.hr_employee_self_edit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.hr_employee_self_edit IS 'Employee Editing';


--
-- Name: COLUMN res_config_settings.product_pricelist_setting; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.product_pricelist_setting IS 'Pricelists Method';


--
-- Name: COLUMN res_config_settings.product_weight_in_lbs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.product_weight_in_lbs IS 'Weight unit of measure';


--
-- Name: COLUMN res_config_settings.product_volume_volume_in_cubic_feet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.product_volume_volume_in_cubic_feet IS 'Volume unit of measure';


--
-- Name: COLUMN res_config_settings.group_discount_per_so_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_discount_per_so_line IS 'Discounts';


--
-- Name: COLUMN res_config_settings.group_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_uom IS 'Units of Measure';


--
-- Name: COLUMN res_config_settings.group_product_variant; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_product_variant IS 'Variants';


--
-- Name: COLUMN res_config_settings.module_sale_product_matrix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_sale_product_matrix IS 'Sales Grid Entry';


--
-- Name: COLUMN res_config_settings.module_loyalty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_loyalty IS 'Promotions, Coupons, Gift Card & Loyalty Program';


--
-- Name: COLUMN res_config_settings.group_stock_packaging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_stock_packaging IS 'Product Packagings';


--
-- Name: COLUMN res_config_settings.group_product_pricelist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_product_pricelist IS 'Pricelists';


--
-- Name: COLUMN res_config_settings.group_sale_pricelist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_sale_pricelist IS 'Advanced Pricelists';


--
-- Name: COLUMN res_config_settings.unsplash_access_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_access_key IS 'Access Key';


--
-- Name: COLUMN res_config_settings.unsplash_app_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_app_id IS 'Application ID';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2),
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_group_pricelist_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group_pricelist_rel (
    pricelist_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_group_pricelist_rel OWNER TO runbot;

--
-- Name: TABLE res_country_group_pricelist_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group_pricelist_rel IS 'RELATION BETWEEN product_pricelist AND res_country_group';


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label character varying,
    currency_subunit_label character varying,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    category_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.category_id IS 'Application';


--
-- Name: COLUMN res_groups.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.color IS 'Color Index';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_spreadsheet_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_spreadsheet_dashboard_rel (
    spreadsheet_dashboard_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.res_groups_spreadsheet_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_spreadsheet_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_spreadsheet_dashboard_rel IS 'RELATION BETWEEN spreadsheet_dashboard AND res_groups';


--
-- Name: res_groups_tier_validation_exception_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_tier_validation_exception_rel (
    tier_validation_exception_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.res_groups_tier_validation_exception_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_tier_validation_exception_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_tier_validation_exception_rel IS 'RELATION BETWEEN tier_validation_exception AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


ALTER TABLE public.res_lang_install_rel OWNER TO runbot;

--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    title integer,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    display_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    mobile character varying,
    commercial_company_name character varying,
    company_name character varying,
    date date,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    message_main_attachment_id integer,
    message_bounce integer,
    email_normalized character varying,
    signup_type character varying,
    signup_expiration timestamp without time zone,
    signup_token character varying,
    calendar_last_notif_ack timestamp without time zone,
    team_id integer,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.title IS 'Title';


--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.display_name IS 'Display Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.mobile IS 'Mobile';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.date IS 'Date';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN res_partner.message_bounce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.message_bounce IS 'Bounce';


--
-- Name: COLUMN res_partner.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN res_partner.signup_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.signup_type IS 'Signup Token Type';


--
-- Name: COLUMN res_partner.signup_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.signup_expiration IS 'Signup Expiration';


--
-- Name: COLUMN res_partner.calendar_last_notif_ack; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.calendar_last_notif_ack IS 'Last notification marked as read from base Calendar';


--
-- Name: COLUMN res_partner.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.team_id IS 'Sales Team';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Tag Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_partner_title; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_title (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    shortcut jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_title OWNER TO runbot;

--
-- Name: TABLE res_partner_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_title IS 'Partner Title';


--
-- Name: COLUMN res_partner_title.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_title.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_title.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.name IS 'Title';


--
-- Name: COLUMN res_partner_title.shortcut; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.shortcut IS 'Abbreviation';


--
-- Name: COLUMN res_partner_title.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_title.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_date IS 'Last Updated on';


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_title_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_title_id_seq OWNER TO runbot;

--
-- Name: res_partner_title_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_title_id_seq OWNED BY public.res_partner_title.id;


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    default_operating_unit_id integer,
    totp_secret character varying,
    notification_type character varying NOT NULL,
    last_role_line_modification timestamp without time zone,
    odoobot_state character varying,
    odoobot_failed boolean,
    sale_team_id integer,
    CONSTRAINT res_users_notification_type CHECK ((((notification_type)::text = 'email'::text) OR (NOT share)))
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users.default_operating_unit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.default_operating_unit_id IS 'Default Operating Unit';


--
-- Name: COLUMN res_users.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.notification_type IS 'Notification';


--
-- Name: COLUMN res_users.last_role_line_modification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.last_role_line_modification IS 'Last roles modification';


--
-- Name: COLUMN res_users.odoobot_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_state IS 'OdooBot Status';


--
-- Name: COLUMN res_users.odoobot_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_failed IS 'Odoobot Failed';


--
-- Name: COLUMN res_users.sale_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.sale_team_id IS 'User Sales Team';


--
-- Name: CONSTRAINT res_users_notification_type ON res_users; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_notification_type ON public.res_users IS 'CHECK (notification_type = ''email'' OR NOT share)';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8) NOT NULL,
    key character varying NOT NULL,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_deletion OWNER TO runbot;

--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_deletion_id_seq OWNER TO runbot;

--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_effective_permission; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_effective_permission (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    create_domain character varying,
    read_domain character varying,
    write_domain character varying,
    unlink_domain character varying,
    model_human_name jsonb,
    create_permission boolean,
    read_permission boolean,
    write_permission boolean,
    unlink_permission boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_effective_permission OWNER TO runbot;

--
-- Name: TABLE res_users_effective_permission; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_effective_permission IS 'Effective permissions';


--
-- Name: COLUMN res_users_effective_permission.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.model_id IS 'Model';


--
-- Name: COLUMN res_users_effective_permission.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_effective_permission.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_effective_permission.create_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.create_domain IS 'Create restrictions';


--
-- Name: COLUMN res_users_effective_permission.read_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.read_domain IS 'Read restrictions';


--
-- Name: COLUMN res_users_effective_permission.write_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.write_domain IS 'Write restrictions';


--
-- Name: COLUMN res_users_effective_permission.unlink_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.unlink_domain IS 'Delete restrictions';


--
-- Name: COLUMN res_users_effective_permission.model_human_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.model_human_name IS 'Human readable model name';


--
-- Name: COLUMN res_users_effective_permission.create_permission; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.create_permission IS 'Create';


--
-- Name: COLUMN res_users_effective_permission.read_permission; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.read_permission IS 'Read';


--
-- Name: COLUMN res_users_effective_permission.write_permission; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.write_permission IS 'Write';


--
-- Name: COLUMN res_users_effective_permission.unlink_permission; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.unlink_permission IS 'Delete';


--
-- Name: COLUMN res_users_effective_permission.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.create_date IS 'Created on';


--
-- Name: COLUMN res_users_effective_permission.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_effective_permission.write_date IS 'Last Updated on';


--
-- Name: res_users_effective_permission_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_effective_permission_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_effective_permission_id_seq OWNER TO runbot;

--
-- Name: res_users_effective_permission_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_effective_permission_id_seq OWNED BY public.res_users_effective_permission.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.password IS 'Password';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: res_users_role; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_role (
    id integer NOT NULL,
    group_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_role OWNER TO runbot;

--
-- Name: TABLE res_users_role; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_role IS 'User role';


--
-- Name: COLUMN res_users_role.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role.group_id IS 'Associated group';


--
-- Name: COLUMN res_users_role.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_role.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_role.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role.create_date IS 'Created on';


--
-- Name: COLUMN res_users_role.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role.write_date IS 'Last Updated on';


--
-- Name: res_users_role_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_role_id_seq OWNER TO runbot;

--
-- Name: res_users_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_role_id_seq OWNED BY public.res_users_role.id;


--
-- Name: res_users_role_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_role_line (
    id integer NOT NULL,
    role_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date,
    date_to date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    company_id integer
);


ALTER TABLE public.res_users_role_line OWNER TO runbot;

--
-- Name: TABLE res_users_role_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_role_line IS 'Users associated to a role';


--
-- Name: COLUMN res_users_role_line.role_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role_line.role_id IS 'Role';


--
-- Name: COLUMN res_users_role_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role_line.user_id IS 'User';


--
-- Name: COLUMN res_users_role_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role_line.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_role_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_role_line.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role_line.date_from IS 'From';


--
-- Name: COLUMN res_users_role_line.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role_line.date_to IS 'To';


--
-- Name: COLUMN res_users_role_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role_line.create_date IS 'Created on';


--
-- Name: COLUMN res_users_role_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_role_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_role_line.company_id IS 'Company';


--
-- Name: res_users_role_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_role_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_role_line_id_seq OWNER TO runbot;

--
-- Name: res_users_role_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_role_line_id_seq OWNED BY public.res_users_role_line.id;


--
-- Name: res_users_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    voice_active_duration integer,
    create_uid integer,
    write_uid integer,
    push_to_talk_key character varying,
    is_discuss_sidebar_category_channel_open boolean,
    is_discuss_sidebar_category_chat_open boolean,
    use_push_to_talk boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_settings OWNER TO runbot;

--
-- Name: TABLE res_users_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings IS 'User Settings';


--
-- Name: COLUMN res_users_settings.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.user_id IS 'User';


--
-- Name: COLUMN res_users_settings.voice_active_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.voice_active_duration IS 'Duration of voice activity in ms';


--
-- Name: COLUMN res_users_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings.push_to_talk_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.push_to_talk_key IS 'Push-To-Talk shortcut';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_channel_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_channel_open IS 'Is discuss sidebar category channel open?';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_chat_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_chat_open IS 'Is discuss sidebar category chat open?';


--
-- Name: COLUMN res_users_settings.use_push_to_talk; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.use_push_to_talk IS 'Use the push to talk feature';


--
-- Name: COLUMN res_users_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_date IS 'Last Updated on';


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_id_seq OWNED BY public.res_users_settings.id;


--
-- Name: res_users_settings_volumes; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings_volumes (
    id integer NOT NULL,
    user_setting_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    volume double precision,
    CONSTRAINT res_users_settings_volumes_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.res_users_settings_volumes OWNER TO runbot;

--
-- Name: TABLE res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings_volumes IS 'User Settings Volumes';


--
-- Name: COLUMN res_users_settings_volumes.user_setting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.user_setting_id IS 'User Setting';


--
-- Name: COLUMN res_users_settings_volumes.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.partner_id IS 'Partner';


--
-- Name: COLUMN res_users_settings_volumes.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.guest_id IS 'Guest';


--
-- Name: COLUMN res_users_settings_volumes.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings_volumes.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings_volumes.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings_volumes.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_settings_volumes.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.volume IS 'Volume';


--
-- Name: CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON public.res_users_settings_volumes IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_volumes_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNED BY public.res_users_settings_volumes.id;


--
-- Name: res_users_tier_review_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_tier_review_rel (
    tier_review_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_users_tier_review_rel OWNER TO runbot;

--
-- Name: TABLE res_users_tier_review_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_tier_review_rel IS 'RELATION BETWEEN tier_review AND res_users';


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: resource_calendar; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    tz character varying NOT NULL,
    active boolean,
    two_weeks_calendar boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    hours_per_day double precision
);


ALTER TABLE public.resource_calendar OWNER TO runbot;

--
-- Name: TABLE resource_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar IS 'Resource Working Time';


--
-- Name: COLUMN resource_calendar.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.name IS 'Name';


--
-- Name: COLUMN resource_calendar.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.tz IS 'Timezone';


--
-- Name: COLUMN resource_calendar.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.active IS 'Active';


--
-- Name: COLUMN resource_calendar.two_weeks_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.two_weeks_calendar IS 'Calendar in 2 weeks mode';


--
-- Name: COLUMN resource_calendar.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_calendar.hours_per_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.hours_per_day IS 'Average Hour per Day';


--
-- Name: resource_calendar_attendance; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar_attendance (
    id integer NOT NULL,
    calendar_id integer NOT NULL,
    resource_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    dayofweek character varying NOT NULL,
    day_period character varying NOT NULL,
    week_type character varying,
    display_type character varying,
    date_from date,
    date_to date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    hour_from double precision NOT NULL,
    hour_to double precision NOT NULL
);


ALTER TABLE public.resource_calendar_attendance OWNER TO runbot;

--
-- Name: TABLE resource_calendar_attendance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar_attendance IS 'Work Detail';


--
-- Name: COLUMN resource_calendar_attendance.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.calendar_id IS 'Resource''s Calendar';


--
-- Name: COLUMN resource_calendar_attendance.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.resource_id IS 'Resource';


--
-- Name: COLUMN resource_calendar_attendance.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.sequence IS 'Sequence';


--
-- Name: COLUMN resource_calendar_attendance.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar_attendance.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar_attendance.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.name IS 'Name';


--
-- Name: COLUMN resource_calendar_attendance.dayofweek; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.dayofweek IS 'Day of Week';


--
-- Name: COLUMN resource_calendar_attendance.day_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.day_period IS 'Day Period';


--
-- Name: COLUMN resource_calendar_attendance.week_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.week_type IS 'Week Number';


--
-- Name: COLUMN resource_calendar_attendance.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.display_type IS 'Display Type';


--
-- Name: COLUMN resource_calendar_attendance.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.date_from IS 'Starting Date';


--
-- Name: COLUMN resource_calendar_attendance.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.date_to IS 'End Date';


--
-- Name: COLUMN resource_calendar_attendance.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar_attendance.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_calendar_attendance.hour_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.hour_from IS 'Work from';


--
-- Name: COLUMN resource_calendar_attendance.hour_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.hour_to IS 'Work to';


--
-- Name: resource_calendar_attendance_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_attendance_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_attendance_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_attendance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_attendance_id_seq OWNED BY public.resource_calendar_attendance.id;


--
-- Name: resource_calendar_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_id_seq OWNED BY public.resource_calendar.id;


--
-- Name: resource_calendar_leaves; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar_leaves (
    id integer NOT NULL,
    company_id integer,
    calendar_id integer,
    resource_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    time_type character varying,
    date_from timestamp without time zone NOT NULL,
    date_to timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.resource_calendar_leaves OWNER TO runbot;

--
-- Name: TABLE resource_calendar_leaves; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar_leaves IS 'Resource Time Off Detail';


--
-- Name: COLUMN resource_calendar_leaves.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar_leaves.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.calendar_id IS 'Working Hours';


--
-- Name: COLUMN resource_calendar_leaves.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.resource_id IS 'Resource';


--
-- Name: COLUMN resource_calendar_leaves.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar_leaves.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar_leaves.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.name IS 'Reason';


--
-- Name: COLUMN resource_calendar_leaves.time_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.time_type IS 'Time Type';


--
-- Name: COLUMN resource_calendar_leaves.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.date_from IS 'Start Date';


--
-- Name: COLUMN resource_calendar_leaves.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.date_to IS 'End Date';


--
-- Name: COLUMN resource_calendar_leaves.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar_leaves.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.write_date IS 'Last Updated on';


--
-- Name: resource_calendar_leaves_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_leaves_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_leaves_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_leaves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_leaves_id_seq OWNED BY public.resource_calendar_leaves.id;


--
-- Name: resource_resource; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_resource (
    id integer NOT NULL,
    company_id integer,
    user_id integer,
    calendar_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    resource_type character varying NOT NULL,
    tz character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    time_efficiency double precision NOT NULL,
    CONSTRAINT resource_resource_check_time_efficiency CHECK ((time_efficiency > (0)::double precision))
);


ALTER TABLE public.resource_resource OWNER TO runbot;

--
-- Name: TABLE resource_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_resource IS 'Resources';


--
-- Name: COLUMN resource_resource.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.company_id IS 'Company';


--
-- Name: COLUMN resource_resource.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.user_id IS 'User';


--
-- Name: COLUMN resource_resource.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.calendar_id IS 'Working Time';


--
-- Name: COLUMN resource_resource.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.create_uid IS 'Created by';


--
-- Name: COLUMN resource_resource.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_resource.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.name IS 'Name';


--
-- Name: COLUMN resource_resource.resource_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.resource_type IS 'Type';


--
-- Name: COLUMN resource_resource.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.tz IS 'Timezone';


--
-- Name: COLUMN resource_resource.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.active IS 'Active';


--
-- Name: COLUMN resource_resource.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.create_date IS 'Created on';


--
-- Name: COLUMN resource_resource.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_resource.time_efficiency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.time_efficiency IS 'Efficiency Factor';


--
-- Name: CONSTRAINT resource_resource_check_time_efficiency ON resource_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT resource_resource_check_time_efficiency ON public.resource_resource IS 'CHECK(time_efficiency>0)';


--
-- Name: resource_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_resource_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_resource_id_seq OWNER TO runbot;

--
-- Name: resource_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_resource_id_seq OWNED BY public.resource_resource.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: spreadsheet_dashboard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_dashboard (
    id integer NOT NULL,
    dashboard_group_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.spreadsheet_dashboard OWNER TO runbot;

--
-- Name: TABLE spreadsheet_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_dashboard IS 'Spreadsheet Dashboard';


--
-- Name: COLUMN spreadsheet_dashboard.dashboard_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.dashboard_group_id IS 'Dashboard Group';


--
-- Name: COLUMN spreadsheet_dashboard.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.sequence IS 'Sequence';


--
-- Name: COLUMN spreadsheet_dashboard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_dashboard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_dashboard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.name IS 'Name';


--
-- Name: COLUMN spreadsheet_dashboard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_dashboard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.write_date IS 'Last Updated on';


--
-- Name: spreadsheet_dashboard_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_dashboard_group (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.spreadsheet_dashboard_group OWNER TO runbot;

--
-- Name: TABLE spreadsheet_dashboard_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_dashboard_group IS 'Group of dashboards';


--
-- Name: COLUMN spreadsheet_dashboard_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.sequence IS 'Sequence';


--
-- Name: COLUMN spreadsheet_dashboard_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_dashboard_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_dashboard_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.name IS 'Name';


--
-- Name: COLUMN spreadsheet_dashboard_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_dashboard_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.write_date IS 'Last Updated on';


--
-- Name: spreadsheet_dashboard_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_dashboard_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_dashboard_group_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_dashboard_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_dashboard_group_id_seq OWNED BY public.spreadsheet_dashboard_group.id;


--
-- Name: spreadsheet_dashboard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_dashboard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_dashboard_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_dashboard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_dashboard_id_seq OWNED BY public.spreadsheet_dashboard.id;


--
-- Name: target_state_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.target_state_value (
    id integer NOT NULL,
    base_substate_type_id integer,
    create_uid integer,
    write_uid integer,
    target_state_value character varying NOT NULL,
    model character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.target_state_value OWNER TO runbot;

--
-- Name: TABLE target_state_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.target_state_value IS 'Target State Value';


--
-- Name: COLUMN target_state_value.base_substate_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.target_state_value.base_substate_type_id IS 'Substate Type';


--
-- Name: COLUMN target_state_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.target_state_value.create_uid IS 'Created by';


--
-- Name: COLUMN target_state_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.target_state_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN target_state_value.target_state_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.target_state_value.target_state_value IS 'Target State Value';


--
-- Name: COLUMN target_state_value.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.target_state_value.model IS 'Apply on';


--
-- Name: COLUMN target_state_value.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.target_state_value.name IS 'Target state Name';


--
-- Name: COLUMN target_state_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.target_state_value.create_date IS 'Created on';


--
-- Name: COLUMN target_state_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.target_state_value.write_date IS 'Last Updated on';


--
-- Name: target_state_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.target_state_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.target_state_value_id_seq OWNER TO runbot;

--
-- Name: target_state_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.target_state_value_id_seq OWNED BY public.target_state_value.id;


--
-- Name: team_favorite_user_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.team_favorite_user_rel (
    team_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.team_favorite_user_rel OWNER TO runbot;

--
-- Name: TABLE team_favorite_user_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.team_favorite_user_rel IS 'RELATION BETWEEN crm_team AND res_users';


--
-- Name: tier_definition; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.tier_definition (
    id integer NOT NULL,
    model_id integer,
    reviewer_id integer,
    reviewer_group_id integer,
    reviewer_field_id integer,
    sequence integer,
    company_id integer,
    notify_reminder_delay integer,
    create_uid integer,
    write_uid integer,
    model character varying,
    review_type character varying,
    definition_type character varying,
    definition_domain character varying,
    name jsonb NOT NULL,
    active boolean,
    notify_on_create boolean,
    notify_on_accepted boolean,
    notify_on_rejected boolean,
    notify_on_restarted boolean,
    has_comment boolean,
    approve_sequence boolean,
    approve_sequence_bypass boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    has_approve_comment boolean,
    has_reject_comment boolean,
    python_code text,
    reviewer_expression text,
    has_forward boolean,
    server_action_id integer,
    rejected_server_action_id integer,
    auto_validate_domain character varying,
    auto_validate boolean
);


ALTER TABLE public.tier_definition OWNER TO runbot;

--
-- Name: TABLE tier_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.tier_definition IS 'Tier Definition';


--
-- Name: COLUMN tier_definition.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.model_id IS 'Referenced Model';


--
-- Name: COLUMN tier_definition.reviewer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.reviewer_id IS 'Reviewer';


--
-- Name: COLUMN tier_definition.reviewer_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.reviewer_group_id IS 'Reviewer group';


--
-- Name: COLUMN tier_definition.reviewer_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.reviewer_field_id IS 'Reviewer field';


--
-- Name: COLUMN tier_definition.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.sequence IS 'Sequence';


--
-- Name: COLUMN tier_definition.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.company_id IS 'Company';


--
-- Name: COLUMN tier_definition.notify_reminder_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.notify_reminder_delay IS 'Send reminder message on pending reviews';


--
-- Name: COLUMN tier_definition.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.create_uid IS 'Created by';


--
-- Name: COLUMN tier_definition.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.write_uid IS 'Last Updated by';


--
-- Name: COLUMN tier_definition.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.model IS 'Model';


--
-- Name: COLUMN tier_definition.review_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.review_type IS 'Validated by';


--
-- Name: COLUMN tier_definition.definition_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.definition_type IS 'Definition';


--
-- Name: COLUMN tier_definition.definition_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.definition_domain IS 'Definition Domain';


--
-- Name: COLUMN tier_definition.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.name IS 'Description';


--
-- Name: COLUMN tier_definition.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.active IS 'Active';


--
-- Name: COLUMN tier_definition.notify_on_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.notify_on_create IS 'Notify Reviewers on Creation';


--
-- Name: COLUMN tier_definition.notify_on_accepted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.notify_on_accepted IS 'Notify Reviewers on Accepted';


--
-- Name: COLUMN tier_definition.notify_on_rejected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.notify_on_rejected IS 'Notify Reviewers on Rejected';


--
-- Name: COLUMN tier_definition.notify_on_restarted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.notify_on_restarted IS 'Notify Reviewers on Restarted';


--
-- Name: COLUMN tier_definition.has_comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.has_comment IS 'Comment';


--
-- Name: COLUMN tier_definition.approve_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.approve_sequence IS 'Approve by sequence';


--
-- Name: COLUMN tier_definition.approve_sequence_bypass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.approve_sequence_bypass IS 'Approve Sequence Bypass';


--
-- Name: COLUMN tier_definition.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.create_date IS 'Created on';


--
-- Name: COLUMN tier_definition.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.write_date IS 'Last Updated on';


--
-- Name: COLUMN tier_definition.has_approve_comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.has_approve_comment IS 'Approve Comment';


--
-- Name: COLUMN tier_definition.has_reject_comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.has_reject_comment IS 'Reject Comment';


--
-- Name: COLUMN tier_definition.python_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.python_code IS 'Tier Definition Expression';


--
-- Name: COLUMN tier_definition.reviewer_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.reviewer_expression IS 'Review Expression';


--
-- Name: COLUMN tier_definition.has_forward; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.has_forward IS 'Allow Forward';


--
-- Name: COLUMN tier_definition.server_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.server_action_id IS 'Post Approve Action';


--
-- Name: COLUMN tier_definition.rejected_server_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.rejected_server_action_id IS 'Post Reject Action';


--
-- Name: COLUMN tier_definition.auto_validate_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.auto_validate_domain IS 'Auto Validate Domain';


--
-- Name: COLUMN tier_definition.auto_validate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_definition.auto_validate IS 'Auto Validate';


--
-- Name: tier_definition_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.tier_definition_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tier_definition_id_seq OWNER TO runbot;

--
-- Name: tier_definition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.tier_definition_id_seq OWNED BY public.tier_definition.id;


--
-- Name: tier_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.tier_review (
    id integer NOT NULL,
    res_id integer,
    definition_id integer,
    company_id integer,
    sequence integer,
    done_by integer,
    requested_by integer,
    create_uid integer,
    write_uid integer,
    status character varying,
    model character varying,
    todo_by character varying,
    comment character varying,
    can_review boolean,
    reviewed_date timestamp without time zone,
    last_reminder_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    reviewer_id integer,
    reviewer_group_id integer,
    review_type character varying,
    name jsonb,
    has_comment boolean,
    approve_sequence boolean
);


ALTER TABLE public.tier_review OWNER TO runbot;

--
-- Name: TABLE tier_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.tier_review IS 'Tier Review';


--
-- Name: COLUMN tier_review.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.res_id IS 'Related Document ID';


--
-- Name: COLUMN tier_review.definition_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.definition_id IS 'Definition';


--
-- Name: COLUMN tier_review.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.company_id IS 'Company';


--
-- Name: COLUMN tier_review.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.sequence IS 'Tier';


--
-- Name: COLUMN tier_review.done_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.done_by IS 'Done By';


--
-- Name: COLUMN tier_review.requested_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.requested_by IS 'Requested By';


--
-- Name: COLUMN tier_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.create_uid IS 'Created by';


--
-- Name: COLUMN tier_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN tier_review.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.status IS 'Status';


--
-- Name: COLUMN tier_review.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.model IS 'Related Document Model';


--
-- Name: COLUMN tier_review.todo_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.todo_by IS 'Todo By';


--
-- Name: COLUMN tier_review.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.comment IS 'Comments';


--
-- Name: COLUMN tier_review.can_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.can_review IS 'Can Review';


--
-- Name: COLUMN tier_review.reviewed_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.reviewed_date IS 'Validation Date';


--
-- Name: COLUMN tier_review.last_reminder_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.last_reminder_date IS 'Last Reminder Date';


--
-- Name: COLUMN tier_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.create_date IS 'Created on';


--
-- Name: COLUMN tier_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.write_date IS 'Last Updated on';


--
-- Name: COLUMN tier_review.reviewer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.reviewer_id IS 'Reviewer';


--
-- Name: COLUMN tier_review.reviewer_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.reviewer_group_id IS 'Reviewer group';


--
-- Name: COLUMN tier_review.review_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.review_type IS 'Validated by';


--
-- Name: COLUMN tier_review.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.name IS 'Description';


--
-- Name: COLUMN tier_review.has_comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.has_comment IS 'Comment';


--
-- Name: COLUMN tier_review.approve_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_review.approve_sequence IS 'Approve by sequence';


--
-- Name: tier_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.tier_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tier_review_id_seq OWNER TO runbot;

--
-- Name: tier_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.tier_review_id_seq OWNED BY public.tier_review.id;


--
-- Name: tier_review_python_reviewer_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.tier_review_python_reviewer_rel (
    tier_review_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.tier_review_python_reviewer_rel OWNER TO runbot;

--
-- Name: TABLE tier_review_python_reviewer_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.tier_review_python_reviewer_rel IS 'RELATION BETWEEN tier_review AND res_users';


--
-- Name: tier_validation_exception; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.tier_validation_exception (
    id integer NOT NULL,
    model_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model_name character varying,
    allowed_to_write_under_validation boolean,
    allowed_to_write_after_validation boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.tier_validation_exception OWNER TO runbot;

--
-- Name: TABLE tier_validation_exception; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.tier_validation_exception IS 'Tier Validation Exceptions';


--
-- Name: COLUMN tier_validation_exception.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_exception.model_id IS 'Model';


--
-- Name: COLUMN tier_validation_exception.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_exception.company_id IS 'Company';


--
-- Name: COLUMN tier_validation_exception.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_exception.create_uid IS 'Created by';


--
-- Name: COLUMN tier_validation_exception.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_exception.write_uid IS 'Last Updated by';


--
-- Name: COLUMN tier_validation_exception.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_exception.name IS 'Name';


--
-- Name: COLUMN tier_validation_exception.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_exception.model_name IS 'Model Name';


--
-- Name: COLUMN tier_validation_exception.allowed_to_write_under_validation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_exception.allowed_to_write_under_validation IS 'Write under Validation';


--
-- Name: COLUMN tier_validation_exception.allowed_to_write_after_validation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_exception.allowed_to_write_after_validation IS 'Write after Validation';


--
-- Name: COLUMN tier_validation_exception.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_exception.create_date IS 'Created on';


--
-- Name: COLUMN tier_validation_exception.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_exception.write_date IS 'Last Updated on';


--
-- Name: tier_validation_exception_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.tier_validation_exception_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tier_validation_exception_id_seq OWNER TO runbot;

--
-- Name: tier_validation_exception_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.tier_validation_exception_id_seq OWNED BY public.tier_validation_exception.id;


--
-- Name: tier_validation_forward_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.tier_validation_forward_wizard (
    id integer NOT NULL,
    res_id integer,
    forward_reviewer_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    forward_description character varying,
    has_comment boolean,
    approve_sequence boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.tier_validation_forward_wizard OWNER TO runbot;

--
-- Name: TABLE tier_validation_forward_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.tier_validation_forward_wizard IS 'Forward Wizard';


--
-- Name: COLUMN tier_validation_forward_wizard.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_forward_wizard.res_id IS 'Res';


--
-- Name: COLUMN tier_validation_forward_wizard.forward_reviewer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_forward_wizard.forward_reviewer_id IS 'Next Reviewer';


--
-- Name: COLUMN tier_validation_forward_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_forward_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN tier_validation_forward_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_forward_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN tier_validation_forward_wizard.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_forward_wizard.res_model IS 'Res Model';


--
-- Name: COLUMN tier_validation_forward_wizard.forward_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_forward_wizard.forward_description IS 'Forward Description';


--
-- Name: COLUMN tier_validation_forward_wizard.has_comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_forward_wizard.has_comment IS 'Allow Comment';


--
-- Name: COLUMN tier_validation_forward_wizard.approve_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_forward_wizard.approve_sequence IS 'Approve by sequence';


--
-- Name: COLUMN tier_validation_forward_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_forward_wizard.create_date IS 'Created on';


--
-- Name: COLUMN tier_validation_forward_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.tier_validation_forward_wizard.write_date IS 'Last Updated on';


--
-- Name: tier_validation_forward_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.tier_validation_forward_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.tier_validation_forward_wizard_id_seq OWNER TO runbot;

--
-- Name: tier_validation_forward_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.tier_validation_forward_wizard_id_seq OWNED BY public.tier_validation_forward_wizard.id;


--
-- Name: uom_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.uom_category (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.uom_category OWNER TO runbot;

--
-- Name: TABLE uom_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.uom_category IS 'Product UoM Categories';


--
-- Name: COLUMN uom_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_category.create_uid IS 'Created by';


--
-- Name: COLUMN uom_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN uom_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_category.name IS 'Unit of Measure Category';


--
-- Name: COLUMN uom_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_category.create_date IS 'Created on';


--
-- Name: COLUMN uom_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_category.write_date IS 'Last Updated on';


--
-- Name: uom_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.uom_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.uom_category_id_seq OWNER TO runbot;

--
-- Name: uom_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.uom_category_id_seq OWNED BY public.uom_category.id;


--
-- Name: uom_uom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.uom_uom (
    id integer NOT NULL,
    category_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    uom_type character varying NOT NULL,
    name jsonb NOT NULL,
    factor numeric NOT NULL,
    rounding numeric NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT uom_uom_factor_gt_zero CHECK ((factor <> (0)::numeric)),
    CONSTRAINT uom_uom_factor_reference_is_one CHECK (((((uom_type)::text = 'reference'::text) AND (factor = 1.0)) OR ((uom_type)::text <> 'reference'::text))),
    CONSTRAINT uom_uom_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.uom_uom OWNER TO runbot;

--
-- Name: TABLE uom_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.uom_uom IS 'Product Unit of Measure';


--
-- Name: COLUMN uom_uom.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.category_id IS 'Category';


--
-- Name: COLUMN uom_uom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.create_uid IS 'Created by';


--
-- Name: COLUMN uom_uom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN uom_uom.uom_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.uom_type IS 'Type';


--
-- Name: COLUMN uom_uom.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.name IS 'Unit of Measure';


--
-- Name: COLUMN uom_uom.factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.factor IS 'Ratio';


--
-- Name: COLUMN uom_uom.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.rounding IS 'Rounding Precision';


--
-- Name: COLUMN uom_uom.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.active IS 'Active';


--
-- Name: COLUMN uom_uom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.create_date IS 'Created on';


--
-- Name: COLUMN uom_uom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT uom_uom_factor_gt_zero ON uom_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT uom_uom_factor_gt_zero ON public.uom_uom IS 'CHECK (factor!=0)';


--
-- Name: CONSTRAINT uom_uom_factor_reference_is_one ON uom_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT uom_uom_factor_reference_is_one ON public.uom_uom IS 'CHECK((uom_type = ''reference'' AND factor = 1.0) OR (uom_type != ''reference''))';


--
-- Name: CONSTRAINT uom_uom_rounding_gt_zero ON uom_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT uom_uom_rounding_gt_zero ON public.uom_uom IS 'CHECK (rounding>0)';


--
-- Name: uom_uom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.uom_uom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.uom_uom_id_seq OWNER TO runbot;

--
-- Name: uom_uom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.uom_uom_id_seq OWNED BY public.uom_uom.id;


--
-- Name: utm_campaign; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_campaign (
    id integer NOT NULL,
    user_id integer NOT NULL,
    stage_id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    title jsonb NOT NULL,
    is_auto_campaign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.utm_campaign OWNER TO runbot;

--
-- Name: TABLE utm_campaign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_campaign IS 'UTM Campaign';


--
-- Name: COLUMN utm_campaign.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.user_id IS 'Responsible';


--
-- Name: COLUMN utm_campaign.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.stage_id IS 'Stage';


--
-- Name: COLUMN utm_campaign.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.color IS 'Color Index';


--
-- Name: COLUMN utm_campaign.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.create_uid IS 'Created by';


--
-- Name: COLUMN utm_campaign.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_campaign.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.name IS 'Campaign Identifier';


--
-- Name: COLUMN utm_campaign.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.title IS 'Campaign Name';


--
-- Name: COLUMN utm_campaign.is_auto_campaign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.is_auto_campaign IS 'Automatically Generated Campaign';


--
-- Name: COLUMN utm_campaign.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.create_date IS 'Created on';


--
-- Name: COLUMN utm_campaign.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.write_date IS 'Last Updated on';


--
-- Name: utm_campaign_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.utm_campaign_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.utm_campaign_id_seq OWNER TO runbot;

--
-- Name: utm_campaign_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.utm_campaign_id_seq OWNED BY public.utm_campaign.id;


--
-- Name: utm_medium; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_medium (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.utm_medium OWNER TO runbot;

--
-- Name: TABLE utm_medium; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_medium IS 'UTM Medium';


--
-- Name: COLUMN utm_medium.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.create_uid IS 'Created by';


--
-- Name: COLUMN utm_medium.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_medium.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.name IS 'Medium Name';


--
-- Name: COLUMN utm_medium.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.active IS 'Active';


--
-- Name: COLUMN utm_medium.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.create_date IS 'Created on';


--
-- Name: COLUMN utm_medium.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.write_date IS 'Last Updated on';


--
-- Name: utm_medium_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.utm_medium_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.utm_medium_id_seq OWNER TO runbot;

--
-- Name: utm_medium_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.utm_medium_id_seq OWNED BY public.utm_medium.id;


--
-- Name: utm_source; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_source (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.utm_source OWNER TO runbot;

--
-- Name: TABLE utm_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_source IS 'UTM Source';


--
-- Name: COLUMN utm_source.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.create_uid IS 'Created by';


--
-- Name: COLUMN utm_source.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_source.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.name IS 'Source Name';


--
-- Name: COLUMN utm_source.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.create_date IS 'Created on';


--
-- Name: COLUMN utm_source.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.write_date IS 'Last Updated on';


--
-- Name: utm_source_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.utm_source_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.utm_source_id_seq OWNER TO runbot;

--
-- Name: utm_source_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.utm_source_id_seq OWNED BY public.utm_source.id;


--
-- Name: utm_stage; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_stage (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.utm_stage OWNER TO runbot;

--
-- Name: TABLE utm_stage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_stage IS 'Campaign Stage';


--
-- Name: COLUMN utm_stage.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.sequence IS 'Sequence';


--
-- Name: COLUMN utm_stage.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.create_uid IS 'Created by';


--
-- Name: COLUMN utm_stage.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_stage.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.name IS 'Name';


--
-- Name: COLUMN utm_stage.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.create_date IS 'Created on';


--
-- Name: COLUMN utm_stage.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.write_date IS 'Last Updated on';


--
-- Name: utm_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.utm_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.utm_stage_id_seq OWNER TO runbot;

--
-- Name: utm_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.utm_stage_id_seq OWNED BY public.utm_stage.id;


--
-- Name: utm_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.utm_tag OWNER TO runbot;

--
-- Name: TABLE utm_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_tag IS 'UTM Tag';


--
-- Name: COLUMN utm_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.color IS 'Color Index';


--
-- Name: COLUMN utm_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN utm_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.name IS 'Name';


--
-- Name: COLUMN utm_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.create_date IS 'Created on';


--
-- Name: COLUMN utm_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.write_date IS 'Last Updated on';


--
-- Name: utm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.utm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.utm_tag_id_seq OWNER TO runbot;

--
-- Name: utm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.utm_tag_id_seq OWNED BY public.utm_tag.id;


--
-- Name: utm_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_tag_rel (
    tag_id integer NOT NULL,
    campaign_id integer NOT NULL
);


ALTER TABLE public.utm_tag_rel OWNER TO runbot;

--
-- Name: TABLE utm_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_tag_rel IS 'RELATION BETWEEN utm_campaign AND utm_tag';


--
-- Name: web_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


ALTER TABLE public.web_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test IS 'Web Editor Converter Test';


--
-- Name: COLUMN web_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN web_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN web_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN web_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN web_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN web_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN web_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN web_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN web_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN web_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN web_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN web_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."binary" IS 'Binary';


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNED BY public.web_editor_converter_test.id;


--
-- Name: web_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test_sub IS 'Web Editor Converter Subtest';


--
-- Name: COLUMN web_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN web_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNED BY public.web_editor_converter_test_sub.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    user_id integer,
    name character varying NOT NULL
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.user_id IS 'Consumed by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Tour name';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: wizard_create_role_from_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_create_role_from_user (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    assign_to_user boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_create_role_from_user OWNER TO runbot;

--
-- Name: TABLE wizard_create_role_from_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_create_role_from_user IS 'Create role from user wizard';


--
-- Name: COLUMN wizard_create_role_from_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_create_role_from_user.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_create_role_from_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_create_role_from_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_create_role_from_user.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_create_role_from_user.name IS 'Name';


--
-- Name: COLUMN wizard_create_role_from_user.assign_to_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_create_role_from_user.assign_to_user IS 'Assign to user';


--
-- Name: COLUMN wizard_create_role_from_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_create_role_from_user.create_date IS 'Created on';


--
-- Name: COLUMN wizard_create_role_from_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_create_role_from_user.write_date IS 'Last Updated on';


--
-- Name: wizard_create_role_from_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_create_role_from_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_create_role_from_user_id_seq OWNER TO runbot;

--
-- Name: wizard_create_role_from_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_create_role_from_user_id_seq OWNED BY public.wizard_create_role_from_user.id;


--
-- Name: wizard_groups_into_role; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_groups_into_role (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_groups_into_role OWNER TO runbot;

--
-- Name: TABLE wizard_groups_into_role; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_groups_into_role IS 'Group groups into a role';


--
-- Name: COLUMN wizard_groups_into_role.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_groups_into_role.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_groups_into_role.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_groups_into_role.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_groups_into_role.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_groups_into_role.name IS 'Name';


--
-- Name: COLUMN wizard_groups_into_role.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_groups_into_role.create_date IS 'Created on';


--
-- Name: COLUMN wizard_groups_into_role.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_groups_into_role.write_date IS 'Last Updated on';


--
-- Name: wizard_groups_into_role_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_groups_into_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_groups_into_role_id_seq OWNER TO runbot;

--
-- Name: wizard_groups_into_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_groups_into_role_id_seq OWNED BY public.wizard_groups_into_role.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: account_analytic_account id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.account_analytic_account ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_account_id_seq'::regclass);


--
-- Name: account_analytic_applicability id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.account_analytic_applicability ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_applicability_id_seq'::regclass);


--
-- Name: account_analytic_distribution_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.account_analytic_distribution_model ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_distribution_model_id_seq'::regclass);


--
-- Name: account_analytic_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.account_analytic_line ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_line_id_seq'::regclass);


--
-- Name: account_analytic_plan id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.account_analytic_plan ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_plan_id_seq'::regclass);


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: barcode_nomenclature id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.barcode_nomenclature ALTER COLUMN id SET DEFAULT nextval('public.barcode_nomenclature_id_seq'::regclass);


--
-- Name: barcode_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.barcode_rule ALTER COLUMN id SET DEFAULT nextval('public.barcode_rule_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_tests_models_char id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_noreadonly id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_noreadonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_noreadonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_readonly id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_readonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_readonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_required id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_required ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_required_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_states id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_states ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_states_id_seq'::regclass);


--
-- Name: base_import_tests_models_char_stillreadonly id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_char_stillreadonly ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_char_stillreadonly_id_seq'::regclass);


--
-- Name: base_import_tests_models_complex id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_complex ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_complex_id_seq'::regclass);


--
-- Name: base_import_tests_models_float id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_float ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_float_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_related id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_related ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_related_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_required id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_required ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_required_id_seq'::regclass);


--
-- Name: base_import_tests_models_m2o_required_related id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_m2o_required_related ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_m2o_required_related_id_seq'::regclass);


--
-- Name: base_import_tests_models_o2m id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_o2m ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_o2m_id_seq'::regclass);


--
-- Name: base_import_tests_models_o2m_child id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_o2m_child ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_o2m_child_id_seq'::regclass);


--
-- Name: base_import_tests_models_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_tests_models_preview ALTER COLUMN id SET DEFAULT nextval('public.base_import_tests_models_preview_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_install_request id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_request ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_request_id_seq'::regclass);


--
-- Name: base_module_install_review id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_review ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_review_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: base_substate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_substate ALTER COLUMN id SET DEFAULT nextval('public.base_substate_id_seq'::regclass);


--
-- Name: base_substate_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_substate_type ALTER COLUMN id SET DEFAULT nextval('public.base_substate_type_id_seq'::regclass);


--
-- Name: base_user_role_line_history id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_user_role_line_history ALTER COLUMN id SET DEFAULT nextval('public.base_user_role_line_history_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: bus_presence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_presence ALTER COLUMN id SET DEFAULT nextval('public.bus_presence_id_seq'::regclass);


--
-- Name: calendar_alarm id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_alarm ALTER COLUMN id SET DEFAULT nextval('public.calendar_alarm_id_seq'::regclass);


--
-- Name: calendar_attendee id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_attendee ALTER COLUMN id SET DEFAULT nextval('public.calendar_attendee_id_seq'::regclass);


--
-- Name: calendar_event id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_event ALTER COLUMN id SET DEFAULT nextval('public.calendar_event_id_seq'::regclass);


--
-- Name: calendar_event_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_event_type ALTER COLUMN id SET DEFAULT nextval('public.calendar_event_type_id_seq'::regclass);


--
-- Name: calendar_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_filters ALTER COLUMN id SET DEFAULT nextval('public.calendar_filters_id_seq'::regclass);


--
-- Name: calendar_provider_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_provider_config ALTER COLUMN id SET DEFAULT nextval('public.calendar_provider_config_id_seq'::regclass);


--
-- Name: calendar_recurrence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_recurrence ALTER COLUMN id SET DEFAULT nextval('public.calendar_recurrence_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: comment_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.comment_wizard ALTER COLUMN id SET DEFAULT nextval('public.comment_wizard_id_seq'::regclass);


--
-- Name: crm_tag id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.crm_tag ALTER COLUMN id SET DEFAULT nextval('public.crm_tag_id_seq'::regclass);


--
-- Name: crm_team id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.crm_team ALTER COLUMN id SET DEFAULT nextval('public.crm_team_id_seq'::regclass);


--
-- Name: crm_team_member id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.crm_team_member ALTER COLUMN id SET DEFAULT nextval('public.crm_team_member_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: exception_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.exception_rule ALTER COLUMN id SET DEFAULT nextval('public.exception_rule_id_seq'::regclass);


--
-- Name: fetchmail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.fetchmail_server ALTER COLUMN id SET DEFAULT nextval('public.fetchmail_server_id_seq'::regclass);


--
-- Name: hr_contract_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_contract_type ALTER COLUMN id SET DEFAULT nextval('public.hr_contract_type_id_seq'::regclass);


--
-- Name: hr_department id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_department ALTER COLUMN id SET DEFAULT nextval('public.hr_department_id_seq'::regclass);


--
-- Name: hr_departure_reason id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_departure_reason ALTER COLUMN id SET DEFAULT nextval('public.hr_departure_reason_id_seq'::regclass);


--
-- Name: hr_departure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_departure_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_departure_wizard_id_seq'::regclass);


--
-- Name: hr_employee id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_id_seq'::regclass);


--
-- Name: hr_employee_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee_category ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_category_id_seq'::regclass);


--
-- Name: hr_job id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_job ALTER COLUMN id SET DEFAULT nextval('public.hr_job_id_seq'::regclass);


--
-- Name: hr_plan id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_plan ALTER COLUMN id SET DEFAULT nextval('public.hr_plan_id_seq'::regclass);


--
-- Name: hr_plan_activity_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_plan_activity_type ALTER COLUMN id SET DEFAULT nextval('public.hr_plan_activity_type_id_seq'::regclass);


--
-- Name: hr_plan_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_plan_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_plan_wizard_id_seq'::regclass);


--
-- Name: hr_work_location id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_work_location ALTER COLUMN id SET DEFAULT nextval('public.hr_work_location_id_seq'::regclass);


--
-- Name: iap_account id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_account ALTER COLUMN id SET DEFAULT nextval('public.iap_account_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_server_mass_edit_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_server_mass_edit_line ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_server_mass_edit_line_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_property id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_property ALTER COLUMN id SET DEFAULT nextval('public.ir_property_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_server_object_lines id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_server_object_lines ALTER COLUMN id SET DEFAULT nextval('public.ir_server_object_lines_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: mail_activity id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_id_seq'::regclass);


--
-- Name: mail_activity_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_type ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_type_id_seq'::regclass);


--
-- Name: mail_alias id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_alias ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_id_seq'::regclass);


--
-- Name: mail_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_id_seq'::regclass);


--
-- Name: mail_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_remove_id_seq'::regclass);


--
-- Name: mail_channel id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_channel ALTER COLUMN id SET DEFAULT nextval('public.mail_channel_id_seq'::regclass);


--
-- Name: mail_channel_member id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_channel_member ALTER COLUMN id SET DEFAULT nextval('public.mail_channel_member_id_seq'::regclass);


--
-- Name: mail_channel_rtc_session id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_channel_rtc_session ALTER COLUMN id SET DEFAULT nextval('public.mail_channel_rtc_session_id_seq'::regclass);


--
-- Name: mail_compose_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_compose_message ALTER COLUMN id SET DEFAULT nextval('public.mail_compose_message_id_seq'::regclass);


--
-- Name: mail_followers id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_followers ALTER COLUMN id SET DEFAULT nextval('public.mail_followers_id_seq'::regclass);


--
-- Name: mail_gateway_allowed id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_gateway_allowed ALTER COLUMN id SET DEFAULT nextval('public.mail_gateway_allowed_id_seq'::regclass);


--
-- Name: mail_guest id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_guest ALTER COLUMN id SET DEFAULT nextval('public.mail_guest_id_seq'::regclass);


--
-- Name: mail_ice_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_ice_server ALTER COLUMN id SET DEFAULT nextval('public.mail_ice_server_id_seq'::regclass);


--
-- Name: mail_link_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_link_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_link_preview_id_seq'::regclass);


--
-- Name: mail_mail id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_mail ALTER COLUMN id SET DEFAULT nextval('public.mail_mail_id_seq'::regclass);


--
-- Name: mail_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message ALTER COLUMN id SET DEFAULT nextval('public.mail_message_id_seq'::regclass);


--
-- Name: mail_message_reaction id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_reaction ALTER COLUMN id SET DEFAULT nextval('public.mail_message_reaction_id_seq'::regclass);


--
-- Name: mail_message_schedule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_schedule ALTER COLUMN id SET DEFAULT nextval('public.mail_message_schedule_id_seq'::regclass);


--
-- Name: mail_message_subtype id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_subtype ALTER COLUMN id SET DEFAULT nextval('public.mail_message_subtype_id_seq'::regclass);


--
-- Name: mail_notification id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_notification ALTER COLUMN id SET DEFAULT nextval('public.mail_notification_id_seq'::regclass);


--
-- Name: mail_resend_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_resend_message ALTER COLUMN id SET DEFAULT nextval('public.mail_resend_message_id_seq'::regclass);


--
-- Name: mail_resend_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_resend_partner ALTER COLUMN id SET DEFAULT nextval('public.mail_resend_partner_id_seq'::regclass);


--
-- Name: mail_shortcode id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_shortcode ALTER COLUMN id SET DEFAULT nextval('public.mail_shortcode_id_seq'::regclass);


--
-- Name: mail_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template ALTER COLUMN id SET DEFAULT nextval('public.mail_template_id_seq'::regclass);


--
-- Name: mail_template_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_template_preview_id_seq'::regclass);


--
-- Name: mail_template_reset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_reset ALTER COLUMN id SET DEFAULT nextval('public.mail_template_reset_id_seq'::regclass);


--
-- Name: mail_tracking_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_tracking_value ALTER COLUMN id SET DEFAULT nextval('public.mail_tracking_value_id_seq'::regclass);


--
-- Name: mail_wizard_invite id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_wizard_invite ALTER COLUMN id SET DEFAULT nextval('public.mail_wizard_invite_id_seq'::regclass);


--
-- Name: mass_editing_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mass_editing_wizard ALTER COLUMN id SET DEFAULT nextval('public.mass_editing_wizard_id_seq'::regclass);


--
-- Name: operating_unit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.operating_unit ALTER COLUMN id SET DEFAULT nextval('public.operating_unit_id_seq'::regclass);


--
-- Name: phone_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_id_seq'::regclass);


--
-- Name: phone_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_remove_id_seq'::regclass);


--
-- Name: privacy_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_log ALTER COLUMN id SET DEFAULT nextval('public.privacy_log_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard_line ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_line_id_seq'::regclass);


--
-- Name: product_attribute id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_attribute ALTER COLUMN id SET DEFAULT nextval('public.product_attribute_id_seq'::regclass);


--
-- Name: product_attribute_custom_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_attribute_custom_value ALTER COLUMN id SET DEFAULT nextval('public.product_attribute_custom_value_id_seq'::regclass);


--
-- Name: product_attribute_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_attribute_value ALTER COLUMN id SET DEFAULT nextval('public.product_attribute_value_id_seq'::regclass);


--
-- Name: product_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_category ALTER COLUMN id SET DEFAULT nextval('public.product_category_id_seq'::regclass);


--
-- Name: product_label_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_label_layout ALTER COLUMN id SET DEFAULT nextval('public.product_label_layout_id_seq'::regclass);


--
-- Name: product_packaging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_packaging ALTER COLUMN id SET DEFAULT nextval('public.product_packaging_id_seq'::regclass);


--
-- Name: product_pricelist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_pricelist ALTER COLUMN id SET DEFAULT nextval('public.product_pricelist_id_seq'::regclass);


--
-- Name: product_pricelist_item id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_pricelist_item ALTER COLUMN id SET DEFAULT nextval('public.product_pricelist_item_id_seq'::regclass);


--
-- Name: product_product id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_product ALTER COLUMN id SET DEFAULT nextval('public.product_product_id_seq'::regclass);


--
-- Name: product_supplierinfo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_supplierinfo ALTER COLUMN id SET DEFAULT nextval('public.product_supplierinfo_id_seq'::regclass);


--
-- Name: product_tag id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_tag ALTER COLUMN id SET DEFAULT nextval('public.product_tag_id_seq'::regclass);


--
-- Name: product_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_template ALTER COLUMN id SET DEFAULT nextval('public.product_template_id_seq'::regclass);


--
-- Name: product_template_attribute_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_template_attribute_exclusion ALTER COLUMN id SET DEFAULT nextval('public.product_template_attribute_exclusion_id_seq'::regclass);


--
-- Name: product_template_attribute_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_template_attribute_line ALTER COLUMN id SET DEFAULT nextval('public.product_template_attribute_line_id_seq'::regclass);


--
-- Name: product_template_attribute_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_template_attribute_value ALTER COLUMN id SET DEFAULT nextval('public.product_template_attribute_value_id_seq'::regclass);


--
-- Name: rating_rating id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.rating_rating ALTER COLUMN id SET DEFAULT nextval('public.rating_rating_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_installer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_installer ALTER COLUMN id SET DEFAULT nextval('public.res_config_installer_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_partner_title id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_title ALTER COLUMN id SET DEFAULT nextval('public.res_partner_title_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_effective_permission id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_effective_permission ALTER COLUMN id SET DEFAULT nextval('public.res_users_effective_permission_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: res_users_role id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_role ALTER COLUMN id SET DEFAULT nextval('public.res_users_role_id_seq'::regclass);


--
-- Name: res_users_role_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_role_line ALTER COLUMN id SET DEFAULT nextval('public.res_users_role_line_id_seq'::regclass);


--
-- Name: res_users_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_id_seq'::regclass);


--
-- Name: res_users_settings_volumes id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings_volumes ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_volumes_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: resource_calendar id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_id_seq'::regclass);


--
-- Name: resource_calendar_attendance id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar_attendance ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_attendance_id_seq'::regclass);


--
-- Name: resource_calendar_leaves id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar_leaves ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_leaves_id_seq'::regclass);


--
-- Name: resource_resource id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_resource ALTER COLUMN id SET DEFAULT nextval('public.resource_resource_id_seq'::regclass);


--
-- Name: spreadsheet_dashboard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_dashboard ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_dashboard_id_seq'::regclass);


--
-- Name: spreadsheet_dashboard_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_dashboard_group ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_dashboard_group_id_seq'::regclass);


--
-- Name: target_state_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.target_state_value ALTER COLUMN id SET DEFAULT nextval('public.target_state_value_id_seq'::regclass);


--
-- Name: tier_definition id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.tier_definition ALTER COLUMN id SET DEFAULT nextval('public.tier_definition_id_seq'::regclass);


--
-- Name: tier_review id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.tier_review ALTER COLUMN id SET DEFAULT nextval('public.tier_review_id_seq'::regclass);


--
-- Name: tier_validation_exception id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.tier_validation_exception ALTER COLUMN id SET DEFAULT nextval('public.tier_validation_exception_id_seq'::regclass);


--
-- Name: tier_validation_forward_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.tier_validation_forward_wizard ALTER COLUMN id SET DEFAULT nextval('public.tier_validation_forward_wizard_id_seq'::regclass);


--
-- Name: uom_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.uom_category ALTER COLUMN id SET DEFAULT nextval('public.uom_category_id_seq'::regclass);


--
-- Name: uom_uom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.uom_uom ALTER COLUMN id SET DEFAULT nextval('public.uom_uom_id_seq'::regclass);


--
-- Name: utm_campaign id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.utm_campaign ALTER COLUMN id SET DEFAULT nextval('public.utm_campaign_id_seq'::regclass);


--
-- Name: utm_medium id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.utm_medium ALTER COLUMN id SET DEFAULT nextval('public.utm_medium_id_seq'::regclass);


--
-- Name: utm_source id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.utm_source ALTER COLUMN id SET DEFAULT nextval('public.utm_source_id_seq'::regclass);


--
-- Name: utm_stage id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.utm_stage ALTER COLUMN id SET DEFAULT nextval('public.utm_stage_id_seq'::regclass);


--
-- Name: utm_tag id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.utm_tag ALTER COLUMN id SET DEFAULT nextval('public.utm_tag_id_seq'::regclass);


--
-- Name: web_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_id_seq'::regclass);


--
-- Name: web_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: wizard_create_role_from_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_create_role_from_user ALTER COLUMN id SET DEFAULT nextval('public.wizard_create_role_from_user_id_seq'::regclass);


--
-- Name: wizard_groups_into_role id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_groups_into_role ALTER COLUMN id SET DEFAULT nextval('public.wizard_groups_into_role_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: account_analytic_account; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_account (id, message_main_attachment_id, plan_id, root_plan_id, company_id, partner_id, create_uid, write_uid, name, code, active, create_date, write_date, line_seq, budgetable) FROM stdin;
\.


--
-- Data for Name: account_analytic_applicability; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_applicability (id, analytic_plan_id, create_uid, write_uid, business_domain, applicability, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: account_analytic_distribution_model; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_distribution_model (id, partner_id, partner_category_id, company_id, create_uid, write_uid, analytic_distribution, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: account_analytic_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_line (id, product_uom_id, account_id, partner_id, user_id, company_id, currency_id, plan_id, create_uid, write_uid, name, category, date, amount, create_date, write_date, unit_amount) FROM stdin;
\.


--
-- Data for Name: account_analytic_plan; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_plan (id, parent_id, company_id, color, create_uid, write_uid, name, parent_path, complete_name, default_applicability, description, create_date, write_date, message_main_attachment_id, code) FROM stdin;
\.


--
-- Data for Name: analytic_account_operating_unit_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.analytic_account_operating_unit_rel (analytic_account_id, operating_unit_id) FROM stdin;
\.


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_device (id, name, user_id, scope, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_wizard (id, user_id, create_uid, write_uid, secret, url, code, create_date, write_date, qrcode) FROM stdin;
\.


--
-- Data for Name: barcode_nomenclature; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.barcode_nomenclature (id, create_uid, write_uid, name, upc_ean_conv, create_date, write_date, gs1_separator_fnc1, is_gs1_nomenclature) FROM stdin;
1	1	1	Default Nomenclature	always	2026-02-06 07:56:47.459881	2026-02-06 07:56:47.459881	(Alt029|#|\\x1D)	\N
2	1	1	Default GS1 Nomenclature	always	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	(Alt029|#|\\x1D)	t
\.


--
-- Data for Name: barcode_rule; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.barcode_rule (id, barcode_nomenclature_id, sequence, create_uid, write_uid, name, encoding, type, pattern, alias, create_date, write_date, associated_uom_id, gs1_content_type, gs1_decimal_usage) FROM stdin;
1	1	90	1	1	Product Barcodes	any	product	.*	0	2026-02-06 07:56:47.459881	2026-02-06 07:56:47.459881	\N	\N	\N
2	2	100	1	1	Serial Shipping Container Code	gs1-128	package	(00)(\\d{18})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	identifier	\N
3	2	101	1	1	Global Trade Item Number (GTIN)	gs1-128	product	(01)(\\d{14})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	identifier	\N
4	2	102	1	1	GTIN of contained trade items	gs1-128	product	(02)(\\d{14})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	identifier	\N
5	2	110	1	1	Ship to / Deliver to Global Loca	gs1-128	location_dest	(410)(\\d{13})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	identifier	\N
6	2	113	1	1	Ship for / Deliver for - Forward	gs1-128	location_dest	(413)(\\d{13})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	identifier	\N
7	2	114	1	1	Identification of a physical loc	gs1-128	location	(414)(\\d{13})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	identifier	\N
8	2	125	1	1	Batch or lot number	gs1-128	lot	(10)([!"%-/0-9:-?A-Z_a-z]{0,20})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	alpha	\N
9	2	126	1	1	Serial number	gs1-128	lot	(21)([!"%-/0-9:-?A-Z_a-z]{0,20})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	alpha	\N
10	2	137	1	1	Pack date (YYMMDD)	gs1-128	pack_date	(13)(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	date	\N
11	2	138	1	1	Best before date (YYMMDD)	gs1-128	use_date	(15)(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	date	\N
12	2	139	1	1	Expiration date (YYMMDD)	gs1-128	expiration_date	(17)(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	date	\N
13	2	300	1	1	Variable count of items (variabl	gs1-128	quantity	(30)(\\d{0,8})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	1	measure	f
14	2	305	1	1	Count of trade items or trade it	gs1-128	quantity	(37)(\\d{0,8})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	1	measure	f
15	2	310	1	1	Net weight, kilograms (variable 	gs1-128	quantity	(310[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	12	measure	t
16	2	311	1	1	Length or first dimension, metre	gs1-128	quantity	(311[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	5	measure	t
17	2	314	1	1	Area, square meters (variable me	gs1-128	quantity	(314[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	9	measure	t
18	2	315	1	1	Net volume, litres (variable mea	gs1-128	quantity	(315[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	10	measure	t
19	2	316	1	1	Net volume, cubic metres (variab	gs1-128	quantity	(316[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	11	measure	t
20	2	320	1	1	Net weight, pounds (variable mea	gs1-128	quantity	(320[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	15	measure	t
21	2	321	1	1	Length or first dimension, inche	gs1-128	quantity	(321[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	17	measure	t
22	2	322	1	1	Length or first dimension, feet 	gs1-128	quantity	(322[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	18	measure	t
23	2	323	1	1	Length or first dimension, yards	gs1-128	quantity	(322[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	19	measure	t
24	2	351	1	1	Area, square feet (variable meas	gs1-128	quantity	(351[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	21	measure	t
25	2	357	1	1	Net weight (or volume), ounces (	gs1-128	quantity	(357[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	16	measure	t
26	2	360	1	1	Net volume, quarts (variable mea	gs1-128	quantity	(360[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	23	measure	t
27	2	361	1	1	Net volume, gallons U.S. (variab	gs1-128	quantity	(361[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	24	measure	t
28	2	364	1	1	Net volume, cubic inches (variab	gs1-128	quantity	(364[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	25	measure	t
29	2	365	1	1	Net volume, cubic feet (variable	gs1-128	quantity	(365[0-5])(\\d{6})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	26	measure	t
30	2	500	1	1	Package type	gs1-128	package_type	(91)([!"%-/0-9:-?A-Z_a-z]{0,90})	0	2026-02-06 07:56:51.506523	2026-02-06 07:56:51.506523	\N	alpha	\N
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_enable_profiling_wizard (id, create_uid, write_uid, duration, expiration, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_import (id, create_uid, write_uid, res_model, file_name, file_type, create_date, write_date, file) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_mapping (id, create_uid, write_uid, res_model, column_name, field_name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_noreadonly; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_noreadonly (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_readonly; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_readonly (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_required; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_required (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_states; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_states (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_char_stillreadonly; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_char_stillreadonly (id, create_uid, write_uid, value, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_complex; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_complex (id, currency_id, create_uid, write_uid, c, d, m, dt, create_date, write_date, f) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_float; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_float (id, currency_id, create_uid, write_uid, value2, create_date, write_date, value) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o (id, value, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o_related; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o_related (id, value, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o_required; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o_required (id, value, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_m2o_required_related; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_m2o_required_related (id, value, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_o2m; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_o2m (id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_o2m_child; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_o2m_child (id, parent_id, value, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_tests_models_preview; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_tests_models_preview (id, somevalue, othervalue, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_export (id, create_uid, write_uid, name, lang, format, state, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_import (id, create_uid, write_uid, name, code, filename, overwrite, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_install (id, create_uid, write_uid, overwrite, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_install_request; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_install_request (id, module_id, user_id, create_uid, write_uid, body_html, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_install_review; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_install_review (id, module_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall (id, module_id, create_uid, write_uid, show_all, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_update (id, updated, added, create_uid, write_uid, state, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_upgrade (id, create_uid, write_uid, module_info, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard (id, number_group, current_line_id, dst_partner_id, maximum_group, create_uid, write_uid, state, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, exclude_contact, exclude_journal_item, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, create_uid, write_uid, aggr_ids, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_substate; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_substate (id, sequence, target_state_value_id, mail_template_id, create_uid, write_uid, model, name, description, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_substate_type; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_substate_type (id, create_uid, write_uid, model, target_state_field, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_user_role_line_history; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_user_role_line_history (id, user_id, old_role_id, new_role_id, create_uid, write_uid, performed_action, old_date_from, new_date_from, old_date_to, new_date_to, old_is_enabled, new_is_enabled, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_bus; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_bus (id, create_uid, write_uid, channel, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_presence; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_presence (id, user_id, status, last_poll, last_presence, guest_id) FROM stdin;
\.


--
-- Data for Name: calendar_alarm; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_alarm (id, duration, duration_minutes, mail_template_id, create_uid, write_uid, alarm_type, "interval", name, body, create_date, write_date) FROM stdin;
1	15	15	\N	1	1	notification	minutes	{"en_US": "Notification - 15 Minutes"}	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119
2	30	30	\N	1	1	notification	minutes	{"en_US": "Notification - 30 Minutes"}	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119
3	1	60	\N	1	1	notification	hours	{"en_US": "Notification - 1 Hours"}	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119
4	2	120	\N	1	1	notification	hours	{"en_US": "Notification - 2 Hours"}	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119
5	1	1440	\N	1	1	notification	days	{"en_US": "Notification - 1 Days"}	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119
6	3	180	9	1	1	email	hours	{"en_US": "Email - 3 Hours"}	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119
7	6	360	9	1	1	email	hours	{"en_US": "Email - 6 Hours"}	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119
\.


--
-- Data for Name: calendar_alarm_calendar_event_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_alarm_calendar_event_rel (calendar_event_id, calendar_alarm_id) FROM stdin;
\.


--
-- Data for Name: calendar_attendee; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_attendee (id, event_id, partner_id, create_uid, write_uid, common_name, access_token, state, availability, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: calendar_event; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_event (id, message_main_attachment_id, user_id, videocall_channel_id, res_id, res_model_id, recurrence_id, create_uid, write_uid, name, location, videocall_location, access_token, privacy, show_as, res_model, start_date, stop_date, description, active, allday, recurrency, follow_recurrence, start, stop, create_date, write_date, duration) FROM stdin;
\.


--
-- Data for Name: calendar_event_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_event_res_partner_rel (res_partner_id, calendar_event_id) FROM stdin;
\.


--
-- Data for Name: calendar_event_type; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_event_type (id, color, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: calendar_filters; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_filters (id, user_id, partner_id, create_uid, write_uid, active, partner_checked, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: calendar_provider_config; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_provider_config (id, create_uid, write_uid, external_calendar_provider, cal_client_id, cal_client_secret, microsoft_outlook_client_identifier, microsoft_outlook_client_secret, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: calendar_recurrence; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_recurrence (id, base_event_id, "interval", count, day, create_uid, write_uid, name, event_tz, rrule, rrule_type, end_type, month_by, weekday, byday, until, mon, tue, wed, thu, fri, sat, sun, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_own; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_own (id, create_uid, write_uid, new_password, confirm_password, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_user; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_user (id, wizard_id, user_id, create_uid, write_uid, user_login, new_passwd, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: comment_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.comment_wizard (id, res_id, create_uid, write_uid, validate_reject, res_model, comment, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: comment_wizard_tier_review_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.comment_wizard_tier_review_rel (comment_wizard_id, tier_review_id) FROM stdin;
\.


--
-- Data for Name: crm_tag; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.crm_tag (id, color, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: crm_team; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.crm_team (id, message_main_attachment_id, sequence, company_id, user_id, color, create_uid, write_uid, name, active, create_date, write_date) FROM stdin;
1	\N	0	\N	\N	\N	1	1	{"en_US": "Sales"}	t	2026-02-06 07:57:07.961456	2026-02-06 07:57:07.961456
2	\N	10	\N	\N	\N	1	1	{"en_US": "Website"}	f	2026-02-06 07:57:07.961456	2026-02-06 07:57:07.961456
3	\N	10	\N	\N	\N	1	1	{"en_US": "Point of Sale"}	f	2026-02-06 07:57:07.961456	2026-02-06 07:57:07.961456
4	\N	10	1	\N	\N	1	1	{"en_US": "eBay"}	f	2026-02-06 07:57:07.961456	2026-02-06 07:57:07.961456
\.


--
-- Data for Name: crm_team_member; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.crm_team_member (id, message_main_attachment_id, crm_team_id, user_id, create_uid, write_uid, active, create_date, write_date) FROM stdin;
1	\N	1	2	1	1	t	2026-02-06 07:57:07.961456	2026-02-06 07:57:07.961456
\.


--
-- Data for Name: decimal_precision; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.decimal_precision (id, digits, create_uid, write_uid, name, create_date, write_date) FROM stdin;
1	2	1	1	Percentage Analytic	2026-02-06 07:56:58.022054	2026-02-06 07:56:58.022054
2	2	1	1	Product Price	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988
3	2	1	1	Discount	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988
4	2	1	1	Stock Weight	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988
5	2	1	1	Volume	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988
6	2	1	1	Product Unit of Measure	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988
\.


--
-- Data for Name: email_template_attachment_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.email_template_attachment_rel (email_template_id, attachment_id) FROM stdin;
\.


--
-- Data for Name: employee_category_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.employee_category_rel (emp_id, category_id) FROM stdin;
\.


--
-- Data for Name: exception_rule; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.exception_rule (id, sequence, create_uid, write_uid, model, exception_type, domain, method, name, description, code, active, is_blocking, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: fetchmail_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.fetchmail_server (id, port, object_id, priority, create_uid, write_uid, name, state, server, server_type, "user", password, script, configuration, active, is_ssl, attach, original, date, create_date, write_date, google_gmail_access_token_expiration, google_gmail_authorization_code, google_gmail_refresh_token, google_gmail_access_token) FROM stdin;
\.


--
-- Data for Name: hr_contract_type; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_contract_type (id, sequence, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_department; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_department (id, message_main_attachment_id, company_id, parent_id, manager_id, color, master_department_id, create_uid, write_uid, name, complete_name, parent_path, note, active, create_date, write_date) FROM stdin;
1	\N	1	\N	\N	\N	1	1	1	Administration	Administration	1/	\N	t	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
2	\N	1	\N	\N	\N	2	1	1	Sales	Sales	2/	\N	t	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
\.


--
-- Data for Name: hr_department_mail_channel_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_department_mail_channel_rel (mail_channel_id, hr_department_id) FROM stdin;
\.


--
-- Data for Name: hr_departure_reason; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_departure_reason (id, sequence, create_uid, write_uid, name, create_date, write_date) FROM stdin;
1	0	1	1	{"en_US": "Fired"}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
2	1	1	1	{"en_US": "Resigned"}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
3	2	1	1	{"en_US": "Retired"}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
\.


--
-- Data for Name: hr_departure_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_departure_wizard (id, departure_reason_id, employee_id, create_uid, write_uid, departure_date, departure_description, archive_private_address, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_employee; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee (id, resource_id, company_id, resource_calendar_id, message_main_attachment_id, color, department_id, job_id, address_id, work_contact_id, work_location_id, user_id, parent_id, coach_id, address_home_id, country_id, children, country_of_birth, bank_account_id, km_home_work, departure_reason_id, create_uid, write_uid, name, job_title, work_phone, mobile_phone, work_email, employee_type, gender, marital, spouse_complete_name, place_of_birth, ssnid, sinid, identification_id, passport_id, permit_no, visa_no, certificate, study_field, study_school, emergency_contact, emergency_phone, barcode, pin, spouse_birthdate, birthday, visa_expire, work_permit_expiration_date, departure_date, additional_note, notes, departure_description, active, work_permit_scheduled_activity, create_date, write_date) FROM stdin;
1	1	1	1	\N	0	1	\N	1	3	\N	2	\N	\N	7	\N	\N	\N	\N	\N	\N	1	1	Administrator	\N	\N	\N	admin@example.com	employee	\N	single	\N	\N	\N	\N	\N	\N	\N	\N	other	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
\.


--
-- Data for Name: hr_employee_category; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee_category (id, color, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_employee_hr_plan_wizard_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee_hr_plan_wizard_rel (employee_id, plan_wizard_id) FROM stdin;
\.


--
-- Data for Name: hr_job; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_job (id, message_main_attachment_id, sequence, expected_employees, no_of_employee, no_of_recruitment, no_of_hired_employee, department_id, company_id, contract_type_id, create_uid, write_uid, name, description, requirements, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_plan; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_plan (id, company_id, department_id, create_uid, write_uid, name, active, create_date, write_date) FROM stdin;
1	1	\N	1	1	Onboarding	t	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
2	1	\N	1	1	Offboarding	t	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
\.


--
-- Data for Name: hr_plan_activity_type; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_plan_activity_type (id, company_id, activity_type_id, responsible_id, plan_id, create_uid, write_uid, summary, responsible, note, create_date, write_date) FROM stdin;
1	1	4	\N	1	1	1	Setup IT Materials	manager	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
2	1	4	\N	1	1	1	Plan Training	manager	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
3	1	4	\N	1	1	1	Training	employee	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
4	1	4	\N	2	1	1	Organize knowledge transfer inside the team	manager	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
5	1	4	\N	2	1	1	Take Back HR Materials	manager	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
\.


--
-- Data for Name: hr_plan_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_plan_wizard (id, plan_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_work_location; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_work_location (id, company_id, address_id, create_uid, write_uid, name, location_number, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: iap_account; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account (id, create_uid, write_uid, service_name, account_token, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: iap_account_res_company_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account_res_company_rel (iap_account_id, res_company_id) FROM stdin;
\.


--
-- Data for Name: ir_act_client; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_client (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, tag, target, res_model, context, params_store) FROM stdin;
2	\N	1	1	ir.actions.client	action	list,form	{"en_US": "Open Settings Menu"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	reload	current	\N	{}	\\x7b276d656e755f6964273a20347d
39	\N	1	1	ir.actions.client	action	list,form	{"en_US": "App Store"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	apps	current	\N	{}	\N
40	\N	1	1	ir.actions.client	action	list,form	{"en_US": "Updates"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	apps.updates	current	\N	{}	\\x7b7d
128	\N	1	1	ir.actions.client	action	list,form	{"en_US": "Discuss"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	mail.action_discuss	current	\N	{}	\\x7b202764656661756c745f6163746976655f6964273a20276d61696c2e626f785f696e626f7827207d
224	\N	1	1	ir.actions.client	action	list,form	{"en_US": "Dashboards"}	\N	2026-02-06 07:57:08.550438	2026-02-06 07:57:08.550438	action_spreadsheet_dashboard	current	\N	{}	\N
\.


--
-- Data for Name: ir_act_report_xml; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_report_xml (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, paperformat_id, model, report_type, report_name, report_file, attachment, print_report_name, multi, attachment_use) FROM stdin;
34	3	1	1	ir.actions.report	report	list,form	{"en_US": "Model Overview"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	ir.model	qweb-pdf	base.report_irmodeloverview	base.report_irmodeloverview	\N	\N	\N	\N
41	66	1	1	ir.actions.report	report	list,form	{"en_US": "Technical guide"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	ir.module.module	qweb-pdf	base.report_irmodulereference	base.report_irmodulereference	\N	\N	\N	\N
86	94	1	1	ir.actions.report	report	list,form	{"en_US": "Preview Internal Report"}	\N	2026-02-06 07:56:46.164914	2026-02-06 07:56:46.164914	\N	res.company	qweb-pdf	web.preview_internalreport	web.preview_internalreport	\N	\N	\N	\N
87	94	1	1	ir.actions.report	report	list,form	{"en_US": "Preview External Report"}	\N	2026-02-06 07:56:46.164914	2026-02-06 07:56:46.164914	\N	res.company	qweb-pdf	web.preview_externalreport	web.preview_externalreport	\N	\N	\N	\N
88	94	1	1	ir.actions.report	report	list,form	{"en_US": "Report Layout Preview"}	\N	2026-02-06 07:56:46.164914	2026-02-06 07:56:46.164914	\N	res.company	qweb-pdf	web.preview_layout_report	web.preview_layout_report	\N	\N	\N	\N
176	429	1	1	ir.actions.report	report	list,form	{"en_US": "Print Badge"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	hr.employee	qweb-pdf	hr.print_employee_badge	hr.print_employee_badge	\N	{"en_US": "'Print Badge - %s' % (object.name).replace('/', '')"}	\N	\N
213	\N	1	1	ir.actions.report	report	list,form	{"en_US": "Product Label (PDF)"}	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	4	product.template	qweb-pdf	product.report_producttemplatelabel	product.report_producttemplatelabel	\N	{"en_US": "'Products Labels - %s' % (object.name)"}	\N	\N
214	456	1	1	ir.actions.report	report	list,form	{"en_US": "Product Packaging (PDF)"}	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	product.packaging	qweb-pdf	product.report_packagingbarcode	product.report_packagingbarcode	\N	{"en_US": "'Products packaging - %s' % (object.name)"}	\N	\N
215	\N	1	1	ir.actions.report	report	list,form	{"en_US": "Pricelist"}	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	product.product	qweb-pdf	product.report_pricelist	product.report_pricelist	\N	\N	\N	\N
216	\N	1	1	ir.actions.report	report	list,form	{"en_US": "Product Label (PDF)"}	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	5	product.template	qweb-pdf	product.report_producttemplatelabel_dymo	product.report_producttemplatelabel_dymo	\N	{"en_US": "'Products Labels - %s' % (object.name)"}	\N	\N
\.


--
-- Data for Name: ir_act_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, sequence, model_id, crud_model_id, link_field_id, usage, state, model_name, code, mass_edit_message, template_id, activity_type_id, activity_date_deadline_range, activity_user_id, mail_post_method, activity_summary, activity_date_deadline_range_type, activity_user_type, activity_user_field_name, activity_note, mail_post_autofollow) FROM stdin;
10	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Config: Run Remaining Action Todo"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:52.288141	5	89	\N	\N	ir_actions_server	code	res.config	\nconfig = model.next() or {}\nif config.get('type') not in ('ir.actions.act_window_close',):\n    action = config\n	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f
33	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Base: Auto-vacuum internal data"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:52.288141	5	38	\N	\N	ir_cron	code	ir.autovacuum	model._run_vacuum_cleaner()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f
50	66	1	1	ir.actions.server	action	list,form	{"en_US": "Activate Modules"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:52.288141	5	66	\N	\N	ir_actions_server	code	ir.module.module	records.button_immediate_install()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f
51	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Failed to install demo data for some modules, demo disabled"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:52.288141	5	71	\N	\N	ir_actions_server	code	ir.demo_failure.wizard	\nfailures = env['ir.demo_failure'].search([\n    ('wizard_id', '=', False),\n])\nrecord = model.create({\n    'failure_ids': [Command.set(failures.ids)],\n})\naction = {\n    'type': 'ir.actions.act_window',\n    'res_id': record.id,\n    'res_model': 'ir.demo_failure.wizard',\n    'target': 'new',\n    'views': [(env.ref('base.demo_failures_dialog').id, 'form')],\n}\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f
79	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Update user roles"}	\N	2026-02-06 07:56:44.287826	2026-02-06 07:56:52.288141	5	117	\N	\N	ir_cron	code	res.users.role	model.cron_update_users()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f
90	97	1	1	ir.actions.server	action	list,form	{"en_US": "Disable two-factor authentication"}	\N	2026-02-06 07:56:47.277441	2026-02-06 07:56:52.288141	5	97	\N	\N	ir_actions_server	code	res.users	\n            action = records.action_totp_disable()\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f
109	91	1	1	ir.actions.server	action	list,form	{"en_US": "Open IAP Account"}	\N	2026-02-06 07:56:51.985706	2026-02-06 07:56:52.288141	5	91	\N	\N	ir_actions_server	code	res.config.settings	\nif records:\n    action = records._redirect_to_iap_account()\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f
132	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Mail: Email Queue Manager"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	5	201	\N	\N	ir_cron	code	mail.mail	model.process_email_queue()	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
133	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Publisher: Update Notification"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	5	229	\N	\N	ir_cron	code	publisher_warranty.contract	model.update_notification(None)	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
134	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Notification: Delete Notifications older than 6 Month"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	5	190	\N	\N	ir_cron	code	mail.notification	model._gc_notifications(max_age_days=180)	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
135	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Mail: Fetchmail Service"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	5	189	\N	\N	ir_cron	code	fetchmail.server	model._fetch_mails()	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
136	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Notification: Send scheduled message notifications"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	5	198	\N	\N	ir_cron	code	mail.message.schedule	model._send_notifications_cron()	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
151	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Users: Notify About Unregistered Users"}	\N	2026-02-06 07:56:58.535815	2026-02-06 07:56:58.535815	5	97	\N	\N	ir_cron	code	res.users	model.send_unregistered_user_reminder()	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
152	97	1	1	ir.actions.server	action	list,form	{"en_US": "Send Password Reset Instructions"}	\N	2026-02-06 07:56:58.535815	2026-02-06 07:56:58.535815	5	97	\N	\N	ir_actions_server	code	res.users	records.action_reset_password()	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
153	97	1	1	ir.actions.server	action	list	{"en_US": "Invite to use two-factor authentication"}	\N	2026-02-06 07:56:58.775756	2026-02-06 07:56:58.775756	5	97	\N	\N	ir_actions_server	code	res.users	\n            action = records.action_totp_invite()\n        	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
154	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Open two-factor authentication configuration"}	\N	2026-02-06 07:56:58.775756	2026-02-06 07:56:58.775756	5	97	\N	\N	ir_actions_server	code	res.users	\nuser = env.user\naction = user.action_open_my_account_settings()\n        	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
159	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Send Tier Review Reminder"}	\N	2026-02-06 07:56:59.481562	2026-02-06 07:56:59.481562	5	412	\N	\N	ir_cron	code	tier.definition	model._cron_send_review_reminder()	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
162	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Calendar: Event Reminder"}	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119	5	422	\N	\N	ir_cron	code	calendar.alarm_manager	model._send_reminder()	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
180	429	1	1	ir.actions.server	action	form	{"en_US": "Create User"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	5	429	\N	\N	ir_actions_server	code	hr.employee	\n                action = records.action_create_user()\n            	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
188	\N	1	1	ir.actions.server	action	list,form	{"en_US": "HR Employee: check work permit validity"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	5	429	\N	\N	ir_cron	code	hr.employee	model._cron_check_work_permit_validity()	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
192	85	1	1	ir.actions.server	action	form	{"en_US": "Privacy Lookup"}	\N	2026-02-06 07:57:05.249714	2026-02-06 07:57:05.249714	5	85	\N	\N	ir_actions_server	code	res.partner	\naction = record.action_privacy_lookup()\n        	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
193	97	1	1	ir.actions.server	action	form	{"en_US": "Privacy Lookup"}	\N	2026-02-06 07:57:05.249714	2026-02-06 07:57:05.249714	5	97	\N	\N	ir_actions_server	code	res.users	\naction = record.partner_id.action_privacy_lookup()\n        	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
196	446	1	1	ir.actions.server	action	list	{"en_US": "Archive Selection"}	\N	2026-02-06 07:57:05.249714	2026-02-06 07:57:05.249714	5	446	\N	\N	ir_actions_server	code	privacy.lookup.wizard.line	\nrecords.action_archive_all()\n        	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
197	446	1	1	ir.actions.server	action	list	{"en_US": "Delete Selection"}	\N	2026-02-06 07:57:05.249714	2026-02-06 07:57:05.249714	5	446	\N	\N	ir_actions_server	code	privacy.lookup.wizard.line	\nrecords.action_unlink_all()\n        	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
203	448	1	1	ir.actions.server	action	list,form	{"en_US": "Generate Pricelist"}	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	5	448	\N	\N	ir_actions_server	code	product.product	\nctx = env.context\nctx.update({'default_pricelist': env['product.pricelist'].search([], limit=1).id})\naction = {\n    'name': 'Pricelist Report',\n    'type': 'ir.actions.client',\n    'tag': 'generate_pricelist',\n    'context': ctx,\n}\n        	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
211	447	1	1	ir.actions.server	action	list,form	{"en_US": "Generate Pricelist Report"}	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	5	447	\N	\N	ir_actions_server	code	product.template	\nctx = env.context\nctx.update({'default_pricelist': env['product.pricelist'].search([], limit=1).id})\naction = {\n    'name': 'Pricelist Report',\n    'type': 'ir.actions.client',\n    'tag': 'generate_pricelist',\n    'context': ctx,\n}\n        	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
226	\N	1	1	ir.actions.server	action	list,form	{"en_US": "Automatic Tier Validation"}	\N	2026-02-06 07:57:10.870485	2026-02-06 07:57:10.870485	5	412	\N	\N	ir_cron	code	tier.definition	model._cron_auto_tier_validation()	\N	\N	\N	\N	\N	\N	\N	days	\N	\N	\N	f
\.


--
-- Data for Name: ir_act_server_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_group_rel (act_id, gid) FROM stdin;
90	2
152	2
153	2
154	1
180	2
192	4
193	4
203	22
211	22
\.


--
-- Data for Name: ir_act_server_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_res_partner_rel (ir_act_server_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: ir_act_url; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_url (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, target, url) FROM stdin;
3	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Home Menu"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	self	/web
37	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Third-Party Apps"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	new	https://apps.odoo.com/apps/modules
38	\N	1	1	ir.actions.act_url	action	list,form	{"en_US": "Theme Store"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	new	https://apps.odoo.com/apps/themes
\.


--
-- Data for Name: ir_act_window; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date, view_id, res_id, "limit", search_view_id, domain, context, res_model, target, view_mode, usage, filter) FROM stdin;
1	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Load demo data"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	ir.demo	new	form	\N	\N
4	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Decimal Accuracy"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	decimal.precision	current	tree,form	\N	\N
5	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Actions"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	7	\N	80	8	\N	{}	ir.actions.actions	current	tree,form	\N	\N
6	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Reports"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	10	\N	80	11	\N	{}	ir.actions.report	current	tree,form	\N	\N
7	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Window Actions"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	14	\N	{}	ir.actions.act_window	current	tree,form	\N	\N
8	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Server Actions"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	16	\N	80	17	\N	{'key':'server_action'}	ir.actions.server	current	tree,form	\N	\N
9	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Configuration Wizards"}	{"en_US": "<p>The configuration wizards are used to help you configure a new instance of Odoo. They are launched during the installation of new modules, but you can choose to restart some wizards manually from this menu.</p>"}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	18	\N	80	\N	\N	{}	ir.actions.todo	current	tree,form	\N	\N
11	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Assets"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	22	\N	80	\N	\N	{'search_default_active': 1}	ir.asset	current	tree,form	\N	\N
12	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "System Parameters"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	ir.config_parameter	current	tree,form	\N	\N
14	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Scheduled Actions Triggers"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	ir.cron.trigger	current	tree,form	\N	\N
15	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "User-defined Filters"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	ir.filters	current	tree,form	\N	\N
16	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Outgoing Mail Servers"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	38	\N	80	39	\N	{}	ir.mail_server	current	tree,form	\N	\N
17	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Create Menu"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{'model_id': active_id}	wizard.ir.model.menu.create	new	form	\N	\N
18	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Models"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	42	\N	80	\N	\N	{}	ir.model	current	tree,form	\N	\N
19	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fields"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	45	\N	80	\N	\N	{}	ir.model.fields	current	tree,form	\N	\N
20	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fields Selection"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	48	\N	80	\N	\N	{}	ir.model.fields.selection	current	tree,form	\N	\N
21	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "External Identifiers"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	51	\N	80	\N	\N	{}	ir.model.data	current	tree,form	\N	\N
22	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Model Constraints"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	54	\N	80	55	\N	{}	ir.model.constraint	current	tree,form	\N	\N
23	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "ManyToMany Relations"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	57	\N	80	\N	\N	{}	ir.model.relation	current	tree,form	\N	\N
24	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Access Rights"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	59	\N	80	61	\N	{}	ir.model.access	current	tree,form	\N	\N
26	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Record Rules"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	66	\N	80	67	\N	{}	ir.rule	current	tree,form	\N	\N
27	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Sequences"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	69	\N	80	\N	\N	{'active_test': False}	ir.sequence	current	tree,form	\N	\N
28	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Menu Items"}	{"en_US": "<p>Manage and customize the items available and displayed in your Odoo system menu. You can delete an item by clicking on the box at the beginning of each line and then delete it through the button that appeared. Items can be assigned to specific groups in order to make them accessible to some users within the system.</p>"}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	72	\N	80	73	\N	{'ir.ui.menu.full_list':True}	ir.ui.menu	current	tree,form	\N	\N
29	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Views"}	{"en_US": "<p>Views allows you to personalize each view of Odoo. You can add new fields, move fields, rename them or delete the ones that you do not need.</p>"}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	75	\N	80	\N	\N	{'search_default_active': 1}	ir.ui.view	current	tree,form	\N	\N
30	15	1	1	ir.actions.act_window	action	form,list	{"en_US": "Compare/Reset"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	reset.view.arch.wizard	new	form	\N	\N
31	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customized Views"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">Create a customized view</p><p>Customized views are used when users reorganize the content of their dashboard views (via web client)</p>"}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	ir.ui.view.custom	current	tree,form	\N	\N
32	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "User-defined Defaults"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	83	\N	{}	ir.default	current	tree,form	\N	\N
35	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Logging"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	87	\N	{}	ir.logging	current	tree,form	\N	\N
36	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Apps"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No module found!\\n              </p><p>\\n                You should try other search criteria.\\n              </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	92	\N	{'search_default_app':1}	ir.module.module	current	kanban,tree,form	\N	\N
42	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Module Update"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	base.module.update	new	form	\N	\N
43	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Add Languages"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	base.language.install	new	form	\N	\N
44	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Import Translation"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	base.language.import	new	form	\N	\N
45	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Apply Schedule Upgrade"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	base.module.upgrade	new	form	\N	\N
46	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Module Upgrade Install"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	102	\N	80	\N	\N	{}	base.module.upgrade	new	form	\N	\N
47	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Export Translation"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	base.language.export	new	form	\N	\N
48	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Deduplicate Contacts"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{'active_test': False}	base.partner.merge.automatic.wizard	new	form	\N	\N
49	85	1	1	ir.actions.act_window	action	list	{"en_US": "Merge"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	base.partner.merge.automatic.wizard	new	form	\N	\N
52	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Ir profile"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{'search_default_group_session': 1}	ir.profile	current	tree,form	\N	\N
53	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Companies"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new company\\n              </p><p>\\n                Create and manage the companies that will be managed by Odoo from here. Shops or subsidiaries can be created and maintained from here.\\n              </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	res.company	current	tree,kanban,form	\N	\N
54	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Languages"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	117	\N	{'active_test': False}	res.lang	current	tree,form	\N	\N
55	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Contact Titles"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Title\\n                </p><p>\\n                    Manage Contact Titles as well as their abbreviations (e.g. \\"Mr.\\", \\"Mrs.\\", etc).\\n                </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	[]	{}	res.partner.title	current	tree,form	\N	\N
59	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Contact Tags"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact Tag\\n              </p><p>\\n                Assign tags to your contacts to organize, filter and track them.\\n              </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	129	\N	{}	res.partner.category	current	tree,form	\N	\N
60	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Industries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create an Industry\\n              </p><p>\\n                Specify industries to classify your contacts and draw up reports.\\n              </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	132	\N	{}	res.partner.industry	current	tree,form	\N	\N
61	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Banks"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank\\n              </p><p>\\n                Banks are the financial institutions at which you and your contacts have their accounts.\\n              </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	135	\N	{}	res.bank	current	tree,form	\N	\N
62	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Bank Accounts"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank Account\\n              </p><p>\\n                From here you can manage all bank accounts linked to you and your contacts.\\n              </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	res.partner.bank	current	tree,form	\N	\N
63	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Countries"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No Country Found!\\n                </p><p>\\n                    Manage the list of countries that can be set on your contacts.\\n                </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	res.country	current	tree,form	\N	\N
64	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Country Group"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Country Group\\n                </p><p>\\n                    Use groups to organize countries that are frequently selected together (e.g. \\"LATAM\\", \\"BeNeLux\\", \\"ASEAN\\").\\n                </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	res.country.group	current	tree,form	\N	\N
65	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Fed. States"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a State\\n                </p><p>\\n                    Federal States belong to countries and are part of your contacts' addresses.\\n                </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	143	\N	80	\N	\N	{}	res.country.state	current	tree,form	\N	\N
66	92	1	1	ir.actions.act_window	action	form	{"en_US": "Show Currency Rates"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	147	\N	80	\N	[('currency_id','=', active_id)]	{'default_currency_id': active_id}	res.currency.rate	current	tree,form	\N	\N
67	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Currencies"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	149	\N	{'active_test': False}	res.currency	current	tree,kanban,form	\N	\N
68	97	1	1	ir.actions.act_window	action	list,form	{"en_US": "Change Password"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	change.password.wizard	new	form	\N	\N
69	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Groups"}	{"en_US": "<p>A group is a set of functional areas that will be assigned to the user in order to give them access and rights to specific applications and tasks in the system. You can create custom groups or edit the ones existing by default in order to customize the view of the menu that users will be able to see. Whether they can have a read, write, create and delete access right can be managed from here.</p>"}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{'search_default_filter_no_share': 1}	res.groups	current	tree,form	\N	\N
142	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Email Templates"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	374	\N	80	375	\N	{'search_default_base_templates': 1}	mail.template	current	form,tree	\N	\N
70	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Users"}	{"en_US": "<p>Create and manage users that will connect to the system. Users can be deactivated should there be a period of time during which they will/should not connect to the system. You can assign them groups in order to give them specific access to the applications they need to use in the system.</p>"}	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	161	\N	80	163	\N	{'search_default_filter_no_share': 1, 'show_user_group_warning': True}	res.users	current	tree,kanban,form	\N	\N
71	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "API Key: description input wizard"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	res.users.apikeys.description	new	form	\N	\N
72	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Change My Preferences"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	res.users	new	form	\N	\N
73	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "API Keys Listing"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	168	\N	80	\N	\N	{}	res.users.apikeys	current	tree	\N	\N
74	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Company Properties"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	171	\N	80	\N	\N	{}	ir.property	current	tree,form	\N	\N
75	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Settings"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	res.config.settings	inline	form	\N	\N
76	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Paper Format General Configuration"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	report.paperformat	current	tree,form	\N	\N
77	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Reports"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N	80	\N	\N	{}	ir.actions.report	current	tree,form	\N	\N
78	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Set your company data"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	178	\N	80	\N	\N	{}	res.company	new	form	\N	\N
80	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Roles"}	\N	2026-02-06 07:56:44.287826	2026-02-06 07:56:44.287826	183	\N	80	\N	\N	{}	res.users.role	current	tree,form	\N	\N
81	97	1	1	ir.actions.act_window	action	list,form	{"en_US": "Create role from user"}	\N	2026-02-06 07:56:44.287826	2026-02-06 07:56:44.287826	\N	\N	80	\N	\N	{}	wizard.create.role.from.user	new	form	\N	\N
82	95	1	1	ir.actions.act_window	action	list,form	{"en_US": "Create Role"}	\N	2026-02-06 07:56:44.287826	2026-02-06 07:56:44.287826	\N	\N	80	\N	\N	{}	wizard.groups.into.role	new	form	\N	\N
83	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Operating Units"}	{"en_US": "<p class=\\"oe_view_nocontent_create\\">Click to start a new Operating Unit.</p>\\n        "}	2026-02-06 07:56:45.048035	2026-02-06 07:56:45.048035	\N	\N	80	\N	\N	{}	operating.unit	current	tree,form	\N	\N
84	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Units of Measure"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Add a new unit of measure\\n          </p><p>\\n            You must define a conversion rate between several Units of\\n            Measure within the same category.\\n          </p>\\n        "}	2026-02-06 07:56:45.815046	2026-02-06 07:56:45.815046	201	\N	80	203	\N	{}	uom.uom	current	tree,form	\N	\N
85	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Units of Measure Categories"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Add a new unit of measure category\\n          </p><p>\\n            Units of measure belonging to the same category can be\\n            converted between each others. For example, in the category\\n            <i>'Time'</i>, you will have the following units of measure:\\n            Hours, Days.\\n          </p>\\n        "}	2026-02-06 07:56:45.815046	2026-02-06 07:56:45.815046	\N	\N	80	\N	\N	{'allow_to_change_reference': 1}	uom.category	current	tree,form	\N	\N
89	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Configure your document layout"}	\N	2026-02-06 07:56:46.164914	2026-02-06 07:56:46.164914	238	\N	80	\N	\N	{}	base.document.layout	new	form	\N	\N
91	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Barcode Nomenclatures"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Add a new barcode nomenclature\\n              </p><p>\\n                A barcode nomenclature defines how the point of sale identify and interprets barcodes\\n              </p>\\n            "}	2026-02-06 07:56:47.459881	2026-02-06 07:56:47.459881	\N	\N	80	\N	\N	{}	barcode.nomenclature	current	tree,kanban,form	\N	\N
92	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Settings"}	\N	2026-02-06 07:56:48.916945	2026-02-06 07:56:48.916945	\N	\N	80	\N	\N	{'module' : 'general_settings', 'bin_size': False}	res.config.settings	inline	form	\N	\N
93	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Resources"}	{"en_US": "<p>Resources allow you to create and manage resources that should be involved in a specific project phase. You can also set their efficiency level and workload based on their weekly working hours.</p>"}	2026-02-06 07:56:50.214558	2026-02-06 07:56:50.214558	\N	\N	80	263	\N	{}	resource.resource	current	tree,form	\N	\N
94	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Resources"}	{"en_US": "<p>Resources allow you to create and manage resources that should be involved in a specific project phase. You can also set their efficiency level and workload based on their weekly working hours.</p>"}	2026-02-06 07:56:50.214558	2026-02-06 07:56:50.214558	\N	\N	80	263	\N	{\n            'default_calendar_id': active_id,\n            'search_default_calendar_id': active_id}	resource.resource	current	tree,form	\N	\N
95	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Resource Time Off"}	\N	2026-02-06 07:56:50.214558	2026-02-06 07:56:50.214558	\N	\N	80	266	\N	{}	resource.calendar.leaves	current	tree,form,calendar	\N	\N
96	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Resource Time Off"}	\N	2026-02-06 07:56:50.214558	2026-02-06 07:56:50.214558	\N	\N	80	266	\N	{\n            'default_calendar_id': active_id,\n            'search_default_calendar_id': active_id}	resource.calendar.leaves	current	tree,form,calendar	\N	\N
97	160	1	1	ir.actions.act_window	action	form	{"en_US": "Closing Days"}	\N	2026-02-06 07:56:50.214558	2026-02-06 07:56:50.214558	\N	\N	80	\N	[('calendar_id','=',active_id), ('resource_id','=',False)]	{'default_calendar_id': active_id}	resource.calendar.leaves	current	calendar,tree,form	\N	\N
98	160	1	1	ir.actions.act_window	action	form	{"en_US": "Resources Time Off"}	\N	2026-02-06 07:56:50.214558	2026-02-06 07:56:50.214558	\N	\N	80	\N	[('calendar_id','=',active_id), ('resource_id','!=',False)]	{'default_calendar_id': active_id}	resource.calendar.leaves	current	calendar,tree,form	\N	\N
99	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Working Times"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Define working hours and time table that could be scheduled to your project members\\n          </p>\\n        "}	2026-02-06 07:56:50.214558	2026-02-06 07:56:50.214558	\N	\N	80	272	\N	{}	resource.calendar	current	tree,form	\N	\N
100	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Campaigns"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a campaign\\n            </p>\\n            <p>\\n                Campaigns are used to centralize your marketing efforts and track their results.\\n            </p>\\n        "}	2026-02-06 07:56:50.702405	2026-02-06 07:56:50.702405	\N	\N	80	\N	\N	{}	utm.campaign	current	tree,kanban,form	\N	\N
101	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Mediums"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Medium\\n            </p><p>\\n                UTM Mediums track the mean that was used to attract traffic (e.g. \\"Website\\", \\"Twitter\\", ...).\\n            </p>\\n        "}	2026-02-06 07:56:50.702405	2026-02-06 07:56:50.702405	\N	\N	80	282	\N	{}	utm.medium	current	tree,form	\N	\N
102	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Sources"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                No Sources yet!\\n            </p><p>\\n                UTM Sources track where traffic comes from  (e.g. \\"May Newsletter\\", \\"\\", ...).\\n            </p>\\n        "}	2026-02-06 07:56:50.702405	2026-02-06 07:56:50.702405	\N	\N	80	\N	\N	{}	utm.source	current	tree,form	\N	\N
103	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "UTM Stages"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Create a stage for your campaigns\\n            </p><p>\\n            Stages allow you to organize your workflow  (e.g. : plan, design, in progress,  done, …).\\n            </p>\\n        "}	2026-02-06 07:56:50.702405	2026-02-06 07:56:50.702405	\N	\N	80	\N	\N	{}	utm.stage	current	tree,form	\N	\N
104	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Campaign Tags"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Tag\\n            </p><p>\\n                Assign tags to your campaigns to organize, filter and track them.\\n            </p>\\n        "}	2026-02-06 07:56:50.702405	2026-02-06 07:56:50.702405	\N	\N	80	\N	\N	{}	utm.tag	current	tree,form	\N	\N
105	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Tours"}	\N	2026-02-06 07:56:51.312064	2026-02-06 07:56:51.312064	288	\N	80	289	\N	{}	web_tour.tour	current	tree,form	\N	\N
106	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Outstanding exceptions to manage"}	\N	2026-02-06 07:56:51.802847	2026-02-06 07:56:51.802847	293	\N	80	\N	\N	{}	exception.rule.confirm	new	form	\N	\N
107	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Exception Rules"}	\N	2026-02-06 07:56:51.802847	2026-02-06 07:56:51.802847	294	\N	80	\N	\N	{'active_test': False}	exception.rule	current	tree,form	\N	\N
108	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "IAP Account"}	\N	2026-02-06 07:56:51.985706	2026-02-06 07:56:51.985706	\N	\N	80	\N	\N	{}	iap.account	current	tree,form	\N	\N
110	233	1	1	ir.actions.act_window	action	list,form	{"en_US": "Compose Email"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.compose.message	new	form	\N	\N
111	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Sending Failures"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.resend.message	new	form	\N	\N
112	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Template Preview"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	302	\N	80	\N	\N	{'default_mail_template_id':active_id}	mail.template.preview	new	form	\N	\N
113	203	1	1	ir.actions.act_window	action	list	{"en_US": "Reset Mail Template"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	304	\N	80	\N	\N	{\n            'default_template_ids': active_ids\n        }	mail.template.reset	new	form	\N	\N
114	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Incoming Mail Servers"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	305	\N	80	307	\N	{}	fetchmail.server	current	tree,form	\N	\N
115	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Subtypes"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.message.subtype	current	tree,form	\N	\N
116	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Tracking Values"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.tracking.value	current	tree,form	\N	\N
117	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Notifications"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.notification	current	tree,form	\N	\N
118	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Messages"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	316	\N	{}	mail.message	current	tree,form	\N	\N
119	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Scheduled Messages"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.message.schedule	current	tree,form	\N	\N
120	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Emails"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	323	\N	{}	mail.mail	current	tree,form	\N	\N
121	189	1	1	ir.actions.act_window	action	form	{"en_US": "Messages"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	[('email_from', '!=', False), ('fetchmail_server_id', '=', active_id)]	{'search_default_server_id': active_id, 'default_fetchmail_server_id': active_id}	mail.mail	current	tree,form	\N	\N
122	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Followers"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.followers	current	tree,form	\N	\N
123	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "ICE servers"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.ice.server	current	tree,form	\N	\N
124	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Channels/Member"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.channel.member	current	tree,form	\N	\N
125	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "RTC sessions"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{'search_default_group_by_channel': True}	mail.channel.rtc.session	current	tree,form	\N	\N
126	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Link Previews"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.link.preview	current	tree,form	\N	\N
127	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Join a group"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	337	\N	{}	mail.channel	current	kanban,tree,form	\N	\N
129	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Chat Shortcode"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Define a new chat shortcode\\n              </p><p>\\n                A shortcode is a keyboard shortcut. For instance, you type #gm and it will be transformed into \\"Good Morning\\".\\n              </p>\\n            "}	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.shortcode	current	tree,form	\N	\N
130	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Activity Types"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.activity.type	current	tree,form	\N	\N
131	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Activities"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.activity	current	tree,form	\N	\N
25	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Attachments"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Attach a new document\\n              </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:52.288141	\N	\N	80	64	\N	{}	ir.attachment	current	kanban,tree,form	\N	\N
13	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Scheduled Actions"}	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:52.288141	28	\N	80	\N	[('id', '!=', 4)]	{'search_default_all': 1}	ir.cron	current	tree,form,calendar	\N	\N
137	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Aliases"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{\n                    'search_default_active': True,\n                }\n            	mail.alias	current	tree,form	\N	\N
138	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Mail Gateway Allowed"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.gateway.allowed	current	tree	\N	\N
139	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Guests"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.guest	current	tree,form	\N	\N
140	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Message Reactions"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	mail.message.reaction	current	tree,form	\N	\N
141	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "User Settings"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{}	res.users.settings	current	tree,form	\N	\N
194	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Privacy Logs"}	\N	2026-02-06 07:57:05.249714	2026-02-06 07:57:05.249714	\N	\N	80	\N	\N	{'create': False}	privacy.log	current	tree,form	\N	\N
143	85	1	1	ir.actions.act_window	action	list	{"en_US": "Send email"}	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N	80	\N	\N	{'default_composition_mode': 'mass_mail', 'default_partner_to': "{{ object.id or '' }}", 'default_use_template': False, 'default_reply_to_force_new': True}	mail.compose.message	new	form	\N	\N
144	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Blacklisted Email Addresses"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Add an email address to the blacklist\\n          </p><p>\\n            Email addresses that are blacklisted won't receive Email mailings anymore.\\n        </p>\\n        "}	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	385	\N	80	387	\N	{}	mail.blacklist	current	tree,form	\N	\N
56	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact in your address book\\n              </p><p>\\n                Odoo helps you track all activities related to your contacts.\\n              </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:52.288141	\N	\N	80	125	\N	{'res_partner_search_mode': 'customer'}	res.partner	current	kanban,tree,form,activity	\N	\N
57	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Customers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new customer in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a customer.\\n              </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:52.288141	\N	\N	80	\N	[]	{'res_partner_search_mode': 'customer', 'default_is_company': True}	res.partner	current	kanban,tree,form,activity	\N	t
58	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Vendors"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new vendor in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a vendor.\\n              </p>\\n            "}	2026-02-06 07:56:25.611196	2026-02-06 07:56:52.288141	\N	\N	80	\N	[]	{'res_partner_search_mode': 'supplier', 'default_is_company': True}	res.partner	current	kanban,tree,form,activity	\N	t
145	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Gross Margin"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No activity yet on this account\\n            </p><p>\\n                In Odoo, sales orders and projects are implemented using\\n                analytic accounts. You can track costs and revenues to analyse\\n                your margins easily.\\n            </p><p>\\n                Costs will be created automatically when you register supplier\\n                invoices, expenses or timesheets.\\n            </p><p>\\n                Revenues will be created automatically when you create customer\\n                invoices. Customer invoices can be created based on sales orders\\n                (fixed price invoices), on timesheets (based on the work done) or\\n                on expenses (e.g. reinvoicing of travel costs).\\n            </p>\\n        "}	2026-02-06 07:56:58.022054	2026-02-06 07:56:58.022054	399	\N	80	400	[('account_id','=', active_id)]	{'search_default_group_date': 1, 'default_account_id': active_id}	account.analytic.line	current	tree,form,graph,pivot	\N	\N
146	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Analytic Items"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n               No activity yet\\n            </p><p>\\n                In Odoo, sales orders and projects are implemented using\\n                analytic accounts. You can track costs and revenues to analyse\\n                your margins easily.\\n            </p><p>\\n                Costs will be created automatically when you register supplier\\n                invoices, expenses or timesheets.\\n            </p><p>\\n                Revenues will be created automatically when you create customer\\n                invoices. Customer invoices can be created based on sales orders\\n                (fixed price invoices), on timesheets (based on the work done) or\\n                on expenses (e.g. reinvoicing of travel costs).\\n            </p>\\n        "}	2026-02-06 07:56:58.022054	2026-02-06 07:56:58.022054	399	\N	80	400	\N	{}	account.analytic.line	current	tree,kanban,form,graph,pivot	\N	\N
147	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Chart of Analytic Accounts"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Add a new analytic account\\n              </p>\\n            "}	2026-02-06 07:56:58.022054	2026-02-06 07:56:58.022054	406	\N	80	409	\N	{'search_default_active':1}	account.analytic.account	current	tree,kanban,form	\N	\N
148	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Analytic Accounts"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Add a new analytic account\\n              </p>\\n            "}	2026-02-06 07:56:58.022054	2026-02-06 07:56:58.022054	\N	\N	80	409	\N	{'search_default_active':1}	account.analytic.account	current	tree,kanban,form	\N	\N
149	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Analytic Plans"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n              Click to add a new analytic account plan.\\n          </p>\\n        "}	2026-02-06 07:56:58.022054	2026-02-06 07:56:58.022054	\N	\N	80	\N	[('parent_id', '=', False)]	{}	account.analytic.plan	current	tree,form	\N	\N
150	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Analytic Distribution Models"}	\N	2026-02-06 07:56:58.022054	2026-02-06 07:56:58.022054	\N	\N	80	\N	\N	{}	account.analytic.distribution.model	current	tree,form	\N	\N
155	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "You are about to install an extra application"}	\N	2026-02-06 07:56:58.928114	2026-02-06 07:56:58.928114	\N	\N	80	\N	\N	{ 'default_module_id': active_id }	base.module.install.review	new	form	\N	\N
156	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Sub State Type"}	\N	2026-02-06 07:56:59.126153	2026-02-06 07:56:59.126153	\N	\N	80	430	[]	{}	base.substate.type	current	tree,form	\N	\N
157	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Target State Value"}	\N	2026-02-06 07:56:59.126153	2026-02-06 07:56:59.126153	\N	\N	80	433	[]	{}	target.state.value	current	tree,form	\N	\N
158	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Base Substate"}	\N	2026-02-06 07:56:59.126153	2026-02-06 07:56:59.126153	\N	\N	80	436	[]	{}	base.substate	current	tree,form	\N	\N
160	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Tier Definition"}	\N	2026-02-06 07:56:59.481562	2026-02-06 07:56:59.481562	\N	\N	80	\N	\N	{'search_default_all': 1}	tier.definition	current	tree,form	\N	\N
161	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Tier Validation Exception"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">Create a new Validation Exception!</p>\\n            <p>Once created, you can decide which fields you want to be editable when the record:</p>\\n            <ul>\\n                <li>It's in the validation process</li>\\n                <li>It's fully validated</li>\\n            </ul>\\n        "}	2026-02-06 07:56:59.481562	2026-02-06 07:56:59.481562	\N	\N	80	\N	\N	{}	tier.validation.exception	current	tree,form	\N	\N
163	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Meeting Types"}	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119	455	\N	80	\N	\N	{}	calendar.event.type	current	tree,form	\N	\N
164	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Calendar Alarm"}	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119	456	\N	80	\N	\N	{}	calendar.alarm	current	tree,form	\N	\N
191	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Privacy Lookup Line"}	\N	2026-02-06 07:57:05.249714	2026-02-06 07:57:05.249714	521	\N	80	\N	\N	{'search_default_group_by_res_model_id': 1, 'no_create_edit': True}	privacy.lookup.wizard.line	current	tree	\N	\N
165	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Meetings"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            No meetings found. Let's schedule one!\\n          </p><p>\\n            The calendar is shared between employees and fully integrated with\\n            other applications such as the employee leaves or the business\\n            opportunities.\\n          </p>\\n        "}	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119	460	\N	80	461	\N	{}	calendar.event	current	calendar,tree,form	\N	\N
166	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Contacts"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Create a Contact in your address book\\n          </p><p>\\n            Odoo helps you track all activities related to your contacts.\\n          </p>\\n        "}	2026-02-06 07:57:01.255104	2026-02-06 07:57:01.255104	\N	\N	80	125	\N	{'default_is_company': True}	res.partner	current	kanban,tree,form,activity	\N	\N
167	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Launch Plan"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	\N	\N	{}	hr.plan.wizard	new	form	\N	\N
168	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Register Departure"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	\N	\N	{}	hr.departure.wizard	new	form	\N	\N
169	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Departure Reasons"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	\N	\N	{}	hr.departure.reason	current	tree	\N	\N
170	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Employment Types"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a new employment type\\n                </p>\\n            "}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	\N	\N	{}	hr.contract.type	current	tree	\N	\N
171	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Job Positions"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Ready to recruit more efficiently?\\n              </p><p>\\n                Let's create a job position.\\n              </p>\\n            "}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	478	\N	{"search_default_Current":1}	hr.job	current	tree,form	\N	\N
172	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Plans"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Add a new plan\\n                </p>\\n            "}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	479	\N	{}	hr.plan	current	tree,form	\N	\N
173	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Plan Activities"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Add a new plan activity\\n                </p>\\n            "}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	\N	\N	{}	hr.plan.activity.type	current	tree,form	\N	\N
174	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Employee Tags"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	\N	\N	{}	hr.employee.category	current	tree,form	\N	\N
175	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Employees"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Add a new employee\\n              </p><p>\\n                With just a quick glance on the Odoo employee screen, you\\n                can easily find all the information you need for each person;\\n                contact data, job position, availability, etc.\\n              </p>\\n            "}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	486	[]	{'chat_icon': True}	hr.employee.public	current	kanban,tree,form	\N	\N
177	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Employees"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n               Add a new employee\\n             </p><p>\\n               With just a quick glance on the Odoo employee screen, you\\n               can easily find all the information you need for each person;\\n               contact data, job position, availability, etc.\\n             </p>\\n            "}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	491	[]	{'chat_icon': True}	hr.employee	current	kanban,tree,form,activity	\N	\N
178	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Employees Structure"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	494	\N	80	491	[('parent_id','=',False)]	{}	hr.employee	current	tree,form	\N	\N
179	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Employees"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	491	\N	{}	hr.employee	current	form,tree	\N	\N
181	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Employees"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Add a new employee\\n              </p><p>\\n                With just a quick glance on the Odoo employee screen, you\\n                can easily find all the information you need for each person;\\n                contact data, job position, availability, etc.\\n              </p>\\n            "}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	491	\N	{\n                "searchpanel_default_department_id": active_id,\n                "default_department_id": active_id,\n                "search_default_group_department": 1,\n                "search_default_department_id": active_id,\n                "expand": 1}\n            	hr.employee	current	tree,kanban,form	\N	\N
182	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Departments"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new department\\n              </p><p>\\n                Odoo's department structure is used to manage all documents\\n                related to employees by departments: expenses, timesheets,\\n                time off, recruitments, etc.\\n              </p>\\n            "}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	500	\N	{}	hr.department	current	kanban,tree,form	\N	\N
183	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Departments"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a new department\\n                </p><p>\\n                    Odoo's department structure is used to manage all documents\\n                    related to employees by departments: expenses, timesheets,\\n                    leaves, recruitments, etc.\\n                </p>\\n            "}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	500	\N	{}	hr.department	current	tree,form,kanban	\N	\N
184	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Work Locations"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a new work location\\n                </p>\\n            "}	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	\N	\N	{}	hr.work.location	current	tree,form	\N	\N
185	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Settings"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	\N	\N	{'module' : 'hr', 'bin_size': False}	res.config.settings	inline	form	\N	\N
186	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Change my Preferences"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	508	\N	80	\N	\N	{'from_my_profile': True}	res.users	current	form	\N	\N
187	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Employees"}	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N	80	\N	[('user_id', '=', active_id)]	{}	hr.employee	current	kanban,tree,form	\N	\N
189	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Blacklisted Phone Numbers"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Add a phone number in the blacklist\\n            </p><p>\\n                Blacklisted phone numbers won't receive SMS Mailings anymore.\\n            </p>\\n        "}	2026-02-06 07:57:04.883303	2026-02-06 07:57:04.883303	516	\N	80	518	\N	{}	phone.blacklist	current	tree,form	\N	\N
190	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Privacy Lookup"}	\N	2026-02-06 07:57:05.249714	2026-02-06 07:57:05.249714	520	\N	80	\N	\N	{}	privacy.lookup.wizard	current	form	\N	\N
195	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Privacy Logs"}	\N	2026-02-06 07:57:05.249714	2026-02-06 07:57:05.249714	\N	\N	80	\N	\N	{'create': False}	privacy.log	current	form	\N	\N
198	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Choose Labels Layout"}	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	\N	80	\N	\N	{}	product.label.layout	new	tree,form	\N	\N
199	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Products"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new product\\n            </p>\\n        "}	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	\N	80	\N	\N	{}	product.template	current	kanban,tree,form	\N	\N
200	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Product Variants"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new product variant\\n              </p><p>\\n                You must define a product for everything you sell or purchase,\\n                whether it's a storable product, a consumable or a service.\\n              </p>\\n            "}	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	\N	80	528	\N	{}	product.product	current	tree,form,kanban,activity	\N	\N
201	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Product Variants"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new product variant\\n              </p><p>\\n                You must define a product for everything you sell or purchase,\\n                whether it's a storable product, a consumable or a service.\\n                The product form contains information to simplify the sale process:\\n                price, notes in the quotation, accounting data, procurement methods, etc.\\n              </p>\\n            "}	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	\N	80	528	\N	{'search_default_product_tmpl_id': [active_id], 'default_product_tmpl_id': active_id, 'create': False}	product.product	current	tree,form	\N	\N
202	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Product Variants"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new product variant\\n              </p><p>\\n                You must define a product for everything you sell, whether it's a physical product,\\n                a consumable or a service you offer to customers.\\n                The product form contains information to simplify the sale process:\\n                price, notes in the quotation, accounting data, procurement methods, etc.\\n              </p>\\n            "}	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	530	\N	80	528	\N	{"search_default_filter_to_sell":1}	product.product	current	kanban,tree,form,activity	\N	\N
204	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Attributes"}	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	\N	80	\N	\N	{}	product.attribute	current	tree,form	\N	\N
205	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Product Categories"}	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	542	\N	80	543	\N	{}	product.category	current	tree,form	\N	\N
206	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Product Packagings"}	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	\N	80	\N	[('product_id', '!=', False)]	{}	product.packaging	current	tree,form	\N	\N
207	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Pricelists"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Create a new pricelist\\n            </p><p>\\n            A price is a set of sales prices or rules to compute the price of sales order lines based on products, product categories, dates and ordered quantities.\\n            This is the perfect tool to handle several pricings, seasonal discounts, etc.\\n            </p><p>\\n            You can assign pricelists to your customers or select one when creating a new sales quotation.\\n            </p>\\n        "}	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	\N	80	552	\N	{"default_base":'list_price'}	product.pricelist	current	tree,kanban,form	\N	\N
208	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Price Rules"}	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	\N	80	\N	\N	{}	product.pricelist.item	current	tree,form	\N	\N
209	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Vendor Pricelists"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                No vendor pricelist found\\n            </p><p>\\n                Register the prices requested by your vendors for each product, based on the quantity and the period.\\n            </p>\\n        "}	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	\N	80	\N	\N	{'visible_product_tmpl_id': False, 'search_default_active_products': True}	product.supplierinfo	current	tree,form,kanban	\N	\N
210	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Products"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new product\\n            </p><p>\\n                You must define a product for everything you sell or purchase,\\n                whether it's a storable product, a consumable or a service.\\n            </p>\\n        "}	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	562	\N	80	527	\N	{"search_default_filter_to_sell":1}	product.template	current	kanban,tree,form	\N	\N
212	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Product Tags"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Define a new tag\\n          </p><p>\\n            Tags are used to search product for a given theme.\\n          </p>\\n        "}	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988	\N	\N	80	\N	\N	{}	product.tag	current	tree,form	\N	\N
217	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Ratings"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                    No rating yet\\n                </p><p>\\n                    There is no rating for this object at the moment.\\n                </p>\\n            "}	2026-02-06 07:57:07.542407	2026-02-06 07:57:07.542407	\N	\N	80	\N	\N	{}	rating.rating	current	kanban,tree,graph,pivot,form	\N	\N
218	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Tags"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Create CRM Tags\\n            </p><p>\\n            Use Tags to manage and track your Opportunities (product structure, sales type, ...)\\n            </p>\\n        "}	2026-02-06 07:57:07.961456	2026-02-06 07:57:07.961456	592	\N	80	\N	\N	{}	crm.tag	current	tree,form	\N	\N
219	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Sales Teams"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Define a new sales team\\n            </p><p>\\n                Use Sales Teams to organize your sales departments.\\n                Each team will work with a separate pipeline.\\n            </p>\\n        "}	2026-02-06 07:57:07.961456	2026-02-06 07:57:07.961456	\N	\N	80	\N	\N	{'in_sales_app': True}	crm.team	current	kanban,form	\N	\N
220	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Teams"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Define a new sales team\\n            </p><p>\\n                Use Sales Teams to organize your sales departments.\\n                Each team will work with a separate pipeline.\\n            </p>\\n        "}	2026-02-06 07:57:07.961456	2026-02-06 07:57:07.961456	\N	\N	80	\N	\N	{}	crm.team	current	kanban,form	\N	\N
221	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Sales Teams"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Sales Team\\n            </p><p>\\n                Use Sales Teams to organize your sales departments and draw up reports.\\n            </p>\\n        "}	2026-02-06 07:57:07.961456	2026-02-06 07:57:07.961456	\N	\N	80	\N	\N	{}	crm.team	current	tree,form	\N	\N
222	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Team Members"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new salesman\\n            </p><p>\\n                Link salespersons to sales teams.\\n            </p>\\n        "}	2026-02-06 07:57:07.961456	2026-02-06 07:57:07.961456	\N	\N	80	\N	\N	{}	crm.team.member	current	kanban,tree,form	\N	\N
223	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Activity Types"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create an Activity Type\\n            </p><p>\\n                Those represent the different categories of things you have to do (e.g. \\"Call\\" or \\"Prepare meeting\\").\\n            </p>\\n        "}	2026-02-06 07:57:07.961456	2026-02-06 07:57:07.961456	\N	\N	80	\N	['|', ('res_model', '=', False), ('res_model', '=', 'res.partner')]	{}	mail.activity.type	current	tree,form	\N	\N
225	\N	1	1	ir.actions.act_window	action	list,form	{"en_US": "Dashboards"}	\N	2026-02-06 07:57:08.550438	2026-02-06 07:57:08.550438	\N	\N	80	\N	\N	{}	spreadsheet.dashboard.group	current	tree,form	\N	\N
\.


--
-- Data for Name: ir_act_window_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_group_rel (act_id, gid) FROM stdin;
73	4
\.


--
-- Data for Name: ir_act_window_view; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_view (id, sequence, view_id, act_window_id, create_uid, write_uid, view_mode, multi, create_date, write_date) FROM stdin;
1	1	12	7	1	1	tree	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
2	2	13	7	1	1	form	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
3	0	126	56	1	1	kanban	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
4	2	123	56	1	1	form	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
5	1	120	56	1	1	tree	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
6	1	126	57	1	1	kanban	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
7	2	120	57	1	1	tree	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
8	3	123	57	1	1	form	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
9	1	126	58	1	1	kanban	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
10	2	120	58	1	1	tree	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
11	3	123	58	1	1	form	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
12	10	161	70	1	1	tree	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
13	20	160	70	1	1	form	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
14	10	167	72	1	1	form	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
15	1	\N	131	1	1	tree	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141
16	2	344	131	1	1	form	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141
17	\N	\N	149	1	1	tree	\N	2026-02-06 07:56:58.022054	2026-02-06 07:56:58.022054
18	\N	410	149	1	1	form	\N	2026-02-06 07:56:58.022054	2026-02-06 07:56:58.022054
19	20	429	156	1	1	form	\N	2026-02-06 07:56:59.126153	2026-02-06 07:56:59.126153
20	10	428	156	1	1	tree	\N	2026-02-06 07:56:59.126153	2026-02-06 07:56:59.126153
21	20	432	157	1	1	form	\N	2026-02-06 07:56:59.126153	2026-02-06 07:56:59.126153
22	10	431	157	1	1	tree	\N	2026-02-06 07:56:59.126153	2026-02-06 07:56:59.126153
23	20	435	158	1	1	form	\N	2026-02-06 07:56:59.126153	2026-02-06 07:56:59.126153
24	10	434	158	1	1	tree	\N	2026-02-06 07:56:59.126153	2026-02-06 07:56:59.126153
25	1	460	165	1	1	calendar	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119
26	2	458	165	1	1	tree	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119
27	3	459	165	1	1	form	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119
28	0	126	166	1	1	kanban	\N	2026-02-06 07:57:01.255104	2026-02-06 07:57:01.255104
29	1	120	166	1	1	tree	\N	2026-02-06 07:57:01.255104	2026-02-06 07:57:01.255104
30	2	123	166	1	1	form	\N	2026-02-06 07:57:01.255104	2026-02-06 07:57:01.255104
31	\N	525	198	1	1	form	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988
32	\N	\N	201	1	1	tree	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988
33	\N	529	201	1	1	form	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988
34	\N	\N	201	1	1	kanban	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988
35	\N	544	206	1	1	tree	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988
36	\N	546	206	1	1	form	\N	2026-02-06 07:57:05.665988	2026-02-06 07:57:05.665988
37	1	583	217	1	1	kanban	\N	2026-02-06 07:57:07.542407	2026-02-06 07:57:07.542407
38	5	582	217	1	1	form	\N	2026-02-06 07:57:07.542407	2026-02-06 07:57:07.542407
\.


--
-- Data for Name: ir_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions (id, binding_model_id, create_uid, write_uid, type, binding_type, binding_view_types, name, help, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_actions_server_mass_edit_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions_server_mass_edit_line (id, sequence, server_action_id, field_id, create_uid, write_uid, widget_option, apply_domain, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_actions_todo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions_todo (id, action_id, sequence, create_uid, write_uid, state, name, create_date, write_date) FROM stdin;
1	2	100	1	1	done	Open Menu	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
2	51	1	1	1	done	Demo Failure Notification	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
\.


--
-- Data for Name: ir_asset; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_asset (id, sequence, create_uid, write_uid, name, bundle, directive, path, target, active, create_date, write_date) FROM stdin;
1	16	1	1	13 0 color system support primary variables SCSS	web._assets_primary_variables	append	web_editor/static/src/scss/13_0_color_system_support_primary_variables.scss	\N	f	2026-02-06 07:56:56.815204	2026-02-06 07:56:56.815204
\.


--
-- Data for Name: ir_attachment; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_attachment (id, res_id, company_id, file_size, create_uid, write_uid, name, res_model, res_field, type, url, access_token, store_fname, checksum, mimetype, description, index_content, public, create_date, write_date, db_datas, original_id) FROM stdin;
1	3	1	9152	1	1	flag_image	res.lang	flag_image	binary	\N	\N	44/44d1661b24fa9f688091c8256535434b60aafba7	44d1661b24fa9f688091c8256535434b60aafba7	image/png	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
2	63	1	15497	1	1	flag_image	res.lang	flag_image	binary	\N	\N	62/627090759f9a66678c28c1bc3c3039b37f40f66e	627090759f9a66678c28c1bc3c3039b37f40f66e	image/png	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
3	10	1	192	1	1	flag_image	res.lang	flag_image	binary	\N	\N	05/055ffc5cce56e142234ffc466012dff7edc2c7e7	055ffc5cce56e142234ffc466012dff7edc2c7e7	image/png	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
4	1	1	15310	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
5	1	1	1150	1	1	favicon	res.company	favicon	binary	\N	\N	d0/d09086a0794cf3070f12e742f27126254b4e2b5a	d09086a0794cf3070f12e742f27126254b4e2b5a	image/vnd.microsoft.icon	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
6	1	1	15310	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
7	1	1	15310	1	1	image_512	res.partner	image_512	binary	\N	\N	d5/d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	d5cce68bf4bb4ab57beaf766f3fb775cf8df0c83	image/png	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
8	1	1	12509	1	1	image_256	res.partner	image_256	binary	\N	\N	77/7712910ea66effcd74ee140f5d145fe30000aa57	7712910ea66effcd74ee140f5d145fe30000aa57	image/png	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
9	1	1	5421	1	1	image_128	res.partner	image_128	binary	\N	\N	e0/e0d4b5b2f41d6a523b47d17100558bf3084c67b1	e0d4b5b2f41d6a523b47d17100558bf3084c67b1	image/png	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
10	1	1	9168	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	ab/ab7e6730db0c9255c1a5c4373a2dec39f94058e5	ab7e6730db0c9255c1a5c4373a2dec39f94058e5	image/png	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
11	4	1	9020	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	b8/b8f9001425cfd0ef0315797909281b912817643a	b8f9001425cfd0ef0315797909281b912817643a	image/png	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
12	5	1	9180	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	a3/a330920abcef2433621d6bb985bc24828d77f77b	a330920abcef2433621d6bb985bc24828d77f77b	image/png	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
13	19	1	2879	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	37/370346e9cc2090760bd32bba59f14042e98cd92e	370346e9cc2090760bd32bba59f14042e98cd92e	image/svg+xml	\N	image	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196	\N	\N
14	\N	1	\N	1	1	placeholder.png	\N	\N	url	/web/static/img/placeholder.png	\N	\N	\N	image/png	\N	\N	t	2026-02-06 07:56:46.164914	2026-02-06 07:56:46.164914	\N	\N
15	\N	1	583	1	1	res.company.scss	\N	\N	binary	web/static/asset_styles_company_report.scss	\N	6a/6a8d2ce207c6f1860f379cf9f75c8cc497c06982	6a8d2ce207c6f1860f379cf9f75c8cc497c06982	text/scss	\N	                .o_company_1_layout {\n                font-family: Lato;\n                &.o_report_layout_standard {\n                    h2 {\n                        color: black;\n                    }\n                    #informations strong {\n                        color: black;\n                    }\n                    #total strong{\n                        color: black;\n                    }\n                    table {\n                        thead {\n                            color: black;\n                        }\n                    }\n                }\n            }	\N	2026-02-06 07:56:46.164914	2026-02-06 07:56:46.164914	\N	\N
16	76	1	3055	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	c4/c4cd08e1cc65b073a1c111c6e59815598eb8193a	c4cd08e1cc65b073a1c111c6e59815598eb8193a	image/svg+xml	\N	image	\N	2026-02-06 07:56:50.702405	2026-02-06 07:56:50.702405	\N	\N
17	2	1	2215	1	1	image_1920	res.partner	image_1920	binary	\N	\N	91/91cf91f4bb4e8ab1dda361b7ce81fd7a215616cb	91cf91f4bb4e8ab1dda361b7ce81fd7a215616cb	image/png	\N	image	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N
18	2	1	2215	1	1	image_1024	res.partner	image_1024	binary	\N	\N	91/91cf91f4bb4e8ab1dda361b7ce81fd7a215616cb	91cf91f4bb4e8ab1dda361b7ce81fd7a215616cb	image/png	\N	image	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N
19	2	1	2215	1	1	image_512	res.partner	image_512	binary	\N	\N	91/91cf91f4bb4e8ab1dda361b7ce81fd7a215616cb	91cf91f4bb4e8ab1dda361b7ce81fd7a215616cb	image/png	\N	image	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N
20	2	1	2215	1	1	image_256	res.partner	image_256	binary	\N	\N	91/91cf91f4bb4e8ab1dda361b7ce81fd7a215616cb	91cf91f4bb4e8ab1dda361b7ce81fd7a215616cb	image/png	\N	image	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N
21	2	1	2215	1	1	image_128	res.partner	image_128	binary	\N	\N	91/91cf91f4bb4e8ab1dda361b7ce81fd7a215616cb	91cf91f4bb4e8ab1dda361b7ce81fd7a215616cb	image/png	\N	image	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N
22	85	1	2059	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	6a/6a5b448a0e0b9b61d0f519949af275b96008a96b	6a5b448a0e0b9b61d0f519949af275b96008a96b	image/svg+xml	\N	image	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141	\N	\N
23	117	1	8684	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	e3/e3d8df8535447007b4d158630e7a78e677e5063c	e3d8df8535447007b4d158630e7a78e677e5063c	image/svg+xml	\N	image	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119	\N	\N
24	123	1	6233	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	b2/b2256e07ff068458711ea094a13b4f8ecd678195	b2256e07ff068458711ea094a13b4f8ecd678195	image/svg+xml	\N	image	\N	2026-02-06 07:57:01.255104	2026-02-06 07:57:01.255104	\N	\N
25	136	1	6448	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	71/71c3cb0970bade62eb3128ea399627b530480b14	71c3cb0970bade62eb3128ea399627b530480b14	image/svg+xml	\N	image	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253	\N	\N
26	162	1	6417	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	59/59f76a9b296a2e8e4732f4e69b4b7ace8a5057c9	59f76a9b296a2e8e4732f4e69b4b7ace8a5057c9	image/svg+xml	\N	image	\N	2026-02-06 07:57:08.550438	2026-02-06 07:57:08.550438	\N	\N
\.


--
-- Data for Name: ir_config_parameter; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_config_parameter (id, create_uid, write_uid, key, value, create_date, write_date) FROM stdin;
4	1	1	web.base.url	http://localhost:8069	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
5	1	1	base.login_cooldown_after	10	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
6	1	1	base.login_cooldown_duration	60	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
7	1	1	mail.catchall.alias	catchall	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
8	1	1	mail.bounce.alias	bounce	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
9	1	1	mail.default.from	notifications	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
10	1	1	base.template_portal_user_id	5	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
1	1	1	database.secret	c91d1ec2-13e5-4835-bf5c-5d135b4f41f1	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
2	1	1	database.uuid	5ef30e8f-0331-11f1-8235-0186896c5000	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
3	1	1	database.create_date	2026-02-06 07:56:40	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
11	1	1	base_setup.show_effect	True	2026-02-06 07:56:48.916945	2026-02-06 07:56:48.916945
12	1	1	ribbon.name	TEST<br/>({db_name})	2026-02-06 07:56:51.030181	2026-02-06 07:56:51.030181
13	1	1	ribbon.color	#f0f0f0	2026-02-06 07:56:51.030181	2026-02-06 07:56:51.030181
14	1	1	ribbon.background.color	rgba(255,0,0,.6)	2026-02-06 07:56:51.030181	2026-02-06 07:56:51.030181
15	1	1	auth_signup.invitation_scope	b2c	2026-02-06 07:56:58.535815	2026-02-06 07:56:58.535815
16	1	1	auth_signup.reset_password	True	2026-02-06 07:56:58.535815	2026-02-06 07:56:58.535815
17	1	1	hr.hr_presence_control_login	True	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
\.


--
-- Data for Name: ir_cron; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron (id, ir_actions_server_id, user_id, interval_number, numbercall, priority, create_uid, write_uid, interval_type, cron_name, active, doall, nextcall, lastcall, create_date, write_date) FROM stdin;
1	33	1	1	-1	5	1	1	days	{"en_US": "Base: Auto-vacuum internal data"}	t	\N	2026-02-06 07:56:39	\N	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
2	79	1	3	-1	5	1	1	hours	{"en_US": "Update user roles"}	t	f	2026-02-06 07:56:44	\N	2026-02-06 07:56:44.287826	2026-02-06 07:56:44.287826
3	132	1	1	-1	5	1	1	hours	{"en_US": "Mail: Email Queue Manager"}	t	f	2026-02-06 07:56:54	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141
4	133	1	1	-1	1000	1	1	weeks	{"en_US": "Publisher: Update Notification"}	t	f	2026-02-13 07:56:54	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141
5	134	1	1	-1	5	1	1	days	{"en_US": "Notification: Delete Notifications older than 6 Month"}	t	f	2026-02-06 07:56:55	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141
6	135	1	5	-1	5	1	1	minutes	{"en_US": "Mail: Fetchmail Service"}	f	f	2026-02-06 07:56:55	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141
7	136	1	1	-1	5	1	1	hours	{"en_US": "Notification: Send scheduled message notifications"}	t	f	2026-02-06 07:56:55	\N	2026-02-06 07:56:52.288141	2026-02-06 07:56:52.288141
8	151	1	1	-1	5	1	1	days	{"en_US": "Users: Notify About Unregistered Users"}	t	\N	2026-02-06 07:56:58	\N	2026-02-06 07:56:58.535815	2026-02-06 07:56:58.535815
9	159	1	1	-1	5	1	1	days	{"en_US": "Send Tier Review Reminder"}	t	f	2026-02-06 08:01:59	\N	2026-02-06 07:56:59.481562	2026-02-06 07:56:59.481562
10	162	1	1	-1	5	1	1	days	{"en_US": "Calendar: Event Reminder"}	t	f	2026-02-06 07:57:00	\N	2026-02-06 07:57:00.452119	2026-02-06 07:57:00.452119
11	188	1	1	-1	5	1	1	days	{"en_US": "HR Employee: check work permit validity"}	t	\N	2026-02-06 07:57:04	\N	2026-02-06 07:57:01.847253	2026-02-06 07:57:01.847253
12	226	1	1	-1	5	1	1	hours	{"en_US": "Automatic Tier Validation"}	t	f	2026-02-06 08:02:11	\N	2026-02-06 07:57:10.870485	2026-02-06 07:57:10.870485
\.


--
-- Data for Name: ir_cron_trigger; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron_trigger (id, cron_id, create_uid, write_uid, call_at, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_default; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_default (id, field_id, user_id, company_id, create_uid, write_uid, condition, json_value, create_date, write_date) FROM stdin;
1	901	\N	\N	1	1	\N	"en_US"	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
\.


--
-- Data for Name: ir_demo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure (id, module_id, wizard_id, create_uid, write_uid, error, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports (id, create_uid, write_uid, name, resource, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports_line (id, export_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_filters; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_filters (id, user_id, action_id, create_uid, write_uid, name, model_id, domain, context, sort, is_default, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_logging; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_logging (id, create_uid, write_uid, name, type, dbname, level, path, func, line, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_mail_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_mail_server (id, smtp_port, sequence, create_uid, write_uid, name, from_filter, smtp_host, smtp_authentication, smtp_user, smtp_pass, smtp_encryption, smtp_debug, active, create_date, write_date, smtp_ssl_certificate, smtp_ssl_private_key, google_gmail_access_token_expiration, google_gmail_authorization_code, google_gmail_refresh_token, google_gmail_access_token) FROM stdin;
\.


--
-- Data for Name: ir_model; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model (id, create_uid, write_uid, model, "order", state, name, info, transient, create_date, write_date, is_mail_thread, is_mail_activity, is_mail_blacklist) FROM stdin;
1	\N	\N	base	id	base	{"en_US": "Base"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
2	\N	\N	_unknown	id	base	{"en_US": "Unknown"}	\n    Abstract model used as a substitute for relational fields with an unknown\n    comodel.\n    	f	\N	\N	f	f	f
23	\N	\N	ir.actions.server	sequence,name	base	{"en_US": "Server Action"}	 Add mail.thread related options in server actions. 	f	\N	\N	f	f	f
91	\N	\N	res.config.settings	id	base	{"en_US": "Config Settings"}	 Inherit the base settings to add a counter of failed email + configure\n    the alias domain. 	t	\N	\N	f	f	f
229	\N	\N	publisher_warranty.contract	id	base	{"en_US": "Publisher Warranty Contract"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
170	\N	\N	utm.tag	name	base	{"en_US": "UTM Tag"}	Model of categories of utm campaigns, i.e. marketing, newsletter, ...	f	\N	\N	f	f	f
156	\N	\N	ir.websocket	id	base	{"en_US": "websocket message handling"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
179	\N	\N	mail.alias	alias_model_id, alias_name	base	{"en_US": "Email Aliases"}	A Mail Alias is a mapping of an email address with a given Odoo Document\n       model. It is used by Odoo's mail gateway when processing incoming emails\n       sent to the system. If the recipient address (To) of the message matches\n       a Mail Alias, the message will be either processed following the rules\n       of that alias. If the message is a reply it will be attached to the\n       existing discussion on the corresponding record, otherwise a new\n       record of the corresponding model will be created.\n\n       This is meant to be used in combination with a catch-all email configuration\n       on the company's mail server, so that as soon as a new mail.alias is\n       created, it becomes immediately usable and Odoo will accept email for it.\n     	f	\N	\N	f	f	f
181	\N	\N	mail.activity.mixin	id	base	{"en_US": "Activity Mixin"}	 Mail Activity Mixin is a mixin class to use if you want to add activities\n    management on a model. It works like the mail.thread mixin. It defines\n    an activity_ids one2many field toward activities using res_id and res_model_id.\n    Various related / computed fields are also added to have a global status of\n    activities on documents.\n\n    Activities come with a new JS widget for the form view. It is integrated in the\n    Chatter widget although it is a separate widget. It displays activities linked\n    to the current record and allow to schedule, edit and mark done activities.\n    Just include field activity_ids in the div.oe-chatter to use it.\n\n    There is also a kanban widget defined. It defines a small widget to integrate\n    in kanban vignettes. It allow to manage activities directly from the kanban\n    view. Use widget="kanban_activity" on activitiy_ids field in kanban view to\n    use it.\n\n    Some context keys allow to control the mixin behavior. Use those in some\n    specific cases like import\n\n     * ``mail_activity_automation_skip``: skip activities automation; it means\n       no automated activities will be generated, updated or unlinked, allowing\n       to save computation and avoid generating unwanted activities;\n    	f	\N	\N	f	t	f
182	\N	\N	mail.alias.mixin	id	base	{"en_US": "Email Aliases Mixin"}	 A mixin for models that inherits mail.alias. This mixin initializes the\n        alias_id column in database, and manages the expected one-to-one\n        relation between your model and mail aliases.\n    	f	\N	\N	f	f	f
183	\N	\N	mail.render.mixin	id	base	{"en_US": "Mail Render Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
184	\N	\N	mail.composer.mixin	id	base	{"en_US": "Mail Composer Mixin"}	 Mixin used to edit and render some fields used when sending emails or\n    notifications based on a mail template.\n\n    Main current purpose is to hide details related to subject and body computation\n    and rendering based on a mail.template. It also give the base tools to control\n    who is allowed to edit body, notably when dealing with templating language\n    like inline_template or qweb.\n\n    It is meant to evolve in a near future with upcoming support of qweb and fine\n    grain control of rendering access.\n    	f	\N	\N	f	f	f
185	\N	\N	mail.thread	id	base	{"en_US": "Email Thread"}	 mail_thread model is meant to be inherited by any model that needs to\n        act as a discussion topic on which messages can be attached. Public\n        methods are prefixed with ``message_`` in order to avoid name\n        collisions with methods of the models that will inherit from this class.\n\n        ``mail.thread`` defines fields used to handle and display the\n        communication history. ``mail.thread`` also manages followers of\n        inheriting classes. All features and expected behavior are managed\n        by mail.thread. Widgets has been designed for the 7.0 and following\n        versions of Odoo.\n\n        Inheriting classes are not required to implement any method, as the\n        default implementation will work for any model. However it is common\n        to override at least the ``message_new`` and ``message_update``\n        methods (calling ``super``) to add model-specific behavior at\n        creation and update of a thread when processing incoming emails.\n\n        Options:\n            - _mail_flat_thread: if set to True, all messages without parent_id\n                are automatically attached to the first message posted on the\n                resource. If set to False, the display of Chatter is done using\n                threads, and no parent_id is automatically set.\n\n    MailThread features can be somewhat controlled through context keys :\n\n     - ``mail_create_nosubscribe``: at create or message_post, do not subscribe\n       uid to the record thread\n     - ``mail_create_nolog``: at create, do not log the automatic '<Document>\n       created' message\n     - ``mail_notrack``: at create and write, do not perform the value tracking\n       creating messages\n     - ``tracking_disable``: at create and write, perform no MailThread features\n       (auto subscription, tracking, post, ...)\n     - ``mail_notify_force_send``: if less than 50 email notifications to send,\n       send them directly instead of using the queue; True by default\n    	f	\N	\N	t	f	f
186	\N	\N	mail.thread.blacklist	id	base	{"en_US": "Mail Blacklist mixin"}	 Mixin that is inherited by all model with opt out. This mixin stores a normalized\n    email based on primary_email field.\n\n    A normalized email is considered as :\n        - having a left part + @ + a right part (the domain can be without '.something')\n        - being lower case\n        - having no name before the address. Typically, having no 'Name <>'\n    Ex:\n        - Formatted Email : 'Name <NaMe@DoMaIn.CoM>'\n        - Normalized Email : 'name@domain.com'\n\n    The primary email field can be specified on the parent model, if it differs from the default one ('email')\n    The email_normalized field can than be used on that model to search quickly on emails (by simple comparison\n    and not using time consuming regex anymore).\n\n    Using this email_normalized field, blacklist status is computed.\n\n    Mail Thread capabilities are required for this mixin. 	f	\N	\N	t	f	t
202	\N	\N	mail.tracking.value	tracking_sequence asc	base	{"en_US": "Mail Tracking Value"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
187	\N	\N	mail.thread.cc	id	base	{"en_US": "Email CC management"}	 mail_thread model is meant to be inherited by any model that needs to\n        act as a discussion topic on which messages can be attached. Public\n        methods are prefixed with ``message_`` in order to avoid name\n        collisions with methods of the models that will inherit from this class.\n\n        ``mail.thread`` defines fields used to handle and display the\n        communication history. ``mail.thread`` also manages followers of\n        inheriting classes. All features and expected behavior are managed\n        by mail.thread. Widgets has been designed for the 7.0 and following\n        versions of Odoo.\n\n        Inheriting classes are not required to implement any method, as the\n        default implementation will work for any model. However it is common\n        to override at least the ``message_new`` and ``message_update``\n        methods (calling ``super``) to add model-specific behavior at\n        creation and update of a thread when processing incoming emails.\n\n        Options:\n            - _mail_flat_thread: if set to True, all messages without parent_id\n                are automatically attached to the first message posted on the\n                resource. If set to False, the display of Chatter is done using\n                threads, and no parent_id is automatically set.\n\n    MailThread features can be somewhat controlled through context keys :\n\n     - ``mail_create_nosubscribe``: at create or message_post, do not subscribe\n       uid to the record thread\n     - ``mail_create_nolog``: at create, do not log the automatic '<Document>\n       created' message\n     - ``mail_notrack``: at create and write, do not perform the value tracking\n       creating messages\n     - ``tracking_disable``: at create and write, perform no MailThread features\n       (auto subscription, tracking, post, ...)\n     - ``mail_notify_force_send``: if less than 50 email notifications to send,\n       send them directly instead of using the queue; True by default\n    	f	\N	\N	t	f	f
188	\N	\N	template.reset.mixin	id	base	{"en_US": "Template Reset Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
189	\N	\N	fetchmail.server	priority	base	{"en_US": "Incoming Mail Server"}	Incoming POP/IMAP mail server account	f	\N	\N	f	f	f
190	\N	\N	mail.notification	id	base	{"en_US": "Message Notifications"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
191	\N	\N	mail.activity.type	sequence, id	base	{"en_US": "Activity Type"}	 Activity Types are used to categorize activities. Each type is a different\n    kind of activity e.g. call, mail, meeting. An activity can be generic i.e.\n    available for all models using activities; or specific to a model in which\n    case res_model field should be used. 	f	\N	\N	f	f	f
192	\N	\N	mail.activity	date_deadline ASC, id ASC	base	{"en_US": "Activity"}	 An actual activity to perform. Activities are linked to\n    documents using res_id and res_model_id fields. Activities have a deadline\n    that can be used in kanban view to display a status. Once done activities\n    are unlinked and a message is posted. This message has a new activity_type_id\n    field that indicates the activity linked to the message. 	f	\N	\N	f	f	f
193	\N	\N	mail.blacklist	id	base	{"en_US": "Mail Blacklist"}	 Model of blacklisted email addresses to stop sending emails.	f	\N	\N	t	f	f
194	\N	\N	mail.followers	id	base	{"en_US": "Document Followers"}	 mail_followers holds the data related to the follow mechanism inside\n    Odoo. Partners can choose to follow documents (records) of any kind\n    that inherits from mail.thread. Following documents allow to receive\n    notifications for new messages. A subscription is characterized by:\n\n    :param: res_model: model of the followed objects\n    :param: res_id: ID of resource (may be 0 for every objects)\n    	f	\N	\N	f	f	f
195	\N	\N	mail.gateway.allowed	id	base	{"en_US": "Mail Gateway Allowed"}	List of trusted email address which won't have the quota restriction.\n\n    The incoming emails have a restriction of the number of records they can\n    create with alias, defined by the 2 systems parameters;\n    - mail.gateway.loop.minutes\n    - mail.gateway.loop.threshold\n\n    But we might have some legit use cases for which we want to receive a ton of emails\n    from an automated-source. This model stores those trusted source and this restriction\n    won't apply to them.\n    	f	\N	\N	f	f	f
196	\N	\N	mail.link.preview	id	base	{"en_US": "Store link preview data"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
197	\N	\N	mail.message.reaction	id desc	base	{"en_US": "Message Reaction"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
198	\N	\N	mail.message.schedule	scheduled_datetime DESC, id DESC	base	{"en_US": "Scheduled Messages"}	 Mail message notification schedule queue.\n\n    This model is used to store the mail messages scheduled. So we can\n    delay the sending of the notifications. A scheduled date field already\n    exists on the <mail.mail> but it does not allow us to delay the sending\n    of the <bus.bus> notifications.\n    	f	\N	\N	f	f	f
199	\N	\N	mail.message.subtype	sequence, id	base	{"en_US": "Message subtypes"}	 Class holding subtype definition for messages. Subtypes allow to tune\n        the follower subscription, allowing only some subtypes to be pushed\n        on the Wall. 	f	\N	\N	f	f	f
200	\N	\N	mail.message	id desc	base	{"en_US": "Message"}	 Message model: notification (system, replacing res.log notifications),\n    comment (user input), email (incoming emails) and user_notification\n    (user-specific notification)\n\n    Note:: State management / Error codes / Failure types summary\n\n    * mail.notification\n      * notification_status\n        'ready', 'sent', 'bounce', 'exception', 'canceled'\n      * notification_type\n        'inbox', 'email', 'sms' (SMS addon), 'snail' (snailmail addon)\n      * failure_type\n        # generic\n        unknown,\n        # mail\n        "mail_email_invalid", "mail_smtp", "mail_email_missing"\n        # sms (SMS addon)\n        'sms_number_missing', 'sms_number_format', 'sms_credit',\n        'sms_server', 'sms_acc'\n        # snailmail (snailmail addon)\n        'sn_credit', 'sn_trial', 'sn_price', 'sn_fields',\n        'sn_format', 'sn_error'\n\n    * mail.mail\n      * state\n        'outgoing', 'sent', 'received', 'exception', 'cancel'\n      * failure_reason: text\n\n    * sms.sms (SMS addon)\n      * state\n        'outgoing', 'sent', 'error', 'canceled'\n      * error_code\n        'sms_number_missing', 'sms_number_format', 'sms_credit',\n        'sms_server', 'sms_acc',\n        # mass mode specific codes\n        'sms_blacklist', 'sms_duplicate'\n\n    * snailmail.letter (snailmail addon)\n      * state\n        'pending', 'sent', 'error', 'canceled'\n      * error_code\n        'CREDIT_ERROR', 'TRIAL_ERROR', 'NO_PRICE_AVAILABLE', 'FORMAT_ERROR',\n        'UNKNOWN_ERROR',\n\n    See ``mailing.trace`` model in mass_mailing application for mailing trace\n    information.\n    	f	\N	\N	f	f	f
201	\N	\N	mail.mail	id desc	base	{"en_US": "Outgoing Mails"}	 Model holding RFC2822 email messages to send. This model also provides\n        facilities to queue and send new email messages.  	f	\N	\N	f	f	f
203	\N	\N	mail.template	name	base	{"en_US": "Email Templates"}	Templates for sending email	f	\N	\N	f	f	f
204	\N	\N	mail.channel.member	id	base	{"en_US": "Listeners of a Channel"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
205	\N	\N	mail.channel.rtc.session	id	base	{"en_US": "Mail RTC session"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
206	\N	\N	mail.channel	id	base	{"en_US": "Discussion Channel"}	 A mail.channel is a discussion group that may behave like a listener\n    on documents. 	f	\N	\N	t	f	f
207	\N	\N	mail.guest	id	base	{"en_US": "Guest"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
208	\N	\N	mail.ice.server	id	base	{"en_US": "ICE server"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
209	\N	\N	mail.shortcode	id	base	{"en_US": "Canned Response / Shortcode"}	 Shortcode\n        Canned Responses, allowing the user to defined shortcuts in its message. Should be applied before storing message in database.\n        Emoji allowing replacing text with image for visual effect. Should be applied when the message is displayed (only for final rendering).\n        These shortcodes are global and are available for every user.\n    	f	\N	\N	f	f	f
210	\N	\N	res.users.settings	id	base	{"en_US": "User Settings"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
211	\N	\N	res.users.settings.volumes	id	base	{"en_US": "User Settings Volumes"}	 Represents the volume of the sound that the user of user_setting_id will receive from partner_id. 	f	\N	\N	f	f	f
155	\N	\N	bus.presence	id	base	{"en_US": "User Presence"}	 User Presence\n        Its status is 'online', 'away' or 'offline'. This model should be a one2one, but is not\n        attached to res_users to avoid database concurrence errors. Since the 'update' method is executed\n        at each poll, if the user have multiple opened tabs, concurrence errors can happend, but are 'muted-logged'.\n    	f	\N	\N	f	f	f
20	\N	\N	ir.actions.act_window.view	sequence,id	base	{"en_US": "Action Window View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
28	\N	\N	ir.attachment	id desc	base	{"en_US": "Attachment"}	Attachments are used to link binary files or url to any openerp document.\n\n    External attachment storage\n    ---------------------------\n\n    The computed field ``datas`` is implemented using ``_file_read``,\n    ``_file_write`` and ``_file_delete``, which can be overridden to implement\n    other storage engines. Such methods should check for other location pseudo\n    uri (example: hdfs://hadoopserver).\n\n    The default implementation is the file:dirname location that stores files\n    on the local filesystem using name based on their sha1 hash\n    	f	\N	\N	f	f	f
37	\N	\N	ir.config_parameter	key	base	{"en_US": "System Parameter"}	Per-database storage of configuration key-value pairs.	f	\N	\N	f	f	f
62	\N	\N	ir.http	id	base	{"en_US": "HTTP Routing"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
39	\N	\N	ir.mail_server	sequence	base	{"en_US": "Mail Server"}	Represents an SMTP server, able to send outgoing emails, with SSL and TLS capabilities.	f	\N	\N	f	f	f
3	\N	\N	ir.model	is_mail_thread DESC, name ASC	base	{"en_US": "Models"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
4	\N	\N	ir.model.fields	name	base	{"en_US": "Fields"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
15	\N	\N	ir.ui.view	priority,name,id	base	{"en_US": "View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
94	\N	\N	res.company	sequence, name	base	{"en_US": "Companies"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
85	\N	\N	res.partner	display_name ASC, id DESC	base	{"en_US": "Contact"}	 Update partner to add a field about notification preferences. Add a generic opt-out field that can be used\n       to restrict usage of automatic email templates. 	f	\N	\N	t	t	t
97	\N	\N	res.users	name, login	base	{"en_US": "User"}	 Update of res.users class\n        - add a preference about sending emails about notifications\n        - make a new user follow itself\n        - add a welcome message\n        - add suggestion preference\n        - if adding groups to a user, check mail.channels linked to this user\n          group, and the user. This is done by overriding the write method.\n    	f	\N	\N	f	f	f
95	\N	\N	res.groups	name	base	{"en_US": "Access Groups"}	 Update of res.groups class\n        - if adding users from a group, check mail.channels linked to this user\n          group and subscribe them. This is done by overriding the write method.\n    	f	\N	\N	f	f	f
41	\N	\N	ir.qweb	id	base	{"en_US": "Qweb"}	 IrQWeb object for rendering editor stuff\n    	f	\N	\N	f	f	f
112	\N	\N	base.module.uninstall	id	base	{"en_US": "Module Uninstall"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
115	\N	\N	base.partner.merge.automatic.wizard	id	base	{"en_US": "Merge Partner Wizard"}	\n        The idea behind this wizard is to create a list of potential partners to\n        merge. We use two objects, the first one is the wizard for the end-user.\n        And the second will contain the partner list to merge.\n    	t	\N	\N	f	f	f
232	\N	\N	mail.blacklist.remove	id	base	{"en_US": "Remove email from blacklist wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
233	\N	\N	mail.compose.message	id	base	{"en_US": "Email composition wizard"}	 Generic message composition wizard. You may inherit from this wizard\n        at model and view levels to provide specific features.\n\n        The behavior of the wizard depends on the composition_mode field:\n        - 'comment': post on a record. The wizard is pre-populated via ``get_record_data``\n        - 'mass_mail': wizard in mass mailing mode where the mail details can\n            contain template placeholders that will be merged with actual data\n            before being sent to each recipient.\n    	t	\N	\N	f	f	f
234	\N	\N	mail.resend.message	id	base	{"en_US": "Email resend wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
235	\N	\N	mail.resend.partner	id	base	{"en_US": "Partner with additional information for mail resend"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
236	\N	\N	mail.template.preview	id	base	{"en_US": "Email Template Preview"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
237	\N	\N	mail.template.reset	id	base	{"en_US": "Mail Template Reset"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
238	\N	\N	mail.wizard.invite	id	base	{"en_US": "Invite wizard"}	 Wizard to invite partners (or channels) and make them followers. 	t	\N	\N	f	f	f
5	\N	\N	ir.model.fields.selection	sequence, id	base	{"en_US": "Fields Selection"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
6	\N	\N	ir.model.constraint	id	base	{"en_US": "Model Constraint"}	\n    This model tracks PostgreSQL foreign keys and constraints used by Odoo\n    models.\n    	f	\N	\N	f	f	f
7	\N	\N	ir.model.relation	id	base	{"en_US": "Relation Model"}	\n    This model tracks PostgreSQL tables used to implement Odoo many2many\n    relations.\n    	f	\N	\N	f	f	f
8	\N	\N	ir.model.access	model_id,group_id,name,id	base	{"en_US": "Model Access"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
9	\N	\N	ir.model.data	module, model, name	base	{"en_US": "Model Data"}	Holds external identifier keys for records in the database.\n       This has two main uses:\n\n           * allows easy data integration with third-party systems,\n             making import/export/sync of data possible, as records\n             can be uniquely identified across multiple systems\n           * allows tracking the origin of data installed by Odoo\n             modules themselves, thus making it possible to later\n             update them seamlessly.\n    	f	\N	\N	f	f	f
10	\N	\N	wizard.ir.model.menu.create	id	base	{"en_US": "Create Menu Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
11	\N	\N	ir.sequence	name	base	{"en_US": "Sequence"}	\n    This sub-class is to refactor the ir.sequence by changing the inextensible\n    inner function `_interpolation_dict()` to a normal private class function.\n    	f	\N	\N	f	f	f
12	\N	\N	ir.sequence.date_range	id	base	{"en_US": "Sequence Date Range"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
13	\N	\N	ir.ui.menu	sequence,id	base	{"en_US": "Menu"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
14	\N	\N	ir.ui.view.custom	create_date desc	base	{"en_US": "Custom View"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
16	\N	\N	reset.view.arch.wizard	id	base	{"en_US": "Reset View Architecture Wizard"}	 A wizard to compare and reset views architecture. 	t	\N	\N	f	f	f
17	\N	\N	ir.asset	sequence, id	base	{"en_US": "Asset"}	This model contributes to two things:\n\n        1. It provides a function returning a list of all file paths declared\n        in a given list of addons (see _get_addon_paths);\n\n        2. It allows to create 'ir.asset' records to add additional directives\n        to certain bundles.\n    	f	\N	\N	f	f	f
18	\N	\N	ir.actions.actions	name	base	{"en_US": "Actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
19	\N	\N	ir.actions.act_window	name	base	{"en_US": "Action Window"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
21	\N	\N	ir.actions.act_window_close	name	base	{"en_US": "Action Window Close"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
22	\N	\N	ir.actions.act_url	name	base	{"en_US": "Action URL"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
24	\N	\N	ir.server.object.lines	id	base	{"en_US": "Server Action value mapping"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
25	\N	\N	ir.actions.todo	sequence, id	base	{"en_US": "Configuration Wizards"}	\n    Configuration Wizards\n    	f	\N	\N	f	f	f
26	\N	\N	ir.actions.client	name	base	{"en_US": "Client Action"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
27	\N	\N	ir.actions.report	name, id	base	{"en_US": "Report Action"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
29	\N	\N	ir.binary	id	base	{"en_US": "File streaming helper model for controllers"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
30	\N	\N	ir.cron	cron_name	base	{"en_US": "Scheduled Actions"}	 Model describing cron jobs (also called actions or tasks).\n    	f	\N	\N	f	f	f
31	\N	\N	ir.cron.trigger	id	base	{"en_US": "Triggered actions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
32	\N	\N	ir.filters	model_id, name, id desc	base	{"en_US": "Filters"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
33	\N	\N	ir.default	id	base	{"en_US": "Default Values"}	 User-defined default values for fields. 	f	\N	\N	f	f	f
34	\N	\N	ir.exports	name	base	{"en_US": "Exports"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
35	\N	\N	ir.exports.line	id	base	{"en_US": "Exports Line"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
36	\N	\N	ir.rule	model_id DESC,id	base	{"en_US": "Record Rule"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
38	\N	\N	ir.autovacuum	id	base	{"en_US": "Automatic Vacuum"}	 Helper model to the ``@api.autovacuum`` method decorator. 	f	\N	\N	f	f	f
40	\N	\N	ir.fields.converter	id	base	{"en_US": "Fields Converter"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
42	\N	\N	ir.qweb.field	id	base	{"en_US": "Qweb Field"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
43	\N	\N	ir.qweb.field.integer	id	base	{"en_US": "Qweb Field Integer"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
44	\N	\N	ir.qweb.field.float	id	base	{"en_US": "Qweb Field Float"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
45	\N	\N	ir.qweb.field.date	id	base	{"en_US": "Qweb Field Date"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
46	\N	\N	ir.qweb.field.datetime	id	base	{"en_US": "Qweb Field Datetime"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
47	\N	\N	ir.qweb.field.text	id	base	{"en_US": "Qweb Field Text"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
48	\N	\N	ir.qweb.field.selection	id	base	{"en_US": "Qweb Field Selection"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
49	\N	\N	ir.qweb.field.many2one	id	base	{"en_US": "Qweb Field Many to One"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
50	\N	\N	ir.qweb.field.many2many	id	base	{"en_US": "Qweb field many2many"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
51	\N	\N	ir.qweb.field.html	id	base	{"en_US": "Qweb Field HTML"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
52	\N	\N	ir.qweb.field.image	id	base	{"en_US": "Qweb Field Image"}	\n    Widget options:\n\n    ``class``\n        set as attribute on the generated <img> tag\n    	f	\N	\N	f	f	f
53	\N	\N	ir.qweb.field.image_url	id	base	{"en_US": "Qweb Field Image"}	 ``image_url`` widget rendering, inserts an image tag in the\n    document.\n    	f	\N	\N	f	f	f
54	\N	\N	ir.qweb.field.monetary	id	base	{"en_US": "Qweb Field Monetary"}	 ``monetary`` converter, has a mandatory option\n    ``display_currency`` only if field is not of type Monetary.\n    Otherwise, if we are in presence of a monetary field, the field definition must\n    have a currency_field attribute set.\n\n    The currency is used for formatting *and rounding* of the float value. It\n    is assumed that the linked res_currency has a non-empty rounding value and\n    res.currency's ``round`` method is used to perform rounding.\n\n    .. note:: the monetary converter internally adds the qweb context to its\n              options mapping, so that the context is available to callees.\n              It's set under the ``_values`` key.\n    	f	\N	\N	f	f	f
55	\N	\N	ir.qweb.field.float_time	id	base	{"en_US": "Qweb Field Float Time"}	 ``float_time`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "01:30").\n\n    Can be used on any numerical field.\n    	f	\N	\N	f	f	f
56	\N	\N	ir.qweb.field.time	id	base	{"en_US": "QWeb Field Time"}	 ``time`` converter, to display integer or fractional value as\n    human-readable time (e.g. 1.5 as "1:30 AM"). The unit of this value\n    is in hours.\n\n    Can be used on any numerical field between: 0 <= value < 24\n    	f	\N	\N	f	f	f
57	\N	\N	ir.qweb.field.duration	id	base	{"en_US": "Qweb Field Duration"}	 ``duration`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "1 hour 30 minutes").\n\n    Can be used on any numerical field.\n\n    Has an option ``unit`` which can be one of ``second``, ``minute``,\n    ``hour``, ``day``, ``week`` or ``year``, used to interpret the numerical\n    field value before converting it. By default use ``second``.\n\n    Has an option ``round``. By default use ``second``.\n\n    Has an option ``digital`` to display 01:00 instead of 1 hour\n\n    Sub-second values will be ignored.\n    	f	\N	\N	f	f	f
58	\N	\N	ir.qweb.field.relative	id	base	{"en_US": "Qweb Field Relative"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
59	\N	\N	ir.qweb.field.barcode	id	base	{"en_US": "Qweb Field Barcode"}	 ``barcode`` widget rendering, inserts a data:uri-using image tag in the\n    document. May be overridden by e.g. the website module to generate links\n    instead.\n    	f	\N	\N	f	f	f
60	\N	\N	ir.qweb.field.contact	id	base	{"en_US": "Qweb Field Contact"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
61	\N	\N	ir.qweb.field.qweb	id	base	{"en_US": "Qweb Field qweb"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
130	\N	\N	basemodel.extend	id	base	{"en_US": "Base Extend for Ztree"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
63	\N	\N	ir.logging	id DESC	base	{"en_US": "Logging"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
64	\N	\N	ir.property	id	base	{"en_US": "Company Property"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
65	\N	\N	ir.module.category	name	base	{"en_US": "Application"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
66	\N	\N	ir.module.module	application desc,sequence,name	base	{"en_US": "Module"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
67	\N	\N	ir.module.module.dependency	id	base	{"en_US": "Module dependency"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
68	\N	\N	ir.module.module.exclusion	id	base	{"en_US": "Module exclusion"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
69	\N	\N	ir.demo	id	base	{"en_US": "Demo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
70	\N	\N	ir.demo_failure	id	base	{"en_US": "Demo failure"}	 Stores modules for which we could not install demo data\n    	t	\N	\N	f	f	f
71	\N	\N	ir.demo_failure.wizard	id	base	{"en_US": "Demo Failure wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
72	\N	\N	report.layout	sequence	base	{"en_US": "Report Layout"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
73	\N	\N	report.paperformat	id	base	{"en_US": "Paper Format Config"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
74	\N	\N	ir.profile	session desc, id desc	base	{"en_US": "Profiling results"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
75	\N	\N	base.enable.profiling.wizard	id	base	{"en_US": "Enable profiling for some time"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
76	\N	\N	image.mixin	id	base	{"en_US": "Image Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
77	\N	\N	avatar.mixin	id	base	{"en_US": "Avatar Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
78	\N	\N	res.country	name	base	{"en_US": "Country"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
79	\N	\N	res.country.group	id	base	{"en_US": "Country Group"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
80	\N	\N	res.country.state	code	base	{"en_US": "Country state"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
81	\N	\N	res.lang	active desc,name	base	{"en_US": "Languages"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
82	\N	\N	format.address.mixin	id	base	{"en_US": "Address Format"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
83	\N	\N	res.partner.category	name	base	{"en_US": "Partner Tags"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
84	\N	\N	res.partner.title	name	base	{"en_US": "Partner Title"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
86	\N	\N	res.partner.industry	name	base	{"en_US": "Industry"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
87	\N	\N	res.bank	name	base	{"en_US": "Bank"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
88	\N	\N	res.partner.bank	sequence, id	base	{"en_US": "Bank Accounts"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
89	\N	\N	res.config	id	base	{"en_US": "Config"}	 Base classes for new-style configuration items\n\n    Configuration items should inherit from this class, implement\n    the execute method (and optionally the cancel one) and have\n    their view inherit from the related res_config_view_base view.\n    	t	\N	\N	f	f	f
90	\N	\N	res.config.installer	id	base	{"en_US": "Config Installer"}	 New-style configuration base specialized for addons selection\n    and installation.\n\n    Basic usage\n    -----------\n\n    Subclasses can simply define a number of boolean fields. The field names\n    should be the names of the addons to install (when selected). Upon action\n    execution, selected boolean fields (and those only) will be interpreted as\n    addons to install, and batch-installed.\n\n    Additional addons\n    -----------------\n\n    It is also possible to require the installation of an additional\n    addon set when a specific preset of addons has been marked for\n    installation (in the basic usage only, additionals can't depend on\n    one another).\n\n    These additionals are defined through the ``_install_if``\n    property. This property is a mapping of a collection of addons (by\n    name) to a collection of addons (by name) [#]_, and if all the *key*\n    addons are selected for installation, then the *value* ones will\n    be selected as well. For example::\n\n        _install_if = {\n            ('sale','crm'): ['sale_crm'],\n        }\n\n    This will install the ``sale_crm`` addon if and only if both the\n    ``sale`` and ``crm`` addons are selected for installation.\n\n    You can define as many additionals as you wish, and additionals\n    can overlap in key and value. For instance::\n\n        _install_if = {\n            ('sale','crm'): ['sale_crm'],\n            ('sale','project'): ['sale_service'],\n        }\n\n    will install both ``sale_crm`` and ``sale_service`` if all of\n    ``sale``, ``crm`` and ``project`` are selected for installation.\n\n    Hook methods\n    ------------\n\n    Subclasses might also need to express dependencies more complex\n    than that provided by additionals. In this case, it's possible to\n    define methods of the form ``_if_%(name)s`` where ``name`` is the\n    name of a boolean field. If the field is selected, then the\n    corresponding module will be marked for installation *and* the\n    hook method will be executed.\n\n    Hook methods take the usual set of parameters (cr, uid, ids,\n    context) and can return a collection of additional addons to\n    install (if they return anything, otherwise they should not return\n    anything, though returning any "falsy" value such as None or an\n    empty collection will have the same effect).\n\n    Complete control\n    ----------------\n\n    The last hook is to simply overload the ``modules_to_install``\n    method, which implements all the mechanisms above. This method\n    takes the usual set of parameters (cr, uid, ids, context) and\n    returns a ``set`` of addons to install (addons selected by the\n    above methods minus addons from the *basic* set which are already\n    installed) [#]_ so an overloader can simply manipulate the ``set``\n    returned by ``ResConfigInstaller.modules_to_install`` to add or\n    remove addons.\n\n    Skipping the installer\n    ----------------------\n\n    Unless it is removed from the view, installers have a *skip*\n    button which invokes ``action_skip`` (and the ``cancel`` hook from\n    ``res.config``). Hooks and additionals *are not run* when skipping\n    installation, even for already installed addons.\n\n    Again, setup your hooks accordingly.\n\n    .. [#] note that since a mapping key needs to be hashable, it's\n           possible to use a tuple or a frozenset, but not a list or a\n           regular set\n\n    .. [#] because the already-installed modules are only pruned at\n           the very end of ``modules_to_install``, additionals and\n           hooks depending on them *are guaranteed to execute*. Setup\n           your hooks accordingly.\n    	t	\N	\N	f	f	f
92	\N	\N	res.currency	active desc, name	base	{"en_US": "Currency"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
93	\N	\N	res.currency.rate	name desc	base	{"en_US": "Currency Rate"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
96	\N	\N	res.users.log	id desc	base	{"en_US": "Users Log"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
98	\N	\N	res.users.identitycheck	id	base	{"en_US": "Password Check Wizard"}	 Wizard used to re-check the user's credentials (password)\n\n    Might be useful before the more security-sensitive operations, users might be\n    leaving their computer unlocked & unattended. Re-checking credentials mitigates\n    some of the risk of a third party using such an unattended device to manipulate\n    the account.\n    	t	\N	\N	f	f	f
99	\N	\N	change.password.wizard	id	base	{"en_US": "Change Password Wizard"}	 A wizard to manage the change of users' passwords. 	t	\N	\N	f	f	f
100	\N	\N	change.password.user	id	base	{"en_US": "User, Change Password Wizard"}	 A model to configure users in the change password wizard. 	t	\N	\N	f	f	f
101	\N	\N	change.password.own	id	base	{"en_US": "User, change own password wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
102	\N	\N	res.users.apikeys	id	base	{"en_US": "Users API Keys"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
103	\N	\N	res.users.apikeys.description	id	base	{"en_US": "API Key Description"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
104	\N	\N	res.users.apikeys.show	id	base	{"en_US": "Show API Key"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
105	\N	\N	res.users.deletion	id	base	{"en_US": "Users Deletion Request"}	User deletion requests.\n\n    Those requests are logged in a different model to keep a trace of this action and the\n    deletion is done in a CRON. Indeed, removing a user can be a heavy operation on\n    large database (because of create_uid, write_uid on each model, which are not always\n    indexed). This model just remove the users added in the deletion queue, remaining code\n    must deal with other consideration (archiving, blacklist email...).\n    	f	\N	\N	f	f	f
106	\N	\N	decimal.precision	id	base	{"en_US": "Decimal Precision"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
107	\N	\N	report.base.report_irmodulereference	id	base	{"en_US": "Module Reference Report (base)"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
108	\N	\N	base.module.update	id	base	{"en_US": "Update Module"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
109	\N	\N	base.language.install	id	base	{"en_US": "Install Language"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
110	\N	\N	base.language.import	id	base	{"en_US": "Language Import"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
111	\N	\N	base.module.upgrade	id	base	{"en_US": "Upgrade Module"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
113	\N	\N	base.language.export	id	base	{"en_US": "Language Export"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
114	\N	\N	base.partner.merge.line	min_id asc	base	{"en_US": "Merge Partner Line"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
116	\N	\N	res.users.effective.permission	model_human_name	base	{"en_US": "Effective permissions"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
117	\N	\N	res.users.role	id	base	{"en_US": "User role"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
118	\N	\N	res.users.role.line	id	base	{"en_US": "Users associated to a role"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
119	\N	\N	wizard.create.role.from.user	id	base	{"en_US": "Create role from user wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
120	\N	\N	wizard.groups.into.role	id	base	{"en_US": "Group groups into a role"}	\n    This wizard is used to group different groups into a role.\n    	t	\N	\N	f	f	f
122	\N	\N	operating.unit	id	base	{"en_US": "Operating Unit"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
123	\N	\N	ir.actions.server.mass.edit.line	sequence, field_id	base	{"en_US": "Server Actions Mass Edit Lines"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
124	\N	\N	mass.editing.wizard	id	base	{"en_US": "Wizard for mass edition"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
125	\N	\N	thai.date.mixin	id	base	{"en_US": "Thai Date Format Utility Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
126	\N	\N	uom.category	id	base	{"en_US": "Product UoM Categories"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
127	\N	\N	uom.uom	factor DESC, id	base	{"en_US": "Product Unit of Measure"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
129	\N	\N	base.document.layout	id	base	{"en_US": "Company Document Layout"}	\n    Customise the company document layout and display a live preview\n    	t	\N	\N	f	f	f
131	\N	\N	mixin.parent.chart	sequence_path, parent_path	base	{"en_US": "树状结构基础mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
132	\N	\N	auth_totp.device	id	base	{"en_US": "Authentication Device"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
133	\N	\N	auth_totp.wizard	id	base	{"en_US": "2-Factor Setup Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
134	\N	\N	barcodes.barcode_events_mixin	id	base	{"en_US": "Barcode Event Mixin"}	 Mixin class for objects reacting when a barcode is scanned in their form views\n        which contains `<field name="_barcode_scanned" widget="barcode_handler"/>`.\n        Models using this mixin must implement the method on_barcode_scanned. It works\n        like an onchange and receives the scanned barcode in parameter.\n    	f	\N	\N	f	f	f
135	\N	\N	barcode.nomenclature	id	base	{"en_US": "Barcode Nomenclature"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
136	\N	\N	barcode.rule	sequence asc, id	base	{"en_US": "Barcode Rule"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
137	\N	\N	base_import.mapping	id	base	{"en_US": "Base Import Mapping"}	 mapping of previous column:field selections\n\n    This is useful when repeatedly importing from a third-party\n    system: column names generated by the external system may\n    not match Odoo's field names or labels. This model is used\n    to save the mapping between column names and fields so that\n    next time a user imports from the same third-party systems\n    we can automatically match the columns to the correct field\n    without them having to re-enter the mapping every single\n    time.\n    	f	\N	\N	f	f	f
138	\N	\N	base_import.import	id	base	{"en_US": "Base Import"}	\n    This model is used to prepare the loading of data coming from a user file.\n\n    Here is the process that is followed:\n\n    #. The user selects a file to import.\n    #. File parsing and mapping suggestion (see "parse_preview" method)\n\n       #. Extract the current model's importable fields tree (see :meth:`get_fields_tree`).\n       #. Read the file (see :meth:`_read_file`) and extract header names and file\n          length (used for batch import).\n       #. Extract headers types from the data preview (10 first line of the file)\n          (see :meth:`_extract_headers_types`).\n       #. Try to find for each header a field to map with (see :meth:`_get_mapping_suggestions`)\n\n          - First check the previously saved mappings between the header name\n            and one of the model's fields.\n          - If no mapping found, try an exact match comparison using fields\n            technical names, labels and user language translated labels.\n          - If nothing found, try a fuzzy match using word distance between\n            header name and fields tachnical names, labels and user language\n            translated labels. Keep only the closest match.\n\n       #. Prepare examples for each columns using the first non null value from each column.\n       #. Send the info back to the UI where the user can modify the suggested mapping.\n    #. Execute the import: There are two import mode with uses the same process. (see :meth:`execute_import`)\n\n       #. Test import: Try to import but rollback the transaction. This allows\n          the check errors during the import process and allow the user to\n          choose import options for the different encountered errors.\n       #. Real import: Try to import the file using the configured mapping and\n          the eventual "error mapping options". If import encounters blocking\n          errors, the transaction is rollbacked and the user is allowed to\n          choose import options for the different errors.\n\n          - Get file data and fields to import into (see :meth:`_convert_import_data`).\n          - Parse date, float and binary data (see :meth:`_parse_import_data`).\n          - Handle multiple mapping -> concatenate char/text/many2many columns\n            mapped on the same field (see :meth:`_handle_multi_mapping`).\n          - Handle fallback values for boolean and selection fields, in case\n            input data does not match any allowed values (see :meth:`_handle_fallback_values`).\n          - Load data (see ir.model "load" method).\n          - Rollback transaction if test mode or if encountered error.\n          - Save mapping if any import is successful to ease later mapping suggestions.\n          - Return import result to the UI (success or errors if any).\n    	t	\N	\N	f	f	f
139	\N	\N	base_import.tests.models.char	id	base	{"en_US": "Tests : Base Import Model, Character"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
140	\N	\N	base_import.tests.models.char.required	id	base	{"en_US": "Tests : Base Import Model, Character required"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
141	\N	\N	base_import.tests.models.char.readonly	id	base	{"en_US": "Tests : Base Import Model, Character readonly"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
142	\N	\N	base_import.tests.models.char.states	id	base	{"en_US": "Tests : Base Import Model, Character states"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
143	\N	\N	base_import.tests.models.char.noreadonly	id	base	{"en_US": "Tests : Base Import Model, Character No readonly"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
144	\N	\N	base_import.tests.models.char.stillreadonly	id	base	{"en_US": "Tests : Base Import Model, Character still readonly"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
145	\N	\N	base_import.tests.models.m2o	id	base	{"en_US": "Tests : Base Import Model, Many to One"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
168	\N	\N	utm.source.mixin	id	base	{"en_US": "UTM Source Mixin"}	Mixin responsible of generating the name of the source based on the content\n    (field defined by _rec_name) of the record (mailing, social post,...).\n    	f	\N	\N	f	f	f
169	\N	\N	utm.stage	sequence	base	{"en_US": "Campaign Stage"}	Stage for utm campaigns.	f	\N	\N	f	f	f
146	\N	\N	base_import.tests.models.m2o.related	id	base	{"en_US": "Tests : Base Import Model, Many to One related"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
147	\N	\N	base_import.tests.models.m2o.required	id	base	{"en_US": "Tests : Base Import Model, Many to One required"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
148	\N	\N	base_import.tests.models.m2o.required.related	id	base	{"en_US": "Tests : Base Import Model, Many to One required related"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
149	\N	\N	base_import.tests.models.o2m	id	base	{"en_US": "Tests : Base Import Model, One to Many"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
150	\N	\N	base_import.tests.models.o2m.child	id	base	{"en_US": "Tests : Base Import Model, One to Many child"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
151	\N	\N	base_import.tests.models.preview	id	base	{"en_US": "Tests : Base Import Model Preview"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
152	\N	\N	base_import.tests.models.float	id	base	{"en_US": "Tests: Base Import Model Float"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
153	\N	\N	base_import.tests.models.complex	id	base	{"en_US": "Tests: Base Import Model Complex"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
154	\N	\N	bus.bus	id	base	{"en_US": "Communication Bus"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
157	\N	\N	report.report_xlsx.abstract	id	base	{"en_US": "Abstract XLSX Report"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
158	\N	\N	report.report_xlsx.partner_xlsx	id	base	{"en_US": "Partner XLSX Report"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
159	\N	\N	resource.mixin	id	base	{"en_US": "Resource Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
160	\N	\N	resource.calendar	id	base	{"en_US": "Resource Working Time"}	 Calendar model for a resource. It has\n\n     - attendance_ids: list of resource.calendar.attendance that are a working\n                       interval in a given weekday.\n     - leave_ids: list of leaves linked to this calendar. A leave can be general\n                  or linked to a specific resource, depending on its resource_id.\n\n    All methods in this class use intervals. An interval is a tuple holding\n    (begin_datetime, end_datetime). A list of intervals is therefore a list of\n    tuples, holding several intervals of work or leaves. 	f	\N	\N	f	f	f
161	\N	\N	resource.calendar.attendance	week_type, dayofweek, hour_from	base	{"en_US": "Work Detail"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
162	\N	\N	resource.resource	name	base	{"en_US": "Resources"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
163	\N	\N	resource.calendar.leaves	date_from	base	{"en_US": "Resource Time Off Detail"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
164	\N	\N	utm.campaign	id	base	{"en_US": "UTM Campaign"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
165	\N	\N	utm.medium	name	base	{"en_US": "UTM Medium"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
166	\N	\N	utm.mixin	id	base	{"en_US": "UTM Mixin"}	 Mixin class for objects which can be tracked by marketing. 	f	\N	\N	f	f	f
167	\N	\N	utm.source	id	base	{"en_US": "UTM Source"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
171	\N	\N	web.environment.ribbon.backend	id	base	{"en_US": "Web Environment Ribbon Backend"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
172	\N	\N	web_tour.tour	id	base	{"en_US": "Tours"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
173	\N	\N	exception.rule.confirm	id	base	{"en_US": "Exception Rule Confirm Wizard"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
174	\N	\N	exception.rule	active desc, sequence asc	base	{"en_US": "Exception Rule"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
175	\N	\N	base.exception.method	id	base	{"en_US": "Exception Rule Methods"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
176	\N	\N	base.exception	main_exception_id asc	base	{"en_US": "Exception"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
177	\N	\N	iap.account	id	base	{"en_US": "IAP Account"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
178	\N	\N	iap.enrich.api	id	base	{"en_US": "IAP Lead Enrichment API"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
395	\N	\N	report.report_xlsx_helper.test_partner_xlsx	id	base	{"en_US": "Test Partner XLSX Report"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
397	\N	\N	web_editor.assets	id	base	{"en_US": "Assets Utils"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
398	\N	\N	web_editor.converter.test	id	base	{"en_US": "Web Editor Converter Test"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
399	\N	\N	web_editor.converter.test.sub	id	base	{"en_US": "Web Editor Converter Subtest"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
401	\N	\N	account.analytic.applicability	id	base	{"en_US": "Analytic Plan's Applicabilities"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
402	\N	\N	account.analytic.account	plan_id, name asc	base	{"en_US": "Analytic Account"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	t	f	f
403	\N	\N	account.analytic.line	date desc, id desc	base	{"en_US": "Analytic Line"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
404	\N	\N	analytic.mixin	id	base	{"en_US": "Analytic Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
405	\N	\N	account.analytic.distribution.model	id desc	base	{"en_US": "Analytic Distribution Model"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
406	\N	\N	base.module.install.request	id	base	{"en_US": "Module Activation Request"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
407	\N	\N	base.module.install.review	id	base	{"en_US": "Module Activation Review"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
408	\N	\N	base.substate.type	name asc, model asc	base	{"en_US": "Base Substate Type"}	This model defines technical data which precises\n    for each target model concerned by substate,\n    the technical "state" field name.\n    Data in this model should be created by import as technical data\n    in the specific module. For example in sale_substate we can define:\n    base.substate.type:\n     - name: Sale order Substate\n     - model: sale.order\n     - target_state_field: state\n    	f	\N	\N	f	f	f
409	\N	\N	target.state.value	name asc	base	{"en_US": "Target State Value"}	This model define technical data that precise the translatable name\n    of the target model state (ex:Quotation for 'draft' State)\n    Data in this model should be created by import as technical data\n    in specific module ex : sale_subsatate\n    	f	\N	\N	f	f	f
410	\N	\N	base.substate	active desc, sequence asc	base	{"en_US": "Base Substate"}	This model define substates that will be applied on the target model.\n    for each state we can define one or more substate.\n    ex:\n    for the quotation state of a sale order we can define\n    3 substates "In negotiation",\n    "Won" and "Lost".\n    We can also send mail when the susbstate is reached.\n    	f	\N	\N	f	f	f
411	\N	\N	base.substate.mixin	id	base	{"en_US": "BaseSubstate Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
412	\N	\N	tier.definition	id	base	{"en_US": "Tier Definition"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
413	\N	\N	tier.validation	id	base	{"en_US": "Tier Validation (abstract)"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
414	\N	\N	tier.validation.exception	id	base	{"en_US": "Tier Validation Exceptions"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
416	\N	\N	comment.wizard	id	base	{"en_US": "Comment Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
417	\N	\N	base.user.role.line.history	id desc	base	{"en_US": "History of user roles"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
418	\N	\N	calendar.attendee	create_date ASC	base	{"en_US": "Calendar Attendee Information"}	 Calendar Attendee Information 	f	\N	\N	f	f	f
419	\N	\N	calendar.recurrence	id	base	{"en_US": "Event Recurrence Rule"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
420	\N	\N	calendar.event	start desc	base	{"en_US": "Calendar Event"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	t	f	f
421	\N	\N	calendar.alarm	id	base	{"en_US": "Event Alarm"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
422	\N	\N	calendar.alarm_manager	id	base	{"en_US": "Event Alarm Manager"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
423	\N	\N	calendar.filters	id	base	{"en_US": "Calendar Filters"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
424	\N	\N	calendar.event.type	id	base	{"en_US": "Event Meeting Type"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
425	\N	\N	calendar.provider.config	id	base	{"en_US": "Calendar Provider Configuration Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
426	\N	\N	google.gmail.mixin	id	base	{"en_US": "Google Gmail Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
427	\N	\N	hr.contract.type	sequence	base	{"en_US": "Contract Type"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
428	\N	\N	hr.employee.base	name	base	{"en_US": "Basic Employee"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
429	\N	\N	hr.employee	name	base	{"en_US": "Employee"}	\n    NB: Any field only available on the model hr.employee (i.e. not on the\n    hr.employee.public model) should have `groups="hr.group_hr_user"` on its\n    definition to avoid being prefetched when the user hasn't access to the\n    hr.employee model. Indeed, the prefetch loads the data for all the fields\n    that are available according to the group defined on them.\n    	f	\N	\N	t	t	f
430	\N	\N	hr.employee.category	id	base	{"en_US": "Employee Category"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
431	\N	\N	hr.employee.public	name	base	{"en_US": "Public Employee"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
432	\N	\N	hr.department	name	base	{"en_US": "Department"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	t	f	f
433	\N	\N	hr.departure.reason	sequence	base	{"en_US": "Departure Reason"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
434	\N	\N	hr.job	sequence	base	{"en_US": "Job Position"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	t	f	f
435	\N	\N	hr.plan	id	base	{"en_US": "plan"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
436	\N	\N	hr.plan.activity.type	id	base	{"en_US": "Plan activity type"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
437	\N	\N	hr.work.location	name	base	{"en_US": "Work Location"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
438	\N	\N	hr.plan.wizard	id	base	{"en_US": "Plan Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
439	\N	\N	hr.departure.wizard	id	base	{"en_US": "Departure Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
440	\N	\N	mail.bot	id	base	{"en_US": "Mail Bot"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
441	\N	\N	phone.blacklist	id	base	{"en_US": "Phone Blacklist"}	 Blacklist of phone numbers. Used to avoid sending unwanted messages to people. 	f	\N	\N	t	f	f
442	\N	\N	mail.thread.phone	id	base	{"en_US": "Phone Blacklist Mixin"}	 Purpose of this mixin is to offer two services\n\n      * compute a sanitized phone number based on ´´_sms_get_number_fields´´.\n        It takes first sanitized value, trying each field returned by the\n        method (see ``MailThread._sms_get_number_fields()´´ for more details\n        about the usage of this method);\n      * compute blacklist state of records. It is based on phone.blacklist\n        model and give an easy-to-use field and API to manipulate blacklisted\n        records;\n\n    Main API methods\n\n      * ``_phone_set_blacklisted``: set recordset as blacklisted;\n      * ``_phone_reset_blacklisted``: reactivate recordset (even if not blacklisted\n        this method can be called safely);\n    	f	\N	\N	t	f	f
443	\N	\N	phone.blacklist.remove	id	base	{"en_US": "Remove phone from blacklist"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
444	\N	\N	privacy.log	id	base	{"en_US": "Privacy Log"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
445	\N	\N	privacy.lookup.wizard	id	base	{"en_US": "Privacy Lookup Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
446	\N	\N	privacy.lookup.wizard.line	id	base	{"en_US": "Privacy Lookup Wizard Line"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
447	\N	\N	product.template	priority desc, name	base	{"en_US": "Product"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	t	t	f
448	\N	\N	product.product	priority desc, default_code, name, id	base	{"en_US": "Product Variant"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	t	t	f
449	\N	\N	product.attribute	sequence, id	base	{"en_US": "Product Attribute"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
450	\N	\N	product.attribute.value	attribute_id, sequence, id	base	{"en_US": "Attribute Value"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
451	\N	\N	product.template.attribute.line	attribute_id, id	base	{"en_US": "Product Template Attribute Line"}	Attributes available on product.template with their selected values in a m2m.\n    Used as a configuration model to generate the appropriate product.template.attribute.value	f	\N	\N	f	f	f
452	\N	\N	product.template.attribute.value	attribute_line_id, product_attribute_value_id, id	base	{"en_US": "Product Template Attribute Value"}	Materialized relationship between attribute values\n    and product template generated by the product.template.attribute.line	f	\N	\N	f	f	f
453	\N	\N	product.template.attribute.exclusion	product_tmpl_id, id	base	{"en_US": "Product Template Attribute Exclusion"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
454	\N	\N	product.attribute.custom.value	custom_product_template_attribute_value_id, id	base	{"en_US": "Product Attribute Custom Value"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
455	\N	\N	product.category	complete_name	base	{"en_US": "Product Category"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
456	\N	\N	product.packaging	product_id, sequence, id	base	{"en_US": "Product Packaging"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
457	\N	\N	product.pricelist	sequence asc, id desc	base	{"en_US": "Pricelist"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
458	\N	\N	product.pricelist.item	applied_on, min_quantity desc, categ_id desc, id desc	base	{"en_US": "Pricelist Rule"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
459	\N	\N	product.supplierinfo	sequence, min_qty DESC, price, id	base	{"en_US": "Supplier Pricelist"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
460	\N	\N	product.tag	id	base	{"en_US": "Product Tag"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
461	\N	\N	report.product.report_producttemplatelabel	id	base	{"en_US": "Product Label Report"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
462	\N	\N	report.product.report_producttemplatelabel_dymo	id	base	{"en_US": "Product Label Report"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
463	\N	\N	report.product.report_pricelist	id	base	{"en_US": "Pricelist Report"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
464	\N	\N	product.label.layout	id	base	{"en_US": "Choose the sheet layout to print the labels"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
465	\N	\N	rating.rating	write_date desc, id desc	base	{"en_US": "Rating"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
466	\N	\N	rating.mixin	id	base	{"en_US": "Rating Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
467	\N	\N	rating.parent.mixin	id	base	{"en_US": "Rating Parent Mixin"}	\n    Updates the base class to support setting xids directly in create by\n    providing an "id" key (otherwise stripped by create) during an import\n    (which should strip 'id' from the input data anyway)\n    	f	\N	\N	f	f	f
468	\N	\N	crm.team.member	create_date ASC, id	base	{"en_US": "Sales Team Member"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	t	f	f
469	\N	\N	crm.team	sequence ASC, create_date DESC, id DESC	base	{"en_US": "Sales Team"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	t	f	f
470	\N	\N	crm.tag	id	base	{"en_US": "CRM Tag"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
471	\N	\N	spreadsheet.dashboard.group	sequence	base	{"en_US": "Group of dashboards"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
472	\N	\N	spreadsheet.dashboard	sequence	base	{"en_US": "Spreadsheet Dashboard"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
400	\N	\N	account.analytic.plan	complete_name asc	base	{"en_US": "Analytic Plans"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	t	f	f
415	\N	\N	tier.review	sequence	base	{"en_US": "Tier Review"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
475	\N	\N	tier.validation.forward.wizard	id	base	{"en_US": "Forward Wizard"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
\.


--
-- Data for Name: ir_model_access; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_access (id, model_id, group_id, create_uid, write_uid, name, active, perm_read, perm_write, perm_create, perm_unlink, create_date, write_date) FROM stdin;
1	106	4	1	1	decimal.precision configuration	t	t	t	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
2	28	1	1	1	ir_attachment group_user	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
3	28	\N	1	1	ir_attachment group_portal_public	t	f	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
4	30	4	1	1	ir_cron group_cron	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
5	31	4	1	1	ir_cron_trigger group_cron	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
6	34	8	1	1	ir_exports group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
7	35	1	1	1	ir_exports_line group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
8	3	2	1	1	ir_model group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
9	6	2	1	1	ir_model_constraint group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
10	7	2	1	1	ir_model_relation group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
11	8	2	1	1	ir_model_access_group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
12	9	2	1	1	ir_model_data group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
13	4	2	1	1	ir_model_fields group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
14	5	2	1	1	ir_model_fields_selection group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
15	3	1	1	1	ir_model_all	t	f	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
16	9	1	1	1	ir_model_data user	t	f	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
17	4	1	1	1	ir_model_fields all	t	f	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
18	5	1	1	1	ir_model_fields_selection all	t	f	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
20	66	4	1	1	ir_module_module group_user	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
21	67	4	1	1	ir_module_module_dependency group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
22	68	4	1	1	ir_module_module_exclusion group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
23	64	\N	1	1	ir_property group_user	t	f	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
24	64	4	1	1	ir_property group_system	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
25	36	2	1	1	ir_rule group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
26	11	1	1	1	ir_sequence group_user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
27	11	4	1	1	ir_sequence group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
28	12	1	1	1	ir_sequence_date_range group_user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
29	12	4	1	1	ir_sequence_date_range group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
30	13	1	1	1	ir_ui_menu group_user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
31	13	4	1	1	ir_ui_menu group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
32	15	\N	1	1	ir_ui_view group_user	t	f	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
33	15	4	1	1	ir_ui_view group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
34	16	4	1	1	reset_view_arch_wizard group_system	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
35	14	\N	1	1	ir_ui_view_custom_group_user	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
36	33	\N	1	1	ir_default all	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
37	33	1	1	1	ir_default group_user	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
38	33	4	1	1	ir_default group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
39	94	2	1	1	res_company group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
40	94	\N	1	1	res_company group_user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
41	78	\N	1	1	res_country group_user_all	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
42	80	\N	1	1	res_country_state group_user_all	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
43	79	\N	1	1	res_country_group group_user_all	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
44	78	9	1	1	res_country group_user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
45	78	4	1	1	res_country_group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
46	80	9	1	1	res_country_state group_user	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
47	79	9	1	1	res_country_group group_user	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
48	92	\N	1	1	res_currency group_all	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
49	93	\N	1	1	res_currency_rate group_all	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
50	92	4	1	1	res_currency group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
51	93	4	1	1	res_currency_rate group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
52	95	2	1	1	res_groups group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
53	95	1	1	1	res_groups group_user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
54	81	\N	1	1	res_lang group_all	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
55	81	4	1	1	res_lang group_user	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
56	85	11	1	1	res_partner group_public	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
57	85	10	1	1	res_partner group_portal	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
58	85	9	1	1	res_partner group_partner_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
59	85	1	1	1	res_partner group_user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
60	88	1	1	1	res_partner_bank group_user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
61	88	9	1	1	res_partner_bank group_partner_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
62	83	1	1	1	res_partner_category group_user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
63	83	9	1	1	res_partner_category group_partner_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
64	86	1	1	1	res_partner_industry group_user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
65	86	4	1	1	res_partner_industry group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
66	84	9	1	1	res_partner_title group_partner_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
67	84	\N	1	1	res_partner_title group_user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
68	97	\N	1	1	res_users all	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
69	97	2	1	1	res_users group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
70	105	\N	1	1	res_users_deletion all	t	f	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
71	105	2	1	1	res_users_deletion group_erp_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
72	96	\N	1	1	res_users_log_all	t	t	f	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
73	98	1	1	1	id check employees	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
74	98	10	1	1	id check portal	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
75	102	1	1	1	API keys access employees	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
76	102	10	1	1	API keys access portal	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
77	103	1	1	1	API key wizard employees	t	t	f	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
78	103	10	1	1	API key wizard	t	t	f	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
79	104	1	1	1	API key result employees	t	t	f	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
80	17	4	1	1	ir_asset_group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
81	18	4	1	1	ir_actions_group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
82	19	4	1	1	ir_actions_act_window_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
83	21	4	1	1	ir_actions_act_window_close_group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
84	27	4	1	1	ir_actions_report_group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
85	25	4	1	1	ir_actions_todo group system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
86	20	4	1	1	ir_actions_act_window_view_group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
87	22	4	1	1	ir_actions_act_url_group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
88	24	4	1	1	ir_server_object_lines_group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
89	23	4	1	1	ir_actions_server_group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
90	26	4	1	1	ir_actions_client all	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
91	87	4	1	1	res_bank_group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
92	87	9	1	1	res_bank_group_partner_manager	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
93	87	1	1	1	res_bank user	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
94	32	2	1	1	ir_filters all	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
95	32	1	1	1	ir_filters all	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
96	32	10	1	1	ir_filters all	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
97	32	11	1	1	ir_filters all	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
98	37	4	1	1	ir_config_parameter_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
99	39	4	1	1	ir_mail_server	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
100	63	2	1	1	ir_logging admin	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
101	73	\N	1	1	ir_actions_report_paperformat group_portal	t	t	f	f	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
102	73	4	1	1	ir_actions_report_paperformat group_system	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
103	72	\N	1	1	access_report_layout	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
104	10	4	1	1	access.wizard.ir.model.menu.create	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
105	16	2	1	1	access.reset.view.arch.wizard	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
106	69	4	1	1	access.ir.demo	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
107	70	4	1	1	access.ir.demo_failure	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
108	71	4	1	1	access.ir.demo_failure.wizard	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
109	89	4	1	1	access.res.config	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
110	90	4	1	1	access.res.config.installer	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
111	91	4	1	1	access.res.config.settings	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
112	99	2	1	1	access.change.password.wizard	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
113	100	2	1	1	access.change.password.user	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
114	101	1	1	1	access.change.password.own	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
115	108	4	1	1	access.base.module.update	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
116	109	4	1	1	access.base.language.install	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
117	110	4	1	1	access.base.language.import	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
118	111	4	1	1	access.base.module.upgrade	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
119	112	4	1	1	access.base.module.uninstall	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
120	113	1	1	1	access.base.language.export	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
121	114	9	1	1	access.base.partner.merge.line	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
122	115	9	1	1	access.base.partner.merge.automatic.wizard	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
123	74	4	1	1	ir_profile	t	t	t	t	t	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
124	75	4	1	1	access.base.enable.profiling.wizard	t	t	t	t	f	2026-02-06 07:56:25.611196	2026-02-06 07:56:25.611196
125	116	1	1	1	access_res_users_effective_permission	t	t	f	t	f	2026-02-06 07:56:40.677611	2026-02-06 07:56:40.677611
126	117	2	1	1	access_res_users_role	t	t	t	t	t	2026-02-06 07:56:44.287826	2026-02-06 07:56:44.287826
127	118	2	1	1	access_res_users_role_line	t	t	t	t	t	2026-02-06 07:56:44.287826	2026-02-06 07:56:44.287826
128	119	2	1	1	access_wizard_create_role_from_user	t	t	t	t	t	2026-02-06 07:56:44.287826	2026-02-06 07:56:44.287826
129	120	\N	1	1	access_wizard_groups_into_role	t	t	t	t	t	2026-02-06 07:56:44.287826	2026-02-06 07:56:44.287826
130	122	14	1	1	operating.unit erp.manager	t	t	t	t	t	2026-02-06 07:56:45.048035	2026-02-06 07:56:45.048035
131	122	\N	1	1	operating_unit user	t	t	f	f	f	2026-02-06 07:56:45.048035	2026-02-06 07:56:45.048035
132	123	4	1	1	ir.actions.server.mass.edit.line manager	t	t	t	t	t	2026-02-06 07:56:45.585499	2026-02-06 07:56:45.585499
133	124	1	1	1	mass.editing.wizard user	t	t	t	t	t	2026-02-06 07:56:45.585499	2026-02-06 07:56:45.585499
134	126	4	1	1	uom.category.manager	t	t	t	t	t	2026-02-06 07:56:45.815046	2026-02-06 07:56:45.815046
135	126	1	1	1	uom.category.user	t	t	f	f	f	2026-02-06 07:56:45.815046	2026-02-06 07:56:45.815046
136	127	4	1	1	uom.uom.manager	t	t	t	t	t	2026-02-06 07:56:45.815046	2026-02-06 07:56:45.815046
137	127	1	1	1	uom.uom.user	t	t	f	f	f	2026-02-06 07:56:45.815046	2026-02-06 07:56:45.815046
